<?php
// 'pxl-splitting',
// 'pxl-typography-animation',
pxl_add_custom_widget(
    array(
        'name' => 'pxl_heading',
        'title' => esc_html__('Case Heading', 'floka' ),
        'icon' => 'eicon-heading',
        'categories' => array('pxltheme-core'),
        'scripts'    => array(
            'gsap',
            'pxl-scroll-trigger',
            'pxl-splitText',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'source_type',
                            'label' => esc_html__('Source Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'text' => 'Text',
                                'title' => 'Page Title',
                            ],
                            'default' => 'text',
                        ),
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'label_block' => true,
                            'condition' => [
                                'source_type' => ['text'],
                            ],
                            'description' => 'Create Typewriter text width shortcode: [typewriter text="Text1, Text2"], Highlight text with shortcode: [highlight text="Text"] and Highlight image with shortcode: [highlight_image id_image="123"]',
                        ),
                        array(
                            'name' => 'sub_title',
                            'label' => esc_html__('Sub Title', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                        ),
                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'floka' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'floka' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'floka' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                            'justify' => [
                                'title' => esc_html__( 'Justified', 'floka' ),
                                'icon' => 'eicon-text-align-justify',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-heading' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'h_width',
                            'label' => esc_html__('Max Width', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-heading .pxl-heading--inner' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
),
array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_tag',
            'label' => esc_html__('HTML Tag', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'h1' => 'H1',
                'h2' => 'H2',
                'h3' => 'H3',
                'h4' => 'H4',
                'h5' => 'H5',
                'h6' => 'H6',
                'div' => 'div',
                'span' => 'span',
                'p' => 'p',
            ],
            'default' => 'h2',
        ),
        array(
            'name' => 'title_style_color',
            'label' => esc_html__('Style Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Default',
                'text-gradient' => 'Gradient',
                'text-gradient-2' => 'Gradient 2',
                'text-image' => 'Image',
                'mix-blend-mode' => 'Mix Blend Mode',
            ],
            'default' => '',
        ),

        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-heading .pxl-heading--text' => 'color: {{VALUE}};',
            ],
            'condition' => [
                'title_style_color' => ['','mix-blend-mode'],
            ],
        ),

        array(
            'name' => 'title_color_gr',
            'type'         => \Elementor\Group_Control_Background::get_type(), 
            'control_type' => 'group', 
            'types' => [ 'gradient' ],
            'selector' => '{{WRAPPER}} .pxl-heading .pxl-heading--text',
            'condition' => [
                'title_style_color'  => ['text-gradient'],
            ],
        ),

        array(
            'name' => 'title_color_gr2',
            'type'         => \Elementor\Group_Control_Background::get_type(), 
            'control_type' => 'group', 
            'types' => [ 'gradient' ],
            'selector' => '{{WRAPPER}} .pxl-heading .pxl-item--title',
            'condition' => [
                'title_style_color'  => ['text-gradient-2'],
            ],
        ),

        array(
            'name' => 'title_color_image',
            'type'         => \Elementor\Group_Control_Background::get_type(), 
            'control_type' => 'group', 
            'types' => [ 'classic' ],
            'selector' => '{{WRAPPER}} .pxl-heading .pxl-heading--text',
            'condition' => [
                'title_style_color'  => 'text-image',
            ],
        ),


        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-heading .pxl-item--title',
        ),


        array(
            'name' => 'title_underline_color',
            'label' => esc_html__('Underline Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-heading .pxl-item--title' => 'text-decoration-color: {{VALUE}};',
            ],
            'description'   => esc_html__( 'Applied when the text has decorative underlining. Controls the color of the underline.', 'floka' ),
        ),

        array(
            'name'         => 'title_box_shadow',
            'label' => esc_html__( 'Title Shadow', 'floka' ),
            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-heading .pxl-item--title'
        ),
        array(
            'name' => 'title_space_top',
            'label' => esc_html__('Top Spacer', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-heading .pxl-item--title' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
            'separator' => 'after',
        ),

        array(
            'name' => 'title_space_bottom',
            'label' => esc_html__('Bottom Spacer', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'default' => [
                'size' => 0,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-heading .pxl-item--title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
            'separator' => 'after',
        ),

        array(
            'name' => 'h_title_style',
            'label' => esc_html__('Style', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style-default' => 'Default',
                'style-outline' => 'Outline',
            ],
            'default' => 'style-default',
        ),
        array(
            'name'         => 'h_title_style_outline',
            'label' => esc_html__( 'Text Stroke', 'floka' ),
            'type'         => \Elementor\Group_Control_Text_Stroke::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-heading .pxl-item--title',
            'condition' => [
             'h_title_style'  =>  'style-outline',
         ],
     ),

        array(
            'name' => 'h_title_style_fill',
            'label' => esc_html__('Text Fill', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-heading .pxl-heading--text' => '-webkit-text-fill-color: {{VALUE}};',
            ],
            'condition' => [
                'h_title_style' => 'style-outline',
            ],
        ),
        array(
            'name' => 'pxl_animate',
            'label' => esc_html__('Case Animate', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => floka_widget_animate_v2(),
            'default' => '',
        ),
        array(
            'name' => 'pxl_animate_delay',
            'label' => esc_html__('Animate Delay', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => '0',
            'description' => 'Enter number. Default 0ms',
        ),
    ),
),
array(
    'name' => 'section_style_title_sub',
    'label' => esc_html__('Sub Title', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(

            array(
                'name' => 'sub_title_style_color',
                'label' => esc_html__('Style Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Default',
                    'sub_title_color_gradient' => 'Gradient',
                ],
                'default' => '',
            ),

            array(
                'name' => 'sub_title_color',
                'label' => esc_html__('Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-item--subtitle .pxl-item--subtext' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .pxl-heading .pxl-item--subtitle svg path' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'sub_title_style_color' => '',
                ],
            ),

            array(
                'name' => 'sub_title_color_gr',
                'type'         => \Elementor\Group_Control_Background::get_type(), 
                'control_type' => 'group', 
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .pxl-heading .pxl-item--subtitle .pxl-item--subtext',
                'condition' => [
                    'sub_title_style_color'  => 'sub_title_color_gradient',
                ],
            ),

            array(
                'name' => 'sub_title_bg_color',
                'label' => esc_html__('Background Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-item--subtitle' => 'background-color: {{VALUE}};',
                ],
            ),
            
            array(
                'name' => 'sub_title_typography',
                'label' => esc_html__('Typography', 'floka' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-heading .pxl-item--subtitle, {{WRAPPER}} .pxl-heading .pxl-item--subtitle span',
            ),
            array(
                'name' => 'sub_title_space_bottom',
                'label' => esc_html__('Bottom Spacer', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-item--subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ),

            array(
                'name'         => 'sub_tt__border_type',
                'label' => esc_html__( 'Border Type', 'floka' ),
                'type'         => \Elementor\Group_Control_Border::get_type(),
                'control_type' => 'group',
                'selector'     => '{{WRAPPER}} .pxl-heading .pxl-item--subtitle',
            ),
            array(
                'name' => 'sub_tt_border_radius',
                'label' => esc_html__('Border Radius', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'control_type' => 'responsive',
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-item--subtitle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ),
            array(
                'name' => 'sub_tt_padding',
                'label' => esc_html__('Padding', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'control_type' => 'responsive',
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-item--subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ),

            array(
                'name' => 'pxl_animate_sub',
                'label' => esc_html__('Case Animate', 'floka' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => floka_widget_animate(),
                'default' => '',
            ),
            array(
                'name' => 'pxl_animate_delay_sub',
                'label' => esc_html__('Animate Delay', 'floka' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '0',
                'description' => 'Enter number. Default 0ms',
            ),
        )
),
),
array(
    'name' => 'section_style_highlight',
    'label' => esc_html__('Highlight Text', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(
            array(
                'name' => 'highlight_style',
                'label' => esc_html__('Style', 'floka' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'highlight-default' => 'Default',
                    'highlight-text-gradient' => 'Text Gradient',
                ],
                'default' => 'highlight-default',
            ),
            array(
                'name' => 'highlight_color',
                'label' => esc_html__('Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-title--highlight' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'highlight_style' => ['highlight-default'],
                ],
            ),
            
            array(
                'name' => 'highlight_color_text',
                'type'         => \Elementor\Group_Control_Background::get_type(), 
                'control_type' => 'group', 
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .pxl-heading .pxl-title--highlight',
                'condition' => [
                    'highlight_style' => ['highlight-text-gradient'],
                ],
            ),

            array(
                'name' => 'highlight_typography',
                'label' => esc_html__('Typography', 'floka' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-heading .pxl-title--highlight',
            ),
            array(
                'name' => 'highlight_text_image',
                'label' => esc_html__( 'Text Image', 'floka' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-title--highlight' => 'background-image: url( {{URL}} );',
                ],  
            ),
            array(
                'name' => 'highlight_image_position',
                'label' => esc_html__( 'Text Image Position', 'floka' ),
                'type'         => \Elementor\Controls_Manager::SELECT,
                'options'      => array(
                    ''              => esc_html__( 'Default', 'floka' ),
                    'center center' => esc_html__( 'Center Center', 'floka' ),
                    'center left'   => esc_html__( 'Center Left', 'floka' ),
                    'center right'  => esc_html__( 'Center Right', 'floka' ),
                    'top center'    => esc_html__( 'Top Center', 'floka' ),
                    'top left'      => esc_html__( 'Top Left', 'floka' ),
                    'top right'     => esc_html__( 'Top Right', 'floka' ),
                    'bottom center' => esc_html__( 'Bottom Center', 'floka' ),
                    'bottom left'   => esc_html__( 'Bottom Left', 'floka' ),
                    'bottom right'  => esc_html__( 'Bottom Right', 'floka' ),
                    'initial'       =>  esc_html__( 'Custom', 'floka' ),
                ),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-title--highlight' => 'background-position: {{VALUE}};',
                ],
                'condition' => [
                    'highlight_text_image[url]!' => ''
                ]        
            ),
            array(
                'name' => 'highlight_image_size',
                'label' => esc_html__( 'Text Image Size', 'floka' ),
                'type'         => \Elementor\Controls_Manager::SELECT,
                'hide_in_inner' => true,
                'options'      => array(
                    ''              => esc_html__( 'Default', 'floka' ),
                    'auto' => esc_html__( 'Auto', 'floka' ),
                    'cover'   => esc_html__( 'Cover', 'floka' ),
                    'contain'  => esc_html__( 'Contain', 'floka' ),
                    'initial'    => esc_html__( 'Custom', 'floka' ),
                ),
                'default'      => '',
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-title--highlight' => 'background-size: {{VALUE}};',
                ],
                'condition' => [
                    'highlight_text_image[url]!' => ''
                ]        
            ),
            array(
                'name' => 'highlight_margin',
                'label' => esc_html__('Margin', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-title--highlight' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),
        )
),
),

array(
    'name' => 'section_style_highlight_img',
    'label' => esc_html__('Highlight Image', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(
            array(
                'name' => 'h_img_width',
                'label' => esc_html__('Width', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-image--highlight img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'after',
            ),
            array(
                'name' => 'h_img_height',
                'label' => esc_html__('Height', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-image--highlight img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'after',
            ),

            array(
                'name'         => 'h_img_border_type',
                'label' => esc_html__( 'Border Type', 'floka' ),
                'type'         => \Elementor\Group_Control_Border::get_type(),
                'control_type' => 'group',
                'selector'     => '{{WRAPPER}} .pxl-heading .pxl-image--highlight img',
            ),

            array(
                'name' => 'h_img_border_radius',
                'label' => esc_html__('Border Radius', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px','custom' ],
                'control_type' => 'responsive',
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-image--highlight img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ),

            array(
                'name' => 'h_img_space_left',
                'label' => esc_html__('Left Spacer', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-image--highlight' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ),
            array(
                'name' => 'h_img_transform_y',
                'label' => esc_html__('Position Y', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px','custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-image--highlight img' => 'transform: translateY({{SIZE}}{{UNIT}});',
                ],
                'separator' => 'after',
            ),
        )
    ),
),

array(
    'name' => 'section_style_typewriter',
    'label' => esc_html__('Typewriter', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(
            array(
                'name' => 'typewriter_color',
                'label' => esc_html__('Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-heading .pxl-title--typewriter' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'typewriter_typography',
                'label' => esc_html__('Typography', 'floka' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-heading .pxl-title--typewriter',
            ),
        )
    ),
),
),
),
),
floka_get_class_widget_path()
);