<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_icon',
        'title' => esc_html__('Case Icons', 'floka'),
        'icon' => 'eicon-alert',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'icons',
                            'label' => esc_html__('Icons', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'icon_link',
                                    'label' => esc_html__('Link', 'floka'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'label',
                                    'label' => esc_html__('Label', 'floka'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'type_icon',
                                    'label' => esc_html__('Type Icon', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        '' => 'Normal',
                                        'btn-copy-link' => 'Copy Link',
                                    ],
                                    'default' => '',
                                ),
                                array(
                                    'name' => 'color_item',
                                    'label' => esc_html__( 'Color', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'default' => '',
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-icon1 {{CURRENT_ITEM}}' => 'color: {{VALUE}};',
                                        '{{WRAPPER}} .pxl-icon1 {{CURRENT_ITEM}} svg path' => 'fill: {{VALUE}};',
                                    ],
                                ),

                                array(
                                    'name' => 'bgcolor_item',
                                    'label' => esc_html__( 'Background Color', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'default' => '',
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-icon1 {{CURRENT_ITEM}}' => 'background: {{VALUE}};',
                                    ],
                                ),

                                array(
                                    'name' => 'z_index',
                                    'label' => esc_html__('z-index', 'floka'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-icon1 {{CURRENT_ITEM}}' => 'z-index: {{VALUE}};',
                                    ],
                                ),
                                
                            ),
                            'title_field' => '{{{ label }}}',
                        ),
                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'floka' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'floka' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'floka' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-icon1' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                            '{{WRAPPER}} .pxl-icon1 a' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'icon_arrange',
                            'label' => esc_html__( 'Arrange', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'icon-horizontal' => esc_html__( 'Horizontal', 'floka' ),
                                'icon-vertical' => esc_html__( 'Vertical', 'floka' ),
                            ],
                            'default' => 'icon-horizontal'
                        ),
                    ),
),

array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'style',
            'label' => esc_html__('Style', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Default',
                'style-1' => 'Style 1',
            ],
            'default' => '',
        ),
        array(
            'name'         => 'border_type_general',
            'label' => esc_html__('Border Type', 'floka' ),
            'type'         => \Elementor\Group_Control_Border::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-icon-list',
        ),
        array(
            'name' => 'border_radius_general',
            'label' => esc_html__('Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
         array(
            'name'         => 'box_shadow_general',
            'label' => esc_html__('Box Shadow', 'floka' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-icon-list',
        ),

        array(
            'name'  => 'heading_icon',
            'label' => esc_html__('ICONS','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-icon1 a svg path' => 'fill: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'color_hover',
            'label' => esc_html__( 'Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'icon_font_size',
            'label' => esc_html__('Font Size', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'font-size: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-icon1 svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
            ],
        ),

        array(
            'name'  => 'heading_label',
            'label' => esc_html__('LABEL','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),

        array(
            'name' => 'color_label',
            'label' => esc_html__( 'Color Label', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a span' => 'color: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'color_label_hv',
            'label' => esc_html__( 'Color Label Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover span' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name'         => 'typography_label',
            'label' => esc_html__( 'Typography Label', 'floka' ),
            'type'         => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-icon1 a span',
        ),
        
        array(
            'name'  => 'heading_box',
            'label' => esc_html__('BOX','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),

        array(
            'name' => 'box_color',
            'label' => esc_html__( 'Box Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a, {{WRAPPER}} .pxl-icon1 a:before' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'box_color_hover',
            'label' => esc_html__( 'Box Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'box_width',
            'label' => esc_html__('Box Width', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type'  => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'width: {{SIZE}}{{UNIT}};min-width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'box_height',
            'label' => esc_html__('Box Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type'  => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),

        array(
            'name'         => 'icon_border_type',
            'label' => esc_html__( 'Border Type', 'floka' ),
            'type'         => \Elementor\Group_Control_Border::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-icon1 a',
        ),

        array(
            'name' => 'border_color_hover',
            'label' => esc_html__( 'Border Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'border-color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name'         => 'icon_box_shadow',
            'label' => esc_html__( 'Box Shadow', 'floka' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-icon1 a',
        ),
        array(
            'name' => 'icon_border_radius',
            'label' => esc_html__('Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),


        array(
            'name'  => 'heading_extend',
            'label' => esc_html__('EXTEND','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'space_content',
            'label' => esc_html__('Space Content', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'gap: {{SIZE}}{{UNIT}};',
            ],
        ),

        array(
            'name' => 'space_item',
            'label' => esc_html__('Space Item', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1' => 'gap: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'icon_arrange'  => 'icon-horizontal',

            ],
        ),
        array(
            'name' => 'space_item_vtc',
            'label' => esc_html__('Space Item', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list a' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'icon_arrange'  => 'icon-vertical',

            ],
        ),


        array(
            'name' => 'icon_margin',
            'label' => esc_html__('Margin', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                '{{WRAPPER}} .pxl-icon1' => 'margin-left: -{{LEFT}}{{UNIT}};margin-right: -{{RIGHT}}{{UNIT}};',
            ],
            'control_type' => 'responsive',
        ),
        array(
            'name' => 'img_effect',
            'label' => esc_html__('Icon Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'None',
                'pxl-image-effect1' => 'Zigzag',
                'pxl-phone-ring' => 'Phone Ring',
                'pxl-image-tilt' => 'Tilt',
                'pxl-image-spin' => 'Spin',
                'pxl-image-zoom' => 'Zoom 1',
                'pxl-image-zoom2' => 'Zoom 2',
                'pxl-image-bounce' => 'Bounce',
                'slide-up-down' => 'Slide Up Down',
                'slide-top-to-bottom' => 'Slide Top To Bottom ',
                'pxl-image-effect2' => 'Slide Bottom To Top ',
                'slide-right-to-left' => 'Slide Right To Left ',
                'slide-left-to-right' => 'Slide Left To Right ',
                'pxl-hover1' => 'ZoomIn',
                'pxl-hover2' => 'ZoomOut',
                'pxl-animation-round' => 'Round',
                'pxl-image-parallax' => 'Parallax Hover',
                'pxl-parallax-scroll' => 'Parallax Scroll',
            ],
            'default' => '',
        ),
        array(
            'name' => 'parallax_scroll_type',
            'label' => esc_html__('Parallax Scroll Type', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'y' => 'Effect Y',
                'x' => 'Effect X',
                'z' => 'Effect Z',
            ],
            'default' => 'y',
            'condition' => [
                'img_effect' => 'pxl-parallax-scroll',
            ],
        ),
        array(
            'name' => 'parallax_scroll_value_x',
            'label' => esc_html__('Parallax Value', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-parallax-scroll',
            ],
            'default' => '80',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'parallax_value',
            'label' => esc_html__('Parallax Value', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-parallax',
            ],
            'default' => '40',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
    ),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);