<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_join_team',
        'title' => esc_html__('Case Join Team', 'floka'),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_join_team/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('Content', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'floka'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name'  => 'working_type',
                                    'label' => esc_html__('Wordking Type', 'floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                ),


                                array(
                                    'name'  => 'status',
                                    'label' => esc_html__('Status', 'floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                    'default'   => esc_html__('Apply Now','floka'),
                                ),
                                
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'default' => [
                                        'url' => '#',
                                    ],
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name'  => 'items_padding',
                            'label' => esc_html__('Padding Items','floka'),
                            'type'  => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type'  => 'responsive',
                            'size_units'    => ['px'],
                            'range' => [
                                'px'=> [
                                    'min'   => 0,
                                    'max'   => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl--item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name'  => 'items_margin',
                            'label' => esc_html__('Margin Items','floka'),
                            'type'  => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type'  => 'responsive',
                            'size_units'    => ['px'],
                            'range' => [
                                'px'=> [
                                    'min'   => 0,
                                    'max'   => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl--item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name' => 'border_color',
                            'label' => esc_html__('Border Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl--item' => 'border-color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'background_color',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl--item' => 'background: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'background_color_hv',
                            'label' => esc_html__('Background Color Hover', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl--item.active' => 'background: {{VALUE}};',
                            ],
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(

                        array(
                            'name'  => 'heading_title',
                            'label' => esc_html__('TITLE','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                        ),

                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl-item-title,{{WRAPPER}} .pxl-join--team .pxl--title' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-join--team .pxl-item-title',
                        ),

                        array(
                            'name'  => 'heading_reward',
                            'label' => esc_html__('REWARDS','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                        ),

                        array(
                            'name' => 'reward_color',
                            'label' => esc_html__('Rewards Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl-item-reward' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'reward_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-join--team .pxl-item-reward',
                        ),

                        array(
                            'name'  => 'heading_date',
                            'label' => esc_html__('DATE','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                        ),

                        array(
                            'name' => 'date_color',
                            'label' => esc_html__('Date Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-join--team .pxl-item--date' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'date_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-join--team .pxl-item--date',
                        ),

                    ),
                ),

                floka_widget_animation_settings(),
            ),
),
),
floka_get_class_widget_path()
);