<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_list',
        'title' => esc_html__('Case List', 'floka'),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('List', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'label',
                                    'label' => esc_html__('Label', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'rows' => 10,
                                    'show_label' => false,
                                ),
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                    'show_label' => false,
                                    'description' => 'Create Typewriter text width shortcode: [typewriter text="Text1, Text2"], Highlight text with shortcode: [highlight text="Text"] and Highlight image with shortcode: [highlight_image id_image="123"]',
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ content }}}',
                        ),

                        array(
                            'name' => 'display_type',
                            'label' => esc_html__('Display Item', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => 'Vertical',
                                'horizontal' => 'Horizontal',
                            ],
                            'default' => '',
                        ),
                        array(
                            'name' => 'display_type_gap',
                            'label' => esc_html__('Gap', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px','custom'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list' => 'gap: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'display_type'  => 'horizontal',
                            ],
                        ),

                        array(
                            'name' => 'icon_type',
                            'label' => esc_html__('Icon Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'icon' => 'Icon',
                                'image' => 'Image',
                            ],
                            'default' => 'icon',
                        ),
                        
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'icon_type' => 'icon',
                            ],
                        ),
                        array(
                            'name' => 'icon_image',
                            'label' => esc_html__( 'Icon Image', 'floka' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'icon_type' => 'image',
                            ],
                        ),

                        array(
                            'name' => 'icon_position',
                            'label' => esc_html__('Icon Position', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => 'Before',
                                'icon-after' => 'After',
                            ],
                            'default' => '',
                            'condition' => [
                                'icon_type' => 'icon',
                            ],
                        ),

                        array(
                            'name' => 'flex_box',
                            'label' => esc_html__('Flex Box', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'start' => esc_html__('Start','floka'),
                                'center' => esc_html__('Center','floka'),
                                'end' => esc_html__('End','floka'),
                                'space-around' => esc_html__('Space Around','floka'),
                                'space-between' => esc_html__('Space Between','floka'),
                                'space-evenly' => esc_html__('Space Evenly','floka'),
                            ],
                            'default' => 'start',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl--item'  => 'justify-content:{{VALUE}};'
                            ],
                        ),
                        array(
                            'name' => 'flex_grow',
                            'label' => esc_html__('Flex Grow', 'floka' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'options' => [
                                'inherit' => [
                                    'title' => esc_html__( 'Inherit', 'floka' ),
                                    'icon' => 'fas fa-arrows-alt-v',
                                ],
                                '1' => [
                                    'title' => esc_html__( 'Full', 'floka' ),
                                    'icon' => 'fas fa-arrows-alt-h',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}' => 'flex-grow: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'flex_wrap',
                            'label' => esc_html__( 'Flex Wrap', 'floka' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'nowrap' => [
                                    'title' => esc_html__( 'No Wrap', 'floka' ),
                                    'icon' => 'eicon-nowrap',
                                ],
                                'wrap' => [
                                    'title' => esc_html__( 'Wrap', 'floka' ),
                                    'icon' => 'eicon-wrap',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list' => 'flex-wrap: {{VALUE}};',
                            ],
                            'condition' => [
                                'display_type'  => 'horizontal',
                            ],
                        ),
                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'floka' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'floka' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'floka' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                            'justify' => [
                                'title' => esc_html__( 'Justified', 'floka' ),
                                'icon' => 'eicon-text-align-justify',
                            ],
                            'space-between' => [
                                'title' => esc_html__( 'Space Between', 'floka' ),
                                'icon' => 'eicon-justify-space-between-h',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-list,{{WRAPPER}} .pxl-list .pxl-item--content' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                        ],
                    ),
                    ),
),
array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        floka_widget_color_type([
            'label' => 'Icon',
            'prefix' => 'icon',
            'selectors_class' => '.pxl-list1 .pxl-item--icon',
        ]),
        array(
            array(
                'name' => 'icon_margin',
                'label' => esc_html__('Icon Margin', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),
            array(
                'name' => 'icon_font_size',
                'label' => esc_html__('Icon Font Size', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-item--icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ),

            array(
                'name' => 'image_size',
                'label' => esc_html__('Image Size', 'floka' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => 'Enter image size - Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme. Alternatively enter size in pixels Example: 200x100 - Width x Height.',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ),
            array(
                'name' => 'border_radius_image',
                'label' => esc_html__('Border Radius Image', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px','%','custom' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-item--icon img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ),

            array(
                'name'  => 'heading_general',
                'label' => esc_html__('GENERAL','floka'),
                'type'  => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ),
            array(
                'name' => 'display_type_content',
                'label' => esc_html__('Display Content', 'floka' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Horizontal',
                    'content-grid' => 'Vertical',
                ],
                'default' => '',
            ),
            array(
                'name' => 'item_gap',
                'label' => esc_html__('Item Gap', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-item--content ' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ),

            array(
                'name' => 'item_margin',
                'label' => esc_html__('Margin Item', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px','%','custom' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl--item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),

            array(
                'name' => 'item_padding',
                'label' => esc_html__('Padding Item', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px','%','custom' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl--item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),

            array(
                'name' => 'border_typography',
                'label' => esc_html__('Border', 'floka' ),
                'type' => \Elementor\Group_Control_Border::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-list .pxl--item',
            ),

            array(
                'name'  => 'heading_label',
                'label' => esc_html__('LABEL','floka'),
                'type'  => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ),
            
            array(
                'name' => 'label_color',
                'label' => esc_html__('Label Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-list label' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'label_typography',
                'label' => esc_html__('Label Typography', 'floka' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-list label',
            ),

            array(
                'name' => 'label_spacer_bottom',
                'label' => esc_html__('Space Bottom', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-content' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ),
            array(
                'name' => 'label_min_width',
                'label' => esc_html__('Label Min Width', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list label' => 'min-width: {{SIZE}}{{UNIT}};',
                ],
            ),

            array(
                'name'  => 'heading_content',
                'label' => esc_html__('CONTENT','floka'),
                'type'  => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ),
            array(
                'name' => 'content_color',
                'label' => esc_html__('Content Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-content,
                    {{WRAPPER}} .pxl-list .pxl-content a' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'content_hl_color',
                'label' => esc_html__('Content Highlight Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-content .pxl-title--highlight,
                    {{WRAPPER}} .pxl-list .pxl-content a' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'content_color_hv',
                'label' => esc_html__('Content Color Hover', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-list .pxl-content:hover,
                    {{WRAPPER}} .pxl-list .pxl-content a:hover' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'content_typography',
                'label' => esc_html__('Content Typography', 'floka' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-list .pxl-content',
            ),

        )
),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);