<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_list_categories',
        'title' => esc_html__('Case List Categories', 'floka'),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('Content', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'label',
                                    'label' => esc_html__('Label', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'rows' => 10,
                                    'show_label' => false,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ label }}}',
                        ),
                        
                        array(
                            'name' => 'flex_box',
                            'label' => esc_html__('Flex Box', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'start' => esc_html__('Start','floka'),
                                'center' => esc_html__('Center','floka'),
                                'end' => esc_html__('End','floka'),
                                'space-around' => esc_html__('Space Around','floka'),
                                'space-between' => esc_html__('Space Between','floka'),
                                'space-evenly' => esc_html__('Space Evenly','floka'),
                            ],
                            'default' => 'start',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list .pxl--item'  => 'justify-content:{{VALUE}};'
                            ],
                        ),
                    ),
),
array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        
        array(

            array(
                'name'  => 'heading_icon',
                'label' => esc_html__('Icon','floka'),
                'type'  => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ),
            array(
                'name' => 'icon_color',
                'label' => esc_html__('Icon Color', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-list--categories .pxl-icon--arrow' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'icon_typography',
                'label' => esc_html__('Icon Typography', 'floka' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-list--categories .pxl-icon--arrow',
            ),


            array(
                'name'  => 'heading_label',
                'label' => esc_html__('LABEL','floka'),
                'type'  => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ),
            
            array(
                'name' => 'label_typography',
                'label' => esc_html__('Label Typography', 'floka' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-list--categories .pxl-item--label',
            ), 

            array(
                'name' => 'item_border',
                'label' => esc_html__('Border', 'floka' ),
                'type' => \Elementor\Group_Control_Border::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-list--categories .pxl--item ',
            ),

            array(
                'name' => 'item_margin',
                'label' => esc_html__('Item Margin', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px','custom' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list--categories .pxl--item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),
            array(
                'name' => 'item_padding',
                'label' => esc_html__('Item Padding', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px','custom' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-list--categories .pxl--item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),
            

        )
),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);