<?php
$pt_supports = ['post','portfolio','service','careers'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_grid',
        'title' => esc_html__('Case Post Grid', 'floka' ),
        'icon' => 'eicon-posts-grid',
        'categories' => array('pxltheme-core'),
        'scripts' => [
            'imagesloaded',
            'isotope',
            'pxl-post-grid',
            'floka-effect',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'tab_layout',
                    'label'    => esc_html__( 'Layout', 'floka' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => floka_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        floka_get_post_grid_layout($pt_supports)
                    ),
                ),

                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'floka' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'floka' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        floka_get_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        floka_get_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'floka' ),
                                    'ID' => esc_html__('ID', 'floka' ),
                                    'author' => esc_html__('Author', 'floka' ),
                                    'title' => esc_html__('Title', 'floka' ),
                                    'rand' => esc_html__('Random', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'floka' ),
                                    'asc' => esc_html__('Ascending', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'floka' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'tab_grid',
                    'label' => esc_html__('Grid', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 419x279 (Width x Height)).',
                        ),
                        array(
                            'name' => 'img_size_featured',
                            'label' => esc_html__('Image Size Featured', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 677x439 (Width x Height)).',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-2']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'pxl_animate',
                            'label' => esc_html__('Case Animate', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => floka_widget_animate(),
                            'default' => '',
                        ),

                        array(
                            'name' => 'data_layout',
                            'label' => esc_html__('Layout Mode', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'masonry',
                            'options' => [
                                'masonry' => esc_html__('Masonry', 'floka' ),
                                'fitRows' => esc_html__('fitRows', 'floka' ),
                            ],
                            
                        ),

                        array(
                            'name' => 'filter',
                            'label' => esc_html__('Filter on Masonry', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'options' => [
                                'true' => esc_html__('Enable', 'floka' ),
                                'false' => esc_html__('Disable', 'floka' ),
                            ],
                            'condition' => [
                                'select_post_by' => 'term_selected',
                            ],
                        ),
                        array(
                            'name'    => 'filter_type',
                            'label'   => esc_html__('Filter Type', 'floka' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'normal',
                            'options' => [
                                'normal'  => esc_html__('Normal', 'floka' ),
                                'ajax' => esc_html__('Ajax', 'floka' ),
                            ],
                            'condition' => [
                                'select_post_by' => 'term_selected',
                                'filter' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'filter_default_title',
                            'label' => esc_html__('Filter Default Title', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('All', 'floka' ),
                            'condition' => [
                                'filter' => 'true',
                                'select_post_by' => 'term_selected',
                            ],
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'options' => [
                                'pagination' => esc_html__('Pagination', 'floka' ),
                                'loadmore' => esc_html__('Loadmore', 'floka' ),
                                'false' => esc_html__('Disable', 'floka' ),
                            ],
                        ),
                        array(
                            'name'  => 'text_btn_loadmore',
                            'label' => esc_html__('Custom Text Button','floka'),
                            'type'  => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'pagination_type'   => 'loadmore',
                            ],
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns: Screen <= 575', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns: Screen <= 767', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns: Screen <= 991', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns: Screen <= 1199', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns: Screen => 1200', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'item_spacer',
                            'label' => esc_html__('Item Spacer', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'description' => 'Default: 15',
                            'default'   => [
                                'size'  => 15,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.pxl-post-blog .pxl-grid-inner' => 'margin-block:-{{SIZE}}px; margin-inline:-{{SIZE}}px',
                                '{{WRAPPER}}.pxl-post-blog .pxl-grid-item' => 'padding-block: {{SIZE}}px; padding-inline:{{SIZE}}px',
                            ],
                        ),
                        array(
                            'name' => 'grid_masonry',
                            'label' => esc_html__('Grid Masonry', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'col_xs_m',
                                    'label' => esc_html__('Columns: Screen <= 575', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '1',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_sm_m',
                                    'label' => esc_html__('Columns: Screen <= 767', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '2',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_md_m',
                                    'label' => esc_html__('Columns: Screen <= 991', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '2',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_lg_m',
                                    'label' => esc_html__('Columns: Screen <= 1199', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '3',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '2.4' => 'Column 5',
                                        '6' => '6',
                                        'col-7' => 'Column 7',
                                        'col-66' => 'Column 66%',
                                    ],
                                ),
                                array(
                                    'name' => 'col_xl_m',
                                    'label' => esc_html__('Columns: Screen => 1200', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '3',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '2.4' => 'Column 5',
                                        '6' => '6',
                                        'col-7' => 'Column 7',
                                        'col-66' => 'Column 66%',
                                    ],
                                ),
                                
                                array(
                                    'name' => 'img_size_m',
                                    'label' => esc_html__('Image Size', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'control_type' => 'responsive',
                                    'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                                ),
                            ),
),
),
),
array(
    'name' => 'tab_display',
    'label' => esc_html__('Display', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
    'controls' => array(

       array(
        'name' => 'show_date',
        'label' => esc_html__('Show Date', 'floka' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'true',
    ),

       array(
        'name' => 'show_category',
        'label' => esc_html__('Show Category', 'floka' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'true',
    ),

       array(
        'name' => 'show_button',
        'label' => esc_html__('Show Button', 'floka' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'true',
    ),
       array(
        'name' => 'button_text',
        'label' => esc_html__('Button Text', 'floka' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
            'show_button'   => 'true',
        ],
    ),
       array(
        'name' => 'show_excerpt',
        'label' => esc_html__('Show Excerpt', 'floka' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'true',
        'conditions' => [
            'relation' => 'or',
            'terms' => [
                [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                    ]
                ],
            ],
        ],
    ),
       array(
        'name' => 'num_words',
        'label' => esc_html__('Number of Words', 'floka' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'default' => 12,
        'separator' => 'after',
        'control_type'  => 'responsive',
    ),
   ),
),
array(
    'name' => 'section_style_general',
    'label' => esc_html__('General', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'heading_image',
            'label' => esc_html__('IMAGE','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),

        array(
            'name' => 'img_effect',
            'label' => esc_html__('Image Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'None',
                'pxl-image-tilt' => 'Tilt',
                'pxl-image-scale-parallax' => 'Parallax Scale',
                'pxl-image-distortion' => 'Distortion',
            ],
            'default' => '',
            'description'   => 'Not Apply to layout 5!'

        ),
        
        array(
            'name' => 'displacement_img',
            'label' => esc_html__('Displacement Image', 'floka'),
            'type' => 'media',
            'default' => [
                'url' => content_url('/uploads/2025/01/displacement-4.webp'),
                'id' => 9031,
            ],
            'condition' => [
                'img_effect' => 'pxl-image-distortion',
            ]
        ),
        array(
            'name' => 'max_tilt',
            'label' => esc_html__('Max Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '10',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'speed_tilt',
            'label' => esc_html__('Speed Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '400',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'perspective_tilt',
            'label' => esc_html__('Perspective Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '1000',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),

        array(
            'name'          => 'tab_iconbox_featured',
            'control_type'  => 'tab',
            'tabs'          => [
                [
                    'name'  => 'iconbox_featured_normal',
                    'label' => esc_html__('Normal','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                        

                        array(
                            'name'  => 'box_shadow_item',
                            'label' => esc_html__('Box Shadow','floka'),
                            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type'  => 'group',
                            'selector'  => '{{WRAPPER}}.pxl-post-blog .pxl-post--inner',
                        ),

                        
                        
                    ],
                ],
                [
                    'name'  => 'iconbox_featured_hover',
                    'label' => esc_html__('Hover','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                     


                    ],
                ],
            ],
        ),

    ),
),
array(
    'name' => 'section_style_category',
    'label' => esc_html__('Category', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'categories_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-item--category a' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'categories_color_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-item--category a' => 'color: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'categories_bg_color',
            'label' => esc_html__('Background Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-item--category' => 'background: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'categories_bg_color_hv',
            'label' => esc_html__('Background Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-item--category' => 'background: {{VALUE}};',
            ],
        ),


        array(
            'name' => 'category_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-item--category a',
        ),
    ),
),

array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_color_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-post--title' => 'color: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--title',
        ),

        array(
            'name'  => 'heading_date',
            'label' => esc_html__('DATE','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            
        ),

        array(
            'name'  => 'date_color',
            'label' => esc_html__('Color','floka'),
            'type'  => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date,{{WRAPPER}}.pxl-post-blog .pxl-item--date' => 'color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date svg path' => 'fill: {{VALUE}};',
            ],
            
        ),
        array(
            'name'  => 'date_bg_color',
            'label' => esc_html__('Background Color','floka'),
            'type'  => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date svg path' => 'fill: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'date_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--date',
        ),
    ),
),

array(
    'name' => 'section_style_excerpt',
    'label' => esc_html__('Exceprt', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'excerpt_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-item--excerpt' => 'color: {{VALUE}};',
            ],
        ),
        
        array(
            'name' => 'excerpt_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-item--excerpt',
        ),
    ),
),

array(
    'name' => 'section_style_button',
    'label' => esc_html__('Button', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'button_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a' => 'color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a svg path' => 'fill: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'button_color_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a:hover svg path' => 'fill: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'button_bg_color',
            'label' => esc_html__('Background', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a' => 'background: {{VALUE}};',

            ],
        ),

        array(
            'name' => 'button_bg_color_hv',
            'label' => esc_html__('Background Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a' => 'background: {{VALUE}};',

            ],
            'condition' => [
                'btn_text_effect!'  => 'btn-spotlight-scale',
            ],
        ),

        array(
            'name' => 'button_bg_color_hv_spotlight',
            'label' => esc_html__('Background Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a .item-spotlight' => 'background: {{VALUE}};',

            ],
            'condition' => [
                'btn_text_effect'  => 'btn-spotlight-scale',
            ],
        ),

        array(
            'name' => 'button_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--button a',
        ),

        array(
            'name' => 'btn_text_effect',
            'label' => esc_html__('Text Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => esc_html__('Default', 'floka' ),
                'btn-text-nina' => esc_html__('Nina', 'floka' ),
                'btn-text-nanuk' => esc_html__('Nanuk', 'floka' ),
                'btn-text-parallax' => esc_html__('Parallax', 'floka' ),
                'btn-spotlight-scale' => esc_html__('Spotlight', 'floka' ),

            ],
        ),

    ),
),


),
),
),
floka_get_class_widget_path()
);