<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_progressbar',
        'title' => esc_html__( 'Case Progress Bar', 'floka' ),
        'icon' => 'eicon-skill-bar',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'pxl-progressbar',
            'floka-progressbar',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_progressbar/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_progressbar/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_progressbar/layout3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_progressbar/layout4.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__( 'Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'progressbar',
                            'label' => esc_html__( 'Progress Bar', 'floka' ),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__( 'Title', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'percent',
                                    'label' => esc_html__( 'Percentage', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'default' => [
                                        'size' => 50,
                                        'unit' => '%',
                                    ],
                                    'label_block' => true,
                                ),
                                array(
                                    'name'  => 'heading_style_currentitem',
                                    'label' => esc_html__('STYLE','floka'),
                                    'type'  => \Elementor\Controls_Manager::HEADING,
                                    'separator' => 'before',
                                ),
                                array(
                                    'name' => 'title_color_item',
                                    'label' => esc_html__( 'Title', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-progressbar {{CURRENT_ITEM}} .pxl--title' => 'color: {{VALUE}};',
                                    ],
                                ),
                                array(
                                    'name' => 'percentage_color_item',
                                    'label' => esc_html__( 'Percentage', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-progressbar {{CURRENT_ITEM}} .pxl-progressbar--wrap .pxl--percentage,{{WRAPPER}} .pxl-progressbar.pxl-progressbar-4 {{CURRENT_ITEM}} .pxl-progressbar--wrap .stat-box' => 'color: {{VALUE}};',
                                    ],
                                ),
                                array(
                                    'name' => 'bg_color_item',
                                    'label' => esc_html__( 'Background', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-progressbar {{CURRENT_ITEM}} .pxl-progressbar--wrap .pxl--progressbar,{{WRAPPER}} .pxl-progressbar.pxl-progressbar-4 {{CURRENT_ITEM}} .pxl-progressbar--wrap .stat-box' => 'background: {{VALUE}};',
                                    ],
                                ),
                                array(
                                    'name' => 'border_current_item',
                                    'label' => esc_html__('Border', 'floka' ),
                                    'type' => \Elementor\Group_Control_Border::get_type(),
                                    'control_type'  => 'group',
                                    'selector' => '{{WRAPPER}} .pxl-progressbar {{CURRENT_ITEM}} .pxl-progressbar--wrap .pxl--progressbar',
                                        '{{WRAPPER}} .pxl-progressbar.pxl-progressbar-4 {{CURRENT_ITEM}} .stat-box',
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'item_max_width',
                            'label' => esc_html__('Item Max Width', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout!'   => '4',
                            ],
                        ),
                        array(
                            'name' => 'item_max_height',
                            'label' => esc_html__('Item Max Height', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout'   => '4',
                            ],
                        ),
                        array(
                            'name' => 'item_space',
                            'label' => esc_html__('Item Spacer', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar .pxl--item + .pxl--item' => 'margin-top: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout!'   => '4',
                            ],
                        ),
                        array(
                            'name' => 'item_space_columns',
                            'label' => esc_html__('Item Spacer', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 50,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar' => 'gap: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout'   => '4',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_title',
                    'label' => esc_html__( 'Title', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__( 'Title Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar .pxl--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__( 'Title Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}}  .pxl-progressbar .pxl--title',
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_percentage',
                    'label' => esc_html__( 'Percentage', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'percentage_color',
                            'label' => esc_html__( 'Percentage Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar .pxl--percentage' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'percentage_typography',
                            'label' => esc_html__( 'Percentage Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-progressbar .pxl--percentage',
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_bar',
                    'label' => esc_html__( 'Bar', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'bar_color',
                            'label' => esc_html__( 'Bar Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar .pxl--progressbar' => 'background: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'bar_bg_color',
                            'label' => esc_html__( 'Bar Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar .pxl-progressbar--wrap' => 'background: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'bar_height',
                            'label' => esc_html__('Bar Height', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar-1 .pxl-progressbar--wrap' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-progressbar-1 .pxl--progressbar' => 'height: calc({{SIZE}}{{UNIT}}/2);',
                            ],
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'bar_radius',
                            'label' => esc_html__('Bar Radius', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-progressbar-1 .pxl-progressbar--wrap, {{WRAPPER}} .pxl-progressbar-1 .pxl--progressbar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                    ),
                ),
                floka_widget_animation_settings(),
            ),
        ),
    ),
    floka_get_class_widget_path()
);