<?php
$templates = floka_get_templates_option('tab', []) ;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_tabs',
        'title' => esc_html__( 'Case Tabs', 'floka' ),
        'icon' => 'eicon-tabs',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'floka-effect',
            'floka-tabs',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Layout', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_tabs/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_tabs/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__( 'Tabs', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'tab_active',
                            'label' => esc_html__( 'Active Tab', 'floka' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 1,
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'tabs',
                            'label' => esc_html__( 'Content', 'floka' ),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'type_active',
                                    'label' => esc_html__('Type Active', 'floka'),
                                    'type' => 'select',
                                    'options' => [
                                        '' => esc_html__( 'Default', 'floka' ),
                                        'custom_target' => esc_html__( 'Custom Target', 'floka' ),
                                    ],
                                    'default' => '' 
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__( 'Title', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),

                                array(
                                    'name' => 'target_custom',
                                    'label' => esc_html__( 'Custom Target', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                    'description'   => esc_html__('Enter a similar value in the Content Type → Custom Target → Custom ID.','floka'),
                                    'condition' => ['type_active' => 'custom_target']
                                ),


                                
                                array(
                                    'name' => 'content_type',
                                    'label' => esc_html__('Content Type', 'floka'),
                                    'type' => 'select',
                                    'options' => [
                                        'df' => esc_html__( 'Default', 'floka' ),
                                        'template' => esc_html__( 'From Template Builder', 'floka' ),
                                        'custom_target' => esc_html__( 'Custom Target', 'floka' ),
                                    ],
                                    'default' => 'df' 
                                ),

                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__( 'Content', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::WYSIWYG,
                                    'condition' => ['content_type' => 'df'] 
                                ),
                                array(
                                    'name' => 'content_template',
                                    'label' => esc_html__('Select Template', 'floka'),
                                    'type' => 'select',
                                    'options' => $templates,
                                    'default' => 'df',
                                    'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>" and Edit template "<a href="' . esc_url( admin_url( 'edit.php?s&post_status=all&post_type=pxl-template&action=-1&m=0&pxl_filter_template_type=tab&filter_action=Filter&paged=1&action2=-1' ) ) . '" target="_blank">Here.</a>"',
                                    'condition' => ['content_type' => 'template'] 
                                ),

                                array(
                                    'name' => 'id_custom',
                                    'label' => esc_html__( 'Custom ID', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                    'condition' => ['type_active' => 'custom_target']

                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'max_width',
                            'label' => esc_html__('Content Max Width', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-tabs .pxl-tabs--inner' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
),
array(
    'name' => 'tab_style',
    'label' => esc_html__( 'Style', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'style_l2',
            'label' => esc_html__('Style', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style-1' => 'Style 1',
                'style-2' => 'Style 2',
            ],
            'default' => 'style-1',
            'condition' => [
                'layout' => '2',
            ],
        ),
        array(
            'name' => 'tab_effect',
            'label' => esc_html__('Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'tab-effect-slide' => 'Slide',
                'tab-effect-fade' => 'Fade',
            ],
            'default' => 'tab-effect-fade',
        ),

        array(
            'name'      => 'heading_general',
            'label'     => esc_html__('General','floka'),
            'type'      => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),


        array(
            'name'      => 'heading_title',
            'label'     => esc_html__('TITLE','floka'),
            'type'      => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name'  => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type'  => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tab--title' => 'color: {{VALUE}};--tab-title-color: {{VALUE}};',
                '{{WRAPPER}} .pxl-tabs .pxl-item--icon svg path' => 'fill: {{VALUE}};',
            ],
        ),
        array(
            'name'  => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type'  => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-tabs .pxl-tab--title',
            'separator' => 'after',
        ),
        array(
            'name' => 'title_bg_color',
            'label' => esc_html__('Background', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tab--title' => 'background: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'title_bg_colorhv_active',
            'label' => esc_html__('Background Hover/Active', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tab--title .direction-item' => 'background: {{VALUE}};',
            ],
        ),

    ),
),

floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);