<?php

if (!class_exists('Floka_Blog')) {

    class Floka_Blog
    {

        public function get_archive_meta() {
            $archive_author = floka()->get_theme_opt( 'archive_author', true );
            if($archive_author || $archive_category || $archive_date || $archive_comment) : ?>
                <div class="pxl-item--meta pxl-blog-meta">
                    <div class="pxl-blog-meta-inner">
                        <?php if($archive_author) : ?>
                            <?php $this->get_author_info(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; 
        }

        public function get_post_metas(){
            $post_comment = floka()->get_theme_opt( 'post_comment', true );
            $post_date = floka()->get_theme_opt( 'post_date', true );
            $post_category = floka()->get_theme_opt( 'post_category', true );
            $count_post_view = $this->floka_set_post_views(get_the_ID());

            $post_author = floka()->get_theme_opt( 'post_author', true );
            $post_id = get_the_ID();
            $author_id = get_post_field('post_author', $post_id);
            $author_url = get_author_posts_url($author_id);
            $author_name = get_the_author_meta('display_name', $author_id);
            if($post_author || $post_date) : ?>
                <div class="pxl-item--meta pxl-blog-meta">
                    <h3 class="pxl-item--title-entry">
                        <?php if(is_sticky()) { ?>
                            <i class="caseicon-check-mark pxl-mr-4"></i>
                        <?php } ?>
                        <?php the_title(); ?>

                    </h3>

                    <div class="pxl-blog-meta-inner">
                       <?php if($post_author) : ?>
                        <div class="pxl-post--author pxl-post--item">
                            <span class="pxl-author--avatar">
                                <?php echo get_avatar( get_the_author_meta('ID'), 280 ); ?>
                            </span>
                            <span class="pxl-author--name">
                                <span class="pxl-text--highlight"><?php echo esc_html__('By ', 'floka'); ?></span><?php the_author_posts_link(); ?>
                            </span>
                        </div>
                    <?php endif; ?>

                    <?php if($post_date) : ?>
                        <div class="pxl-item--date">
                            <i class="fas fa-calendar-alt"></i>
                            <?php echo get_the_date('M d'); ?>, <?php echo get_the_date('Y'); ?>
                        </div>
                    <?php endif; ?>

                    <?php if($post_comment) : ?>
                        <div class="pxl-item--comment">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                              <path d="M17.991 2.70625C17.991 1.71625 17.19 0.90625 16.2 0.90625H1.8C0.81 0.90625 0 1.71625 0 2.70625V13.5062C0 14.4962 0.81 15.3062 1.8 15.3062H14.4L18 18.9062L17.991 2.70625ZM13.5 11.7062H4.5C4.005 11.7062 3.6 11.3012 3.6 10.8062C3.6 10.3112 4.005 9.90625 4.5 9.90625H13.5C13.995 9.90625 14.4 10.3112 14.4 10.8062C14.4 11.3012 13.995 11.7062 13.5 11.7062ZM13.5 9.00625H4.5C4.005 9.00625 3.6 8.60125 3.6 8.10625C3.6 7.61125 4.005 7.20625 4.5 7.20625H13.5C13.995 7.20625 14.4 7.61125 14.4 8.10625C14.4 8.60125 13.995 9.00625 13.5 9.00625ZM13.5 6.30625H4.5C4.005 6.30625 3.6 5.90125 3.6 5.40625C3.6 4.91125 4.005 4.50625 4.5 4.50625H13.5C13.995 4.50625 14.4 4.91125 14.4 5.40625C14.4 5.90125 13.995 6.30625 13.5 6.30625Z" fill="#17511A"/>
                          </svg>
                          <a href="<?php the_permalink(); ?>#comments">
                            <?php echo comments_number(esc_html__('0', 'floka'),esc_html__('1', 'floka'),esc_html__('%', 'floka')); ?>
                        </a>
                    </div>
                <?php endif; ?>
                <div class="pxl-post--view pxl-post--item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="15" viewBox="0 0 21 15" fill="none">
                        <path d="M20.9396 7.62275C20.909 7.55363 20.1679 5.9095 18.5202 4.26187C16.3249 2.0665 13.552 0.90625 10.5 0.90625C7.44799 0.90625 4.67512 2.0665 2.47974 4.26187C0.832117 5.9095 0.0874916 7.55625 0.0603666 7.62275C0.0205656 7.71227 0 7.80915 0 7.90712C0 8.0051 0.0205656 8.10198 0.0603666 8.1915C0.0909916 8.26062 0.832117 9.90388 2.47974 11.5515C4.67512 13.746 7.44799 14.9062 10.5 14.9062C13.552 14.9062 16.3249 13.746 18.5202 11.5515C20.1679 9.90388 20.909 8.26062 20.9396 8.1915C20.9794 8.10198 21 8.0051 21 7.90712C21 7.80915 20.9794 7.71227 20.9396 7.62275ZM10.5 11.4062C9.80776 11.4062 9.13107 11.201 8.5555 10.8164C7.97992 10.4318 7.53132 9.88518 7.26641 9.24564C7.00151 8.6061 6.9322 7.90237 7.06724 7.22343C7.20229 6.5445 7.53563 5.92086 8.02512 5.43138C8.5146 4.94189 9.13824 4.60855 9.81718 4.4735C10.4961 4.33845 11.1998 4.40776 11.8394 4.67267C12.4789 4.93758 13.0256 5.38618 13.4101 5.96175C13.7947 6.53733 14 7.21402 14 7.90625C14 8.83451 13.6312 9.72475 12.9749 10.3811C12.3185 11.0375 11.4283 11.4062 10.5 11.4062Z" fill="#17511A"/>
                    </svg>
                    <span class="pxl-count-view">
                        <?php echo esc_attr($count_post_view); ?>
                    </span>
                </div>
            </div>


        </div>
    <?php endif; 
}

public function get_author_info() {
    if(!is_single()) : ?>
        <div class="pxl-item--author">
            <div class="pxl-author--avatar">
                <?php echo get_avatar( get_the_author_meta( 'ID' ), 280 ); ?>
            </div>
            <div class="pxl-author-meta">
                <?php floka_get_user_name(); ?>
                <?php floka_get_user_position(); ?>
            </div>
        </div>
    <?php else : ?>
        <?php 
        $author_desc = get_user_meta(get_the_author_meta( 'ID' ), 'description', true);
        ?>
        <div class="pxl-author">
            <div class="pxl-author--avatar">
                <?php echo get_avatar( get_the_author_meta( 'ID' ), 280 ); ?>
            </div>
            <div class="pxl-author-meta">
                <?php floka_get_user_name(); ?>
                <div class="pxl-author--desc">
                    <?php echo esc_attr($author_desc); ?>
                </div>
                <?php floka_get_user_social(); ?>
            </div>
        </div>
    <?php endif;
}

public function get_excerpt(){
    $archive_excerpt_length = floka()->get_theme_opt('archive_excerpt_length', '50');
    $floka_the_excerpt = get_the_excerpt();
    if(!empty($floka_the_excerpt)) {
        echo wp_trim_words( $floka_the_excerpt, $archive_excerpt_length, $more = null );
    } else {
        echo wp_kses_post($this->get_excerpt_more( $archive_excerpt_length ));
    }
}

public function get_excerpt_more( $post = null ) {
    $archive_excerpt_length = floka()->get_theme_opt('archive_excerpt_length', '50');
    $post = get_post( $post );

    if ( empty( $post ) || 0 >= $archive_excerpt_length ) {
        return '';
    }

    if ( post_password_required( $post ) ) {
        return esc_html__( 'Post password required.', 'floka' );
    }

    $content = apply_filters( 'the_content', strip_shortcodes( $post->post_content ) );
    $content = str_replace( ']]>', ']]&gt;', $content );

    $excerpt_more = apply_filters( 'floka_excerpt_more', '&hellip;' );
    $excerpt      = wp_trim_words( $content, $archive_excerpt_length, $excerpt_more );

    return $excerpt;
}

public function floka_set_post_views( $postID ) {
    $countKey = 'post_views_count';
    $count    = get_post_meta( $postID, $countKey, true );
    if ( $count == '' ) {
        $count = 0;
        delete_post_meta( $postID, $countKey );
        add_post_meta( $postID, $countKey, '0' );
    } else {
        $count ++;
        update_post_meta( $postID, $countKey, $count );
    }
    return $count;
}

public function get_tagged_in(){
    $tags_list = get_the_tag_list( '', ' ' );
    if ( $tags_list )
    {
        echo '<div class="pxl--tags">';
        printf('%2$s', '', $tags_list);
        echo '</div>';
    }
}

public function get_socials_share() { 
    $img_url = '';
    if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
        $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
    }
    $social_facebook = floka()->get_theme_opt( 'social_facebook', true );
    $social_twitter = floka()->get_theme_opt( 'social_twitter', true );
    $social_behance = floka()->get_theme_opt( 'social_behance', true );
    $social_youtube = floka()->get_theme_opt( 'social_youtube', true );
    $copy_link = floka()->get_theme_opt( 'copy_link', true );
    ?>
    <div class="pxl--social">
        <?php if($social_facebook) : ?>
            <a class="fb-social" title="<?php echo esc_attr__('Facebook', 'floka'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="caseicon-facebook"></i></a>
        <?php endif; ?>

        <?php if($social_twitter) : ?>
            <a class="tw-social" title="<?php echo esc_attr__('Twitter', 'floka'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>%20"><i class="fab fa-twitter"></i></a>
        <?php endif; ?>

        <?php if($social_behance) : ?>
            <a class="bh-social" title="<?php echo esc_attr__('Behance', 'floka'); ?>" target="_blank" href="behance.net"><i class="fab fa-behance"></i></a>
        <?php endif; ?>

        <?php if($social_youtube) : ?>
            <a class="yt-social" title="<?php echo esc_attr__('Youtube', 'floka'); ?>" target="_blank" href="http://youtube.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url[0]); ?>&description=<?php the_title(); ?>%20"><i class="fab fa-youtube"></i></a>
        <?php endif; ?>

        <?php if($copy_link) : ?>
            <a class="btn-copy-link" title="<?php echo esc_attr__('Copy Link', 'floka'); ?>" href="#">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M3.88176 15.9999C2.85964 16 1.89439 15.5949 1.14967 14.8503C0.369892 14.0705 -0.0374194 13.0487 0.00270552 11.9733C0.0441742 10.8626 0.545954 9.79558 1.45383 8.88771L3.08845 7.24643C3.33201 7.00184 3.72773 7.00103 3.97232 7.24462C4.21688 7.48818 4.21773 7.88393 3.97413 8.12849L2.33864 9.77071C1.0133 11.0961 0.888235 12.821 2.03361 13.9664C3.17901 15.1119 4.90398 14.9868 6.22835 13.6623L8.47481 11.4158C9.15572 10.7349 9.53122 9.95746 9.56069 9.16752C9.58772 8.44346 9.31009 7.75218 8.77897 7.22106C8.601 7.04312 8.40409 6.89212 8.19369 6.77228C7.89375 6.60143 7.7891 6.21978 7.95994 5.91987C8.13081 5.61994 8.51247 5.51531 8.81234 5.68612C9.11978 5.86125 9.40594 6.08031 9.66287 6.33722C10.4427 7.117 10.85 8.13871 10.8098 9.21418C10.7684 10.3249 10.2666 11.3919 9.35872 12.2997L7.11225 14.5462C6.20435 15.4541 5.13741 15.9558 4.0267 15.9973C3.97832 15.999 3.92992 15.9999 3.88176 15.9999ZM8.04013 10.0801C8.21097 9.78015 8.10628 9.39849 7.80638 9.22768C7.59597 9.10784 7.39903 8.95684 7.2211 8.77893C6.07572 7.63353 6.20079 5.90856 7.52522 4.58413L9.77169 2.33769C11.0962 1.01329 12.8211 0.888196 13.9664 2.03357C15.1118 3.17894 14.9867 4.90391 13.6614 6.22925L12.0259 7.87146C11.7823 8.11603 11.7831 8.51178 12.0277 8.75534C12.2723 8.99893 12.668 8.99805 12.9116 8.75352L14.5462 7.11222C15.4541 6.20434 15.9558 5.13738 15.9973 4.02669C16.0375 2.95122 15.6301 1.92948 14.8504 1.1497C14.0706 0.369885 13.0483 -0.0373646 11.9734 0.00269782C10.8627 0.0441665 9.79569 0.545947 8.88784 1.45382L6.64135 3.70025C5.73348 4.60813 5.23173 5.67509 5.19023 6.78578C5.1501 7.86125 5.55741 8.88299 6.33719 9.6628C6.5941 9.91968 6.88025 10.1387 7.18772 10.3139C7.28535 10.3695 7.3916 10.3959 7.49647 10.3959C7.71375 10.3959 7.92488 10.2824 8.04013 10.0801Z" fill="black"/>
                </svg>
            </a>
        <?php endif; ?>
        
    </div>
    <?php
}

public function get_socials_share_portfolio() { 
    $img_url = '';
    if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
        $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
    }
    ?>
    <div class="pxl--social">
        <a class="fb-social" title="<?php echo esc_attr__('Facebook', 'floka'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="caseicon-facebook"></i></a>
        <a class="tw-social" title="<?php echo esc_attr__('Twitter', 'floka'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>%20"><i class="caseicon-twitter"></i></a>
        <a class="pin-social" title="<?php echo esc_attr__('Pinterest', 'floka'); ?>" target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url[0]); ?>&description=<?php the_title(); ?>%20"><i class="caseicon-pinterest"></i></a>
        <a class="lin-social" title="<?php echo esc_attr__('LinkedIn', 'floka'); ?>" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>%20"><i class="caseicon-linkedin"></i></a>
    </div>
    <?php
}

public function get_post_nav() {
    global $post;
    $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous )
        return;
    ?>
    <?php
    $next_post = get_next_post();
    $previous_post = get_previous_post();

    if( !empty($next_post) || !empty($previous_post) ) { 
        $page_for_posts = get_option( 'page_for_posts' );
        ?>
        <div class="pxl-post--navigation pxl-flex">

            <?php if ( is_a( $previous_post , 'WP_Post' ) && get_the_title( $previous_post->ID ) != '') { 
                $prev_img_id = get_post_thumbnail_id($previous_post->ID);
                $img_prev  = pxl_get_image_by_size( array(
                    'attach_id'  => $prev_img_id,
                    'thumb_size' => '260x260',
                ) );
                $thumbnail_prev    = $img_prev['url']; ?>
                <div class="pxl-navigation--col pxl-navigation--prev">
                    <div class="pxl-navigation--icon">
                        <svg width="15" height="10" viewBox="0 0 15 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5.23877 8.90625C5.11377 9.0625 4.86377 9.0625 4.73877 8.90625L1.08252 5.28125C0.926271 5.125 0.926271 4.90625 1.08252 4.75L4.73877 1.125C4.86377 0.96875 5.11377 0.96875 5.23877 1.125L5.48877 1.34375C5.61377 1.5 5.61377 1.71875 5.48877 1.875L2.86377 4.46875H14.6138C14.8013 4.46875 14.9888 4.65625 14.9888 4.84375V5.15625C14.9888 5.375 14.8013 5.53125 14.6138 5.53125H2.86377L5.48877 8.15625C5.61377 8.3125 5.61377 8.53125 5.48877 8.6875L5.23877 8.90625Z" fill="currentColor"/>
                        </svg>
                    </div>
                    <h5 class="pxl-navigation--title">
                        <a  href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><?php echo get_the_title( $previous_post->ID ); ?></a>
                    </h5>
                </div>
            <?php } ?>

            <div class="pxl-icon--center pxl-dflex-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                  <g opacity="0.3">
                    <rect x="9" width="3" height="3" fill="#0A0A0A"/>
                    <rect x="9" y="9" width="3" height="3" fill="#0A0A0A"/>
                    <rect y="9" width="3" height="3" fill="#0A0A0A"/>
                    <rect y="18" width="3" height="3" fill="#0A0A0A"/>
                    <rect width="3" height="3" fill="#0A0A0A"/>
                    <rect x="9" y="18" width="3" height="3" fill="#0A0A0A"/>
                    <rect x="18" y="9" width="3" height="3" fill="#0A0A0A"/>
                    <rect x="18" y="18" width="3" height="3" fill="#0A0A0A"/>
                    <rect x="18" width="3" height="3" fill="#0A0A0A"/>
                </g>
            </svg>
        </div>

        <?php if ( is_a( $next_post , 'WP_Post' ) && get_the_title( $next_post->ID ) != '') { 
            $next_img_id = get_post_thumbnail_id($next_post->ID);
            $img_next  = pxl_get_image_by_size( array(
                'attach_id'  => $next_img_id,
                'thumb_size' => '260x260',
            ) );
            $thumbnail_next    = $img_next['url']; ?>
            <div class="pxl-navigation--col pxl-navigation--next">
                <h5 class="pxl-navigation--title">
                    <a  href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"><?php echo get_the_title( $next_post->ID ); ?></a>
                </h5>
                <div class="pxl-navigation--icon">
                    <svg width="15" height="10" viewBox="0 0 15 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.5513 1.125C10.6763 0.96875 10.9263 0.96875 11.0825 1.125L14.7075 4.75C14.8638 4.90625 14.8638 5.125 14.7075 5.28125L11.0825 8.90625C10.9263 9.0625 10.6763 9.0625 10.5513 8.90625L10.3013 8.6875C10.1763 8.53125 10.1763 8.3125 10.3013 8.15625L12.9263 5.53125H1.20752C0.988771 5.53125 0.832521 5.375 0.832521 5.15625V4.84375C0.832521 4.65625 0.988771 4.46875 1.20752 4.46875H12.9263L10.3013 1.875C10.1763 1.71875 10.1763 1.5 10.3013 1.34375L10.5513 1.125Z" fill="currentColor"/>
                    </svg>
                </div>

            </div>
        <?php } ?>

    </div>
<?php }
}

public function get_post_author_info() { 
    $description_ai = floka()->get_theme_opt( 'description_ai', 'default' );
    $description_custom = floka()->get_theme_opt( 'description_ai_custom_text');
    ?>
    <div class="pxl-post--author-info">
        <div class="pxl-post--author-image pxl-mr-28"><?php echo get_avatar( get_the_author_meta( 'ID' ), 280 ); ?></div>
        <div class="pxl-post--author-meta">
            <?php floka_get_user_position(); ?>
            <?php  floka_get_user_name(); ?>

            <div class="pxl-post--author-description">
                <?php if ($description_ai === 'default') { the_author_meta('description'); } 
                elseif ($description_ai === 'custom_text') { echo pxl_print_html($description_custom); } 
                ?>
            </div>
            <?php  floka_get_user_social(); ?>
        </div>
    </div>
<?php }



public function get_related_post(){
    $post_related = floka()->get_theme_opt( 'post_related', true );

    if($post_related) {
        global $post;
        $current_id = $post->ID;
        $posttags = get_the_category($post->ID);
        if (empty($posttags)) return;

        $tags = array();

        foreach ($posttags as $tag) {

            $tags[] = $tag->term_id;
        }
        $post_number = '6';
        $query_similar = new WP_Query(array('posts_per_page' => $post_number, 'post_type' => 'post', 'post_status' => 'publish', 'category__in' => $tags));
        if (count($query_similar->posts) > 1) {
            wp_enqueue_script( 'swiper' );
            wp_enqueue_script( 'pxl-swiper' );
            $opts = [
                'slide_direction'               => 'horizontal',
                'slide_percolumn'               => '1', 
                'slide_mode'                    => 'slide', 
                'slides_to_show'                => 3, 
                'slides_to_show_lg'             => 3, 
                'slides_to_show_md'             => 2, 
                'slides_to_show_sm'             => 2, 
                'slides_to_show_xs'             => 1, 
                'slides_to_scroll'              => 1, 
                'slides_gutter'                 => 30, 
                'arrow'                         => false,
                'dots'                          => true,
                'dots_style'                    => 'bullets',
                'loop'                          => true,
            ];
            $data_settings = wp_json_encode($opts);
            $dir           = is_rtl() ? 'rtl' : 'ltr';
            ?>
            <div class="pxl-related-post">
                <h3 class="pxl-swiper-slider related-post--title"><?php echo esc_html__('Related Articles', 'floka'); ?></h3>

                <div class="pxl-carousel-inner">
                    <div class="pxl-swiper-container" data-settings="<?php echo esc_attr($data_settings) ?>" data-rtl="<?php echo esc_attr($dir) ?>">
                        <div class="pxl-related-post-inner">
                            <?php foreach ($query_similar->posts as $post):
                                $thumbnail_url = '';
                                if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) :
                                    $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'pxl-blog-small', false);
                            endif;
                            if ($post->ID !== $current_id) : ?>
                                <div class="pxl-swiper-slide swiper-slide grid-item">
                                    <div class="pxl-grid-item-inner">
                                        <?php if (has_post_thumbnail()) { ?>
                                            <div class="item-featured">
                                                <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($thumbnail_url[0]); ?>" height="279"/></a>
                                                <div class="item--date">
                                                    <div class="item--day">
                                                        <?php echo get_the_date('d'); ?>
                                                    </div>
                                                    <div class="item--month">
                                                        <?php echo get_the_date('M'); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        <div class="pxl--category">
                                            <?php
                                            $categories = get_the_category();
                                            if ( !empty($categories) ) {
                                                $first_category = $categories[0];
                                                echo '<a href="' . esc_url(get_category_link($first_category->term_id)) . '"><i class="flaticon flaticon-superellipse pxl-mr-8""></i>'  . esc_html($first_category->name) . '</a>';
                                            }
                                            ?> 
                                        </div>
                                        <h4 class="item-title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h4>
                                    </div>
                                </div>
                            <?php endif;
                        endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php }
}

wp_reset_postdata();
}
}
}
