<?php if(!function_exists('floka_configs')){
    function floka_configs($value){
        $primary_darker = floka()->get_opt('color_primary', '#5f2dde');
        $primary_darker_10 = pxl_darker_color($primary_darker, $primary_darker_10=1);
        $primary_darker_20 = pxl_darker_color($primary_darker, $primary_darker_20=1.3);
        $primary_darker_30 = pxl_darker_color($primary_darker, $primary_darker_30=3);
        $primary_darker_40 = pxl_darker_color($primary_darker, $primary_darker_40=4);

        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'floka'), 
                    'value' => floka()->get_opt('color_primary', '#0A0A0A')
                ],
                'gradient-first'   => [
                    'title' => esc_html__('Gradient First', 'floka'), 
                    'value' => floka()->get_opt('gradient_first_color', '#FE6462')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'floka'), 
                    'value' => floka()->get_opt('color_secondary', '#FFF')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'floka'), 
                    'value' => floka()->get_opt('third_color', '#94D96B')
                ],
                'dark'   => [
                    'title' => esc_html__('Dark', 'floka'), 
                    'value' => floka()->get_opt('dark_color', '#000')
                ],
                'body-bg'   => [
                    'title' => esc_html__('Body Background Color', 'floka'), 
                    'value' => floka()->get_page_opt('body_bg_color', '#F5F5F5')
                ],
                'primary-darker-10'   => [
                    'title' => esc_html__('Primary Darker Color 10', 'floka'),
                    'value' => $primary_darker_10
                ],
                'primary-darker-20'   => [
                    'title' => esc_html__('Primary Darker Color 20', 'floka'), 
                    'value' => $primary_darker_20
                ],
                'primary-darker-30'   => [
                    'title' => esc_html__('Primary Darker Color 30', 'floka'), 
                    'value' => $primary_darker_30
                ],
                'primary-darker-40'   => [
                    'title' => esc_html__('Primary Darker Color 40', 'floka'), 
                    'value' => $primary_darker_40
                ]
            ],
            'link' => [
                'color' => floka()->get_opt('link_color', ['regular' => '#0A0A0A'])['regular'],
                'color-hover'   => floka()->get_opt('link_color', ['hover' => '#0A0A0A'])['hover'],
                'color-active'  => floka()->get_opt('link_color', ['active' => '#0A0A0A'])['active'],
            ],
            'gradient' => [
                'color-from' => floka()->get_opt('gradient_color', ['from' => '#FFF'])['from'],
                'color-to' => floka()->get_opt('gradient_color', ['to' => '#272727'])['to'],
            ],
            'gradient2' => [
                'color-from' => floka()->get_opt('gradient_color2', ['from' => '#8c92f6'])['from'],
                'color-to' => floka()->get_opt('gradient_color2', ['to' => '#f9d78f'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('floka_inline_styles')) {
    function floka_inline_styles() {  
        
        $theme_colors      = floka_configs('theme_colors');
        $link_color        = floka_configs('link');
        $gradient_color    = floka_configs('gradient');
        $gradient_color2   = floka_configs('gradient2');

        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--color-%1$s: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  floka_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color2 as $color => $value) {
                printf('--gradient-%1$s2: %2$s;', $color, $value);
            }

        echo '}';

        return ob_get_clean();
         
    }
}
 