<?php
add_action('after_setup_theme', 'casethemes_setup_option', 1);

function casethemes_setup_option(){
    if (!class_exists('ReduxFramework')) {
        return;
    }

    $opt_name = floka()->get_option_name();
    $version = floka()->get_version();

    $args = array(
    // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => '', //$theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $version,
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu', //class_exists('Pxltheme_Core') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'floka'),
    'page_title'           => esc_html__('Theme Options', 'floka'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => 80,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'pxlart', //class_exists('Floka_Admin_Page') ? 'case' : '',
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'pxlart-theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# Colors
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Global Colors', 'floka'),
    'icon'       => 'el el-filter',
    'fields' => array(
        array(
            'id'          => 'color_primary',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'floka'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'secondary_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'floka'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'third_color',
            'type'        => 'color',
            'title'       => esc_html__('Third Color', 'floka'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'dark_color',
            'type'        => 'color',
            'title'       => esc_html__('Dark Color', 'floka'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Colors', 'floka'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'  => ''
            ),
            'output'  => array('a')
        ),
        array(
            'id'          => 'gradient_first_color',
            'type'        => 'color',
            'title'       => esc_html__('Gradient First Color', 'floka'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'          => 'gradient_color',
            'type'        => 'color_gradient',
            'title'       => esc_html__('Gradient Color', 'floka'),
            'transparent' => false,
            'default'  => array(
                'from' => '',
                'to'   => '', 
            ),
        ),
        array(
            'id'          => 'gradient_color2',
            'type'        => 'color_gradient',
            'title'       => esc_html__('Gradient Color 2', 'floka'),
            'transparent' => false,
            'default'  => array(
                'from' => '',
                'to'   => '', 
            ),
        ),
    )
));

/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'floka'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(

        array(
            'id'          => 'font_body',
            'type'        => 'typography',
            'title'       => esc_html__('Body Font', 'floka'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'output'      => array('body'),
            'units'       => 'px',
        ),
        
        array(
            'id'          => 'font_heading_h1',
            'type'        => 'typography',
            'title'       => esc_html__('Heading H1', 'floka'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height' => true,
            'font-size'   => true,
            'font-backup' => false,
            'font-style'  => false,
            'output'      => array('h1'),
            'units'       => 'px',
        ),

        array(
            'id'          => 'font_heading_h2',
            'type'        => 'typography',
            'title'       => esc_html__('Heading H2', 'floka'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height' => true,
            'font-size'   => true,
            'font-backup' => false,
            'font-style'  => false,
            'output'      => array('h2'),
            'units'       => 'px',
        ),

        array(
            'id'          => 'font_heading_h3',
            'type'        => 'typography',
            'title'       => esc_html__('Heading H3', 'floka'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height' => true,
            'font-size'   => true,
            'font-backup' => false,
            'font-style'  => false,
            'output'      => array('h3'),
            'units'       => 'px',
        ),

        array(
            'id'          => 'font_heading_h4',
            'type'        => 'typography',
            'title'       => esc_html__('Heading H4', 'floka'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height' => true,
            'font-size'   => true,
            'font-backup' => false,
            'font-style'  => false,
            'output'      => array('h4'),
            'units'       => 'px',
        ),

        array(
            'id'          => 'font_heading_h5',
            'type'        => 'typography',
            'title'       => esc_html__('Heading H5', 'floka'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height' => true,
            'font-size'   => true,
            'font-backup' => false,
            'font-style'  => false,
            'output'      => array('h5'),
            'units'       => 'px',
        ),

        array(
            'id'          => 'font_heading_h6',
            'type'        => 'typography',
            'title'       => esc_html__('Heading H6', 'floka'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height' => true,
            'font-size'   => true,
            'font-backup' => false,
            'font-style'  => false,
            'output'      => array('h6'),
            'units'       => 'px',
        ),

        array(
            'id'          => 'f_secondary',
            'type'        => 'typography',
            'title'       => esc_html__('Secondary', 'floka'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => false,
            'line-height'  => false,
            'font-size'  => false,
            'color'  => false,
            'font-style'  => false,
            'font-weight'  => false,
            'text-align'  => false,
            'units'       => 'px',
            'output'      => array('.ft-secondary'),
        ),

    )
));

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'floka'),
    'icon'   => 'el el-wrench',
    'fields' => array(
        array(
            'id'       => 'site_loader',
            'type'     => 'button_set',
            'title'    => esc_html__('Site Loader', 'floka'),
            'options'  => array(
                'on' => esc_html__('On', 'floka'),
                'off' => esc_html__('Off', 'floka'),
            ),
            'default'  => 'off',
        ),
        array(
            'id'       => 'site_loader_style',
            'type'     => 'button_set',
            'title'    => esc_html__('Site Loader Style', 'floka'),
            'options'  => array(
                'style-1' => esc_html__('Style 1', 'floka'),
                'style-2' => esc_html__('Style 2', 'floka'),
            ),
            'default'  => 'style-1',
            'required' => array( 0 => 'site_loader', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'       => 'site_loader_icon',
            'type'     => 'media',
            'title'    => esc_html__('Site Loader Icon', 'floka'),
            'default' => '',
            'url'      => false,
            'required' => array( 0 => 'site_loader', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'       => 'mouse_move_animation',
            'type'     => 'button_set',
            'title'    => esc_html__('Mouse Move Animation', 'floka'),
            'options'  => array(
                'on' => esc_html__('On', 'floka'),
                'off' => esc_html__('Off', 'floka'),
            ),
            'default'  => 'off',
        ),
        array(
            'id'       => 'smooth_scroll',
            'type'     => 'button_set',
            'title'    => esc_html__('Smooth Scroll', 'floka'),
            'options'  => array(
                'on' => esc_html__('On', 'floka'),
                'off' => esc_html__('Off', 'floka'),
            ),
            'default'  => 'off',
        ),

        array(
            'id'       => 'subscribe',
            'type'     => 'button_set',
            'title'    => esc_html__('Subscribe', 'floka'),
            'options'  => array(
                'show' => esc_html__('Show', 'floka'),
                'hide' => esc_html__('Hide', 'floka'),
            ),
            'default'  => 'hide',
        ),
        array(
            'id'      => 'subscribe_layout',
            'type'    => 'select',
            'title'   => esc_html__('Subscribe Layout', 'floka'),
            'desc'    => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','floka'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '">','</a>'),
            'options' => floka_get_templates_option('popup'),
            'required' => array( 0 => 'subscribe', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'    => 'popup_effect',
            'type'  => 'select',
            'title' => esc_html__('Subscribe Popup Effect', 'floka'),
            'options' => [
                'fade'           => esc_html__('Fade', 'floka'),
                'fade-slide'           => esc_html__('Fade Slide', 'floka'),
                'zoom'           => esc_html__('Zoom', 'floka'),
            ],
            'default' => 'fade',
            'required' => array( 0 => 'subscribe', 1 => 'equals', 2 => 'show' ),
        ),
    )
));

/* Search Popup */
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Search Popup', 'floka'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'logo_s',
            'type'     => 'media',
            'title'    => esc_html__('Logo Search Popup', 'floka'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/img/logo.png'
            ),
        ),
        array(
            'id'      => 'placeholder_search_pu',
            'type'    => 'text',
            'title'   => esc_html__('Placeholder', 'floka'),
            'default' => 'Type Your Search Words...',
        )
    )
));
/* End Search Popup */

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'floka'),
    'icon'   => 'el el-indent-left',
    'fields' => array_merge(
        floka_header_opts(),
        array(
            array(
                'id'       => 'sticky_scroll',
                'type'     => 'button_set',
                'title'    => esc_html__('Sticky Scroll', 'floka'),
                'options'  => array(
                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'floka'),
                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'floka'),
                ),
                'default'  => 'pxl-sticky-stt',
            ),
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Mobile', 'floka'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array_merge(
        floka_header_mobile_opts(),
        array(
            array(
                'id'       => 'mobile_display',
                'type'     => 'button_set',
                'title'    => esc_html__('Display', 'floka'),
                'options'  => array(
                    'show'  => esc_html__('Show', 'floka'),
                    'hide'  => esc_html__('Hide', 'floka'),
                ),
                'default'  => 'show'
            ),
            array(
                'id'       => 'opt_mobile_style',
                'type'     => 'button_set',
                'title'    => esc_html__('Style', 'floka'),
                'options'  => array(
                    'light'  => esc_html__('Light', 'floka'),
                    'dark'  => esc_html__('Dark', 'floka'),
                ),
                'default'  => 'light',
                'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
            ),
            array(
                'id'       => 'logo_m',
                'type'     => 'media',
                'title'    => esc_html__('Logo Dark in Menu Sidebar', 'floka'),
                'default' => array(
                    'url'=>get_template_directory_uri().'/assets/img/logo.png'
                ),
                'url'      => false,
                'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
            ),
            array(
                'id'       => 'logo_light_m',
                'type'     => 'media',
                'title'    => esc_html__('Logo Light in Menu Sidebar', 'floka'),
                'default' => array(
                    'url'=>get_template_directory_uri().'/assets/img/logo-light.png'
                ),
                'url'      => false,
                'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
            ),
            array(
                'id'       => 'logo_height',
                'type'     => 'dimensions',
                'title'    => esc_html__('Logo Height', 'floka'),
                'width'    => false,
                'unit'     => 'px',
                'output'    => array('#pxl-header-default .pxl-header-branding img, #pxl-header-default #pxl-header-mobile .pxl-header-branding img, #pxl-header-elementor #pxl-header-mobile .pxl-header-branding img, .pxl-logo-mobile img'),
                'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
            ),
            array(
                'id'       => 'search_mobile',
                'type'     => 'switch',
                'title'    => esc_html__('Search Form', 'floka'),
                'default'  => true,
                'required' => array( 0 => 'mobile_display', 1 => 'equals', 2 => 'show' ),
            ),
            array(
                'id'      => 'search_placeholder_mobile',
                'type'    => 'text',
                'title'   => esc_html__('Search Text Placeholder', 'floka'),
                'default' => '',
                'subtitle' => esc_html__('Default: Search...', 'floka'),
                'required' => array( 0 => 'search_mobile', 1 => 'equals', 2 => true ),
            )
        )
    )
));


/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'floka'),
    'icon'   => 'el el-website',
    'fields' => array_merge(
        floka_footer_opts(),
        array(
            array(
                'id'       => 'back_totop_on',
                'type'     => 'switch',
                'title'    => esc_html__('Button Back to Top', 'floka'),
                'default'  => false,
            ),
            array(
                'id'       => 'footer_fixed',
                'type'     => 'button_set',
                'title'    => esc_html__('Footer Fixed', 'floka'),
                'options'  => array(
                    'on' => esc_html__('On', 'floka'),
                    'off' => esc_html__('Off', 'floka'),
                ),
                'default'  => 'off',
            ),
        ) 
    )
    
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'floka'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array_merge(
        floka_page_title_opts(),
        array(
            array(
                'id'       => 'ptitle_scroll_opacity',
                'title'    => esc_html__('Scroll Opacity', 'floka'),
                'type'     => 'switch',
                'default'  => false,
            ),
        )
    )
));

/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog', 'floka'),
    'icon'  => 'el el-edit',
    'fields'     => array(
    )
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog Archive', 'floka'),
    'icon'  => 'el-icon-pencil',
    'subsection' => true,
    'fields'     => array_merge(
        floka_sidebar_pos_opts([ 'prefix' => 'blog_']),
        array(
            array(
                'id'       => 'archive_author',
                'title'    => esc_html__('Author', 'floka'),
                'subtitle' => esc_html__('Display the Author for each blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'      => 'featured_img_size',
                'type'    => 'text',
                'title'   => esc_html__('Featured Image Size', 'floka'),
                'default' => '',
                'subtitle' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
            ),
            array(
                'id'      => 'archive_excerpt_length',
                'type'    => 'text',
                'title'   => esc_html__('Excerpt Length', 'floka'),
                'default' => '',
                'subtitle' => esc_html__('Default: 50', 'floka'),
            ),
            array(
                'id'      => 'archive_readmore_text',
                'type'    => 'text',
                'title'   => esc_html__('Read More Text', 'floka'),
                'default' => '',
                'subtitle' => esc_html__('Default: Read more', 'floka'),
            ),
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'floka'),
    'icon'       => 'el el-icon-pencil',
    'subsection' => true,
    'fields'     => array_merge(
        floka_sidebar_pos_opts([ 'prefix' => 'post_']),
        floka_post_title_opts('post'),
        array(
            array(
                'id'       => 'sg_post_title',
                'type'     => 'button_set',
                'title'    => esc_html__('Page Title Type', 'floka'),
                'options'  => array(
                    'default' => esc_html__('Default', 'floka'),
                    'custom_text' => esc_html__('Custom Text', 'floka'),
                ),
                'default'  => 'default',
            ),
            array(
                'id'      => 'sg_post_title_text',
                'type'    => 'text',
                'title'   => esc_html__('Page Title Text', 'floka'),
                'default' => 'Blog Details',
                'required' => array( 0 => 'sg_post_title', 1 => 'equals', 2 => 'custom_text' ),
            ),
            array(
                'id'      => 'sg_featured_img_size',
                'type'    => 'text',
                'title'   => esc_html__('Featured Image Size', 'floka'),
                'default' => '',
                'subtitle' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
            ),
            array(
             'id'       => 'blog_page',
             'title'    => esc_html__('Back to Blog Page', 'floka'),
             'type'     => 'switch',
             'default'  => false
         ),
            array(
                'id'       => 'link_blog_page',
                'title'    => esc_html__('Link Blog Page', 'floka'),
                'type'     => 'text',
                'default'  => '#',
                'indent' => true,
                'required' => array( 0 => 'blog_page', 1 => 'equals', 2 => '1' ),
            ),

            array(
                'id'       => 'post_date',
                'title'    => esc_html__('Date', 'floka'),
                'subtitle' => esc_html__('Display the Date for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_author',
                'title'    => esc_html__('Author', 'floka'),
                'subtitle' => esc_html__('Display the Author for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_comment',
                'title'    => esc_html__('Comment', 'floka'),
                'subtitle' => esc_html__('Display the Comment for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_category',
                'title'    => esc_html__('Category', 'floka'),
                'subtitle' => esc_html__('Display the Category for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_tag',
                'title'    => esc_html__('Tags', 'floka'),
                'subtitle' => esc_html__('Display the Tag for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_navigation',
                'title'    => esc_html__('Navigation', 'floka'),
                'subtitle' => esc_html__('Display the Navigation for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => false,
            ),
            array(
                'title' => esc_html__('Social', 'floka'),
                'type'  => 'section',
                'id' => 'social_section',
                'indent' => true,
            ),
            array(
                'id'       => 'post_social_share',
                'title'    => esc_html__('Social', 'floka'),
                'subtitle' => esc_html__('Display the Social Share for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => false,
            ),
            array(
                'id'       => 'social_facebook',
                'title'    => esc_html__('Facebook', 'floka'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_twitter',
                'title'    => esc_html__('Twitter', 'floka'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_behance',
                'title'    => esc_html__('Behance', 'floka'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_youtube',
                'title'    => esc_html__('Youtube', 'floka'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'copy_link',
                'title'    => esc_html__('Copy Link', 'floka'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'title' => esc_html__('Author Info', 'floka'),
                'type'  => 'section',
                'id' => 'author_section',
                'indent' => true,
            ),
            array(
                'id'       => 'post_author_info',
                'title'    => esc_html__('Author Box', 'floka'),
                'subtitle' => esc_html__('Display the Author Info for blog post.', 'floka'),
                'type'     => 'switch',
                'default'  => false,
            ),

            array(
                'id'       => 'description_ai',
                'title'    => esc_html__('Description', 'floka'),
                'type'     => 'button_set',
                'options'  => array(
                    'default'   => esc_html__('Default','floka'),
                    'custom_text'   => esc_html__('Custom Text','floka'),
                ),
                'default'  => 'default',
                'indent' => true,
                'required' => array( 0 => 'post_author_info', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'      => 'description_ai_custom_text',
                'type'    => 'textarea',
                'title'   => esc_html__('Description Custom', 'floka'),
                'indent' => true,
                'required' => array( 0 => 'description_ai', 1 => 'equals', 2 => 'custom_text' ),
            ),
            array(
                'title' => esc_html__('Related/Latest Articles', 'floka'),
                'type'  => 'section',
                'id' => 'author_section',
                'indent' => true,
            ),
            array(
                'id'       => 'post_related',
                'title'    => esc_html__('Related Articles', 'floka'),
                'type'     => 'switch',
                'default'  => true,
            ),
        )
)
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Portfolio', 'floka'),
    'icon'       => 'el el-briefcase',
    'fields'     => array_merge(
        floka_post_title_opts('portfolio'),
        array(
            array(
                'id'       => 'portfolio_display',
                'type'     => 'button_set',
                'title'    => esc_html__('Portfolio', 'floka'),
                'options'  => array(
                    'on' => esc_html__('On', 'floka'),
                    'off' => esc_html__('Off', 'floka'),
                ),
                'default'  => 'on',
            ),
            array(
                'id'       => 'sg_portfolio_title',
                'type'     => 'button_set',
                'title'    => esc_html__('Page Title Type', 'floka'),
                'options'  => array(
                    'default' => esc_html__('Default', 'floka'),
                    'custom_text' => esc_html__('Custom Text', 'floka'),
                ),
                'default'  => 'default',
                'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'      => 'sg_portfolio_title_text',
                'type'    => 'text',
                'title'   => esc_html__('Page Title Text', 'floka'),
                'default' => 'Single Portfolio',
                'required' => array( 0 => 'sg_portfolio_title', 1 => 'equals', 2 => 'custom_text' ),
            ),
            array(
                'id'      => 'portfolio_slug',
                'type'    => 'text',
                'title'   => esc_html__('Portfolio Slug', 'floka'),
                'default' => '',
                'desc'     => 'Default: portfolio',
                'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'      => 'portfolio_name',
                'type'    => 'text',
                'title'   => esc_html__('Portfolio Name', 'floka'),
                'default' => '',
                'desc'     => 'Default: Portfolio',
                'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'    => 'archive_portfolio_link',
                'type'  => 'select',
                'title' => esc_html__( 'Custom Archive Page Link', 'floka' ), 
                'data'  => 'page',
                'args'  => array(
                    'post_type'      => 'page',
                    'posts_per_page' => -1,
                    'orderby'        => 'title',
                    'order'          => 'ASC',
                ),
                'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Service', 'floka'),
    'icon'       => 'el el-cog',
    'fields'     => array_merge(
        floka_post_title_opts('service'),
        array(
            array(
                'id'       => 'service_display',
                'type'     => 'button_set',
                'title'    => esc_html__('Service', 'floka'),
                'options'  => array(
                    'on' => esc_html__('On', 'floka'),
                    'off' => esc_html__('Off', 'floka'),
                ),
                'default'  => 'on',
            ),

            array(
                'id'       => 'sg_service_title',
                'type'     => 'button_set',
                'title'    => esc_html__('Page Title Type', 'floka'),
                'options'  => array(
                    'default' => esc_html__('Default', 'floka'),
                    'custom_text' => esc_html__('Custom Text', 'floka'),
                ),
                'default'  => 'default',
                'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'      => 'sg_service_title_text',
                'type'    => 'text',
                'title'   => esc_html__('Page Title Text', 'floka'),
                'default' => 'Single Service',
                'required' => array( 0 => 'sg_service_title', 1 => 'equals', 2 => 'custom_text' ),
            ),
            array(
                'id'      => 'service_slug',
                'type'    => 'text',
                'title'   => esc_html__('Service Slug', 'floka'),
                'default' => '',
                'desc'     => 'Default: service',
                'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'      => 'service_name',
                'type'    => 'text',
                'title'   => esc_html__('Service Name', 'floka'),
                'default' => '',
                'desc'     => 'Default: Services',
                'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'    => 'archive_service_link',
                'type'  => 'select',
                'title' => esc_html__( 'Custom Archive Page Link', 'floka' ), 
                'data'  => 'page',
                'args'  => array(
                    'post_type'      => 'page',
                    'posts_per_page' => -1,
                    'orderby'        => 'title',
                    'order'          => 'ASC',
                ),
                'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Careers', 'floka'),
    'icon'       => 'el el-cog',
    'fields'     => array_merge(
        floka_post_title_opts('careers'),
        array(
            array(
                'id'       => 'careers_display',
                'type'     => 'button_set',
                'title'    => esc_html__('Careers', 'floka'),
                'options'  => array(
                    'on' => esc_html__('On', 'floka'),
                    'off' => esc_html__('Off', 'floka'),
                ),
                'default'  => 'on',
            ),

            array(
                'id'       => 'sg_careers_title',
                'type'     => 'button_set',
                'title'    => esc_html__('Page Title Type', 'floka'),
                'options'  => array(
                    'default' => esc_html__('Default', 'floka'),
                    'custom_text' => esc_html__('Custom Text', 'floka'),
                ),
                'default'  => 'default',
                'required' => array( 0 => 'careers_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'      => 'sg_careers_title_text',
                'type'    => 'text',
                'title'   => esc_html__('Page Title Text', 'floka'),
                'default' => 'Single Careers',
                'required' => array( 0 => 'sg_careers_title', 1 => 'equals', 2 => 'custom_text' ),
            ),
            array(
                'id'      => 'careers_slug',
                'type'    => 'text',
                'title'   => esc_html__('Careers Slug', 'floka'),
                'default' => '',
                'desc'     => 'Default: careers',
                'required' => array( 0 => 'careers_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'      => 'careers_name',
                'type'    => 'text',
                'title'   => esc_html__('Careers Name', 'floka'),
                'default' => '',
                'desc'     => 'Default: Careers',
                'required' => array( 0 => 'careers_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
            array(
                'id'    => 'archive_careers_link',
                'type'  => 'select',
                'title' => esc_html__( 'Custom Archive Page Link', 'floka' ), 
                'data'  => 'page',
                'args'  => array(
                    'post_type'      => 'page',
                    'posts_per_page' => -1,
                    'orderby'        => 'title',
                    'order'          => 'ASC',
                ),
                'required' => array( 0 => 'careers_display', 1 => 'equals', 2 => 'on' ),
                'force_output' => true
            ),
        ),
    )
));

/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'floka'),
        'icon'   => 'el el-shopping-cart',
    ));

    Redux::setSection($opt_name, array(
        'title' => esc_html__('Product Archive', 'floka'),
        'icon'  => 'el-icon-pencil',
        'subsection' => true,
        'fields'     => array_merge(
            floka_sidebar_pos_opts([ 'prefix' => 'shop_']),
            array(
                array(
                    'id'      => 'shop_featured_img_size',
                    'type'    => 'text',
                    'title'   => esc_html__('Featured Image Size', 'floka'),
                    'default' => '',
                    'subtitle' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                ),
                array(
                    'id'          => 'number_of_words_excerpt',
                    'type'        => 'text', 
                    'input_type'  => 'number', 
                    'title'       => esc_html__( 'Number of word s in short description', 'floka' ),
                    'default'     => 25,
                ),
                
                array(
                    'title'         => esc_html__('Product Grid Layout', 'floka'),
                    'id'            => 'products_columns',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Display products in a row', 'floka'),
                    'default'       => 1,
                    'min'           => 1,
                    'step'          => 1,
                    'max'           => 5,
                    'display_value' => 'text',
                ),
                array(
                    'title'         => esc_html__('Product List Layout', 'floka'),
                    'id'            => 'products_columns2',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Display products in a row', 'floka'),
                    'default'       => 3,
                    'min'           => 1,
                    'step'          => 1,
                    'max'           => 5,
                    'display_value' => 'text',
                ),
                array(
                    'title'         => esc_html__('Products displayed per page', 'floka'),
                    'id'            => 'products_per_page',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Number product to show', 'floka'),
                    'default'       => 9,
                    'min'           => 3,
                    'step'          => 1,
                    'max'           => 50,
                    'display_value' => 'text'
                ),
            )
        )
    ));

    Redux::setSection($opt_name, array(
        'title' => esc_html__('Single Product', 'floka'),
        'icon'  => 'el-icon-pencil',
        'subsection' => true,
        'fields'     => array_merge(
            floka_post_title_opts('product'),
            array(
                array(
                    'id'       => 'single_img_size',
                    'type'     => 'dimensions',
                    'title'    => esc_html__('Image Size', 'floka'),
                    'unit'     => 'px',
                ),
                array(
                    'id'       => 'sg_product_ptitle',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Page Title Type', 'floka'),
                    'options'  => array(
                        'default' => esc_html__('Default', 'floka'),
                        'custom_text' => esc_html__('Custom Text', 'floka'),
                    ),
                    'default'  => 'default',
                ),
                array(
                    'id'      => 'sg_product_ptitle_text',
                    'type'    => 'text',
                    'title'   => esc_html__('Page Title Text', 'floka'),
                    'default' => 'Shop Details',
                    'required' => array( 0 => 'sg_product_ptitle', 1 => 'equals', 2 => 'custom_text' ),
                ),
                array(
                    'id'       => 'product_button_add_to_cart',
                    'type'     => 'text',
                    'title'    => esc_html__('Button Cart Text', 'floka'),
                    'default'  => ''
                ),
                array(
                    'id'       => 'product_social_share',
                    'type'     => 'switch',
                    'title'    => esc_html__('Social Share', 'floka'),
                    'default'  => true
                ),
            )
        )
    ));
}

//Page 404
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Page 404', 'floka'),
    'icon'       => 'el el-website',
    'fields'     => array_merge(
        floka_post_title_opts('404'),
        array(
            array(
                'id'       => 'background_404',
                'type'     => 'media',
                'title'    => esc_html__('Background Image', 'floka'),
            ),
            array(
                'id' => 'title_404',
                'type' => 'text',
                'title' => esc_html__('Title', 'floka'),
            ),
            array(
                'id' => 'description_404',
                'type' => 'text',
                'title' => esc_html__('Description', 'floka'),
            ),
            array(
                'id'       => 'search_bar_404',
                'type'     => 'switch',
                'title'    => esc_html__('Search Bar', 'floka'),
                'default'  => true
            ),

        ),
        
    ),
));
}