<?php
/**
 * @package Case-Themes
 */
?>
<section class="no-results not-found">
    <header class="page-header">
        <h1 class="page-title"><?php pxl_print_html( 'Nothing here', 'floka' ); ?></h1>
    </header><!-- .page-header -->

    <div class="page-content">
        <?php
        if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

            <?php echo esc_html__('Ready to publish your first post?', 'floka'); ?>
            <a href="<?php echo esc_url( admin_url( 'post-new.php' ) ); ?>"><?php echo esc_html__('Get started here', 'floka'); ?></a>

        <?php elseif ( is_search() ) : ?>

            <p><?php pxl_print_html( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'floka' ); ?></p>
            <?php
            get_search_form();

        else : ?>

            <p><?php pxl_print_html( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'floka' ); ?></p>
            <?php
            get_search_form();

        endif; ?>
    </div><!-- .page-content -->
</section><!-- .no-results -->