<?php

// Get count item in cart
function get_count_items() {
	global $woocommerce;
	return (count(WC()->cart->get_cart()) > 0) ? count(WC()->cart->get_cart()) : 0;
}


// Chang text shipping in cart form 
add_filter( 'gettext', 'customize_no_shipping_text', 20, 3 );
function customize_no_shipping_text( $translated_text, $text, $domain ) {
	if ( $translated_text === 'No shipping options were found for %s.' ) {
		$translated_text = esc_html__( 'Enter your adress to view shipping options.', 'floka' );
	}
	return $translated_text;
}

add_filter( 'gettext', 'customize_button_shipping_text', 25, 3 );
function customize_button_shipping_text( $translated_text, $text, $domain ) {
	if ( $translated_text === 'Enter a different address' ) {
		$translated_text = esc_html__( 'Calculate Shipping', 'floka' );
	}
	return $translated_text;
}


//Custom products layout on archive page
add_filter( 'loop_shop_columns', 'floka_loop_shop_columns', 20 ); 
function floka_loop_shop_columns() {
	$columns = isset($_GET['col']) ? sanitize_text_field($_GET['col']) : floka()->get_theme_opt('products_columns', 4);
	return $columns;
}


// Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'floka_loop_shop_per_page', 20 );
function floka_loop_shop_per_page( $limit ) {
	$limit = floka()->get_theme_opt('products_per_page', 9);
	return $limit;
}


/* Remove result count & product ordering & item product category..... */
function floka_cwoocommerce_remove_function() {
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10, 0 );
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5, 0 );
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10, 0 );
	remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10, 0 );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10, 0 );
	remove_action( 'woocommerce_before_shop_loop' , 'woocommerce_catalog_ordering', 30 );
	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

	remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 1);
	remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_sale_flash', 15);

	remove_action( 'woocommerce_single_product_summary' , 'woocommerce_template_single_title', 5 );
	remove_action( 'woocommerce_single_product_summary' , 'woocommerce_template_single_rating', 10 );
	remove_action( 'woocommerce_single_product_summary' , 'woocommerce_template_single_price', 10 );
	remove_action( 'woocommerce_single_product_summary' , 'woocommerce_template_single_excerpt', 20 );
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
	remove_action( 'woocommerce_single_product_summary' , 'woocommerce_template_single_sharing', 50 );


}
add_action( 'init', 'floka_cwoocommerce_remove_function' );

/* Product Category */
add_action( 'woocommerce_before_shop_loop', 'floka_woocommerce_nav_top', 2 );
function floka_woocommerce_nav_top() { 
	$grid_col = floka()->get_theme_opt('products_columns1', 3);
	$list_col = floka()->get_theme_opt('products_columns2', 2);
	?>
	<div class="woocommerce-topbar">
		<div class="woocommerce-topbar-group">
			<div class="woocommerce-layout-types">
				<button class="woocommerce-layout-grid btn-change-layout active" data-layout = "grid <?php echo esc_attr('columns-'.$grid_col); ?>">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="13" viewBox="0 0 16 13" fill="none">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M0 -0.00012207H4V2.99988H0V-0.00012207ZM6 -0.00012207H10V2.99988H6V-0.00012207ZM16 -0.00012207H11V2.99988H16V-0.00012207ZM0 4.99988H4V7.99988H0V4.99988ZM10 4.99988H6V7.99988H10V4.99988ZM11 4.99988H16V7.99988H11V4.99988ZM4 9.99988H0V12.9999H4V9.99988ZM6 9.99988H10V12.9999H6V9.99988ZM16 9.99988H11V12.9999H16V9.99988Z" fill="#B0B6BC"/>
					</svg>
				</button>
				<button class="woocommerce-layout-list btn-change-layout" data-layout = "list <?php echo esc_attr('columns-'.$list_col); ?>">
					<svg xmlns="http://www.w3.org/2000/svg" width="15" height="13" viewBox="0 0 15 13" fill="none">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M1.5 2.99988C2.32843 2.99988 3 2.32831 3 1.49988C3 0.671451 2.32843 -0.00012207 1.5 -0.00012207C0.671573 -0.00012207 0 0.671451 0 1.49988C0 2.32831 0.671573 2.99988 1.5 2.99988ZM1.5 7.99988C2.32843 7.99988 3 7.32831 3 6.49988C3 5.67145 2.32843 4.99988 1.5 4.99988C0.671573 4.99988 0 5.67145 0 6.49988C0 7.32831 0.671573 7.99988 1.5 7.99988ZM3 11.4999C3 12.3283 2.32843 12.9999 1.5 12.9999C0.671573 12.9999 0 12.3283 0 11.4999C0 10.6715 0.671573 9.99988 1.5 9.99988C2.32843 9.99988 3 10.6715 3 11.4999ZM15 -0.00012207H4V2.99988H15V-0.00012207ZM4 4.99988H15V7.99988H4V4.99988ZM15 9.99988H4V12.9999H15V9.99988Z" fill="#B0B6BC"/>
					</svg>
				</button>
			</div>
			<?php woocommerce_result_count(); ?>
		</div>
		<div class="woocommerce-topbar-ordering">
			<?php woocommerce_catalog_ordering(); ?>
		</div>
	</div>
<?php }

add_filter( 'woocommerce_price_filter_widget_min_amount', 'floka_custom_price_filter_min', 10, 1 );
function floka_custom_price_filter_min( $min ) {
	return 10; 
}

add_filter( 'woocommerce_price_filter_widget_max_amount', 'floka_custom_price_filter_max', 10, 1 );
function floka_custom_price_filter_max( $max ) {
	return 220; 
}

function display_new_badge_on_products() {
	global $product;
	$newness_days = 30;
	$created = strtotime( $product->get_date_created() );
	$html = '';
	if ( ( time() - ( 60 * 60 * 24 * $newness_days ) ) < $created ) {
		$html = '<span class="new">' . esc_html__( 'New', 'floka' ) . '</span>';
	}
	return $html;
}

function display_rating($product) {
	$rating_count = $product->get_rating_count();
	$average_rating = $product->get_average_rating();
	$html = '<div class="woocommerce-rating">';
	if($rating_count == 0) {
		$html .= '<div class="rating-star">';
		for($i=0 ; $i<5; $i++) {
			$html .= '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="16" viewBox="0 0 18 16" fill="none">
			<path d="M16.4443 5.50833L12.1652 4.87668L10.2527 0.950354C9.90997 0.250496 8.91708 0.2416 8.57147 0.950354L6.65891 4.87668L2.3798 5.50833C1.61243 5.62102 1.3049 6.57887 1.86139 7.12749L4.95722 10.182L4.225 14.4968C4.0932 15.2767 4.9045 15.8609 5.584 15.4961L9.41206 13.4588L13.2401 15.4961C13.9196 15.8579 14.7309 15.2767 14.5991 14.4968L13.8669 10.182L16.9627 7.12749C17.5192 6.57887 17.2117 5.62102 16.4443 5.50833ZM12.3585 9.68375L13.0527 13.788L9.41206 11.8515L5.77145 13.788L6.4656 9.68375L3.51914 6.77756L7.59029 6.17853L9.41206 2.442L11.2338 6.17853L15.305 6.77756L12.3585 9.68375Z" fill="#FEC51B"/>
			</svg>';
		}
		$html .= '</div>';
	}else {
		$html .= wc_get_rating_html( $average_rating, $rating_count);
	}

	$html .= '<span class="rating-count">('.esc_html($rating_count).')</span>';
	$html .= '</div>';
	return pxl_print_html($html);
}

add_filter( 'woocommerce_after_shop_loop_item', 'floka_woocommerce_product' );
function floka_woocommerce_product() {
	global $product;
	$img_size = floka()->get_theme_opt('shop_featured_img_size', '500x500');
	$num_words = floka()->get_theme_opt('number_of_words_excerpt', 25);
	?>
	<div class="woocommerce-product-inner">
		<div class="woocommerce-product-header">
			<a class="woocommerce-product-details" href="<?php the_permalink(); ?>">
				<?php echo woocommerce_get_product_thumbnail($img_size); ?>
			</a>
			<div class="woocommerce-badges">
				<?php pxl_print_html(display_new_badge_on_products($product->get_id())); ?>
				<?php if ($product->is_on_sale()) : ?>
					<span class="onsale"><?php echo esc_html__('Sale', 'floka'); ?></span>
				<?php endif; ?>
			</div>
			<div class="product-action">
				<?php woocommerce_template_loop_add_to_cart(); ?>
			</div>
		</div>
		<div class="woocommerce-product-content">
			<div class="pxl-content-top">				
				<?php display_rating($product); ?>
				<div class="woocommerce-content-main">
					<h5 class="woocommerce-product-title">
						<a href="<?php the_permalink(); ?>" ><?php the_title(); ?></a>
					</h5>
					<div class="woocommerce-product--price">
						<?php woocommerce_template_loop_price(); ?>
					</div>
				</div>
				
			</div>
			<div class="woocommerce-short-description">
				<span class="short-descripion-text">
					<?php echo wp_trim_words( get_the_excerpt($product->get_id()), $num_words, $more = null); ?>
				</span>
			</div>
		</div>
	</div>
<?php }

/* Removes the "shop" title on the main shop page */
add_filter('woocommerce_show_page_title', 'floka_hide_page_title');
function floka_hide_page_title()
{
	return false;
}

/**
 * Modify image width theme support.
 */

add_action( 'woocommerce_before_single_product_summary', 'floka_woocommerce_single_summer_start', 0 );
function floka_woocommerce_single_summer_start() { ?>
	<?php echo '<div class="woocommerce-summary-wrap">'; ?>
<?php }
add_action( 'woocommerce_after_single_product_summary', 'floka_woocommerce_single_summer_end', 5 );
function floka_woocommerce_single_summer_end() { ?>
	<?php echo '</div></div>'; ?>
<?php }

add_action( 'woocommerce_single_product_summary', 'floka_woocommerce_sg_product_rating', 5 );
function floka_woocommerce_sg_product_rating() { global $product; ?>
	<div class="woocommerce-sg-product-rating">
		<?php woocommerce_template_single_rating(); ?>
	</div>
<?php }

add_action( 'woocommerce_single_product_summary', 'floka_woocommerce_sg_product_title', 10 );
function floka_woocommerce_sg_product_title() { 
	global $product; 
	?>
	<div class="woocommerce-sg-product-title">
		<?php woocommerce_template_single_title(); ?>
	</div>
<?php  }

add_action( 'woocommerce_single_product_summary', 'floka_woocommerce_sg_product_price', 15 );
function floka_woocommerce_sg_product_price() { ?>
	<div class="woocommerce-sg-product-price">
		<?php woocommerce_template_single_price(); ?>
	</div>
<?php }

add_action( 'woocommerce_single_product_summary', 'floka_woocommerce_sg_product_excerpt', 20 );
function floka_woocommerce_sg_product_excerpt() { ?>
	<div class="woocommerce-sg-product-excerpt">
		<?php woocommerce_template_single_excerpt(); ?>
	</div>
<?php }

add_action('woocommerce_before_add_to_cart_quantity', 'add_label_quantity', 25);
function add_label_quantity() {
	?>
	<h6 class="woocomerce-label--quantity"><?php echo esc_html('Quantity:', 'floka'); ?></h6>
	<?php
}

add_action('woocommerce_product_single_add_to_cart_text', 'custom_add_to_cart_button_text', 30); 
function custom_add_to_cart_button_text() {
	return __('Add To Cart', 'floka'); 
}

add_action('woocommerce_single_product_summary','floka_single_product_meta_before', 40);
function floka_single_product_meta_before() {
	global $product;
	echo '<div class="woocommerce-product-info-meta product_meta">';
	if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>
		<div class="sku_wrapper"><?php esc_html_e( 'SKU:', 'floka' ); ?> <span class="sku"><?php echo floka_html($product->get_sku()); ?></span></div>
<?php endif;
echo wc_get_product_tag_list( $product->get_id(), '', '<div class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'floka' ) . ' ', '</div>' );
}

add_action( 'woocommerce_single_product_summary', 'floka_woocommerce_sg_social_share', 40 );
function floka_woocommerce_sg_social_share() { 
	$product_social_share = floka()->get_theme_opt( 'product_social_share', false );
	if($product_social_share) : ?>
		<div class="woocommerce-social-share">
			<label><?php echo esc_html__('Share:', 'floka'); ?></label>
			<a class="fb-social" title="<?php echo esc_attr__('Facebook', 'floka'); ?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>"><i class="caseicon-facebook"></i></a>
			<a class="tw-social" title="<?php echo esc_attr__('Twitter', 'floka'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php echo urlencode(get_permalink()); ?>&text=<?php echo urlencode(get_the_title()); ?>"><i class="caseicon-twitter"></i></a>
			<a class="insta-social" title="<?php echo esc_attr__('Instagram', 'floka'); ?>" target="_blank" href="https://www.instagram.com/?url=<?php echo urlencode(get_permalink()); ?>"><i class="fab fa-instagram"></i></a>
			<a class="yt-social" title="<?php echo esc_attr__('YouTube', 'floka'); ?>" target="_blank" href="https://www.youtube.com/share?url=<?php echo urlencode(get_permalink()); ?>"><i class="fab fa-youtube"></i></a>
			<a class="pin-social" title="<?php echo esc_attr__('Pinterest', 'floka'); ?>" target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&media=<?php echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>&description=<?php echo urlencode(get_the_title()); ?>"><i class="fab fa-pinterest-p"></i></a>

		</div>
	<?php endif; }


	remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

	add_action('woocommerce_after_single_product', 'custom_output_related_products_outside_summary', 5);
	function custom_output_related_products_outside_summary() {
		woocommerce_output_related_products();
	}


	/* Checkout Page*/
	add_action('woocommerce_before_order_notes', 'custom_content_before_order_notes', 10);
	function custom_content_before_order_notes() {
		echo '<h3 class="wc-block-title">Additional Information</h3>';
	}

// Change button text submit checkout
	add_filter('woocommerce_order_button_text', 'custom_woocommerce_order_button_text');
	function custom_woocommerce_order_button_text() {
		return 'Place Order Now'; 
	}


	add_filter('gettext', 'custom_coupon_message_text', 20, 3);
	function custom_coupon_message_text($translated_text, $text, $domain) {
		if ($text === 'If you have a coupon code, please apply it below.' && $domain === 'woocommerce') {
			$translated_text = 'Have a coupon ?';
		}
		return $translated_text;
	}



	add_action( 'woocommerce_checkout_before_order_review_heading', 'floka_checkout_before_order_review_heading_start', 5 );
	function floka_checkout_before_order_review_heading_start() { ?>
		<?php echo '<div class="pxl-order-review-right"><div class="pxl-order-review-inner">'; ?>
	<?php }

	add_action( 'woocommerce_checkout_after_order_review', 'floka_checkout_after_order_review_end', 5 );
	function floka_checkout_after_order_review_end() { ?>
		<?php echo '</div></div>'; ?>
	<?php }
	/* End Checkout Page*/

	/* Product Single: Gallery */
	add_action( 'woocommerce_before_single_product_summary', 'floka_woocommerce_single_gallery_start', 0 );
	function floka_woocommerce_single_gallery_start() { 
		global $product;
		echo '<div class="woocommerce-gallery"><div class="woocommerce-gallery-inner">';
	}

	add_action( 'woocommerce_before_single_product_summary', 'floka_woocommerce_single_gallery_end', 30 );
	function floka_woocommerce_single_gallery_end() { 
		global $product;
		echo '</div></div><div class="woocommerce-summary-inner">';
	}


	add_action( 'woocommerce_product_thumbnails', 'floka_woocommerce_custom_badge', 30 );
	function floka_woocommerce_custom_badge() { 
		global $product;
		?>
		<div class="woocommerce-badges">
			<?php pxl_print_html(display_new_badge_on_products($product->get_id())); ?>
			<?php if ($product->is_on_sale()) : ?>
				<span class="onsale"><?php echo esc_html__('Sale', 'floka'); ?></span>
			<?php endif; ?>
		</div>
		<?php
	}

	add_filter('woocommerce_review_before_comment_form', 'custom_change_review_title');

	function custom_change_review_title() {
		if (is_product()) {
			$product_id = get_the_ID();
			$reviews_count = get_comments_number($product_id);
			$product_title = get_the_title($product_id);
			$new_title = sprintf('%d reviews for %s', $reviews_count, $product_title);

        // Thay thế tiêu đề hiện tại bằng tiêu đề mới
			echo '<h2 class="woocommerce-reviews-title">' . esc_html($new_title) . '</h2>';
		}
	}



	/* Ajax update cart item */
	add_filter('woocommerce_add_to_cart_fragments', 'floka_woo_mini_cart_item_fragment');
	function floka_woo_mini_cart_item_fragment( $fragments ) {
		global $woocommerce;
		$product_subtitle = floka()->get_page_opt( 'product_subtitle' );
		ob_start();
		?>
		<div class="widget_shopping_cart">
			<div class="widget_shopping_head">
				<div class="pxl-item--close pxl-close pxl-cursor--cta"></div>
				<div class="widget_shopping_title">
					<?php echo esc_html__( 'Cart', 'floka' ); ?> <span class="widget_cart_counter">(<?php echo sprintf (_n( '%d item', '%d items', WC()->cart->cart_contents_count, 'floka' ), WC()->cart->cart_contents_count ); ?>)</span>
				</div>
			</div>
			<div class="widget_shopping_cart_content">
				<?php
				$cart_is_empty = sizeof( $woocommerce->cart->get_cart() ) <= 0;
				?>
				<ul class="cart_list product_list_widget">

					<?php if ( ! WC()->cart->is_empty() ) : ?>

					<?php foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
						$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
						$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

						if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

							$product_name  = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
							$thumbnail     = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
							$product_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
							?>
							<li>
								<?php if(!empty($thumbnail)) : ?>
									<div class="cart-product-image">
										<a href="<?php echo esc_url( $_product->get_permalink( $cart_item ) ); ?>">
											<?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
										</a>
									</div>
								<?php endif; ?>
								<div class="cart-product-meta">
									<h3><a href="<?php echo esc_url( $_product->get_permalink( $cart_item ) ); ?>"><?php echo esc_html($product_name); ?></a></h3>
									<?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); ?>
									<?php
									echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
										'<a href="%s" class="remove_from_cart_button pxl-close" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s"></a>',
										esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
										esc_attr__( 'Remove this item', 'floka' ),
										esc_attr( $product_id ),
										esc_attr( $cart_item_key ),
										esc_attr( $_product->get_sku() )
									), $cart_item_key );
									?>
								</div>	
							</li>
							<?php
						}
					}
					?>

				<?php else : ?>

					<li class="empty">
						<i class="caseicon-shopping-cart-alt"></i>
						<span><?php esc_html_e( 'Your cart is empty', 'floka' ); ?></span>
						<a class="btn btn-shop" href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>"><?php echo esc_html__('Browse Shop', 'floka'); ?></a>
					</li>

				<?php endif; ?>

			</ul><!-- end product list -->
		</div>
		<?php if ( ! WC()->cart->is_empty() ) : ?>
		<div class="widget_shopping_cart_footer">
			<p class="total"><strong><?php esc_html_e( 'Subtotal', 'floka' ); ?>:</strong> <?php echo WC()->cart->get_cart_subtotal(); ?></p>

			<?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>

			<p class="buttons">
				<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="btn btn-shop wc-forward"><?php esc_html_e( 'View Cart', 'floka' ); ?></a>
				<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn checkout wc-forward"><?php esc_html_e( 'Checkout', 'floka' ); ?></a>
			</p>
		</div>
	<?php endif; ?>
</div>
<?php
$fragments['div.widget_shopping_cart'] = ob_get_clean();
return $fragments;
}

/* Ajax update cart total number */

add_filter( 'woocommerce_add_to_cart_fragments', 'floka_woocommerce_sidebar_cart_count_number' );
function floka_woocommerce_sidebar_cart_count_number( $fragments ) {
	ob_start();
	?>
	<span class="widget_cart_counter">(<?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'floka' ), WC()->cart->cart_contents_count ); ?>)</span>
	<?php
	
	$fragments['span.widget_cart_counter'] = ob_get_clean();
	
	return $fragments;
}

add_filter( 'woocommerce_add_to_cart_fragments', 'floka_woocommerce_sidebar_cart_count_number_header' );
function floka_woocommerce_sidebar_cart_count_number_header( $fragments ) {
	ob_start();
	?>
	<span class="widget_cart_counter_header"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'floka' ), WC()->cart->cart_contents_count ); ?></span>
	<?php
	
	$fragments['span.widget_cart_counter_header'] = ob_get_clean();
	
	return $fragments;
}

add_filter( 'woocommerce_add_to_cart_fragments', 'floka_woocommerce_sidebar_cart_count_number_sidebar' );
function floka_woocommerce_sidebar_cart_count_number_sidebar( $fragments ) {
	ob_start();
	?>
	<span class="ct-cart-count-sidebar"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'floka' ), WC()->cart->cart_contents_count ); ?></span>
	<?php
	
	$fragments['span.ct-cart-count-sidebar'] = ob_get_clean();
	
	return $fragments;
}

add_filter( 'woocommerce_output_related_products_args', 'floka_related_products_args', 20 );
function floka_related_products_args( $args ) {
	$args['posts_per_page'] = 4;
	$args['columns'] = 4;
	return $args;
}

/* Pagination Args */
function floka_filter_woocommerce_pagination_args( $array ) { 
	$array['end_size'] = 1;
	$array['mid_size'] = 1;
	return $array; 
}; 
add_filter( 'woocommerce_pagination_args', 'floka_filter_woocommerce_pagination_args', 10, 1 ); 

/* Flex Slider Arrow */
add_filter( 'woocommerce_single_product_carousel_options', 'floka_update_woo_flexslider_options' );
function floka_update_woo_flexslider_options( $options ) {
	$options['directionNav'] = true;
	return $options;
}

/* Single Thumbnail Size */
$single_img_size = floka()->get_theme_opt('single_img_size');
if(!empty($single_img_size['width']) && !empty($single_img_size['height'])) {
	add_filter('woocommerce_get_image_size_single', function ($size) {
		$single_img_size = floka()->get_theme_opt('single_img_size');
		$single_img_size_width = preg_replace('/[^0-9]/', '', $single_img_size['width'] ?? '');
		$single_img_size_height = preg_replace('/[^0-9]/', '', $single_img_size['height'] ?? '');
		$size['width'] = $single_img_size_width;
		$size['height'] = $single_img_size_height;
		$size['crop'] = 1;
		return $size;
	});
}
add_filter('woocommerce_get_image_size_gallery_thumbnail', function ($size) {
	$size['width'] = 300;
	$size['height'] = 300;
	$size['crop'] = 1;
	return $size;
});

add_filter('woocommerce_get_image_size_thumbnail', function ($size) {
	$size['width'] = 600;
	$size['height'] = 506;
	$size['crop'] = 1;
	return $size;
});

// paginate links
add_filter('woocommerce_pagination_args', 'floka_woocommerce_pagination_args');
function floka_woocommerce_pagination_args($default){
	$default = array_merge($default, [
		'prev_text' => '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
		<path d="M14.9941 9.80566H3.00586C2.79492 9.79395 2.61621 9.71777 2.46973 9.57715C2.32324 9.43652 2.25 9.26074 2.25 9.0498C2.25 8.83887 2.32324 8.66309 2.46973 8.52246C2.61621 8.38184 2.79492 8.30566 3.00586 8.29395H14.9941C15.2051 8.30566 15.3838 8.38184 15.5303 8.52246C15.6768 8.66309 15.75 8.83887 15.75 9.0498C15.75 9.26074 15.6768 9.43652 15.5303 9.57715C15.3838 9.71777 15.2051 9.79395 14.9941 9.80566ZM8.0332 13.0225C8.17383 13.1748 8.24414 13.3506 8.24414 13.5498C8.24414 13.749 8.16797 13.9219 8.01562 14.0684C7.86328 14.2148 7.69043 14.2881 7.49707 14.2881C7.30371 14.2881 7.13086 14.2178 6.97852 14.0771L2.47852 9.57715C2.32617 9.4248 2.25 9.24902 2.25 9.0498C2.25 8.85059 2.32617 8.6748 2.47852 8.52246L6.97852 4.02246C7.13086 3.88184 7.30371 3.81152 7.49707 3.81152C7.69043 3.81152 7.86328 3.88477 8.01562 4.03125C8.16797 4.17773 8.24414 4.35059 8.24414 4.5498C8.24414 4.74902 8.17383 4.9248 8.0332 5.07715L4.06055 9.0498L8.0332 13.0225Z" fill="#5C6972"/>
		</svg>',
		'next_text' => '<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none">
		<path d="M3.50586 9.80566H15.4941C15.7051 9.79395 15.8838 9.71777 16.0303 9.57715C16.1768 9.43652 16.25 9.26074 16.25 9.0498C16.25 8.83887 16.1768 8.66309 16.0303 8.52246C15.8838 8.38184 15.7051 8.30566 15.4941 8.29395H3.50586C3.29492 8.30566 3.11621 8.38184 2.96973 8.52246C2.82324 8.66309 2.75 8.83887 2.75 9.0498C2.75 9.26074 2.82324 9.43652 2.96973 9.57715C3.11621 9.71777 3.29492 9.79395 3.50586 9.80566ZM10.4668 13.0225C10.3262 13.1748 10.2559 13.3506 10.2559 13.5498C10.2559 13.749 10.332 13.9219 10.4844 14.0684C10.6367 14.2148 10.8096 14.2881 11.0029 14.2881C11.1963 14.2881 11.3691 14.2178 11.5215 14.0771L16.0215 9.57715C16.1738 9.4248 16.25 9.24902 16.25 9.0498C16.25 8.85059 16.1738 8.6748 16.0215 8.52246L11.5215 4.02246C11.3691 3.88184 11.1963 3.81152 11.0029 3.81152C10.8096 3.81152 10.6367 3.88477 10.4844 4.03125C10.332 4.17773 10.2559 4.35059 10.2559 4.5498C10.2559 4.74902 10.3262 4.9248 10.4668 5.07715L14.4395 9.0498L10.4668 13.0225Z" fill="#5C6972"/>
		</svg>',
		'type'      => 'plain',
	]);
	return $default;
}

// cart link in archive product
add_filter('woocommerce_loop_add_to_cart_link', 'floka_woocommerce_loop_add_to_cart_link', 10, 3);
function floka_woocommerce_loop_add_to_cart_link($button, $product, $args){
	global $woocommerce_loop;
	if ( is_shop() || is_product_category() || is_product_tag() || (isset($woocommerce_loop['name']) && $woocommerce_loop['name'] == 'related') ) { 
		return sprintf(
			'<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
			esc_url( $product->add_to_cart_url() ),
			esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
			esc_attr( isset( $args['class'] ) ? $args['class'] : 'woo-btn' ),
			isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
			'<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.366 0L16.577 5.38395L20 5.38412V7.32012L18.833 7.31993L18.0764 16.1124C18.0332 16.6141 17.5999 17 17.0798 17H2.92014C2.40005 17 1.96678 16.6141 1.92359 16.1124L1.166 7.31993L0 7.32012V5.38412L3.422 5.38395L6.63398 0L8.36602 0.967988L5.732 5.38395H14.267L11.634 0.967988L13.366 0ZM16.826 7.31993L3.173 7.32012L3.84 15.064H16.159L16.826 7.31993ZM11 9.2561V13.128H9.00002V9.2561H11ZM7 9.2561V13.128H5V9.2561H7ZM15 9.2561V13.128H13V9.2561H15Z" fill="currentcolor"/></svg>'
		);
	}
	if(is_product()) {
		$args['class'] .= ' single_add_to_cart_button';
	}
	return sprintf(
		'<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
		esc_url( $product->add_to_cart_url() ),
		esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
		esc_attr( isset( $args['class'] ) ? $args['class'] : 'woo-btn pxl-button' ),
		isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
		'<span class="pxl-button-text">
		Add to cart
		</span>'
	);
}

function custom_woocommerce_review_callback( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	$rating = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div class="custom-review">
			<div class="review-text"><?php comment_text(); ?></div>
			<div class="pxl-holder">
				<div class="review-author"><?php echo get_avatar( $comment, 60 ); ?> <?php printf( '<strong>%s</strong>', get_comment_author() ); ?></div>
				<?php if ( $rating ) : ?>
					<div class="review-rating"><?php echo wc_get_rating_html( $rating ); ?></div>
				<?php endif; ?>
			</div>
		</div>
	</li>
	<?php
}
add_filter( 'woocommerce_product_review_list_args', 'custom_override_review_list_callback' );
function custom_override_review_list_callback( $args ) {
	$args['callback'] = 'custom_woocommerce_review_callback';
	return $args;
}
