<?php
/**
 * Custom Product image
 *
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 9.7.0
 */
global $product, $nasa_opt;

$product_id = $product->get_id();
$post_thumbnail_id = $product->get_image_id();

$attachment_ids = $product->get_gallery_image_ids();
$data_rel = '';

$image_size = apply_filters('woocommerce_gallery_image_size', 'woocommerce_single');
$full_size = apply_filters('woocommerce_gallery_full_size', apply_filters('woocommerce_product_thumbnails_large_size', 'full'));

$image_title = esc_attr(get_the_title($post_thumbnail_id));
$alt_text = trim(wp_strip_all_tags(get_post_meta($post_thumbnail_id, '_wp_attachment_image_alt', true)));

$image_full = wp_get_attachment_image_src($post_thumbnail_id, $full_size);
$image_link = isset($image_full[0]) ? $image_full[0] : wp_get_attachment_url($post_thumbnail_id);
$image_large = wp_get_attachment_image_src($post_thumbnail_id, $image_size);
$src_large = isset($image_large[0]) ? $image_large[0] : $image_link;

$image = wp_get_attachment_image(
    $post_thumbnail_id,
    $image_size,
    false,
    apply_filters(
        'woocommerce_gallery_image_html_attachment_image_params',
        array(
            'title'                   => _wp_specialchars(get_post_field('post_title', $post_thumbnail_id), ENT_QUOTES, 'UTF-8', true),
            'alt'                     => $alt_text,
            'data-caption'            => _wp_specialchars(get_post_field('post_excerpt', $post_thumbnail_id), ENT_QUOTES, 'UTF-8', true),
            'data-src'                => esc_url($image_full[0]),
            'data-large_image'        => esc_url($image_full[0]),
            'data-large_image_width'  => esc_attr($image_full[1]),
            'data-large_image_height' => esc_attr($image_full[2]),
            'class'                   => 'wp-post-image skip-lazy attachment-shop_single size-shop_single',
        ),
        $post_thumbnail_id,
        $image_size,
        true
    )
);

$attachment_count = count($attachment_ids);

$classMain = 'nasa-main-wrap rtl-left';
$slideHoz = false;
if (isset($nasa_opt['product_detail_layout']) && $nasa_opt['product_detail_layout'] === 'classic' && isset($nasa_opt['product_thumbs_style']) && $nasa_opt['product_thumbs_style'] === 'hoz') {
    $slideHoz = true;
}
$classMain .= $slideHoz ? ' nasa-thumbnail-hoz' : ' nasa-thumbnail-ver';

$wrapper_classes = apply_filters(
    'woocommerce_single_product_image_gallery_classes',
    array(
        'woocommerce-product-gallery',
        'woocommerce-product-gallery--' . ($post_thumbnail_id ? 'with-images' : 'without-images'),
        'images',
    )
);
?>
<div class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $wrapper_classes))); ?>">
    <div class="row">
        <div class="large-12 columns">
            <?php if (!$slideHoz && (!isset($nasa_opt['nasa_in_mobile']) || !$nasa_opt['nasa_in_mobile'])) : ?>
                <div class="nasa-thumb-wrap rtl-right">
                    <?php do_action('woocommerce_product_thumbnails'); ?>
                </div>
            <?php endif; ?>
            
            <div class="nasa-main-wrap rtl-left<?php echo esc_attr($classMain); ?>">
                <div class="product-images-slider images-popups-gallery">
                    <div class="nasa-main-image-default-wrap">
                        <div class="main-images nasa-single-product-main-image nasa-main-image-default">
                            <div class="item-wrap">
                                <div class="nasa-item-main-image-wrap" id="nasa-main-image-0" data-key="0">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="easyzoom first">
                                            <?php
                                            echo apply_filters(
                                                'woocommerce_single_product_image_thumbnail_html',
                                                sprintf(
                                                    '<a href="%s" class="woocommerce-main-image product-image woocommerce-product-gallery__image" data-o_href="%s" data-full_href="%s" title="%s">%s</a>',
                                                    $image_link,
                                                    $src_large,
                                                    $image_link,
                                                    $image_title,
                                                    $image
                                                ),
                                                $post_thumbnail_id
                                            ); ?>
                                        </div>
                                    <?php else :
                                        $noimage = wc_placeholder_img_src();
                                        ?>
                                        <div class="easyzoom">
                                            <?php echo apply_filters(
                                                'woocommerce_single_product_image_thumbnail_html',
                                                sprintf(
                                                    '<div class="woocommerce-main-image product-image woocommerce-product-gallery__image woocommerce-product-gallery__image--placeholder"><img src="%s" alt="%s" class="wp-post-image" /></div>',
                                                        esc_url(wc_placeholder_img_src('woocommerce_single')),
                                                        esc_html__('Awaiting product image', 'flozen-theme')
                                                    ),
                                                $post_thumbnail_id
                                            ); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php
                            $_i = 0;
                            if ($attachment_count > 0) :
                                foreach ($attachment_ids as $attachment_id) :
                                    $_i++;
                                    ?>
                                    <div class="item-wrap">
                                        <div class="nasa-item-main-image-wrap" id="nasa-main-image-<?php echo absint($_i); ?>" data-key="<?php echo absint($_i); ?>">
                                            <div class="easyzoom">
                                                <?php
                                                $image_title = esc_attr(get_the_title($attachment_id));
                                                $alt_text = trim(wp_strip_all_tags(get_post_meta($attachment_id, '_wp_attachment_image_alt', true)));
                                                
                                                $image_full = wp_get_attachment_image_src($attachment_id, $full_size);
                                                $image_link = isset($image_full[0]) ? $image_full[0] : wp_get_attachment_url($attachment_id);
                                                
                                                $image = wp_get_attachment_image(
                                                    $attachment_id,
                                                    $image_size,
                                                    false,
                                                    apply_filters(
                                                        'woocommerce_gallery_image_html_attachment_image_params',
                                                        array(
                                                            'title'                   => _wp_specialchars(get_post_field('post_title', $attachment_id), ENT_QUOTES, 'UTF-8', true),
                                                            'alt'                     => $alt_text,
                                                            'data-caption'            => _wp_specialchars(get_post_field('post_excerpt', $attachment_id), ENT_QUOTES, 'UTF-8', true),
                                                            'data-src'                => esc_url($image_full[0]),
                                                            'data-large_image'        => esc_url($image_full[0]),
                                                            'data-large_image_width'  => esc_attr($image_full[1]),
                                                            'data-large_image_height' => esc_attr($image_full[2]),
                                                            'class'                   => 'skip-lazy attachment-shop_single size-shop_single',
                                                        ),
                                                        $post_thumbnail_id,
                                                        $image_size,
                                                        false
                                                    )
                                                );
                                                
                                                $image = $image ? $image : wc_placeholder_img('woocommerce_single');
                                                
                                                echo sprintf(
                                                    '<a href="%s" class="woocommerce-additional-image product-image" title="%s">%s</a>',
                                                    $image_link,
                                                    $image_title,
                                                    $image
                                                );
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                endforeach;
                            endif;
                            ?>
                        </div>
                    </div>

                    <div class="product-image-btn">
                        <a class="product-lightbox-btn tip-top" title="<?php esc_attr_e('Zoom', 'flozen-theme'); ?>" href="<?php echo esc_url($image_link); ?>">
                            <i class="icon-nasa-icons-plus nasa-icon"></i>
                            <span class="nasa-lightbox-text hidden-tag"><?php esc_html_e('Zoom', 'flozen-theme'); ?></span>
                        </a>
                        <?php do_action('product_video_btn'); ?>
                    </div>
                </div>
                
                <?php if (!$slideHoz && (!isset($nasa_opt['nasa_in_mobile']) || !$nasa_opt['nasa_in_mobile'])) : ?>
                    <span class="hidden-tag hide-for-mobile nasa-suggested-mouse" data-text_change="<?php echo esc_attr__('Click to open expanded view', 'flozen-theme'); ?>"><?php echo esc_html__('Roll over image to zoom in', 'flozen-theme'); ?></span>
                <?php endif; ?>
                <div class="nasa-end-scroll"></div>
            </div>
            
            <?php if ($slideHoz) : ?>
                <div class="nasa-thumb-wrap nasa-thumbnail-hoz">
                    <?php do_action('woocommerce_product_thumbnails'); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
