<?php
/**
 * Woocommerce Compare button
 *
 * @author  NasaTheme
 * @package Flozen-theme/WooCommerce
 * @version 3.0.0
 * 
 * Template variables:
 *
 * @var $style string
 * @var $added bool
 * @var $product_id int
 * @var $button_target string
 * @var $compare_url string
 * @var $compare_classes string
 * @var $compare_label string
 */
defined('YITH_WOOCOMPARE') || exit; // Exit if accessed directly.

global $product, $nasa_opt;

$added = YITH_WooCompare_Products_List::instance()->has($product_id);

$class_btn = 'btn-compare tip-top nasa-compare compare';
$class_btn .= $added ? ' added nasa-added' : '';

?>
<a
    href="<?php echo esc_url($compare_url); ?>"
    class="<?php echo esc_attr($class_btn); ?>"
    data-product_id="<?php echo (int) $product_id; ?>"
    target="<?php echo esc_attr($button_target); ?>"
    rel="nofollow"
    data-icon-text="<?php esc_attr_e('Compare', 'flozen-theme'); ?>" 
    data-added="<?php esc_attr_e('Added to Compare', 'flozen-theme'); ?>"
    data-prod="<?php echo (int) $product_id; ?>"
    data-tip="<?php esc_attr_e('Compare', 'flozen-theme'); ?>"
    title="<?php esc_attr_e('Compare', 'flozen-theme'); ?>">
    <?php if (isset($compare_label['is_single']) && $compare_label['is_single'] === true) : ?>
        <div class="btn-link">
            <div class="compare-icon">
                <span class="nasa-icon icon-nasa-compare-2"></span>
                <span class="nasa-icon-text">Add to Compare</span>
            </div>
        </div>
    <?php else : ?>
        <div class="btn-link">
            <div class="compare-icon">
                <span class="nasa-icon icon-nasa-refresh"></span>
                <span class="hidden-tag nasa-icon-text"><?php esc_html_e('Compare', 'flozen-theme'); ?></span>
            </div>
        </div>
    <?php endif; ?>
</a>
<?php
// wp_enqueue_script('yith-woocompare-main');
