<?php
/**
 * Custom icons for this theme.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since Twenty Twenty 1.0
 */

namespace Glozin;

/**
 * SVG ICONS CLASS
 * Retrieve the SVG code for the specified icon. Based on a solution in Twenty Nineteen.
 */
class Icon {

	/**
	 * Store the code for all SVGs in an array.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public static $ui_icons = array(
		'left-mini'       => '<svg width="7" height="11" viewBox="0 0 7 11" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M5.5 11L0 5.5L5.5 0L6.47625 0.97625L1.9525 5.5L6.47625 10.0238L5.5 11Z" fill="currentColor"/></svg>',
		'right-mini'      => '<svg width="7" height="11" viewBox="0 0 7 11" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M1.5 11L7 5.5L1.5 0L0.52375 0.97625L5.0475 5.5L0.52375 10.0238L1.5 11Z" fill="currentColor"/></svg>',
		'arrow-right'     => '<svg width="5" height="8" viewBox="0 0 5 8" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M0.886718 3.49691e-07L4.88672 4L0.886719 8L0.176719 7.29L3.46672 4L0.176719 0.71L0.886718 3.49691e-07Z" /></svg>',
		'arrow-top'       => '<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 8 8" fill="currentColor" class="hdt-inline-block hdt-icon hdt-icon-2"><path d="M0.861539 8L0 7.13846L5.90769 1.23077H0.615385V0H8V7.38462H6.76923V2.09231L0.861539 8Z" fill="currentColor"></path></svg>',
		'arrow-bottom'    => '<svg xmlns="http://www.w3.org/2000/svg" width="12" height="7" viewBox="0 0 12 7" fill="currentColor"><path d="M0.738281 1.23813L6.23828 6.73813L11.7383 1.23813L10.762 0.261879L6.23828 4.78563L1.71453 0.261879L0.738281 1.23813Z" fill="currentColor"></path></svg>',
		'arrow-left'      => '<svg width="6" height="11" viewBox="0 0 6 11" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.7193 10.7605C4.85965 10.9202 5.03509 11 5.24561 11C5.45614 11 5.63158 10.9202 5.77193 10.7605C5.92398 10.6131 6 10.435 6 10.2261C6 10.005 5.92398 9.81463 5.77193 9.65494L1.80702 5.49079L5.77193 1.32663C5.92398 1.17923 6 1.00112 6 0.792295C6 0.571189 5.92398 0.380793 5.77193 0.221106C5.63158 0.0737018 5.45614 0 5.24561 0C5.03509 0 4.85965 0.0737018 4.7193 0.221106L0.22807 4.93802C0.0760236 5.09771 0 5.28811 0 5.50921C0 5.71803 0.0760236 5.89615 0.22807 6.04355L4.7193 10.7605Z" fill="currentColor"/></svg>',
		'pr-arrow'        => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="9.98 12.06 12.05 6.79" width="14" height="14"><path d="M16.767 12.809l-0.754-0.754-6.035 6.035 0.754 0.754 5.281-5.281 5.256 5.256 0.754-0.754-3.013-3.013z" fill="currentColor"></path></svg>',
		'double-arrow'    => '<svg viewBox="0 0 8 10" width="8" height="10" fill="none"><path fill="currentColor" d="M7.797 4.203h.016A.636.636 0 0 1 8 4.672a.67.67 0 0 1-.188.469.69.69 0 0 1-.484.187.67.67 0 0 1-.469-.187L4 2.28l-2.86 2.86a.69.69 0 0 1-.484.187.617.617 0 0 1-.453-.187A.644.644 0 0 1 0 4.67c0-.187.068-.343.203-.468L3.531.86A.636.636 0 0 1 4 .672c.188 0 .344.062.469.187l3.328 3.344Zm0 4.656h.016A.69.69 0 0 1 8 9.344a.617.617 0 0 1-.188.453.661.661 0 0 1-.953 0L4 6.937l-2.86 2.86A.661.661 0 0 1 .657 10a.594.594 0 0 1-.453-.203A.594.594 0 0 1 0 9.344c0-.188.068-.35.203-.485l3.328-3.328A.611.611 0 0 1 4 5.328c.188 0 .344.068.469.203L7.797 8.86Z"></path></svg>',
		'search'          => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.2 11.0409C11.1059 11.0409 11.1059 11.0409 11.2 11.0409C11.1059 11.1345 11.1059 11.1345 11.1059 11.1345C10.6353 11.6023 10.0706 11.9766 9.31765 12.2573C8.65882 12.538 7.90588 12.6316 7.15294 12.6316C6.4 12.6316 5.64706 12.4444 4.98823 12.1637C4.32941 11.883 3.76471 11.5088 3.2 10.9474C2.72941 10.4795 2.25882 9.82456 1.97647 9.16959C1.69412 8.60819 1.6 7.95322 1.6 7.20468C1.6 6.45614 1.78824 5.7076 2.07059 5.05263C2.35294 4.30409 2.72941 3.74269 3.2 3.18129C3.76471 2.71345 4.32941 2.33918 4.98823 2.05848C5.64706 1.77778 6.4 1.59064 7.15294 1.59064C7.90588 1.59064 8.65882 1.77778 9.31765 2.05848C9.97647 2.33918 10.6353 2.71345 11.1059 3.27485C11.5765 3.74269 11.9529 4.39766 12.3294 5.05263C12.6118 5.7076 12.8 6.36257 12.8 7.20468C12.8 7.95322 12.6118 8.70175 12.3294 9.35672C12.0471 9.91813 11.6706 10.4795 11.2 11.0409ZM15.7176 14.5029L12.8 11.6023C13.2706 10.9474 13.6471 10.2924 13.9294 9.54386C14.2118 8.79532 14.3059 7.95322 14.3059 7.11111C14.3059 6.08187 14.1176 5.1462 13.7412 4.30409C13.3647 3.46199 12.8941 2.71345 12.2353 2.05848C11.5765 1.40351 10.8235 0.935673 9.97647 0.561404C9.12941 0.187134 8.18824 0 7.15294 0C6.21176 0 5.27059 0.187134 4.32941 0.561404C3.48235 0.935673 2.72941 1.40351 2.07059 2.05848C1.41176 2.71345 0.941176 3.46199 0.564706 4.39766C0.188235 5.23977 0 6.17544 0 7.20468C0 8.14035 0.188235 9.07602 0.564706 10.0117C0.941176 10.8538 1.50588 11.6023 2.16471 12.2573C2.82353 12.9123 3.57647 13.3801 4.42353 13.848C5.27059 14.1287 6.21176 14.3158 7.15294 14.3158C8 14.3158 8.84706 14.2222 9.6 13.9415C10.3529 13.6608 11.1059 13.2865 11.6706 12.8187L14.5882 15.7193C14.7765 15.9064 14.9647 16 15.1529 16C15.3412 16 15.5294 15.9064 15.7176 15.7193C15.9059 15.5322 16 15.345 16 15.1579C16 14.8772 15.9059 14.6901 15.7176 14.5029Z" fill="currentColor"/></svg>',
		'account'         => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.899 14.8407C15.0898 13.4718 13.9351 12.3369 12.5494 11.5483C11.1637 10.7598 9.59497 10.345 7.99854 10.345C6.40212 10.345 4.83338 10.7598 3.44766 11.5483C2.06195 12.3369 0.907317 13.4718 0.0981041 14.8407C-0.000963745 15.0183 -0.0261854 15.2274 0.0278433 15.4232C0.0533259 15.5229 0.0999421 15.6161 0.164569 15.6964C0.229196 15.7768 0.310341 15.8425 0.402568 15.8891C0.521545 15.9562 0.65615 15.991 0.792905 15.9901C0.928522 15.9958 1.06307 15.964 1.1816 15.8982C1.30013 15.8324 1.39798 15.7351 1.46429 15.6173C2.13414 14.4835 3.09017 13.5434 4.23766 12.8902C5.38515 12.237 6.68428 11.8934 8.00635 11.8934C9.32842 11.8934 10.6276 12.237 11.775 12.8902C12.9225 13.5434 13.8786 14.4835 14.5484 15.6173C14.6527 15.7936 14.8227 15.9219 15.0215 15.9742C15.2203 16.0266 15.4318 15.9988 15.6101 15.8969C15.6989 15.8498 15.7768 15.7847 15.8386 15.7057C15.9005 15.6268 15.945 15.5358 15.9692 15.4387C15.9981 15.3394 16.0068 15.2354 15.9947 15.1327C15.9827 15.03 15.9501 14.9307 15.899 14.8407Z" fill="currentColor"/><path d="M7.99922 9.60001C9.25716 9.60022 10.4649 9.10204 11.3626 8.21265C12.2603 7.32327 12.7762 6.11377 12.7992 4.84441C12.7992 3.55959 12.2935 2.3274 11.3933 1.41889C10.4932 0.510392 9.27226 0 7.99922 0C6.72618 0 5.50528 0.510392 4.60511 1.41889C3.70493 2.3274 3.19922 3.55959 3.19922 4.84441C3.22228 6.11377 3.73816 7.32327 4.63584 8.21265C5.53353 9.10204 6.74128 9.60022 7.99922 9.60001ZM4.79922 4.84441C4.79922 3.98786 5.13636 3.1664 5.73648 2.56073C6.3366 1.95506 7.15053 1.6148 7.99922 1.6148C8.84791 1.6148 9.66185 1.95506 10.262 2.56073C10.8621 3.1664 11.1992 3.98786 11.1992 4.84441C11.1992 5.70095 10.8621 6.52242 10.262 7.12809C9.66185 7.73375 8.84791 8.07402 7.99922 8.07402C7.15053 8.07402 6.3366 7.73375 5.73648 7.12809C5.13636 6.52242 4.79922 5.70095 4.79922 4.84441Z" fill="currentColor"/></svg>',
		'sidebar'         => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="currentColor"><path d="M10.2326 0H5.76744C1.72428 0 0 1.72428 0 5.76744V10.2326C0 14.2757 1.72428 16 5.76744 16H10.2326C14.2757 16 16 14.2757 16 10.2326V5.76744C16 1.72428 14.2757 0 10.2326 0ZM9.67442 14.8837H5.76744C2.33377 14.8837 1.11628 13.6662 1.11628 10.2326V5.76744C1.11628 2.33377 2.33377 1.11628 5.76744 1.11628H9.67442V14.8837ZM14.8837 10.2326C14.8837 13.4727 13.798 14.7379 10.7907 14.8703V1.12967C13.798 1.26214 14.8837 2.52726 14.8837 5.76744V10.2326ZM5.41767 5.70047L7.32279 7.60558C7.37463 7.65735 7.41576 7.71883 7.44382 7.78651C7.47188 7.85419 7.48633 7.92673 7.48633 8C7.48633 8.07327 7.47188 8.14581 7.44382 8.21349C7.41576 8.28117 7.37463 8.34265 7.32279 8.39442L5.41767 10.2995C5.31236 10.4012 5.17135 10.4573 5.025 10.456C4.87866 10.4547 4.7387 10.3959 4.63526 10.2924C4.53183 10.1888 4.4732 10.0488 4.47199 9.90248C4.47079 9.75613 4.52712 9.61517 4.62884 9.50995L6.13953 8L4.62884 6.49005C4.52712 6.38483 4.47079 6.24387 4.47199 6.09752C4.4732 5.95118 4.53183 5.81116 4.63526 5.70763C4.7387 5.6041 4.87866 5.54533 5.025 5.54399C5.17135 5.54265 5.31236 5.59884 5.41767 5.70047Z"></path></svg>',
		'shop'            => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64.39 64.26" width="18" height="18" fill="currentColor"><path d="M45.47,64.26a11.21,11.21,0,0,1-11.2-11.2V45.34a11.21,11.21,0,0,1,11.2-11.2h7.72a11.21,11.21,0,0,1,11.2,11.2v7.72a11.22,11.22,0,0,1-11.2,11.2Zm0-22.53a3.61,3.61,0,0,0-3.61,3.61v7.72a3.61,3.61,0,0,0,3.61,3.6h7.72a3.6,3.6,0,0,0,3.6-3.6V45.34a3.61,3.61,0,0,0-3.6-3.61ZM11.2,64.26A11.22,11.22,0,0,1,0,53.06V45.34a11.21,11.21,0,0,1,11.2-11.2h7.72a11.21,11.21,0,0,1,11.2,11.2v7.72a11.21,11.21,0,0,1-11.2,11.2Zm0-22.53a3.61,3.61,0,0,0-3.61,3.61v7.72a3.61,3.61,0,0,0,3.61,3.6h7.72a3.61,3.61,0,0,0,3.61-3.6V45.34a3.61,3.61,0,0,0-3.61-3.61ZM45.47,30.12a11.21,11.21,0,0,1-11.2-11.2V11.2A11.21,11.21,0,0,1,45.47,0h7.72a11.21,11.21,0,0,1,11.2,11.2v7.72a11.22,11.22,0,0,1-11.2,11.2Zm0-22.53a3.61,3.61,0,0,0-3.61,3.61v7.72a3.61,3.61,0,0,0,3.61,3.61h7.72a3.61,3.61,0,0,0,3.6-3.61V11.2a3.61,3.61,0,0,0-3.6-3.61ZM11.2,30.12A11.22,11.22,0,0,1,0,18.92V11.2A11.21,11.21,0,0,1,11.2,0h7.72a11.21,11.21,0,0,1,11.2,11.2v7.72a11.21,11.21,0,0,1-11.2,11.2Zm0-22.53A3.61,3.61,0,0,0,7.59,11.2v7.72a3.61,3.61,0,0,0,3.61,3.61h7.72a3.61,3.61,0,0,0,3.61-3.61V11.2a3.61,3.61,0,0,0-3.61-3.61Z"></path></svg>',
		'close'           => '<svg fill="currentColor" width="16" height="16" viewBox="0 0 16 16"><path d="M16 1.4L14.6 0L8 6.6L1.4 0L0 1.4L6.6 8L0 14.6L1.4 16L8 9.4L14.6 16L16 14.6L9.4 8L16 1.4Z" fill="currentColor"></path></svg>',
		'filter'          => '<svg width="20" height="12" viewBox="0 0 20 12" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M0 1C0 0.734784 0.105357 0.48043 0.292893 0.292893C0.48043 0.105357 0.734784 0 1 0H19C19.2652 0 19.5196 0.105357 19.7071 0.292893C19.8946 0.48043 20 0.734784 20 1C20 1.26522 19.8946 1.51957 19.7071 1.70711C19.5196 1.89464 19.2652 2 19 2H1C0.734784 2 0.48043 1.89464 0.292893 1.70711C0.105357 1.51957 0 1.26522 0 1ZM3 6C3 5.73478 3.10536 5.48043 3.29289 5.29289C3.48043 5.10536 3.73478 5 4 5H16C16.2652 5 16.5196 5.10536 16.7071 5.29289C16.8946 5.48043 17 5.73478 17 6C17 6.26522 16.8946 6.51957 16.7071 6.70711C16.5196 6.89464 16.2652 7 16 7H4C3.73478 7 3.48043 6.89464 3.29289 6.70711C3.10536 6.51957 3 6.26522 3 6ZM8 10C7.73478 10 7.48043 10.1054 7.29289 10.2929C7.10536 10.4804 7 10.7348 7 11C7 11.2652 7.10536 11.5196 7.29289 11.7071C7.48043 11.8946 7.73478 12 8 12H12C12.2652 12 12.5196 11.8946 12.7071 11.7071C12.8946 11.5196 13 11.2652 13 11C13 10.7348 12.8946 10.4804 12.7071 10.2929C12.5196 10.1054 12.2652 10 12 10H8Z" fill="currentColor"></path></svg>',
		'filter-2'        => '<svg width="14" height="13" fill="none"><path fill="currentColor" d="M11.58 1.5H2.42l3.855 4.553a.474.474 0 0 1 .096.191.482.482 0 0 1 .041.192v3.459l1.176.574V6.436c0-.073.009-.142.027-.206a.72.72 0 0 1 .11-.177L11.58 1.5ZM12.838.338c.064 0 .128.014.191.04.064.02.123.051.178.097.128.1.196.232.205.396a.533.533 0 0 1-.137.424L8.75 6.655v4.757a.695.695 0 0 1-.014.137.587.587 0 0 1-.383.424.598.598 0 0 1-.45-.041L5.577 10.77a.597.597 0 0 1-.246-.205.648.648 0 0 1-.082-.315V6.654L.725 1.294a.719.719 0 0 1-.11-.177.743.743 0 0 1-.027-.205.54.54 0 0 1 .164-.396.563.563 0 0 1 .41-.178h11.676Z"></path></svg>',
		'list'            => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" fill="none"><g fill="currentColor"><path d="M2.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM2.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM2.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM19.073 2a1 1 0 0 1-1 1h-12a1 1 0 0 1 0-2h12a1 1 0 0 1 1 1ZM19.073 7a1 1 0 0 1-1 1h-12a1 1 0 0 1 0-2h12a1 1 0 0 1 1 1ZM19.073 12a1 1 0 0 1-1 1h-12a1 1 0 0 1 0-2h12a1 1 0 0 1 1 1Z"></path></g></svg>',
		'grid-2'          => '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="14" fill="none"><g fill="currentColor"><path d="M11.073 6a3 3 0 1 0 0-6 3 3 0 0 0 0 6ZM4.07 6a3 3 0 1 0 0-6 3 3 0 0 0 0 6ZM11.073 14a3 3 0 1 0 0-6 3 3 0 0 0 0 6ZM3.927 14a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"></path></g></svg>',
		'grid-3'          => '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="14" fill="none"><g fill="currentColor"><path d="M2.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM2.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM2.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"></path></g></svg>',
		'grid-4'          => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" fill="none"><g fill="currentColor"><path d="M2.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM2.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM2.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM7.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM12.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM17.073 4a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM17.073 9a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM17.073 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"></path></g></svg>',
		'object-column'   => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.8019 7.43638H10.7669C9.27167 7.43638 8.54639 6.76644 8.54639 5.40422V2.03217C8.54639 0.669945 9.27167 0 10.7669 0H13.7684C15.2636 0 15.9889 0.669945 15.9889 2.03217V5.41539C15.9889 6.07416 15.8215 6.56546 15.4756 6.90043C15.1074 7.2689 14.5718 7.43638 13.8019 7.43638ZM10.7669 1.11657C9.77379 1.11657 9.66221 1.40688 9.66221 2.03217V5.40422C9.66221 6.04067 9.76263 6.31981 10.7669 6.31981H13.7684C14.2482 6.33098 14.5495 6.25282 14.6946 6.10766C14.8173 5.98484 14.8731 5.75036 14.8731 5.41539V2.03217C14.8731 1.40688 14.7615 1.11657 13.7684 1.11657H10.7669Z" fill="currentColor"></path><path d="M13.7794 16.0003H10.7779C9.28266 16.0003 8.55737 15.2745 8.55737 13.7783V10.7747C8.55737 9.27851 9.28266 8.55273 10.7779 8.55273H13.7794C15.2746 8.55273 15.9999 9.27851 15.9999 10.7747V13.7783C15.9999 15.2745 15.2746 16.0003 13.7794 16.0003ZM10.7779 9.66931C9.90751 9.66931 9.67319 9.89262 9.67319 10.7747V13.7783C9.67319 14.6492 9.89636 14.8837 10.7779 14.8837H13.7794C14.6498 14.8837 14.8841 14.6604 14.8841 13.7783V10.7747C14.8841 9.90379 14.6609 9.66931 13.7794 9.66931H10.7779Z" fill="currentColor"></path><path d="M5.25478 7.43638H2.21975C0.72455 7.43638 -0.000732422 6.76644 -0.000732422 5.40422V2.03217C-0.000732422 0.669945 0.72455 0 2.21975 0H5.2213C6.7165 0 7.44179 0.669945 7.44179 2.03217V5.41539C7.44179 6.07416 7.27441 6.56546 6.92851 6.90043C6.56029 7.2689 6.0247 7.43638 5.25478 7.43638ZM2.21975 1.11657C1.22667 1.11657 1.11509 1.40688 1.11509 2.03217V5.40422C1.11509 6.04067 1.21551 6.31981 2.21975 6.31981H5.2213C5.68995 6.33098 6.00238 6.25282 6.13628 6.10766C6.25902 5.98484 6.31481 5.75036 6.31481 5.41539V2.03217C6.31481 1.40688 6.20323 1.11657 5.21015 1.11657H2.21975Z" fill="currentColor"></path><path d="M5.2213 16.0003H2.21975C0.72455 16.0003 -0.000732422 15.2745 -0.000732422 13.7783V10.7747C-0.000732422 9.27851 0.72455 8.55273 2.21975 8.55273H5.2213C6.7165 8.55273 7.44179 9.27851 7.44179 10.7747V13.7783C7.44179 15.2745 6.7165 16.0003 5.2213 16.0003ZM2.21975 9.66931C1.34941 9.66931 1.11509 9.89262 1.11509 10.7747V13.7783C1.11509 14.6492 1.33825 14.8837 2.21975 14.8837H5.2213C6.09164 14.8837 6.32597 14.6604 6.32597 13.7783V10.7747C6.32597 9.90379 6.1028 9.66931 5.2213 9.66931H2.21975Z" fill="currentColor"></path></svg>',
		'plus'            => '<svg width="11" height="12" viewBox="0 0 11 12" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 11.5H6L6 6.5H11V5.5H6L6 0.5H5L5 5.5H0V6.5H5L5 11.5Z" fill="currentColor"></path></svg>',
		'plus-mini'       => '<svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 0C4.44772 0 4 0.447715 4 1V4L1 4C0.447715 4 0 4.44771 0 5C0 5.55228 0.447715 6 1 6H4V9C4 9.55229 4.44772 10 5 10C5.55228 10 6 9.55228 6 9V6H9C9.55228 6 10 5.55229 10 5C10 4.44772 9.55228 4 9 4L6 4V1C6 0.447715 5.55228 0 5 0Z" fill="currentColor"/></svg>',
		'minus'           => '<svg width="11" height="12" viewBox="0 0 11 2" fill="none"><path d="M11 0.5L11 1.5L-4.37114e-08 1.5L0 0.5L11 0.5Z" fill="currentColor"></path></svg>',
		'clock'           => '<svg xmlns="http://www.w3.org/2000/svg" class="hdt-ani-tada is--infinite hdt-inine-block" width="14" height="14" viewBox="0 0 14 14"><path d="M6.7796 0.828412C3.1501 0.828412 0.193808 3.7847 0.193808 7.41421C0.193808 11.0437 3.1501 14 6.7796 14C10.4091 14 13.3654 11.0437 13.3654 7.41421C13.3654 3.7847 10.4091 0.828412 6.7796 0.828412ZM6.7796 12.5365C3.95503 12.5365 1.65732 10.2388 1.65732 7.41421C1.65732 4.58963 3.95503 2.29192 6.7796 2.29192C9.60418 2.29192 11.9019 4.58963 11.9019 7.41421C11.9019 10.2388 9.60418 12.5365 6.7796 12.5365ZM0.252349 2.65048C-0.0549885 2.38705 -0.0842587 1.91873 0.179173 1.61871C0.669449 1.05526 1.24754 0.550345 1.88416 0.125928C2.22077 -0.100916 2.67446 -0.0131058 2.9013 0.323501C3.12814 0.660109 3.04033 1.1138 2.70373 1.34064C2.17686 1.69188 1.70122 2.1163 1.29144 2.58462C1.14509 2.75293 0.947516 2.83342 0.742624 2.83342C0.564631 2.83384 0.392712 2.76872 0.259666 2.65048H0.252349ZM10.8555 1.34064C10.5189 1.1138 10.4311 0.660109 10.6579 0.323501C10.8847 -0.0131058 11.3384 -0.100916 11.675 0.125928C12.3117 0.550345 12.8824 1.05526 13.38 1.61871C13.6435 1.92604 13.6142 2.38705 13.3069 2.65048C13.2349 2.71418 13.1511 2.76303 13.0602 2.79421C12.9693 2.82539 12.8732 2.83829 12.7773 2.83217C12.6814 2.82605 12.5876 2.80102 12.5015 2.75854C12.4153 2.71606 12.3383 2.65695 12.2751 2.58462C11.859 2.1117 11.3844 1.69368 10.8628 1.34064H10.8555ZM8.71875 8.1606C9.01877 8.43135 9.04804 8.89235 8.77729 9.19237C8.63094 9.35336 8.43337 9.44117 8.22848 9.44117C8.05286 9.44117 7.88455 9.38263 7.74552 9.25823L6.28933 7.96302C6.13566 7.82399 6.04053 7.62642 6.04053 7.41421V4.48719C6.04053 4.08472 6.36982 3.75543 6.77228 3.75543C7.17475 3.75543 7.50404 4.08472 7.50404 4.48719V7.08492L8.71875 8.1606Z"></path></svg>',
		'clock-2'         => '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M13.5631 11.7661L10.7746 9.67465V5.41441C10.7746 4.98605 10.4283 4.6398 9.99996 4.6398C9.5716 4.6398 9.22535 4.98605 9.22535 5.41441V10.062C9.22535 10.306 9.34 10.5361 9.5352 10.6817L12.6336 13.0055C12.7673 13.1062 12.9302 13.1606 13.0975 13.1604C13.3338 13.1604 13.5662 13.0543 13.718 12.8498C13.9752 12.5081 13.9055 12.0225 13.5631 11.7661Z" fill="currentColor"></path><path d="M10 0C4.48566 0 0 4.48566 0 10C0 15.5143 4.48566 20 10 20C15.5143 20 20 15.5143 20 10C20 4.48566 15.5143 0 10 0ZM10 18.4508C5.34082 18.4508 1.54918 14.6592 1.54918 10C1.54918 5.34082 5.34082 1.54918 10 1.54918C14.66 1.54918 18.4508 5.34082 18.4508 10C18.4508 14.6592 14.6592 18.4508 10 18.4508Z" fill="currentColor"></path></svg>',
		'fullscreen'      => '<svg width="18" height="18" viewBox="0 0 18 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.672 17.0111L17.672 12.0526L16.4091 12.0526L16.4091 15.4846L11.5285 10.604L10.6352 11.4972L15.5158 16.3778L12.082 16.3796L12.082 17.6425L17.0405 17.6425C17.3878 17.6407 17.6701 17.3584 17.672 17.0111ZM2.48608 16.3778L5.91808 16.3778L5.91808 17.6407L0.961377 17.6425C0.78679 17.6425 0.628951 17.5701 0.515665 17.4568C0.40053 17.3417 0.329985 17.1856 0.329948 17.0111L0.329912 12.0525H1.59277V15.4845L6.47335 10.6039L7.36662 11.4972L2.48604 16.3778L2.48608 16.3778ZM15.514 1.56337H12.082L12.0819 0.300476L17.0405 0.300512C17.1234 0.300625 17.2054 0.317088 17.2819 0.348957C17.3584 0.380826 17.4278 0.427474 17.4862 0.486229C17.6032 0.603249 17.6719 0.764822 17.6719 0.931941L17.6701 5.88864L16.4072 5.88864L16.4072 2.45664L11.5267 7.33722L10.6334 6.44395L15.514 1.56337ZM6.47523 7.33722L7.3685 6.44395L2.48608 1.56152L5.91993 1.56337L5.91808 0.298663L0.961377 0.300512C0.878435 0.300435 0.796292 0.316715 0.719649 0.34842C0.643005 0.380126 0.573367 0.426633 0.514718 0.485282C0.456069 0.543931 0.409562 0.613569 0.377857 0.690212C0.346151 0.766856 0.329871 0.848999 0.329948 0.931941L0.328062 5.88868L1.59277 5.89053L1.59281 2.45479L6.47523 7.33722Z"/></svg>',
		'fullscreen-2'    => '<svg viewBox="0 0 44 44"><path stroke-width="8" stroke-opacity=".25" stroke="inherit" d="M19 14h-4a1 1 0 00-1 1v4a1 1 0 102 0v-3h3a1 1 0 100-2zm0 14h-3v-3a1 1 0 10-2 0v4a1 1 0 001 1h4a1 1 0 100-2zm10-4a1 1 0 00-1 1v3h-3a1 1 0 100 2h4a1 1 0 001-1v-4a1 1 0 00-1-1zm0-10h-4a1 1 0 100 2h3v3a1 1 0 102 0v-4a1 1 0 00-1-1z" fill="currentColor"></path></svg>',
		'exit-fullscreen' => '<svg viewBox="0 0 44 44"><g stroke-width="8" stroke-opacity=".25" stroke="inherit" fill="currentColor"><path d="M25 20h4a1 1 0 100-2h-3v-3a1 1 0 10-2 0v4a1 1 0 001 1zM19 24h-4a1 1 0 100 2h3v3a1 1 0 102 0v-4a1 1 0 00-1-1zM29 24h-4a1 1 0 00-1 1v4a1 1 0 102 0v-3h3a1 1 0 100-2zM19 14a1 1 0 00-1 1v3h-3a1 1 0 100 2h4a1 1 0 001-1v-4a1 1 0 00-1-1z"></path></g></svg>',
		'share'           => '<svg width="14" height="15" viewBox="0 0 14 15" fill="currentColor"><path fill="currentColor" d="M9.813 11.407a.835.835 0 0 0-.11.281 1.59 1.59 0 0 0-.031.313c0 .188.031.365.094.531.073.156.171.292.296.406.115.125.25.224.407.297a1.5 1.5 0 0 0 .531.094c.188 0 .36-.031.516-.094.166-.073.307-.171.421-.296.126-.115.22-.25.282-.407a1.31 1.31 0 0 0 0-1.047 1.075 1.075 0 0 0-.281-.421 1.074 1.074 0 0 0-.422-.282 1.31 1.31 0 0 0-1.047 0 1.098 1.098 0 0 0-.406.281l-.094.094a.418.418 0 0 0-.078.11c0 .01-.006.02-.016.03-.01.011-.016.022-.016.032l-.03.031a.12.12 0 0 1-.017.047Zm.062-8.031c.02.042.047.083.078.125a.544.544 0 0 0 .11.11c.114.124.25.223.406.296a1.5 1.5 0 0 0 .531.094c.188 0 .36-.031.516-.094.166-.073.307-.172.421-.297a1.25 1.25 0 0 0 .282-.422 1.274 1.274 0 0 0 0-1.03 1.216 1.216 0 0 0-.281-.438 1.359 1.359 0 0 0-.422-.282 1.31 1.31 0 0 0-1.047 0 1.414 1.414 0 0 0-.406.282c-.126.125-.224.27-.297.437a1.376 1.376 0 0 0-.094.516c0 .114.01.224.031.328.031.104.073.203.125.297v.031c.01 0 .016.005.016.016.01 0 .015.005.015.015l.016.016Zm-5.75 3.25a.82.82 0 0 0-.078-.125.544.544 0 0 0-.11-.11 1.074 1.074 0 0 0-.421-.28 1.31 1.31 0 0 0-1.047 0 1.098 1.098 0 0 0-.407.28c-.124.126-.223.271-.296.438a1.334 1.334 0 0 0-.094.5c0 .188.031.365.094.531.073.157.171.297.296.422a1.311 1.311 0 0 0 1.453.281c.167-.072.308-.166.423-.28l.109-.11a.612.612 0 0 0 .078-.14h.016c0-.011.005-.022.015-.032.01-.01.016-.02.016-.031a1.02 1.02 0 0 0 .11-.297c.03-.115.046-.23.046-.344 0-.114-.016-.224-.047-.328a1.02 1.02 0 0 0-.11-.297c0-.01-.004-.016-.015-.016v-.03h-.015c0-.011-.006-.022-.016-.032Zm4.313-3.234a4.078 4.078 0 0 1-.079-.344 2.68 2.68 0 0 1 .172-1.422c.146-.323.339-.604.578-.844.24-.24.521-.427.844-.562a2.584 2.584 0 0 1 2.078 0c.334.135.62.323.86.562.24.24.427.521.562.844.146.323.219.672.219 1.047 0 .364-.073.708-.219 1.031a2.603 2.603 0 0 1-.562.844 2.64 2.64 0 0 1-1.89.781c-.366 0-.715-.068-1.048-.203a2.825 2.825 0 0 1-.844-.578L5.563 6.61c.03.115.057.235.078.36a2.277 2.277 0 0 1 0 .734 3.64 3.64 0 0 1-.079.36l3.547 2.062v-.016c.24-.24.521-.427.844-.562a2.585 2.585 0 0 1 2.078 0c.334.135.62.323.86.562.24.24.427.526.562.86a2.584 2.584 0 0 1 0 2.078 2.604 2.604 0 0 1-.562.844c-.24.24-.526.427-.86.562a2.585 2.585 0 0 1-2.078 0 2.603 2.603 0 0 1-.844-.562c-.24-.24-.432-.521-.578-.844A2.756 2.756 0 0 1 8.328 12c0-.125.01-.245.031-.36.021-.124.047-.25.079-.374L4.89 9.204v.016A2.64 2.64 0 0 1 3 10c-.366 0-.715-.068-1.048-.203a2.825 2.825 0 0 1-.844-.578c-.24-.24-.432-.521-.578-.844a2.68 2.68 0 0 1-.203-1.047c0-.364.068-.708.203-1.031.146-.323.339-.604.578-.844.24-.24.521-.427.844-.562a2.584 2.584 0 0 1 2.078 0c.334.135.62.323.86.562l3.546-2.062Z"></path></svg>',
		'delivery'        => '<svg width="30" height="30" fill="none"><circle cx="15" cy="15" r="14.5" fill="#fff" stroke="currentColor"></circle><path fill="currentColor" stroke="currentColor" stroke-width=".3" d="M23.802 14.611 22.71 13.6a.643.643 0 0 1-.166-.25l-.857-2.325a1.722 1.722 0 0 0-1.607-1.12h-1.298v-.363a.59.59 0 0 0-.59-.59h-7.841a.448.448 0 0 0-.453.43.439.439 0 0 0 .438.447h7.57v3.805a.59.59 0 0 0 .59.59h3.564l1.059.953v3.554h-.96a1.894 1.894 0 0 0-3.693 0h-2.953a1.894 1.894 0 0 0-3.693 0h-1.47a.448.448 0 0 0-.452.43.438.438 0 0 0 .438.447h1.491a1.895 1.895 0 0 0 3.678 0h2.968a1.894 1.894 0 0 0 3.678 0h1.255a.59.59 0 0 0 .59-.59V15.05a.589.589 0 0 0-.195-.439Zm-5.019-1.263v-2.565h1.298a.84.84 0 0 1 .785.546l.747 2.019h-2.83Zm-5.116 6.823a1.017 1.017 0 1 1 0-2.035 1.017 1.017 0 0 1 0 2.035Zm6.646 0a1.017 1.017 0 1 1 0-2.035 1.017 1.017 0 0 1 0 2.035Z"></path><path fill="currentColor" stroke="currentColor" stroke-width=".3" d="M8.47 12.283h4.974a.438.438 0 0 0 0-.878H8.47a.439.439 0 1 0 0 .878ZM13.876 14.28a.438.438 0 0 0-.439-.439H6.435a.44.44 0 1 0 0 .878h7.002a.439.439 0 0 0 .439-.44ZM11.101 16.716a.44.44 0 0 0-.438-.438H7.614a.439.439 0 0 0 0 .877h3.049a.438.438 0 0 0 .438-.439Z"></path></svg>',
		'question'        => '<svg width="18" height="18" viewBox="0 0 18 18" fill="currentColor"><path fill="currentColor" d="M18 8.991c0-.613-.058-1.214-.173-1.802a9.26 9.26 0 0 0-.537-1.686 8.072 8.072 0 0 0-.825-1.534 8.506 8.506 0 0 0-1.094-1.342 10.22 10.22 0 0 0-1.343-1.092A9.11 9.11 0 0 0 12.512.71a8.344 8.344 0 0 0-1.689-.517A8.566 8.566 0 0 0 9 0c-.627 0-1.235.064-1.823.192A8.345 8.345 0 0 0 5.488.71a9.114 9.114 0 0 0-1.516.825c-.486.332-.934.696-1.343 1.092-.41.41-.774.856-1.094 1.342a8.958 8.958 0 0 0-.844 1.534C.473 6.039.3 6.602.173 7.189A9.353 9.353 0 0 0 0 8.991c0 .627.058 1.234.173 1.822.128.587.3 1.15.518 1.686.23.537.512 1.048.844 1.534.32.473.685.914 1.094 1.323.41.409.857.773 1.343 1.092a8.36 8.36 0 0 0 3.205 1.361A8.573 8.573 0 0 0 9 18.001c.627 0 1.235-.064 1.823-.192a8.351 8.351 0 0 0 3.205-1.36 8.51 8.51 0 0 0 1.343-1.093c.41-.41.774-.85 1.094-1.323a8.07 8.07 0 0 0 .825-1.534c.23-.536.41-1.099.537-1.687A9.458 9.458 0 0 0 18 8.992Zm-1.631 0c0 1.023-.192 1.981-.576 2.876a7.385 7.385 0 0 1-1.573 2.338 7.63 7.63 0 0 1-2.36 1.572 7.1 7.1 0 0 1-2.86.575 7.237 7.237 0 0 1-2.878-.575 7.695 7.695 0 0 1-2.342-1.571 7.386 7.386 0 0 1-1.573-2.34 7.215 7.215 0 0 1-.576-2.875c0-1.01.192-1.961.576-2.856A7.385 7.385 0 0 1 3.78 3.797a7.692 7.692 0 0 1 2.342-1.572A7.035 7.035 0 0 1 9 1.63c1.024 0 1.977.198 2.86.595a7.628 7.628 0 0 1 2.36 1.571 7.384 7.384 0 0 1 1.573 2.34c.384.894.576 1.846.576 2.855Zm-8.98-2.185a1.655 1.655 0 0 1 1.44-1.073c.216-.026.433 0 .65.076.193.064.359.16.5.288.14.128.262.268.364.422a1.593 1.593 0 0 1 .23.843.512.512 0 0 1-.038.192 1.092 1.092 0 0 1-.057.191 5.286 5.286 0 0 1-.135.211 3.113 3.113 0 0 1-1.151.863l-.518.23a.754.754 0 0 0-.48.402.738.738 0 0 0-.038.614.836.836 0 0 0 .403.48.782.782 0 0 0 .633.037l.73-.306a4.796 4.796 0 0 0 1.42-.978 9.26 9.26 0 0 0 .306-.364c.115-.14.211-.294.288-.46.09-.166.154-.339.192-.518.051-.191.077-.39.077-.594a3.187 3.187 0 0 0-.46-1.687c-.193-.32-.436-.6-.73-.843a2.92 2.92 0 0 0-.998-.556 2.962 2.962 0 0 0-1.286-.173 3.185 3.185 0 0 0-1.209.307 3.225 3.225 0 0 0-1.017.748c-.294.319-.511.69-.652 1.111a.833.833 0 0 0 .02.633.823.823 0 0 0 .479.422c.204.064.41.05.614-.039a.823.823 0 0 0 .422-.479ZM9 13.9c.23 0 .422-.077.576-.23a.79.79 0 0 0 .25-.575.75.75 0 0 0-.25-.575.751.751 0 0 0-.576-.25.813.813 0 0 0-.595.25.78.78 0 0 0-.23.575c0 .217.077.409.23.575.166.153.365.23.595.23Z"></path></svg>',
		'compare-color'   => '<svg width="18" height="18" viewBox="0 0 18 18" fill="currentColor"><path fill="#09A1E5" d="M6.61 13.142v3.654H4.5A9.044 9.044 0 0 1 1.205 13.5v-2.11h3.654a4.805 4.805 0 0 0 1.75 1.75Z"></path><path fill="#962B7C" d="M4.86 6.61H1.204V4.5A9.044 9.044 0 0 1 4.5 1.205h2.11V4.86a4.804 4.804 0 0 0-1.75 1.75Z"></path><path fill="#FF9259" d="M11.391 4.86V1.204h2.11A9.044 9.044 0 0 1 16.795 4.5v2.11h-3.654a4.804 4.804 0 0 0-1.75-1.75Z"></path><path fill="#3EC3FF" d="m9 13.783 2.11 2.109L9 18.002a8.959 8.959 0 0 1-4.5-1.205l2.109-3.654a4.76 4.76 0 0 0 2.391.64Z"></path><path fill="#49B296" d="M13.141 11.392h3.654v2.11a9.044 9.044 0 0 1-3.294 3.294h-1.506l-.604-3.654a4.804 4.804 0 0 0 1.75-1.75Z"></path><path fill="#077CCC" d="M4.219 9.001c0 .871.233 1.688.64 2.39l-3.654 2.11A8.958 8.958 0 0 1 0 9.002l2.11-1.406L4.219 9Z"></path><path fill="#2897B1" d="m11.39 13.143 2.11 3.654A8.958 8.958 0 0 1 9 18v-4.218a4.76 4.76 0 0 0 2.39-.64Z"></path><path fill="#89C247" d="m13.781 9.001 2.11-1.055L18 9.001c0 1.64-.439 3.177-1.205 4.5l-3.654-2.109a4.76 4.76 0 0 0 .64-2.391Z"></path><path fill="#622876" d="M4.219 9.002H0C0 7.362.44 5.825 1.205 4.5l3.654 2.11A4.76 4.76 0 0 0 4.219 9Z"></path><path fill="#CB2E81" d="M6.61 4.86 4.5 1.206A8.958 8.958 0 0 1 9 0l2.11 2.11L9 4.22a4.76 4.76 0 0 0-2.39.64Z"></path><path fill="#FF5178" d="M9 4.22V0c1.639 0 3.176.439 4.5 1.205L11.39 4.86A4.76 4.76 0 0 0 9 4.22Z"></path><path fill="#FFD23B" d="m13.141 6.61 3.654-2.109A8.958 8.958 0 0 1 18 9.001h-4.219a4.76 4.76 0 0 0-.64-2.39Z"></path></svg>',
		'thunder'         => '<svg viewBox="0 0 15 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M14.5833 8H8.61742L9.94318 0L0 12H5.96591L4.64015 20L14.5833 8Z" /></svg>',
		'hamburger'       => '<svg width="22" height="14" viewBox="0 0 22 14" fill="currentColor"><path d="M2 8H20C20.2812 8 20.5156 7.90625 20.7031 7.71875C20.9062 7.51562 21.0078 7.27344 21.0078 6.99219C21.0078 6.72656 20.9062 6.5 20.7031 6.3125C20.5156 6.10938 20.2812 6.00781 20 6.00781H2C1.71875 6.00781 1.47656 6.10938 1.27344 6.3125C1.08594 6.5 0.992188 6.72656 0.992188 6.99219C0.992188 7.27344 1.08594 7.51562 1.27344 7.71875C1.47656 7.90625 1.71875 8 2 8ZM2 2H20C20.2812 2 20.5156 1.90625 20.7031 1.71875C20.9062 1.51563 21.0078 1.27344 21.0078 0.992188C21.0078 0.726562 20.9062 0.5 20.7031 0.3125C20.5156 0.109375 20.2812 0.0078125 20 0.0078125H2C1.71875 0.0078125 1.47656 0.109375 1.27344 0.3125C1.08594 0.5 0.992188 0.726562 0.992188 0.992188C0.992188 1.27344 1.08594 1.51563 1.27344 1.71875C1.47656 1.90625 1.71875 2 2 2ZM2 14H20C20.2812 14 20.5156 13.9062 20.7031 13.7188C20.9062 13.5156 21.0078 13.2734 21.0078 12.9922C21.0078 12.7266 20.9062 12.5 20.7031 12.3125C20.5156 12.1094 20.2812 12.0078 20 12.0078H2C1.71875 12.0078 1.47656 12.1094 1.27344 12.3125C1.08594 12.5 0.992188 12.7266 0.992188 12.9922C0.992188 13.2734 1.08594 13.5156 1.27344 13.7188C1.47656 13.9062 1.71875 14 2 14Z" fill="currentColor"></path></svg>',
		'location'        => '<svg viewBox="0 0 13 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M6.40984 3.43944C4.77197 3.43944 3.43944 4.77197 3.43944 6.40984C3.43944 8.04772 4.77197 9.38025 6.40984 9.38025C8.04772 9.38025 9.38025 8.04772 9.38025 6.40984C9.38025 4.77197 8.04775 3.43944 6.40984 3.43944ZM6.40984 8.12956C5.46159 8.12956 4.69012 7.35809 4.69012 6.40984C4.69012 5.46159 5.46159 4.69012 6.40984 4.69012C7.35809 4.69012 8.12956 5.46159 8.12956 6.40984C8.12956 7.35809 7.35809 8.12956 6.40984 8.12956Z" /><path d="M6.40984 0C2.87544 0 0 2.87547 0 6.40984V6.58703C0 8.37453 1.02481 10.4575 3.04606 12.7781C4.51131 14.4603 5.95609 15.6333 6.01684 15.6824L6.40984 16L6.80284 15.6825C6.86363 15.6333 8.30841 14.4603 9.77362 12.7781C11.7948 10.4575 12.8197 8.37456 12.8197 6.58706V6.40987C12.8197 2.87547 9.94425 0 6.40984 0ZM11.569 6.58706C11.569 9.60784 7.67678 13.2646 6.40984 14.3746C5.14256 13.2642 1.25069 9.60763 1.25069 6.58706V6.40987C1.25069 3.56512 3.56509 1.25072 6.40984 1.25072C9.25459 1.25072 11.569 3.56512 11.569 6.40987V6.58706Z" /></svg>',
		'quote'           => '<svg xmlns="http://www.w3.org/2000/svg" width="46" height="31" viewBox="0 0 46 31" fill="currentColor"><path d="M32.4413 30.5L37.8204 19.9545L38.1913 19.2273H37.375H26.375V0.5H45.5V19.6071L39.9438 30.5H32.4413ZM6.56633 30.5L11.9454 19.9545L12.3163 19.2273H11.5H0.5V0.5H19.625V19.6071L14.0688 30.5H6.56633Z" stroke="#B5B5B5"></path></svg>',
		'3d-model'        => '<svg xmlns="http://www.w3.org/2000/svg" width="66" height="65" viewBox="0 0 66 65" fill="currentColor"><path d="M42.1 25.7451L34.4093 21.3697C33.9837 21.1281 33.5008 21.001 33.0093 21.001C32.5178 21.001 32.035 21.1281 31.6093 21.3697L23.9 25.7451C23.4741 25.9868 23.1204 26.3345 22.8747 26.7532C22.6289 27.1718 22.4997 27.6467 22.5 28.1301V36.8719C22.4997 37.3552 22.6289 37.8301 22.8747 38.2488C23.1204 38.6675 23.4741 39.0151 23.9 39.2568L31.6093 43.6323C32.035 43.8738 32.5178 44.001 33.0093 44.001C33.5008 44.001 33.9837 43.8738 34.4093 43.6323L42.1 39.2568C42.5259 39.0151 42.8796 38.6675 43.1253 38.2488C43.3711 37.8301 43.5003 37.3552 43.5 36.8719V28.1301C43.5003 27.6467 43.3711 27.1718 43.1253 26.7532C42.8796 26.3345 42.5259 25.9868 42.1 25.7451ZM32.5427 42.0454L24.8333 37.6699C24.6909 37.5891 24.5727 37.4727 24.4908 37.3326C24.4088 37.1924 24.366 37.0335 24.3667 36.8719V28.1301C24.366 27.9685 24.4088 27.8095 24.4908 27.6694C24.5727 27.5292 24.6909 27.4129 24.8333 27.332L32.5427 22.9566C32.6849 22.8773 32.8458 22.8362 33.0093 22.8373C33.1728 22.8362 33.3338 22.8773 33.476 22.9566L41.1667 27.332C41.3151 27.4153 41.4352 27.5397 41.512 27.6898L34.1573 31.8359C33.8039 32.0429 33.512 32.3373 33.3105 32.6898C33.1091 33.0423 33.0052 33.4405 33.0093 33.8448V42.183C32.8447 42.1749 32.6846 42.1277 32.5427 42.0454Z" fill="currentColor"></path></svg>',
		'flash'           => '<svg xmlns="http://www.w3.org/2000/svg" width="21" height="31" viewBox="0 0 21 31" fill="currentColor"><path d="M20.0916 11.5447C20.02 11.3956 19.9077 11.2698 19.7677 11.1817C19.6277 11.0936 19.4656 11.0469 19.3002 11.0469H13.6903L18.3286 1.77202C18.3954 1.63804 18.427 1.48925 18.4204 1.33968C18.4138 1.19011 18.3692 1.04468 18.2908 0.917131C18.1295 0.657911 17.8463 0.5 17.5424 0.5H6.99547C6.81673 0.500164 6.64228 0.5548 6.49538 0.656625C6.34848 0.75845 6.2361 0.902628 6.17322 1.06994L0.899757 15.1325C0.849964 15.2655 0.833013 15.4085 0.850345 15.5494C0.867677 15.6903 0.91878 15.8249 0.999308 15.9419C1.0803 16.0586 1.18832 16.154 1.31417 16.2199C1.44002 16.2858 1.57994 16.3203 1.72201 16.3204H7.62717L4.38446 29.4083C4.33605 29.603 4.35562 29.8084 4.43991 29.9904C4.52421 30.1724 4.66817 30.3201 4.84794 30.4091C5.02771 30.4978 5.23235 30.5225 5.42806 30.4791C5.62376 30.4357 5.7988 30.3269 5.92425 30.1705L19.9868 12.4751C20.0904 12.3458 20.1552 12.1898 20.1738 12.0251C20.1923 11.8604 20.1638 11.6939 20.0916 11.5447Z" fill="currentColor"></path></svg>',
		'sale-flash'      => '<svg width="9" height="12" viewBox="0 0 9 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.45115 5.14843L3.46899 11.8984C3.44574 11.9299 3.41543 11.9555 3.38049 11.9731C3.34555 11.9908 3.30696 11.9999 3.26782 12C3.23487 12 3.20223 11.9935 3.17187 11.9807C3.12021 11.9593 3.07723 11.9212 3.04983 11.8724C3.02242 11.8237 3.01218 11.7671 3.02075 11.7119L3.70849 7.24997H0.750003C0.703741 7.24997 0.658387 7.23713 0.618987 7.21289C0.579587 7.18865 0.547686 7.15395 0.526835 7.11265C0.505983 7.07135 0.496999 7.02508 0.500882 6.97899C0.504765 6.93289 0.521363 6.88877 0.548828 6.85154L5.53099 0.101566C5.56418 0.0565804 5.61149 0.0240191 5.66537 0.00908492C5.71924 -0.00584928 5.77657 -0.00229448 5.82819 0.0191813C5.8798 0.0406571 5.92273 0.0788144 5.95011 0.127556C5.97749 0.176298 5.98775 0.232811 5.97924 0.288065L5.29149 4.74998H8.24998C8.29624 4.74997 8.3416 4.76281 8.38101 4.78705C8.42041 4.8113 8.45232 4.846 8.47317 4.8873C8.49402 4.9286 8.503 4.97488 8.49912 5.02098C8.49523 5.06708 8.47862 5.1112 8.45115 5.14843Z" fill="currentColor"></path></svg>',
		'copy'            => '<svg width="16" height="14" fill="none"><path fill="currentColor" fill-rule="evenodd" d="M14.286 4.667v7.583H4.57V4.667h9.715ZM16 4.375c0-.805-.64-1.458-1.429-1.458H4.286c-.79 0-1.429.653-1.429 1.458v8.167c0 .805.64 1.458 1.429 1.458H14.57c.79 0 1.429-.653 1.429-1.458V4.375Z" clip-rule="evenodd"></path><path fill="currentColor" fill-rule="evenodd" d="M13.43.875A.866.866 0 0 0 12.573 0H1.43C1.05 0 .687.154.42.427A1.474 1.474 0 0 0 0 1.458V10.5c0 .484.384.875.857.875a.866.866 0 0 0 .857-.875V1.75h10.857a.866.866 0 0 0 .858-.874Z" clip-rule="evenodd"></path></svg>',
		'home'			 => '<svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M27.52 11.84l-9.6-7.2c-0.64-0.48-1.28-0.64-1.92-0.64s-1.28 0.16-1.92 0.64l-9.6 7.2c-0.8 0.64-1.28 1.6-1.28 2.56v11.2c0 1.76 1.44 3.2 3.2 3.2h19.2c1.76 0 3.2-1.44 3.2-3.2v-11.2c0-0.96-0.48-1.92-1.28-2.56zM25.6 25.6h-7.2v-4c0-1.28-1.12-2.4-2.4-2.4s-2.4 1.12-2.4 2.4v4h-7.2v-11.2l9.6-7.2 9.6 7.2v11.2z"></path></svg>',
		'support'         => '<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M2.21989 13.7008C2.19942 13.7199 2.18295 13.743 2.17143 13.7685C2.1599 13.7941 2.15354 13.8217 2.15272 13.8497V18.5857C2.15272 19.4124 2.83298 20.0926 3.65962 20.0926H5.5256C5.64874 20.0926 5.74087 20.0005 5.74087 19.8774V13.8497C5.73977 13.793 5.71674 13.7389 5.6766 13.6987C5.63647 13.6586 5.58235 13.6356 5.5256 13.6345H2.36799C2.3118 13.6361 2.25855 13.66 2.21989 13.7008ZM0 13.8497C0.00339224 13.2228 0.253966 12.6224 0.697317 12.1791C1.14067 11.7357 1.74101 11.4851 2.36799 11.4817H5.5256C6.15335 11.4827 6.75513 11.7324 7.19902 12.1763C7.64291 12.6202 7.89268 13.222 7.89359 13.8497V19.8774C7.89428 20.1885 7.83349 20.4967 7.71473 20.7844C7.59597 21.072 7.42157 21.3333 7.20154 21.5533C6.98152 21.7733 6.7202 21.9477 6.4326 22.0665C6.14499 22.1852 5.83676 22.246 5.5256 22.2453H3.65962C1.64468 22.2453 0 20.6007 0 18.5857V13.8497Z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M13.9927 2.15272C12.8144 2.1517 11.6476 2.38302 10.5588 2.83344C9.47008 3.28386 8.48083 3.94455 7.64769 4.77769C6.81455 5.61083 6.15387 6.60007 5.70345 7.68882C5.25303 8.77756 5.02171 9.94444 5.02273 11.1227V12.5719C5.02273 12.8574 4.90933 13.1311 4.70747 13.333C4.50561 13.5348 4.23184 13.6482 3.94637 13.6482C3.6609 13.6482 3.38712 13.5348 3.18527 13.333C2.98341 13.1311 2.87001 12.8574 2.87001 12.5719V11.1227C2.87001 4.97451 7.84451 0 13.9927 0C20.1409 0 25.1154 4.97451 25.1154 11.1227V12.5581C25.1154 12.8436 25.002 13.1174 24.8001 13.3192C24.5982 13.5211 24.3245 13.6345 24.039 13.6345C23.7535 13.6345 23.4798 13.5211 23.2779 13.3192C23.076 13.1174 22.9626 12.8436 22.9626 12.5581V11.1227C22.9626 6.16281 18.9525 2.15272 13.9927 2.15272ZM24.107 20.1133C24.2457 20.1411 24.3775 20.1959 24.495 20.2746C24.6124 20.3534 24.7132 20.4545 24.7916 20.5722C24.87 20.6899 24.9244 20.8219 24.9517 20.9607C24.979 21.0994 24.9788 21.2422 24.9509 21.3808C24.1914 25.1601 20.859 28 16.8627 28H15.4281C15.1426 28 14.8689 27.8866 14.667 27.6847C14.4652 27.4829 14.3518 27.2091 14.3518 26.9236C14.3518 26.6382 14.4652 26.3644 14.667 26.1625C14.8689 25.9607 15.1426 25.8473 15.4281 25.8473H16.8627C18.2705 25.8473 19.635 25.3603 20.7245 24.4688C21.8141 23.5773 22.5617 22.3362 22.8404 20.9563C22.8967 20.6766 23.0617 20.4307 23.2992 20.2726C23.5367 20.1146 23.8273 20.0572 24.107 20.1133Z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M22.3117 13.7008C22.2912 13.7199 22.2747 13.743 22.2632 13.7685C22.2517 13.7941 22.2453 13.8217 22.2445 13.8497V19.8774C22.2445 19.9936 22.3444 20.0926 22.4598 20.0926H24.2543C25.124 20.0926 25.8326 19.3831 25.8326 18.5134V13.8497C25.8315 13.793 25.8085 13.7389 25.7684 13.6987C25.7282 13.6586 25.6741 13.6356 25.6174 13.6345H22.4598C22.4036 13.6361 22.3503 13.66 22.3117 13.7008ZM20.0918 13.8497C20.0952 13.2228 20.3457 12.6224 20.7891 12.1791C21.2324 11.7357 21.8328 11.4851 22.4598 11.4817H25.6174C26.2451 11.4827 26.8469 11.7324 27.2908 12.1763C27.7347 12.6202 27.9845 13.222 27.9854 13.8497V18.5134C27.9847 19.5028 27.5914 20.4515 26.8918 21.1512C26.1923 21.8509 25.2437 22.2444 24.2543 22.2453H22.4598C21.832 22.2444 21.2302 21.9947 20.7863 21.5508C20.3425 21.1069 20.0927 20.5051 20.0918 19.8774V13.8497Z" fill="currentColor"></path></svg>',
		'search-not-found' => '<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg"><mask id="path-1-inside-1_1879_20828" fill="white"><path d="M19.4505 11.7097C21.0956 15.6774 21.7731 17.129 21.386 19.8387C21.2892 20.3226 21.6763 20.9032 22.3537 20.9032C22.8376 20.9032 23.2247 20.5161 23.3214 20.0323C23.7085 16.8387 22.9343 14.9032 21.1924 10.8387L20.1279 8.41935C20.1279 7.83871 20.515 7.74193 20.8053 7.74193H24.1924C25.8376 7.74193 27.0956 6.48387 27.0956 4.83871V2.80645C27.0956 2.41935 27.5795 1.93548 27.9666 1.93548H31.9343C32.515 1.93548 32.9021 2.41935 32.9021 2.80645V4.83871C32.9021 6.48387 34.1602 7.74193 35.8053 7.74193H39.2892C39.5795 7.74193 40.0634 8.12903 39.8698 8.51613L38.2247 12.2903C38.0311 12.7742 38.2247 13.3548 38.7085 13.5484C39.1924 13.7419 39.7731 13.5484 39.9666 13.0645L41.6118 9.19355C41.9021 8.41935 41.8053 7.54839 41.3214 6.87097C40.8376 6.19355 40.0634 5.80645 39.2892 5.80645H35.8053C35.2247 5.80645 34.8376 5.41935 34.8376 4.83871V2.80645C34.8376 1.25806 33.4827 0 31.9343 0H27.9666C26.515 0 25.1602 1.35484 25.1602 2.80645V4.83871C25.1602 5.41935 24.7731 5.80645 24.1924 5.80645H20.8053C19.9343 5.80645 19.1602 6.19355 18.6763 6.87097C18.1924 7.54839 18.0956 8.41935 18.386 9.29032L19.4505 11.7097Z"/></mask><path d="M19.4505 11.7097C21.0956 15.6774 21.7731 17.129 21.386 19.8387C21.2892 20.3226 21.6763 20.9032 22.3537 20.9032C22.8376 20.9032 23.2247 20.5161 23.3214 20.0323C23.7085 16.8387 22.9343 14.9032 21.1924 10.8387L20.1279 8.41935C20.1279 7.83871 20.515 7.74193 20.8053 7.74193H24.1924C25.8376 7.74193 27.0956 6.48387 27.0956 4.83871V2.80645C27.0956 2.41935 27.5795 1.93548 27.9666 1.93548H31.9343C32.515 1.93548 32.9021 2.41935 32.9021 2.80645V4.83871C32.9021 6.48387 34.1602 7.74193 35.8053 7.74193H39.2892C39.5795 7.74193 40.0634 8.12903 39.8698 8.51613L38.2247 12.2903C38.0311 12.7742 38.2247 13.3548 38.7085 13.5484C39.1924 13.7419 39.7731 13.5484 39.9666 13.0645L41.6118 9.19355C41.9021 8.41935 41.8053 7.54839 41.3214 6.87097C40.8376 6.19355 40.0634 5.80645 39.2892 5.80645H35.8053C35.2247 5.80645 34.8376 5.41935 34.8376 4.83871V2.80645C34.8376 1.25806 33.4827 0 31.9343 0H27.9666C26.515 0 25.1602 1.35484 25.1602 2.80645V4.83871C25.1602 5.41935 24.7731 5.80645 24.1924 5.80645H20.8053C19.9343 5.80645 19.1602 6.19355 18.6763 6.87097C18.1924 7.54839 18.0956 8.41935 18.386 9.29032L19.4505 11.7097Z" fill="currentColor"/><path d="M19.4505 11.7097L26.8404 8.64555L26.8076 8.5663L26.773 8.48777L19.4505 11.7097ZM21.386 19.8387L29.2306 21.4076L29.2742 21.1899L29.3056 20.9701L21.386 19.8387ZM23.3214 20.0323L31.1661 21.6012L31.2263 21.2999L31.2633 20.9949L23.3214 20.0323ZM21.1924 10.8387L28.5456 7.68735L28.5304 7.652L28.5149 7.6168L21.1924 10.8387ZM20.1279 8.41935H12.1279V10.1015L12.8054 11.6413L20.1279 8.41935ZM39.8698 8.51613L32.7144 4.93842L32.6203 5.12659L32.5363 5.31944L39.8698 8.51613ZM38.2247 12.2903L30.8911 9.09363L30.8423 9.20569L30.7969 9.31919L38.2247 12.2903ZM39.9666 13.0645L32.604 9.93539L32.5705 10.014L32.5388 10.0934L39.9666 13.0645ZM41.6118 9.19355L48.9744 12.3227L49.0419 12.164L49.1024 12.0025L41.6118 9.19355ZM18.386 9.29032L10.7965 11.8201L10.9139 12.1724L11.0634 12.5122L18.386 9.29032ZM12.0605 14.7738C12.4974 15.8273 12.8018 16.5514 13.0537 17.1936C13.2988 17.8186 13.4083 18.1532 13.4622 18.3509C13.5051 18.5081 13.4959 18.5189 13.4926 18.4629C13.4896 18.4131 13.501 18.4646 13.4664 18.7073L29.3056 20.9701C30.0585 15.6993 28.2886 12.1383 26.8404 8.64555L12.0605 14.7738ZM13.5413 18.2698C12.4471 23.7406 16.6654 28.9032 22.3537 28.9032V12.9032C26.6872 12.9032 30.1312 16.9045 29.2306 21.4076L13.5413 18.2698ZM22.3537 28.9032C27.4692 28.9032 30.4944 24.9594 31.1661 21.6012L15.4768 18.4633C15.9549 16.0728 18.2059 12.9032 22.3537 12.9032V28.9032ZM31.2633 20.9949C31.9384 15.4253 30.2486 11.6612 28.5456 7.68735L13.8393 13.9901C14.7666 16.1538 15.1315 17.0805 15.3144 17.7815C15.4181 18.179 15.4548 18.4488 15.3796 19.0696L31.2633 20.9949ZM28.5149 7.6168L27.4504 5.19744L12.8054 11.6413L13.8699 14.0606L28.5149 7.6168ZM28.1279 8.41935C28.1279 10.0852 27.4439 12.6013 25.0631 14.3328C23.1707 15.7091 21.2979 15.7419 20.8053 15.7419V-0.258066C20.0224 -0.258066 17.8109 -0.17681 15.6524 1.39301C13.0055 3.31802 12.1279 6.17286 12.1279 8.41935H28.1279ZM20.8053 15.7419H24.1924V-0.258066H20.8053V15.7419ZM24.1924 15.7419C30.2559 15.7419 35.0956 10.9021 35.0956 4.83871H19.0956C19.0956 2.06559 21.4193 -0.258066 24.1924 -0.258066V15.7419ZM35.0956 4.83871V2.80645H19.0956V4.83871H35.0956ZM35.0956 2.80645C35.0956 4.3263 34.6414 5.48671 34.2891 6.17071C33.9178 6.89138 33.4718 7.4537 33.0428 7.88266C32.6139 8.31161 32.0515 8.75768 31.3309 9.12893C30.6469 9.48129 29.4865 9.93548 27.9666 9.93548V-6.06452C24.7901 -6.06452 22.6541 -4.35605 21.7291 -3.43105C20.8041 -2.50604 19.0956 -0.370015 19.0956 2.80645H35.0956ZM27.9666 9.93548H31.9343V-6.06452H27.9666V9.93548ZM31.9343 9.93548C29.8956 9.93548 28.1568 9.06035 26.9791 7.88266C25.9364 6.84 24.9021 5.11024 24.9021 2.80645H40.9021C40.9021 -1.99892 36.9333 -6.06452 31.9343 -6.06452V9.93548ZM24.9021 2.80645V4.83871H40.9021V2.80645H24.9021ZM24.9021 4.83871C24.9021 10.9022 29.7419 15.7419 35.8053 15.7419V-0.258066C38.5784 -0.258066 40.9021 2.06559 40.9021 4.83871H24.9021ZM35.8053 15.7419H39.2892V-0.258066H35.8053V15.7419ZM39.2892 15.7419C37.7285 15.7419 36.5551 15.2712 35.9001 14.9378C35.17 14.5661 34.4733 14.0547 33.8637 13.3897C32.7515 12.1764 30.7636 8.84001 32.7144 4.93842L47.0252 12.0938C49.1696 7.80515 47.0365 4.08169 45.6582 2.57806C44.4828 1.29582 42.2923 -0.258066 39.2892 -0.258066V15.7419ZM32.5363 5.31944L30.8911 9.09363L45.5582 15.487L47.2034 11.7128L32.5363 5.31944ZM30.7969 9.31919C29.2606 13.1599 30.4435 18.8586 35.7374 20.9762L41.6797 6.12057C46.0058 7.85103 46.8017 12.3885 45.6525 15.2614L30.7969 9.31919ZM35.7374 20.9762C39.5781 22.5125 45.2769 21.3295 47.3944 16.0356L32.5388 10.0934C34.2692 5.76725 38.8067 4.9714 41.6797 6.12057L35.7374 20.9762ZM47.3293 16.1936L48.9744 12.3227L34.2491 6.06442L32.604 9.93539L47.3293 16.1936ZM49.1024 12.0025C50.2848 8.8494 49.9341 5.16492 47.8313 2.22106L34.8116 11.5209C33.6766 9.93185 33.5194 7.98931 34.1211 6.38456L49.1024 12.0025ZM47.8313 2.22106C45.8602 -0.538465 42.6718 -2.19355 39.2892 -2.19355V13.8064C37.455 13.8064 35.8149 12.9256 34.8116 11.5209L47.8313 2.22106ZM39.2892 -2.19355H35.8053V13.8064H39.2892V-2.19355ZM35.8053 -2.19355C37.333 -2.19355 39.2277 -1.64941 40.7606 -0.116533C42.2934 1.41635 42.8376 3.31105 42.8376 4.83871H26.8376C26.8376 6.94701 27.5753 9.32559 29.4468 11.1972C31.3184 13.0688 33.697 13.8064 35.8053 13.8064V-2.19355ZM42.8376 4.83871V2.80645H26.8376V4.83871H42.8376ZM42.8376 2.80645C42.8376 -3.50686 37.5462 -8 31.9343 -8V8C29.4193 8 26.8376 6.02299 26.8376 2.80645H42.8376ZM31.9343 -8H27.9666V8H31.9343V-8ZM27.9666 -8C24.7654 -8 22.1125 -6.54835 20.3622 -4.79798C18.6118 -3.04761 17.1602 -0.394743 17.1602 2.80645H33.1602C33.1602 4.55603 32.3859 5.80567 31.6759 6.51572C30.9658 7.22577 29.7162 8 27.9666 8V-8ZM17.1602 2.80645V4.83871H33.1602V2.80645H17.1602ZM17.1602 4.83871C17.1602 3.31105 17.7043 1.41635 19.2372 -0.116533C20.7701 -1.64941 22.6648 -2.19355 24.1924 -2.19355V13.8064C26.3007 13.8064 28.6793 13.0688 30.5509 11.1972C32.4225 9.32559 33.1602 6.94701 33.1602 4.83871H17.1602ZM24.1924 -2.19355H20.8053V13.8064H24.1924V-2.19355ZM20.8053 -2.19355C17.4918 -2.19355 14.2321 -0.670931 12.1664 2.22106L25.1862 11.5209C24.0882 13.058 22.3769 13.8064 20.8053 13.8064V-2.19355ZM12.1664 2.22106C9.97835 5.28436 9.82227 8.89747 10.7965 11.8201L25.9754 6.7605C26.369 7.94124 26.4065 9.81241 25.1862 11.5209L12.1664 2.22106ZM11.0634 12.5122L12.128 14.9316L26.773 8.48777L25.7085 6.06841L11.0634 12.5122Z" fill="currentColor" mask="url(#path-1-inside-1_1879_20828)"/><mask id="path-3-inside-2_1879_20828" fill="white"><path d="M20.4199 36.387H33.9683C34.549 36.387 34.9361 35.9999 34.9361 35.4193C34.9361 34.8386 34.549 34.4515 33.9683 34.4515H20.4199C19.9361 34.5483 19.8393 33.9677 19.9361 33.7741L22.4522 24.4838C22.549 23.9999 22.2587 23.4193 21.7748 23.3225C21.2909 23.2257 20.7103 23.516 20.6135 23.9999L18.0974 33.2902C17.9038 34.0644 18.0006 34.8386 18.4845 35.4193C18.8716 35.9999 19.6458 36.387 20.4199 36.387Z"/></mask><path d="M20.4199 36.387H33.9683C34.549 36.387 34.9361 35.9999 34.9361 35.4193C34.9361 34.8386 34.549 34.4515 33.9683 34.4515H20.4199C19.9361 34.5483 19.8393 33.9677 19.9361 33.7741L22.4522 24.4838C22.549 23.9999 22.2587 23.4193 21.7748 23.3225C21.2909 23.2257 20.7103 23.516 20.6135 23.9999L18.0974 33.2902C17.9038 34.0644 18.0006 34.8386 18.4845 35.4193C18.8716 35.9999 19.6458 36.387 20.4199 36.387Z" fill="currentColor"/><path d="M20.4199 34.4515V26.4515H19.6278L18.851 26.6069L20.4199 34.4515ZM19.9361 33.7741L27.0915 37.3518L27.4489 36.6369L27.6579 35.8654L19.9361 33.7741ZM22.4522 24.4838L30.174 26.5751L30.2442 26.316L30.2968 26.0527L22.4522 24.4838ZM20.6135 23.9999L28.3353 26.0912L28.4055 25.8321L28.4581 25.5688L20.6135 23.9999ZM18.0974 33.2902L10.3756 31.1989L10.3552 31.2742L10.3362 31.35L18.0974 33.2902ZM18.4845 35.4193L25.1409 30.9817L24.9038 30.6261L24.6302 30.2978L18.4845 35.4193ZM20.4199 44.387H33.9683V28.387H20.4199V44.387ZM33.9683 44.387C36.0766 44.387 38.4552 43.6493 40.3268 41.7777C42.1984 39.9061 42.9361 37.5276 42.9361 35.4193H26.9361C26.9361 33.8916 27.4802 31.9969 29.0131 30.464C30.546 28.9311 32.4407 28.387 33.9683 28.387V44.387ZM42.9361 35.4193C42.9361 33.311 42.1984 30.9324 40.3268 29.0608C38.4552 27.1892 36.0766 26.4515 33.9683 26.4515V42.4515C32.4407 42.4515 30.546 41.9074 29.0131 40.3745C27.4802 38.8416 26.9361 36.9469 26.9361 35.4193H42.9361ZM33.9683 26.4515H20.4199V42.4515H33.9683V26.4515ZM18.851 26.6069C20.3923 26.2986 22.3223 26.439 24.1403 27.4935C25.8338 28.4757 26.758 29.8598 27.2239 30.8692C27.6856 31.8695 27.8656 32.8394 27.8971 33.6735C27.9226 34.3497 27.8853 35.7642 27.0915 37.3518L12.7807 30.1964C11.9384 31.8808 11.8769 33.4404 11.9085 34.2769C11.946 35.2714 12.1623 36.4166 12.6966 37.5742C13.2351 38.7409 14.2682 40.2641 16.1129 41.334C18.0821 42.4761 20.2056 42.6528 21.9889 42.2962L18.851 26.6069ZM27.6579 35.8654L30.174 26.5751L14.7304 22.3925L12.2143 31.6828L27.6579 35.8654ZM30.2968 26.0527C30.7487 23.7936 30.2872 21.6057 29.3245 19.8728C28.3525 18.1233 26.4124 16.0916 23.3437 15.4779L20.2059 31.1671C17.621 30.6502 16.068 28.9572 15.338 27.6431C14.6172 26.3457 14.2525 24.6901 14.6076 22.9149L30.2968 26.0527ZM23.3437 15.4779C21.0846 15.026 18.8967 15.4875 17.1638 16.4502C15.4143 17.4222 13.3826 19.3622 12.7688 22.431L28.4581 25.5688C27.9412 28.1537 26.2482 29.7067 24.9341 30.4367C23.6367 31.1575 21.9811 31.5222 20.2059 31.1671L23.3437 15.4779ZM12.8917 21.9086L10.3756 31.1989L25.8192 35.3816L28.3353 26.0912L12.8917 21.9086ZM10.3362 31.35C9.70687 33.8674 9.79011 37.4824 12.3387 40.5407L24.6302 30.2978C26.2111 32.1948 26.1008 34.2615 25.8585 35.2305L10.3362 31.35ZM11.8281 39.8569C13.8803 42.9352 17.3153 44.387 20.4199 44.387V28.387C21.3349 28.387 22.1677 28.6069 22.8848 28.9655C23.5865 29.3164 24.4444 29.937 25.1409 30.9817L11.8281 39.8569Z" fill="currentColor" mask="url(#path-3-inside-2_1879_20828)"/><mask id="path-5-inside-3_1879_20828" fill="white"><path d="M42.0979 33.1936L39.5817 23.9032C38.614 20.3226 38.4204 18.6774 38.7108 16.9355C38.8075 16.4516 38.4204 15.871 37.9366 15.7742C37.4527 15.6774 36.872 16.0645 36.7753 16.5484C36.3882 18.7742 36.6785 20.8065 37.6462 24.3871L40.1624 33.5807C40.1624 33.7742 40.1624 34.3548 39.5817 34.3548H37.743C37.1624 34.3548 36.7753 34.7419 36.7753 35.3226C36.7753 35.9032 37.1624 36.2903 37.743 36.2903H39.5817C40.3559 36.2903 41.0333 36 41.5172 35.4194C42.0011 34.8387 42.1946 34.0645 42.0979 33.1936Z"/></mask><path d="M42.0979 33.1936L39.5817 23.9032C38.614 20.3226 38.4204 18.6774 38.7108 16.9355C38.8075 16.4516 38.4204 15.871 37.9366 15.7742C37.4527 15.6774 36.872 16.0645 36.7753 16.5484C36.3882 18.7742 36.6785 20.8065 37.6462 24.3871L40.1624 33.5807C40.1624 33.7742 40.1624 34.3548 39.5817 34.3548H37.743C37.1624 34.3548 36.7753 34.7419 36.7753 35.3226C36.7753 35.9032 37.1624 36.2903 37.743 36.2903H39.5817C40.3559 36.2903 41.0333 36 41.5172 35.4194C42.0011 34.8387 42.1946 34.0645 42.0979 33.1936Z" fill="currentColor"/><path d="M42.0979 33.1936L50.0489 32.3101L49.9808 31.6973L49.8197 31.1022L42.0979 33.1936ZM39.5817 23.9032L31.8588 25.9905L31.8599 25.9946L39.5817 23.9032ZM38.7108 16.9355L30.8661 15.3666L30.8408 15.4931L30.8196 15.6203L38.7108 16.9355ZM36.7753 16.5484L28.9306 14.9795L28.9109 15.0783L28.8936 15.1777L36.7753 16.5484ZM37.6462 24.3871L29.9233 26.4744L29.9267 26.4867L29.93 26.4989L37.6462 24.3871ZM40.1624 33.5807H48.1624V32.5057L47.8786 31.4688L40.1624 33.5807ZM49.8197 31.1022L47.3035 21.8119L31.8599 25.9946L34.376 35.2849L49.8197 31.1022ZM47.3046 21.816C46.8491 20.1304 46.6769 19.257 46.6141 18.7486C46.5694 18.3871 46.5911 18.3156 46.6019 18.2507L30.8196 15.6203C30.2308 19.1531 30.8361 22.2063 31.8588 25.9905L47.3046 21.816ZM46.5554 18.5044C47.1141 15.7112 46.2237 13.311 45.1978 11.7721C44.1719 10.2332 42.2988 8.48821 39.5055 7.92956L36.3676 23.6189C34.0582 23.157 32.6206 21.7507 31.885 20.6473C31.1494 19.5439 30.4042 17.676 30.8661 15.3666L46.5554 18.5044ZM39.5055 7.92956C36.7122 7.37091 34.312 8.26123 32.7732 9.28716C31.2343 10.3131 29.4893 12.1862 28.9306 14.9795L44.6199 18.1173C44.158 20.4267 42.7518 21.8644 41.6484 22.6C40.545 23.3356 38.677 24.0807 36.3676 23.6189L39.5055 7.92956ZM28.8936 15.1777C28.1946 19.1968 28.8864 22.6377 29.9233 26.4744L45.3691 22.2998C44.4706 18.9752 44.5817 18.3517 44.657 17.9191L28.8936 15.1777ZM29.93 26.4989L32.4461 35.6925L47.8786 31.4688L45.3625 22.2753L29.93 26.4989ZM32.1624 33.5807C32.1624 33.8154 32.0772 32.4276 32.7366 30.889C33.1326 29.965 33.901 28.7126 35.3135 27.7186C36.7742 26.6907 38.3337 26.3548 39.5817 26.3548V42.3548C41.12 42.3548 42.8973 41.9464 44.5214 40.8035C46.0971 39.6947 46.9744 38.285 47.443 37.1917C47.8937 36.1399 48.0438 35.2118 48.1044 34.6667C48.1671 34.1022 48.1624 33.6369 48.1624 33.5807H32.1624ZM39.5817 26.3548H37.743V42.3548H39.5817V26.3548ZM37.743 26.3548C35.6347 26.3548 33.2561 27.0925 31.3845 28.9641C29.513 30.8357 28.7753 33.2143 28.7753 35.3226H44.7753C44.7753 36.8502 44.2311 38.745 42.6983 40.2778C41.1654 41.8107 39.2707 42.3548 37.743 42.3548V26.3548ZM28.7753 35.3226C28.7753 37.4309 29.513 39.8095 31.3845 41.6811C33.2561 43.5526 35.6347 44.2903 37.743 44.2903V28.2903C39.2707 28.2903 41.1654 28.8345 42.6983 30.3673C44.2311 31.9002 44.7753 33.7949 44.7753 35.3226H28.7753ZM37.743 44.2903H39.5817V28.2903H37.743V44.2903ZM39.5817 44.2903C42.492 44.2903 45.513 43.1208 47.663 40.5408L35.3714 30.2979C35.9047 29.6579 36.6014 29.1211 37.4092 28.7621C38.2037 28.409 38.9622 28.2903 39.5817 28.2903V44.2903ZM47.663 40.5408C49.8201 37.9523 50.3332 34.869 50.0489 32.3101L34.1468 34.077C34.056 33.2601 34.1821 31.7251 35.3714 30.2979L47.663 40.5408Z" fill="currentColor" mask="url(#path-5-inside-3_1879_20828)"/><path d="M24.1944 28.6452C23.7105 28.4516 23.1298 28.7419 23.0331 29.3226L22.4524 31.2581C22.2589 32.129 23.0331 32.5161 23.4202 32.5161H26.1298C26.7105 32.5161 27.0976 32.129 27.0976 31.5484C27.0976 30.9677 26.7105 30.5806 26.1298 30.5806H24.5815L24.775 29.9032C24.9686 29.4194 24.6782 28.8387 24.1944 28.6452Z" fill="currentColor"/><path d="M4 59.0322C4 59.3214 3.95113 59.656 3.82944 59.9999H1.97701C1.85532 59.656 1.80645 59.3214 1.80645 59.0322C1.80645 58.743 1.85532 58.4084 1.97701 58.0645H3.82944C3.95113 58.4084 4 58.743 4 59.0322Z" fill="currentColor" stroke="currentColor" stroke-width="2"/><mask id="path-9-inside-4_1879_20828" fill="white"><path d="M37.7422 58.0646H36.3873C35.2261 56.1291 33.1938 54.871 30.968 54.5807V39.3872C30.968 38.8065 30.5809 38.4194 30.0002 38.4194C29.4196 38.4194 29.0325 38.8065 29.0325 39.3872V54.5807C26.8067 54.871 24.8712 56.1291 23.6132 58.0646H8.70993C8.12928 58.0646 7.74219 58.4517 7.74219 59.0323C7.74219 59.613 8.12928 60.0001 8.70993 60.0001H37.7422C38.3228 60.0001 38.7099 59.613 38.7099 59.0323C38.7099 58.4517 38.3228 58.0646 37.7422 58.0646ZM26.0325 58.0646C27.097 57.0001 28.4519 56.4194 30.0002 56.4194C31.5486 56.4194 32.9035 57.0001 33.968 58.0646H26.0325Z"/></mask><path d="M37.7422 58.0646H36.3873C35.2261 56.1291 33.1938 54.871 30.968 54.5807V39.3872C30.968 38.8065 30.5809 38.4194 30.0002 38.4194C29.4196 38.4194 29.0325 38.8065 29.0325 39.3872V54.5807C26.8067 54.871 24.8712 56.1291 23.6132 58.0646H8.70993C8.12928 58.0646 7.74219 58.4517 7.74219 59.0323C7.74219 59.613 8.12928 60.0001 8.70993 60.0001H37.7422C38.3228 60.0001 38.7099 59.613 38.7099 59.0323C38.7099 58.4517 38.3228 58.0646 37.7422 58.0646ZM26.0325 58.0646C27.097 57.0001 28.4519 56.4194 30.0002 56.4194C31.5486 56.4194 32.9035 57.0001 33.968 58.0646H26.0325Z" fill="currentColor"/><path d="M36.3873 58.0646L29.5274 62.1806L31.8578 66.0646H36.3873V58.0646ZM30.968 54.5807H22.968V61.605L29.9333 62.5135L30.968 54.5807ZM29.0325 54.5807L30.0672 62.5135L37.0325 61.605V54.5807H29.0325ZM23.6132 58.0646V66.0646H27.9546L30.3207 62.4245L23.6132 58.0646ZM26.0325 58.0646L20.3757 52.4077L6.7188 66.0646H26.0325V58.0646ZM33.968 58.0646V66.0646H53.2817L39.6248 52.4077L33.968 58.0646ZM37.7422 50.0646H36.3873V66.0646H37.7422V50.0646ZM43.2473 53.9486C40.7489 49.7847 36.4927 47.2336 32.0027 46.6479L29.9333 62.5135C29.8926 62.5082 29.8431 62.494 29.7819 62.455C29.7163 62.4133 29.616 62.3283 29.5274 62.1806L43.2473 53.9486ZM38.968 54.5807V39.3872H22.968V54.5807H38.968ZM38.968 39.3872C38.968 37.2789 38.2303 34.9003 36.3587 33.0287C34.4871 31.1571 32.1086 30.4194 30.0002 30.4194V46.4194C28.4726 46.4194 26.5779 45.8753 25.045 44.3424C23.5121 42.8095 22.968 40.9148 22.968 39.3872H38.968ZM30.0002 30.4194C27.8919 30.4194 25.5134 31.1571 23.6418 33.0287C21.7702 34.9003 21.0325 37.2789 21.0325 39.3872H37.0325C37.0325 40.9148 36.4884 42.8095 34.9555 44.3424C33.4226 45.8753 31.5279 46.4194 30.0002 46.4194V30.4194ZM21.0325 39.3872V54.5807H37.0325V39.3872H21.0325ZM27.9978 46.6479C23.327 47.2571 19.3716 49.9108 16.9056 53.7047L30.3207 62.4245C30.3571 62.3684 30.3586 62.3883 30.2949 62.4294C30.2651 62.4486 30.2276 62.4681 30.1842 62.484C30.1405 62.5001 30.0999 62.5093 30.0672 62.5135L27.9978 46.6479ZM23.6132 50.0646H8.70993V66.0646H23.6132V50.0646ZM8.70993 50.0646C6.60162 50.0646 4.22305 50.8023 2.35146 52.6739C0.479873 54.5455 -0.257812 56.924 -0.257812 59.0323H15.7422C15.7422 60.56 15.1981 62.4547 13.6652 63.9876C12.1323 65.5205 10.2376 66.0646 8.70993 66.0646V50.0646ZM-0.257812 59.0323C-0.257812 61.1406 0.479873 63.5192 2.35146 65.3908C4.22305 67.2624 6.60162 68.0001 8.70993 68.0001V52.0001C10.2376 52.0001 12.1323 52.5442 13.6652 54.0771C15.1981 55.61 15.7422 57.5047 15.7422 59.0323H-0.257812ZM8.70993 68.0001H37.7422V52.0001H8.70993V68.0001ZM37.7422 68.0001C39.8505 68.0001 42.2291 67.2624 44.1006 65.3908C45.9722 63.5192 46.7099 61.1406 46.7099 59.0323H30.7099C30.7099 57.5047 31.2541 55.61 32.7869 54.0771C34.3198 52.5442 36.2145 52.0001 37.7422 52.0001V68.0001ZM46.7099 59.0323C46.7099 56.924 45.9722 54.5455 44.1006 52.6739C42.2291 50.8023 39.8505 50.0646 37.7422 50.0646V66.0646C36.2145 66.0646 34.3198 65.5205 32.7869 63.9876C31.2541 62.4547 30.7099 60.56 30.7099 59.0323H46.7099ZM31.6894 63.7214C31.5268 63.884 31.2697 64.0778 30.9214 64.2235C30.5706 64.3701 30.2433 64.4194 30.0002 64.4194V48.4194C26.2912 48.4194 22.9127 49.8707 20.3757 52.4077L31.6894 63.7214ZM30.0002 64.4194C29.7572 64.4194 29.4299 64.3701 29.0791 64.2235C28.7308 64.0778 28.4737 63.884 28.3111 63.7214L39.6248 52.4077C37.0878 49.8707 33.7093 48.4194 30.0002 48.4194V64.4194ZM33.968 50.0646H26.0325V66.0646H33.968V50.0646Z" fill="currentColor" mask="url(#path-9-inside-4_1879_20828)"/><mask id="path-11-inside-5_1879_20828" fill="white"><path d="M59.0316 58.0645H41.6123C41.0316 58.0645 40.6445 58.4515 40.6445 59.0322C40.6445 59.6128 41.0316 59.9999 41.6123 59.9999H59.0316C59.6123 59.9999 59.9994 59.6128 59.9994 59.0322C59.9994 58.4515 59.6123 58.0645 59.0316 58.0645Z"/></mask><path d="M59.0316 58.0645H41.6123C41.0316 58.0645 40.6445 58.4515 40.6445 59.0322C40.6445 59.6128 41.0316 59.9999 41.6123 59.9999H59.0316C59.6123 59.9999 59.9994 59.6128 59.9994 59.0322C59.9994 58.4515 59.6123 58.0645 59.0316 58.0645Z" fill="currentColor"/><path d="M59.0316 50.0645H41.6123V66.0645H59.0316V50.0645ZM41.6123 50.0645C39.504 50.0645 37.1254 50.8021 35.2538 52.6737C33.3822 54.5453 32.6445 56.9239 32.6445 59.0322H48.6445C48.6445 60.5599 48.1004 62.4546 46.5675 63.9874C45.0346 65.5203 43.1399 66.0645 41.6123 66.0645V50.0645ZM32.6445 59.0322C32.6445 61.1405 33.3822 63.5191 35.2538 65.3907C37.1254 67.2623 39.504 67.9999 41.6123 67.9999V51.9999C43.1399 51.9999 45.0346 52.5441 46.5675 54.077C48.1004 55.6098 48.6445 57.5045 48.6445 59.0322H32.6445ZM41.6123 67.9999H59.0316V51.9999H41.6123V67.9999ZM59.0316 67.9999C61.1399 67.9999 63.5185 67.2623 65.3901 65.3907C67.2617 63.5191 67.9994 61.1405 67.9994 59.0322H51.9994C51.9994 57.5045 52.5435 55.6098 54.0764 54.077C55.6093 52.5441 57.504 51.9999 59.0316 51.9999V67.9999ZM67.9994 59.0322C67.9994 56.9239 67.2617 54.5453 65.3901 52.6737C63.5185 50.8021 61.1399 50.0645 59.0316 50.0645V66.0645C57.504 66.0645 55.6093 65.5203 54.0764 63.9874C52.5435 62.4546 51.9994 60.5599 51.9994 59.0322H67.9994Z" fill="currentColor" mask="url(#path-11-inside-5_1879_20828)"/><path d="M7.95979 23.2014C8.01196 23.2917 8.0927 23.3496 8.1947 23.3732L10.1628 23.9023L9.63648 25.8731C9.60863 25.9774 9.62129 26.0792 9.67504 26.1723C9.7269 26.2621 9.80699 26.3198 9.90813 26.3437C10.0094 26.3742 10.1093 26.3619 10.2014 26.3087C10.294 26.2553 10.3548 26.1743 10.3787 26.0705L10.9077 24.1073L12.8724 24.6308C12.9742 24.662 13.0748 24.6498 13.1674 24.5964C13.2594 24.5432 13.3201 24.4628 13.3443 24.3598C13.3741 24.2603 13.3642 24.1621 13.3123 24.0723C13.2586 23.9792 13.1768 23.9173 13.0725 23.8893L11.1027 23.3597L11.6285 21.3907C11.659 21.2906 11.6493 21.1917 11.5971 21.1014C11.5434 21.0083 11.4615 20.9464 11.3573 20.9184C11.2569 20.8914 11.1583 20.9065 11.0674 20.9591C10.9764 21.0116 10.914 21.0894 10.8872 21.1898L10.3609 23.1603L8.39138 22.6308C8.29095 22.6038 8.19242 22.6189 8.10143 22.6714C8.01045 22.724 7.94807 22.8017 7.92124 22.9022C7.89339 23.0065 7.90605 23.1083 7.95979 23.2014Z" fill="currentColor" stroke="currentColor" stroke-width="0.2"/><path d="M3.01415 5.32451C3.0734 5.42713 3.16571 5.49312 3.28019 5.51987L5.19925 6.0358L4.68583 7.95834C4.65464 8.07512 4.66887 8.19057 4.72939 8.2954C4.78819 8.39723 4.87954 8.463 4.99281 8.49013C5.107 8.52416 5.2207 8.50988 5.32409 8.45019C5.42822 8.39008 5.49768 8.29787 5.5249 8.18078L6.04065 6.26656L7.9563 6.77702C8.07131 6.81199 8.18589 6.79793 8.29001 6.73782C8.3934 6.67813 8.46261 6.5868 8.49024 6.47089C8.52337 6.35923 8.5121 6.24723 8.4533 6.1454C8.39278 6.04057 8.29991 5.97052 8.18318 5.93914L6.2615 5.4225L6.77422 3.50258C6.8083 3.39007 6.79731 3.27713 6.73806 3.17451C6.67754 3.06968 6.58467 2.99964 6.46794 2.96825C6.35386 2.93758 6.24173 2.95518 6.14001 3.01391C6.0383 3.07263 5.96699 3.16094 5.93651 3.27508L5.42322 5.19713L3.50202 4.68063C3.38794 4.64996 3.27581 4.66756 3.17409 4.72628C3.07238 4.78501 3.00107 4.87332 2.97059 4.98745C2.9394 5.10423 2.95363 5.21968 3.01415 5.32451Z" fill="currentColor" stroke="currentColor" stroke-width="0.3"/><path d="M48.0141 30.3245C48.0734 30.4271 48.1657 30.4931 48.2802 30.5199L50.1992 31.0358L49.6858 32.9583C49.6546 33.0751 49.6689 33.1906 49.7294 33.2954C49.7882 33.3972 49.8795 33.463 49.9928 33.4901C50.107 33.5242 50.2207 33.5099 50.3241 33.4502C50.4282 33.3901 50.4977 33.2979 50.5249 33.1808L51.0407 31.2666L52.9563 31.777C53.0713 31.812 53.1859 31.7979 53.29 31.7378C53.3934 31.6781 53.4626 31.5868 53.4902 31.4709C53.5234 31.3592 53.5121 31.2472 53.4533 31.1454C53.3928 31.0406 53.2999 30.9705 53.1832 30.9391L51.2615 30.4225L51.7742 28.5026C51.8083 28.3901 51.7973 28.2771 51.7381 28.1745C51.6775 28.0697 51.5847 27.9996 51.4679 27.9683C51.3539 27.9376 51.2417 27.9552 51.14 28.0139C51.0383 28.0726 50.967 28.1609 50.9365 28.2751L50.4232 30.1971L48.502 29.6806C48.3879 29.65 48.2758 29.6676 48.1741 29.7263C48.0724 29.785 48.0011 29.8733 47.9706 29.9875C47.9394 30.1042 47.9536 30.2197 48.0141 30.3245Z" fill="currentColor" stroke="currentColor" stroke-width="0.3"/><circle cx="56.5" cy="11.5" r="2.85" stroke="currentColor" stroke-width="1.3"/><circle cx="8" cy="43" r="2.5" stroke="currentColor"/></svg>',
		'category' 		  => '<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"><path d="M4.83416 0H1.61897C0.726277 0 0 0.726277 0 1.61897V4.83416C0 5.72685 0.726277 6.45312 1.61897 6.45312H4.83416C5.72685 6.45312 6.45312 5.72685 6.45312 4.83416V1.61897C6.45312 0.726277 5.72685 0 4.83416 0ZM5.35938 4.83416C5.35938 5.12375 5.12375 5.35938 4.83416 5.35938H1.61897C1.32937 5.35938 1.09375 5.12375 1.09375 4.83416V1.61897C1.09375 1.32937 1.32937 1.09375 1.61897 1.09375H4.83416C5.12375 1.09375 5.35938 1.32937 5.35938 1.61897V4.83416ZM12.3594 0H9.1875C8.28286 0 7.54688 0.735984 7.54688 1.64062V4.8125C7.54688 5.71714 8.28286 6.45312 9.1875 6.45312H12.3594C13.264 6.45312 14 5.71714 14 4.8125V1.64062C14 0.735984 13.264 0 12.3594 0ZM12.9062 4.8125C12.9062 5.11405 12.6609 5.35938 12.3594 5.35938H9.1875C8.88595 5.35938 8.64062 5.11405 8.64062 4.8125V1.64062C8.64062 1.33908 8.88595 1.09375 9.1875 1.09375H12.3594C12.6609 1.09375 12.9062 1.33908 12.9062 1.64062V4.8125ZM4.83416 7.54688H1.61897C0.726277 7.54688 0 8.27315 0 9.16584V12.381C0 13.2737 0.726277 14 1.61897 14H4.83416C5.72685 14 6.45312 13.2737 6.45312 12.381V9.16584C6.45312 8.27315 5.72685 7.54688 4.83416 7.54688ZM5.35938 12.381C5.35938 12.6706 5.12375 12.9062 4.83416 12.9062H1.61897C1.32937 12.9062 1.09375 12.6706 1.09375 12.381V9.16584C1.09375 8.87625 1.32937 8.64062 1.61897 8.64062H4.83416C5.12375 8.64062 5.35938 8.87625 5.35938 9.16584V12.381ZM12.3594 7.54688H9.1875C8.28286 7.54688 7.54688 8.28286 7.54688 9.1875V12.3594C7.54688 13.264 8.28286 14 9.1875 14H12.3594C13.264 14 14 13.264 14 12.3594V9.1875C14 8.28286 13.264 7.54688 12.3594 7.54688ZM12.9062 12.3594C12.9062 12.6609 12.6609 12.9062 12.3594 12.9062H9.1875C8.88595 12.9062 8.64062 12.6609 8.64062 12.3594V9.1875C8.64062 8.88595 8.88595 8.64062 9.1875 8.64062H12.3594C12.6609 8.64062 12.9062 8.88595 12.9062 9.1875V12.3594Z" fill="currentColor"></path></svg>',
		'play'			  => '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="21" viewBox="0 0 18 21" fill="currentColor"><path d="M18 10.5L0.749999 20.4593L0.75 0.540707L18 10.5Z" fill="currentColor"></path></svg>',
		'move-left-right' => '<svg width="10" height="12" viewBox="0 0 10 12" fill="none"><rect width="2" height="12" rx="1" fill="currentColor"></rect><rect x="4" width="2" height="12" rx="1" fill="currentColor"></rect><rect x="8" width="2" height="12" rx="1" fill="currentColor"></rect></svg>',
		'fire'			 => '<svg xmlns="http://www.w3.org/2000/svg" width="14" height="19" viewBox="0 0 14 19" fill="currentColor"><path d="M7.02105 18.6774C10.055 18.6774 12.7816 16.7396 13.6906 13.8451C13.8829 13.2328 14 12.5829 14 11.908C14 8.13282 10.9092 5.08661 10.9092 5.08661C10.9092 5.08661 11.1221 6.31978 10.9896 7.36947C10.8572 8.41917 10.369 9.06356 10.369 9.06356C10.369 9.06356 10.7255 7.41532 10.2518 6.31025C9.70664 5.03834 8.68975 4.44831 8.29913 3.30309C7.84954 1.98502 8.52322 0.452148 8.52322 0.452148C8.52322 0.452148 6.30738 1.30837 4.70616 3.51789C2.89015 6.02383 4.11387 9.25234 4.11387 9.25234C4.11387 9.25234 3.94461 8.36058 3.02684 7.63809C2.10907 6.91559 2.48087 5.79505 2.48087 5.79505C2.48087 5.79505 0 8.57546 0 11.9081C0 12.8128 0.259084 13.7253 0.636502 14.5745C1.75251 17.0855 4.27321 18.6774 7.02105 18.6774Z" fill="#D10028"></path><path d="M10.9092 5.08661C10.9092 5.08661 11.0247 5.75685 11.0324 6.52958C11.7557 7.74103 12.4378 9.35357 12.4378 11.1269C12.4378 11.8018 12.3208 12.4517 12.1285 13.064C11.2194 15.9585 8.49284 17.8963 5.45889 17.8963C4.65653 17.8962 3.86005 17.7595 3.10354 17.4922C4.26367 18.2655 5.62682 18.6779 7.02105 18.6774C10.055 18.6774 12.7816 16.7396 13.6906 13.8451C13.8829 13.2328 14 12.5829 14 11.908C14 8.13282 10.9092 5.08661 10.9092 5.08661Z" fill="#B7022D"></path><path d="M10.5225 13.5592C10.5225 11.6529 9.27189 10.4233 8.49315 9.63453C7.1065 8.2296 7.3527 6.63104 7.3527 6.63104C7.3527 6.63104 4.63493 8.96756 4.20791 10.9056C3.79964 12.7592 4.82668 13.7896 4.82668 13.7896C4.82668 13.7896 4.34812 13.6048 4.05052 13.2738C3.67147 12.8523 3.53525 12.3415 3.53525 12.3415C3.53525 12.3415 3.37684 12.7248 3.58453 14.0361C3.73216 14.9681 4.21643 15.6656 4.78466 16.1789C6.16577 17.4264 8.3196 17.3057 9.57135 15.9284C10.1077 15.3384 10.5225 14.5588 10.5225 13.5592Z" fill="#FFA91A"></path><path d="M5.15997 13.6162C5.11857 13.6162 5.07725 13.5999 5.04656 13.5675C4.9829 13.5003 4.42427 12.8791 4.42427 11.7617C4.42427 11.506 4.45419 11.2406 4.51308 10.9729C4.59939 10.5811 4.79521 10.1391 5.09498 9.65913C5.11693 9.62399 5.15194 9.599 5.19231 9.58967C5.23268 9.58034 5.27511 9.58743 5.31025 9.60938C5.34539 9.63132 5.37038 9.66633 5.37971 9.7067C5.38904 9.74707 5.38195 9.7895 5.36001 9.82464C5.07913 10.2743 4.8969 10.6832 4.81825 11.0401C4.7642 11.2857 4.73678 11.5285 4.73678 11.7617C4.73678 12.7751 5.25143 13.3294 5.27338 13.3525C5.2944 13.3747 5.30845 13.4026 5.31381 13.4326C5.31917 13.4627 5.31559 13.4937 5.30352 13.5217C5.29145 13.5498 5.27142 13.5737 5.24591 13.5905C5.22039 13.6073 5.19052 13.6162 5.15997 13.6162ZM5.57918 9.38177C5.5503 9.38176 5.522 9.37374 5.4974 9.35861C5.47281 9.34349 5.45289 9.32184 5.43985 9.29608C5.42682 9.27032 5.42118 9.24144 5.42356 9.21267C5.42594 9.18389 5.43625 9.15634 5.45334 9.13307L5.49919 9.07113C5.51146 9.05469 5.52685 9.04082 5.54447 9.03033C5.5621 9.01983 5.58162 9.01291 5.60192 9.00996C5.62222 9.00701 5.64291 9.00808 5.66279 9.01312C5.68268 9.01817 5.70138 9.02707 5.71782 9.03934C5.73426 9.05161 5.74813 9.067 5.75862 9.08462C5.76912 9.10225 5.77604 9.12177 5.77899 9.14207C5.78194 9.16237 5.78087 9.18306 5.77583 9.20294C5.77078 9.22283 5.76187 9.24152 5.74961 9.25797L5.70509 9.31803C5.6906 9.33782 5.67165 9.35391 5.64977 9.36499C5.62789 9.37606 5.6037 9.38181 5.57918 9.38177Z" fill="#FFC91D"></path><path d="M8.49315 9.63453C7.1065 8.2296 7.3527 6.63104 7.3527 6.63104C7.3527 6.63104 6.48929 7.37346 5.65924 8.36832C6.42345 9.15877 7.39808 10.314 7.39808 11.9971C7.39808 12.9967 6.98332 13.7762 6.44696 14.3663C5.83506 15.0396 5.0075 15.4117 4.16011 15.4714C4.34429 15.7386 4.55752 15.9737 4.78466 16.1789C6.16577 17.4264 8.3196 17.3057 9.57135 15.9284C10.1077 15.3384 10.5225 14.5588 10.5225 13.5592C10.5225 11.6529 9.27189 10.4233 8.49315 9.63453Z" fill="#F79219"></path><path d="M8.49315 9.63453C7.1065 8.2296 7.3527 6.63104 7.3527 6.63104C7.3527 6.63104 6.80774 7.10008 6.16772 7.79125C6.33964 8.13876 6.58427 8.50212 6.93099 8.85345C7.70965 9.64234 8.96032 10.8718 8.96032 12.7781C8.96032 13.7778 8.54556 14.5573 8.00919 15.1474C7.17508 16.0652 5.94058 16.4241 4.80099 16.1929C6.18272 17.4251 8.32444 17.3004 9.57135 15.9284C10.1077 15.3384 10.5225 14.5588 10.5225 13.5592C10.5225 11.6529 9.27189 10.4233 8.49315 9.63453Z" fill="#EF7816"></path></svg>',
		'play'			 => '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="21" viewBox="0 0 18 21" fill="currentColor"><path d="M18 10.5L0.749999 20.4593L0.75 0.540707L18 10.5Z" fill="currentColor"></path></svg>',
		'tag'			 => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 252.1V48C0 21.5 21.5 0 48 0h204.1a48 48 0 0 1 33.9 14.1l211.9 211.9c18.7 18.7 18.7 49.1 0 67.9L293.8 497.9c-18.7 18.7-49.1 18.7-67.9 0L14.1 286.1A48 48 0 0 1 0 252.1zM112 64c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z"></path></svg>',
		'edit'			=> '<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.7356 2.10021L2.94644 7.16937C2.76561 7.36187 2.59061 7.74104 2.55561 8.00354L2.33977 9.89354C2.26394 10.576 2.75394 11.0427 3.43061 10.926L5.30894 10.6052C5.57144 10.5585 5.93894 10.366 6.11977 10.1677L10.9089 5.09854C11.7373 4.22354 12.1106 3.22604 10.8214 2.00687C9.5381 0.799375 8.56394 1.22521 7.7356 2.10021Z" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M6.93555 2.9458C7.18638 4.5558 8.49305 5.78663 10.1147 5.94997" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/><path d="M1.75 12.8333H12.25" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/></svg>',
		'eye'			=> '<svg width="30" height="25" viewBox="0 0 30 25" fill="none" xmlns="http://www.w3.org/2000/svg" fill="none"><path fill="currentColor" d="m8.563 12.339.153-.28c.101-.194.25-.431.444-.71.127-.178.267-.369.42-.572a8.86 8.86 0 0 1 .532-.634c.246-.263.517-.525.813-.788.304-.262.635-.503.99-.723.432-.271.906-.491 1.422-.66A5.076 5.076 0 0 1 15 7.705c.592 0 1.147.089 1.663.267.516.169.99.389 1.422.66.355.22.681.461.977.723.305.263.58.525.826.788.194.211.368.423.52.634.161.204.305.394.432.572.195.279.343.516.444.71l.152.28c.043.085.064.17.064.254 0 .084-.021.16-.064.228l-.152.292c-.101.187-.25.424-.444.711-.127.178-.271.373-.432.584a8.1 8.1 0 0 1-.52.622c-.246.263-.52.525-.826.787a7.126 7.126 0 0 1-.977.724c-.432.27-.906.49-1.422.66a5.31 5.31 0 0 1-1.663.254 5.31 5.31 0 0 1-1.663-.254c-.516-.17-.99-.39-1.422-.66a7.827 7.827 0 0 1-.99-.724 12.092 12.092 0 0 1-.813-.787 11.09 11.09 0 0 1-.533-.622l-.419-.584a9.18 9.18 0 0 1-.444-.71l-.153-.293a.49.49 0 0 1 0-.482Zm1.092.241c.051.076.106.17.165.28.068.1.148.22.242.355.11.16.237.334.38.52.144.187.3.373.47.559.22.237.461.47.724.698.262.229.546.44.85.635.364.22.754.402 1.168.546a4.39 4.39 0 0 0 1.346.203 4.27 4.27 0 0 0 1.333-.203 6.022 6.022 0 0 0 1.18-.546c.305-.195.589-.406.851-.635a9.52 9.52 0 0 0 .724-.698c.17-.186.326-.373.47-.559.143-.186.27-.36.38-.52.094-.136.17-.254.229-.356.068-.11.127-.203.178-.279l-.178-.267a3.087 3.087 0 0 0-.229-.355 11.2 11.2 0 0 0-.38-.52 9.134 9.134 0 0 0-1.194-1.27 6.269 6.269 0 0 0-.85-.622A5.178 5.178 0 0 0 16.333 9 4.269 4.269 0 0 0 15 8.797c-.474 0-.922.068-1.346.203a5.256 5.256 0 0 0-1.168.546 6.269 6.269 0 0 0-.85.622 9.134 9.134 0 0 0-1.193 1.27 11.2 11.2 0 0 0-.382.52 5.362 5.362 0 0 0-.24.355c-.06.102-.115.19-.166.267Zm7.516 0c0 .305-.06.588-.178.85-.11.263-.262.492-.457.686a2.143 2.143 0 0 1-1.536.635c-.296 0-.58-.055-.85-.165a2.294 2.294 0 0 1-.686-.47 2.296 2.296 0 0 1-.47-.685 2.178 2.178 0 0 1-.165-.85c0-.297.055-.576.165-.839.119-.262.275-.49.47-.685.194-.195.423-.347.685-.457a2.1 2.1 0 0 1 1.689 0 2.084 2.084 0 0 1 1.155 1.142c.119.263.178.542.178.838Zm-1.092 0c0-.144-.03-.28-.089-.406a.985.985 0 0 0-.228-.356.872.872 0 0 0-.343-.228 1.066 1.066 0 0 0-.85 0 .892.892 0 0 0-.33.228c-.102.102-.183.22-.242.356-.05.127-.076.262-.076.406 0 .152.025.296.076.432.06.127.14.24.241.342a1.064 1.064 0 0 0 1.18.229c.136-.06.25-.135.344-.229.101-.101.178-.215.228-.342.06-.136.09-.28.09-.432Z"></path></svg>',
		'verified'		=> '<svg width="12" height="11" viewBox="0 0 12 11" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.5 5.03906C10.5 4.89844 10.5469 4.78125 10.6406 4.6875C10.7422 4.58594 10.8633 4.53516 11.0039 4.53516C11.1367 4.53516 11.25 4.58594 11.3438 4.6875C11.4453 4.78125 11.4961 4.89844 11.4961 5.03906V5.49609C11.4961 5.87891 11.4609 6.25 11.3906 6.60938C11.3125 6.96875 11.2031 7.3125 11.0625 7.64062C10.9219 7.96875 10.7539 8.28125 10.5586 8.57812C10.3633 8.86719 10.1406 9.13672 9.89062 9.38672C9.64062 9.63672 9.36719 9.85938 9.07031 10.0547C8.78125 10.2578 8.46875 10.4258 8.13281 10.5586C7.80469 10.6992 7.46094 10.8086 7.10156 10.8867C6.74219 10.957 6.375 10.9922 6 10.9922C5.61719 10.9922 5.24609 10.957 4.88672 10.8867C4.52734 10.8086 4.18359 10.6992 3.85547 10.5586C3.52734 10.4258 3.21484 10.2578 2.91797 10.0547C2.62891 9.85938 2.35938 9.63672 2.10938 9.38672C1.85938 9.13672 1.63672 8.86328 1.44141 8.56641C1.23828 8.27734 1.06641 7.96875 0.925781 7.64062C0.792969 7.30469 0.6875 6.95703 0.609375 6.59766C0.539062 6.23828 0.503906 5.87109 0.503906 5.49609C0.503906 5.11328 0.539062 4.74219 0.609375 4.38281C0.6875 4.02344 0.796875 3.67969 0.9375 3.35156C1.07812 3.02344 1.24609 2.71094 1.44141 2.41406C1.63672 2.125 1.85938 1.85547 2.10938 1.60547C2.35938 1.35547 2.63281 1.13281 2.92969 0.9375C3.21875 0.734375 3.52734 0.566406 3.85547 0.433594C4.19141 0.292969 4.53906 0.183594 4.89844 0.105469C5.25781 0.0351562 5.625 0 6 0C6.40625 0 6.79688 0.0429687 7.17188 0.128906C7.55469 0.207031 7.91016 0.324219 8.23828 0.480469C8.36328 0.535156 8.44922 0.628906 8.49609 0.761719C8.55078 0.886719 8.54688 1.01172 8.48438 1.13672C8.42969 1.26172 8.33594 1.35156 8.20312 1.40625C8.07812 1.45312 7.95312 1.44531 7.82812 1.38281C7.5625 1.26562 7.27344 1.17188 6.96094 1.10156C6.65625 1.03125 6.33594 0.996094 6 0.996094C5.38281 0.996094 4.80078 1.11328 4.25391 1.34766C3.70703 1.58203 3.23047 1.90234 2.82422 2.30859C2.41016 2.72266 2.08594 3.20313 1.85156 3.75C1.61719 4.28906 1.5 4.87109 1.5 5.49609C1.5 6.11328 1.61719 6.69531 1.85156 7.24219C2.08594 7.78906 2.40625 8.26562 2.8125 8.67188C3.21875 9.08594 3.69531 9.41016 4.24219 9.64453C4.78906 9.87891 5.375 9.99609 6 9.99609C6.61719 9.99609 7.19922 9.87891 7.74609 9.64453C8.29297 9.41016 8.76953 9.08984 9.17578 8.68359C9.58984 8.27734 9.91406 7.80078 10.1484 7.25391C10.3828 6.70703 10.5 6.12109 10.5 5.49609V5.03906ZM10.6523 1.14844C10.7461 1.04688 10.8594 0.996094 10.9922 0.996094C11.1328 0.996094 11.2539 1.04688 11.3555 1.14844C11.4492 1.24219 11.4961 1.35938 11.4961 1.5C11.4961 1.64062 11.4492 1.75781 11.3555 1.85156L6.35156 6.85547C6.25781 6.95703 6.14062 7.00781 6 7.00781C5.85938 7.00781 5.74219 6.95703 5.64844 6.85547L4.14844 5.35547C4.04688 5.26172 3.99609 5.14453 3.99609 5.00391C3.99609 4.86328 4.04688 4.74609 4.14844 4.65234C4.24219 4.55078 4.35938 4.5 4.5 4.5C4.64062 4.5 4.75781 4.55078 4.85156 4.65234L6 5.80078L10.6523 1.14844Z" fill="currentColor"/></svg>',
		'price-filter-separator' => '<svg width="10" height="2" viewBox="0 0 10 2" fill="none"><path d="M10 0.5L10 1.5L-4.37114e-08 1.5L0 0.5L10 0.5Z" fill="#666"></path></svg>',
		'icon-instagram-shop' => '<svg viewBox="0 0 10 12" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M8.50117 2.50319L7.75176 1.49574H2.24824L1.49883 2.50319H8.50117ZM9.89461 2.69063V2.70234C9.89461 2.70234 9.89852 2.70234 9.90632 2.70234C9.92974 2.7492 9.94926 2.79606 9.96487 2.84292C9.98829 2.88978 10 2.94054 10 2.99521V10.0005C10 10.2036 9.95706 10.3988 9.87119 10.5863C9.79313 10.7659 9.68774 10.9221 9.55503 11.0548C9.42233 11.1954 9.26229 11.3048 9.07494 11.3829C8.89539 11.461 8.70414 11.5 8.50117 11.5H1.49883C1.29586 11.5 1.1007 11.457 0.913349 11.3711C0.733802 11.293 0.577674 11.1876 0.444965 11.0548C0.30445 10.9221 0.19516 10.7659 0.117096 10.5863C0.039032 10.3988 0 10.2036 0 10.0005V2.99521C0 2.96397 0.0039032 2.93273 0.0117096 2.90149C0.019516 2.86244 0.0312256 2.82339 0.0468384 2.78434C0.0546448 2.76873 0.0624512 2.75311 0.0702576 2.73749C0.0858704 2.72187 0.09758 2.70625 0.105386 2.69063L1.60422 0.699148C1.65105 0.63667 1.7096 0.589812 1.77986 0.558573C1.85012 0.519524 1.92428 0.5 2.00234 0.5H7.99766C8.07572 0.5 8.14988 0.519524 8.22014 0.558573C8.2904 0.589812 8.34895 0.63667 8.39578 0.699148L9.89461 2.69063ZM1.00703 3.49893V10.0005C1.00703 10.063 1.01874 10.1255 1.04215 10.188C1.06557 10.2504 1.1007 10.3051 1.14754 10.352C1.19438 10.3988 1.24902 10.434 1.31148 10.4574C1.37393 10.4808 1.43638 10.4925 1.49883 10.4925H8.50117C8.57143 10.4925 8.63388 10.4808 8.68852 10.4574C8.75098 10.434 8.80562 10.3988 8.85246 10.352C8.8993 10.3051 8.93443 10.2504 8.95784 10.188C8.98126 10.1255 8.99297 10.063 8.99297 10.0005V3.49893H1.00703ZM6.49883 4.9984C6.49883 4.85783 6.54567 4.74068 6.63934 4.64696C6.74083 4.54544 6.86183 4.49468 7.00234 4.49468C7.13505 4.49468 7.24824 4.54544 7.34192 4.64696C7.4434 4.74068 7.49414 4.85783 7.49414 4.9984C7.49414 5.34203 7.42779 5.66613 7.29508 5.97071C7.17018 6.27529 6.99454 6.54082 6.76815 6.76731C6.54176 6.99379 6.27635 7.17341 5.9719 7.30618C5.66745 7.43113 5.34348 7.49361 5 7.49361C4.65652 7.49361 4.33255 7.43113 4.0281 7.30618C3.72365 7.17341 3.45824 6.99379 3.23185 6.76731C3.00546 6.54082 2.82592 6.27529 2.69321 5.97071C2.56831 5.66613 2.50585 5.34203 2.50585 4.9984C2.50585 4.85783 2.55269 4.74068 2.64637 4.64696C2.74785 4.54544 2.86495 4.49468 2.99766 4.49468C3.13817 4.49468 3.25527 4.54544 3.34895 4.64696C3.45043 4.74068 3.50117 4.85783 3.50117 4.9984C3.50117 5.20927 3.5402 5.40451 3.61827 5.58413C3.69633 5.76376 3.80562 5.91995 3.94614 6.05272C4.07884 6.19329 4.23497 6.30263 4.41452 6.38072C4.59407 6.45882 4.78923 6.49787 5 6.49787C5.21077 6.49787 5.40593 6.45882 5.58548 6.38072C5.76503 6.30263 5.92115 6.19329 6.05386 6.05272C6.19438 5.91995 6.30367 5.76376 6.38173 5.58413C6.4598 5.40451 6.49883 5.20927 6.49883 4.9984Z" fill="currentColor"/></svg>',
		'icon-lookbook-plus' => '<svg viewBox="0 0 10 10" fill="currentColor"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 0C4.44772 0 4 0.447715 4 1V4L1 4C0.447715 4 0 4.44771 0 5C0 5.55228 0.447715 6 1 6H4V9C4 9.55229 4.44772 10 5 10C5.55228 10 6 9.55228 6 9V6H9C9.55228 6 10 5.55229 10 5C10 4.44772 9.55228 4 9 4L6 4V1C6 0.447715 5.55228 0 5 0Z" fill="currentColor"></path></svg>',
		'icon-instagram'	=> '<svg width="15" height="15" viewBox="0 0 15 15" fill="currentColor"><path fill="currentColor" d="M14.959 4.41c-.035-.797-.164-1.345-.349-1.82a3.66 3.66 0 0 0-.867-1.33 3.691 3.691 0 0 0-1.328-.864c-.477-.185-1.022-.314-1.82-.35C9.794.01 9.539 0 7.502 0 5.465 0 5.21.009 4.41.044c-.797.035-1.345.164-1.82.349a3.66 3.66 0 0 0-1.33.867c-.38.375-.677.83-.864 1.327-.185.478-.314 1.023-.35 1.82C.01 5.21 0 5.465 0 7.501c0 2.037.009 2.292.044 3.092.035.797.164 1.345.349 1.82a3.7 3.7 0 0 0 .867 1.33c.375.38.83.677 1.327.864.478.185 1.023.314 1.82.349.8.035 1.055.044 3.092.044 2.036 0 2.291-.009 3.091-.044.797-.035 1.345-.164 1.82-.349a3.837 3.837 0 0 0 2.194-2.194c.185-.478.314-1.023.35-1.82.034-.8.043-1.055.043-3.092 0-2.036-.003-2.291-.038-3.091Zm-1.35 6.124c-.033.733-.156 1.128-.259 1.392a2.489 2.489 0 0 1-1.424 1.424c-.264.103-.662.226-1.392.258-.79.035-1.028.044-3.03.044-2 0-2.241-.009-3.03-.044-.732-.032-1.128-.155-1.391-.258a2.308 2.308 0 0 1-.862-.56 2.331 2.331 0 0 1-.56-.86c-.102-.265-.225-.663-.257-1.393-.036-.79-.044-1.028-.044-3.03 0-2.001.008-2.241.044-3.03.032-.732.155-1.128.257-1.391.12-.326.311-.622.563-.862.243-.249.536-.44.862-.56.263-.102.662-.225 1.391-.257.792-.036 1.029-.044 3.03-.044 2.005 0 2.242.008 3.03.044.733.032 1.128.155 1.392.257.325.12.621.311.862.56.249.243.44.536.56.862.102.263.225.662.257 1.391.035.792.044 1.029.044 3.03 0 2.002-.009 2.236-.044 3.027Z"></path><path fill="currentColor" d="M7.506 3.648a3.854 3.854 0 0 0 0 7.707 3.854 3.854 0 0 0 0-7.707Zm0 6.353a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5ZM12.405 3.496a.9.9 0 1 1-1.8 0 .9.9 0 0 1 1.8 0Z"></path></svg>',
		'cloud' => '<svg width="40" height="31" viewBox="0 0 40 31" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M31.7161 10.8323C31.6326 4.84596 26.6457 0.000976562 20.5276 0.000976562C17.8061 0.000976562 15.1842 0.972765 13.145 2.73735C11.325 4.31214 10.08 6.41661 9.58694 8.72713C9.55092 8.72675 9.51522 8.72644 9.47959 8.72644C4.25265 8.72644 0 12.9008 0 18.0317C0 23.1625 4.25265 27.3369 9.47967 27.3369H16.1002C16.5712 27.3369 16.9532 26.9621 16.9532 26.4995C16.9532 26.037 16.5712 25.6622 16.1002 25.6622H9.47967C5.19327 25.6622 1.70609 22.2392 1.70609 18.0317C1.70609 13.8242 5.19327 10.4012 9.47967 10.4012C9.70803 10.4012 9.94943 10.4132 10.2178 10.438C10.6726 10.4798 11.081 10.1622 11.1429 9.71741C11.4501 7.50726 12.5618 5.4745 14.2732 3.99358C16.0006 2.49878 18.2218 1.67561 20.5275 1.67561C25.7568 1.67561 30.011 5.85165 30.011 10.9847C30.011 11.1695 29.9971 11.36 29.9823 11.5617L29.976 11.6474C29.9582 11.8937 30.0521 12.1352 30.2328 12.3072C30.4131 12.4792 30.6615 12.5642 30.9122 12.5396C31.1391 12.5171 31.368 12.5059 31.5925 12.5059C35.2876 12.5059 38.2939 15.4568 38.2939 19.084C38.2939 22.7111 35.2877 25.662 31.5925 25.662H24.6307C24.1597 25.662 23.7777 26.0369 23.7777 26.4994C23.7777 26.9619 24.1597 27.3367 24.6307 27.3367H31.5925C36.2284 27.3367 40 23.6346 40 19.084C39.9999 14.5742 36.2952 10.8974 31.7161 10.8323Z" fill="currentColor"/><path d="M20.5285 3.93555C16.9615 3.93555 13.9081 6.55221 13.4259 10.022C13.3622 10.4802 13.6891 10.9024 14.1558 10.9649C14.195 10.9701 14.2338 10.9727 14.2721 10.9727C14.6921 10.9727 15.058 10.6683 15.1162 10.2485C15.4836 7.60429 17.8104 5.61026 20.5285 5.61026C20.9996 5.61026 21.3815 5.23541 21.3815 4.7729C21.3816 4.31047 20.9996 3.93555 20.5285 3.93555Z" fill="currentColor"/><path d="M24.4069 20.4117L21.3039 17.6908C20.769 17.2215 19.9619 17.2216 19.4268 17.6908L16.3238 20.4118C15.9724 20.7199 15.9421 21.2492 16.2559 21.5942C16.5698 21.939 17.109 21.969 17.4605 21.6608L19.5123 19.8616V30.1631C19.5123 30.6256 19.8942 31.0005 20.3654 31.0005C20.8365 31.0005 21.2184 30.6256 21.2184 30.1631V19.8614L23.2704 21.6607C23.433 21.8035 23.6361 21.8736 23.8383 21.8736C24.0729 21.8736 24.3063 21.7794 24.4749 21.5941C24.7886 21.2492 24.7582 20.7199 24.4069 20.4117Z" fill="currentColor"/></svg>',
		'note' => '<svg width="15" height="16" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.8642 1.18519V0.691358C10.8642 0.296296 10.5679 0 10.1728 0C9.77778 0 9.48148 0.395062 9.48148 0.691358V1.08642H5.03704V0.691358C5.03704 0.395062 4.74074 0 4.34568 0C3.95062 0 3.65432 0.395062 3.65432 0.691358V1.18519C1.28395 1.38272 0 2.96296 0 5.4321V11.6543C0 14.4198 1.58025 16 4.34568 16H10.1728C12.9383 16 14.5185 14.4198 14.5185 11.6543V5.4321C14.5185 2.96296 13.2346 1.38272 10.8642 1.18519ZM4.34568 3.55556C4.64198 3.55556 5.03704 3.25926 5.03704 2.8642V2.46914H9.48148V2.8642C9.48148 3.25926 9.87654 3.55556 10.1728 3.55556C10.4691 3.55556 10.8642 3.25926 10.8642 2.8642V2.46914C12.4444 2.66667 13.1358 3.65432 13.1358 5.4321V11.6543C13.1358 13.7284 12.1481 14.6173 10.1728 14.6173H4.34568C2.27161 14.6173 1.38272 13.6296 1.38272 11.6543V5.33333C1.38272 3.55556 2.07407 2.5679 3.65432 2.37037V2.76543C3.65432 3.25926 3.95062 3.55556 4.34568 3.55556Z" fill="currentColor"></path><path d="M4.34565 8.00019H10.1728C10.4691 8.00019 10.8642 7.7039 10.8642 7.30884C10.8642 6.91377 10.4691 6.61748 10.1728 6.61748H4.34565C3.95059 6.61748 3.6543 6.91377 3.6543 7.30884C3.6543 7.7039 4.04936 8.00019 4.34565 8.00019Z" fill="currentColor"></path><path d="M7.30862 10.2715H4.34565C3.95059 10.2715 3.6543 10.5678 3.6543 10.9629C3.6543 11.3579 4.04936 11.6542 4.34565 11.6542H7.30862C7.60491 11.6542 7.99998 11.3579 7.99998 10.9629C7.99998 10.5678 7.60491 10.2715 7.30862 10.2715Z" fill="currentColor"></path></svg>',
		'discount' => '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 20 20" fill="none"><path d="M3.32408 12.2187L2.05742 10.952C1.54076 10.4353 1.54076 9.5853 2.05742 9.06863L3.32408 7.80195C3.54075 7.58528 3.71575 7.16028 3.71575 6.86028V5.06859C3.71575 4.33526 4.31575 3.73528 5.04909 3.73528H6.84075C7.14075 3.73528 7.56575 3.5603 7.78242 3.34364L9.04908 2.07695C9.56574 1.56029 10.4158 1.56029 10.9324 2.07695L12.1991 3.34364C12.4158 3.5603 12.8407 3.73528 13.1407 3.73528H14.9324C15.6658 3.73528 16.2657 4.33526 16.2657 5.06859V6.86028C16.2657 7.16028 16.4407 7.58528 16.6574 7.80195L17.9241 9.06863C18.4408 9.5853 18.4408 10.4353 17.9241 10.952L16.6574 12.2187C16.4407 12.4353 16.2657 12.8603 16.2657 13.1603V14.9519C16.2657 15.6852 15.6658 16.2853 14.9324 16.2853H13.1407C12.8407 16.2853 12.4158 16.4603 12.1991 16.677L10.9324 17.9437C10.4158 18.4603 9.56574 18.4603 9.04908 17.9437L7.78242 16.677C7.56575 16.4603 7.14075 16.2853 6.84075 16.2853H5.04909C4.31575 16.2853 3.71575 15.6852 3.71575 14.9519V13.1603C3.71575 12.852 3.54075 12.427 3.32408 12.2187Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.5 12.502L12.5 7.50195" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.0788 12.0856H12.0862" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.91209 7.91862H7.91957" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path></svg>',
		'box' => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.7633 2.65861L9.8962 0.435045C8.83275 -0.145015 7.28593 -0.145015 6.31916 0.435045L2.45209 2.65861C1.38865 3.23867 0.518555 4.68882 0.518555 5.94562V10.1027C0.518555 11.3595 1.38865 12.713 2.45209 13.3897L6.31916 15.6133C6.80254 15.9033 7.47928 16 8.15602 16C8.83275 16 9.41282 15.9033 9.99288 15.6133L13.8599 13.3897C14.9234 12.8097 15.7935 11.3595 15.7935 10.1027V5.84894C15.6968 4.68882 14.8267 3.23867 13.7633 2.65861ZM6.80254 1.49849C7.09257 1.30514 7.57596 1.20846 8.05934 1.20846C8.54272 1.20846 8.92943 1.30514 9.31614 1.49849L13.1832 3.72205C13.4732 3.81873 13.6666 4.10876 13.8599 4.39879L11.7331 5.65559L5.7391 2.07855L6.80254 1.49849ZM2.93547 3.62538L4.57898 2.65861L10.5729 6.13897L8.05934 7.6858L2.16206 4.30212C2.35541 4.01208 2.64544 3.81873 2.93547 3.62538ZM2.93547 12.2296C2.25874 11.8429 1.582 10.7795 1.582 10.006V5.84894C1.582 5.65559 1.582 5.46224 1.67868 5.26888L7.47928 8.65257V14.6465C7.18925 14.6465 6.9959 14.5498 6.80254 14.4532L2.93547 12.2296ZM14.5367 10.006C14.5367 10.7795 13.9566 11.8429 13.1832 12.2296L9.31614 14.3565C9.12279 14.4532 8.92943 14.5498 8.6394 14.5498V8.65257L11.153 7.20242V8.84592C11.153 9.13595 11.443 9.42598 11.7331 9.42598C12.0231 9.42598 12.3131 9.13595 12.3131 8.84592V6.52568L14.44 5.26888C14.44 5.55891 14.5367 5.75227 14.5367 5.84894V10.006Z" fill="currentColor"></path></svg>',			
	);

	/**
	 * Store the code for all SVGs in an array.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public static function inline_icons() {
		$args = array(
			'<symbol id="star" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.97635 3.78143C10.0089 3.88335 10.0122 3.98868 9.98611 4.0974C9.96007 4.20612 9.90473 4.29785 9.8201 4.37259L7.64236 6.37033L8.28689 9.32616C8.30642 9.43488 8.29666 9.5402 8.2576 9.64213C8.22504 9.74405 8.16645 9.82899 8.08181 9.89694C7.99067 9.96489 7.89301 9.99887 7.78885 9.99887C7.68468 10.0057 7.58702 9.98188 7.49588 9.92752L5.00564 8.36806L2.51541 9.92752C2.47635 9.94791 2.43077 9.96489 2.37869 9.97848C2.33312 9.99207 2.28754 9.99887 2.24197 9.99887C2.18989 9.99887 2.13455 9.98868 2.07595 9.96829C2.02387 9.9547 1.97504 9.93092 1.92947 9.89694C1.84484 9.82899 1.78299 9.74405 1.74392 9.64213C1.71137 9.5402 1.70486 9.43488 1.72439 9.32616L2.36892 6.37033L0.191189 4.37259C0.106554 4.29785 0.0512153 4.20612 0.0251736 4.0974C-0.000868056 3.98868 0.00238715 3.88335 0.0349392 3.78143C0.0674913 3.67271 0.12283 3.58437 0.200955 3.51642C0.28559 3.44847 0.379991 3.4077 0.484158 3.39411L3.37478 3.12911L4.51736 0.336353C4.55642 0.234428 4.62153 0.152888 4.71267 0.0917327C4.80382 0.0305776 4.90148 0 5.00564 0C5.10981 0 5.20747 0.0305776 5.29861 0.0917327C5.38976 0.152888 5.45486 0.234428 5.49392 0.336353L6.6365 3.12911L9.52713 3.39411C9.63129 3.4077 9.72244 3.44847 9.80056 3.51642C9.8852 3.58437 9.94379 3.67271 9.97635 3.78143Z" fill="currentColor"/></symbol>',
			'<symbol id="heart" viewBox="0 0 19 16"><path d="M17.4693 1.46278C16.4831 0.52335 15.178 0 13.8216 0C12.4652 0 11.1601 0.52335 10.1739 1.46278L9.5 2.11096L8.8261 1.46278C7.84238 0.51698 6.53343 -0.00720742 5.17448 0.000442952C3.81807 -0.00598466 2.512 0.518175 1.53069 1.46278C1.04762 1.9183 0.662488 2.46909 0.399178 3.08097C0.135869 3.69285 0 4.35278 0 5.01983C0 5.68687 0.135869 6.3468 0.399178 6.95868C0.662488 7.57057 1.04762 8.12135 1.53069 8.57687L8.96715 15.7858C9.04006 15.8502 9.12189 15.9034 9.21006 15.9439C9.39624 16.0187 9.60376 16.0187 9.78994 15.9439C9.87811 15.9034 9.95994 15.8502 10.0329 15.7858L17.4693 8.57687C17.9524 8.12135 18.3375 7.57057 18.6008 6.95868C18.8641 6.3468 19 5.68687 19 5.01983C19 4.35278 18.8641 3.69285 18.6008 3.08097C18.3375 2.46909 17.9524 1.9183 17.4693 1.46278ZM17.4693 5.00402C17.4715 5.47163 17.3796 5.93483 17.1991 6.36555C17.0186 6.79627 16.7533 7.18553 16.4193 7.50976L9.5 14.2286L2.58856 7.50976C2.24936 7.18822 1.97903 6.80001 1.79425 6.36906C1.60946 5.93811 1.51413 5.47355 1.51413 5.00402C1.51413 4.53448 1.60946 4.06992 1.79425 3.63897C1.97903 3.20802 2.24936 2.81981 2.58856 2.49828C3.28454 1.82749 4.21191 1.45613 5.17448 1.46278C6.14183 1.45534 7.07438 1.82652 7.77606 2.49828L8.96715 3.66025C9.04006 3.72459 9.12189 3.77785 9.21006 3.81834C9.39624 3.89313 9.60376 3.89313 9.78994 3.81834C9.87811 3.77785 9.95994 3.72459 10.0329 3.66025L11.2318 2.49828C11.9277 1.82749 12.8551 1.45613 13.8177 1.46278C14.785 1.45534 15.7176 1.82652 16.4193 2.49828C16.7562 2.82115 17.0244 3.20981 17.2076 3.64059C17.3908 4.07137 17.4852 4.53526 17.485 5.00402H17.4693Z" fill="currentColor"/></symbol>',
			'<symbol id="heart-filled" viewBox="0 0 20 20"><path d="M10 3.22l-0.61-0.6c-0.983-0.931-2.314-1.504-3.779-1.504-3.038 0-5.5 2.462-5.5 5.5 0 1.462 0.571 2.791 1.501 3.776l-0.002-0.003 8.39 8.39 8.39-8.4c0.928-0.983 1.499-2.312 1.499-3.774 0-3.038-2.462-5.5-5.5-5.5-1.465 0-2.796 0.573-3.782 1.506l0.003-0.002-0.61 0.61z"></path></symbol>',
			'<symbol id="trash"><path fill="currentColor" d="M10.5 4.25h-7v7.588c0 .073.014.146.041.219a.727.727 0 0 0 .137.191.416.416 0 0 0 .177.123c.073.027.15.041.233.041h5.824c.082 0 .16-.014.232-.04a.416.416 0 0 0 .178-.124.53.53 0 0 0 .123-.191.485.485 0 0 0 .055-.22V4.25Zm-.588-1.162h2.338c.164 0 .3.06.41.178a.52.52 0 0 1 .178.396c0 .164-.06.305-.178.424a.557.557 0 0 1-.41.164h-.588v7.588c0 .237-.046.465-.137.684-.09.21-.214.391-.369.546a1.615 1.615 0 0 1-.56.383c-.21.091-.438.137-.684.137H4.088c-.246 0-.474-.05-.684-.15a1.931 1.931 0 0 1-.56-.37 1.755 1.755 0 0 1-.37-.546 1.76 1.76 0 0 1-.136-.684V4.25H1.75a.603.603 0 0 1-.424-.164.603.603 0 0 1-.164-.424.54.54 0 0 1 .164-.396.579.579 0 0 1 .424-.178h2.338V2.5c0-.237.045-.46.137-.67.09-.219.214-.406.369-.56.155-.165.337-.292.547-.383.218-.091.45-.137.697-.137h2.324c.246 0 .474.046.684.137.21.09.396.218.56.383.155.154.278.341.37.56.09.21.136.433.136.67v.588Zm-4.662 0h3.5V2.5a.433.433 0 0 0-.055-.219.531.531 0 0 0-.123-.191.416.416 0 0 0-.177-.123.513.513 0 0 0-.233-.055H5.838a.513.513 0 0 0-.233.055.416.416 0 0 0-.177.123.73.73 0 0 0-.137.191.55.55 0 0 0-.041.219v.588Zm0 3.5c0-.164.055-.3.164-.41A.579.579 0 0 1 5.838 6a.52.52 0 0 1 .396.178c.119.11.178.246.178.41v3.5c0 .155-.06.292-.178.41a.54.54 0 0 1-.396.164.603.603 0 0 1-.424-.164.587.587 0 0 1-.164-.41v-3.5Zm2.338 0c0-.164.055-.3.164-.41a.563.563 0 0 1 .82 0c.119.11.178.246.178.41v3.5c0 .155-.06.292-.178.41a.556.556 0 0 1-.41.164.587.587 0 0 1-.41-.164.587.587 0 0 1-.164-.41v-3.5Z"></path></symbol>',
			'<symbol id="cross-arrow" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M6.59 5.17L1.41 0L0 1.41L5.17 6.58L6.59 5.17ZM10.5 0L12.54 2.04L0 14.59L1.41 16L13.96 3.46L16 5.5V0H10.5ZM10.83 9.41L9.42 10.82L12.55 13.95L10.5 16H16V10.5L13.96 12.54L10.83 9.41Z" /></symbol>',
			'<symbol id="check" viewBox="0 0 16 12"><path d="M0 6.5105L5.4791 12.0001L16 1.48956L14.4896 0L5.4791 8.99999L1.48953 5.01045L0 6.5105Z"></path></symbol>',
			'<symbol id="eye" viewBox="0 0 19 12"><path d="M18.7079 5.6338C18.5397 5.40371 14.5321 0 9.4137 0C4.29527 0 0.287485 5.40371 0.119471 5.63358C0.041836 5.73994 0 5.86821 0 5.99989C0 6.13157 0.041836 6.25984 0.119471 6.3662C0.287485 6.59629 4.29527 12 9.4137 12C14.5321 12 18.5397 6.59625 18.7079 6.36638C18.7857 6.26008 18.8276 6.13179 18.8276 6.00009C18.8276 5.86839 18.7857 5.74011 18.7079 5.6338ZM9.4137 10.7586C5.64343 10.7586 2.37798 7.17207 1.41133 5.99958C2.37673 4.82605 5.63534 1.24137 9.4137 1.24137C13.1838 1.24137 16.449 4.8273 17.4161 6.00042C16.4507 7.17391 13.1921 10.7586 9.4137 10.7586Z"></path><path d="M9.4137 2.27586C7.36024 2.27586 5.68954 3.94656 5.68954 6.00002C5.68954 8.05348 7.36024 9.72417 9.4137 9.72417C11.4672 9.72417 13.1379 8.05348 13.1379 6.00002C13.1379 3.94656 11.4672 2.27586 9.4137 2.27586ZM9.4137 8.48276C8.04465 8.48276 6.93095 7.36903 6.93095 6.00002C6.93095 4.63101 8.04469 3.51727 9.4137 3.51727C10.7827 3.51727 11.8964 4.63101 11.8964 6.00002C11.8964 7.36903 10.7827 8.48276 9.4137 8.48276Z"></path></symbol>',
			'<symbol id="arrow-left-long" viewBox="0 0 7 11" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M5.5 11L0 5.5L5.5 0L6.47625 0.97625L1.9525 5.5L6.47625 10.0238L5.5 11Z" fill="currentColor"/></symbol>',
			'<symbol id="arrow-right-long" viewBox="0 0 7 11" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M1.5 11L7 5.5L1.5 0L0.52375 0.97625L5.0475 5.5L0.52375 10.0238L1.5 11Z" fill="currentColor"/></symbol>',
			'<symbol id="icon-back" viewBox="0 0 6 11" fill="none"><path d="M4.7193 10.7605C4.85965 10.9202 5.03509 11 5.24561 11C5.45614 11 5.63158 10.9202 5.77193 10.7605C5.92398 10.6131 6 10.435 6 10.2261C6 10.005 5.92398 9.81463 5.77193 9.65494L1.80702 5.49079L5.77193 1.32663C5.92398 1.17923 6 1.00112 6 0.792295C6 0.571189 5.92398 0.380793 5.77193 0.221106C5.63158 0.0737018 5.45614 0 5.24561 0C5.03509 0 4.85965 0.0737018 4.7193 0.221106L0.22807 4.93802C0.0760236 5.09771 0 5.28811 0 5.50921C0 5.71803 0.0760236 5.89615 0.22807 6.04355L4.7193 10.7605Z" fill="currentColor"></path></symbol>',
			'<symbol id="icon-next" viewBox="0 0 6 11" fill="none"><path fill="currentColor" d="M1.278 10.721a.688.688 0 0 1-.528.229.688.688 0 0 1-.527-.229.669.669 0 0 1-.229-.51c0-.21.077-.392.229-.544l3.973-3.973L.223 1.721a.669.669 0 0 1-.229-.51c0-.21.077-.392.229-.544C.363.527.539.456.75.456c.211 0 .387.07.528.21l4.5 4.5a.744.744 0 0 1 .228.546c0 .199-.076.369-.228.51l-4.5 4.5Z"></path></symbol>',
			'<symbol id="icon-wishlist" viewBox="0 0 19 16"><path d="M17.4693 1.46278C16.4831 0.52335 15.178 0 13.8216 0C12.4652 0 11.1601 0.52335 10.1739 1.46278L9.5 2.11096L8.8261 1.46278C7.84238 0.51698 6.53343 -0.00720742 5.17448 0.000442952C3.81807 -0.00598466 2.512 0.518175 1.53069 1.46278C1.04762 1.9183 0.662488 2.46909 0.399178 3.08097C0.135869 3.69285 0 4.35278 0 5.01983C0 5.68687 0.135869 6.3468 0.399178 6.95868C0.662488 7.57057 1.04762 8.12135 1.53069 8.57687L8.96715 15.7858C9.04006 15.8502 9.12189 15.9034 9.21006 15.9439C9.39624 16.0187 9.60376 16.0187 9.78994 15.9439C9.87811 15.9034 9.95994 15.8502 10.0329 15.7858L17.4693 8.57687C17.9524 8.12135 18.3375 7.57057 18.6008 6.95868C18.8641 6.3468 19 5.68687 19 5.01983C19 4.35278 18.8641 3.69285 18.6008 3.08097C18.3375 2.46909 17.9524 1.9183 17.4693 1.46278ZM17.4693 5.00402C17.4715 5.47163 17.3796 5.93483 17.1991 6.36555C17.0186 6.79627 16.7533 7.18553 16.4193 7.50976L9.5 14.2286L2.58856 7.50976C2.24936 7.18822 1.97903 6.80001 1.79425 6.36906C1.60946 5.93811 1.51413 5.47355 1.51413 5.00402C1.51413 4.53448 1.60946 4.06992 1.79425 3.63897C1.97903 3.20802 2.24936 2.81981 2.58856 2.49828C3.28454 1.82749 4.21191 1.45613 5.17448 1.46278C6.14183 1.45534 7.07438 1.82652 7.77606 2.49828L8.96715 3.66025C9.04006 3.72459 9.12189 3.77785 9.21006 3.81834C9.39624 3.89313 9.60376 3.89313 9.78994 3.81834C9.87811 3.77785 9.95994 3.72459 10.0329 3.66025L11.2318 2.49828C11.9277 1.82749 12.8551 1.45613 13.8177 1.46278C14.785 1.45534 15.7176 1.82652 16.4193 2.49828C16.7562 2.82115 17.0244 3.20981 17.2076 3.64059C17.3908 4.07137 17.4852 4.53526 17.485 5.00402H17.4693Z" fill="currentColor"/></symbol>',
			'<symbol id="icon-compare" viewBox="0 0 14 14"><path fill="currentColor" d="m7 1.98 4.525 2.27L7 6.52 2.475 4.25 7 1.98ZM6.74.818.902 3.73a.587.587 0 0 0-.3.342.568.568 0 0 0 .04.438.517.517 0 0 0 .11.164.844.844 0 0 0 .15.096L6.74 7.682a.527.527 0 0 0 .52 0l5.838-2.912a.536.536 0 0 0 .287-.329.556.556 0 0 0-.028-.45.378.378 0 0 0-.109-.151.577.577 0 0 0-.15-.11L7.26.805a.633.633 0 0 0-.52 0v.013Zm-5.838 9.79L6.74 13.52a.434.434 0 0 0 .26.054.632.632 0 0 0 .26-.054l5.838-2.913a.537.537 0 0 0 .287-.341.522.522 0 0 0-.028-.438.537.537 0 0 0-.341-.287.559.559 0 0 0-.438.014L7 12.344 1.422 9.568a.522.522 0 0 0-.438-.027.537.537 0 0 0-.341.287.56.56 0 0 0-.041.438.586.586 0 0 0 .3.341Zm0-2.926 5.838 2.925a.632.632 0 0 0 .52 0l5.838-2.925a.493.493 0 0 0 .287-.328.556.556 0 0 0-.028-.452.537.537 0 0 0-.341-.287.522.522 0 0 0-.438.028L7 9.432l-5.578-2.79a.522.522 0 0 0-.438-.027.537.537 0 0 0-.341.287.598.598 0 0 0-.041.452.587.587 0 0 0 .3.341v-.013Z"></path></symbol>',
			'<symbol id="icon-quickview" viewBox="0 0 14 12"><path fill="currentColor" d="m.068 5.904.164-.3c.11-.21.27-.465.479-.766.137-.192.287-.397.451-.615.173-.228.365-.456.574-.684a13 13 0 0 1 .875-.848 8.431 8.431 0 0 1 1.067-.779 6.929 6.929 0 0 1 1.531-.71A5.466 5.466 0 0 1 7 .913c.638 0 1.235.096 1.791.287a6.93 6.93 0 0 1 1.531.711c.383.237.734.497 1.053.78.328.282.624.565.889.847.21.228.396.456.56.684.173.218.328.423.465.615.21.3.37.556.479.766l.164.3a.606.606 0 0 1 .068.274.455.455 0 0 1-.068.246l-.164.314c-.11.2-.27.456-.479.766-.137.191-.292.401-.465.629-.164.219-.35.442-.56.67-.265.282-.56.565-.889.847a7.68 7.68 0 0 1-1.053.78 6.929 6.929 0 0 1-1.531.71A5.715 5.715 0 0 1 7 11.415a5.715 5.715 0 0 1-1.791-.273 6.928 6.928 0 0 1-1.531-.711 8.434 8.434 0 0 1-1.067-.78c-.319-.282-.61-.565-.875-.847-.21-.228-.4-.451-.574-.67l-.451-.63C.5 7.195.34 6.94.232 6.739l-.164-.314a.527.527 0 0 1 0-.52Zm1.176.26c.055.082.114.182.178.3.073.11.16.238.26.384.118.173.255.36.41.56.155.2.323.401.506.602.237.255.496.506.779.752.283.246.588.474.916.683a6.61 6.61 0 0 0 1.258.588c.456.146.939.219 1.449.219.51 0 .989-.073 1.436-.219.455-.155.88-.35 1.271-.588.328-.21.633-.437.916-.683.283-.246.542-.497.78-.752.182-.2.35-.401.505-.602.155-.2.292-.387.41-.56.1-.146.183-.274.247-.383a9.97 9.97 0 0 1 .19-.3l-.19-.288a3.318 3.318 0 0 0-.247-.383c-.118-.173-.255-.36-.41-.56a9.822 9.822 0 0 0-1.285-1.368 6.746 6.746 0 0 0-.916-.67 5.576 5.576 0 0 0-1.271-.587A4.598 4.598 0 0 0 7 2.089c-.51 0-.993.074-1.45.22a5.66 5.66 0 0 0-1.257.587c-.328.201-.633.424-.916.67a9.835 9.835 0 0 0-1.285 1.367c-.155.201-.292.388-.41.561-.1.137-.187.264-.26.383-.064.11-.123.205-.178.287Zm8.094 0a2.2 2.2 0 0 1-.192.916 2.279 2.279 0 0 1-.492.738A2.31 2.31 0 0 1 7 8.502a2.41 2.41 0 0 1-.916-.178 2.472 2.472 0 0 1-.738-.506 2.472 2.472 0 0 1-.506-.738 2.344 2.344 0 0 1-.178-.916c0-.319.06-.62.178-.902.127-.283.296-.529.506-.739.21-.21.455-.373.738-.492a2.261 2.261 0 0 1 1.818 0c.292.119.543.283.752.492.21.21.374.456.492.739.128.282.192.583.192.902Zm-1.176 0c0-.155-.032-.3-.096-.437a1.063 1.063 0 0 0-.246-.383.94.94 0 0 0-.369-.246 1.147 1.147 0 0 0-.916 0 .96.96 0 0 0-.355.246c-.11.11-.196.237-.26.383a1.167 1.167 0 0 0-.082.437c0 .164.027.32.082.465.064.137.15.26.26.37a1.147 1.147 0 0 0 1.271.246c.146-.065.269-.147.37-.247.109-.11.19-.232.245-.37.064-.145.096-.3.096-.464Z"></path></symbol>',
			'<symbol id="icon-search" viewBox="0 0 16 16"><path fill="currentColor" d="M11.2 11.04c-.094 0-.094 0 0 0l-.094.095c-.47.467-1.035.842-1.788 1.122-.66.281-1.412.375-2.165.375-.753 0-1.506-.188-2.165-.468A5.52 5.52 0 0 1 3.2 10.947 5.993 5.993 0 0 1 1.976 9.17C1.694 8.608 1.6 7.953 1.6 7.205c0-.749.188-1.497.47-2.152.283-.749.66-1.31 1.13-1.872.565-.468 1.13-.842 1.788-1.123.66-.28 1.412-.467 2.165-.467.753 0 1.506.187 2.165.467.658.281 1.317.655 1.788 1.217.47.468.847 1.123 1.223 1.778.283.655.471 1.31.471 2.152 0 .748-.188 1.497-.47 2.152a8.78 8.78 0 0 1-1.13 1.684Zm4.518 3.463-2.918-2.9c.47-.656.847-1.31 1.13-2.06.282-.748.376-1.59.376-2.432 0-1.03-.188-1.965-.565-2.807-.376-.842-.847-1.59-1.506-2.246-.659-.654-1.412-1.122-2.259-1.497C9.13.187 8.188 0 7.153 0 6.212 0 5.27.187 4.329.561c-.847.375-1.6.843-2.258 1.497-.66.655-1.13 1.404-1.506 2.34C.188 5.24 0 6.175 0 7.205c0 .935.188 1.871.565 2.807.376.842.94 1.59 1.6 2.245.659.655 1.411 1.123 2.259 1.591.847.28 1.788.468 2.729.468.847 0 1.694-.094 2.447-.375.753-.28 1.506-.655 2.07-1.122l2.918 2.9c.189.187.377.281.565.281.188 0 .376-.094.565-.28.188-.188.282-.375.282-.562 0-.28-.094-.468-.282-.655Z"></path></symbol>',
			'<symbol id="icon-tick" viewBox="0 0 10 8"><path d="M9.04948 0.651625C9.16233 0.550542 9.29253 0.5 9.4401 0.5C9.59635 0.5 9.72656 0.550542 9.83073 0.651625C9.94358 0.761131 10 0.891697 10 1.04332C10 1.18652 9.94358 1.30866 9.83073 1.40975L3.72396 7.34838C3.61979 7.44946 3.48958 7.5 3.33333 7.5C3.17708 7.5 3.04688 7.44946 2.94271 7.34838L0.169271 4.6444C0.0564236 4.54332 0 4.42118 0 4.27798C0 4.12635 0.0564236 3.99579 0.169271 3.88628C0.273438 3.7852 0.399306 3.73466 0.546875 3.73466C0.703125 3.73466 0.837674 3.7852 0.950521 3.88628L3.33333 6.19856L9.04948 0.651625Z" fill="currentColor"></path></symbol>',
		);

		$cart_icon = '<symbol id="shopping-bag" viewBox="0 0 15 16"><path d="M12.7518 2.91374L11.6276 1.44835H3.37237L2.24824 2.91374H12.7518ZM14.8419 3.18637V3.20341C14.8419 3.20341 14.8478 3.20341 14.8595 3.20341C14.8946 3.27157 14.9239 3.33972 14.9473 3.40788C14.9824 3.47604 15 3.54988 15 3.62939V13.819C15 14.1143 14.9356 14.3983 14.8068 14.6709C14.6897 14.9322 14.5316 15.1594 14.3326 15.3525C14.1335 15.557 13.8934 15.716 13.6124 15.8296C13.3431 15.9432 13.0562 16 12.7518 16H2.24824C1.94379 16 1.65105 15.9375 1.37002 15.8126C1.1007 15.699 0.866511 15.5456 0.667447 15.3525C0.456674 15.1594 0.29274 14.9322 0.175644 14.6709C0.058548 14.3983 0 14.1143 0 13.819V3.62939C0 3.58395 0.0058548 3.53852 0.0175644 3.49308C0.029274 3.43628 0.0468384 3.37948 0.0702576 3.32268C0.0819672 3.29996 0.0936768 3.27725 0.105386 3.25453C0.128806 3.23181 0.14637 3.20909 0.15808 3.18637L2.40632 0.28967C2.47658 0.198793 2.5644 0.130635 2.66979 0.085197C2.77518 0.028399 2.88642 0 3.00351 0H11.9965C12.1136 0 12.2248 0.028399 12.3302 0.085197C12.4356 0.130635 12.5234 0.198793 12.5937 0.28967L14.8419 3.18637ZM1.51054 4.36209V13.819C1.51054 13.9098 1.5281 14.0007 1.56323 14.0916C1.59836 14.1825 1.65105 14.262 1.72131 14.3301C1.79157 14.3983 1.87354 14.4494 1.96721 14.4835C2.06089 14.5176 2.15457 14.5346 2.24824 14.5346H12.7518C12.8571 14.5346 12.9508 14.5176 13.0328 14.4835C13.1265 14.4494 13.2084 14.3983 13.2787 14.3301C13.3489 14.262 13.4016 14.1825 13.4368 14.0916C13.4719 14.0007 13.4895 13.9098 13.4895 13.819V4.36209H1.51054ZM9.74824 6.54313C9.74824 6.33866 9.8185 6.16826 9.95902 6.03195C10.1112 5.88427 10.2927 5.81044 10.5035 5.81044C10.7026 5.81044 10.8724 5.88427 11.0129 6.03195C11.1651 6.16826 11.2412 6.33866 11.2412 6.54313C11.2412 7.04295 11.1417 7.51438 10.9426 7.9574C10.7553 8.40043 10.4918 8.78665 10.1522 9.11608C9.81265 9.44551 9.41452 9.70678 8.95785 9.89989C8.50117 10.0816 8.01522 10.1725 7.5 10.1725C6.98478 10.1725 6.49883 10.0816 6.04215 9.89989C5.58548 9.70678 5.18735 9.44551 4.84777 9.11608C4.5082 8.78665 4.23888 8.40043 4.03981 7.9574C3.85246 7.51438 3.75878 7.04295 3.75878 6.54313C3.75878 6.33866 3.82904 6.16826 3.96956 6.03195C4.12178 5.88427 4.29742 5.81044 4.49649 5.81044C4.70726 5.81044 4.8829 5.88427 5.02342 6.03195C5.17564 6.16826 5.25176 6.33866 5.25176 6.54313C5.25176 6.84984 5.3103 7.13383 5.4274 7.3951C5.5445 7.65637 5.70843 7.88356 5.9192 8.07668C6.11827 8.28115 6.35246 8.44018 6.62178 8.55378C6.8911 8.66738 7.18384 8.72417 7.5 8.72417C7.81616 8.72417 8.1089 8.66738 8.37822 8.55378C8.64754 8.44018 8.88173 8.28115 9.0808 8.07668C9.29157 7.88356 9.4555 7.65637 9.5726 7.3951C9.6897 7.13383 9.74824 6.84984 9.74824 6.54313Z" fill="currentColor"/></symbol>';

		$args[] = apply_filters('glozin_get_cart_svg_icon', $cart_icon);

		echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">' . implode( '', $args ) . '</svg>';
	}

	/**
	 * Social Icons – svg sources.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public static $social_icons = array(
		'500px'           => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.94026,15.1412c.00437.01213.108.29862.168.44064a6.55008,6.55008,0,1,0,6.03191-9.09557,6.68654,6.68654,0,0,0-2.58357.51467A8.53914,8.53914,0,0,0,8.21268,8.61344L8.209,8.61725V3.22948l9.0504-.00008c.32934-.0036.32934-.46353.32934-.61466s0-.61091-.33035-.61467L7.47248,2a.43.43,0,0,0-.43131.42692v7.58355c0,.24466.30476.42131.58793.4819.553.11812.68074-.05864.81617-.2457l.018-.02481A10.52673,10.52673,0,0,1,9.32258,9.258a5.35268,5.35268,0,1,1,7.58985,7.54976,5.417,5.417,0,0,1-3.80867,1.56365,5.17483,5.17483,0,0,1-2.69822-.74478l.00342-4.61111a2.79372,2.79372,0,0,1,.71372-1.78792,2.61611,2.61611,0,0,1,1.98282-.89477,2.75683,2.75683,0,0,1,1.95525.79477,2.66867,2.66867,0,0,1,.79656,1.909,2.724,2.724,0,0,1-2.75849,2.748,4.94651,4.94651,0,0,1-.86254-.13719c-.31234-.093-.44519.34058-.48892.48349-.16811.54966.08453.65862.13687.67489a3.75751,3.75751,0,0,0,1.25234.18375,3.94634,3.94634,0,1,0-2.82444-6.742,3.67478,3.67478,0,0,0-1.13028,2.584l-.00041.02323c-.0035.11667-.00579,2.881-.00644,3.78811l-.00407-.00451a6.18521,6.18521,0,0,1-1.0851-1.86092c-.10544-.27856-.34358-.22925-.66857-.12917-.14192.04372-.57386.17677-.47833.489Zm4.65165-1.08338a.51346.51346,0,0,0,.19513.31818l.02276.022a.52945.52945,0,0,0,.3517.18416.24242.24242,0,0,0,.16577-.0611c.05473-.05082.67382-.67812.73287-.738l.69041.68819a.28978.28978,0,0,0,.21437.11032.53239.53239,0,0,0,.35708-.19486c.29792-.30419.14885-.46821.07676-.54751l-.69954-.69975.72952-.73469c.16-.17311.01874-.35708-.12218-.498-.20461-.20461-.402-.25742-.52855-.14083l-.7254.72665-.73354-.73375a.20128.20128,0,0,0-.14179-.05695.54135.54135,0,0,0-.34379.19648c-.22561.22555-.274.38149-.15656.5059l.73374.7315-.72942.73072A.26589.26589,0,0,0,11.59191,14.05782Zm1.59866-9.915A8.86081,8.86081,0,0,0,9.854,4.776a.26169.26169,0,0,0-.16938.22759.92978.92978,0,0,0,.08619.42094c.05682.14524.20779.531.50006.41955a8.40969,8.40969,0,0,1,2.91968-.55484,7.87875,7.87875,0,0,1,3.086.62286,8.61817,8.61817,0,0,1,2.30562,1.49315.2781.2781,0,0,0,.18318.07586c.15529,0,.30425-.15253.43167-.29551.21268-.23861.35873-.4369.1492-.63538a8.50425,8.50425,0,0,0-2.62312-1.694A9.0177,9.0177,0,0,0,13.19058,4.14283ZM19.50945,18.6236h0a.93171.93171,0,0,0-.36642-.25406.26589.26589,0,0,0-.27613.06613l-.06943.06929A7.90606,7.90606,0,0,1,7.60639,18.505a7.57284,7.57284,0,0,1-1.696-2.51537,8.58715,8.58715,0,0,1-.5147-1.77754l-.00871-.04864c-.04939-.25873-.28755-.27684-.62981-.22448-.14234.02178-.5755.088-.53426.39969l.001.00712a9.08807,9.08807,0,0,0,15.406,4.99094c.00193-.00192.04753-.04718.0725-.07436C19.79425,19.16234,19.87422,18.98728,19.50945,18.6236Z"></path></svg>',
		'amazon'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M13.582,8.182C11.934,8.367,9.78,8.49,8.238,9.166c-1.781,0.769-3.03,2.337-3.03,4.644 c0,2.953,1.86,4.429,4.253,4.429c2.02,0,3.125-0.477,4.685-2.065c0.516,0.747,0.685,1.109,1.629,1.894 c0.212,0.114,0.483,0.103,0.672-0.066l0.006,0.006c0.567-0.505,1.599-1.401,2.18-1.888c0.231-0.188,0.19-0.496,0.009-0.754 c-0.52-0.718-1.072-1.303-1.072-2.634V8.305c0-1.876,0.133-3.599-1.249-4.891C15.23,2.369,13.422,2,12.04,2 C9.336,2,6.318,3.01,5.686,6.351C5.618,6.706,5.877,6.893,6.109,6.945l2.754,0.298C9.121,7.23,9.308,6.977,9.357,6.72 c0.236-1.151,1.2-1.706,2.284-1.706c0.584,0,1.249,0.215,1.595,0.738c0.398,0.584,0.346,1.384,0.346,2.061V8.182z M13.049,14.088 c-0.451,0.8-1.169,1.291-1.967,1.291c-1.09,0-1.728-0.83-1.728-2.061c0-2.42,2.171-2.86,4.227-2.86v0.615 C13.582,12.181,13.608,13.104,13.049,14.088z M20.683,19.339C18.329,21.076,14.917,22,11.979,22c-4.118,0-7.826-1.522-10.632-4.057 c-0.22-0.199-0.024-0.471,0.241-0.317c3.027,1.762,6.771,2.823,10.639,2.823c2.608,0,5.476-0.541,8.115-1.66 C20.739,18.62,21.072,19.051,20.683,19.339z M21.336,21.043c-0.194,0.163-0.379,0.076-0.293-0.139 c0.284-0.71,0.92-2.298,0.619-2.684c-0.301-0.386-1.99-0.183-2.749-0.092c-0.23,0.027-0.266-0.173-0.059-0.319 c1.348-0.946,3.555-0.673,3.811-0.356C22.925,17.773,22.599,19.986,21.336,21.043z"></path></svg>',
		'bandcamp'        => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.27 17.289 3 17.289 8.73 6.711 21 6.711 15.27 17.289"></path></svg>',
		'behance'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8H0v354.4h171.8c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9H151c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2h-79v-82.7zm83.3 233.7H77.9V272h84.9c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zm358.5-240.7H376V94h143.7v34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3H509c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3h185.1c.3-4.2.6-8.7.6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8H390.4z"/></svg>',
		'blogger' 		  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M446.6 222.7c-1.8-8-6.8-15.4-12.5-18.5-1.8-1-13-2.2-25-2.7-20.1-.9-22.3-1.3-28.7-5-10.1-5.9-12.8-12.3-12.9-29.5-.1-33-13.8-63.7-40.9-91.3-19.3-19.7-40.9-33-65.5-40.5-5.9-1.8-19.1-2.4-63.3-2.9-69.4-.8-84.8.6-108.4 10C45.9 59.5 14.7 96.1 3.3 142.9 1.2 151.7.7 165.8.2 246.8c-.6 101.5.1 116.4 6.4 136.5 15.6 49.6 59.9 86.3 104.4 94.3 14.8 2.7 197.3 3.3 216 .8 32.5-4.4 58-17.5 81.9-41.9 17.3-17.7 28.1-36.8 35.2-62.1 4.9-17.6 4.5-142.8 2.5-151.7zm-322.1-63.6c7.8-7.9 10-8.2 58.8-8.2 43.9 0 45.4.1 51.8 3.4 9.3 4.7 13.4 11.3 13.4 21.9 0 9.5-3.8 16.2-12.3 21.6-4.6 2.9-7.3 3.1-50.3 3.3-26.5.2-47.7-.4-50.8-1.2-16.6-4.7-22.8-28.5-10.6-40.8zm191.8 199.8l-14.9 2.4-77.5.9c-68.1.8-87.3-.4-90.9-2-7.1-3.1-13.8-11.7-14.9-19.4-1.1-7.3 2.6-17.3 8.2-22.4 7.1-6.4 10.2-6.6 97.3-6.7 89.6-.1 89.1-.1 97.6 7.8 12.1 11.3 9.5 31.2-4.9 39.4z"/></svg>',
		'codepen'         => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22.016,8.84c-0.002-0.013-0.005-0.025-0.007-0.037c-0.005-0.025-0.008-0.048-0.015-0.072 c-0.003-0.015-0.01-0.028-0.013-0.042c-0.008-0.02-0.015-0.04-0.023-0.062c-0.007-0.015-0.013-0.028-0.02-0.042 c-0.008-0.02-0.018-0.037-0.03-0.057c-0.007-0.013-0.017-0.027-0.025-0.038c-0.012-0.018-0.023-0.035-0.035-0.052 c-0.01-0.013-0.02-0.025-0.03-0.037c-0.015-0.017-0.028-0.032-0.043-0.045c-0.01-0.012-0.022-0.023-0.035-0.035 c-0.015-0.015-0.032-0.028-0.048-0.04c-0.012-0.01-0.025-0.02-0.037-0.03c-0.005-0.003-0.01-0.008-0.015-0.012l-9.161-6.096 c-0.289-0.192-0.666-0.192-0.955,0L2.359,8.237C2.354,8.24,2.349,8.245,2.344,8.249L2.306,8.277 c-0.017,0.013-0.033,0.027-0.048,0.04C2.246,8.331,2.234,8.342,2.222,8.352c-0.015,0.015-0.028,0.03-0.042,0.047 c-0.012,0.013-0.022,0.023-0.03,0.037C2.139,8.453,2.125,8.471,2.115,8.488C2.107,8.501,2.099,8.514,2.09,8.526 C2.079,8.548,2.069,8.565,2.06,8.585C2.054,8.6,2.047,8.613,2.04,8.626C2.032,8.648,2.025,8.67,2.019,8.69 c-0.005,0.013-0.01,0.027-0.013,0.042C1.999,8.755,1.995,8.778,1.99,8.803C1.989,8.817,1.985,8.828,1.984,8.84 C1.978,8.879,1.975,8.915,1.975,8.954v6.093c0,0.037,0.003,0.075,0.008,0.112c0.002,0.012,0.005,0.025,0.007,0.038 c0.005,0.023,0.008,0.047,0.015,0.072c0.003,0.015,0.008,0.028,0.013,0.04c0.007,0.022,0.013,0.042,0.022,0.063 c0.007,0.015,0.013,0.028,0.02,0.04c0.008,0.02,0.018,0.038,0.03,0.058c0.007,0.013,0.015,0.027,0.025,0.038 c0.012,0.018,0.023,0.035,0.035,0.052c0.01,0.013,0.02,0.025,0.03,0.037c0.013,0.015,0.028,0.032,0.042,0.045 c0.012,0.012,0.023,0.023,0.035,0.035c0.015,0.013,0.032,0.028,0.048,0.04l0.038,0.03c0.005,0.003,0.01,0.007,0.013,0.01 l9.163,6.095C11.668,21.953,11.833,22,12,22c0.167,0,0.332-0.047,0.478-0.144l9.163-6.095l0.015-0.01 c0.013-0.01,0.027-0.02,0.037-0.03c0.018-0.013,0.035-0.028,0.048-0.04c0.013-0.012,0.025-0.023,0.035-0.035 c0.017-0.015,0.03-0.032,0.043-0.045c0.01-0.013,0.02-0.025,0.03-0.037c0.013-0.018,0.025-0.035,0.035-0.052 c0.008-0.013,0.018-0.027,0.025-0.038c0.012-0.02,0.022-0.038,0.03-0.058c0.007-0.013,0.013-0.027,0.02-0.04 c0.008-0.022,0.015-0.042,0.023-0.063c0.003-0.013,0.01-0.027,0.013-0.04c0.007-0.025,0.01-0.048,0.015-0.072 c0.002-0.013,0.005-0.027,0.007-0.037c0.003-0.042,0.007-0.079,0.007-0.117V8.954C22.025,8.915,22.022,8.879,22.016,8.84z M12.862,4.464l6.751,4.49l-3.016,2.013l-3.735-2.492V4.464z M11.138,4.464v4.009l-3.735,2.494L4.389,8.954L11.138,4.464z M3.699,10.562L5.853,12l-2.155,1.438V10.562z M11.138,19.536l-6.749-4.491l3.015-2.011l3.735,2.492V19.536z M12,14.035L8.953,12 L12,9.966L15.047,12L12,14.035z M12.862,19.536v-4.009l3.735-2.492l3.016,2.011L12.862,19.536z M20.303,13.438L18.147,12 l2.156-1.438L20.303,13.438z"></path></svg>',
		'deviantart'      => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M 18.19 5.636 18.19 2 18.188 2 14.553 2 14.19 2.366 12.474 5.636 11.935 6 5.81 6 5.81 10.994 9.177 10.994 9.477 11.357 5.81 18.363 5.81 22 5.811 22 9.447 22 9.81 21.634 11.526 18.364 12.065 18 18.19 18 18.19 13.006 14.823 13.006 14.523 12.641 18.19 5.636z"></path></svg>',
		'discord'      	  => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-discord" viewBox="0 0 16 16"><path d="M13.545 2.907a13.2 13.2 0 0 0-3.257-1.011.05.05 0 0 0-.052.025c-.141.25-.297.577-.406.833a12.2 12.2 0 0 0-3.658 0 8 8 0 0 0-.412-.833.05.05 0 0 0-.052-.025c-1.125.194-2.22.534-3.257 1.011a.04.04 0 0 0-.021.018C.356 6.024-.213 9.047.066 12.032q.003.022.021.037a13.3 13.3 0 0 0 3.995 2.02.05.05 0 0 0 .056-.019q.463-.63.818-1.329a.05.05 0 0 0-.01-.059l-.018-.011a9 9 0 0 1-1.248-.595.05.05 0 0 1-.02-.066l.015-.019q.127-.095.248-.195a.05.05 0 0 1 .051-.007c2.619 1.196 5.454 1.196 8.041 0a.05.05 0 0 1 .053.007q.121.1.248.195a.05.05 0 0 1-.004.085 8 8 0 0 1-1.249.594.05.05 0 0 0-.03.03.05.05 0 0 0 .003.041c.24.465.515.909.817 1.329a.05.05 0 0 0 .056.019 13.2 13.2 0 0 0 4.001-2.02.05.05 0 0 0 .021-.037c.334-3.451-.559-6.449-2.366-9.106a.03.03 0 0 0-.02-.019m-8.198 7.307c-.789 0-1.438-.724-1.438-1.612s.637-1.613 1.438-1.613c.807 0 1.45.73 1.438 1.613 0 .888-.637 1.612-1.438 1.612m5.316 0c-.788 0-1.438-.724-1.438-1.612s.637-1.613 1.438-1.613c.807 0 1.451.73 1.438 1.613 0 .888-.631 1.612-1.438 1.612"/></svg>',
		'dribbble'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.252 8 8 119.252 8 256s111.252 248 248 248 248-111.252 248-248S392.748 8 256 8zm163.97 114.366c29.503 36.046 47.369 81.957 47.835 131.955-6.984-1.477-77.018-15.682-147.502-6.818-5.752-14.041-11.181-26.393-18.617-41.614 78.321-31.977 113.818-77.482 118.284-83.523zM396.421 97.87c-3.81 5.427-35.697 48.286-111.021 76.519-34.712-63.776-73.185-116.168-79.04-124.008 67.176-16.193 137.966 1.27 190.061 47.489zm-230.48-33.25c5.585 7.659 43.438 60.116 78.537 122.509-99.087 26.313-186.36 25.934-195.834 25.809C62.38 147.205 106.678 92.573 165.941 64.62zM44.17 256.323c0-2.166.043-4.322.108-6.473 9.268.19 111.92 1.513 217.706-30.146 6.064 11.868 11.857 23.915 17.174 35.949-76.599 21.575-146.194 83.527-180.531 142.306C64.794 360.405 44.17 310.73 44.17 256.323zm81.807 167.113c22.127-45.233 82.178-103.622 167.579-132.756 29.74 77.283 42.039 142.053 45.189 160.638-68.112 29.013-150.015 21.053-212.768-27.882zm248.38 8.489c-2.171-12.886-13.446-74.897-41.152-151.033 66.38-10.626 124.7 6.768 131.947 9.055-9.442 58.941-43.273 109.844-90.795 141.978z"/></svg>',
		'dropbox'         => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12,6.134L6.069,9.797L2,6.54l5.883-3.843L12,6.134z M2,13.054l5.883,3.843L12,13.459L6.069,9.797L2,13.054z M12,13.459 l4.116,3.439L22,13.054l-4.069-3.257L12,13.459z M22,6.54l-5.884-3.843L12,6.134l5.931,3.663L22,6.54z M12.011,14.2l-4.129,3.426 l-1.767-1.153v1.291l5.896,3.539l5.897-3.539v-1.291l-1.769,1.153L12.011,14.2z"></path></svg>',
		'digg'         	  => '<svg viewBox="0 0 32 32"><path d="M5.125 10.75h-5.125v10.938h8.313v-15.688h-3.188v4.75zM5.125 19.125h-1.938v-5.813h1.938v5.813zM23.688 10.75v10.938h5.125v1.75h-5.125v2.563h8.313v-15.25h-8.313zM28.813 19.125h-1.938v-5.813h1.938v5.813zM14.063 21.688h5.125v1.75h-5.125v2.563h8.313v-15.25h-8.313v10.938zM17.25 13.313h1.938v5.813h-1.938v-5.813zM9.563 6h3.25v3.188h-3.25v-3.188zM9.563 10.75h3.25v10.938h-3.25v-10.938z"></path></svg>',
		'etsy'            => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M9.16033,4.038c0-.27174.02717-.43478.48913-.43478h6.22283c1.087,0,1.68478.92391,2.11957,2.663l.35326,1.38587h1.05978C19.59511,3.712,19.75815,2,19.75815,2s-2.663.29891-4.23913.29891h-7.962L3.29076,2.163v1.1413L4.731,3.57609c1.00543.19022,1.25.40761,1.33152,1.33152,0,0,.08152,2.71739.08152,7.20109s-.08152,7.17391-.08152,7.17391c0,.81522-.32609,1.11413-1.33152,1.30435l-1.44022.27174V22l4.2663-.13587h7.11957c1.60326,0,5.32609.13587,5.32609.13587.08152-.97826.625-5.40761.70652-5.89674H19.7038L18.644,18.52174c-.84239,1.90217-2.06522,2.038-3.42391,2.038H11.1712c-1.3587,0-2.01087-.54348-2.01087-1.712V12.65217s3.0163,0,3.99457.08152c.76087.05435,1.22283.27174,1.46739,1.33152l.32609,1.413h1.16848l-.08152-3.55978.163-3.587H15.02989l-.38043,1.57609c-.24457,1.03261-.40761,1.22283-1.46739,1.33152-1.38587.13587-4.02174.1087-4.02174.1087Z"></path></svg>',
		'facebook-f'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path></svg>',
		'facebook'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path></svg>',
		'facebook-square' => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M21 2.672v18.656q0 0.469 -0.329 0.821t-0.844 0.352h-5.344v-8.156h2.719l0.422 -3.141h-3.141v-2.016q0 -0.797 0.281 -1.125 0.375 -0.422 1.266 -0.422h1.688v-2.86q-0.985 -0.094 -2.438 -0.094 -1.829 0 -2.954 1.079t-1.125 3.094v2.344h-2.719v3.141h2.719v8.156h-10.031q-0.516 0 -0.844 -0.352t-0.329 -0.821v-18.656q0 -0.516 0.329 -0.844t0.844 -0.329h18.656q0.469 0 0.821 0.329t0.352 0.844z"/></svg>',
		'feed'            => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M2,8.667V12c5.515,0,10,4.485,10,10h3.333C15.333,14.637,9.363,8.667,2,8.667z M2,2v3.333 c9.19,0,16.667,7.477,16.667,16.667H22C22,10.955,13.045,2,2,2z M4.5,17C3.118,17,2,18.12,2,19.5S3.118,22,4.5,22S7,20.88,7,19.5 S5.882,17,4.5,17z"></path></svg>',
		'flickr'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.5,7c-2.75,0-5,2.25-5,5s2.25,5,5,5s5-2.25,5-5S9.25,7,6.5,7z M17.5,7c-2.75,0-5,2.25-5,5s2.25,5,5,5s5-2.25,5-5 S20.25,7,17.5,7z"></path></svg>',
		'foursquare'      => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.573,2c0,0-9.197,0-10.668,0S5,3.107,5,3.805s0,16.948,0,16.948c0,0.785,0.422,1.077,0.66,1.172 c0.238,0.097,0.892,0.177,1.285-0.275c0,0,5.035-5.843,5.122-5.93c0.132-0.132,0.132-0.132,0.262-0.132h3.26 c1.368,0,1.588-0.977,1.732-1.552c0.078-0.318,0.692-3.428,1.225-6.122l0.675-3.368C19.56,2.893,19.14,2,17.573,2z M16.495,7.22 c-0.053,0.252-0.372,0.518-0.665,0.518c-0.293,0-4.157,0-4.157,0c-0.467,0-0.802,0.318-0.802,0.787v0.508 c0,0.467,0.337,0.798,0.805,0.798c0,0,3.197,0,3.528,0s0.655,0.362,0.583,0.715c-0.072,0.353-0.407,2.102-0.448,2.295 c-0.04,0.193-0.262,0.523-0.655,0.523c-0.33,0-2.88,0-2.88,0c-0.523,0-0.683,0.068-1.033,0.503 c-0.35,0.437-3.505,4.223-3.505,4.223c-0.032,0.035-0.063,0.027-0.063-0.015V4.852c0-0.298,0.26-0.648,0.648-0.648 c0,0,8.228,0,8.562,0c0.315,0,0.61,0.297,0.528,0.683L16.495,7.22z"></path></svg>',
		'goodreads'       => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.3,17.5c-0.2,0.8-0.5,1.4-1,1.9c-0.4,0.5-1,0.9-1.7,1.2C13.9,20.9,13.1,21,12,21c-0.6,0-1.3-0.1-1.9-0.2 c-0.6-0.1-1.1-0.4-1.6-0.7c-0.5-0.3-0.9-0.7-1.2-1.2c-0.3-0.5-0.5-1.1-0.5-1.7h1.5c0.1,0.5,0.2,0.9,0.5,1.2 c0.2,0.3,0.5,0.6,0.9,0.8c0.3,0.2,0.7,0.3,1.1,0.4c0.4,0.1,0.8,0.1,1.2,0.1c1.4,0,2.5-0.4,3.1-1.2c0.6-0.8,1-2,1-3.5v-1.7h0 c-0.4,0.8-0.9,1.4-1.6,1.9c-0.7,0.5-1.5,0.7-2.4,0.7c-1,0-1.9-0.2-2.6-0.5C8.7,15,8.1,14.5,7.7,14c-0.5-0.6-0.8-1.3-1-2.1 c-0.2-0.8-0.3-1.6-0.3-2.5c0-0.9,0.1-1.7,0.4-2.5c0.3-0.8,0.6-1.5,1.1-2c0.5-0.6,1.1-1,1.8-1.4C10.3,3.2,11.1,3,12,3 c0.5,0,0.9,0.1,1.3,0.2c0.4,0.1,0.8,0.3,1.1,0.5c0.3,0.2,0.6,0.5,0.9,0.8c0.3,0.3,0.5,0.6,0.6,1h0V3.4h1.5V15 C17.6,15.9,17.5,16.7,17.3,17.5z M13.8,14.1c0.5-0.3,0.9-0.7,1.3-1.1c0.3-0.5,0.6-1,0.8-1.6c0.2-0.6,0.3-1.2,0.3-1.9 c0-0.6-0.1-1.2-0.2-1.9c-0.1-0.6-0.4-1.2-0.7-1.7c-0.3-0.5-0.7-0.9-1.3-1.2c-0.5-0.3-1.1-0.5-1.9-0.5s-1.4,0.2-1.9,0.5 c-0.5,0.3-1,0.7-1.3,1.2C8.5,6.4,8.3,7,8.1,7.6C8,8.2,7.9,8.9,7.9,9.5c0,0.6,0.1,1.3,0.2,1.9C8.3,12,8.6,12.5,8.9,13 c0.3,0.5,0.8,0.8,1.3,1.1c0.5,0.3,1.1,0.4,1.9,0.4C12.7,14.5,13.3,14.4,13.8,14.1z"></path></svg>',
		'google'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.02,10.18v3.72v0.01h5.51c-0.26,1.57-1.67,4.22-5.5,4.22c-3.31,0-6.01-2.75-6.01-6.12s2.7-6.12,6.01-6.12 c1.87,0,3.13,0.8,3.85,1.48l2.84-2.76C16.99,2.99,14.73,2,12.03,2c-5.52,0-10,4.48-10,10s4.48,10,10,10c5.77,0,9.6-4.06,9.6-9.77 c0-0.83-0.11-1.42-0.25-2.05H12.02z"></path></svg>',
		'google-plus' 	  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M386.061 228.496c1.834 9.692 3.143 19.384 3.143 31.956C389.204 370.205 315.599 448 204.8 448c-106.084 0-192-85.915-192-192s85.916-192 192-192c51.864 0 95.083 18.859 128.611 50.292l-52.126 50.03c-14.145-13.621-39.028-29.599-76.485-29.599-65.484 0-118.92 54.221-118.92 121.277 0 67.056 53.436 121.277 118.92 121.277 75.961 0 104.513-54.745 108.965-82.773H204.8v-66.009h181.261zm185.406 6.437V179.2h-56.001v55.733h-55.733v56.001h55.733v55.733h56.001v-55.733H627.2v-56.001h-55.733z"/></svg>',
		'github'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"/></svg>',
		'instagram'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>',
		'lastfm'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M10.5002,0 C4.7006,0 0,4.70109753 0,10.4998496 C0,16.2989526 4.7006,21 10.5002,21 C16.299,21 21,16.2989526 21,10.4998496 C21,4.70109753 16.299,0 10.5002,0 Z M14.69735,14.7204413 C13.3164,14.7151781 12.4346,14.0870017 11.83445,12.6859357 L11.6816001,12.3451305 L10.35405,9.31011397 C9.92709997,8.26875064 8.85260001,7.57120012 7.68010001,7.57120012 C6.06945001,7.57120012 4.75925001,8.88509738 4.75925001,10.5009524 C4.75925001,12.1164565 6.06945001,13.4303036 7.68010001,13.4303036 C8.77200001,13.4303036 9.76514999,12.827541 10.2719501,11.8567047 C10.2893,11.8235214 10.3239,11.8019673 10.36305,11.8038219 C10.4007,11.8053759 10.43535,11.8287847 10.4504,11.8631709 L10.98655,13.1045863 C11.0016,13.1389726 10.9956,13.17782 10.97225,13.2068931 C10.1605001,14.1995341 8.96020001,14.7683115 7.68010001,14.7683115 C5.33305,14.7683115 3.42340001,12.8535563 3.42340001,10.5009524 C3.42340001,8.14679459 5.33300001,6.23203946 7.68010001,6.23203946 C9.45720002,6.23203946 10.8909,7.19074535 11.6138,8.86359341 C11.6205501,8.88018505 12.3412,10.5707777 12.97445,12.0190621 C13.34865,12.8739575 13.64615,13.3959676 14.6288,13.4291508 C15.5663001,13.4612814 16.25375,12.9121534 16.25375,12.1484869 C16.25375,11.4691321 15.8320501,11.3003585 14.8803,10.98216 C13.2365,10.4397989 12.34495,9.88605929 12.34495,8.51817658 C12.34495,7.1809207 13.26665,6.31615054 14.692,6.31615054 C15.62875,6.31615054 16.3155,6.7286858 16.79215,7.5768142 C16.80495,7.60062396 16.8079001,7.62814302 16.8004001,7.65420843 C16.7929,7.68027384 16.7748,7.70212868 16.7507001,7.713808 L15.86145,8.16900031 C15.8178001,8.19200805 15.7643,8.17807308 15.73565,8.13847371 C15.43295,7.71345711 15.0956,7.52513451 14.6423,7.52513451 C14.05125,7.52513451 13.6220001,7.92899802 13.6220001,8.48649708 C13.6220001,9.17382194 14.1529001,9.34144259 15.0339,9.61923972 C15.14915,9.65578139 15.26955,9.69397731 15.39385,9.73432853 C16.7763,10.1865133 17.57675,10.7311301 17.57675,12.1836251 C17.57685,13.629654 16.3389,14.7204413 14.69735,14.7204413 Z"></path></svg>',
		'linkedin'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"/></svg>',
		'email'           => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20,4H4C2.895,4,2,4.895,2,6v12c0,1.105,0.895,2,2,2h16c1.105,0,2-0.895,2-2V6C22,4.895,21.105,4,20,4z M20,8.236l-8,4.882 L4,8.236V6h16V8.236z"></path></svg>',
		'mastodon'        => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M23.193 7.879c0-5.206-3.411-6.732-3.411-6.732C18.062.357 15.108.025 12.041 0h-.076c-3.068.025-6.02.357-7.74 1.147 0 0-3.411 1.526-3.411 6.732 0 1.192-.023 2.618.015 4.129.124 5.092.934 10.109 5.641 11.355 2.17.574 4.034.695 5.535.612 2.722-.15 4.25-.972 4.25-.972l-.09-1.975s-1.945.613-4.129.539c-2.165-.074-4.449-.233-4.799-2.891a5.499 5.499 0 0 1-.048-.745s2.125.52 4.817.643c1.646.075 3.19-.097 4.758-.283 3.007-.359 5.625-2.212 5.954-3.905.517-2.665.475-6.507.475-6.507zm-4.024 6.709h-2.497V8.469c0-1.29-.543-1.944-1.628-1.944-1.2 0-1.802.776-1.802 2.312v3.349h-2.483v-3.35c0-1.536-.602-2.312-1.802-2.312-1.085 0-1.628.655-1.628 1.944v6.119H4.832V8.284c0-1.289.328-2.313.987-3.07.68-.758 1.569-1.146 2.674-1.146 1.278 0 2.246.491 2.886 1.474L12 6.585l.622-1.043c.64-.983 1.608-1.474 2.886-1.474 1.104 0 1.994.388 2.674 1.146.658.757.986 1.781.986 3.07v6.304z"/></svg>',
		'medium'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20.962,7.257l-5.457,8.867l-3.923-6.375l3.126-5.08c0.112-0.182,0.319-0.286,0.527-0.286c0.05,0,0.1,0.008,0.149,0.02 c0.039,0.01,0.078,0.023,0.114,0.041l5.43,2.715l0.006,0.003c0.004,0.002,0.007,0.006,0.011,0.008 C20.971,7.191,20.98,7.227,20.962,7.257z M9.86,8.592v5.783l5.14,2.57L9.86,8.592z M15.772,17.331l4.231,2.115 C20.554,19.721,21,19.529,21,19.016V8.835L15.772,17.331z M8.968,7.178L3.665,4.527C3.569,4.479,3.478,4.456,3.395,4.456 C3.163,4.456,3,4.636,3,4.938v11.45c0,0.306,0.224,0.669,0.498,0.806l4.671,2.335c0.12,0.06,0.234,0.088,0.337,0.088 c0.29,0,0.494-0.225,0.494-0.602V7.231C9,7.208,8.988,7.188,8.968,7.178z"></path></svg>',
		'meetup'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M19.24775,14.722a3.57032,3.57032,0,0,1-2.94457,3.52073,3.61886,3.61886,0,0,1-.64652.05634c-.07314-.0008-.10187.02846-.12507.09547A2.38881,2.38881,0,0,1,13.49453,20.094a2.33092,2.33092,0,0,1-1.827-.50716.13635.13635,0,0,0-.19878-.00408,3.191,3.191,0,0,1-2.104.60248,3.26309,3.26309,0,0,1-3.00324-2.71993,2.19076,2.19076,0,0,1-.03512-.30865c-.00156-.08579-.03413-.1189-.11608-.13493a2.86421,2.86421,0,0,1-1.23189-.56111,2.945,2.945,0,0,1-1.166-2.05749,2.97484,2.97484,0,0,1,.87524-2.50774.112.112,0,0,0,.02091-.16107,2.7213,2.7213,0,0,1-.36648-1.48A2.81256,2.81256,0,0,1,6.57673,7.58838a.35764.35764,0,0,0,.28869-.22819,4.2208,4.2208,0,0,1,6.02892-1.90111.25161.25161,0,0,0,.22023.0243,3.65608,3.65608,0,0,1,3.76031.90678A3.57244,3.57244,0,0,1,17.95918,8.626a2.97339,2.97339,0,0,1,.01829.57356.10637.10637,0,0,0,.0853.12792,1.97669,1.97669,0,0,1,1.27939,1.33733,2.00266,2.00266,0,0,1-.57112,2.12652c-.05284.05166-.04168.08328-.01173.13489A3.51189,3.51189,0,0,1,19.24775,14.722Zm-6.35959-.27836a1.6984,1.6984,0,0,0,1.14556,1.61113,3.82039,3.82039,0,0,0,1.036.17935,1.46888,1.46888,0,0,0,.73509-.12255.44082.44082,0,0,0,.26057-.44274.45312.45312,0,0,0-.29211-.43375.97191.97191,0,0,0-.20678-.063c-.21326-.03806-.42754-.0701-.63973-.11215a.54787.54787,0,0,1-.50172-.60926,2.75864,2.75864,0,0,1,.1773-.901c.1763-.535.414-1.045.64183-1.55913A12.686,12.686,0,0,0,15.85,10.47863a1.58461,1.58461,0,0,0,.04861-.87208,1.04531,1.04531,0,0,0-.85432-.83981,1.60658,1.60658,0,0,0-1.23654.16594.27593.27593,0,0,1-.36286-.03413c-.085-.0747-.16594-.15379-.24918-.23055a.98682.98682,0,0,0-1.33577-.04933,6.1468,6.1468,0,0,1-.4989.41615.47762.47762,0,0,1-.51535.03566c-.17448-.09307-.35512-.175-.53531-.25665a1.74949,1.74949,0,0,0-.56476-.2016,1.69943,1.69943,0,0,0-1.61654.91787,8.05815,8.05815,0,0,0-.32952.80126c-.45471,1.2557-.82507,2.53825-1.20838,3.81639a1.24151,1.24151,0,0,0,.51532,1.44389,1.42659,1.42659,0,0,0,1.22008.17166,1.09728,1.09728,0,0,0,.66994-.69764c.44145-1.04111.839-2.09989,1.25981-3.14926.11581-.28876.22792-.57874.35078-.86438a.44548.44548,0,0,1,.69189-.19539.50521.50521,0,0,1,.15044.43836,1.75625,1.75625,0,0,1-.14731.50453c-.27379.69219-.55265,1.38236-.82766,2.074a2.0836,2.0836,0,0,0-.14038.42876.50719.50719,0,0,0,.27082.57722.87236.87236,0,0,0,.66145.02739.99137.99137,0,0,0,.53406-.532q.61571-1.20914,1.228-2.42031.28423-.55863.57585-1.1133a.87189.87189,0,0,1,.29055-.35253.34987.34987,0,0,1,.37634-.01265.30291.30291,0,0,1,.12434.31459.56716.56716,0,0,1-.04655.1915c-.05318.12739-.10286.25669-.16183.38156-.34118.71775-.68754,1.43273-1.02568,2.152A2.00213,2.00213,0,0,0,12.88816,14.44366Zm4.78568,5.28972a.88573.88573,0,0,0-1.77139.00465.8857.8857,0,0,0,1.77139-.00465Zm-14.83838-7.296a.84329.84329,0,1,0,.00827-1.68655.8433.8433,0,0,0-.00827,1.68655Zm10.366-9.43673a.83506.83506,0,1,0-.0091,1.67.83505.83505,0,0,0,.0091-1.67Zm6.85014,5.22a.71651.71651,0,0,0-1.433.0093.71656.71656,0,0,0,1.433-.0093ZM5.37528,6.17908A.63823.63823,0,1,0,6.015,5.54483.62292.62292,0,0,0,5.37528,6.17908Zm6.68214,14.80843a.54949.54949,0,1,0-.55052.541A.54556.54556,0,0,0,12.05742,20.98752Zm8.53235-8.49689a.54777.54777,0,0,0-.54027.54023.53327.53327,0,0,0,.532.52293.51548.51548,0,0,0,.53272-.5237A.53187.53187,0,0,0,20.58977,12.49063ZM7.82846,2.4715a.44927.44927,0,1,0,.44484.44766A.43821.43821,0,0,0,7.82846,2.4715Zm13.775,7.60492a.41186.41186,0,0,0-.40065.39623.40178.40178,0,0,0,.40168.40168A.38994.38994,0,0,0,22,10.48172.39946.39946,0,0,0,21.60349,10.07642ZM5.79193,17.96207a.40469.40469,0,0,0-.397-.39646.399.399,0,0,0-.396.405.39234.39234,0,0,0,.39939.389A.39857.39857,0,0,0,5.79193,17.96207Z"></path></svg>',
		'pinterest'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M204 6.5C101.4 6.5 0 74.9 0 185.6 0 256 39.6 296 63.6 296c9.9 0 15.6-27.6 15.6-35.4 0-9.3-23.7-29.1-23.7-67.8 0-80.4 61.2-137.4 140.4-137.4 68.1 0 118.5 38.7 118.5 109.8 0 53.1-21.3 152.7-90.3 152.7-24.9 0-46.2-18-46.2-43.8 0-37.8 26.4-74.4 26.4-113.4 0-66.2-93.9-54.2-93.9 25.8 0 16.8 2.1 35.4 9.6 50.7-13.8 59.4-42 147.9-42 209.1 0 18.9 2.7 37.5 4.5 56.4 3.4 3.8 1.7 3.4 6.9 1.5 50.4-69 48.6-82.5 71.4-172.8 12.3 23.4 44.1 36 69.3 36 106.2 0 153.9-103.5 153.9-196.8C384 71.3 298.2 6.5 204 6.5z"/></svg>',
		'pocket'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M21.927,4.194C21.667,3.48,20.982,3,20.222,3h-0.01h-1.721H3.839C3.092,3,2.411,3.47,2.145,4.17 C2.066,4.378,2.026,4.594,2.026,4.814v6.035l0.069,1.2c0.29,2.73,1.707,5.115,3.899,6.778c0.039,0.03,0.079,0.059,0.119,0.089 l0.025,0.018c1.175,0.859,2.491,1.441,3.91,1.727c0.655,0.132,1.325,0.2,1.991,0.2c0.615,0,1.232-0.057,1.839-0.17 c0.073-0.014,0.145-0.028,0.219-0.044c0.02-0.004,0.042-0.012,0.064-0.023c1.359-0.297,2.621-0.864,3.753-1.691l0.025-0.018 c0.04-0.029,0.08-0.058,0.119-0.089c2.192-1.664,3.609-4.049,3.898-6.778l0.069-1.2V4.814C22.026,4.605,22,4.398,21.927,4.194z M17.692,10.481l-4.704,4.512c-0.266,0.254-0.608,0.382-0.949,0.382c-0.342,0-0.684-0.128-0.949-0.382l-4.705-4.512 C5.838,9.957,5.82,9.089,6.344,8.542c0.524-0.547,1.392-0.565,1.939-0.04l3.756,3.601l3.755-3.601 c0.547-0.524,1.415-0.506,1.939,0.04C18.256,9.089,18.238,9.956,17.692,10.481z"></path></svg>',
		'reddit'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22,11.816c0-1.256-1.021-2.277-2.277-2.277c-0.593,0-1.122,0.24-1.526,0.614c-1.481-0.965-3.455-1.594-5.647-1.69 l1.171-3.702l3.18,0.748c0.008,1.028,0.846,1.862,1.876,1.862c1.035,0,1.877-0.842,1.877-1.878c0-1.035-0.842-1.877-1.877-1.877 c-0.769,0-1.431,0.466-1.72,1.13l-3.508-0.826c-0.203-0.047-0.399,0.067-0.46,0.261l-1.35,4.268 c-2.316,0.038-4.411,0.67-5.97,1.671C5.368,9.765,4.853,9.539,4.277,9.539C3.021,9.539,2,10.56,2,11.816 c0,0.814,0.433,1.523,1.078,1.925c-0.037,0.221-0.061,0.444-0.061,0.672c0,3.292,4.011,5.97,8.941,5.97s8.941-2.678,8.941-5.97 c0-0.214-0.02-0.424-0.053-0.632C21.533,13.39,22,12.661,22,11.816z M18.776,4.394c0.606,0,1.1,0.493,1.1,1.1s-0.493,1.1-1.1,1.1 s-1.1-0.494-1.1-1.1S18.169,4.394,18.776,4.394z M2.777,11.816c0-0.827,0.672-1.5,1.499-1.5c0.313,0,0.598,0.103,0.838,0.269 c-0.851,0.676-1.477,1.479-1.812,2.36C2.983,12.672,2.777,12.27,2.777,11.816z M11.959,19.606c-4.501,0-8.164-2.329-8.164-5.193 S7.457,9.22,11.959,9.22s8.164,2.329,8.164,5.193S16.46,19.606,11.959,19.606z M20.636,13.001c-0.326-0.89-0.948-1.701-1.797-2.384 c0.248-0.186,0.55-0.301,0.883-0.301c0.827,0,1.5,0.673,1.5,1.5C21.223,12.299,20.992,12.727,20.636,13.001z M8.996,14.704 c-0.76,0-1.397-0.616-1.397-1.376c0-0.76,0.637-1.397,1.397-1.397c0.76,0,1.376,0.637,1.376,1.397 C10.372,14.088,9.756,14.704,8.996,14.704z M16.401,13.328c0,0.76-0.616,1.376-1.376,1.376c-0.76,0-1.399-0.616-1.399-1.376 c0-0.76,0.639-1.397,1.399-1.397C15.785,11.931,16.401,12.568,16.401,13.328z M15.229,16.708c0.152,0.152,0.152,0.398,0,0.55 c-0.674,0.674-1.727,1.002-3.219,1.002c-0.004,0-0.007-0.002-0.011-0.002c-0.004,0-0.007,0.002-0.011,0.002 c-1.492,0-2.544-0.328-3.218-1.002c-0.152-0.152-0.152-0.398,0-0.55c0.152-0.152,0.399-0.151,0.55,0 c0.521,0.521,1.394,0.775,2.669,0.775c0.004,0,0.007,0.002,0.011,0.002c0.004,0,0.007-0.002,0.011-0.002 c1.275,0,2.148-0.253,2.669-0.775C14.831,16.556,15.078,16.556,15.229,16.708z"></path></svg>',
		'skype'           => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M10.113,2.699c0.033-0.006,0.067-0.013,0.1-0.02c0.033,0.017,0.066,0.033,0.098,0.051L10.113,2.699z M2.72,10.223 c-0.006,0.034-0.011,0.069-0.017,0.103c0.018,0.032,0.033,0.064,0.051,0.095L2.72,10.223z M21.275,13.771 c0.007-0.035,0.011-0.071,0.018-0.106c-0.018-0.031-0.033-0.064-0.052-0.095L21.275,13.771z M13.563,21.199 c0.032,0.019,0.065,0.035,0.096,0.053c0.036-0.006,0.071-0.011,0.105-0.017L13.563,21.199z M22,16.386 c0,1.494-0.581,2.898-1.637,3.953c-1.056,1.057-2.459,1.637-3.953,1.637c-0.967,0-1.914-0.251-2.75-0.725 c0.036-0.006,0.071-0.011,0.105-0.017l-0.202-0.035c0.032,0.019,0.065,0.035,0.096,0.053c-0.543,0.096-1.099,0.147-1.654,0.147 c-1.275,0-2.512-0.25-3.676-0.743c-1.125-0.474-2.135-1.156-3.002-2.023c-0.867-0.867-1.548-1.877-2.023-3.002 c-0.493-1.164-0.743-2.401-0.743-3.676c0-0.546,0.049-1.093,0.142-1.628c0.018,0.032,0.033,0.064,0.051,0.095L2.72,10.223 c-0.006,0.034-0.011,0.069-0.017,0.103C2.244,9.5,2,8.566,2,7.615c0-1.493,0.582-2.898,1.637-3.953 c1.056-1.056,2.46-1.638,3.953-1.638c0.915,0,1.818,0.228,2.622,0.655c-0.033,0.007-0.067,0.013-0.1,0.02l0.199,0.031 c-0.032-0.018-0.066-0.034-0.098-0.051c0.002,0,0.003-0.001,0.004-0.001c0.586-0.112,1.187-0.169,1.788-0.169 c1.275,0,2.512,0.249,3.676,0.742c1.124,0.476,2.135,1.156,3.002,2.024c0.868,0.867,1.548,1.877,2.024,3.002 c0.493,1.164,0.743,2.401,0.743,3.676c0,0.575-0.054,1.15-0.157,1.712c-0.018-0.031-0.033-0.064-0.052-0.095l0.034,0.201 c0.007-0.035,0.011-0.071,0.018-0.106C21.754,14.494,22,15.432,22,16.386z M16.817,14.138c0-1.331-0.613-2.743-3.033-3.282 l-2.209-0.49c-0.84-0.192-1.807-0.444-1.807-1.237c0-0.794,0.679-1.348,1.903-1.348c2.468,0,2.243,1.696,3.468,1.696 c0.645,0,1.209-0.379,1.209-1.031c0-1.521-2.435-2.663-4.5-2.663c-2.242,0-4.63,0.952-4.63,3.488c0,1.221,0.436,2.521,2.839,3.123 l2.984,0.745c0.903,0.223,1.129,0.731,1.129,1.189c0,0.762-0.758,1.507-2.129,1.507c-2.679,0-2.307-2.062-3.743-2.062 c-0.645,0-1.113,0.444-1.113,1.078c0,1.236,1.501,2.886,4.856,2.886C15.236,17.737,16.817,16.199,16.817,14.138z"></path></svg>',
		'snapchat'        => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.065,2a5.526,5.526,0,0,1,3.132.892A5.854,5.854,0,0,1,17.326,5.4a5.821,5.821,0,0,1,.351,2.33q0,.612-.117,2.487a.809.809,0,0,0,.365.091,1.93,1.93,0,0,0,.664-.176,1.93,1.93,0,0,1,.664-.176,1.3,1.3,0,0,1,.729.234.7.7,0,0,1,.351.6.839.839,0,0,1-.41.7,2.732,2.732,0,0,1-.9.41,3.192,3.192,0,0,0-.9.378.728.728,0,0,0-.41.618,1.575,1.575,0,0,0,.156.56,6.9,6.9,0,0,0,1.334,1.953,5.6,5.6,0,0,0,1.881,1.315,5.875,5.875,0,0,0,1.042.3.42.42,0,0,1,.365.456q0,.911-2.852,1.341a1.379,1.379,0,0,0-.143.507,1.8,1.8,0,0,1-.182.605.451.451,0,0,1-.429.241,5.878,5.878,0,0,1-.807-.085,5.917,5.917,0,0,0-.833-.085,4.217,4.217,0,0,0-.807.065,2.42,2.42,0,0,0-.82.293,6.682,6.682,0,0,0-.755.5q-.351.267-.755.527a3.886,3.886,0,0,1-.989.436A4.471,4.471,0,0,1,11.831,22a4.307,4.307,0,0,1-1.256-.176,3.784,3.784,0,0,1-.976-.436q-.4-.26-.749-.527a6.682,6.682,0,0,0-.755-.5,2.422,2.422,0,0,0-.807-.293,4.432,4.432,0,0,0-.82-.065,5.089,5.089,0,0,0-.853.1,5,5,0,0,1-.762.1.474.474,0,0,1-.456-.241,1.819,1.819,0,0,1-.182-.618,1.411,1.411,0,0,0-.143-.521q-2.852-.429-2.852-1.341a.42.42,0,0,1,.365-.456,5.793,5.793,0,0,0,1.042-.3,5.524,5.524,0,0,0,1.881-1.315,6.789,6.789,0,0,0,1.334-1.953A1.575,1.575,0,0,0,6,12.9a.728.728,0,0,0-.41-.618,3.323,3.323,0,0,0-.9-.384,2.912,2.912,0,0,1-.9-.41.814.814,0,0,1-.41-.684.71.71,0,0,1,.338-.593,1.208,1.208,0,0,1,.716-.241,1.976,1.976,0,0,1,.625.169,2.008,2.008,0,0,0,.69.169.919.919,0,0,0,.416-.091q-.117-1.849-.117-2.474A5.861,5.861,0,0,1,6.385,5.4,5.516,5.516,0,0,1,8.625,2.819,7.075,7.075,0,0,1,12.062,2Z"></path></svg>',
		'soundcloud'      => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M8.9,16.1L9,14L8.9,9.5c0-0.1,0-0.1-0.1-0.1c0,0-0.1-0.1-0.1-0.1c-0.1,0-0.1,0-0.1,0.1c0,0-0.1,0.1-0.1,0.1L8.3,14l0.1,2.1 c0,0.1,0,0.1,0.1,0.1c0,0,0.1,0.1,0.1,0.1C8.8,16.3,8.9,16.3,8.9,16.1z M11.4,15.9l0.1-1.8L11.4,9c0-0.1,0-0.2-0.1-0.2 c0,0-0.1,0-0.1,0s-0.1,0-0.1,0c-0.1,0-0.1,0.1-0.1,0.2l0,0.1l-0.1,5c0,0,0,0.7,0.1,2v0c0,0.1,0,0.1,0.1,0.1c0.1,0.1,0.1,0.1,0.2,0.1 c0.1,0,0.1,0,0.2-0.1c0.1,0,0.1-0.1,0.1-0.2L11.4,15.9z M2.4,12.9L2.5,14l-0.2,1.1c0,0.1,0,0.1-0.1,0.1c0,0-0.1,0-0.1-0.1L2.1,14 l0.1-1.1C2.2,12.9,2.3,12.9,2.4,12.9C2.3,12.9,2.4,12.9,2.4,12.9z M3.1,12.2L3.3,14l-0.2,1.8c0,0.1,0,0.1-0.1,0.1 c-0.1,0-0.1,0-0.1-0.1L2.8,14L3,12.2C3,12.2,3,12.2,3.1,12.2C3.1,12.2,3.1,12.2,3.1,12.2z M3.9,11.9L4.1,14l-0.2,2.1 c0,0.1,0,0.1-0.1,0.1c-0.1,0-0.1,0-0.1-0.1L3.5,14l0.2-2.1c0-0.1,0-0.1,0.1-0.1C3.9,11.8,3.9,11.8,3.9,11.9z M4.7,11.9L4.9,14 l-0.2,2.1c0,0.1-0.1,0.1-0.1,0.1c-0.1,0-0.1,0-0.1-0.1L4.3,14l0.2-2.2c0-0.1,0-0.1,0.1-0.1C4.7,11.7,4.7,11.8,4.7,11.9z M5.6,12 l0.2,2l-0.2,2.1c0,0.1-0.1,0.1-0.1,0.1c0,0-0.1,0-0.1,0c0,0,0-0.1,0-0.1L5.1,14l0.2-2c0,0,0-0.1,0-0.1s0.1,0,0.1,0 C5.5,11.9,5.5,11.9,5.6,12L5.6,12z M6.4,10.7L6.6,14l-0.2,2.1c0,0,0,0.1,0,0.1c0,0-0.1,0-0.1,0c-0.1,0-0.1-0.1-0.2-0.2L5.9,14 l0.2-3.3c0-0.1,0.1-0.2,0.2-0.2c0,0,0.1,0,0.1,0C6.4,10.7,6.4,10.7,6.4,10.7z M7.2,10l0.2,4.1l-0.2,2.1c0,0,0,0.1,0,0.1 c0,0-0.1,0-0.1,0c-0.1,0-0.2-0.1-0.2-0.2l-0.1-2.1L6.8,10c0-0.1,0.1-0.2,0.2-0.2c0,0,0.1,0,0.1,0S7.2,9.9,7.2,10z M8,9.6L8.2,14 L8,16.1c0,0.1-0.1,0.2-0.2,0.2c-0.1,0-0.2-0.1-0.2-0.2L7.5,14l0.1-4.4c0-0.1,0-0.1,0.1-0.1c0,0,0.1-0.1,0.1-0.1c0.1,0,0.1,0,0.1,0.1 C8,9.6,8,9.6,8,9.6z M11.4,16.1L11.4,16.1L11.4,16.1z M9.7,9.6L9.8,14l-0.1,2.1c0,0.1,0,0.1-0.1,0.2s-0.1,0.1-0.2,0.1 c-0.1,0-0.1,0-0.1-0.1s-0.1-0.1-0.1-0.2L9.2,14l0.1-4.4c0-0.1,0-0.1,0.1-0.2s0.1-0.1,0.2-0.1c0.1,0,0.1,0,0.2,0.1S9.7,9.5,9.7,9.6 L9.7,9.6z M10.6,9.8l0.1,4.3l-0.1,2c0,0.1,0,0.1-0.1,0.2c0,0-0.1,0.1-0.2,0.1c-0.1,0-0.1,0-0.2-0.1c0,0-0.1-0.1-0.1-0.2L10,14 l0.1-4.3c0-0.1,0-0.1,0.1-0.2c0,0,0.1-0.1,0.2-0.1c0.1,0,0.1,0,0.2,0.1S10.6,9.7,10.6,9.8z M12.4,14l-0.1,2c0,0.1,0,0.1-0.1,0.2 c-0.1,0.1-0.1,0.1-0.2,0.1c-0.1,0-0.1,0-0.2-0.1c-0.1-0.1-0.1-0.1-0.1-0.2l-0.1-1l-0.1-1l0.1-5.5v0c0-0.1,0-0.2,0.1-0.2 c0.1,0,0.1-0.1,0.2-0.1c0,0,0.1,0,0.1,0c0.1,0,0.1,0.1,0.1,0.2L12.4,14z M22.1,13.9c0,0.7-0.2,1.3-0.7,1.7c-0.5,0.5-1.1,0.7-1.7,0.7 h-6.8c-0.1,0-0.1,0-0.2-0.1c-0.1-0.1-0.1-0.1-0.1-0.2V8.2c0-0.1,0.1-0.2,0.2-0.3c0.5-0.2,1-0.3,1.6-0.3c1.1,0,2.1,0.4,2.9,1.1 c0.8,0.8,1.3,1.7,1.4,2.8c0.3-0.1,0.6-0.2,1-0.2c0.7,0,1.3,0.2,1.7,0.7C21.8,12.6,22.1,13.2,22.1,13.9L22.1,13.9z"></path></svg>',
		'spotify'         => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12,2C6.477,2,2,6.477,2,12c0,5.523,4.477,10,10,10c5.523,0,10-4.477,10-10C22,6.477,17.523,2,12,2 M16.586,16.424 c-0.18,0.295-0.563,0.387-0.857,0.207c-2.348-1.435-5.304-1.76-8.785-0.964c-0.335,0.077-0.67-0.133-0.746-0.469 c-0.077-0.335,0.132-0.67,0.469-0.746c3.809-0.871,7.077-0.496,9.713,1.115C16.673,15.746,16.766,16.13,16.586,16.424 M17.81,13.7 c-0.226,0.367-0.706,0.482-1.072,0.257c-2.687-1.652-6.785-2.131-9.965-1.166C6.36,12.917,5.925,12.684,5.8,12.273 C5.675,11.86,5.908,11.425,6.32,11.3c3.632-1.102,8.147-0.568,11.234,1.328C17.92,12.854,18.035,13.335,17.81,13.7 M17.915,10.865 c-3.223-1.914-8.54-2.09-11.618-1.156C5.804,9.859,5.281,9.58,5.131,9.086C4.982,8.591,5.26,8.069,5.755,7.919 c3.532-1.072,9.404-0.865,13.115,1.338c0.445,0.264,0.59,0.838,0.327,1.282C18.933,10.983,18.359,11.129,17.915,10.865"></path></svg>',
		'tumblr'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M309.8 480.3c-13.6 14.5-50 31.7-97.4 31.7-120.8 0-147-88.8-147-140.6v-144H17.9c-5.5 0-10-4.5-10-10v-68c0-7.2 4.5-13.6 11.3-16 62-21.8 81.5-76 84.3-117.1.8-11 6.5-16.3 16.1-16.3h70.9c5.5 0 10 4.5 10 10v115.2h83c5.5 0 10 4.4 10 9.9v81.7c0 5.5-4.5 10-10 10h-83.4V360c0 34.2 23.7 53.6 68 35.8 4.8-1.9 9-3.2 12.7-2.2 3.5.9 5.8 3.4 7.4 7.9l22 64.3c1.8 5 3.3 10.6-.4 14.5z"/></svg>',
		'twitch'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M16.499,8.089h-1.636v4.91h1.636V8.089z M12,8.089h-1.637v4.91H12V8.089z M4.228,3.178L3,6.451v13.092h4.499V22h2.456 l2.454-2.456h3.681L21,14.636V3.178H4.228z M19.364,13.816l-2.864,2.865H12l-2.453,2.453V16.68H5.863V4.814h13.501V13.816z"></path></svg>',
		'twitter'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"></path></svg>',
		'vimeo'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3C100.3 250 85.3 174.3 56.2 174.3c-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z"/></svg>',
		'vk'              => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22,7.1c0.2,0.4-0.4,1.5-1.6,3.1c-0.2,0.2-0.4,0.5-0.7,0.9c-0.5,0.7-0.9,1.1-0.9,1.4c-0.1,0.3-0.1,0.6,0.1,0.8 c0.1,0.1,0.4,0.4,0.8,0.9h0l0,0c1,0.9,1.6,1.7,2,2.3c0,0,0,0.1,0.1,0.1c0,0.1,0,0.1,0.1,0.3c0,0.1,0,0.2,0,0.4 c0,0.1-0.1,0.2-0.3,0.3c-0.1,0.1-0.4,0.1-0.6,0.1l-2.7,0c-0.2,0-0.4,0-0.6-0.1c-0.2-0.1-0.4-0.1-0.5-0.2l-0.2-0.1 c-0.2-0.1-0.5-0.4-0.7-0.7s-0.5-0.6-0.7-0.8c-0.2-0.2-0.4-0.4-0.6-0.6C14.8,15,14.6,15,14.4,15c0,0,0,0-0.1,0c0,0-0.1,0.1-0.2,0.2 c-0.1,0.1-0.2,0.2-0.2,0.3c-0.1,0.1-0.1,0.3-0.2,0.5c-0.1,0.2-0.1,0.5-0.1,0.8c0,0.1,0,0.2,0,0.3c0,0.1-0.1,0.2-0.1,0.2l0,0.1 c-0.1,0.1-0.3,0.2-0.6,0.2h-1.2c-0.5,0-1,0-1.5-0.2c-0.5-0.1-1-0.3-1.4-0.6s-0.7-0.5-1.1-0.7s-0.6-0.4-0.7-0.6l-0.3-0.3 c-0.1-0.1-0.2-0.2-0.3-0.3s-0.4-0.5-0.7-0.9s-0.7-1-1.1-1.6c-0.4-0.6-0.8-1.3-1.3-2.2C2.9,9.4,2.5,8.5,2.1,7.5C2,7.4,2,7.3,2,7.2 c0-0.1,0-0.1,0-0.2l0-0.1c0.1-0.1,0.3-0.2,0.6-0.2l2.9,0c0.1,0,0.2,0,0.2,0.1S5.9,6.9,5.9,7L6,7c0.1,0.1,0.2,0.2,0.3,0.3 C6.4,7.7,6.5,8,6.7,8.4C6.9,8.8,7,9,7.1,9.2l0.2,0.3c0.2,0.4,0.4,0.8,0.6,1.1c0.2,0.3,0.4,0.5,0.5,0.7s0.3,0.3,0.4,0.4 c0.1,0.1,0.3,0.1,0.4,0.1c0.1,0,0.2,0,0.3-0.1c0,0,0,0,0.1-0.1c0,0,0.1-0.1,0.1-0.2c0.1-0.1,0.1-0.3,0.1-0.5c0-0.2,0.1-0.5,0.1-0.8 c0-0.4,0-0.8,0-1.3c0-0.3,0-0.5-0.1-0.8c0-0.2-0.1-0.4-0.1-0.5L9.6,7.6C9.4,7.3,9.1,7.2,8.7,7.1C8.6,7.1,8.6,7,8.7,6.9 C8.9,6.7,9,6.6,9.1,6.5c0.4-0.2,1.2-0.3,2.5-0.3c0.6,0,1,0.1,1.4,0.1c0.1,0,0.3,0.1,0.3,0.1c0.1,0.1,0.2,0.1,0.2,0.3 c0,0.1,0.1,0.2,0.1,0.3s0,0.3,0,0.5c0,0.2,0,0.4,0,0.6c0,0.2,0,0.4,0,0.7c0,0.3,0,0.6,0,0.9c0,0.1,0,0.2,0,0.4c0,0.2,0,0.4,0,0.5 c0,0.1,0,0.3,0,0.4s0.1,0.3,0.1,0.4c0.1,0.1,0.1,0.2,0.2,0.3c0.1,0,0.1,0,0.2,0c0.1,0,0.2,0,0.3-0.1c0.1-0.1,0.2-0.2,0.4-0.4 s0.3-0.4,0.5-0.7c0.2-0.3,0.5-0.7,0.7-1.1c0.4-0.7,0.8-1.5,1.1-2.3c0-0.1,0.1-0.1,0.1-0.2c0-0.1,0.1-0.1,0.1-0.1l0,0l0.1,0 c0,0,0,0,0.1,0s0.2,0,0.2,0l3,0c0.3,0,0.5,0,0.7,0S21.9,7,21.9,7L22,7.1z"></path></svg>',
		'wordpress'       => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.158,12.786L9.46,20.625c0.806,0.237,1.657,0.366,2.54,0.366c1.047,0,2.051-0.181,2.986-0.51 c-0.024-0.038-0.046-0.079-0.065-0.124L12.158,12.786z M3.009,12c0,3.559,2.068,6.634,5.067,8.092L3.788,8.341 C3.289,9.459,3.009,10.696,3.009,12z M18.069,11.546c0-1.112-0.399-1.881-0.741-2.48c-0.456-0.741-0.883-1.368-0.883-2.109 c0-0.826,0.627-1.596,1.51-1.596c0.04,0,0.078,0.005,0.116,0.007C16.472,3.904,14.34,3.009,12,3.009 c-3.141,0-5.904,1.612-7.512,4.052c0.211,0.007,0.41,0.011,0.579,0.011c0.94,0,2.396-0.114,2.396-0.114 C7.947,6.93,8.004,7.642,7.52,7.699c0,0-0.487,0.057-1.029,0.085l3.274,9.739l1.968-5.901l-1.401-3.838 C9.848,7.756,9.389,7.699,9.389,7.699C8.904,7.67,8.961,6.93,9.446,6.958c0,0,1.484,0.114,2.368,0.114 c0.94,0,2.397-0.114,2.397-0.114c0.485-0.028,0.542,0.684,0.057,0.741c0,0-0.488,0.057-1.029,0.085l3.249,9.665l0.897-2.996 C17.841,13.284,18.069,12.316,18.069,11.546z M19.889,7.686c0.039,0.286,0.06,0.593,0.06,0.924c0,0.912-0.171,1.938-0.684,3.22 l-2.746,7.94c2.673-1.558,4.47-4.454,4.47-7.771C20.991,10.436,20.591,8.967,19.889,7.686z M12,22C6.486,22,2,17.514,2,12 C2,6.486,6.486,2,12,2c5.514,0,10,4.486,10,10C22,17.514,17.514,22,12,22z"></path></svg>',
		'whatsapp'        => '<svg viewBox="0 0 32 32"><path d="M23.813 6.063q-2-1.938-4.531-3t-5.281-1.063q-3.75 0-6.938 1.875t-5.063 5.063-1.875 6.938 1.875 6.938l-2 7.188 7.375-1.938q3.063 1.688 6.625 1.688v0q3.75 0 6.969-1.875t5.125-5.063 1.906-6.938q0-2.75-1.094-5.281t-3.094-4.531zM14 27.438q-3.188 0-5.875-1.625l-0.438-0.25-4.375 1.125 1.188-4.25-0.25-0.438q-1.813-2.813-1.813-6.125 0-3.125 1.563-5.781t4.219-4.219 5.781-1.563q2.313 0 4.406 0.875t3.75 2.531 2.594 3.781 0.938 4.375q0 3.125-1.594 5.781t-4.281 4.219-5.813 1.563zM20.313 18.75q-1.875-0.938-2.375-1.125-0.25-0.063-0.438-0.063t-0.313 0.25q-0.313 0.438-1.125 1.375-0.25 0.313-0.75 0.063-1.75-0.875-2.625-1.563-1.188-0.938-2.063-2.563-0.188-0.188-0.125-0.344t0.313-0.406q0.5-0.5 0.813-1.125 0.125-0.25-0.063-0.625l-1.063-2.563q-0.125-0.375-0.281-0.469t-0.406-0.094h-0.75q-0.5 0-0.938 0.438l-0.063 0.063q-1.125 1.188-1.125 2.813t1.375 3.563l0.125 0.125q2.625 3.75 5.813 5.125 1.563 0.688 2.5 0.875 0.813 0.125 1.688 0 0.563-0.063 1.344-0.594t1-1.063 0.25-1.031-0.031-0.625-0.5-0.313z"></path></svg>',
		'yelp'            => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.271,16.718v1.417q-.011,3.257-.067,3.4a.707.707,0,0,1-.569.446,4.637,4.637,0,0,1-2.024-.424A4.609,4.609,0,0,1,7.8,20.565a.844.844,0,0,1-.19-.4.692.692,0,0,1,.044-.29,3.181,3.181,0,0,1,.379-.524q.335-.412,2.019-2.409.011,0,.669-.781a.757.757,0,0,1,.44-.274.965.965,0,0,1,.552.039.945.945,0,0,1,.418.324.732.732,0,0,1,.139.468Zm-1.662-2.8a.783.783,0,0,1-.58.781l-1.339.435q-3.067.981-3.257.981a.711.711,0,0,1-.6-.4,2.636,2.636,0,0,1-.19-.836,9.134,9.134,0,0,1,.011-1.857,3.559,3.559,0,0,1,.335-1.389.659.659,0,0,1,.625-.357,22.629,22.629,0,0,1,2.253.859q.781.324,1.283.524l.937.379a.771.771,0,0,1,.4.34A.982.982,0,0,1,10.609,13.917Zm9.213,3.313a4.467,4.467,0,0,1-1.021,1.8,4.559,4.559,0,0,1-1.512,1.417.671.671,0,0,1-.7-.078q-.156-.112-2.052-3.2l-.524-.859a.761.761,0,0,1-.128-.513.957.957,0,0,1,.217-.513.774.774,0,0,1,.926-.29q.011.011,1.327.446,2.264.736,2.7.887a2.082,2.082,0,0,1,.524.229.673.673,0,0,1,.245.68Zm-7.5-7.049q.056,1.137-.6,1.361-.647.19-1.272-.792L6.237,4.08a.7.7,0,0,1,.212-.691,5.788,5.788,0,0,1,2.314-1,5.928,5.928,0,0,1,2.5-.352.681.681,0,0,1,.547.5q.034.2.245,3.407T12.327,10.181Zm7.384,1.2a.679.679,0,0,1-.29.658q-.167.112-3.67.959-.747.167-1.015.257l.011-.022a.769.769,0,0,1-.513-.044.914.914,0,0,1-.413-.357.786.786,0,0,1,0-.971q.011-.011.836-1.137,1.394-1.908,1.673-2.275a2.423,2.423,0,0,1,.379-.435A.7.7,0,0,1,17.435,8a4.482,4.482,0,0,1,1.372,1.489,4.81,4.81,0,0,1,.9,1.868v.034Z"></path></svg>',
		'youtube'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg>',
		'telegram'        => '<svg viewBox="0 0 32 32"><path d="M27.938 6.188l-4.25 19.875q-0.25 1.063-0.844 1.344t-1.469-0.219l-6.438-4.75-3.125 3q-0.313 0.313-0.5 0.438-0.313 0.188-0.813 0.188l0.5-6.563 11.938-10.813q0.25-0.188 0.156-0.344t-0.375-0.125-0.594 0.219l-14.75 9.313-6.375-2q-1.063-0.313-1-0.938t1.313-1.125l24.813-9.563q0.938-0.313 1.5 0.219t0.313 1.844z"></path></svg>',
		'stumbleupon'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M502.9 266v69.7c0 62.1-50.3 112.4-112.4 112.4-61.8 0-112.4-49.8-112.4-111.3v-70.2l34.3 16 51.1-15.2V338c0 14.7 12 26.5 26.7 26.5S417 352.7 417 338v-72h85.9zm-224.7-58.2l34.3 16 51.1-15.2V173c0-60.5-51.1-109-112.1-109-60.8 0-112.1 48.2-112.1 108.2v162.4c0 14.9-12 26.7-26.7 26.7S86 349.5 86 334.6V266H0v69.7C0 397.7 50.3 448 112.4 448c61.6 0 112.4-49.5 112.4-110.8V176.9c0-14.7 12-26.7 26.7-26.7s26.7 12 26.7 26.7v30.9z"/></svg>',
		'tiktok' 		  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z"/></svg>',
		'houzz' 		  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M275.9 330.7H171.3V480H17V32h109.5v104.5l305.1 85.6V480H275.9z"/></svg>',
		'rss' 			  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M128.081 415.959c0 35.369-28.672 64.041-64.041 64.041S0 451.328 0 415.959s28.672-64.041 64.041-64.041 64.04 28.673 64.04 64.041zm175.66 47.25c-8.354-154.6-132.185-278.587-286.95-286.95C7.656 175.765 0 183.105 0 192.253v48.069c0 8.415 6.49 15.472 14.887 16.018 111.832 7.284 201.473 96.702 208.772 208.772.547 8.397 7.604 14.887 16.018 14.887h48.069c9.149.001 16.489-7.655 15.995-16.79zm144.249.288C439.596 229.677 251.465 40.445 16.503 32.01 7.473 31.686 0 38.981 0 48.016v48.068c0 8.625 6.835 15.645 15.453 15.999 191.179 7.839 344.627 161.316 352.465 352.465.353 8.618 7.373 15.453 15.999 15.453h48.068c9.034-.001 16.329-7.474 16.005-16.504z"/></svg>'
	);

	/**
	 * Get the SVG code for the specified icon
	 *
	 * @since 1.0.0
	 *
	 * @param string $icon Icon name.
	 * @param string $group Icon group.
	 * @param array  $size The icon attributes.
	 *
	 * @return string
	 */
	public static function get_svg( $icon, $group = 'ui', $attr = array() ) {
		$attr = wp_parse_args( $attr, array(
			'class' => '',
			'size'  => 24,
		) );
		$svg = '';

		if ( ! empty( $group ) ) {
			if ( 'ui' === $group ) {
				$arr = self::$ui_icons;
			} elseif ( 'social' === $group ) {
				$arr = self::$social_icons;
			} else {
				$arr = array();
			}

			$arr = apply_filters( "glozin_svg_icons_{$group}", $arr );

			if ( array_key_exists( $icon, $arr ) ) {
				$svg = $arr[ $icon ];
			}
		} else {
			if ( array_key_exists( $icon, self::$ui_icons ) ) {
				$svg = self::$ui_icons[ $icon ];
			} elseif ( array_key_exists( $icon, self::$social_icons ) ) {
				$svg = self::$social_icons[ $icon ];
			}
		}

		if ( $svg ) {
			$size = absint( $attr['size'] );

			if ( strpos( $svg, 'width' ) && strpos( $svg, 'height' ) ) {
				$repl = sprintf( '<svg aria-hidden="true" role="img" focusable="false" ' );
			} else {
				$repl = sprintf( '<svg width="%d" height="%d" aria-hidden="true" role="img" focusable="false" ', $size, $size );
			}

			// Build attributes.
			unset( $attr['size'] );
			$attr_string = '';

			$attr['class'] = trim( 'glozin-svg-icon glozin-svg-icon--' . $icon . ' ' . $attr['class'] );

			foreach ( $attr as $name => $value ) {
				$attr_string .= esc_attr( $name ) . '="' . esc_attr( $value ) . '" ';
			}

			$svg = preg_replace( '/^<svg /', $repl, $svg );
			$svg = '<span ' . $attr_string . '>' . $svg . '</span>';
		}

		return $svg;
	}

	/**
	 * Return SVG markup.
	 *
	 * @param array $args
	 *
	 * @return string
	 */
	public static function inline_svg( $args = array() ) {
		$args = wp_parse_args( $args, array(
			'icon'     => '',
			'class'    => '',
			'width'     => 24,
			'height'     => 24,
			'title'    => '',
			'desc'     => '',
			'fallback' => '',
			'original_size'  => false,
			'echo'     => true,
		) );

		// Begin SVG markup.
		$svg = sprintf( '<svg width="%d" height="%d" aria-hidden="true" role="img" focusable="false" >', $args['width'], $args['height'] );

		// Display the title.
		if ( $args['title'] ) {
			$unique_id = uniqid();
			$svg       .= '<title id="title-' . $unique_id . '">' . esc_html( $args['title'] ) . '</title>';

			// Display the desc only if the title is already set.
			if ( $args['desc'] ) {
				$svg .= '<desc id="desc-' . $unique_id . '">' . esc_html( $args['desc'] ) . '</desc>';
			}
		}

		$svg .= ' <use href="#' . esc_html( $args['icon'] ) . '" xlink:href="#' . esc_html( $args['icon'] ) . '"></use> ';

		// Add some markup to use as a fallback for browsers that do not support SVGs.
		if ( $args['fallback'] ) {
			$svg .= '<span class="svg-fallback ' . esc_attr( $args['fallback'] ) . '"></span>';
		}

		$svg .= '</svg>';

		$svg  = apply_filters( 'glozin_svg_icon_code', $svg, $args );
		$wrapper_class = !empty($args['original_size']) ? 'glozin-svg-icon-original' : 'glozin-svg-icon';
		$code = $svg ? '<span class="' . esc_attr( $wrapper_class ) . ' glozin-svg-icon__inline glozin-svg-icon--' . esc_attr( $args['icon'] ) . ' ' . esc_attr( $args['class'] ) . '">' . $svg . '</span>' : '';
		$code = apply_filters( 'glozin_svg_icon', $code, $args );

		if ( $args['echo'] ) {
			return $code;
		}

		return self::sanitize_svg( $svg ); // XSS: ignore.
	}

	/**
	 * Sanitize SVG code.
	 *
	 * @since 1.0.0
	 *
	 * @param string $svg SVG code.
	 *
	 * @return string
	 */
	public static function sanitize_svg( $svg ) {
		$allowed   = array();
		$whitelist = array(
			'a'              => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'mask', 'opacity', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'href', 'xlink:href', 'xlink:title' ),
			'circle'         => array( 'class', 'clip-path', 'clip-rule', 'cx', 'cy', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'mask', 'opacity', 'r', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform' ),
			'clipPath'       => array( 'class', 'clipPathUnits', 'id' ),
			'defs'           => array(),
			'style'          => array( 'type' ),
			'desc'           => array(),
			'ellipse'        => array( 'class', 'clip-path', 'clip-rule', 'cx', 'cy', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'mask', 'opacity', 'requiredFeatures', 'rx', 'ry', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform' ),
			'feGaussianBlur' => array( 'class', 'color-interpolation-filters', 'id', 'requiredFeatures', 'stdDeviation' ),
			'filter'         => array( 'class', 'color-interpolation-filters', 'filterRes', 'filterUnits', 'height', 'id', 'primitiveUnits', 'requiredFeatures', 'width', 'x', 'xlink:href', 'y' ),
			'foreignObject'  => array( 'class', 'font-size', 'height', 'id', 'opacity', 'requiredFeatures', 'style', 'transform', 'width', 'x', 'y' ),
			'g'              => array( 'class', 'clip-path', 'clip-rule', 'id', 'display', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'font-family', 'font-size', 'font-style', 'font-weight', 'text-anchor', ),
			'image'          => array( 'class', 'clip-path', 'clip-rule', 'filter', 'height', 'id', 'mask', 'opacity', 'requiredFeatures', 'style', 'systemLanguage', 'transform', 'width', 'x', 'xlink:href', 'xlink:title', 'y', ),
			'line'           => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'x1', 'x2', 'y1', 'y2', ),
			'linearGradient' => array( 'class', 'id', 'gradientTransform', 'gradientUnits', 'requiredFeatures', 'spreadMethod', 'systemLanguage', 'x1', 'x2', 'xlink:href', 'y1', 'y2', ),
			'marker'         => array( 'id', 'class', 'markerHeight', 'markerUnits', 'markerWidth', 'orient', 'preserveAspectRatio', 'refX', 'refY', 'systemLanguage', 'viewBox', ),
			'mask'           => array( 'class', 'height', 'id', 'maskContentUnits', 'maskUnits', 'width', 'x', 'y' ),
			'metadata'       => array( 'class', 'id' ),
			'path'           => array( 'class', 'clip-path', 'clip-rule', 'd', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', ),
			'pattern'        => array( 'class', 'height', 'id', 'patternContentUnits', 'patternTransform', 'patternUnits', 'requiredFeatures', 'style', 'systemLanguage', 'viewBox', 'width', 'x', 'xlink:href', 'y', ),
			'polygon'        => array( 'class', 'clip-path', 'clip-rule', 'id', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'class', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'points', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', ),
			'polyline'       => array( 'class', 'clip-path', 'clip-rule', 'id', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'points', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', ),
			'radialGradient' => array( 'class', 'cx', 'cy', 'fx', 'fy', 'gradientTransform', 'gradientUnits', 'id', 'r', 'requiredFeatures', 'spreadMethod', 'systemLanguage', 'xlink:href', ),
			'rect'           => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'height', 'id', 'mask', 'opacity', 'requiredFeatures', 'rx', 'ry', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'width', 'x', 'y', ),
			'stop'           => array( 'class', 'id', 'offset', 'requiredFeatures', 'stop-color', 'stop-opacity', 'style', 'systemLanguage', ),
			'svg'            => array( 'class', 'clip-path', 'clip-rule', 'filter', 'id', 'mask', 'fill', 'stroke', 'preserveaspectRatio', 'requiredfeatures', 'style', 'systemlanguage', 'viewbox', 'width', 'height', 'xmlns', 'xmlns:se', 'xmlns:xlink', 'x', 'y', 'enable-background', ),
			'switch'         => array( 'class', 'id', 'requiredFeatures', 'systemLanguage' ),
			'symbol'         => array( 'class', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'font-family', 'font-size', 'font-style', 'font-weight', 'id', 'opacity', 'preserveAspectRatio', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'viewBox', ),
			'text'           => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'font-family', 'font-size', 'font-style', 'font-weight', 'id', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'text-anchor', 'transform', 'x', 'xml:space', 'y', ),
			'textPath'       => array( 'class', 'id', 'method', 'requiredFeatures', 'spacing', 'startOffset', 'style', 'systemLanguage', 'transform', 'xlink:href', ),
			'title'          => array(),
			'tspan'          => array( 'class', 'clip-path', 'clip-rule', 'dx', 'dy', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'font-family', 'font-size', 'font-style', 'font-weight', 'id', 'mask', 'opacity', 'requiredFeatures', 'rotate', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'text-anchor', 'textLength', 'transform', 'x', 'xml:space', 'y', ),
			'use'            => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'height', 'id', 'mask', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'transform', 'width', 'x', 'xlink:href', 'y', ),
		);

		foreach ( $whitelist as $tag => $attributes ) {
			$allowed[ $tag ] = array();

			foreach ( $attributes as $attribute ) {
				$allowed[ $tag ][ $attribute ] = true;
			}
		}

		return wp_kses( $svg, $allowed );
	}
}
