<?php
/**
 * SMOF Admin
 *
 * @package     WordPress
 * @subpackage  SMOF
 * @since       1.4.0
 * @author      Syamil MJ
 */
 

/**
 * Head Hook
 *
 * @since 1.0.0
 */
function gon_of_head() { do_action( 'gon_of_head' ); }

/**
 * Change activation message
 *
 * @since 1.0.0
 */
function gon_optionsframework_admin_message() { 
	
	//Tweaked the message on theme activate
	?>
    <script type="text/javascript">
    jQuery(function(){
    	"use strict";
        var message = '<p>This theme comes with an <a href="<?php echo admin_url('admin.php?page=optionsframework'); ?>">options panel</a> to configure settings. This theme also supports widgets, please visit the <a href="<?php echo admin_url('widgets.php'); ?>">widgets settings page</a> to configure them.</p>';
    	jQuery('.themes-php #message2').html(message);
    
    });
    </script>
    <?php
	
}

/**
 * Get header classes
 *
 * @since 1.0.0
 */
function gon_of_get_header_classes_array() 
{
	global $gon_of_options;
	$hooks = array();
	foreach ($gon_of_options as $value) 
	{
		if( $value['type'] == 'heading' ){
			$hooks[] = str_replace(' ','',strtolower($value['name']));	
		}
	}
	
	return $hooks;
}

/**
 * Get options from the database and process them with the load filter hook.
 *
 * @author Jonah Dahlquist
 * @since 1.4.0
 * @return array
 */
function gon_of_get_options($key = null, $data = null) {
	global $smof_data;

	do_action('gon_of_get_options_before', array(
		'key'=>$key, 'data'=>$data
	));
	if ($key != null) { // Get one specific value
		$data = get_theme_mod($key, $data);
	} else { // Get all values
		$data = get_theme_mods();	
	}
	$data = apply_filters('gon_of_options_after_load', $data);
	if ($key == null) {
		$smof_data = $data;
	} else {
		$smof_data[$key] = $data;
	}
	do_action('gon_of_option_setup_before', array(
		'key'=>$key, 'data'=>$data
	));
	return $data;

}

/**
 * Save options to the database after processing them
 *
 * @param $data Options array to save
 * @author Jonah Dahlquist
 * @since 1.4.0
 * @uses update_option()
 * @return void
 */

function gon_of_save_options($data, $key = null) {
	global $smof_data;
    if( empty($data) ){
        return;	
	}
    do_action('gon_of_save_options_before', array(
		'key'=>$key, 'data'=>$data
	));
	$data = apply_filters('gon_of_options_before_save', $data);
	if ($key != null) { // Update one specific value
		if ($key == BACKUPS) {
			unset($data['smof_init']); // Don't want to change this.
		}
		set_theme_mod($key, $data);
	} else { // Update all values in $data
		foreach ( $data as $k=>$v ) {
			if (!isset($smof_data[$k]) || $smof_data[$k] != $v) { // Only write to the DB when we need to
				set_theme_mod($k, $v);
			} else if (is_array($v)) {
				foreach ($v as $key=>$val) {
					if ($key != $k && $v[$key] == $val) {
						set_theme_mod($k, $v);
						break;
					}
				}
			}
	  	}
	}
    do_action('gon_of_save_options_after', array(
		'key'=>$key, 'data'=>$data
	));

	update_option('gon_of_last_updated_time', time());
}


/* Fix bug activate theme no value default */
function gon_of_option_setup()	
{
	global $gon_of_options, $gon_options_machine;
	$ts_data = gon_of_get_options();
	$gon_options_machine = new Gon_Options_Machine($gon_of_options);
	$ts_data = gon_array_atts($gon_options_machine->Defaults, $ts_data);
	gon_of_save_options_setup($ts_data);	
}

function gon_of_save_options_setup($data){
	foreach ( $data as $k=>$v ) {
		if (is_array($v)) {
			foreach ($v as $key=>$val) {
				if ($key != $k && $v[$key] == $val) {
					set_theme_mod($k, $v);
					break;
				}
			}
		} else {
			set_theme_mod($k, $v);
		}		
	}
}


/**
 * For use in themes
 *
 * @since forever
 */



$data = gon_of_get_options();
if( !isset($gon_smof_details) ){
	$gon_smof_details = array();
}