<?php
function gon_deprecated_function( $function, $version = '2.0.0', $replacement = null ){
	if( !( defined('WP_DEBUG') && WP_DEBUG && apply_filters( 'deprecated_function_trigger_error', true ) ) ){
		return;
	}
	
	do_action( 'deprecated_function_run', $function, $replacement, $version );
	if( !is_null( $replacement ) ){
		$message = sprintf( esc_html__( '%1$s is deprecated since version %2$s! Use %3$s instead.', 'gon' ), $function, $version, $replacement );
	}
	else{
		$message = sprintf( esc_html__( '%1$s is deprecated since version %2$s with no alternative available.', 'gon' ), $function, $version );
	}
	if( wp_doing_ajax() ){
		error_log( $message );
	}
	else{
		trigger_error( $message );
	}
}

if( !function_exists('ts_get_vertical_menu_heading') ){
	function ts_get_vertical_menu_heading(){
		gon_deprecated_function('ts_get_vertical_menu_heading', '2.0.0', 'gon_get_vertical_menu_heading');
		return gon_get_vertical_menu_heading();
	}
}

if( !function_exists('ts_the_excerpt_max_words') ){
	function ts_the_excerpt_max_words( $word_limit = -1, $post = '', $strip_tags = true, $extra_str = '', $echo = true ){
		gon_deprecated_function('ts_the_excerpt_max_words', '2.0.0', 'gon_the_excerpt_max_words');
		return gon_the_excerpt_max_words( $word_limit, $post, $strip_tags, $extra_str, $echo );
	}
}

if( !function_exists('ts_page_layout_columns_class') ){
	function ts_page_layout_columns_class( $page_column ){
		gon_deprecated_function('ts_page_layout_columns_class', '2.0.0', 'gon_page_layout_columns_class');
		return gon_page_layout_columns_class( $page_column );
	}
}

if( !function_exists('ts_show_page_slider') ){
	function ts_show_page_slider(){
		gon_deprecated_function('ts_show_page_slider', '2.0.0', 'gon_show_page_slider');
		gon_show_page_slider();
	}
}

if( !function_exists('ts_has_woocommerce') ){
	function ts_has_woocommerce(){
		gon_deprecated_function('ts_has_woocommerce', '2.0.0');
		return class_exists('WooCommerce');
	}
}

if( !function_exists('ts_breadcrumbs_title') ){
	function ts_breadcrumbs_title( $show_breadcrumb = false, $show_page_title = false, $page_title = '', $extra_class_title = '' ){
		gon_deprecated_function('ts_breadcrumbs_title', '2.0.0', 'gon_breadcrumbs_title');
		gon_breadcrumbs_title( $show_breadcrumb, $show_page_title, $page_title, $extra_class_title );
	}
}

if( !function_exists('ts_pagination') ){
	function ts_pagination( $query = null ){
		gon_deprecated_function('ts_pagination', '2.0.0', 'gon_pagination');
		gon_pagination( $query );
	}
}

if( !function_exists('ts_theme_logo') ){
	function ts_theme_logo(){
		gon_deprecated_function('ts_theme_logo', '2.0.0', 'gon_theme_logo');
		gon_theme_logo();
	}
}

if( !function_exists('ts_theme_favicon') ){
	function ts_theme_favicon(){
		gon_deprecated_function('ts_theme_favicon', '2.0.0', 'gon_theme_favicon');
		gon_theme_favicon();
	}
}

if( !function_exists('ts_get_search_form_by_category') ){
	function ts_get_search_form_by_category(){
		gon_deprecated_function('ts_get_search_form_by_category', '2.0.0', 'gon_get_search_form_by_category');
		gon_get_search_form_by_category();
	}
}

if( !function_exists('ts_template_loop_short_description') ){
	function ts_template_loop_short_description(){
		gon_deprecated_function('ts_template_loop_short_description', '2.0.0', 'gon_template_loop_short_description');
		gon_template_loop_short_description();
	}
}

if( !function_exists('ts_template_loop_product_label') ){
	function ts_template_loop_product_label(){
		gon_deprecated_function('ts_template_loop_product_label', '2.0.0', 'gon_template_loop_product_label');
		gon_template_loop_product_label();
	}
}

if( !function_exists('ts_template_single_sku') ){
	function ts_template_single_sku(){
		gon_deprecated_function('ts_template_single_sku', '2.0.0', 'gon_template_single_sku');
		gon_template_single_sku();
	}
}

if( !function_exists('ts_template_single_availability') ){
	function ts_template_single_availability(){
		gon_deprecated_function('ts_template_single_availability', '2.0.0', 'gon_template_single_availability');
		gon_template_single_availability();
	}
}

if( !function_exists('ts_template_loop_product_thumbnail') ){
	function ts_template_loop_product_thumbnail(){
		gon_deprecated_function('ts_template_loop_product_thumbnail', '2.0.0', 'gon_template_loop_product_thumbnail');
		gon_template_loop_product_thumbnail();
	}
}

if( !function_exists('ts_template_loop_categories') ){
	function ts_template_loop_categories(){
		gon_deprecated_function('ts_template_loop_categories', '2.0.0', 'gon_template_loop_categories');
		gon_template_loop_categories();
	}
}

if( !function_exists('ts_template_loop_product_title') ){
	function ts_template_loop_product_title(){
		gon_deprecated_function('ts_template_loop_product_title', '2.0.0', 'gon_template_loop_product_title');
		gon_template_loop_product_title();
	}
}

if( !function_exists('ts_template_loop_product_sku') ){
	function ts_template_loop_product_sku(){
		gon_deprecated_function('ts_template_loop_product_sku', '2.0.0', 'gon_template_loop_product_sku');
		gon_template_loop_product_sku();
	}
}

if( !function_exists('ts_template_loop_add_to_cart') ){
	function ts_template_loop_add_to_cart(){
		gon_deprecated_function('ts_template_loop_add_to_cart', '2.0.0', 'gon_template_loop_add_to_cart');
		gon_template_loop_add_to_cart();
	}
}

if( !function_exists('ts_template_social_sharing') ){
	function ts_template_social_sharing(){
		// Show nothing if ThemeSky is not updated
	}
}

if( !function_exists('ts_tiny_account') ){
	function ts_tiny_account(){
		gon_deprecated_function('ts_tiny_account', '2.0.0', 'gon_tiny_account');
		return gon_tiny_account();
	}
}

if( !function_exists('ts_tiny_cart') ){
	function ts_tiny_cart(){
		gon_deprecated_function('ts_tiny_cart', '2.0.0', 'gon_tiny_cart');
		return gon_tiny_cart();
	}
}

if( !function_exists('ts_tini_wishlist') ){
	function ts_tini_wishlist(){
		gon_deprecated_function('ts_tini_wishlist', '2.0.0', 'gon_tini_wishlist');
		return gon_tini_wishlist();
	}
}

if( !function_exists('ts_woocommerce_multilingual_currency_switcher') ){
	function ts_woocommerce_multilingual_currency_switcher(){
		gon_deprecated_function('ts_woocommerce_multilingual_currency_switcher', '2.0.0', 'gon_woocommerce_multilingual_currency_switcher');
		gon_woocommerce_multilingual_currency_switcher();
	}
}

if( !function_exists('ts_wpml_language_selector') ){
	function ts_wpml_language_selector(){
		gon_deprecated_function('ts_wpml_language_selector', '2.0.0', 'gon_wpml_language_selector');
		gon_wpml_language_selector();
	}
}

add_action('gon_before_main_content', 'gon_execute_old_before_main_content_action');
function gon_execute_old_before_main_content_action(){
	do_action('ts_before_main_content');
}