<?php
/*************************************************
* WooCommerce Custom Hook                        *
**************************************************/

/*** Shop - Category ***/

/* Remove hook */
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);

remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);

remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);

remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);

remove_action('woocommerce_before_subcategory', 'woocommerce_template_loop_category_link_open', 10);
remove_action('woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10);

/* Add new hook */

add_action('woocommerce_before_shop_loop_item_title', 'gon_template_loop_product_thumbnail', 10);
add_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_product_label', 1);

add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_categories', 10);
add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_product_title', 20);
add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_product_sku', 30);
add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_short_description', 40); 
add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_short_description_listview', 65); 
add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_price', 50);
add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_rating', 60);
add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_add_to_cart', 70); 

add_action('woocommerce_before_shop_loop', 'gon_shop_top_content_widget_area_button', 25);

add_filter('loop_shop_per_page', 'gon_change_products_per_page_shop' ); 
add_filter('woocommerce_product_get_rating_html', 'gon_get_empty_rating_html', 10, 2);

add_filter('woocommerce_before_output_product_categories', 'gon_before_output_product_categories');
add_filter('woocommerce_after_output_product_categories', 'gon_after_output_product_categories');

function gon_template_loop_product_label(){
	global $product;
	$theme_options = gon_get_theme_options();
	?>
	<div class="product-label">
	<?php 
	if( $product->is_in_stock() ){
		/* Sale label */
		if( $product->is_on_sale() ){
			if( $theme_options['ts_show_sale_label_as'] != 'text' ){
				if( $product->get_type() == 'variable' ){
					$regular_price = $product->get_variation_regular_price('max');
					$sale_price = $product->get_variation_sale_price('min');
				}
				else{
					$regular_price = $product->get_regular_price();
					$sale_price = $product->get_price();
				}
				if( $regular_price ){
					if( $theme_options['ts_show_sale_label_as'] == 'number' ){
						$_off_price = round($regular_price - $sale_price, wc_get_price_decimals());
						$price_display = '-' . sprintf(get_woocommerce_price_format(), get_woocommerce_currency_symbol(), $_off_price);
						echo '<span class="onsale amount" data-original="'.$price_display.'">'.$price_display.'</span>';
					}
					if( $theme_options['ts_show_sale_label_as'] == 'percent' ){
						$_off_percent = ( 1 - round($sale_price / $regular_price, 2) ) * 100;
						echo '<span class="onsale percent">-'.$_off_percent.'%</span>';
					}
				}
			}
			else{
				echo '<span class="onsale">'.esc_html(stripslashes($theme_options['ts_product_sale_label_text'])).'</span>';
			}
		}
		
		/* Hot label */
		if( $product->is_featured() ){
			echo '<span class="featured">'.esc_html(stripslashes($theme_options['ts_product_feature_label_text'])).'</span>';
		}
	}
	else{ /* Out of stock */
		echo '<span class="out-of-stock">'.esc_html(stripslashes($theme_options['ts_product_out_of_stock_label_text'])).'</span>';
	}
	?>
	</div>
	<?php
}

function gon_template_loop_product_thumbnail(){
	global $product;
	$theme_options = gon_get_theme_options();
	$lazy_load = $theme_options['ts_prod_lazy_load'] && !wp_doing_ajax();
	$placeholder_img_src = $theme_options['ts_prod_placeholder_img'];
	
	if( defined( 'YITH_INFS' ) && (is_shop() || is_product_taxonomy()) ){ /* Compatible with YITH Infinite Scrolling */
		$lazy_load = false;
	}
	
	$prod_galleries = $product->get_gallery_image_ids();
	
	$has_back_image = $theme_options['ts_effect_product'];
	
	if( !is_array($prod_galleries) || ( is_array($prod_galleries) && count($prod_galleries) == 0 ) ){
		$has_back_image = false;
	}
	 
	if( wp_is_mobile() ){
		$has_back_image = false;
	}
	
	$image_size = apply_filters('ts_loop_product_thumbnail', 'woocommerce_thumbnail');
	
	$dimensions = wc_get_image_size( $image_size );
	
	echo '<figure class="'.(($has_back_image)?'has-back-image':'no-back-image').'">';
		if( !$lazy_load ){
			echo woocommerce_get_product_thumbnail( $image_size );
			if( $has_back_image ){
				echo wp_get_attachment_image( $prod_galleries[0], $image_size, 0, array('class' => 'product-image-back') );
			}
		}
		else{
			$front_img_src = '';
			$alt = '';
			if( has_post_thumbnail( $product->get_id() ) ){
				$post_thumbnail_id = get_post_thumbnail_id($product->get_id());
				$image_obj = wp_get_attachment_image_src($post_thumbnail_id, $image_size, 0);
				if( isset($image_obj[0]) ){
					$front_img_src = $image_obj[0];
				}
				$alt = trim(strip_tags( get_post_meta($post_thumbnail_id, '_wp_attachment_image_alt', true) ));
			}
			else if( wc_placeholder_img_src() ){
				$front_img_src = wc_placeholder_img_src();
			}
			
			echo '<img src="'.esc_url($placeholder_img_src).'" data-src="'.esc_url($front_img_src).'" class="attachment-shop_catalog wp-post-image ts-lazy-load" alt="'.esc_attr($alt).'" width="'.$dimensions['width'].'" height="'.$dimensions['height'].'" />';
			
			if( $has_back_image ){
				$back_img_src = '';
				$alt = '';
				$image_obj = wp_get_attachment_image_src($prod_galleries[0], $image_size, 0);
				if( isset($image_obj[0]) ){
					$back_img_src = $image_obj[0];
					$alt = trim(strip_tags( get_post_meta($prod_galleries[0], '_wp_attachment_image_alt', true) ));
				}
				else if( wc_placeholder_img_src() ){
					$back_img_src = wc_placeholder_img_src();
				}
				
				echo '<img src="'.esc_url($placeholder_img_src).'" data-src="'.esc_url($back_img_src).'" class="product-image-back ts-lazy-load" alt="'.esc_attr($alt).'" width="'.$dimensions['width'].'" height="'.$dimensions['height'].'" />';
			}
		}
	echo '</figure>';
}

function gon_template_loop_product_title(){
	global $post, $product;
	$uri = esc_url(get_permalink($post->ID));
	echo "<h3 class=\"heading-title product-name\">";
	echo "<a href='{$uri}'>". esc_html(get_the_title()) ."</a>";
	echo "</h3>";
}

function gon_template_loop_add_to_cart(){
	if( gon_get_theme_options('ts_enable_catalog_mode') ){
		return;
	}
	
	echo "<div class='loop-add-to-cart'>";
	woocommerce_template_loop_add_to_cart();
	echo "</div>";
}

function gon_template_loop_product_sku(){
	global $product, $post;
	echo "<span class=\"product-sku\">" . esc_html($product->get_sku()) . "</span>";
}

function gon_template_loop_short_description(){
	global $product, $post;
	if( empty($post->post_excerpt) ){
		return;
	}
	$theme_options = gon_get_theme_options();
	$has_grid_list = get_option('ts_enable_glt', 'yes') == 'yes';
	$grid_limit_words = absint($theme_options['ts_prod_cat_grid_desc_words']);
	$show_grid_desc = $theme_options['ts_prod_cat_grid_desc'];
	
	if( !(is_tax( get_object_taxonomies( 'product' ) ) || is_post_type_archive('product')) ):
	?>
	<div class="short-description">
		<?php gon_the_excerpt_max_words($grid_limit_words, '', true, '', true); ?>
	</div>
	<?php
	else:
		if( $show_grid_desc ):
		?>
			<div class="short-description grid" style="<?php echo esc_attr($has_grid_list?'display: none':''); ?>" >
				<?php gon_the_excerpt_max_words($grid_limit_words, '', true, '', true); ?>
			</div>
		<?php
		endif;
	endif;
}

function gon_template_loop_short_description_listview(){
	global $product, $post;
	$theme_options = gon_get_theme_options();
	$list_limit_words = absint($theme_options['ts_prod_cat_list_desc_words']);
	$show_list_desc = $theme_options['ts_prod_cat_list_desc'];
	$is_archive = is_tax( get_object_taxonomies( 'product' ) ) || is_post_type_archive('product');
	if( $show_list_desc && $is_archive ):
	?>
		<div class="short-description list" style="display: none" >
			<?php gon_the_excerpt_max_words($list_limit_words, '', true, '', true); ?>
		</div>
	<?php
	endif;
}

if( !function_exists('gon_template_loop_categories') ){
	function gon_template_loop_categories(){
		global $product;
		$categories_label = esc_html__('Categories: ', 'gon');
		echo wc_get_product_category_list($product->get_id(), ', ', '<div class="product-categories"><span>'.$categories_label.'</span>', '</div>');
	}
}

function gon_change_products_per_page_shop(){
    if( is_tax( get_object_taxonomies( 'product' ) ) || is_post_type_archive('product') ){
		$per_page = absint( gon_get_theme_options('ts_prod_cat_per_page') );
        if( $per_page > 0 ){
            return $per_page;
        }
    }
}

function gon_get_empty_rating_html( $rating_html, $rating ){
	if( $rating == 0 ){
		$rating_html  = '<div class="star-rating no-rating">';
		$rating_html .= '<span style="width:0%"></span>';
		$rating_html .= '</div>';
	}
	return $rating_html;
}

function gon_before_output_product_categories(){
	return '<div class="list-categories">';
}

function gon_after_output_product_categories(){
	return '</div>';
}

function gon_shop_top_content_widget_area_button(){
	if( is_active_sidebar('product-category-top-content') && gon_get_theme_options('ts_prod_cat_top_content') ){
	?>
		<div class="prod-cat-show-top-content-button"><a href="#"><?php esc_html_e('Filter', 'gon') ?></a></div>
	<?php
	}
}

/*** End Shop - Category ***/



/*** Single Product ***/

/* Remove hook */
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);


/* Add hook */
add_action('gon_before_product_image', 'gon_template_loop_product_label', 10);
add_action('gon_before_product_image', 'gon_template_single_product_video_button', 20);

add_action('woocommerce_single_product_summary', 'gon_template_single_navigation', 1);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 2);
add_action('woocommerce_single_product_summary', 'gon_template_single_availability', 3);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 5);
add_action('woocommerce_single_product_summary', 'gon_template_single_sku', 6);
add_action('woocommerce_single_product_summary', 'gon_template_single_meta', 60);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 70);

add_action('woocommerce_after_single_product_summary', 'gon_product_ads_banner', 12);

add_action('woocommerce_share', 'gon_template_before_single_social_sharing', 9);
if( function_exists('ts_template_social_sharing') ){
	add_action('woocommerce_share', 'ts_template_social_sharing', 10);
}
add_action('woocommerce_share', 'gon_template_after_single_social_sharing', 11);
if( function_exists('ts_template_loop_time_deals') ){
	add_action('woocommerce_single_product_summary', 'ts_template_loop_time_deals', 20);
}

add_filter('woocommerce_product_description_heading', '__return_empty_string');
add_filter('woocommerce_product_additional_information_heading', '__return_empty_string');

add_filter('woocommerce_output_related_products_args', 'gon_output_related_products_args_filter');

if( !is_admin() ){ /* Fix for WooCommerce Tab Manager plugin */
	add_filter( 'woocommerce_product_tabs', 'gon_product_remove_tabs', 999 );
	add_filter( 'woocommerce_product_tabs', 'gon_add_product_custom_tab', 90 );
}

add_action('wp_ajax_gon_load_product_video', 'gon_load_product_video_callback' );
add_action('wp_ajax_nopriv_gon_load_product_video', 'gon_load_product_video_callback' );
/*** End Product ***/

function gon_template_single_product_video_button(){
	if( wp_is_mobile() ){
		return;
	}
	wp_enqueue_script( 'prettyphoto' );
	global $product;
	$video_url = get_post_meta($product->get_id(), 'ts_prod_video_url', true);
	if( !empty($video_url) ){
		$ajax_url = admin_url('admin-ajax.php', is_ssl()?'https':'http').'?ajax=true&action=gon_load_product_video&product_id='.$product->get_id();
		echo '<a class="ts-product-video-button" href="'.esc_url($ajax_url).'"></a>';
	}
}

/* Single Product Video - Register ajax */
function gon_load_product_video_callback(){
	if( empty($_GET['product_id']) ){
		die( esc_html__('Invalid Products', 'gon') );
	}
	
	$prod_id = absint($_GET['product_id']);

	if( $prod_id <= 0 ){
		die( esc_html__('Invalid Products', 'gon') );
	}
	
	$video_url = get_post_meta($prod_id, 'ts_prod_video_url', true);
	ob_start();
	if( !empty($video_url) ){
		echo do_shortcode('[ts_video src='.esc_url($video_url).']');
	}
	die( ob_get_clean() );
}

function gon_template_single_navigation(){
	if( !gon_get_theme_options('ts_prod_next_prev_navigation') ){
		return;
	}
	$prev_post = get_adjacent_post(false, '', true, 'product_cat');
	$next_post = get_adjacent_post(false, '', false, 'product_cat');
	?>
	<div class="single-navigation">
	<?php 
		if( $prev_post ){
			$post_id = $prev_post->ID;
			$product = wc_get_product($post_id);
			?>
			<a href="<?php echo get_permalink($post_id); ?>" rel="prev">
				<div class="product-info prev-product-info">
					<?php echo wp_kses_post($product->get_image()); ?>
					<div>
						<span><?php echo esc_html($product->get_title()); ?></span>
						<span class="price"><?php echo wp_kses_post($product->get_price_html()); ?></span>
					</div>
				</div>
			</a>
			<?php
		}
		
		if( $next_post ){
			$post_id = $next_post->ID;
			$product = wc_get_product($post_id);
			?>
			<a href="<?php echo get_permalink($post_id); ?>" rel="next">
				<div class="product-info next-product-info">
					<?php echo wp_kses_post($product->get_image()); ?>
					<div>
						<span><?php echo esc_html($product->get_title()); ?></span>
						<span class="price"><?php echo wp_kses_post($product->get_price_html()); ?></span>
					</div>
				</div>
			</a>
			<?php
		}
	?>
	</div>
	<?php
}

function gon_template_before_single_social_sharing(){
	?>
	<div class="social-sharing">
		<div class="print">
			<a href="javascript:window.print()" rel="nofollow"><i class="fa fa-print"></i><?php esc_html_e('Print', 'gon') ?></a>
		</div>
		<div class="email">
			<a href="mailto:?subject=<?php echo esc_attr(sanitize_title(get_the_title())); ?>&amp;body=<?php echo esc_url(get_permalink()); ?>">
				<i class="fa fa-envelope"></i>
				<?php esc_html_e('Email to a Friend', 'gon') ?>
			</a>
		</div>
	<?php
}

function gon_template_after_single_social_sharing(){
	?>
	</div>
	<?php
}

function gon_template_single_meta(){
	global $product, $post;
	$theme_options = gon_get_theme_options();
	
	echo '<div class="meta-wrapper">';
		do_action( 'woocommerce_product_meta_start' );
		if( $theme_options['ts_prod_cat'] ){
			echo wc_get_product_category_list( $product->get_id(), ', ', '<div class="cats-link"><span>' . esc_html__( 'Categories:', 'gon' ) . '</span><span class="cat-links">', '</span></div>' );
		}
		if( $theme_options['ts_prod_tag'] ){
			echo wc_get_product_tag_list( $product->get_id(), ', ', '<div class="tags-link"><span>' . esc_html__( 'Tags:', 'gon' ) . '</span><span class="tag-links">', '</span></div>' );	
		}
		do_action( 'woocommerce_product_meta_end' );
	echo '</div>';
}

function gon_template_single_sku(){
	global $product;
	if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ){
		echo '<div class="sku-wrapper product_meta">' . esc_html__( 'Sku: ', 'gon' ) . '<span class="sku" itemprop="sku">' . (( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'gon' )) . '</span></div>';
	}
}
function gon_template_single_availability(){
	global $product;

	$product_stock = $product->get_availability();
	$availability_text = empty($product_stock['availability'])?__('In Stock', 'gon'):$product_stock['availability'];
	?>	
		<p class="availability stock <?php echo esc_attr($product_stock['class']); ?>" data-original="<?php echo esc_attr($availability_text) ?>" data-class="<?php echo esc_attr($product_stock['class']) ?>"><span><?php echo esc_html($availability_text); ?></span></p>	
	<?php
}


/*** Product tab ***/
function gon_product_remove_tabs( $tabs = array() ){
	if( !gon_get_theme_options('ts_prod_tabs') ){
		return array();
	}
	return $tabs;
}

function gon_add_product_custom_tab( $tabs = array() ){
	global $post;
	$theme_options = gon_get_theme_options();
	
	$custom_tab_title = $theme_options['ts_prod_custom_tab_title'];
	
	$product_custom_tab = get_post_meta( $post->ID, 'ts_prod_custom_tab', true );
	if( $product_custom_tab ){
		$custom_tab_title = get_post_meta( $post->ID, 'ts_prod_custom_tab_title', true );
	}
	
	if( $theme_options['ts_prod_custom_tab'] ){
		$tabs['ts_custom'] = array(
			'title'    	=> esc_html( $custom_tab_title )
			,'priority' => 90
			,'callback' => "gon_product_custom_tab_content"
		);
	} 
	return $tabs;
}

function gon_product_custom_tab_content(){
	global $post;
	
	$custom_tab_content = gon_get_theme_options('ts_prod_custom_tab_content');
	
	$product_custom_tab = get_post_meta( $post->ID, 'ts_prod_custom_tab', true );
	if( $product_custom_tab ){
		$custom_tab_content = get_post_meta( $post->ID, 'ts_prod_custom_tab_content', true );
	}
	
	echo do_shortcode( stripslashes( wp_specialchars_decode( $custom_tab_content ) ) );
}

/* Ads Banner */
function gon_product_ads_banner(){
	$theme_options = gon_get_theme_options();
	
	if( $theme_options['ts_prod_ads_banner'] ){
		$ads_banner_content = $theme_options['ts_prod_ads_banner_content'];
		echo '<div class="ads-banner">';
		echo do_shortcode( stripslashes( wp_specialchars_decode( $ads_banner_content ) ) );
		echo '</div>';
	}
}

/* Related Products */
function gon_output_related_products_args_filter( $args ){
	$args['posts_per_page'] = 6;
	$args['columns'] = 5;
	return $args;
}

/*** General hook ***/

/*************************************************************
* Custom group button on product (quickshop, wishlist, compare) 
* Begin tag: 	10000
* Add To Cart: 	10001
* Wishlist:  	10002
* Compare:   	10003
* Quickshop: 	10004
* End tag:   	10005
**************************************************************/
add_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_add_to_cart', 10001 );
function gon_product_group_button_start(){
	$theme_options = gon_get_theme_options();
	$num_icon = 0;
	
	if( $theme_options['ts_effect_hover_product_style'] != 'style-3' ){
		if( has_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_add_to_cart') && !$theme_options['ts_enable_catalog_mode'] && apply_filters('ts_display_add_to_cart_button_on_thumbnail', true) ){
			$num_icon++;
		}
	}
	else{
		remove_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_add_to_cart', 10001 );
	}
	if( $theme_options['ts_enable_quickshop'] ){
		$num_icon++;
	}
	if( class_exists('TS_Wishlist') && TS_WISHLIST()->enable_wishlist('loop') ){
		$num_icon++;
	}
	if( class_exists('TS_Compare') && TS_COMPARE()->enable_compare('loop') ){
		$num_icon++;
	}
	
	$classes = array(0 => '', 1 => 'one-button', 2 => 'two-button', 3 => 'three-button', 4 => 'four-button');
	
	echo "<div class=\"product-group-button {$classes[$num_icon]}\" >";
}

function gon_product_group_button_end(){
	echo "</div>";
}

add_action('woocommerce_after_shop_loop_item_title', 'gon_product_group_button_start', 10000 );
add_action('woocommerce_after_shop_loop_item_title', 'gon_product_group_button_end', 10005 );

/*** End General hook ***/

/*** Cart - Checkout hooks ***/
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display', 10 );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display', 10 );

add_action('woocommerce_proceed_to_checkout', 'gon_cart_continue_shopping_button', 20);

add_action('woocommerce_before_checkout_form', 'gon_before_checkout_form_start', 1);
add_action('woocommerce_before_checkout_form', 'gon_before_checkout_form_end', 999);

/* Continue Shopping button */
function gon_cart_continue_shopping_button(){
	echo '<a href="'.esc_url(wc_get_page_permalink('shop')).'" class="button button-secondary">'.esc_html__('Continue Shopping', 'gon').'</a>';
}

function gon_before_checkout_form_start(){
	echo '<div class="checkout-login-coupon-wrapper">';
}
function gon_before_checkout_form_end(){
	echo '</div>';
}
?>