<?php 
/*** Activate Theme ***/
function gon_theme_activation(){
	global $pagenow;
	if( is_admin() && 'themes.php' == $pagenow && isset($_GET['activated']) )
	{
		if( get_option( 'woocommerce_single_image_width' ) === false ){
			/* Single Image */
			update_option( 'woocommerce_single_image_width', 550 );
			
			/* Thumbnail Image */
			update_option('woocommerce_thumbnail_image_width', 330);
			update_option('woocommerce_thumbnail_cropping', 'custom');
			update_option('woocommerce_thumbnail_cropping_custom_width', 330);
			update_option('woocommerce_thumbnail_cropping_custom_height', 402);
		}
	}
}
add_action('admin_init','gon_theme_activation');

/*** Theme Setup ***/
function gon_theme_setup(){
	/* Add editor-style.css file*/
	add_editor_style();
	
	/* Add Theme Support */
	add_theme_support( 'post-formats', array( 'audio', 'gallery', 'quote', 'video' ) );		
	
	add_theme_support( 'post-thumbnails' );
	
	add_theme_support( 'automatic-feed-links' );
	
	add_theme_support( 'title-tag' );
	
	$defaults = array(
		'default-color'         => ''
		,'default-image'        => ''
	);
	add_theme_support( 'custom-background', $defaults );
	
	add_theme_support( 'woocommerce' );
	
	remove_theme_support( 'widgets-block-editor' );
	
	if( !gon_get_theme_options('ts_prod_cloudzoom') ){
		add_theme_support( 'wc-product-gallery-lightbox' );
	}
	
	if ( ! isset( $content_width ) ){ $content_width = 1200; }
	
	/* Translation */
	load_theme_textdomain( 'gon', get_template_directory() . '/languages' );
	
	/* Register Menu Location */
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary Navigation', 'gon' ),
	) );
	register_nav_menus( array(
		'vertical' => esc_html__( 'Vertical Navigation', 'gon' ),
	) );
	register_nav_menus( array(
		'mobile' => esc_html__( 'Mobile Navigation', 'gon' ),
	) );
}
add_action( 'after_setup_theme', 'gon_theme_setup');


/*** Add Image Size ***/
function gon_add_image_size(){
	$menu_icon_width = (int)gon_get_theme_options('ts_menu_thumb_width');
	$menu_icon_height = (int)gon_get_theme_options('ts_menu_thumb_height');
	add_image_size('ts_menu_icon_thumb', $menu_icon_width, $menu_icon_height, true);
	
	add_image_size('ts_blog_shortcode_thumb', 590, 352, true);
	add_image_size('ts_blog_thumb', 1180, 704, true);
	add_image_size('ts_product_cat_thumb', 500, 970, true);
	
	$product_deal_thumb_width = 400;
	$product_deal_thumb_height = 486;
	if( function_exists('wc_get_image_size') ){
		$woocommerce_thumbnail = wc_get_image_size( 'woocommerce_thumbnail' );
		$product_deal_thumb_width = absint( $woocommerce_thumbnail['width'] * 1.21 );
		if( $woocommerce_thumbnail['height'] != '' ){
			$product_deal_thumb_height = absint( $woocommerce_thumbnail['height'] * 1.21 );
		}
		else{
			$product_deal_thumb_height = 0;
		}
	}
	
	add_image_size('ts_product_deal_thumb', $product_deal_thumb_width, $product_deal_thumb_height, true);
}
add_action('init', 'gon_add_image_size');

/*** Register google font ***/
function gon_register_google_font(){				
	$theme_options = gon_get_theme_options();
	$fonts = array();
	
	if( $theme_options['ts_body_font_enable_google_font'] ){
		$fonts[] = array(
					'name'	=> $theme_options['ts_body_font_google']	
					,'bold'	=> '300,400,500,600,700,800,900'
				);
	}
	
	if( $theme_options['ts_secondary_body_font_enable_google_font'] ){
		$fonts[] = array(
					'name'	=> $theme_options['ts_secondary_body_font_google']	
					,'bold'	=> '300,400,500,600,700,800,900'
				);
	}
	
	if( $theme_options['ts_menu_font_enable_google_font'] ){
		$fonts[] = array(
					'name'	=> $theme_options['ts_menu_font_google']	
					,'bold'	=> '300,400,500,600,700,800,900'
				);
	}
	
	if( $theme_options['ts_sub_menu_font_enable_google_font'] ){
		$fonts[] = array(
					'name'	=> $theme_options['ts_sub_menu_font_google']	
					,'bold'	=> '300,400,500,600,700,800,900'
				);
	}
	
	foreach( $fonts as $font ){
		gon_load_google_font( $font['name'], $font['bold'] );
	}
}

function gon_load_google_font( $font_name = '', $font_bold = '300,400,500,600,700,800,900' ){
	if( strlen($font_name) > 0 ){
		$font_name_id = sanitize_title( $font_name );
		
		$font_url = add_query_arg( 'family', urlencode( $font_name . ':' . $font_bold . '&subset=latin,latin-ext' ), '//fonts.googleapis.com/css');
		wp_enqueue_style( "google-font-{$font_name_id}", $font_url );		
	}
}

function gon_get_theme_version(){
	$theme = wp_get_theme();
	if( $theme->parent() ){
		return $theme->parent()->get('Version');
	}
	else{
		return $theme->get('Version');
	}
}

/*** Register Front End Scripts  ***/
function gon_register_scripts(){
	$theme_options = gon_get_theme_options();
	$theme_version = gon_get_theme_version();
	$page_options = gon_get_page_options();
	gon_register_google_font();
	
	wp_deregister_style( 'font-awesome' ); /* Prevent loading version 5 */
	
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), $theme_version );
	
	wp_enqueue_style( 'ts-reset', get_template_directory_uri() . '/css/reset.css', array(), $theme_version ); /* Cant change ts to gon because of the child theme of customer */
	
	wp_enqueue_style( 'ts-style', get_stylesheet_uri(), array(), $theme_version ); /* Cant change ts to gon because of the child theme of customer */
	
	if( !empty($theme_options['ts_responsive']) ){
		wp_enqueue_style( 'gon-responsive', get_template_directory_uri() . '/css/responsive.css', array(), $theme_version );
	}
	
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), $theme_version );
	
	wp_enqueue_style( 'prettyPhoto', get_template_directory_uri() . '/css/prettyPhoto.css', array(), $theme_version );
	
	wp_enqueue_style( 'select2', get_template_directory_uri() . '/css/select2.css', array(), $theme_version );
	
	if( isset($page_options['ts_full_page']) && $page_options['ts_full_page'] ){
		wp_enqueue_style( 'fullPage', get_template_directory_uri() . '/css/jquery.fullPage.css', array(), $theme_version );
	}
	
	if( $theme_options['ts_enable_rtl'] ){
		wp_enqueue_style( 'gon-rtl', get_template_directory_uri() . '/css/rtl.css', array(), $theme_version );
	}
	
	wp_enqueue_script( 'wc-cart-fragments' );
	
	wp_enqueue_script( 'jquery-throttle-debounce', get_template_directory_uri() . '/js/jquery.throttle-debounce.min.js', array('jquery'), $theme_version, true );
	
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri().'/js/owl.carousel.min.js', array(), $theme_version, true);
	
	wp_register_script( 'prettyphoto', get_template_directory_uri() . '/js/jquery.prettyPhoto.js', array(), $theme_version, true );
	
	wp_enqueue_script( 'gon-script', get_template_directory_uri().'/js/main.js', array('jquery'), $theme_version, true);
	
	if( defined('ICL_LANGUAGE_CODE') ){
		$ajax_url = admin_url('admin-ajax.php?lang='.ICL_LANGUAGE_CODE, 'relative');
	}
	else{
		$ajax_url = admin_url('admin-ajax.php', 'relative');
	}
	
	$script_params = array(
		'ajax_url'			=> $ajax_url
		,'sticky_header'	=> (int)( !wp_is_mobile() && !empty($theme_options['ts_enable_sticky_header']) )
		,'responsive'		=> isset($theme_options['ts_responsive'])?(int)$theme_options['ts_responsive']:1
		,'ajax_search'		=> isset($theme_options['ts_ajax_search'])?(int)$theme_options['ts_ajax_search']:1
		,'search_nonce'		=> wp_create_nonce( 'gon-search-nonce' )
	);
	
	wp_localize_script( 'gon-script', 'gon_params', $script_params );
	
	$is_full_page = false;
	if( isset($page_options['ts_full_page']) && $page_options['ts_full_page'] ){
		$is_full_page = true;
	}
	
	if( $theme_options['ts_smooth_scroll'] && !wp_is_mobile() && !$is_full_page ){
		wp_enqueue_script( 'smooth-scroll', get_template_directory_uri() . '/js/SmoothScroll.min.js', array(), $theme_version, true );
	}
	
	if( $script_params['sticky_header'] ){
		wp_enqueue_script( 'jquery-sticky', get_template_directory_uri() . '/js/jquery.sticky.js', array(), $theme_version, true );
	}
	
	if( $is_full_page ){
		wp_enqueue_script( 'fullPage', get_template_directory_uri().'/js/jquery.fullPage.min.js', array(), $theme_version, true);
	}
	
	if( is_singular('product') && $theme_options['ts_prod_cloudzoom'] ){
		wp_enqueue_script( 'cloud-zoom', get_template_directory_uri().'/js/cloud-zoom.js', array('jquery'), $theme_version, true);
	}
	
	if( is_singular('product') && $theme_options['ts_prod_thumbnails_style'] == 'vertical' ){
		wp_enqueue_script( 'jquery-caroufredsel', get_template_directory_uri().'/js/jquery.carouFredSel-6.2.1.min.js', array(), $theme_version, true);
	}
	
	wp_enqueue_script( 'select2', get_template_directory_uri().'/js/select2.min.js', array(), $theme_version, true);
	
	wp_register_script( 'jquery-mb-ytplayer', get_template_directory_uri() . '/js/jquery.mb.YTPlayer.min.js', array(), $theme_version, true );
	
	if( is_single() && get_option( 'thread_comments' ) ){ 	
		wp_enqueue_script( 'comment-reply' );
	}
	
	/* Custom JS */
	if( $custom_js = $theme_options['ts_custom_javascript_code'] ){
		wp_add_inline_script( 'gon-script', stripslashes( trim( $custom_js ) ) );
	}
}
add_action('wp_enqueue_scripts', 'gon_register_scripts', 1000);

function gon_register_custom_style(){
	$upload_dir = wp_get_upload_dir();
	$theme_name = strtolower(str_replace(' ', '', wp_get_theme()->get('Name')));
	$filename = trailingslashit($upload_dir['baseurl']) . $theme_name . '.css';
	$filename_dir = trailingslashit($upload_dir['basedir']) . $theme_name . '.css';

	if( file_exists( $filename_dir ) ){ 
		wp_enqueue_style('gon-dynamic-css', $filename, array(), get_option('gon_of_last_updated_time'));
	}
	else{
		ob_start();
		include_once get_template_directory() . '/framework/dynamic_style.php';
		$dynamic_css = ob_get_contents();
		ob_end_clean();
		wp_add_inline_style( 'ts-style', $dynamic_css );
	}
}
add_action('wp_enqueue_scripts', 'gon_register_custom_style', 9999);

/*** Register Back End Scripts ***/
function gon_register_admin_scripts(){
	$theme_version = gon_get_theme_version();
	wp_enqueue_media();
	
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), $theme_version );
	
	wp_enqueue_style( 'gon-admin-style', get_template_directory_uri() . '/css/admin_style.css', array(), $theme_version );
	
	wp_enqueue_script( 'gon-admin-script', get_template_directory_uri() . '/js/admin_main.js', array('jquery'), $theme_version, true );
}
add_action('admin_enqueue_scripts', 'gon_register_admin_scripts');
	
/*** Array Attribute Compare ***/
if( !function_exists ('gon_array_atts') ){
	function gon_array_atts($pairs, $atts) {
		$atts = (array)$atts;
		$out = array();
		foreach($pairs as $name => $default) {
			if ( array_key_exists($name, $atts) ){
				if( is_array($atts[$name]) && is_array($default) ){
					$out[$name] = gon_array_atts($default,$atts[$name]);
				}
				else{
					$out[$name] = $atts[$name];
				}
			}
			else{
				$out[$name] = $default;
			}	
		}
		return $out;
	}
}

/*** Global Page Options ***/
if( !function_exists('gon_set_global_page_options') ){
	function gon_set_global_page_options( $page_id = 0 ){
		global $ts_page_datas;
		$post_custom = get_post_custom( $page_id );
		if( !is_array($post_custom) ){
			$post_custom = array();
		}
		foreach( $post_custom as $key => $value ){
			if( isset($value[0]) ){
				$ts_page_datas[$key] = $value[0];
			}
		}
		
		$default_options = array(
							'ts_layout_style'				=> 'default'
							,'ts_page_layout'				=> '0-1-0'
							,'ts_left_sidebar'				=> ''
							,'ts_right_sidebar'				=> ''
							,'ts_left_right_padding'		=> 0
							,'ts_full_page'					=> 0
							,'ts_header_layout'				=> 'default'
							,'ts_header_transparent'		=> 0
							,'ts_header_text_color'			=> 'default'
							,'ts_menu_id'					=> 0
							,'ts_breadcrumb_layout'			=> 'default'
							,'ts_breadcrumb_bg_parallax'	=> 'default'
							,'ts_bg_breadcrumbs'			=> ''
							,'ts_logo'						=> ''
							,'ts_logo_mobile'				=> ''
							,'ts_logo_sticky'				=> ''
							,'ts_show_breadcrumb'			=> 1
							,'ts_show_page_title'			=> 1
							,'ts_page_slider'				=> 0
							,'ts_page_slider_position'		=> 'before_main_content'
							,'ts_rev_slider'				=> 0
							);
		$ts_page_datas = array_merge($default_options, (array) $ts_page_datas);
		return $ts_page_datas;
	}
}

if( !function_exists('gon_get_page_options') ){
	function gon_get_page_options( $key = '', $default = '' ){
		global $ts_page_datas;
		if( !$key ){
			return $ts_page_datas;
		} else if( isset($ts_page_datas[$key]) ){
			return $ts_page_datas[$key];
		}
		return $default;
	}
}

/*** Vertical Menu Heading ***/
if( !function_exists('gon_get_vertical_menu_heading') ){
	function gon_get_vertical_menu_heading(){
		$locations = get_nav_menu_locations();
		if( isset($locations['vertical']) ){
			$menu = wp_get_nav_menu_object($locations['vertical']);
			if( isset( $menu->name ) ){
				return $menu->name;
			}
			else{
				return esc_html__('Shop by category', 'gon');
			}
		}
		return '';
	}
}

/*** Get excerpt ***/
if( !function_exists('gon_string_limit_words') ){
	function gon_string_limit_words($string, $word_limit){
		$words = explode(' ', $string, ($word_limit + 1));
		if( count($words) > $word_limit ){
			array_pop($words);
		}
		return implode(' ', $words);
	}
}

if( !function_exists('gon_the_excerpt_max_words') ){
	function gon_the_excerpt_max_words( $word_limit = -1, $post = '', $strip_tags = true, $extra_str = '', $echo = true ) {
		if( $post ){
			$excerpt = gon_get_the_excerpt_by_id($post->ID);
		}
		else{
			$excerpt = get_the_excerpt();
		}
			
		if( $strip_tags ){
			$excerpt = wp_strip_all_tags($excerpt);
			$excerpt = strip_shortcodes($excerpt);
		}
			
		if( $word_limit != -1 )
			$result = gon_string_limit_words($excerpt, $word_limit);
		else
			$result = $excerpt;
		
		$result .= $extra_str;
			
		if( $echo ){
			echo do_shortcode($result);
		}
		return $result;
	}
}

if( !function_exists('gon_get_the_excerpt_by_id') ){
	function gon_get_the_excerpt_by_id( $post_id = 0 )
	{
		global $wpdb;
		$query = "SELECT post_excerpt, post_content FROM $wpdb->posts WHERE ID = %d LIMIT 1";
		$result = $wpdb->get_results( $wpdb->prepare($query, $post_id), ARRAY_A );
		if( $result[0]['post_excerpt'] ){
			return $result[0]['post_excerpt'];
		}
		else{
			return $result[0]['post_content'];
		}
	}
}

/* Get User Role */
if( !function_exists('gon_get_user_role') ){
	function gon_get_user_role( $user_id ){
		global $wpdb;
		$user = get_userdata( $user_id );
		$capabilities = $user->{$wpdb->prefix . 'capabilities'};
		if( empty($capabilities) ){
			return '';
		}
		if ( !isset( $wp_roles ) ){
			$wp_roles = new WP_Roles();
		}
		foreach ( $wp_roles->role_names as $role => $name ) {
			if ( array_key_exists( $role, $capabilities ) ) {
				return $role;
			}
		}
		return '';
	}
}

/*** Page Layout Columns Class ***/
if( !function_exists('gon_page_layout_columns_class') ){
	function gon_page_layout_columns_class($page_column){
		$data = array();
		
		if( empty($page_column) ){
			$page_column = '0-1-0';
		}
		
		$layout_config = explode('-', $page_column);
		$left_sidebar = (int)$layout_config[0];
		$right_sidebar = (int)$layout_config[2];
		$main_class = ($left_sidebar + $right_sidebar) == 2 ?'ts-col-12':( ($left_sidebar + $right_sidebar) == 1 ?'ts-col-18':'ts-col-24' );			
		
		$data['left_sidebar'] = $left_sidebar;
		$data['right_sidebar'] = $right_sidebar;
		$data['main_class'] = $main_class;
		$data['left_sidebar_class'] = 'ts-col-6';
		$data['right_sidebar_class'] = 'ts-col-6';
		
		return $data;
	}
}

/*** Show Page Slider ***/
function gon_show_page_slider(){
	$page_options = gon_get_page_options();
	switch( $page_options['ts_page_slider'] ){
		case 'revslider':
			$selected_slider = $page_options['ts_rev_slider'];
			if( class_exists('RevSliderSlider') && $selected_slider ){
				if( !defined('RS_REVISION') ){ /* RS < 6 */
					if( is_numeric($selected_slider) ){
						$rev_db = new RevSliderDB();
						$response = $rev_db->fetch(RevSliderGlobals::$table_sliders, 'id='.$selected_slider);
						if( !empty($response) ){
							RevSliderOutput::putSlider($selected_slider, '');
						}
					}
					else{
						echo do_shortcode('[rev_slider alias="'.$selected_slider.'"][/rev_slider]');
					}
				}
				else{
					if( is_numeric($selected_slider) ){
						$slider = new RevSliderSlider();
						$sliders = $slider->get_sliders();
						$list_ids = wp_list_pluck($sliders, 'id');
						$list_alias = wp_list_pluck($sliders, 'alias');
						$key = array_search($selected_slider, $list_ids);
						if( $key !== false ){
							echo do_shortcode('[rev_slider alias="'.$list_alias[$key].'"][/rev_slider]');
						}
					}
					else{
						echo do_shortcode('[rev_slider alias="'.$selected_slider.'"][/rev_slider]');
					}
				}
			}
		break;
		default:
		break;
	}
}

/*** Breadcrumbs ***/
if( !function_exists('gon_breadcrumbs') ){
	function gon_breadcrumbs(){
		$is_rtl = is_rtl() || gon_get_theme_options('ts_enable_rtl');
		
		if( class_exists('WooCommerce') ){
			if( function_exists('woocommerce_breadcrumb') && function_exists('is_woocommerce') && is_woocommerce() ){
				woocommerce_breadcrumb(array('wrap_before'=>'<div class="breadcrumbs"><div class="breadcrumbs-container">','delimiter'=>'<span>'.($is_rtl?'\\':'/').'</span>','wrap_after'=>'</div></div>'));
				return;
			}
		}
		
		$allowed_html = array(
			'a'		=> array('href' => array(), 'title' => array())
			,'span'	=> array('class' => array())
			,'div'	=> array('class' => array())
		);
		$output = '';
 
		$delimiter = '<span class="brn_arrow">'.($is_rtl?'\\':'/').'</span>';
	  
		$front_id = get_option( 'page_on_front' );
		if ( !empty( $front_id ) ) {
			$home = get_the_title( $front_id );
		} else {
			$home = esc_html__( 'Home', 'gon' );
		}
		$ar_title = array(
					'search' 		=> esc_html__('Search results for ', 'gon')
					,'404' 			=> esc_html__('Error 404', 'gon')
					,'tagged' 		=> esc_html__('Tagged ', 'gon')
					,'author' 		=> esc_html__('Articles posted by ', 'gon')
					,'page' 		=> esc_html__('Page', 'gon')
					,'portfolio' 	=> esc_html__('Portfolio', 'gon')
					);
	  
		$before = '<span class="current">'; /* tag before the current crumb */
		$after = '</span>'; /* tag after the current crumb */
		global $wp_rewrite;
		$rewriteUrl = $wp_rewrite->using_permalinks();
		if ( !is_home() && !is_front_page() || is_paged() ) {
	 
			$output .= '<div class="breadcrumbs"><div class="breadcrumbs-container">';
	 
			global $post;
			$homeLink = esc_url( home_url('/') ); 
			$output .= '<a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . ' ';
	 
			if ( is_category() ) {
				global $wp_query;
				$cat_obj = $wp_query->get_queried_object();
				$thisCat = $cat_obj->term_id;
				$thisCat = get_category($thisCat);
				$parentCat = get_category($thisCat->parent);
				if ( $thisCat->parent != 0 ) { 
					$output .= get_category_parents($parentCat, true, ' ' . $delimiter . ' '); 
				}
				$output .= $before . single_cat_title('', false) . $after;
		 
			}
			elseif ( is_search() ) {
				$output .= $before . $ar_title['search'] . '"' . get_search_query() . '"' . $after;
		 
			}elseif ( is_day() ) {
				$output .= '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
				$output .= '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
				$output .= $before . get_the_time('d') . $after;
		 
			}elseif ( is_month() ) {
				$output .= '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
				$output .= $before . get_the_time('F') . $after;
		 
			}elseif ( is_year() ) {
				$output .= $before . get_the_time('Y') . $after;
		 
			}elseif ( is_single() && !is_attachment() ) {
				if ( get_post_type() != 'post' ) {
					$post_type = get_post_type_object(get_post_type());
					$slug = $post_type->rewrite;
					$post_type_name = $post_type->labels->singular_name;
				if( strcmp('Portfolio Item', $post_type->labels->singular_name) == 0 ){
					$post_type_name = $ar_title['portfolio'];
				}
				if( $rewriteUrl ){
					$output .= '<a href="' . $homeLink . $slug['slug'] . '/">' . $post_type_name . '</a> ' . $delimiter . ' ';
				}else{
					$output .= '<a href="' . $homeLink . '?post_type=' . get_post_type() . '">' . $post_type_name . '</a> ' . $delimiter . ' ';
				}
				
				$output .= $before . get_the_title() . $after;
			    } else {
					$cat = get_the_category(); $cat = $cat[0];
					$output .= get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
					$output .= $before . get_the_title() . $after;
			    }
		 
			}elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
				$post_type = get_post_type_object(get_post_type());
				$slug = $post_type->rewrite;
				$post_type_name = $post_type->labels->singular_name;
			    if( strcmp('Portfolio Item', $post_type->labels->singular_name) == 0 ){
					$post_type_name = $ar_title['portfolio'];
			    }
				if ( is_tag() ) {
					$output .= $before . $ar_title['tagged'] . '"' . single_tag_title('', false) . '"' . $after;
				}
				elseif( is_taxonomy_hierarchical(get_query_var('taxonomy')) ){
					if($rewriteUrl){
						$output .= '<a href="' . $homeLink . $slug['slug'] . '/">' . $post_type_name . '</a> ' . $delimiter . ' ';
					}else{
						$output .= '<a href="' . $homeLink . '?post_type=' . get_post_type() . '">' . $post_type_name . '</a> ' . $delimiter . ' ';
					}			
					
					$curTaxanomy = get_query_var('taxonomy');
					$curTerm = get_query_var( 'term' );
					$termNow = get_term_by( 'name', $curTerm, $curTaxanomy );
					$pushPrintArr = array();
					if( $termNow !== false ){
						while ((int)$termNow->parent != 0){
							$parentTerm = get_term((int)$termNow->parent,get_query_var('taxonomy'));
							array_push($pushPrintArr,'<a href="' . get_term_link((int)$parentTerm->term_id,$curTaxanomy) . '">' . $parentTerm->name . '</a> ' . $delimiter . ' ');
							$curTerm = $parentTerm->name;
							$termNow = get_term_by( 'name', $curTerm, $curTaxanomy );
						}
					}
					$pushPrintArr = array_reverse($pushPrintArr);
					array_push($pushPrintArr,$before  . get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) )->name  . $after);
					$output .= implode($pushPrintArr);
				}else{
					$output .= $before . $post_type_name . $after;
				}
		 
			}elseif( is_attachment() ) {
				if( (int)$post->post_parent > 0 ){
					$parent = get_post($post->post_parent);
					$cat = get_the_category($parent->ID);
					if( count($cat) > 0 ){
						$cat = $cat[0];
						$output .= get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
					}
					$output .= '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a> ' . $delimiter . ' ';
				}
				$output .= $before . get_the_title() . $after;
			} elseif ( is_page() && !$post->post_parent ) {
				$output .= $before . get_the_title() . $after;
		 
			} elseif ( is_page() && $post->post_parent ) {
				$parent_id  = $post->post_parent;
				$breadcrumbs = array();
				while ($parent_id) {
					$page = get_post($parent_id);
					$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
					$parent_id  = $page->post_parent;
			    }
				$breadcrumbs = array_reverse($breadcrumbs);
				foreach( $breadcrumbs as $crumb ){
					$output .= $crumb . ' ' . $delimiter . ' ';
				}
				$output .= $before . get_the_title() . $after;
		 
			} elseif ( is_tag() ) {
				$output .= $before . $ar_title['tagged'] . '"' . single_tag_title('', false) . '"' . $after;
		 
			} elseif ( is_author() ) {
				global $author;
				$userdata = get_userdata($author);
				$output .= $before . $ar_title['author'] . $userdata->display_name . $after;
		 
			} elseif ( is_404() ) {
				$output .= $before . $ar_title['404'] . $after;
			}
		 
			if ( get_query_var('paged') ) {
				if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() || is_page_template() ||  is_post_type_archive() || is_archive() ){ 
					$output .= $before .' ('; 
				}
				$output .= $ar_title['page'] . ' ' . get_query_var('paged');
				if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() || is_page_template() ||  is_post_type_archive() || is_archive() ){ 
					$output .= ')'. $after; 
				}
			}
			else{ 
				if ( get_query_var('page') ) {
					if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() || is_page_template() ||  is_post_type_archive() || is_archive() ){ 
						$output .= $before .' ('; 
					}
					$output .= $ar_title['page'] . ' ' . get_query_var('page');
					if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() || is_page_template() ||  is_post_type_archive() || is_archive() ){ 
						$output .= ')'. $after; 
					}
				}
			}
			$output .= '</div></div>';
	 
	    }
		
		echo wp_kses($output, $allowed_html);
		
		wp_reset_postdata();
	}
}

function gon_breadcrumbs_title( $show_breadcrumb = false, $show_page_title = false, $page_title = '', $extra_class_title = '' ){
	$theme_options = gon_get_theme_options();
	if( $show_breadcrumb || $show_page_title ){
		$breadcrumb_bg = '';
		$extra_class = 'breadcrumb-' . $theme_options['ts_breadcrumb_layout'];
		if( $theme_options['ts_enable_breadcrumb_background_image'] && $theme_options['ts_breadcrumb_layout'] != 'v3' ){
			if( $theme_options['ts_bg_breadcrumbs'] == '' ){ /* No Override */
				$breadcrumb_bg = get_template_directory_uri() . '/images/bg_breadcrumb_'.$theme_options['ts_breadcrumb_layout'].'.jpg';
			}	
			else{
				$breadcrumb_bg = esc_url( $theme_options['ts_bg_breadcrumbs'] );
			}
		}
		
		$style = '';
		if( $breadcrumb_bg != '' ){
			$style = 'style="background-image: url('. $breadcrumb_bg .')"';
			if( isset($theme_options['ts_breadcrumb_bg_parallax']) && $theme_options['ts_breadcrumb_bg_parallax'] ){
				$extra_class .= ' ts-breadcrumb-parallax';
			}
		}
		echo '<div class="breadcrumb-title-wrapper '.$extra_class.'" '.$style.'><div class="breadcrumb-content"><div class="breadcrumb-title">';
			if( $show_page_title ){
				echo '<h1 itemprop="name" class="heading-title page-title entry-title '.$extra_class_title.'">'.$page_title.'</h1>';
			}
			if( $show_breadcrumb ){
				gon_breadcrumbs();
			}
		echo '</div></div></div>';
	}
}

/*** Pagination ***/
if( !function_exists('gon_pagination') ){
	function gon_pagination( $query = null ){
		global $wp_query;
		$max_num_pages = $wp_query->max_num_pages;
		$paged = $wp_query->get( 'paged' );
		if( $query != null ){
			$max_num_pages = $query->max_num_pages;
			$paged = $query->get( 'paged' );
		}
		if( !$paged ){
			$paged = 1;
		}
		?>
		<nav class="ts-pagination">
			<?php
			echo paginate_links( array(
				'base'         	=> esc_url_raw( str_replace( 999999999, '%#%', get_pagenum_link( 999999999, false ) ) )
				,'format'       => ''
				,'add_args'     => ''
				,'current'      => max( 1, $paged )
				,'total'        => $max_num_pages
				,'prev_text'    => '&larr;'
				,'next_text'    => '&rarr;'
				,'type'         => 'list'
				,'end_size'     => 3
				,'mid_size'     => 3
			) );
			?>
		</nav>
		<?php
	}
}

/*** Logo ***/
if( !function_exists('gon_theme_logo') ){
	function gon_theme_logo(){
		$theme_options = gon_get_theme_options();
		$logo_image = isset($theme_options['ts_logo'])?$theme_options['ts_logo']:'';
		$logo_image_mobile = isset($theme_options['ts_logo_mobile'])?$theme_options['ts_logo_mobile']:'';
		$logo_image_sticky = isset($theme_options['ts_logo_sticky'])?$theme_options['ts_logo_sticky']:'';
		$logo_text = isset($theme_options['ts_text_logo'])?stripslashes($theme_options['ts_text_logo']):'';
		
		if( !$logo_image_sticky ){
			$logo_image_sticky = $logo_image;
		}
		if( !$logo_image_mobile ){
			$logo_image_mobile = $logo_image;
		}
		if( !$logo_text ){
			$logo_text = get_bloginfo('name');
		}
		?>
		<div class="logo">
			<a href="<?php echo esc_url( home_url('/') ); ?>">
			<!-- Main logo -->
			<?php if( $logo_image ): ?>
				<img src="<?php echo esc_url($logo_image); ?>" alt="<?php echo esc_attr($logo_text); ?>" title="<?php echo esc_attr($logo_text); ?>" class="normal-logo" />
			<?php endif; ?>
			
			<!-- Mobile logo -->
			<?php if( $logo_image_mobile ): ?>
				<img src="<?php echo esc_url($logo_image_mobile); ?>" alt="<?php echo esc_attr($logo_text); ?>" title="<?php echo esc_attr($logo_text); ?>" class="normal-logo mobile-logo" />
			<?php endif; ?>
			
			<!-- Sticky logo -->
			<?php if( $logo_image_sticky ): ?>
				<img src="<?php echo esc_url($logo_image_sticky); ?>" alt="<?php echo esc_attr($logo_text); ?>" title="<?php echo esc_attr($logo_text); ?>" class="normal-logo sticky-logo" />
			<?php endif; ?>
			
			<!-- Logo Text -->
			<?php 
			if( !$logo_image ){
				echo esc_html($logo_text); 
			}
			?>
			</a>
		</div>
		<?php
	}
}

/*** Pingback URL ***/
add_action('wp_head', 'gon_pingback_header');
if( !function_exists('gon_pingback_header') ){
	function gon_pingback_header(){
		if( is_singular() && pings_open() ){
		?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
		<?php
		}
	}
}

/*** Favicon ***/
if( !function_exists('gon_theme_favicon') ){
	function gon_theme_favicon(){
		if( has_site_icon() ){
			return;
		}
		$favicon = gon_get_theme_options('ts_favicon');
		if( $favicon ):
		?>
			<link rel="shortcut icon" href="<?php echo esc_url($favicon); ?>" />
		<?php
		endif;
	}
}

/*** Save Of Options - Save Dynamic css ***/
add_action('gon_of_save_options_after', 'gon_update_dynamic_css', 10000);
if( !function_exists('gon_update_dynamic_css') ){
	function gon_update_dynamic_css( $data = array() ){
		
		if( !is_array($data) ){
			return -1;
		}
		if(is_array($data['data'])){
			$data = $data['data'];	
		}
		else{
			return -1;
		}
	
		$upload_dir = wp_get_upload_dir();
		$filename_dir = trailingslashit($upload_dir['basedir']) . strtolower(str_replace(' ', '', wp_get_theme()->get('Name'))) . '.css';
		ob_start();
		include get_template_directory() . '/framework/dynamic_style.php';
		$dynamic_css = ob_get_contents();
		ob_end_clean();
		
		global $wp_filesystem;
		if( empty( $wp_filesystem ) ) {
			require_once( ABSPATH .'/wp-admin/includes/file.php' );
			WP_Filesystem();
		}
		
		$creds = request_filesystem_credentials($filename_dir, '', false, false, array());
		if( ! WP_Filesystem($creds) ){
			return false;
		}

		if( $wp_filesystem ) {
			$wp_filesystem->put_contents(
				$filename_dir,
				$dynamic_css,
				FS_CHMOD_FILE
			);
		}
	}
}

/*** Product Search Form by Category ***/
if( !function_exists('gon_get_search_form_by_category') ){
	function gon_get_search_form_by_category(){
		$search_for_product = class_exists('WooCommerce');
		if( $search_for_product ){
			$taxonomy = 'product_cat';
			$post_type = 'product';
			$placeholder_text = __('Search for products', 'gon');
		}
		else{
			$taxonomy = 'category';
			$post_type = 'post';
			$placeholder_text = __('Search', 'gon');
		}
		
		$rand = mt_rand(0, 1000);
		?>
		<div class="ts-search-by-category">
			<form method="get" id="searchform<?php echo esc_attr($rand); ?>" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				<select class="select-category" name="term"><?php echo gon_search_by_category_get_option_html($taxonomy, 0, 0); ?></select>
				<div class="search-content">
					<input type="text" value="<?php echo esc_attr(get_search_query()); ?>" name="s" id="s<?php echo esc_attr($rand); ?>" placeholder="<?php echo esc_attr($placeholder_text); ?>" autocomplete="off" />
					<input type="submit" title="<?php esc_attr_e( 'Search', 'gon' ); ?>" id="searchsubmit<?php echo esc_attr($rand); ?>" value="<?php esc_attr_e( 'Search', 'gon' ); ?>" />
					<input type="hidden" name="post_type" value="<?php echo esc_attr($post_type); ?>" />
					<input type="hidden" name="taxonomy" value="<?php echo esc_attr($taxonomy); ?>" />
				</div>
			</form>
		</div>
		<?php
	}
}

if( !function_exists('gon_search_by_category_get_option_html') ){
	function gon_search_by_category_get_option_html($taxonomy = 'product_cat', $parent = 0, $level = 0){
		$options = '';
		$spacing = '';
		
		if( $level == 0 ){
			$options = '<option value="">'.esc_html__('All categories', 'gon').'</option>';
		}
		
		for( $i = 0; $i < $level * 3 ; $i++ ){
			$spacing .= '&nbsp;';
		}
		
		$args = array(
			'taxonomy'		=> $taxonomy
			,'number'     	=> ''
			,'hide_empty'	=> 1
			,'orderby'		=>'name'
			,'order'		=>'asc'
			,'parent'		=> $parent
		);
		
		$select = '';
		$categories = get_terms($args);
		if( is_search() &&  isset($_GET['term']) && $_GET['term'] != '' ){
			$select = $_GET['term'];
		}
		$level++;
		if( is_array($categories) ){
			foreach( $categories as $cat ){
				$options .= '<option value="' . $cat->slug . '" ' . selected($select, $cat->slug, false) . '>' . $spacing . $cat->name . '</option>';
				$options .= gon_search_by_category_get_option_html($taxonomy, $cat->term_id, $level);
			}
		}
		
		return $options;
	}
}

/* Ajax search */
add_action( 'wp_ajax_gon_ajax_search', 'gon_ajax_search' );
add_action( 'wp_ajax_nopriv_gon_ajax_search', 'gon_ajax_search' );
if( !function_exists('gon_ajax_search') ){
	function gon_ajax_search(){
		check_ajax_referer( 'gon-search-nonce', 'security' );
		
		global $wpdb, $post;
		$theme_options = gon_get_theme_options();
		
		$search_for_product = class_exists('WooCommerce');
		if( $search_for_product ){
			$taxonomy = 'product_cat';
			$post_type = 'product';
		}
		else{
			$taxonomy = 'category';
			$post_type = 'post';
		}
		
		$num_result = isset($theme_options['ts_ajax_search_number_result'])? (int)$theme_options['ts_ajax_search_number_result']: 10;
		$desc_limit_words = isset($theme_options['ts_prod_cat_grid_desc_words'])?(int)$theme_options['ts_prod_cat_grid_desc_words']:10;
		
		$search_string = sanitize_text_field($_POST['search_string']);
		$category = isset($_POST['category'])? sanitize_text_field($_POST['category']): '';
		
		$args = array(
			'post_type'			=> $post_type
			,'post_status'		=> 'publish'
			,'s'				=> $search_string
			,'posts_per_page'	=> $num_result
			,'tax_query'		=> array()
		);
		
		if( $search_for_product ){
			$args['meta_query'] = WC()->query->get_meta_query();
			$args['tax_query'] = WC()->query->get_tax_query();
		}
		
		if( $category != '' ){
			$args['tax_query'][] = array(
					'taxonomy'  => $taxonomy
					,'terms'	=> $category
					,'field'	=> 'slug'
				);
		}
		
		$results = new WP_Query($args);
		
		if( $results->have_posts() ){
			$extra_class = '';
			if( isset($results->post_count, $results->found_posts) && $results->found_posts > $results->post_count ){
				$extra_class = 'has-view-all';
			}
			
			$html = '<ul class="'.$extra_class.'">';
			while( $results->have_posts() ){
				$results->the_post();
				$link = get_permalink($post->ID);
				
				$image = '';
				if( $post_type == 'product' ){
					$product = wc_get_product($post->ID);
					$image = $product->get_image();
				}
				else if( has_post_thumbnail($post->ID) ){
					$image = get_the_post_thumbnail($post->ID, 'thumbnail');
				}
				
				$html .= '<li>';
					$html .= '<div class="thumbnail">';
						$html .= '<a href="'.esc_url($link).'">'. $image .'</a>';
					$html .= '</div>';
					$html .= '<div class="meta">';
						$html .= '<a href="'.esc_url($link).'" class="title">'. gon_search_highlight_string($post->post_title, $search_string) .'</a>';
						$html .= '<div class="description">'. gon_the_excerpt_max_words($desc_limit_words, '', true, ' ...', false) .'</div>';
						if( $post_type == 'product' ){
							if( $price_html = $product->get_price_html() ){
								$html .= '<span class="price">'. $price_html .'</span>';
							}
						}
					$html .= '</div>';
				$html .= '</li>';
			}
			$html .= '</ul>';
			
			if( isset($results->post_count, $results->found_posts) && $results->found_posts > $results->post_count ){
				$view_all_text = sprintf( esc_html__('View all %d results', 'gon'), $results->found_posts );
				
				$html .= '<div class="view-all-wrapper">';
					$html .= '<a href="#">'. $view_all_text .'</a>';
				$html .= '</div>';
			}
			
			wp_reset_postdata();
			
			$return = array();
			$return['html'] = $html;
			$return['search_string'] = $search_string;
			die( json_encode($return) );
		}
		
		die('');
	}
}

if( !function_exists('gon_search_highlight_string') ){
	function gon_search_highlight_string($string, $search_string){
		$new_string = '';
		$pos_left = stripos($string, $search_string);
		if( $pos_left !== false ){
			$pos_right = $pos_left + strlen($search_string);
			$new_string_right = substr($string, $pos_right);
			$search_string_insensitive = substr($string, $pos_left, strlen($search_string));
			$new_string_left = stristr($string, $search_string, true);
			$new_string = $new_string_left . '<span class="hightlight">' . $search_string_insensitive . '</span>' . $new_string_right;
		}
		else{
			$new_string = $string;
		}
		return $new_string;
	}
}

/* Match with ajax search results */
add_filter('woocommerce_get_catalog_ordering_args', 'gon_woocommerce_get_catalog_ordering_args_filter');
if( !function_exists('gon_woocommerce_get_catalog_ordering_args_filter') ){
	function gon_woocommerce_get_catalog_ordering_args_filter( $args ){
		if( is_search() && !isset($_GET['orderby']) && get_option( 'woocommerce_default_catalog_orderby' ) == 'menu_order' 
			&& gon_get_theme_options('ts_ajax_search') ){
			$args['orderby'] = '';
			$args['order'] = '';
		}
		return $args;
	}
}

/* Custom Sidebar */
add_action( 'sidebar_admin_page', 'gon_custom_sidebar_form' );
function gon_custom_sidebar_form(){
?>
	<form action="<?php echo admin_url( 'widgets.php' ); ?>" method="post" id="ts-form-add-sidebar">
        <input type="text" name="sidebar_name" id="sidebar_name" placeholder="<?php esc_attr_e('Custom Sidebar Name', 'gon') ?>" />
        <input type="hidden" id="ts_custom_sidebar_nonce" value="<?php echo wp_create_nonce('ts-custom-sidebar'); ?>" />
		<button class="button-primary" id="ts-add-sidebar"><?php esc_html_e('Add Sidebar', 'gon') ?></button>
    </form>
<?php
}

function gon_get_custom_sidebars(){
	$option_name = 'ts_custom_sidebars';
	$custom_sidebars = get_option($option_name);
    return is_array($custom_sidebars)?$custom_sidebars:array();
}

add_action('wp_ajax_gon_add_custom_sidebar', 'gon_add_custom_sidebar');
function gon_add_custom_sidebar(){
	if( isset($_POST['sidebar_name']) ){
		check_ajax_referer('ts-custom-sidebar', 'sidebar_nonce');
		
		$option_name = 'ts_custom_sidebars';
		if( !get_option($option_name) || get_option($option_name) == '' ){
			delete_option($option_name);
		}
		
		$sidebar_name = sanitize_text_field($_POST['sidebar_name']);
		
		if( get_option($option_name) ){
			$custom_sidebars = gon_get_custom_sidebars();
			if( !in_array($sidebar_name, $custom_sidebars) ){
				$custom_sidebars[] = $sidebar_name;
			}
			$result1 = update_option($option_name, $custom_sidebars);
		}
		else{
			$custom_sidebars = array();
			$custom_sidebars[] = $sidebar_name;
			$result2 = add_option($option_name, $custom_sidebars);
		}
		
		if( $result1 ){
			die( esc_html__('Updated', 'gon') );
		}
		elseif( $result2 ){
			die( esc_html__('Added', 'gon') );
		}
		else{
			die( esc_html__('Error', 'gon') );
		}
	}
	die('');
}

add_action('wp_ajax_gon_delete_custom_sidebar', 'gon_delete_custom_sidebar');
function gon_delete_custom_sidebar(){
	if( isset($_POST['sidebar_name']) ){
		check_ajax_referer('ts-custom-sidebar', 'sidebar_nonce');
		
		$option_name = 'ts_custom_sidebars';
		$del_sidebar = sanitize_text_field($_POST['sidebar_name']);
		$custom_sidebars = gon_get_custom_sidebars();
		foreach( $custom_sidebars as $key => $value ){
			if( $value == $del_sidebar ){
				unset($custom_sidebars[$key]);
				break;
			}
		}
		$custom_sidebars = array_values($custom_sidebars);
		update_option($option_name, $custom_sidebars);
		die( esc_html__('Deleted', 'gon') );
	}
	die('');
}

/* Calculate Color */
if( !function_exists('gon_hex2rgb') ){
	function gon_hex2rgb($hex){
		if( substr( $hex, 0, 1 ) == "#" ){
			$hex = substr( $hex, 1 );
		}
		if( strlen($hex) == 6 ){
			$R = substr($hex, 0, 2);
			$G = substr($hex, 2, 2);
			$B = substr($hex, 4, 2);
		}
		else{
			$R = substr($hex, 0, 1);
			$G = substr($hex, 1, 1);
			$B = substr($hex, 2, 1);
		}

		$R = hexdec($R);
		$G = hexdec($G);
		$B = hexdec($B);

		$RGB['R'] = $R;
		$RGB['G'] = $G;
		$RGB['B'] = $B;

		return $RGB;
	}
}

if( !function_exists('gon_rgb2hex') ){
	function gon_rgb2hex($rgb) {
	   $hex = "#";
	   $hex .= str_pad(dechex($rgb['R']), 2, dechex($rgb['R']), STR_PAD_LEFT);
	   $hex .= str_pad(dechex($rgb['G']), 2, dechex($rgb['G']), STR_PAD_LEFT);
	   $hex .= str_pad(dechex($rgb['B']), 2, dechex($rgb['B']), STR_PAD_LEFT);

	   return $hex;
	}
}

if( !function_exists('gon_calc_color') ){
	function gon_calc_color($first_color = '', $second_color = '', $add = true){
		if( strrpos($first_color, '#') !== false && strrpos($second_color, '#') !== false ){
			$rgb_first_color = gon_hex2rgb($first_color);
			$rgb_second_color = gon_hex2rgb($second_color);
			if( $add ){
				$rgb_first_color['R'] += $rgb_second_color['R'];
				$rgb_first_color['G'] += $rgb_second_color['G'];
				$rgb_first_color['B'] += $rgb_second_color['B'];
			}
			else{
				$rgb_first_color['R'] -= $rgb_second_color['R'];
				$rgb_first_color['G'] -= $rgb_second_color['G'];
				$rgb_first_color['B'] -= $rgb_second_color['B'];
			}
			return gon_rgb2hex($rgb_first_color);
		}
		else{
			return $first_color;
		}
	}
}

if( !function_exists('gon_get_mailchimp_forms') ){
	function gon_get_mailchimp_forms(){
		$args = array(
			'post_type'			=> 'mc4wp-form'
			,'post_status'		=> 'publish'
			,'posts_per_page'	=> -1
		);
		$results = array();
		$forms = new WP_Query( $args );
		if( !empty( $forms->posts ) && is_array( $forms->posts ) ){
			foreach( $forms->posts as $p ){
				$results[] = array(
					'id'		=> $p->ID
					,'title'	=> $p->post_title
				);
			}
		}
		
		return $results;
	}
}

/* Add User Extra Fields */
if( is_admin() ){
	add_action( 'show_user_profile', 'gon_user_extra_fields' );
	add_action( 'edit_user_profile', 'gon_user_extra_fields' );
}
if( !function_exists('gon_user_extra_fields') ){
	function gon_user_extra_fields( $user ){
		$author_box_bg = get_the_author_meta( 'author_box_bg', $user->ID );
		?>
		<h3><?php esc_html_e('Extra profile information', 'gon'); ?></h3>
		<table class="form-table">
			<tr>
				<th><label for="author_box_bg"><?php esc_html_e('Author box background', 'gon'); ?></label></th>
				<td class="ts-meta-box-field">
					<div class="field">
						<input type="text" class="upload_field" name="author_box_bg" id="author_box_bg" value="<?php echo esc_attr( $author_box_bg ); ?>" />
						<input type="button" class="ts_meta_box_upload_button" value="<?php esc_attr_e('Select Image', 'gon'); ?>" />
						<input type="button" class="ts_meta_box_clear_image_button" value="<?php esc_attr_e('Clear Image', 'gon'); ?>" <?php echo !empty($author_box_bg)?'':'disabled' ?> />
						<p class="description"><?php esc_html_e('Set background of author box on blog', 'gon'); ?></p>
						<img class="preview-image" src="<?php echo esc_url($author_box_bg) ?>" />
					</div>
				</td>
			</tr>
		</table>
		<?php
	}
}

add_action( 'personal_options_update', 'gon_save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'gon_save_extra_user_profile_fields' );
if( !function_exists('gon_save_extra_user_profile_fields') ){
	function gon_save_extra_user_profile_fields( $user_id ) {
		if( !current_user_can( 'edit_user', $user_id ) ){ 
			return false; 
		}
		if( isset($_POST['author_box_bg']) ){
			update_user_meta( $user_id, 'author_box_bg', $_POST['author_box_bg'] );
		}
	}
}

/* Notice remove Gon Importer */
add_action( 'admin_notices', 'gon_remove_plugin_notice' );
function gon_remove_plugin_notice(){
	if( class_exists('TS_Gon_Importer') ){
		?>
		<div class="notice notice-error">
			<p><?php esc_html_e('The Gon Importer plugin is not used anymore. You can remove it!', 'gon'); ?></p>
		</div>
		<?php
		
	}
}

/* Install Required Plugins */
add_action( 'tgmpa_register', 'gon_register_required_plugins' );
function gon_register_required_plugins(){
	$plugin_dir_path = get_template_directory() . '/framework/plugins/';

    $plugins = array(

        array(
            'name'                => 'ThemeSky'
            ,'slug'               => 'themesky'
            ,'source'             => $plugin_dir_path . 'themesky.zip'
            ,'required'           => true
            ,'version'            => '2.2.1'
            ,'external_url'       => ''
        )
		,array(
            'name'                => 'One Click Demo Import'
            ,'slug'               => 'one-click-demo-import'
			,'source'             => 'https://downloads.wordpress.org/plugin/one-click-demo-import.3.4.0.zip'
            ,'required'           => false
			,'version'            => '3.4.0'
            ,'external_url'       => ''
        )
		,array(
            'name'                => 'WooCommerce'
            ,'slug'               => 'woocommerce'
			,'source'             => 'https://downloads.wordpress.org/plugin/woocommerce.10.3.5.zip'
            ,'required'           => true
			,'version'            => '10.3.5'
            ,'external_url'       => ''
        )
		,array(
            'name'                => 'WPBakery Page Builder'
            ,'slug'               => 'js_composer'
            ,'source'             => $plugin_dir_path . 'js_composer.zip'
            ,'required'           => true
            ,'version'            => '8.7.2'
            ,'external_url'       => ''
        )
		,array(
            'name'                => 'Slider Revolution'
            ,'slug'               => 'revslider'
            ,'source'             => $plugin_dir_path . 'revslider.zip'
            ,'required'           => false
            ,'version'            => '6.7.38'
            ,'external_url'       => ''
        )
		,array(
            'name'                => 'Contact Form 7'
            ,'slug'               => 'contact-form-7'
			,'source'             => 'https://downloads.wordpress.org/plugin/contact-form-7.6.1.3.zip'
            ,'required'           => false
			,'version'            => '6.1.3'
            ,'external_url'       => ''
        )
		,array(
            'name'                => 'MailChimp for WordPress'
            ,'slug'               => 'mailchimp-for-wp'
			,'source'             => 'https://downloads.wordpress.org/plugin/mailchimp-for-wp.4.10.8.zip'
            ,'required'           => false
			,'version'            => '4.10.8'
            ,'external_url'       => ''
        )

    );

    $config = array(
		'id'           	=> 'tgmpa'
		,'default_path' => ''
		,'menu'         => 'tgmpa-install-plugins'
		,'parent_slug'  => 'themes.php'
		,'capability'   => 'edit_theme_options'
		,'has_notices'  => true
		,'dismissable'  => true
		,'dismiss_msg'  => ''
		,'is_automatic' => false
		,'message'      => ''
	);

    tgmpa( $plugins, $config );
}
?>