<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<?php
	$gon_theme_options = gon_get_theme_options();
	$gon_page_options = gon_get_page_options();
	?>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />

	<?php if( isset($gon_theme_options['ts_responsive']) && $gon_theme_options['ts_responsive'] == 1 ): ?>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
	<?php endif; ?>

	<link rel="profile" href="//gmpg.org/xfn/11" />
	<?php 
	gon_theme_favicon();
	wp_head(); 
	?>
</head>
<?php
$header_classes = array();
if( isset($gon_page_options['ts_header_transparent']) && $gon_page_options['ts_header_transparent'] ){
	$header_classes[] = 'header-transparent';
	if( isset($gon_page_options['ts_header_text_color']) ){
		$header_classes[] = 'header-text-'.$gon_page_options['ts_header_text_color'];
	}
}

if( isset($gon_theme_options['ts_enable_sticky_header']) && $gon_theme_options['ts_enable_sticky_header'] ){
	$header_classes[] = 'has-sticky';
}

$header_layout = 'header-'.$gon_theme_options['ts_header_layout'];
?>
<body <?php body_class( $header_layout ); ?>>
<?php 
if( function_exists('wp_body_open') ){
	wp_body_open();
}
?>
<div id="page" class="hfeed site">

	<?php if( !is_page_template('page-templates/blank-page-template.php') ): ?>

		<!-- Page Slider -->
		<?php if( is_page() && isset($gon_page_options) ): ?>
			<?php if( $gon_page_options['ts_page_slider'] && $gon_page_options['ts_page_slider_position'] == 'before_header' ): ?>
			<div class="top-slideshow">
				<div class="top-slideshow-wrapper">
					<?php gon_show_page_slider(); ?>
				</div>
			</div>
			<?php endif; ?>
		<?php endif; ?>
		
		<header class="ts-header <?php echo esc_attr(implode(' ', $header_classes)); ?>">
			<div class="header-container">
				<?php 
				$extra_class = array();
				if( $gon_theme_options['ts_enable_tiny_shopping_cart'] == 0 ){
					$extra_class[] = 'hidden-cart';
				}
				else{
					$extra_class[] = 'show-cart';
					
				}
				if( $gon_theme_options['ts_enable_search'] == 0 ){
					$extra_class[] = 'hidden-search';
				}
				else{
					$extra_class[] = 'show-search';
				}
				?>
				<div class="header-template header-<?php echo esc_attr($gon_theme_options['ts_header_layout']); ?> <?php echo has_nav_menu( 'vertical' )?'has-vertical-menu':''; ?> <?php echo esc_attr(implode(' ', $extra_class)); ?>">

					<div class="header-top">
						<div class="container">
							<div class="header-top-left">

								<?php if( $gon_theme_options['ts_header_contact_information'] ): ?>
								<div class="info-desc"><?php echo do_shortcode(stripslashes($gon_theme_options['ts_header_contact_information'])); ?></div>
								<?php endif; ?>

							</div>
							<div class="header-top-right">
							
								<span class="ts-mobile-menu-icon-toggle visible-phone"><i class="fa fa-bars"></i></span>
								
								<span class="ts-group-meta-icon-toggle visible-phone"><i class="fa fa-cog"></i></span>
								
								<?php if( $gon_theme_options['ts_enable_tiny_shopping_cart'] ): ?>
								<div class="shopping-cart-wrapper cart-mobile visible-phone"><?php echo gon_tiny_cart(); ?></div>
								<?php endif; ?>
								
								<div class="group-meta-header">
									<?php if( $gon_theme_options['ts_header_currency'] ): ?>
									<div class="header-currency"><?php gon_woocommerce_multilingual_currency_switcher(); ?></div>
									<?php endif; ?>
									
									<?php if( $gon_theme_options['ts_header_language'] ): ?>
									<div class="header-language"><?php gon_wpml_language_selector(); ?></div>
									<?php endif; ?>
									
									<?php if( class_exists('TS_Wishlist') && $gon_theme_options['ts_enable_tiny_wishlist'] ): ?>
									<div class="my-wishlist-wrapper"><?php echo gon_tini_wishlist(); ?></div>
									<?php endif; ?>
									
									<?php if( $gon_theme_options['ts_enable_tiny_account'] ): ?>
									<div class="my-account-wrapper"><?php echo gon_tiny_account(); ?></div>
									<?php endif; ?>
								</div>
								
							</div>
						</div>
					</div>
					<div class="mobile-menu-wrapper">
						<?php 
						if ( has_nav_menu( 'mobile' ) ) {
							wp_nav_menu( array( 'container' => 'nav', 'container_class' => 'main-menu mobile-menu', 'theme_location' => 'mobile' ) );
						}else{
							wp_nav_menu( array( 'container' => 'nav', 'container_class' => 'main-menu mobile-menu', 'theme_location' => 'primary') );
						}
						?>
					</div>
					<div class="header-middle">
						<div class="container">
							
							<?php if( $gon_theme_options['ts_enable_search'] ): ?>
							<div class="search-wrapper hidden-phone">
								<div class="ts-search-by-category"><?php get_search_form(); ?></div>
							</div>
							<?php endif; ?>
							
							<div class="logo-wrapper"><?php echo gon_theme_logo(); ?></div>
							
							<?php if( $gon_theme_options['ts_enable_tiny_shopping_cart'] ): ?>
							<div class="shopping-cart-wrapper"><?php echo gon_tiny_cart(); ?></div>
							<?php endif; ?>
							
							<?php if( $gon_theme_options['ts_enable_search'] ): ?>
							<div class="search-wrapper visible-phone">
								<div class="ts-search-by-category"><?php get_search_form(); ?></div>
							</div>
							<?php endif; ?>
							
						</div>
					</div>
					<div class="header-bottom header-sticky">
						<div class="container">
							<div class="menu-wrapper hidden-phone">				
								<div class="ts-menu">
									<?php 
										if ( has_nav_menu( 'vertical' ) ) {
											?>
											<div class="vertical-menu-wrapper">
												<div class="vertical-menu-heading"><?php echo gon_get_vertical_menu_heading(); ?></div>
												<?php
												wp_nav_menu( array( 'container' => 'nav', 'container_class' => 'vertical-menu pc-menu ts-mega-menu-wrapper','theme_location' => 'vertical','walker' => new Gon_Walker_Nav_Menu() ) );
												?>
											</div>
											<?php
										}
										
										if ( has_nav_menu( 'primary' ) ) {
											wp_nav_menu( array( 'container' => 'nav', 'container_class' => 'main-menu pc-menu ts-mega-menu-wrapper','theme_location' => 'primary','walker' => new Gon_Walker_Nav_Menu() ) );
										}
										else{
											wp_nav_menu( array( 'container' => 'nav', 'container_class' => 'main-menu pc-menu ts-mega-menu-wrapper' ) );
										}
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
				
			</div>
		</header>
		
	<?php endif; ?>
	
	<?php do_action('gon_before_main_content'); ?>

	<div id="main" class="wrapper">