<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

	academy_get_header( 'course' );
	global $rainbow_options;
    $rainbow_tutor_archive_banner_layout = isset($rainbow_options['academy_course_archive_banner_layout']) && !empty($rainbow_options['academy_course_archive_banner_layout']) ? $rainbow_options['academy_course_archive_banner_layout']: '';

	$overlay_top = 'rbt-section-overlayping-top';
	if( $rainbow_tutor_archive_banner_layout == 'layout-1') {
		$overlay_top = 'histudy-academy-archive-top';
	}
?>

<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

	academy_get_header( 'course' );
	
	$filter_layout_academy = '';
	if( function_exists('academy_start')) {
		$filter_layout_academy = isset( $rainbow_options['histudy_academy_course_breadcrumb_filter_layout'] ) ? $rainbow_options['histudy_academy_course_breadcrumb_filter_layout'] : '' ;
	}
	
	$course_filter_layout = get_query_var( 'course_filter_layout' );
	if( !empty($course_filter_layout) ) {
		$filter_layout = $course_filter_layout;
	} else {
		$filter_layout = $filter_layout_academy;
	}

	$sidebar_position = get_query_var('sidebar_position');

	if(!empty($sidebar_position)) {
		$sidebar_position = get_query_var('sidebar_position');
		
	} else {
		$sidebar_position = \Academy\Helper::get_settings( 'course_archive_sidebar_position', 'right' );
	}

	$card_layout = isset( $_GET['card_layout'] ) ? $_GET['card_layout'] : '';
	$course_masonary = isset( $_GET['course_masonary'] ) ? $_GET['course_masonary'] : '';
    if( !empty( $card_layout)) {
        $rainbow_academy_card_layout = $card_layout;
    } else {
        $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';
    }
	$card_layout_class ='';
	if( $rainbow_academy_card_layout == 'layout-3' ) {
		$card_layout_class = 'histudy-academy-class';
	}

	$masonary_class ='';
	if( ( $rainbow_academy_card_layout == 'layout-3' || $rainbow_academy_card_layout == 'layout-4' ) && $course_masonary == 'yes') {
		$masonary_class = 'histudy-academy-course-masonary';
	}

	$card_layout_class2 ='';
	if( $rainbow_academy_card_layout == 'layout-4' ) {
		$card_layout_class2 = 'histudy-academy-class-four';
	}


?>

<?php
	/**
	 * @hook - academy/templates/before_main_content
	 */
	do_action( 'academy/templates/before_main_content', 'archive-course.php' );
?>

<div class="academy-courses academy-courses--archive <?php echo esc_attr($overlay_top); ?> has-filter-layout rbt-section-gapBottom course-layout tutor-course-archive-page <?php echo esc_attr($card_layout_class);?> <?php echo esc_attr($card_layout_class2); ?> <?php echo esc_attr($masonary_class); ?>">
	<div class="inner">
		<div class="academy-container container">
			<div class="academy-row  <?php echo esc_attr( 'none' === $sidebar_position && $filter_layout != 'layout-3' && $filter_layout != 'layout-4' ? 'rbt-course-grid-column' : 'row--30 gy-5' ); ?>">
				
				<?php
				if ( 'left' === $sidebar_position || ( $filter_layout == 'layout-4' && $sidebar_position !== 'right' ) ) :
					?>
					<div class="academy-col-md-3"><?php do_action( 'academy/templates/archive_course_sidebar' ); ?></div> 
					<?php
					endif;
				?>
				<div class="<?php echo esc_attr( 'none' === $sidebar_position && $filter_layout != 'layout-3' && $filter_layout != 'layout-4' ? 'academy-col-12 academy-course-large-col' : 'academy-col-md-9 academy-course-large-col' ); ?>"><?php do_action( 'academy/templates/archive_course_content' ); ?></div>
				<?php
				if (
					$sidebar_position === 'right' ||
					( $filter_layout === 'layout-3' && $sidebar_position !== 'left' )
				) :
				
					?>
					<div class="academy-col-md-3"><?php do_action( 'academy/templates/archive_course_sidebar' ); ?></div> 
					<?php
					endif;
				?>
				<div class="academy-col-12"><?php do_action( 'academy/templates/archive_course_footer' ); ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php
	/**
	 * @hook - academy/templates/after_main_content
	 */
	do_action( 'academy/templates/after_main_content', 'archive-course.php' );
?>

<?php
academy_get_footer( 'course' );
?>
