<?php
// course loop

remove_action('academy/templates/course_loop_header', 'academy_course_loop_header', 10);
remove_action('academy/templates/course_loop_content', 'academy_course_loop_content', 11);
remove_action('academy/templates/course_loop_footer', 'academy_course_loop_footer', 12);
remove_action('academy/templates/archive_course_description', 'academy_archive_course_header_filter', 10);

add_action("academy/templates/course_loop_header", "histudy_course_loop_header", 10);
add_action("academy/templates/course_loop_content", "histudy_course_loop_content", 11);
add_action("academy/templates/course_loop_footer", "histudy_course_loop_footer", 12);
add_action('academy/templates/archive_course_description', 'histudy_archive_course_header_filter', 10);

// course loop header functions

function histudy_course_loop_header()
{
    $card_style = Academy\Helper::get_settings('course_card_style');
    $image_class = 'layout_two' === $card_style || 'layout_four' === $card_style ? 'academy-course-thumbnail-width' : '';

    $course_id = get_the_ID();
    if ($course_id) {
        $course_percentage = Rainbow_Helper::rb_get_product_offer_percentage($course_id);
    }

    $rainbow_options = Rainbow_Helper::rainbow_get_options();

    $list_course_img_size = isset($rainbow_options['academy_rainbow_course_list_archive_img_size']) ? $rainbow_options['academy_rainbow_course_list_archive_img_size'] : '';
    $grid_course_img_size = isset($rainbow_options['academy_rainbow_course_grid_archive_img_size']) ? $rainbow_options['academy_rainbow_course_grid_archive_img_size'] : '';

    $card_layout = isset( $_GET['card_layout'] ) ? $_GET['card_layout'] : '';
    if( !empty( $card_layout)) {
        $rainbow_academy_card_layout = $card_layout;
    } else {
        $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';
    }

    if( $rainbow_academy_card_layout == 'layout-3' || $rainbow_academy_card_layout == 'layout-4' ) {
        $img_size = $list_course_img_size;
    } else {
        $img_size = $grid_course_img_size;
    }

    $academy_rainbow_course_card_image_switch = isset($rainbow_options['academy_rainbow_course_card_image_switch']) ? $rainbow_options['academy_rainbow_course_card_image_switch'] : 'false';
    
    if( $academy_rainbow_course_card_image_switch == '1') {
?>
    <div class="rbt-card-img">
        <a href="<?php echo esc_url(get_the_permalink()); ?>">
            <img class="academy-course__thumbnail-image <?php echo esc_html($image_class); ?>" src="<?php echo esc_url(Academy\Helper::get_the_course_thumbnail_url('academy_thumbnail')); ?>" alt="<?php esc_html_e('thumbnail', 'academy'); ?>">
            <?php if (!empty($course_percentage)) : ?>
                <div class="rbt-badge-3 bg-white">
                    <span><?php echo esc_html($course_percentage); ?>%</span>
                    <span><?php echo esc_html__("Off", "histudy"); ?></span>
                </div>
            <?php endif; ?>
        </a>
    </div>
<?php
    }
}

// course loop content 

function histudy_course_loop_content()
{

    global $wpdb;
    $content = get_the_excerpt();
    $content = apply_filters('the_content', $content);
    $content = wp_trim_words(get_the_excerpt(),  '12', '.');
    $course_id = get_the_ID();
    $user_id   = get_current_user_id();

    $total_enrolled = \Academy\Helper::count_course_enrolled($course_id);
    $student_count  = sprintf(_n('%s Student', '%s Students', $total_enrolled, 'histudy'), $total_enrolled);


    $total_lessons  = \Academy\Helper::get_total_number_of_course_lesson($course_id);

    if ($total_lessons == 1) {
        $lesson = esc_html__('Lesson', 'histudy');
    } else {
        $lesson = esc_html__('Lessons', 'histudy');
    }

    $is_already_in_wishlist = $wpdb->get_row($wpdb->prepare("SELECT * from {$wpdb->usermeta} WHERE user_id = %d AND meta_key = 'academy_course_wishlist' AND meta_value = %d;", $user_id, $course_id));
    $is_show_wishlist = (bool) \Academy\Helper::get_settings('is_enabled_course_wishlist', true);
    $card_style = Academy\Helper::get_settings('course_card_style');

    $wishlist_class = 'layout_two' === $card_style || 'layout_four' === $card_style ? 'academy-wishlist-dynamic' : '';

    $rating = \Academy\Helper::get_course_rating($course_id);
    $reviews_status = Academy\Helper::get_settings('is_enabled_course_review', true);
    if ($rating->rating_count == 1) {
        $review_text = __('Review', 'histudy');
    } else {
        $review_text = __('Reviews', 'histudy');
    }

    $rainbow_options = Rainbow_Helper::rainbow_get_options();

    $card_layout = isset( $_GET['card_layout'] ) ? $_GET['card_layout'] : '';
    if( !empty( $card_layout)) {
        $rainbow_academy_card_layout = $card_layout;
    } else {
        $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';
    }

    
    $rainbow_course_content_limit = isset($rainbow_options['academy_rainbow_course_content_limit']) ? $rainbow_options['academy_rainbow_course_content_limit'] : 'layout-1';
    $categories             = get_the_terms($course_id, 'academy_courses_category');
    $categorie_lists = [];
    if(isset($categories) && !empty($categories)) {
        $cat_taxonomy = 'academy_courses_category';
        foreach($categories as $cat) {
            $cat_id = $cat->term_id;
            $cat_name = $cat->name;
            $cat_url = $category_link = get_term_link($cat_id, $cat_taxonomy);
            $categorie_lists[$cat_url] = $cat_name;
        }
    }

    $margin_bottom = ( $rainbow_academy_card_layout == 'layout-4' || $rainbow_academy_card_layout == 'layout-5') ? 'mb--10' : '';

    $academy_rainbow_course_card_title_switch = isset($rainbow_options['academy_rainbow_course_card_title_switch']) ? $rainbow_options['academy_rainbow_course_card_title_switch'] : 'false';
    $academy_rainbow_course_card_meta_switch = isset($rainbow_options['academy_rainbow_course_card_meta_switch']) ? $rainbow_options['academy_rainbow_course_card_meta_switch'] : 'false';
    $academy_rainbow_course_card_rating_switch = isset($rainbow_options['academy_rainbow_course_card_rating_switch']) ? $rainbow_options['academy_rainbow_course_card_rating_switch'] : 'false';

    $user_id = get_current_user_id();
    $course_id = get_the_ID();
    $wishlist = get_user_meta($user_id, 'academy_course_wishlist', true);
    $is_in_wishlist = is_array($wishlist) && in_array($course_id, $wishlist);
    $login_class = ! is_user_logged_in() ? 'academy-header-login-btn' : '';

?>

    <div class="rbt-card-body">
    <input type="hidden" name="_histudy_academy_nonce" value="<?php echo wp_create_nonce('histudy_academy_nonce'); ?>">
        <?php 

        if( $rainbow_academy_card_layout  =='layout-1' || $rainbow_academy_card_layout  =='layout-3' || $rainbow_academy_card_layout  =='layout-4' || $rainbow_academy_card_layout  =='layout-5') { ?>
            <div class="rbt-card-top">
                <?php
                if ( $academy_rainbow_course_card_rating_switch == '1') : ?>
                    <div class="rbt-review">
                        <div class="rating">
                            <?php
                            $rating_avg = $rating->rating_avg;
                            $fullStars = floor($rating_avg);
                            $halfStar = ($rating_avg - $fullStars) >= 0.5 ? 1 : 0;
                            $emptyStars = 5 - ($fullStars + $halfStar);
                            ?>
                            <?php for ($i = 0; $i < $fullStars; $i++): ?>
                                <i class="fas fa-star"></i>
                            <?php endfor; ?>

                            <?php if ($halfStar): ?>
                                <i class="fas fa-star-half-alt"></i>
                            <?php endif; ?>

                            <?php for ($i = 0; $i < $emptyStars; $i++): ?>
                                <i class="far fa-star"></i>
                            <?php endfor; ?>

                            <?php

                            ?>
                        </div>
                        <span class="rating-count"><?php echo esc_html('(' . $rating->rating_count . " " . $review_text . ')'); ?></span>
                    </div>
                <?php
                endif;
                if ($is_show_wishlist) :
                ?>

                    <div class="rbt-bookmark-btn academy-course-header-meta">
                        <?php
                        if ($is_already_in_wishlist) :
                        ?>
                            <a class="<?php echo esc_attr($login_class); ?> active academy-course__wishlist-histudy academy-add-wishlist-btn-histudy rbt-round-btn  <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>" data-course-id="<?php echo esc_attr(get_the_ID()); ?>"><i class="fa-solid fa-bookmark <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>"></i></a>
                        <?php else : ?>
                            <a class="<?php echo esc_attr($login_class); ?>  academy-course__wishlist-histudy academy-add-wishlist-btn-histudy rbt-round-btn <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>" data-course-id="<?php echo esc_attr(get_the_ID()); ?>"><i class="fa-regular fa-bookmark <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>"></i></a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php if( $academy_rainbow_course_card_title_switch == '1') { ?>
            <h4 class="rbt-card-title">
                <a href="<?php echo esc_url(get_permalink($course_id)); ?>">
                    <?php the_title(); ?>
                </a>
            </h4>
            <?php } ?>
            <?php if( $academy_rainbow_course_card_meta_switch == '1') { ?>
            <ul class="rbt-meta <?php echo esc_attr($margin_bottom); ?>">
                <li><i class="feather-book"></i>
                    <?php echo esc_html($total_lessons); ?> <?php echo esc_html($lesson); ?></li>
                <li><i class="feather-users"></i> <?php echo esc_attr($student_count); ?></li>
            </ul>
            <?php } ?>
            <?php if ($content) { ?>
                <p class="rbt-card-text"><?php echo wp_trim_words(get_the_excerpt($course_id), $rainbow_course_content_limit); ?></p>
            <?php } 
            if( $rainbow_academy_card_layout  =='layout-4' || $rainbow_academy_card_layout  =='layout-5') {
            ?>
             <?php if(!empty($categorie_lists)) : ?>
            <ul class="rbt-meta rbt-meta-badge mb--20">
                <?php foreach($categorie_lists as $url => $name) : ?>
                    <li><a href="<?php echo esc_url($url); ?>"><span class="rbt-badge"><?php echo esc_html($name); ?></span></a></li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>
        <?php 
            }

        } elseif( $rainbow_academy_card_layout  =='layout-2' ) { ?>
        <?php if( $academy_rainbow_course_card_title_switch == '1') { ?>
            <h5 class="rbt-card-title">
                <a href="<?php echo esc_url(get_permalink($course_id)); ?>">
                    <?php the_title(); ?>
                </a>
            </h5>
            <?php
        }
        if ( $academy_rainbow_course_card_rating_switch == '1') : ?>
            <div class="rbt-review">
                <div class="rating">
                    <?php
                    $rating_avg = $rating->rating_avg;
                    $fullStars = floor($rating_avg);
                    $halfStar = ($rating_avg - $fullStars) >= 0.5 ? 1 : 0;
                    $emptyStars = 5 - ($fullStars + $halfStar);
                    ?>
                    <?php for ($i = 0; $i < $fullStars; $i++): ?>
                        <i class="fas fa-star"></i>
                    <?php endfor; ?>

                    <?php if ($halfStar): ?>
                        <i class="fas fa-star-half-alt"></i>
                    <?php endif; ?>

                    <?php for ($i = 0; $i < $emptyStars; $i++): ?>
                        <i class="far fa-star"></i>
                    <?php endfor; ?>

                    <?php

                    ?>
                </div>
                <span class="rating-count"><?php echo esc_html('(' . $rating->rating_count . " " . $review_text . ')'); ?></span>
            </div>
        <?php
        endif;
        } elseif( $rainbow_academy_card_layout == 'layout-6') { ?>
        <?php if( $academy_rainbow_course_card_meta_switch == '1') { ?>
            <ul class="rbt-meta">
                <li><i class="feather-book"></i>
                    <?php echo esc_html($total_lessons); ?> <?php echo esc_html($lesson); ?></li>
                <li><i class="feather-users"></i> <?php echo esc_attr($student_count); ?></li>
            </ul>
            <?php 
        }
            if( $academy_rainbow_course_card_title_switch == '1') { ?>
            <h4 class="rbt-card-title">
                <a href="<?php echo esc_url(get_permalink($course_id)); ?>">
                    <?php the_title(); ?>
                </a>
            </h4>
            <?php
            }
            if ( $academy_rainbow_course_card_rating_switch == '1') : ?>
                    <div class="rbt-review">
                        <div class="rating">
                            <?php
                            $rating_avg = $rating->rating_avg;
                            $fullStars = floor($rating_avg);
                            $halfStar = ($rating_avg - $fullStars) >= 0.5 ? 1 : 0;
                            $emptyStars = 5 - ($fullStars + $halfStar);
                            ?>
                            <?php for ($i = 0; $i < $fullStars; $i++): ?>
                                <i class="fas fa-star"></i>
                            <?php endfor; ?>

                            <?php if ($halfStar): ?>
                                <i class="fas fa-star-half-alt"></i>
                            <?php endif; ?>

                            <?php for ($i = 0; $i < $emptyStars; $i++): ?>
                                <i class="far fa-star"></i>
                            <?php endfor; ?>
                        </div>
                        <span class="rating-count"><?php echo esc_html('(' . $rating->rating_count . " " . $review_text . ')'); ?></span>
                    </div>
                <?php
            endif;
        }
            ?>
    <?php
}

// Fix translation issues

function histudy_course_loop_footer()
{

    $course_id = get_the_ID();
    $categories = \Academy\Helper::get_the_course_category(get_the_ID());
    global $authordata;
    $rainbow_options = Rainbow_Helper::rainbow_get_options();

    $card_layout = isset( $_GET['card_layout'] ) ? $_GET['card_layout'] : '';
    if( !empty( $card_layout)) {
        $rainbow_academy_card_layout = $card_layout;
    } else {
        $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';
    }

    $academy_rainbow_course_card_author_switch = isset($rainbow_options['academy_rainbow_course_card_author_switch']) ? $rainbow_options['academy_rainbow_course_card_author_switch'] : 'false';
    $academy_rainbow_course_card_add_to_cart_switch = isset($rainbow_options['academy_rainbow_course_card_add_to_cart_switch']) ? $rainbow_options['academy_rainbow_course_card_add_to_cart_switch'] : 'false';
    $academy_rainbow_course_card_pricing_switch = isset($rainbow_options['academy_rainbow_course_card_pricing_switch']) ? $rainbow_options['academy_rainbow_course_card_pricing_switch'] : 'false';

    ?>
    <?php 
    if( $rainbow_academy_card_layout  =='layout-1' || $rainbow_academy_card_layout  =='layout-3' || $rainbow_academy_card_layout  =='layout-4' || $rainbow_academy_card_layout  =='layout-5') { ?>
    <?php if(  $academy_rainbow_course_card_author_switch == '1') { ?>
        <div class="rbt-author-meta mb--10">
            <?php if (!empty(get_the_author())) : ?>
                <div class="rbt-avater">
                    <img src="<?php echo esc_url(get_avatar_url($authordata->ID, ['size' => '40'])); ?>" alt="">
                </div>
            <?php endif; ?>
            <?php if (!empty(get_the_author())) : ?>
                <div class="rbt-author-info">
                    <?php esc_html_e('By', 'histudy'); ?> <a href="<?php echo esc_url(home_url('/author/' . $authordata->user_nicename)); ?>"> <?php echo get_the_author(); ?></a>
                    <?php
                    if (! empty($categories)) {
                        esc_html_e('In', 'histudy'); ?>
                        <a href="<?php echo esc_url(get_term_link($categories[0]->term_id)); ?>"><?php echo esc_html($categories[0]->name); ?></a>
                    <?php } ?>
                </div>
            <?php endif; ?>
        </div>
        <?php } ?>
        <?php } ?>
        <div class="rbt-card-bottom">
            <?php 
            if( $academy_rainbow_course_card_pricing_switch == '1') {
                get_template_part('template-parts/components/price/layout', 1); 
            }
            ?>
            <?php if(  $academy_rainbow_course_card_add_to_cart_switch == '1') { ?>
            <a href="<?php echo esc_url(get_permalink($course_id)); ?>"
                class="course_details"><?php esc_html_e('Enroll Course', 'histudy'); ?>
                <i class="feather-arrow-right"></i>
            </a>
            <?php } ?>
        </div>
    </div>
    <?php
}

if (! function_exists('histudy_archive_course_header_filter')) {
    function histudy_archive_course_header_filter()
    {
        global $wp_query;
        $orderby = (get_query_var('orderby')) ? get_query_var('orderby') : ''; ?>

        <div class="rbt-short-item">
            <div class="filter-select academy-courses__header-filter">
                <span class="select-label d-block"><?php esc_html_e('Sort By', 'histudy'); ?></span>
                <div class="filter-select rbt-modern-select search-by-category">
                    <form class="academy-courses__header-ordering" method="get">
                        <select name="orderby" class="academy-courses__header-orderby" aria-label="Course order"
                            onchange="this.form.submit()" data-size="7">
                            <option value="DESC" <?php selected($orderby, 'DESC'); ?>>
                                <?php esc_html_e('Default Sorting', 'histudy'); ?>
                            </option>
                            <option value="menu_order" <?php selected($orderby, 'menu_order'); ?>>
                                <?php esc_html_e('Menu Order', 'histudy'); ?>
                            </option>
                            <option value="name" <?php selected($orderby, 'name'); ?>>
                                <?php esc_html_e('Order by course name', 'histudy'); ?>
                            </option>
                            <option value="date" <?php selected($orderby, 'date'); ?>>
                                <?php esc_html_e('Order by Publish Date', 'histudy'); ?>
                            </option>
                            <option value="modified" <?php selected($orderby, 'modified'); ?>>
                                <?php esc_html_e('Order by Modified Date', 'histudy'); ?>
                            </option>
                            <option value="ratings" <?php selected($orderby, 'ratings'); ?>>
                                <?php esc_html_e('Order by Most Reviews', 'histudy'); ?>
                            </option>
                            <option value="ID" <?php selected($orderby, 'ID'); ?>>
                                <?php esc_html_e('Order by ID', 'histudy'); ?>
                            </option>
                        </select>
                        <input type="hidden" name="paged" value="1">
                    </form>
                </div>
            </div>
        </div>
<?php
    }
}