<?php
/** @var int $product_id */

if ( ! defined( 'ABSPATH' ) ) {
	exit(); // Exit if accessed directly

}

use Academy\Helper;
use EDD\Models\Download;
$product_id = Academy\Helper::get_course_product_id( get_the_ID(  ));

$is_enabled_academy_login = Academy\Helper::get_settings( 'is_enabled_academy_login', true );
$force_login_before_enroll = $is_enabled_academy_login && Academy\Helper::get_settings( 'woo_force_login_before_enroll', true );
$monetization_engine = Helper::monetization_engine();
if ( 'woocommerce' === $monetization_engine ) {
	$product = wc_get_product( $product_id ); ?> 
          
	<div class="add-to-card-button mt--15">
		<?php if ( $product ) :
			if ( $force_login_before_enroll && ! is_user_logged_in() ) : ?>
				<button type="button" class="rbt-btn btn-gradient icon-hover w-100 d-block text-center academy-btn-popup-login">
					<span class="academy-icon academy--shopping-cart" aria-hidden="true"></span> 
                    <?php echo esc_html( $product->single_add_to_cart_text() ); ?>
				</button>
				<?php
		elseif ( Academy\Helper::is_product_in_cart( $product_id ) ) : ?>
					<a class="rbt-btn btn-gradient icon-hover w-100 d-block text-center" href="<?php echo esc_url( wc_get_cart_url() ); ?>"> 
						<span class="btn-text"><?php esc_html_e( 'View Cart', 'histudy' ); ?></span> 
						<span class="btn-icon"><i class="feather-arrow-right"></i></span> 
                    </a>
			<?php
		elseif ( $product->is_purchasable() ) : ?>
					<form class="cart" method="post" enctype='multipart/form-data'>
						<button type="submit" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>"
								class="rbt-btn btn-gradient icon-hover w-100 d-block text-center">
							<span class="academy-icon academy--shopping-cart" aria-hidden="true"></span>
                             
                                <span class="btn-text"><?php echo esc_html( $product->single_add_to_cart_text() ); ?></span>
                                <span class="btn-icon"><i class="feather-arrow-right"></i></span> 
                            
						</button>
					</form>
				<?php
		endif;
        else :
            ?>
            <p class="academy-alert academy-alert--warning">
                <?php esc_html_e( 'Please make sure that your product exists and valid for this course', 'histudy' ); ?>
            </p>
        <?php
        endif; ?>
	</div>
	<?php
} elseif ( 'edd' === $monetization_engine ) {
	$download = new EDD_Download( $download_id );
	$purchase_link = edd_get_purchase_link( [
		'download_id' => $download->ID,
		'text' => esc_html__( 'Add To Cart', 'histudy' ),
		'price' => 'no',
		'class' => 'rbt-btn btn-gradient icon-hover w-100 d-block text-center',
		'color' => '',
		'style' => ''
	] );
	?>
	<div class="academy-widget-enroll__add-to-cart">
        <?php if ( ! is_user_logged_in() ) : ?>
                <button type="button" class="rbt-btn btn-gradient icon-hover w-100 d-block text-center academy-btn-popup-login">
                    <span class="academy-icon academy--shopping-cart" aria-hidden="true"></span>
                     
						<span class="btn-text"><?php echo esc_html__( 'Add To Cart', 'histudy' ); ?></span>
                        <span class="btn-icon"><i class="feather-arrow-right"></i></span> 
                     
                </button>
            <?php
        else :
            echo wp_kses_post( $purchase_link ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        endif; ?>
	</div>

                        
	<?php
}//end if
