<?php
global $rainbow_options;
$course_id = get_the_ID();
$course_single_url = get_the_permalink($course_id);
$page_title = get_the_title();
$facebookShareUrl = "https://www.facebook.com/sharer/sharer.php?u=" . urlencode($course_single_url);
$twitterShareUrl = "https://twitter.com/intent/tweet?url=" . urlencode($course_single_url) . "&text=" . urlencode($page_title);
$linkedInShareUrl = "https://www.linkedin.com/sharing/share-offsite/?url=" . urlencode($course_single_url);
 
// Student
$total_enrolled = \Academy\Helper::count_course_enrolled( $course_id );
$total_student  = sprintf( _n( '%s', '%s', $total_enrolled, 'histudy' ), $total_enrolled );
if ($total_student === 1) {
	$students = 'Student';
} elseif ($total_student > 1) {
	$students = 'Students';
} else {
	$students = 'Student';
}  

$rainbow_options = Rainbow_Helper::rainbow_get_options();
$rainbow_course_details_thumbnail_switch = $rainbow_options['rainbow_course_details_thumbnail_switch'];

$course_video = '';
$current_user_id = get_current_user_id();
// $is_enrolled = function_exists('tutor_utils') ? tutor_utils()->is_enrolled($course_id, $current_user_id) : false;
$course_attributes      = get_post_meta($course_id);
$product_type = '';
 
 $last_updated = get_option('enable_course_update_date') ? get_the_modified_date(get_option('date_format')) : null;
 
$rainbow_course_details_settings                        = Rainbow_Helper::rainbow_course_details_settings();
// $course_duration   = get_tutor_course_duration_context($course_id, true);
$total_student_html     = sprintf(_n('%s Student', '%s Students', $students, 'histudy'), $students);
$author_id              = get_post_field('post_author', $course_id);
$author_image           = get_avatar_url($author_id);
$author_url             = get_author_posts_url($author_id);
$author_image_alt       = get_the_author_meta('description', $author_id);
$author_name            = get_the_author_meta('display_name', $author_id);
$last_updated           = get_option('enable_course_update_date') ? get_the_modified_date(get_option('date_format')) : null;
global $post;
$string                 = apply_filters('tutor_course_about_content', get_the_content());
$course_level           = get_post_meta($course_id, '_tutor_course_level', true);
$course_level_str       = null;
$language               = function_exists('get_field') ? get_field('rbt_course_language') : __('English', 'histudy');

 
/**
 * Course sidebar redux
 */

$rainbow_course_details_card_video_thumbnail_show       = $rainbow_course_details_settings['rainbow_course_details_card_video_thumbnail_show'];
$rainbow_course_details_card_price_show                 = $rainbow_course_details_settings['rainbow_course_details_card_price_show'];
// $rainbow_course_details_card_progress_show              = $rainbow_course_details_settings['rainbow_course_details_card_progress_show'];
$rainbow_course_details_card_mony_back_badge_show       = $rainbow_course_details_settings['rainbow_course_details_card_mony_back_badge_show'];
$rainbow_course_details_card_last_udpate_show           = $rainbow_course_details_settings['rainbow_course_details_card_last_udpate_show'];
$rainbow_course_details_card_enrolled_show              = $rainbow_course_details_settings['rainbow_course_details_card_enrolled_show'];
$rainbow_course_details_lecture_count_show              = $rainbow_course_details_settings['rainbow_course_details_lecture_count_show'];
$rainbow_course_details_skill_level_show                = $rainbow_course_details_settings['rainbow_course_details_skill_level_show'];
$rainbow_course_details_language_show                   = $rainbow_course_details_settings['rainbow_course_details_language_show'];
// $rainbow_course_details_quizzes_show                    = $rainbow_course_details_settings['rainbow_course_details_quizzes_show'];
$rainbow_course_details_card_duration_show              = $rainbow_course_details_settings['rainbow_course_details_card_duration_show']; 
$rainbow_course_details_card_tags_show                  = $rainbow_course_details_settings['rainbow_course_details_card_tags_show']; 
$rainbow_course_details_sidebar_social_box              = $rainbow_options['rainbow_course_details_sidebar_social_box'];

$rainbow_course_details_card_social_link                = isset($rainbow_options['rainbow_course_details_card_social_link']) ? $rainbow_options['rainbow_course_details_card_social_link'] : ''; 
$enable_course_details_sidebar_show_more                = isset($rainbow_course_details_settings['enable_course_details_sidebar_show_more']) ? $rainbow_course_details_settings['enable_course_details_sidebar_show_more'] : 0;
$sidebar_show_more_text                                 = isset($rainbow_options['sidebar_show_more_text']) ? $rainbow_options['sidebar_show_more_text'] : ''; 
$money_back_text                                        = isset($rainbow_options['money_back_text']) ? $rainbow_options['money_back_text'] : ''; 

$rainbow_course_details_card_contact_label              = $rainbow_course_details_settings['rainbow_course_details_card_contact_label'];
$rainbow_course_details_card_contact_number_before_text = $rainbow_course_details_settings['rainbow_course_details_card_contact_number_before_text'];
$rainbow_course_details_card_contact_number_link        = $rainbow_course_details_settings['rainbow_course_details_card_contact_number_link'];
$image_size                                             = isset($rainbow_options['rainbow_course_details_img_size']) ? sanitize_text_field($rainbow_options['rainbow_course_details_img_size']) : 'full';


$course_layout_class = '';
$rainbow_course_details_layout = isset($rainbow_options['rainbow_course_details_layout']) ? $rainbow_options['rainbow_course_details_layout'] : '';

if (!empty(get_query_var('course_single_layout'))) {
    $rainbow_course_details_layout = get_query_var('course_single_layout');
}
$course_layout_class = ($rainbow_course_details_layout == 'layout-3' || $rainbow_course_details_layout == 'layout-6') ? 'course--single-layout-three' : '';
$selling_option = '';
  
$is_logged_in       = is_user_logged_in();
$user_id            = get_current_user_id();
// buy now button
$course_attributes      = get_post_meta($course_id);
$product_id = Academy\Helper::get_course_product_id( $course_id );  
$redirect_url = '';
if ( class_exists( 'WooCommerce' ) ) { 
$redirect_url = wc_get_checkout_url();
                } 

 
?>

<div class="course-sidebar sticky-top rbt-shadow-box course-sidebar-top rbt-gradient-border <?php echo esc_attr($course_layout_class); ?>">
    <div class="inner">  
        <!-- Start Viedo Wrapper  -->
        <?php if(1 == $rainbow_course_details_card_video_thumbnail_show) : ?> 
            <?php get_template_part('template-parts/components/popups/course-intro-video', 'card');  ?>  
        <?php endif; ?>
        <!-- End Viedo Wrapper  --> 
        <div class="content-item-content">  
            <?php if(1 == $rainbow_course_details_card_price_show): ?>
                <div class="rbt-price-wrapper text-center mb-3">
                    <?php get_template_part('template-parts/components/price/layout', 1); ?>  
                </div>  
            <?php endif; ?>
            
            <?php academy_course_enroll_form(); ?>
            <!-- Button -->
             
           <?php 
            if(1 == $rainbow_course_details_card_mony_back_badge_show) { 
            if (!empty($money_back_text)) { ?>
               <span class="subtitle"><i class="feather-rotate-ccw"></i> <?php echo esc_html($money_back_text); ?></span>
           <?php }} ?> 
            <?php
     		 $duration       = \Academy\Helper::get_course_duration( $course_id );
             $total_lessons  = \Academy\Helper::get_total_number_of_course_lesson( $course_id );
             $total_enroll_count_status = \Academy\Helper::get_settings( 'is_enabled_course_single_enroll_count', true ); 
             $skill          = \Academy\Helper::get_course_difficulty_level( $course_id );
             $language       = get_post_meta( $course_id, 'academy_course_language', true );
             $max_students   = (int) get_post_meta( $course_id, 'academy_course_max_students', true );
             $last_update    = get_the_modified_time( get_option( 'date_format' ), $course_id );
            ?>
           <div class="rbt-widget-details has-show-more">
                <ul class="has-show-more-inner-content rbt-course-details-list-wrapper">
                    <?php if(1 == $rainbow_course_details_card_duration_show) : ?> 
                        <?php if ( $duration ) : ?>
                            <li>
                                <span>
                                    <i class="academy-icon academy-icon--clock"></i>
                                <?php esc_html_e( 'Duration', 'histudy' ); ?>
                                </span>
                                <span class="rbt-feature-value rbt-badge-5"><?php echo esc_html( $duration ); ?></span>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                    <?php 
                        if(1 == $rainbow_course_details_lecture_count_show) :
                        if ( $total_lessons ) : ?>
                        <li>
                            <span>
                                <i class="academy-icon academy-icon--lesson"></i>
                            <?php esc_html_e( 'Lessons', 'histudy' ); ?>
                            </span>
                            <span class="rbt-feature-value rbt-badge-5"><?php echo esc_html( $total_lessons ); ?></span>
                        </li>
                    <?php endif; endif;?>

                    <?php if ( $total_enrolled && $total_enroll_count_status ) : ?>
                        <li>
                            <span>
                                <i class="academy-icon academy-icon--group-profile"></i>
                            <?php esc_html_e( 'Enrolled', 'histudy' ); ?>
                            </span>
                            <span class="rbt-feature-value rbt-badge-5"><?php echo esc_html( $total_enrolled ); ?></span>
                        </li>
                    <?php endif; ?>
                    
                    <?php 
                        if(1 == $rainbow_course_details_language_show) :  
                        if ( $language ) : ?>
                        <li>
                            <span>
                                <i class="academy-icon academy-icon--language"></i>
                            <?php esc_html_e( 'Language', 'histudy' ); ?>
                            </span>
                            <span class="rbt-feature-value rbt-badge-5"><?php echo esc_html( $language ); ?></span>
                        </li>
                    <?php endif; endif; ?>

                    <?php 
                        if(1 == $rainbow_course_details_skill_level_show) :  
                        if ( $skill ) : ?>
                        <li>
                            <span>
                                <i class="academy-icon academy-icon--skill"></i>
                            <?php esc_html_e( 'Skill', 'histudy' ); ?>
                            </span>
                            <span class="rbt-feature-value rbt-badge-5"><?php echo esc_html( $skill ); ?></span>
                        </li>
                    <?php endif; endif; ?>

                    <?php 
                        if(1 == $rainbow_course_details_card_enrolled_show) :   
                        if ( $max_students ) : ?>
                        <li>
                            <span>
                                <i class="academy-icon academy-icon--group-profile"></i>
                            <?php esc_html_e( 'Available Seats', 'histudy' ); ?>
                            </span>
                            <span class="rbt-feature-value rbt-badge-5"><?php echo esc_html( max( $max_students - $total_enrolled, 0 ) ); ?></span>
                        </li>
                    <?php endif; endif; ?>

                    <?php  
                        if(1 == $rainbow_course_details_card_last_udpate_show) :
                        if ( $last_update ) : ?>
                        <li>
                            <span>
                                <i class="academy-icon academy-icon--calender"></i>
                            <?php esc_html_e( 'Last Update', 'histudy' ); ?>
                            </span>
                            <span class="rbt-feature-value rbt-badge-5"><?php echo esc_html( $last_update ); ?></span>
                        </li>
                    <?php endif; endif; ?>
                </ul> 
                <?php if($enable_course_details_sidebar_show_more ) : ?>
                    <div class="rbt-show-more-btn"><?php echo esc_html( $sidebar_show_more_text ) ?></div> 
                <?php endif; ?>     
                
            </div>  
            <!-- rbt-widget-details -->

            <?php if (1 == $rainbow_course_details_sidebar_social_box) : ?>
               <div class="social-share-wrapper mt--30 text-center">
                   <?php if (1 == $rainbow_course_details_card_social_link) : ?>
                        <div class="rbt-post-share d-flex align-items-center justify-content-center"> 
                            <ul class="social-icon social-default transparent-with-border justify-content-center mb--20"> 
                                <?php if (!empty($facebookShareUrl)) : ?>
                                    <li><a target="_blank" href="<?php echo esc_url($facebookShareUrl); ?>"> <i class="feather-facebook"></i> </a> </li>
                                <?php endif; ?> 
                                <?php if (!empty($twitterShareUrl)) : ?>
                                    <li><a target="_blank" href="<?php echo esc_url($twitterShareUrl); ?>"> <i class="feather-twitter"></i> </a> </li>
                                <?php endif; ?> 
                                <?php if (!empty($linkedInShareUrl)) : ?>
                                    <li><a target="_blank" href="<?php echo esc_url($linkedInShareUrl); ?>"> <i class="feather-linkedin"></i> </a> </li>
                                <?php endif; ?> 
                            </ul> 
                            <!-- social-icon -->
                        </div>
                        <!-- rbt-post-share -->
                   <?php endif; ?>
                   <hr class="">
                   <div class="contact-with-us text-center">
                       <?php if (!empty($rainbow_course_details_card_contact_label)) : ?>
                           <p><?php echo esc_html($rainbow_course_details_card_contact_label); ?></p>
                       <?php endif; ?>
                        <p class="rbt-badge-2 mt--10 justify-content-center w-100"><i class="feather-phone mr--5"></i>
                           <?php if (!empty($rainbow_course_details_card_contact_number_before_text)) : ?>
                               <?php echo esc_html($rainbow_course_details_card_contact_number_before_text); ?>
                           <?php endif; ?>
                           <a href="tel: <?php echo esc_attr($rainbow_course_details_card_contact_number_link) ? esc_attr($rainbow_course_details_card_contact_number_link) : '#0'; ?>">
                                <strong><?php echo esc_html($rainbow_course_details_card_contact_number_link); ?></strong>
                           </a>
                        </p>
                   </div>
                   <!-- contact-with-us -->
               </div>
               <!-- social-share-wrapper -->
            <?php endif; ?>
           <!-- social-share-wrapper --> 
            <?php
            //echo academy_render_prerequisite_tags();
            ?>
        </div>
    </div>
</div>