 <?php  
    $course_id = get_the_ID(); 

    $output = '';
    $intro_video =  get_post_meta( $course_id, 'academy_course_intro_video', true ); 
     
    if ( is_array($intro_video) && isset($intro_video[1]) ) {
        $embed = Academy\Helper::get_basic_url_to_embed_url( $intro_video[1] );
    } else {
        $embed = ''; // or a fallback URL or message
    }  

    $rainbow_course_details_settings  = Rainbow_Helper::rainbow_course_details_settings();   
    $rainbow_course_details_layout = $rainbow_course_details_settings['rainbow_course_details_layout'];
    $sidebar_class = 
        ($rainbow_course_details_layout === 'layout-1') ? 'sidebar-video-hidden' :
        (($rainbow_course_details_layout === 'layout-2') ? '' : '');



    $thumbnail_url = Academy\Helper::get_the_course_thumbnail_url_by_id( $course_id );
    if ( $intro_video && is_array( $intro_video ) && count( $intro_video ) > 1 && ! empty( $intro_video[1] ) ) {
        $type = $intro_video[0]; 
        if ( 'html5' === $type ) {  
            $attachment_id = (int) $intro_video[1];
            $att_url       = wp_get_attachment_url( $attachment_id ); // Get actual video URL  
            ?>
            <a class="video-popup-with-text video-popup-wrapper text-center popup-video <?php echo esc_attr( $sidebar_class )  ?> mb--15" href="<?php echo esc_url( $att_url ); ?>">
                <div class="video-content"> 
                    <?php if ( $thumbnail_url ) { ?> 
                        <img class="w-100 rbt-radius" src="<?php echo esc_url( $thumbnail_url ); ?>" alt="<?php echo esc_attr__( 'Course Intro Video', 'histudy' ); ?>">
                    <?php } else {
                        echo get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); 
                    } ?>   
        
                    <div class="position-to-top">
                        <span class="rbt-btn rounded-player-2 with-animation">
                            <span class="play-icon"></span>
                        </span>
                    </div>
                    <span class="play-view-text d-block color-white"><i class="feather-eye"></i> <?php echo esc_html__( 'Preview this course', 'histudy' ); ?></span>  
                </div> 
            </a>
            <?php 
        } elseif ( 'embedded' === $type ) { 
         // Extract the src from the iframe string
            if ( preg_match( '/src="([^"]+)"/', $intro_video[1], $matches ) ) {
                $embed_url = $matches[1];
        
                // Check if it's a YouTube embed and convert it to watch URL
                if ( preg_match( '/youtube\.com\/embed\/([a-zA-Z0-9_-]+)/', $embed_url, $id_matches ) ) {
                    $video_id = $id_matches[1];
                    $embed_url = 'https://www.youtube.com/watch?v=' . esc_html( $video_id );
                } else {
                    // Just print the embed URL if not YouTube
                    $embed_url;
                }
            } else {
                echo 'Invalid iframe format';
            } 
            ?>   
            <a class="video-popup-with-text video-popup-wrapper text-center popup-video sidebar-video-hidden mb--15" href="<?php echo esc_url( $embed_url ); ?>">
                <div class="video-content"> 
                    <?php if ( $thumbnail_url ) { ?> 
                        <img class="w-100 rbt-radius" src="<?php echo esc_url( $thumbnail_url ); ?>" alt="<?php echo esc_attr__( 'Course Intro Video', 'histudy' ); ?>">
                    <?php } else {
                        echo get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); 
                    } ?>   
        
                    <div class="position-to-top">
                        <span class="rbt-btn rounded-player-2 with-animation">
                            <span class="play-icon"></span>
                        </span>
                    </div>
                    <span class="play-view-text d-block color-white"><i class="feather-eye"></i> <?php echo esc_html__( 'Preview this course', 'histudy' ); ?></span>  
                </div> 
            </a>
            <?php
        } elseif (  'vimeo' === $type ) {?>
            <a class="video-popup-with-text video-popup-wrapper text-center popup-video sidebar-video-hidden mb--15" href="<?php echo esc_url( $intro_video[1] ); ?>">
                <div class="video-content"> 
                 <!-- Check if there is a thumbnail and display it -->
                    <?php 
                    if ( $thumbnail_url ) { ?> 
                        <img class="w-100 rbt-radius" src="<?php echo esc_url( $thumbnail_url );?>" alt="<?php echo esc_attr__( 'Course Intro Video', 'histudy' ); ?>">
                        <?php 
                    } else {
                        echo get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); 
                    }
                    ?>   
                    <div class="position-to-top">
                        <span class="rbt-btn rounded-player-2 with-animation">
                            <span class="play-icon"></span>
                        </span>
                    </div>
                    <span class="play-view-text d-block color-white"><i class="feather-eye"></i> <?php echo esc_html__( 'Preview this course', 'histudy' ); ?></span>  
                </div> 
                <!-- video-content -->
            </a>
            <?php 
        }
        elseif ( 'youtube' === $type || 'external'  === $type ) {; ?>
            <a class="video-popup-with-text video-popup-wrapper text-center popup-video sidebar-video-hidden mb--15" href="<?php echo esc_url( $intro_video[1] ); ?>">
                <div class="video-content"> 
                 <!-- Check if there is a thumbnail and display it -->
                    <?php 
                    if ( $thumbnail_url ) { ?> 
                        <img class="w-100 rbt-radius" src="<?php echo esc_url( $thumbnail_url );?>" alt="<?php echo esc_attr__( 'Course Intro Video', 'histudy' ); ?>">
                        <?php 
                    } else {
                        echo get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); 
                    }
                    ?>   
                    <div class="position-to-top">
                        <span class="rbt-btn rounded-player-2 with-animation">
                            <span class="play-icon"></span>
                        </span>
                    </div>
                    <span class="play-view-text d-block color-white"><i class="feather-eye"></i> <?php echo esc_html__( 'Preview this course', 'histudy' ); ?></span>  
                </div> 
                <!-- video-content -->
            </a>
            <?php
        }
        elseif ( 'shortcode' === $type ) {
            $output .= do_shortcode( $intro_video[1] );
        } else {
            $embed = Academy\Helper::get_basic_url_to_embed_url( $intro_video[1] );
            $output .= sprintf( '<div class="academy-embed-responsive academy-embed-responsive-16by9"><iframe class="academy-embed-responsive-item" src="%s" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>', esc_url( $embed['url'] ) );
        }//end if
    } 
    echo esc_html( $output );

        ?>   