<?php 
$rainbow_options = Rainbow_Helper::rainbow_get_options();
$rainbow_event_breadcrumb_enable =  sanitize_text_field( $rainbow_options['rainbow_event_breadcrumb_enable'] );
$rainbow_event_title_text =  sanitize_text_field( $rainbow_options['rainbow_event_title_text'] );
$rainbow_event_desc_text =  sanitize_text_field( $rainbow_options['rainbow_event_desc_text'] );
$allowed_tags = wp_kses_allowed_html('post');
$rainbow_event_archive_banner = isset( $rainbow_options['rainbow_event_archive_banner_layout'] ) ? $rainbow_options['rainbow_event_archive_banner_layout']: 'layout-1';
$count = $GLOBALS['wp_query']->post_count;
$rainbow_event_archive_overlap = isset( $rainbow_options['rainbow_event_archive_overlap'] ) ? $rainbow_options['rainbow_event_archive_overlap']: 0;
if( 1 == $rainbow_event_archive_overlap ) {
    $overlap_class = '';
} else {
    $overlap_class = 'rbt-event-overlap-none';
}
?>
<?php if($rainbow_event_breadcrumb_enable == 'yes') {
    if( 'layout-2' === $rainbow_event_archive_banner ) {
        ob_start();?>
        <div class="rbt-page-banner-wrapper <?php echo esc_attr( $overlap_class ); ?>">
            <!-- Start Banner BG Image  -->
            <div class="rbt-banner-image"></div>
                <!-- End Banner BG Image  -->
                <div class="rbt-banner-content">
                    <!-- Start Banner Content Top  -->
                    <div class="rbt-banner-content-top">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-12">
                                    <!-- Start Breadcrumb Area  -->
                                    <?php rainbow_breadcrumbs(); ?>
                                    <!-- End Breadcrumb Area  -->

                                    <div class=" title-wrapper">
                                        <h1 class="title mb--0">
                                            <?php 
                                            if(!empty($rainbow_event_title_text)) { 
                                                echo wp_kses( $rainbow_event_title_text, $allowed_tags ); 
                                            } else {  
                                                echo  wp_kses(Rainbow_Helper::rainbow_get_page_title(),$allowed_tags); 
                                            }
                                            ?>
                                        </h1>
                                        <a href="#" class="rbt-badge-2">
                                            <div class="image">🎉</div> <?php echo absint($count); ?> <?php echo esc_html__('Events', 'histudy'); ?>
                                        </a>
                                    </div>
                                    <p class="description"><?php echo wp_kses( $rainbow_event_desc_text, $allowed_tags ); ?> </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End Banner Content Top  -->
                </div>
            </div>
            <?php echo ob_get_clean(); } else {
        ob_start();?>
        <div class="rbt-breadcrumb-default ptb--100 ptb_md--50 ptb_sm--30 bg-gradient-1">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="breadcrumb-inner text-center">
                            <h2 class="title">
                                <?php 
                                    if(!empty($rainbow_event_title_text)) { 
                                        echo wp_kses( $rainbow_event_title_text, $allowed_tags ); 
                                    } else {  
                                        echo  wp_kses(Rainbow_Helper::rainbow_get_page_title(),$allowed_tags); 
                                    }
                                ?>
                            </h2>
                            <?php rainbow_breadcrumbs(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo ob_get_clean();
    }
}