<?php
    $locations = get_the_terms(get_the_ID(), 'event_location');
    $first_location = '';
    $rainbow_options = Rainbow_Helper::rainbow_get_options();
    $event_btn_label = isset($rainbow_options['rainbow_event_archive_btn_label']) ? $rainbow_options['rainbow_event_archive_btn_label']: '';
    if ($locations && !is_wp_error($locations) && count($locations) > 0) {
        // Get the first location
        $first_location = array_shift($locations)->name;
        
    } 

    $additional_attributes = rainbow_get_acf_data( 'additional_attributes' );
    $schedule = rainbow_get_acf_data( 'schedule' );
    
    $start_time = '';
    $end_time = '';
    if(!empty($additional_attributes)) {
        $additional_attributes = array_shift($additional_attributes);
        $start_time = $additional_attributes['start_time'];
        $end_time = $additional_attributes['end_time'];
        $full_address = $additional_attributes ? $additional_attributes['location']: '';
    }
   // $date = '';

    if (!empty($schedule)) {
        $schedule_attributes = array_shift($schedule);

        if (!empty($schedule_attributes['insert_event_day'][0]['event_date'])) {
            $date = $schedule_attributes['insert_event_day'][0]['event_date'];
        }
    }

    if (empty($date)) {
        $date = date('Y-m-d'); 
    }

    $timestamp = strtotime(str_replace('/', '-', $date));

    if ($timestamp !== false) {
        $day_month = date("d M", $timestamp);
        $year = date("Y", $timestamp);
    } 


    
?>
<div class="rbt-card event-grid-card variation-01 rbt-hover">
    <div class="rbt-card-img">
        <a href="<?php the_permalink(); ?>">
            <?php the_post_thumbnail(); ?>
            <?php if ( !empty($schedule) && !empty($schedule_attributes['insert_event_day'][0]['event_date'])) { ?>
            <div class="rbt-badge-3 bg-white">
                <span><?php echo wp_kses_post( $day_month ); ?></span>
                <span><?php echo wp_kses_post( $year ); ?></span>
            </div>
            <?php } ?>
        </a>
    </div>
    <div class="rbt-card-body">
        <ul class="rbt-meta">
            <?php if(!empty($first_location)) : ?>
                <li><i class="feather-map-pin"></i>
                <?php
                if(!empty($full_address)) {
                    echo esc_html($full_address); 
                } else {
                    echo esc_html($first_location);
                }
                 
                ?>
            </li>
            <?php endif; ?>
            <?php if(!empty($start_time) || !empty($end_time)) : ?>
                <li><i class="feather-clock"></i><?php echo esc_html($start_time); ?> -<?php echo esc_html($end_time); ?></li>
            <?php endif; ?>
        </ul>
        <h4 class="rbt-card-title"><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h4>
        <?php if(!empty($event_btn_label)) : ?>
        <div class="read-more-btn">
            <a class="rbt-btn btn-border hover-icon-reverse btn-sm radius-round" href="<?php echo esc_url(get_the_permalink()); ?>">
                <span class="icon-reverse-wrapper">
                    <span class="btn-text"><?php echo esc_html( $event_btn_label ); ?></span>
                    <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                    <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                </span>
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>