<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


	$column_per_row = (array) Academy\Helper::get_settings( 'course_archive_courses_per_row', array(
		'desktop' => 3,
		'tablet' => 2,
		'mobile' => 1,
	));

	$rainbow_options = Rainbow_Helper::rainbow_get_options();

	$course_view = isset( $_GET['view'] ) ? $_GET['view'] : '';
	$course_masonary = isset( $_GET['course_masonary'] ) ? $_GET['course_masonary'] : '';

	$card_list = [];

	$card_layout = isset( $_GET['card_layout'] ) ? $_GET['card_layout'] : '';
    if( !empty( $card_layout)) {
        $rainbow_academy_card_layout = $card_layout;
    } else {
        $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';
    }

	if ( in_array( $rainbow_academy_card_layout, [ 'layout-3', 'layout-4' ] ) || $course_masonary == 'yes') {
		$card_list[] = 'card-list-2';
	}

	if ( in_array( $rainbow_academy_card_layout, [ 'layout-5' ] ) ) {
		$card_list[] = 'elegant-course';
	}

	if ( $rainbow_academy_card_layout === 'layout-4' ) {
		$card_list[] = ' elegant-course';
	}

	$class_attr = implode( ' ', $card_list );

	$grid_class = ! empty( $grid_class ) ? $grid_class : Academy\Helper::get_responsive_column( $column_per_row );
	?>
<div class="<?php echo esc_attr( $grid_class ); ?> course-grid-3">
	<div class="academy-course rbt-card variation-01 rbt-hover <?php echo esc_attr($class_attr); ?>">
		<?php
			do_action( 'academy/templates/before_course_loop' );
			/**
			 * @hook - academy/templates/course_loop_header
			 *
			 * @Hooked - academy_course_loop_header - 10
			 */
			 do_action( 'academy/templates/course_loop_header' );
			/**
			 * @hook - academy/templates/course_loop_content
			 *
			 * @Hooked - academy_course_loop_content - 11
			 */
			do_action( 'academy/templates/course_loop_content' );
			/**
			 * @hook - academy/templates/course_loop_footer
			 *
			 * @Hooked - academy_course_loop_footer - 12
			 */
			do_action( 'academy/templates/course_loop_footer' );
			do_action( 'academy/templates/after_course_loop_item' );
		?>
	</div>
</div>