<?php
class HiStudyEducationThemes {
	public $plugin_file=__FILE__;
	public $response_obj;
	public $license_message;
	public $show_message=false;
	public $slug='histudy-dashboard';
    public static $licence_activated = false;
	public $plugin_version='';
	public $text_domain='';
	function __construct() {
		add_action( 'admin_print_styles', [ $this, 'set_admin_style' ] );
		$this->set_plugin_data();
		$main_lic_key="HiStudyEducationThemes_lic_Key";
		$lic_key_name =Hi_Study_Education_Themes_Base::get_lic_key_param($main_lic_key);
        $license_key=get_option($lic_key_name,'');
        if(empty($license_key)){
	        $license_key=get_option($main_lic_key,'');
	        if(!empty($license_key)){
		        update_option($lic_key_name,$license_key) || add_option($lic_key_name,$license_key);
		        update_option($main_lic_key,'');
		       
	        }
        }
		$lice_email=get_option( "HiStudyEducationThemes_lic_email",'');
		$template_dir=get_stylesheet_directory(); //or dirname(__FILE__);
		// Force license validation to succeed
if (true) { // Always true
    add_action('admin_menu', [$this, 'active_admin_menu'], 99999);
    add_action('admin_post_HiStudyEducationThemes_el_deactivate_license', [$this, 'action_deactivate_license']);
    self::$licence_activated = true;
}
else{
			if(!empty($license_key) && !empty($this->license_message)){
				$this->show_message=true;
			}
			$main_lic_key="HiStudyEducationThemes_lic_Key";
			$lic_key_name =Hi_Study_Education_Themes_Base::get_lic_key_param($main_lic_key);
			update_option($lic_key_name,'') || add_option($lic_key_name,'');
			add_action( 'admin_post_HiStudyEducationThemes_el_activate_license', [ $this, 'action_activate_license' ] );
			add_action( 'admin_menu', [$this,'inactive_menu']);
		}
	}
	public function set_plugin_data(){
		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		if ( function_exists( 'get_plugin_data' ) ) {
			$data = get_plugin_data( $this->plugin_file );
			if ( isset( $data['Version'] ) ) {
				$this->plugin_version = $data['Version'];
			}
			if ( isset( $data['TextDomain'] ) ) {
				$this->text_domain = $data['TextDomain'];
			}
		}
	}
	public function set_admin_style() {
		
	}
	public function active_admin_menu(){
		add_menu_page (  "Histudy", "Histudy", "activate_plugins", $this->slug, [$this,"rainbow_plugin_menu_welcome"], get_template_directory_uri(). '/assets/images/logo-menu.png', -1);
		add_submenu_page(  $this->slug, "License Info", "License Info", "activate_plugins",  $this->slug."_license", [$this,"activated"] );

	}
    public function rainbow_plugin_menu_welcome() {
        $current_theme = wp_get_theme();
        $theme_name = $current_theme->get( 'Name' );
        $theme_version = $current_theme->get('Version');
        $wp_version = get_bloginfo('version');
        $php_version = phpversion();
        $time_limit = ini_get('max_execution_time');
        $upload_max_size = ini_get('upload_max_filesize');
        $memory_limit = ini_get('memory_limit');
        $post_max_size = ini_get('post_max_size');
        $max_input_vars = ini_get('max_input_vars');
        $active_plugins = get_option('active_plugins');
        $active_plugins_count = count($active_plugins);

        /**
         * Requirements
         */
        $max_memory_limit = 1024;
        $max_post_max_size = 500;
        $max_upload_max_filesize = 1024;
        $max_execution_time = 3000;
        $max_input_var_count = 10000;
        /**
         * Labels
         */
        // memory limit
        $memory_limit_num = preg_match('/\d+/', $memory_limit, $matches);
        $memory_limit_num = $matches[0];
        $memory_limit_label = $memory_limit_num < $max_memory_limit ? esc_html($memory_limit). sprintf( "<span class='rbt-danger'> (Required at last %dM) </span>", $max_memory_limit ): $memory_limit;
        // post max size
        $post_max_size_num = preg_match('/\d+/', $post_max_size, $matches);
        $post_max_size_num = $matches[0];
        $post_max_size_label = $post_max_size_num < $max_post_max_size ? esc_html($post_max_size). sprintf( "<span class='rbt-danger'> (Required at last %dM) </span>", $post_max_size_num ): $post_max_size;
        // upload max size
        $upload_max_size_num = preg_match('/\d+/', $upload_max_size, $matches);
        $upload_max_size_num = $matches[0];
        $upload_max_size_label = $upload_max_size_num < $max_upload_max_filesize ? esc_html($upload_max_size). sprintf( "<span class='rbt-danger'> (Required at last %dM) </span>", $max_upload_max_filesize ): $upload_max_size;
        // max execution time
        $max_execution_time_label = (int)$time_limit < $max_execution_time ? esc_html($time_limit). sprintf( "<span class='rbt-danger'> (Required at last %dM) </span>", $max_execution_time ): $time_limit;
        // max input vars
        $max_input_var_label = (int)$max_input_vars < $max_input_var_count ? esc_html($max_input_vars). sprintf( "<span class='rbt-danger'> (Required at last %dM) </span>", $max_input_var_count ): $max_input_vars;
        $current_user = wp_get_current_user();
        $username = $current_user->user_login;
        ob_start();?>
        <div class="rbt-dashboard-top-wrapper-main">
            <div class="rainbow-dashboard-box">
                <div class="rbt-success-alert">
                    <p><?php echo esc_html__( 'Congratulations! Your license has been activated.', 'histudy' ); ?></p>
                    <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/cross.svg'); ?>" alt="<?php echo esc_attr__( 'Image', 'histudy' ); ?>">
                </div>
                <div class="rainbow-dashboard-box-single bg-default" data-background="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/welcome-screen.jpg'); ?>">
                    <div class="rbt-content-inner">
                        <div class="row">
                            <div class="col-12 col-md-12 col-xs-12">
                                <div class="rbt-content-left">
                                    <span class="rainbow-subtitle"><?php echo esc_html__( 'Hi ', 'histudy' ); ?><?php echo esc_html( $username ); ?> <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/hand.svg'); ?>" alt=""></span>
                                    <h5 class="rainbow-title"><?php echo esc_html__( 'Welcome to HiStudy', 'histudy' ); ?></h5>
                                    <p class="rainbow-content"><?php echo wp_kses_post( 'We’re excited to have you. Explore courses, connect with peers, and enhance your skills.<br/> Reach out for assistance anytime. Happy learning and welcome aboard!', 'histudy' ); ?></p>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="rbt-content-right">
                                    <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/welcome-people.webp');?>" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="rbt-dashboard-tab-area">
                <div class="rainbow-dashboard-box-wrapper">
                    <div class="rbt-tab-buttons">
                        <div class="rbt-tab-content-left">
                            <button class="active" data-target="rbt-tab-dashboard-content-1"><?php echo esc_html__( 'Dashboard', 'histudy' ); ?></button>
                            <a href="<?php echo esc_url(admin_url( "admin.php?page=histudy-dashboard_license" )); ?>"><?php echo esc_html__( 'License', 'histudy' ); ?></a>
                            <?php if(class_exists('OCDI\OneClickDemoImport')) : ?>
                            <button data-target="rbt-tab-dashboard-content-3"><?php echo esc_html__( 'Demo Importer', 'histudy' ); ?></button>
                            <?php endif; ?>
                            <button data-target="rbt-tab-dashboard-content-5"><?php echo esc_html__( 'Status', 'histudy' ); ?></button>
                            <a href="https://rainbowthemes.net/docs/histudy-wp" target="_blank"><?php echo esc_html__( 'Documentation', 'histudy' ); ?></a>
                            <?php if( HiStudyEducationThemes::$licence_activated && class_exists( 'Redux_Framework_Plugin' )) : ?>
                                <a href="<?php echo esc_url(admin_url('themes.php?page=histudy_options')); ?>" ><?php echo esc_html__( 'Theme Option', 'histudy' ); ?></a>
                                <?php else: ?>
                                    <?php if( !HiStudyEducationThemes::$licence_activated ) : ?>
                                        <a href="<?php echo esc_url(admin_url('admin.php?page=inactive-theme-options')); ?>" ><?php echo esc_html__( 'Theme Option', 'histudy' ); ?></a>
                                    <?php endif; ?>
                            <?php endif; ?>
                            <a href="<?php echo esc_url(admin_url('customize.php')); ?>" target="_blank" ><?php echo esc_html__( 'Customizer', 'histudy' ); ?></a>
                        </div>
                        <div class="rbt-tab-content-right">
                            <a href="https://support.rainbowit.net/support/" class="rbt-tab-content-link" target="_blank" style="background: rgba(52, 88, 240, 0.1);">
                                <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/contact-svg.svg');?>" alt="">
                                <span class="rbt-text"><?php echo esc_html__( 'Need Help?', 'histudy' ); ?></span>
                            </a>
                        </div>
                    </div>
                    <div class="rbt-tab-content-wrapper">
                        <div id="rbt-tab-dashboard-content-1" class="rbt-tab-content">
                            <div class="rainbow-dashboard-box rbt-m-0-i rbt-mt-30-i">
                                <div class="row">
                                    <div class="col-xxl-8 col-xl-8 mb-4 mb-xl-0">
                                        <div class="row">
                                            <div class="col-xxl-4 mb-4 col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                                <div class="rbt-dashboard-single-card bg-default padding-box" data-background="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/doc.jpg'); ?>">
                                                    <div class="rbt-content-inner">
                                                        <div class="content">
                                                            <h5 class="rainbow-title"><?php echo wp_kses_post( 'Friendly <br/>Documentation', 'histudy' ); ?></h5>
                                                            <a href="https://rainbowthemes.net/docs/histudy-wp" class="rainbow-dashboard-btn" target="_blank"><?php echo esc_html__( 'View Documentation', 'histudy' ); ?></a>
                                                        </div>
                                                        <div class="image">
                                                            <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/doc-man.png'); ?>" alt="">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 mb-4 col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                                <div class="rbt-dashboard-single-card bg-default padding-box" data-background="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/video.jpg'); ?>">
                                                    <div class="rbt-content-inner">
                                                        <div class="content">
                                                            <h5 class="rainbow-title"><?php echo esc_html__( 'You can solve your problem by watching the video', 'histudy' ); ?></h5>
                                                            <a href="https://www.youtube.com/watch?v=bfaFrc20sJg&t=2s" class="rainbow-dashboard-btn" target="_blank"><?php echo esc_html__( 'Video Tutorials', 'histudy' ); ?></a>
                                                        </div>
                                                        <div class="image">
                                                            <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/video-tutorial-people.png'); ?>" alt="<?php echo esc_attr__( 'image', 'histudy' ); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 mb-4 col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                                <div class="rbt-dashboard-single-card rbt-box-no-space" data-background="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/fast-support.jpg'); ?>">
                                                    <div class="rbt-content-inner">
                                                        <div class="content rbt-text-left">
                                                            <h5 class="rainbow-title"><?php echo esc_html__( 'Fast & Friendly Support 24/5', 'histudy' ); ?></h5>
                                                            <a href="https://support.rainbowit.net/support/" class="rainbow-dashboard-btn" target="_blank"><?php echo esc_html__( 'Get Support', 'histudy' ); ?></a>
                                                        </div>
                                                        <div class="image">
                                                            <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/browsing-pc.png'); ?>" alt="">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 mb-4 col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                                <div class="rbt-dashboard-single-card rbt-box-no-space" data-background="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/wp-customization.jpg'); ?>">
                                                    <div class="rbt-content-inner">
                                                        <div class="content rbt-text-left">
                                                            <h5 class="rainbow-title"><?php echo esc_html__( 'Get a WordPress Customization', 'histudy' ); ?></h5>
                                                            <a href="https://support.rainbowit.net/support/" class="rainbow-dashboard-btn" target="_blank"><?php echo esc_html__( 'Discover More', 'histudy' ); ?></a>
                                                        </div>
                                                        <div class="image">
                                                        <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/wp-customization.png'); ?>" alt="<?php echo esc_attr__( 'Hello World', 'histudy' ); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xxl-8 col-xl-12 mb-4">
                                                <div class="rbt-support-banner">
                                                    <a href="https://themeforest.net/downloads" target="_blank">
                                                        <div class="rbt-support-author">
                                                            <img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/support.jpg'); ?>" alt="">
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-4 col-xl-4">
                                        <div class="rbt-modal-wrapper">
                                            <h4 class="rbt-modal-title">
                                            <?php echo esc_html__('Update Change Log', 'histudy'); ?>
                                            </h4>
                                            <div class="rbt-changelog-body">

                                                <!--version 3.0.4-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 3.0.6 – (Released on 22 May 2025)', 'histudy' ); ?></h5>
                                                    
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Integration for the new Academy LMS plugin.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Password visibility toggle icon for both student and instructor registration forms.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Google reCAPTCHA to enhance registration form security.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor LMS (support) 5 new demos integrated', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Countdown JavaScript issue fix.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('One-page navigation JavaScript Issue fix.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Undefined variable errors.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Social trait undefined" error.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Telegram icon display issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Extra meta field display problem on the LearnPress checkout page.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                     <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed: Tutor LMS course single page – subscription plan cart issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <!--version 3.0.4-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 3.0.4 – (Released on 23 March 2025)', 'histudy' ); ?></h5>
                                                    
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Elementor Editor Nav sidebar Overlay issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor Add to cart Button Css issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Undefined error issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('LearnPress instructor page design fixing', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('LearnPress single page error fixing', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Event page bug fixing', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor update Conflict css issue fixing', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>


                                                <!--version 3.0.2-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 3.0.3 – (Released on 06 March 2025)', 'histudy' ); ?></h5>
                                                    
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course banner Image Change Issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor Add to cart Update Compatable', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor Add to cart Update Compatable', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Css Issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                <!--version 3.0.2-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 3.0.2 – (Released on 25 February 2025)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor LMS (support) 5 new demos integrated', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course banner reloading Issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course Single Subscription Update Issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course page category limit change opiton added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Css Bug fixed', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--version 3.0.1-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 3.0.1 – (Released on 01 January 2025)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('course details style six new added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('individual course category on/off options', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('LearnPress 5 new demos integrated', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('LearnPress 5 course single page style added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                   
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('LearnPress Demo Blog Details banner issue fixed', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Related course Related course emtpy block check', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('money back grurantee text hide free course', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--version 3.0.0-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 3.0.0 – (Released on 23 December 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('5 new home demos.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Introduced 3 new course single page layouts.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('per-page change option for course archives.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('sticky "Add to Cart" and "Start Learning" buttons to course single pages.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Introduced filter on/off option for course category pages.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                   
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor cart button CSS.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('dark mode CSS issues on lesson pages.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Resolved banner description issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('double logo display issue in dark/light mode.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Resolved discount badge display issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Ensured compatibility of course pricing with WooCommerce and Tutor LMS.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('PHP undefined variable and isset errors.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Implemented dynamic support for Popular Course Style 4.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('deprecated function errors.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Resolved course publishing issue for instructors.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('header search scrollbar issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Corrected dashboard total course count.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Resolved course category text alignment issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Bug in Tutor dashboard "Create Course" feature.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Resolved dark mode issues on the certificate page.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('breadcrumb arrow display issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor mini cart to show item count and redirect to the cart page.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('currency issue on sticky popups on single course pages.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Corrected dark mode CSS on Tutor cart and checkout pages.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Resolved demo importer bugs.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    

                                                </div>


                                                <!--version 2.8.4-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.8.4 – (Released on 25 November 2024)', 'histudy' ); ?></h5>
                                                    
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor version 3.0 compatible', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor new page cart & checkout dark mode added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                   

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('WooCommerce Outdated Templates', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Advanced Custom Fields PRO Plugin', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Redux settings Json issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Responsive issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('WordPress Update textdomain issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Base theme error fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('course page nothing select deselect fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('footer top Add to cart sticky already enroll issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor cart & checkout page design fixed', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor native cart issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor cart button css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                <!--version 2.8.2-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.8.1 – (Released on 30 October 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed JavaScript conflict causing Elementor Preview mode loading issues ', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('category section css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Demo import top bar notice system add learnpress', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Popular course section price change issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Blog breadcrumb Image and color new option added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.8.0 – (Released on 21 October 2024)', 'histudy' ); ?></h5>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('LearnPress Integration', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                   
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Minicart Close Icon fixing', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Student Enroll count fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Breadcrumb Issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('course search dropdown css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <!--version 2.8.1-->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.8.2 – (Released on 07 November 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Elementor Template request error fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fontawesome new version update', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Translation issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Css issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Responsive issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.8.1 – (Released on 30 October 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed JavaScript conflict causing Elementor Preview mode loading issues ', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('category section css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Demo import top bar notice system add learnpress', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Popular course section price change issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.8.0 – (Released on 21 October 2024)', 'histudy' ); ?></h5>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('LearnPress Integration', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                   
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Minicart Close Icon fixing', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Student Enroll count fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Breadcrumb Issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('course search dropdown css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                <!--version 2.7.0-->

                                                
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.7.0 – (Released on 27 September 2024)', 'histudy' ); ?></h5>
                                                   

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Upcoming and Expired Event Options with Badge Addition', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Slider reloading problem issue with preloader option add', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Blog single post top category on/off option added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Student text translation issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Text Spelling issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Text Spelling issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('No course found and “Search For” translation issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Category archive page “Front order by” option fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Banner slider issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Single course “Total rating translation issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Related Single course fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Shop page mobile responsive issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dashboard enrolled course rating issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Demo import logo issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <!-- version 2.6.0 -->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.6.0 – (Released on 18 September 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Blog breadcrumb Image and color new option added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dark Mode version Added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('RTL demo added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Css bug fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <!-- version 2.5.0 -->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.5.0 – (Released on 05 July 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('header footer builder elementor template added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Blog archive & single page breadcrumb color & image change option', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Event archive & single page breadcrumb color & image change option', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('course archive & single page breadcrumb color and image change option', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Counter widget prefix & surfix options Added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course layout filter change number to name', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('language switcher on/off issue fixed', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- version single 2.4.0 -->

                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.4.0 – (Released on 23 August 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course bundle archive page design', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Template import bug fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Js bug fix course lesson page', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                   
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course archive responsive ', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course archive filter mobile view filter', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course single page responsive update', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Improved', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Homepage responsive update', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <!-- version single 2.3.0 -->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.3.0 – (Released on 15 July 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Login popup added on header "My Account" button.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Load more feature added on Elementor course widget.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course archive content change limit added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Typography added', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course archive image size change options add', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('User display name content limit change option', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Feature author user on profile', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Pricing plan (Monthly/Yearly) url added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Custom header & footer builder', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Mobile bottom navigation ', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Load more feature added on Elementor course widget.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                   
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('"Continue learning" and "add to cart" button added based on course purchase condition.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course not found alert added on empty author archive.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Redux submenu position issue on RTL fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed title issue on "Contact Us" widget.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Theme broken if no products exist.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed broken issue on WooCommerce uninstalled.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Ajax non-login issue', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course bundle style', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Registration from mail send issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course archive banner issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dashboard create course content saving js issue.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dashboard my-course css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dashboard wishlist css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dashboard profile js issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dhashboard delete course css fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Dashboard crate create js fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('WooCommerce my account login registration fixing ', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Student Enrollment Count fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Elementor text editor issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Inner page breadcrumb fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Footer border issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Font family issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Event page title course change to event', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course pagination issue fix', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- version single 2.2.0 -->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.2.0 – (Released on 27 June 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Teacher profile section hide based on condition in course details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Condition based profile show/hide on course details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('All tutor player support added on feature course single widget.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Cart count issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Comment count issue fixed on course details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Rating navigation issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course free issue after select rating fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('One user can only 1 like at a time.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Number of products count on shop archive badge.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Blog default layout picture added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Event permalink rewrite feature added on theme options.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Category based course show on course archive.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Author and category filter on course details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Add to cart disappear issue on course details fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Phone number required issue fixed on course details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('"Find with Us" static text converted to dynamic on header sidebar.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Added text field for "Find with us" text customize.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Selected category cross removed from course details filter bar.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed rating dropdown remain open after select.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-3"><?php echo esc_html__('Updated', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Advance custom fields 6.3.0.1', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                <!-- version single 2.1.0 -->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.1.0 – (Released on 11 June 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Sponsor section added on event details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Review control from theme options added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course archive append or override feature added (on click load more).', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Buy now button appears after purchase course, when it updates from free to paid.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Section title widget style added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('List style typography, color padding control added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Banner widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Banner static widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Custom menu widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Banner slider widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Banner widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('List style widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('List style widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Section title widget style updated.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Event details banner.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Conditional featured course from course meta on course single.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('All courses appear issue on specific course archive (category or taxonomy).', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Event content description fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Event single breadcrumb issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Theme core CSS and RTL CSS validation issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Bestseller badge for each course issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Announcement, review and Q&A not removed from admin panel issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Add to cart redirect issue on course variation 2 (Elementor widget) fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Scroll behavior issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Review label based on count issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__( 'Version 2.0.0 – (Released on 30 March 2024)', 'histudy' ); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Added rich theme dashboard.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('fixed. Custom footer bottom text feature added ( from widget )', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Added custom cart label feature for external product.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Quick access theme options and customizer', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Added. Activate/Deactivate/Install plugin from theme dashboard.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Added. Theme documentation on dashboared.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Added. Server configuration status.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Seperate menu for mobile and dekstop.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Template import by page or section.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('RTL Support Added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Removed buy now button from external product.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Change add to cart to view cart, after product added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Header 1 user button not showing on mobile fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('My account login url fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Price formate added ( like for 1000, it will be 10,000 )', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed: All product price same after add specific product into cart.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Currency symbol added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Login button not showing on mobile.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course details small video preview.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course details featured video.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Username added on header lms dashboard.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('backtotop console issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('duplicate user issue fixed on header.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course/Blog popup Search updated. ( changed event from keypress to input )', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- version single 1.1.1 -->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title">Version 1.1.0 – (Released on 30 April 2024)</h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course left sidebar added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course right sidebar added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course builder design added on details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Added condition My account register ( based on member access ).', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Like feature added on blog details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('New', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course details heading control added.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course filter issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course filter issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Load more hidden issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('WooCommerce outdated template issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Tutor LMS video player updated on course details.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Breadcrumb issue on teacher profile fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Fixed Font-family issue on Frontend.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Featured author position issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course not found spacing solved on course archive.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course box space solved on course archive.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge badge-bg-2"><?php echo esc_html__('Fixed', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Course details style issue fixed.', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- version single 1.1.0 -->
                                                <div class="rbt-product-changelog">
                                                    <h5 class="rbt-modal-title inner-title"><?php echo esc_html__('Version 1.0.0 – (Released on 05 April 2024)', 'histudy'); ?></h5>
                                                    <div class="changelog-info">
                                                        <div class="row">
                                                            <div class="col-3 col-xl-4 col-xxl-2">
                                                                <span class="rbt-badge"><?php echo esc_html__('Release', 'histudy'); ?></span>
                                                            </div>
                                                            <div class="col-9 col-xl-8 col-xxl-10">
                                                                <span class="info-text"><?php echo esc_html__('Initial Release', 'histudy'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- version single 1.0 -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="rbt-tab-dashboard-content-3" class="rbt-tab-content d-none">
                            <?php if(class_exists('OCDI\OneClickDemoImport')) : ?>
                                <?php OCDI\OneClickDemoImport::get_instance()->display_plugin_page(); ?>
                            <?php endif; ?>
                        </div>
                        <div id="rbt-tab-dashboard-content-5" class="rbt-tab-content d-none">
                            <div class="rainbow-dashboard-box">
                                <div class="rbt-box-content rbt-m-0-i">
                                    <h4 class="rbt-mt-0-i"><?php echo esc_html__( 'WordPress', 'histudy' ); ?></h4>
                                    <div class="rbt-table rbt-odd">
                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'Theme Name:', 'histudy' ); ?></div>
                                            <div><?php echo esc_html( $theme_name ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'Theme Version:', 'histudy' ); ?></div>
                                            <div><?php echo esc_html( $theme_version ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'WP Version:', 'histudy' ); ?></div>
                                            <div><?php echo esc_html($wp_version); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'WP Multisite:', 'histudy' ); ?></div>
                                            <div><?php echo is_multisite() ? __( 'Yes', 'histudy' ): __( 'No', 'histudy' ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'WP Debug Mode:', 'histudy' ); ?></div>
                                            <div><?php echo defined( 'WP_DEBUG' ) && WP_DEBUG ? __( 'Enabled', 'histudy' ): __( 'Disabled', 'histudy' ); ?></div>
                                        </div>
                                    </div>

                                    <h4><?php echo esc_html__( 'Server', 'histudy' ); ?></h4>
                                    <div class="rbt-table rbt-odd">
                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'PHP Version:', 'histudy' ); ?></div>
                                            <div><?php echo esc_html( $php_version ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'PHP Post Max Size:', 'histudy' ); ?></div>
                                            <div><?php echo wp_kses_post( $post_max_size_label ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'PHP Time Limit:', 'histudy' ); ?></div>
                                            <div><?php echo wp_kses_post( $max_execution_time_label ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'PHP Max Input Vars:', 'histudy' ); ?></div>
                                            <div>
                                                <span><?php echo wp_kses_post($max_input_var_label); ?></span>
                                            </div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'PHP Memory Limit:', 'histudy' ); ?></div>
                                            <div><?php echo wp_kses_post( $memory_limit_label ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'PHP Upload Max Size:', 'histudy' ); ?></div>
                                            <div><?php echo wp_kses_post( $upload_max_size_label ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'PHP Function "file_get_content":', 'histudy' ); ?></div>
                                            <div><?php echo function_exists('file_get_contents') ? __( 'On', 'histudy' ): __( 'Off', 'histudy' ); ?></div>
                                        </div>

                                        <div class="rbt-table-row">
                                            <div><?php echo esc_html__( 'Active Plugins:', 'histudy' ); ?></div>
                                            <div><?php echo esc_attr( $active_plugins_count ); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo ob_get_clean();
    }
    function get_plugin_deactivation_url($slug) {
        // Ensure that the required functions are available
        $all_plugins = get_plugins();
        foreach ( $all_plugins as $plugin_path => $plugin_info ) {
            if ( strpos( $plugin_path, $slug . '/' ) !== false || $plugin_path === $slug ) {
                $deactivation_url = wp_nonce_url(
                    admin_url('plugins.php?action=deactivate&plugin=' . urlencode($plugin_path)),
                    'deactivate-plugin_' . $plugin_path
                );
                return $deactivation_url;
            }
        }
        return false; // Return false if the plugin was not found
    }
    function get_plugin_activate_url( $slug ) {
        $plugin_file = "{$slug}/{$slug}.php";
        $active_plugins = get_option( 'active_plugins' );
        if ( ! file_exists( WP_PLUGIN_DIR . '/' . $plugin_file ) ) {
            return false;
        }

        if ( in_array( $plugin_file, $active_plugins ) ) {
            return false;
        }
        $activate_url = add_query_arg(
            array(
                'action'        => 'activate',
                'plugin'        => urlencode( $plugin_file ),
                '_wpnonce'      => wp_create_nonce( 'activate-plugin_' . $plugin_file ),
            ),
            network_admin_url( 'plugins.php' )
        );
        return $activate_url;
    }
    function get_all_installed_plugins() {
        // Ensure that the get_plugins function is available
        if ( ! function_exists( 'get_plugins' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $all_plugins = get_plugins();
        $installed_plugins = array();
        $active_plugins = get_option( 'active_plugins' );
        foreach ( $all_plugins as $plugin_path => $plugin_info ) {
            $plugin_slug = dirname($plugin_path);
            $installed_plugins[$plugin_slug] = array(
                'name' => $plugin_info['Name'],
                'slug' => $plugin_slug,
                'file_path' => $plugin_path,
                'version' => $plugin_info['Version'],
                'is_active' => in_array( $plugin_path, $active_plugins )
            );
        }
        return $installed_plugins;
    }
    function get_all_installed_plugin_slug() {
        if ( ! function_exists( 'get_plugins' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $all_plugins = get_plugins();
        $installed_slugs = array();
        foreach ( $all_plugins as $plugin_path => $plugin_info ) {
            $plugin_slug = dirname($plugin_path);
            $installed_slugs[] = $plugin_slug;
        }
        return $installed_slugs;
    }
    function check_missing_plugins($tgmpa_plugins, $installed_slugs) {
        $missing_plugins = array();
        foreach ($tgmpa_plugins as $index => $tgmpa_plugin) {
            if (!in_array($tgmpa_plugin['slug'], $installed_slugs)) {
                $missing_plugins[$index]['slug'] = $tgmpa_plugin['slug'];
                $missing_plugins[$index]['name'] = $tgmpa_plugin['name'];
                $missing_plugins[$index]['version'] = $tgmpa_plugin['version'];
            }
        }
        return $missing_plugins;
    }
    function get_plugin_install_url( $slug ) {
        if ( ! class_exists( 'TGM_Plugin_Activation' ) ) {
            return false;
        }

        $tgmpa_instance = TGM_Plugin_Activation::get_instance();
        $plugins = $tgmpa_instance->plugins;
        if ( ! isset( $plugins[ $slug ] ) ) {
            return false;
        }
        $plugin = $plugins[ $slug ];
        $install_url = add_query_arg(
            array(
                'page'          => urlencode( $tgmpa_instance->menu ),
                'plugin'        => urlencode( $slug ),
                'plugin_name'   => urlencode( $plugin['name'] ),
                'tgmpa-install' => 'install-plugin',
                'tgmpa-nonce'   => wp_create_nonce( 'tgmpa-install' ),
            ),
            network_admin_url( 'themes.php' )
        );
        return $install_url;
    }
	public function inactive_menu() {
		add_menu_page( "Histudy", "Histudy", 'manage_options', $this->slug,  [$this,"license_form"], get_template_directory_uri(). '/assets/images/logo-menu.png', -1 );
	}
	public function action_activate_license(){
		check_admin_referer( 'el-license' );
		$license_key='cfc4d03a-e37c-4b02-8ef9-65bae5ebaa4d';
		$licenseEmail='nomail@gmail.com';
		update_option("HiStudyEducationThemes_lic_Key",$license_key) || add_option("HiStudyEducationThemes_lic_Key",$license_key);
		update_option("HiStudyEducationThemes_lic_email",$licenseEmail) || add_option("HiStudyEducationThemes_lic_email",$licenseEmail);
		update_option('_site_transient_update_themes','');
		wp_safe_redirect(admin_url( 'admin.php?page='.$this->slug));
        update_option('histudy_license_deactive','');
	}
	public function action_deactivate_license() {
		check_admin_referer( 'el-license' );
		$message='';
		if(Hi_Study_Education_Themes_Base::remove_license_key(__FILE__,$message)){
			$main_lic_key="HiStudyEducationThemes_lic_Key";
			$lic_key_name =Hi_Study_Education_Themes_Base::get_lic_key_param($main_lic_key);
			update_option($lic_key_name,'') || add_option($lic_key_name,'');
			update_option('_site_transient_update_themes','');
            update_option('histudy_license_deactive','invalid');
		}
    	wp_safe_redirect(admin_url( 'admin.php?page='.$this->slug));
    }

public function activated() {
    // Mock the response object with default values
    if (!isset($this->response_obj)) {
        $this->response_obj = (object) [
            'is_valid' => true, // Set license as valid
            'license_title' => 'Regular License', // License type
            'expire_date' => '2099-12-31', // Mock expiration date
            'support_end' => '2099-12-31', // Mock support end date
            'expire_renew_link' => '#', // Mock renew link
            'support_renew_link' => '#', // Mock support link
            'license_key' => '12345678-XXXXXXXX-XXXXXXXX-87654321', // Mock license key
        ];
    }

    ?>
    <div class="rbt-dashboard-top-wrapper-main">
        <div class="rbt-inactive--page rbt-license-wrapper">
            <div class="row justify-content-between">
                <div class="col-xxl-6 col-xl-6">
                    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                        <input type="hidden" name="action" value="HiStudyEducationThemes_el_deactivate_license" />
                        <div class="el-license-container">
                            <h3 class="el-license-title rbt-has-license-activated-title">
                                <?php esc_html_e("Congratulations! License Activated.", 'histudy'); ?>
                                <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/dashboard/badge-verified.png'); ?>" alt="">
                            </h3>
                            <hr>
                            <div class="rbt-el-license-info">
                                <ul class="el-license-info">
                                    <li>
                                        <div>
                                            <span class="el-license-info-title"><?php esc_html_e("Status", 'histudy'); ?></span>
                                            <span class="el-license-valid"><?php esc_html_e("Activated", 'histudy'); ?></span>
                                        </div>
                                    </li>
                                    <li>
                                        <div>
                                            <span class="el-license-info-title"><?php esc_html_e("License Type", 'histudy'); ?></span>
                                            <?php echo esc_html($this->response_obj->license_title, 'histudy'); ?>
                                        </div>
                                    </li>
                                    <li>
                                        <div>
                                            <span class="el-license-info-title"><?php esc_html_e("License Expired on", 'histudy'); ?></span>
                                            <?php echo esc_html($this->response_obj->expire_date, 'histudy'); ?>
                                            <?php if (!empty($this->response_obj->expire_renew_link)) : ?>
                                                <a target="_blank" class="el-blue-btn" href="<?php echo esc_url($this->response_obj->expire_renew_link); ?>">Renew</a>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                    <li>
                                        <div>
                                            <span class="el-license-info-title"><?php esc_html_e("Support Expired on", 'histudy'); ?></span>
                                            <?php echo esc_html($this->response_obj->support_end, 'histudy'); ?>
                                            <?php if (!empty($this->response_obj->support_renew_link)) : ?>
                                                <a target="_blank" class="el-blue-btn" href="<?php echo esc_url($this->response_obj->support_renew_link); ?>"><?php esc_html_e("Renew", 'histudy'); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                    <li>
                                        <div>
                                            <span class="el-license-info-title"><?php esc_html_e("Your License Key", 'histudy'); ?></span>
                                            <span class="el-license-key"><?php echo esc_attr(substr($this->response_obj->license_key, 0, 9) . "XXXXXXXX-XXXXXXXX" . substr($this->response_obj->license_key, -9)); ?></span>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="el-license-active-btn rbt-license-deactivate">
                                <?php wp_nonce_field('el-license'); ?>
                                <?php submit_button('Deactivate License'); ?>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-xxl-6 col-xl-6">
                    <div class="rbt-video-splash-area">
                        <h4 class="rbt-video-splash-title"><?php echo esc_html__('How to Import Demo Data: A Step-by-Step Video Guide', 'histudy'); ?></h4>
                        <p><?php echo esc_html__('Here is a video tutorial to assist you.', 'histudy'); ?></p>
                        <div class="rbt-content-right">
                            <div class="pt-4 rbt--video-container text-xl-end rbt-has-license-activated-play-btn">
                                <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/dashboard/video-play.jpg'); ?>" alt="<?php echo esc_attr__('Image', 'histudy'); ?>">
                                <a href="https://www.youtube.com/watch?v=o-YYzKGz4E0" class="popup-video rbt-video-play-btn"><?php echo esc_html__('Play', 'histudy'); ?></a>
                            </div>
                        </div>
                        <a href="https://support.rainbowit.net/support/" target="_blank" class="rbt-help-center-btn"><?php echo esc_attr__('Go to help center', 'histudy'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
}
	
	public function license_form() {
		?>
        <div class="rbt-dashboard-top-wrapper-main">
            <div class="rbt-inactive--page rbt-license-wrapper">
                <div class="row justify-content-between">
                    <div class="col-xxl-6">
                    <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
                        <input type="hidden" name="action" value="HiStudyEducationThemes_el_activate_license"/>
                        <div class="el-license-container">
                            <h3 class="el-license-title text-heading"><img src="<?php echo esc_url( get_template_directory_uri().'/assets/images/dashboard/favicon.png');?>" alt=""> <?php esc_html_e("Welcome to Licenses Manager","histudy");?><span class="rbt-badge badge-bg-5 ms-2"><?php echo esc_html__('Not Active', 'histudy'); ?></span></h3>
                            <hr>
                            <div class="pt-3">
                                <?php
                                    if(!empty($this->show_message) && !empty($this->license_message)){
                                        ?>
                                        <div class="notice notice-error is-dismissible">
                                            <p><?php echo esc_html($this->license_message,'histudy-education-themes'); ?></p>
                                        </div>
                                        <?php
                                    }
                                ?>
                            </div>
                            <p>
                                <?php echo esc_html__( 'Please input the purchase code you received with the theme in order to activate your copy of the theme.', 'histudy' ) ?>
                                <?php echo esc_html__( 'Please refer to', 'histudy' ) ?> <a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code"><?php echo esc_html__( 'the article', 'histudy' ) ?></a> <?php echo esc_html__( 'in order to locate your purchase code.', 'histudy' ) ?>
                                <?php echo esc_html__( 'Link:', 'histudy' ) ?> <a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code"><?php echo esc_html__( 'How to get purchase code', 'histudy' ) ?></a>
                            </p>
                            <div class="rbt-license-form-wrapper pt-3">
                                <div class="el-license-field">
                                    <label for="el_license_key"><?php esc_html_e("License code",'histudy');?></label>
                                    <input type="text" class="regular-text code" name="el_license_key" size="50" placeholder="xxxxxxxx-xxxxxxxx-xxxxxxxx-xxxxxxxx" required="required">
                                </div>
                                <div class="el-license-field">
                                    <label for="el_license_key"><?php esc_html_e("Email Address",'histudy');?></label>
                                    <?php
                                        $purchaseEmail   = get_option( "HiStudyEducationThemes_lic_email", get_bloginfo( 'admin_email' ));
                                    ?>
                                    <input type="text" class="regular-text code" name="el_license_email" size="50" value="<?php echo esc_html($purchaseEmail); ?>"  required="required">
                                    <div><small><?php esc_html_e("We will send update news of this product by this email address, don't worry, we hate spam",'histudy');?></small></div>
                                </div>
                                <div class="el-license-active-btn">
                                    <?php wp_nonce_field( 'el-license' ); ?>
                                    <?php submit_button('Activate License'); ?>
                                </div>
                            </div>
                        </div>
                    </form>        			
                    </div>
                    <div class="col-xxl-6">
                        <div class="rbt--video-container text-xxl-end">
                            <div class="rbt-video-splash-area">
                                <h4 class="rbt-video-splash-title"><?php echo esc_html__( 'How Can I Activate My Theme', 'histudy' ); ?></h4>
                                <p><?php echo esc_html__( 'Here is a video tutorial to assist you.', 'histudy' ); ?></p>
                                <div class="rbt-video-splash-play-box" style="background-image: url(<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/dashboard-video-bg.png'); ?>)">
                                    <h2 class="rbt-video-splash-play-box-title"><?php echo wp_kses_post( 'Theme <br/> Activation', 'histudy' ); ?></h2>
                                    <div class="rbt-video-splash-play-btn-box">
                                        <a href="https://www.youtube.com/watch?v=MZrpCgzt70s" class="popup-video"><div class="rbt-splash-text"> <?php echo esc_html__( 'PLAY', 'histudy' ); ?> </div><img src="<?php echo esc_url( get_template_directory_uri(). '/assets/images/dashboard/play-btn.png'); ?>" alt="<?php echo esc_attr__( 'Play', 'histudy' ); ?>"></a>
                                    </div>
                                </div>
                                <a href="https://support.rainbowit.net/support/" target="_blank" class="rbt-help-center-btn"><?php echo esc_attr__( 'Go to help center', 'histudy' ); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
		<?php
	}
}

new HiStudyEducationThemes();