<?php
use MailPoetVendor\Doctrine\ORM\Query\Expr\Func;

get_header();
$taxonomy_event = 'event_category';
$taxonomy_tag = 'event_tag';
$post_type = 'course_event';
$event_tag_list = get_terms(array(
    'taxonomy'   => $taxonomy_tag,
    'hide_empty' => true
));

$rainbow_options = Rainbow_Helper::rainbow_get_options();
$rainbow_event_archive_overlap = isset( $rainbow_options['rainbow_event_archive_overlap'] ) ? $rainbow_options['rainbow_event_archive_overlap']: 0;
$event_col_xl_list =  sanitize_text_field( $rainbow_options['rainbow_event_archive_col_extra_list'] );
$event_col_xl_grid =  sanitize_text_field( $rainbow_options['rainbow_event_archive_col_extra_grid'] );
$event_col_lg =  sanitize_text_field( $rainbow_options['rainbow_event_archive_col_lg'] );
$event_col_md =  sanitize_text_field( $rainbow_options['rainbow_event_archive_col_md'] );
$event_col_sm =  sanitize_text_field( $rainbow_options['rainbow_event_archive_col'] );
$total_event_col = "col-lg-". $event_col_lg . " " . "col-md-". $event_col_md . " " . "col-". $event_col_sm;

$event_layout = get_query_var('event_layout');
$sidebar_position = get_query_var('sidebar_position');

if( isset( $sidebar_position ) && !empty( $sidebar_position ) ) {
    $sidebar_position = $sidebar_position;
} else {
    $sidebar_position = sanitize_text_field( $rainbow_options['rainbow_event_sidebar'] );
}

if($sidebar_position == 'left') {
    $sidebar_pos = 'left';
} elseif($sidebar_position == 'right') {
    $sidebar_pos = 'right';
} else {
    $sidebar_pos = '';
}

if( isset( $event_layout ) && !empty( $event_layout ) ) {
    $event_layout = $event_layout;
} else {
    $event_layout = sanitize_text_field( $rainbow_options['rainbow_event_layout'] );
}

if  ( $event_layout == 'list' ) {
    $event_style = 'list';
    $event_col = "col-xl-". $event_col_xl_list;
} else {
    $event_style = 'grid';
    $event_col = "col-xl-". $event_col_xl_grid;
}

$column_large = 'col-lg-12 col-xl-12';

if(is_active_sidebar('sidebar-event') && ( $sidebar_pos == 'left' || $sidebar_pos == 'right' )) {
    $column_large = 'col-lg-8 col-xl-9';
}
if( 1 == $rainbow_event_archive_overlap ) {
    $overlap_class = 'rbt-section-overlayping-top';
} else {
    $overlap_class = 'rbt-section-gapTop';
}
$rainbow_event_archive_banner = isset( $rainbow_options['rainbow_event_archive_banner_layout'] ) ? $rainbow_options['rainbow_event_archive_banner_layout']: 'layout-1';
if( 'layout-1' == $rainbow_event_archive_banner ) {
    $overlap_class = 'rbt-section-gapTop';
}

?>
<?php get_template_part('template-parts/content-event-banner'); ?>
<div class="rbt-course-event-area <?php echo esc_attr( $overlap_class ); ?> rbt-section-gapBottom">
    <div class="container">
        <div class="row row--30 gy-5">
            <?php if($sidebar_pos == 'left') { ?>
            <?php if(is_active_sidebar('sidebar-event')   ) { ?>
                <div class="col-lg-4 col-xl-3">
                    <aside class="rbt-sidebar-widget-wrapper rbt-gradient-border">
                        <?php dynamic_sidebar('sidebar-event'); ?>
                    </aside>
                </div>
            <?php } } ?>
            <div class="<?php echo esc_attr($column_large); ?>  ">
                <?php if($wp_query->have_posts()) : ?>
                    <div class="row g-5 rbt-archive-course-event">
                        <?php while($wp_query->have_posts()) : $wp_query->the_post();  ?>
                        <!-- Start Single Event  -->
                        <div class="<?php echo esc_attr($event_col); ?> <?php echo esc_attr( $total_event_col ); ?>">
                            <?php get_template_part('template-parts/event/event-box', $event_style ); ?>
                        </div>
                        <!-- End Single Event  -->
                        <?php endwhile; wp_reset_postdata(); ?>
                    </div>
                <?php endif; ?>
                <?php
                    // Add pagination links
                    $pagination_args = array(
                        'total'        => $wp_query->max_num_pages,
                        'current'      => max(1, get_query_var('paged')),
                        'prev_text'    => '<i class="feather-chevron-left"></i>',
                        'next_text'    => '<i class="feather-chevron-right"></i>',
                        'type'         => 'list',
                        'post_type' => 'course_event'
                    );
                    $pagination_links = paginate_links($pagination_args);
                ?>
                <?php if(!empty($pagination_links)) : ?>
                <div class="row rbt-has-pagination">
                    <div class="col-lg-12 mt--60">
                        <nav>
                            <ul class="rbt-pagination">
                                <?php echo wp_kses_post($pagination_links); ?>
                            </ul>
                        </nav>
                    </div>
                </div>
                <?php endif; wp_reset_postdata(); ?>
            </div>
            <?php if($sidebar_pos == 'right') { 
               
                ?>
                <?php if(is_active_sidebar('sidebar-event') ) { ?>
                    <div class="col-lg-4 col-xl-3">
                        <aside class="rbt-sidebar-widget-wrapper rbt-gradient-border">
                            <?php dynamic_sidebar('sidebar-event'); ?>
                        </aside>
                    </div>
            <?php } } ?>
        </div>
    </div>
</div>
<?php get_footer();