<?php

    $course_id = get_the_ID();
    $rating = \Academy\Helper::get_course_rating( $course_id );
    $reviews_status = Academy\Helper::get_settings( 'is_enabled_course_review', true );

    global $wpdb;
    $user_id                = get_current_user_id();
    $is_already_in_wishlist = $wpdb->get_row( $wpdb->prepare( "SELECT * from {$wpdb->usermeta} WHERE user_id = %d AND meta_key = 'academy_course_wishlist' AND meta_value = %d;", $user_id, $course_id ) );
    $is_show_wishlist = (bool) \Academy\Helper::get_settings( 'is_enabled_course_wishlist', true );
    $card_style = Academy\Helper::get_settings( 'course_card_style' );

    $wishlist_class = 'layout_two' === $card_style || 'layout_four' === $card_style ? 'academy-wishlist-dynamic' : '';

    $user_id = get_current_user_id();
    $course_id = get_the_ID();
    $wishlist = get_user_meta($user_id, 'academy_course_wishlist', true);
    $is_in_wishlist = is_array($wishlist) && in_array($course_id, $wishlist);

    $login_class = ! is_user_logged_in() ? 'academy-header-login-btn' : '';

?>
<div class="rbt-card-top">
<input type="hidden" name="_histudy_academy_nonce" value="<?php echo wp_create_nonce('histudy_academy_nonce'); ?>">
    <div class="rbt-review">
        <div class="rating">
        
            <div class="rating">
                <?php
                $rating_avg = $rating->rating_avg;
                $fullStars = floor($rating_avg);
                $halfStar = ($rating_avg - $fullStars) >= 0.5 ? 1 : 0;
                $emptyStars = 5 - ($fullStars + $halfStar);
                ?>
                <?php for ($i = 0; $i < $fullStars; $i++): ?>
                    <i class="fas fa-star"></i>
                <?php endfor; ?>

                <?php if ($halfStar): ?>
                    <i class="fas fa-star-half-alt"></i>
                <?php endif; ?>

                <?php for ($i = 0; $i < $emptyStars; $i++): ?>
                    <i class="far fa-star"></i>
                <?php endfor; ?>

                <?php

                ?>
                        </div>
        </div>
        <?php if ($rating->rating_count > 0) : ?>
            <span class="rating-count"> ( <?php echo esc_html($rating->rating_count) . _n(' Review', ' Reviews', $rating->rating_count, 'histudy'); ?> )</span>
        <?php else: ?>
            <span class="rating-count"> (<?php echo esc_html__(' 0 Review ', 'histudy'); ?>)</span>

        <?php endif; ?> 
    </div>
    <!-- rbt-review -->
    <?php    
        if ($is_show_wishlist) :
                ?>

            <div class="rbt-bookmark-btn academy-course-header-meta">
                <?php
                if ($is_already_in_wishlist) :
                ?>
                    <a class="<?php echo esc_attr($login_class); ?> active academy-course__wishlist-histudy academy-add-wishlist-btn-histudy rbt-round-btn  <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>" data-course-id="<?php echo esc_attr(get_the_ID()); ?>"><i class="fa-solid fa-bookmark <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>"></i></a>
                <?php else : ?>
                    <a class="<?php echo esc_attr($login_class); ?>  academy-course__wishlist-histudy academy-add-wishlist-btn-histudy rbt-round-btn <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>" data-course-id="<?php echo esc_attr(get_the_ID()); ?>"><i class="fa-regular fa-bookmark <?php echo esc_attr( $is_in_wishlist ) ? ' active' : ''; ?>"></i></a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
</div>
<!-- rbt-card-top -->


