<?php

    $course_id = get_the_ID();
    $rating = \Academy\Helper::get_course_rating( $course_id );
    $reviews_status = Academy\Helper::get_settings( 'is_enabled_course_review', true );
  
?> 
<div class="rbt-card-top"> 
    <div class="rbt-review">
        <div class="rating">
            <?php 
            $rating_avg = $rating->rating_avg;
            $fullStars = floor($rating_avg);  
            $halfStar = ($rating_avg - $fullStars) >= 0.5 ? 1 : 0; 
            $emptyStars = 5 - ($fullStars + $halfStar); 
            ?>
            <?php for ($i = 0; $i < $fullStars; $i++): ?>
                <i class="fas fa-star"></i> 
            <?php endfor; ?>

            <?php if ($halfStar): ?>
                <i class="fas fa-star-half-alt"></i> 
            <?php endif; ?>

            <?php for ($i = 0; $i < $emptyStars; $i++): ?>
                <i class="far fa-star"></i> 
            <?php endfor; ?>
        
            <?php
            if ( $reviews_status ) :
            // Display course rating
                echo wp_kses_post( \Academy\Helper::star_rating_generator( $rating->rating_avg ) );
            endif;
            ?>
        </div>
        <?php if ($rating->rating_count > 0) : ?>
            <span class="rating-count"> ( <?php echo esc_html($rating->rating_count) . _n(' Review', ' Reviews', $rating->rating_count, 'histudy'); ?> )</span>
        <?php else: ?>
            <span class="rating-count"> (<?php echo esc_html__(' 0 Review ', 'histudy'); ?>)</span>
        <?php endif; ?>
    </div>  
</div>