<?php   
    // generic
    $course_id = get_query_var( 'course_id', get_the_ID() );
   
    $categories = \Academy\Helper::get_the_course_category( $course_id );
    $content = get_the_excerpt();
    $content = apply_filters( 'the_content', $content );
    $content = wp_trim_words( get_the_excerpt(),  '12', '.' );
    

    $reviews_status = Academy\Helper::get_settings( 'is_enabled_course_review', true );
    $price       = '';
    $is_paid     = \Academy\Helper::is_course_purchasable( $course_id );
    // Check if WooCommerce is active and the course is purchasable
    if ( \Academy\Helper::is_active_woocommerce() && $is_paid ) {
        $product_id = \Academy\Helper::get_course_product_id( $course_id );
        if ( $product_id ) {
            $product = wc_get_product( $product_id );
            if ( $product ) {
                $price = $product->get_price_html();
            }
        }
    }

    $total_enrolled = \Academy\Helper::count_course_enrolled( $course_id );
    $student_count  = sprintf( _n( '%s Student', '%s Students', $total_enrolled, 'histudy' ), $total_enrolled );

    // Get course rating
    $rating = \Academy\Helper::get_course_rating( $course_id );

    $total_lessons  = \Academy\Helper::get_total_number_of_course_lesson( $course_id );

    global $authordata;
    $course_title = get_the_title( $course_id );

    $author_id = get_post_field( 'post_author', $course_id );
    $author = get_userdata( $author_id );

    // Author
    $author_id              = get_post_field('post_author', $course_id);
    $author_image           = get_avatar_url($author_id);
    $author_image_alt       = get_the_author_meta('description', $author_id);
    $author_name            = get_the_author_meta('display_name', $author_id);

    $rainbow_options = Rainbow_Helper::rainbow_get_options();

    $list_course_img_size = isset($rainbow_options['academy_rainbow_course_list_archive_img_size']) ? $rainbow_options['academy_rainbow_course_list_archive_img_size'] : '';
    $grid_course_img_size = isset($rainbow_options['academy_rainbow_course_grid_archive_img_size']) ? $rainbow_options['academy_rainbow_course_grid_archive_img_size'] : '';

    $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';

    $academy_rainbow_course_card_title_switch = isset($rainbow_options['academy_rainbow_course_card_title_switch']) ? $rainbow_options['academy_rainbow_course_card_title_switch'] : 'false';
    $academy_rainbow_course_card_meta_switch = isset($rainbow_options['academy_rainbow_course_card_meta_switch']) ? $rainbow_options['academy_rainbow_course_card_meta_switch'] : 'false';
    $academy_rainbow_course_card_author_switch = isset($rainbow_options['academy_rainbow_course_card_author_switch']) ? $rainbow_options['academy_rainbow_course_card_author_switch'] : 'false';
    $academy_rainbow_course_card_image_switch = isset($rainbow_options['academy_rainbow_course_card_image_switch']) ? $rainbow_options['academy_rainbow_course_card_image_switch'] : 'false';
    $academy_rainbow_course_card_rating_switch = isset($rainbow_options['academy_rainbow_course_card_rating_switch']) ? $rainbow_options['academy_rainbow_course_card_rating_switch'] : 'false';
    $academy_rainbow_course_card_add_to_cart_switch = isset($rainbow_options['academy_rainbow_course_card_add_to_cart_switch']) ? $rainbow_options['academy_rainbow_course_card_add_to_cart_switch'] : 'false';
    $academy_rainbow_course_card_pricing_switch = isset($rainbow_options['academy_rainbow_course_card_pricing_switch']) ? $rainbow_options['academy_rainbow_course_card_pricing_switch'] : 'false';


    if( $rainbow_academy_card_layout == 'layout-3' || $rainbow_academy_card_layout == 'layout-4' ) {
        $img_size = $list_course_img_size;
    } else {
        $img_size = $grid_course_img_size;
    }

    $categories             = get_the_terms($course_id, 'academy_courses_category');
    $categorie_lists = [];
    if(isset($categories) && !empty($categories)) {
        $cat_taxonomy = 'academy_courses_category';
        foreach($categories as $cat) {
            $cat_id = $cat->term_id;
            $cat_name = $cat->name;
            $cat_url = $category_link = get_term_link($cat_id, $cat_taxonomy);
            $categorie_lists[$cat_url] = $cat_name;
        }
    }

    if ($course_id) {
        $course_percentage = Rainbow_Helper::rb_get_product_offer_percentage($course_id);
    }


?>
                
<div class="rbt-card variation-01 rbt-hover"> 
    <?php if ( has_post_thumbnail( $course_id ) && $academy_rainbow_course_card_image_switch == '1') : ?>
        <div class="rbt-card-img"> 
            <a href="<?php echo esc_url( get_permalink( $course_id ) ); ?>">
                <?php
                echo get_the_post_thumbnail( $course_id, $img_size  );
                if (!empty($course_percentage)) : ?>
                <div class="rbt-badge-3 bg-white">
                    <span><?php echo esc_html($course_percentage); ?>%</span>
                    <span><?php echo esc_html__("Off", "histudy"); ?></span>
                </div>
            <?php endif; ?>
            </a> 
        </div>
    <?php endif; ?>
    <div class="rbt-card-body">
        <?php 
        if( $academy_rainbow_course_card_rating_switch == '1') {
            get_template_part('template-parts/components/academylms/card/card-top'); 
        }
       
            if( $academy_rainbow_course_card_title_switch  == '1') {
        ?>
        <h4 class="rbt-card-title"> 
            <a href="<?php echo esc_url( get_permalink( $course_id ) ); ?>">
                <?php echo esc_html( $course_title ); ?>
            </a>
        </h4>
        <?php } 
        if( $academy_rainbow_course_card_meta_switch  == '1') {
       
        ?>
        <ul class="rbt-meta total-lesson">
            <li>
                <i class="feather-book"></i>
                <?php 
                echo esc_html( $total_lessons ); 
                if( $total_lessons == 1 ) {
                    echo esc_html__(' Lesson','histudy');
                } else {
                    echo esc_html__(' Lessons','histudy');
                }
            ?>
                
            </li>
                <?php if((int) $student_count > 0 ) : ?>
                    <li><i class="feather-users"></i> <?php echo esc_html( $student_count );?></li>
                    <?php else: ?>
                        <li><i class="feather-users"></i> <?php echo esc_html($student_count);?></li>
                <?php endif; ?>
        </ul>
        <?php } ?>
        <?php if ( $content ) { ?>
        <p class="rbt-card-text"><?php echo esc_attr( $content ); ?></p>  
        <?php } ?> 
        
        <div class="rbt-author-meta mb--20">
            <?php 
            if( isset($author_image) && !empty($author_image) && $academy_rainbow_course_card_author_switch == '1') : ?>
            <div class="rbt-avater">

                <?php
                if ( \Academy\Helper::get_settings( 'is_show_public_profile' ) ) :
                    ?>
                <a href="<?php echo esc_url( home_url( '/author/' . $authordata->user_nicename ) ); ?>">
                    <img src="<?php echo esc_url( get_avatar_url( $authordata->ID, [ 'size' => '40' ] ) ); ?>" alt="">
                </a>
                <?php else : ?>
                    <img src="<?php echo esc_url( get_avatar_url( $authordata->ID, [ 'size' => '40' ] ) ); ?>" alt="">
                <?php endif; ?>

            </div>
            <?php endif; ?>
            <?php if ( ! empty( $author ) && $academy_rainbow_course_card_author_switch == '1') : ?>
            <div class="rbt-author-info">
                <?php echo esc_html__('By', 'histudy'); ?> 
                <a href="<?php echo esc_url( home_url( '/author/' . $authordata->user_nicename ) ); ?>">
                        <?php echo get_the_author(); ?>
                </a>  
                <?php 
                if ( ! empty( $categories ) ) {
                        echo esc_html__('In', 'histudy'); ?> 
                <a href="<?php echo esc_url( get_term_link( $categories[0]->term_id ) ); ?>"><?php echo esc_html( $categories[0]->name ); ?></a>
                <?php } ?>
            </div>
            <?php endif; ?>
        </div>
        <div class="rbt-card-bottom">

            <?php 
            if( $academy_rainbow_course_card_pricing_switch == '1') {
                get_template_part('template-parts/components/price/layout', 1);  
            }
            if( $academy_rainbow_course_card_add_to_cart_switch == '1') { ?>
            <a href="<?php echo esc_url( get_permalink( $course_id ) ); ?>"
                class="course_details"><?php echo esc_html__( 'Enroll Course', 'histudy' ); ?>
                <i class="feather-arrow-right"></i>
            </a>
            <?php } ?>
        </div>
    </div>
</div>
 <!-- End Single Course  --> 
                 