<?php
    $rainbow_caourse_cart_settings           = Rainbow_Helper::rainbow_caourse_cart_settings();
    $rainbow_course_card_pricing_switch = $rainbow_caourse_cart_settings['rainbow_course_card_pricing_switch'];
    $post_type = isset($args['post_type']) ? $args['post_type']: 'courses';
    $rainbow_course_grid_archive_img_size = $rainbow_caourse_cart_settings['rainbow_course_grid_archive_img_size'];
    $rainbow_course_content_limit = $rainbow_caourse_cart_settings['rainbow_course_content_limit'];
    $bundle_total = 0;
    if(isset($args['course_id'])) {
        $course_id          = $args['course_id'];
    } else {
        $course_id          = get_the_ID();
    }
    if ( class_exists( '\TutorPro\CourseBundle\Models\BundleModel' ) ) {
        $bundle_course_ids = \TutorPro\CourseBundle\Models\BundleModel::get_bundle_course_ids( $course_id );
        if( count( $bundle_course_ids ) > 0 ) {
            $bundle_total = count( $bundle_course_ids ); 
        }
    }

    $userdata = get_query_var('set_filter_userdata');

    ?>
    <?php 
    if( 'post' == $post_type ) {
        $post_id = get_the_ID();
        ?>
        <!-- Start Single Card  -->
        <div class="rbt-card variation-01 rbt-hover">
            <div class="rbt-card-img">
                <a href="<?php echo get_the_permalink($post_id); ?>">
                    <?php echo get_the_post_thumbnail($post_id,$rainbow_course_grid_archive_img_size); ?>
                </a>
            </div>
            <div class="rbt-card-body">
                <h5 class="rbt-card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h5>
                <p><?php echo wp_trim_words( get_the_excerpt(), $rainbow_course_content_limit ); ?></p>
            </div>
        </div>
        <!-- End Single Card  -->
    <?php }
?>
<?php if( function_exists( 'tutor' ) ) : ?>
    <?php if( 'courses' === $post_type ) : ?>
        <?php
            $course_id = get_the_ID();
            $course_rating = tutor_utils()->get_course_rating( $course_id );
        ?>
        <!-- Start Single Card  -->
        <div class="rbt-card variation-01 rbt-hover">
            <div class="rbt-card-img">
                <a href="<?php echo get_the_permalink($course_id); ?>">
                    <?php echo get_the_post_thumbnail($course_id,$rainbow_course_grid_archive_img_size); ?>
                    <?php if( $bundle_total > 0 ) { ?>
                        <div class="tutor-bundle-course-count-badge">
                            <span class="tutor-icon-layer"></span>
                            <span class="tutor-bundle-course-count-number"><?php echo esc_html($bundle_total); ?></span>
                            <span class="tutor-bundle-course-count-text"> - <?php echo esc_html__("course bundle","histudy");?></span>
                        </div>
                    <?php } ?>
                </a>
            </div>
            <div class="rbt-card-body">
                <h5 class="rbt-card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h5>
                <div class="rbt-review">
                    <div class="rating">
                        <?php tutor_utils()->star_rating_generator_v2( $course_rating->rating_avg ); ?>
                    </div>
                    <span class="rating-count"> (<?php echo esc_html($course_rating->rating_count); ?> <?php echo esc_html__('Reviews', 'histudy'); ?>)</span>
                </div>
                <div class="rbt-card-bottom">
                    <?php if(1 == $rainbow_course_card_pricing_switch) : ?>
                        <?php get_template_part('template-parts/components/price/layout', 1); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- End Single Card  -->
    <?php endif; ?>
<?php endif; ?>
<?php if( class_exists( 'LearnPress' ) ) :

    $course_id = get_the_ID();
    $is_editor 		= class_exists('Elementor') ? \Elementor\Plugin::instance()->editor->is_edit_mode(): false;
    $user_id = get_current_user_id();
    $wishlist = (array) get_user_meta( $user_id, '_lpr_wish_list', true );
    $is_already_wishlist = in_array( $course_id, $wishlist ) ? true : false;
    $rated = $course_rate_res['rated'] ?? 0;
    $total = $course_rate_res['total'] ?? 0;


    if( $rated == 1 ) {
        $review = __('Review','histudy');
    } else {
        $review = __('Reviews','histudy');
    }
?>

    <!-- Start Single Card  -->
    <div class="rbt-card variation-01 rbt-hover">
            <div class="rbt-card-img">
                <a href="<?php echo get_the_permalink($course_id); ?>">
                    <?php echo get_the_post_thumbnail($course_id,$rainbow_course_grid_archive_img_size); ?>
                </a>
            </div>
            <div class="rbt-card-body">
                <h5 class="rbt-card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h5>
                <div class="rbt-review">
                    <div class="rating">
                    <?php
                        if(class_exists('LP_Addon_Course_Review_Preload') ) {
                            LP_Addon_Course_Review_Preload::$addon->get_template( 'rating-stars.php', [ 'rated' => $rated ] );
                        }
                    ?>
                    </div>
                    <span class="rating-count"> (<?php echo esc_attr($rated); ?> <?php echo esc_html($review ); ?>)</span>
                </div>
                <div class="rbt-card-bottom">
                    <?php get_template_part('template-parts/components/price/layout', 1); ?>
                </div>
            </div>
        </div>
    <!-- End Single Card  -->
<?php endif; ?>

<?php if( function_exists( 'academy_start' ) ) :

    global $wpdb;
    
    $course_id = get_query_var( 'course_id', get_the_ID() );
    $user_id   = get_current_user_id();


    $rainbow_course_content_limit = isset($rainbow_options['academy_rainbow_course_content_limit']) ? $rainbow_options['academy_rainbow_course_content_limit'] : '12';
    $content = get_the_excerpt($course_id);
    $content = wp_trim_words($content, $rainbow_course_content_limit, '...');

    $total_enrolled = \Academy\Helper::count_course_enrolled($course_id);
    $student_count  = sprintf(_n('%s Student', '%s Students', $total_enrolled, 'histudy'), $total_enrolled);


    $total_lessons  = \Academy\Helper::get_total_number_of_course_lesson($course_id);

    if ($total_lessons == 1) {
        $lesson = esc_html__('Lesson', 'histudy');
    } else {
        $lesson = esc_html__('Lessons', 'histudy');
    }

    $is_already_in_wishlist = $wpdb->get_row($wpdb->prepare("SELECT * from {$wpdb->usermeta} WHERE user_id = %d AND meta_key = 'academy_course_wishlist' AND meta_value = %d;", $user_id, $course_id));
    $is_show_wishlist = (bool) \Academy\Helper::get_settings('is_enabled_course_wishlist', true);
    $card_style = Academy\Helper::get_settings('course_card_style');

    $wishlist_class = 'layout_two' === $card_style || 'layout_four' === $card_style ? 'academy-wishlist-dynamic' : '';

    $rating = \Academy\Helper::get_course_rating($course_id);
    $reviews_status = Academy\Helper::get_settings('is_enabled_course_review', true);
    if ($rating->rating_count == 1) {
        $review_text = __('Review', 'histudy');
    } else {
        $review_text = __('Reviews', 'histudy');
    }

    $rainbow_options = Rainbow_Helper::rainbow_get_options();

    $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';
    $categories             = get_the_terms($course_id, 'academy_courses_category');
    $categorie_lists = [];
    if(isset($categories) && !empty($categories)) {
        $cat_taxonomy = 'academy_courses_category';
        foreach($categories as $cat) {
            $cat_id = $cat->term_id;
            $cat_name = $cat->name;
            $cat_url = $category_link = get_term_link($cat_id, $cat_taxonomy);
            $categorie_lists[$cat_url] = $cat_name;
        }
    }

    $margin_bottom = ( $rainbow_academy_card_layout == 'layout-4' || $rainbow_academy_card_layout == 'layout-5') ? 'mb--10' : '';

    $categories = \Academy\Helper::get_the_course_category( $course_id );
    global $authordata;

    global $authordata;
    $course_title = get_the_title( $course_id );

    $author_id = get_post_field( 'post_author', $course_id );
    $author = get_userdata( $author_id );

    // Author
    $author_id              = get_post_field('post_author', $course_id);
    $author_image           = get_avatar_url($author_id);
    $author_image_alt       = get_the_author_meta('description', $author_id);
    $author_name            = get_the_author_meta('display_name', $author_id);

    $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';

    $card_list = [];

    if ( in_array( $rainbow_academy_card_layout, [ 'layout-3', 'layout-4' ] ) ) {
        $card_list[] = 'card-list-2';
    }

    if ( in_array( $rainbow_academy_card_layout, [ 'layout-5' ] ) ) {
        $card_list[] = 'elegant-course';
    }

    if ( $rainbow_academy_card_layout === 'layout-4' ) {
        $card_list[] = ' elegant-course';
    }

    $class_attr = implode( ' ', $card_list );

    $card_style = Academy\Helper::get_settings('course_card_style');
    $image_class = 'layout_two' === $card_style || 'layout_four' === $card_style ? 'academy-course-thumbnail-width' : '';

    if ($course_id) {
        $course_percentage = Rainbow_Helper::rb_get_product_offer_percentage($course_id);
    }

    $list_course_img_size = isset($rainbow_options['academy_rainbow_course_list_archive_img_size']) ? $rainbow_options['academy_rainbow_course_list_archive_img_size'] : '';
    $grid_course_img_size = isset($rainbow_options['academy_rainbow_course_grid_archive_img_size']) ? $rainbow_options['academy_rainbow_course_grid_archive_img_size'] : '';

    $rainbow_academy_card_layout = isset($rainbow_options['rainbow_academy_card_layout']) ? $rainbow_options['rainbow_academy_card_layout'] : 'layout-1';

    if( $rainbow_academy_card_layout == 'layout-3' || $rainbow_academy_card_layout == 'layout-4' ) {
        $img_size = $list_course_img_size;
    } else {
        $img_size = $grid_course_img_size;
    }

    $course_title = get_the_title( $course_id );

    $academy_rainbow_course_card_title_switch = isset($rainbow_options['academy_rainbow_course_card_title_switch']) ? $rainbow_options['academy_rainbow_course_card_title_switch'] : 'false';
    $academy_rainbow_course_card_meta_switch = isset($rainbow_options['academy_rainbow_course_card_meta_switch']) ? $rainbow_options['academy_rainbow_course_card_meta_switch'] : 'false';
    $academy_rainbow_course_card_author_switch = isset($rainbow_options['academy_rainbow_course_card_author_switch']) ? $rainbow_options['academy_rainbow_course_card_author_switch'] : 'false';
    $academy_rainbow_course_card_image_switch = isset($rainbow_options['academy_rainbow_course_card_image_switch']) ? $rainbow_options['academy_rainbow_course_card_image_switch'] : 'false';
    $academy_rainbow_course_card_rating_switch = isset($rainbow_options['academy_rainbow_course_card_rating_switch']) ? $rainbow_options['academy_rainbow_course_card_rating_switch'] : 'false';
    $academy_rainbow_course_card_add_to_cart_switch = isset($rainbow_options['academy_rainbow_course_card_add_to_cart_switch']) ? $rainbow_options['academy_rainbow_course_card_add_to_cart_switch'] : 'false';
    $academy_rainbow_course_card_pricing_switch = isset($rainbow_options['academy_rainbow_course_card_pricing_switch']) ? $rainbow_options['academy_rainbow_course_card_pricing_switch'] : 'false';

    $user_id = get_current_user_id();
    $course_id = get_the_ID();
    $wishlist = get_user_meta($user_id, 'academy_course_wishlist', true);
    $is_in_wishlist = is_array($wishlist) && in_array($course_id, $wishlist);

    $login_class = ! is_user_logged_in() ? 'academy-header-login-btn' : '';
?>

<!-- Start Single Card  -->
<div class="rbt-card variation-01 rbt-hover">
<?php 
    if( $academy_rainbow_course_card_image_switch == '1') { ?>
        <div class="rbt-card-img">
            <a href="<?php echo esc_url( get_permalink( $course_id ) ); ?>">
                <?php if ( has_post_thumbnail( $course_id ) ) : ?>
                <?php
                echo get_the_post_thumbnail( $course_id, $img_size  );
                endif;
                ?>
            </a>
        </div>
        <?php } ?>
        <div class="rbt-card-body">
            <h5 class="rbt-card-title"><a href="<?php echo esc_url( get_permalink( $course_id ) ); ?>"><?php echo esc_html( $course_title ); ?></a>
            </h5>
            <?php
                if (  $academy_rainbow_course_card_rating_switch =='1') : ?>
                    <div class="rbt-review">
                        <div class="rating">
                            <?php
                            $rating_avg = $rating->rating_avg;
                            $fullStars = floor($rating_avg);
                            $halfStar = ($rating_avg - $fullStars) >= 0.5 ? 1 : 0;
                            $emptyStars = 5 - ($fullStars + $halfStar);
                            ?>
                            <?php for ($i = 0; $i < $fullStars; $i++): ?>
                                <i class="fas fa-star"></i>
                            <?php endfor; ?>

                            <?php if ($halfStar): ?>
                                <i class="fas fa-star-half-alt"></i>
                            <?php endif; ?>

                            <?php for ($i = 0; $i < $emptyStars; $i++): ?>
                                <i class="far fa-star"></i>
                            <?php endfor; ?>

                            <?php

                            ?>
                        </div>
                        <span class="rating-count"><?php echo esc_html('(' . $rating->rating_count . " " . $review_text . ')'); ?></span>
                    </div>
                <?php
                endif;
                ?>
            <div class="rbt-card-bottom">
            <?php 
                if( $academy_rainbow_course_card_pricing_switch == '1') {
                    get_template_part('template-parts/components/price/layout', 1); 
                }
                if( $academy_rainbow_course_card_add_to_cart_switch == '1') {
                ?>

                <a href="<?php echo esc_url(get_permalink($course_id)); ?>"
                    class="course_details"><?php esc_html_e('Enroll Course', 'histudy'); ?>
                    <i class="feather-arrow-right"></i>
                </a>
                <?php } ?>
            </div>
        </div>
    </div>
<!-- End Single Card  -->
<?php endif; ?>