<?php
$course_terms                           = class_exists('Elementor_Helper') ? Elementor_Helper::get_course_terms() : array();
$course_terms_tags                      = class_exists('Elementor_Helper') ? Elementor_Helper::get_course_terms(false, 'course-tag') : '';
$users_data                             = class_exists('Elementor_Helper') ? Elementor_Helper::get_instructor() : '';
$rainbow_layout_tutor_settings          = Rainbow_Helper::rainbow_layout_tutor_settings();

global $rainbow_options;
if(function_exists('tutor')) {
    $rainbow_tutor_archive_title            = $rainbow_layout_tutor_settings['rainbow_tutor_archive_title'];
} 
elseif(function_exists('academy_start')) {
    $rainbow_tutor_archive_title            = isset( $rainbow_options['rainbow_academy_tutor_archive_title'] ) ? $rainbow_options['rainbow_academy_tutor_archive_title'] : 'All Courses';
}

if (!is_post_type_archive('courses') && !is_post_type_archive('academy_courses')) {
    $rainbow_tutor_archive_title = wp_get_document_title();
}
?>

<!-- Start breadcrumb Area -->
<div class="rbt-breadcrumb-default ptb--100 ptb_md--50 ptb_sm--30 bg-gradient-1 fard">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="breadcrumb-inner text-center">
                    <h2 class="title"><?php echo esc_html($rainbow_tutor_archive_title); ?></h2>
                    <!-- Start Breadcrumb Area  -->
                    <?php rainbow_breadcrumbs();?>
                    <!-- End Breadcrumb Area  -->
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Breadcrumb Area -->