<?php
$locations = get_the_terms(get_the_ID(), 'event_location');
$first_location = '';
$rainbow_options = Rainbow_Helper::rainbow_get_options();
$event_btn_label = isset($rainbow_options['rainbow_event_archive_btn_label']) ? $rainbow_options['rainbow_event_archive_btn_label']: '';
if ($locations && !is_wp_error($locations) && count($locations) > 0) {
    // Get the first location
    $first_location = array_shift($locations)->name;
    
}

$additional_attributes = rainbow_get_acf_data('additional_attributes');

$start_time = '';
$end_time = '';
if (!empty($additional_attributes)) {
    $additional_attributes = array_shift($additional_attributes);
    $start_time = $additional_attributes['start_time'];
    $end_time = $additional_attributes['end_time'];
    $full_address = $additional_attributes ? $additional_attributes['location']: '';
}

$allowed_tags = wp_kses_allowed_html('post');

$schedule = rainbow_get_acf_data( 'schedule' );
$date = '';
if(!empty($schedule)) {
    $schedule_attributes = array_shift($schedule);
    $date = $schedule_attributes ? $schedule_attributes['insert_event_day'][0]['event_date']: '';
}

$timestamp = strtotime(str_replace('/', '-', $date)); 
$day_month = date("d M", $timestamp);
$year = date("Y", $timestamp);


?>

<div class="rbt-card card-list-2 event-list-card variation-01 rbt-hover">
    <div class="rbt-card-img">
        <a href="<?php the_permalink(); ?>">
            <?php the_post_thumbnail(); ?>
        </a>
    </div>
    <div class="rbt-card-body">
        <ul class="rbt-meta">
            <li><i class="feather-calendar"></i><?php echo wp_kses(get_the_date('d M, Y'), 'alltext_allow' ); ?></li>
            <li><i class="feather-map-pin"></i>
                <?php
                if(!empty($full_address)) {
                    echo esc_html($full_address); 
                } else {
                    echo esc_html($first_location);
                }
                 
                ?>
            </li>
        </ul>
        <h4 class="rbt-card-title"><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h4>
        <?php if(!empty($event_btn_label)) : ?>
        <div class="read-more-btn">
            <a class="rbt-btn btn-border hover-icon-reverse btn-sm radius-round" href="<?php echo esc_url(get_the_permalink()); ?>">
                <span class="icon-reverse-wrapper">
                    <span class="btn-text"><?php echo esc_html( $event_btn_label ); ?></span>
                    <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                    <span class="btn-icon"><i class="feather-arrow-right"></i></span>
                </span>
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>