<?php
/**
 * Frontend Wishlist Page
 *
 * @package Tutor\Templates
 * @subpackage Dashboard
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @version 1.4.3
 */

use TUTOR\Input;

global $post;
$per_page     = tutor_utils()->get_option( 'statement_show_per_page', 20 );
$current_page = max( 1, Input::get( 'current_page', 1, Input::TYPE_INT ) );
$offset       = ( $current_page - 1 ) * $per_page;

$wishlists             = tutor_utils()->get_wishlist( null, $offset, $per_page );
$total_wishlists_count = count( tutor_utils()->get_wishlist( null ) );
?>
<div class="section-title">
    <h4 class="rbt-title-style-3"><?php esc_html_e( 'Wishlist', 'histudy' ); ?></h4>
</div>
<div class="tutor-dashboard-content-inner my-wishlist">
	<?php if ( is_array( $wishlists ) && count( $wishlists ) ) : ?>
		<div class="row g-5">
			<?php
			foreach ( $wishlists as $post ) :
				setup_postdata( $post );
				?>
                <div class="col-lg-6 col-xl-4 col-12">
					<div class="rbt-card variation-01 rbt-hover">
						<div class="rbt-card-img">
							<a href="<?php echo get_the_permalink(); ?>" class="tutor-d-block">
								<?php the_post_thumbnail(get_the_ID()); ?>
							</a>
						</div>
						
                        <div class="rbt-card-body">
							<?php get_template_part('template-parts/components/tutor/dashbord/card-top'); ?>
                            <div class="tutor-course-name tutor-fs-6 tutor-fw-bold">
							<h4 class="rbt-card-title">
								<a href="<?php echo get_the_permalink(); ?>">
									<?php the_title(); ?>
								</a>
							</h4>
                            </div>
                            <div class="tutor-mt-auto mb-5">
                                <?php tutor_load_template( 'loop.course-author' ); ?>
                            </div>
                        </div>
                        <div class="tutor-card-footer">
                            <?php tutor_course_loop_price(); ?>
                        </div>
                    </div>
                </div>
				<?php
			endforeach;
			wp_reset_postdata();
			?>
		</div>
	<?php else : ?>
		<?php tutor_utils()->tutor_empty_state( tutor_utils()->not_found_text() ); ?>
	<?php endif; ?>
</div>
<div class="tutor-mt-24">
	<?php
	if ( $total_wishlists_count >= $per_page ) {
		$pagination_data = array(
			'total_items' => $total_wishlists_count,
			'per_page'    => $per_page,
			'paged'       => $current_page,
		);

		tutor_load_template_from_custom_path(
			tutor()->path . 'templates/dashboard/elements/pagination.php',
			$pagination_data
		);
	}
	?>
</div>