<?php
/**
 * The template to display the reviewers meta data (name, verified owner, review date)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review-meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

global $comment;
$verified = wc_review_is_from_verified_owner( $comment->comment_ID );

if ( '0' === $comment->comment_approved ) { ?>

	<div class="meta">
		<em class="woocommerce-review__awaiting-approval">
			<?php esc_html_e( 'Your review is awaiting approval', 'histudy' ); ?>
		</em>
	</div>

<?php } else { ?>

	<div class="rtb-review-meta">
		<h6 class="commenter"><?php comment_author(); ?> </h6>
		<?php
		if ( 'yes' === get_option( 'woocommerce_review_rating_verification_label' ) && $verified ) {
			echo '<em class="woocommerce-review__verified verified">(' . esc_attr__( 'verified owner', 'histudy' ) . ')</em> ';
		}
		?>
        <?php if(!empty(get_comment_date( wc_date_format()))) : ?>
        <div class="comment-meta">
            <div class="time-spent"><?php echo esc_html( get_comment_date( wc_date_format() ) ); ?></div>
        </div>
        <?php endif; ?>
	</div>

	<?php
}