<?php
use Elementor\Plugin;
use Elementor\Core\Settings\Page\Manager as PageManager;

function homirx_themer_path_demo_content(){
  return (__DIR__.'/demo-data/');
}
add_filter('wbc_importer_dir_path', 'homirx_themer_path_demo_content');

//Way to set menu, import revolution slider, and set home page.
function homirx_themer_import_sample($demo_active_import , $demo_directory_path){

	reset($demo_active_import);
	$current_key = key($demo_active_import);

	if ( class_exists( 'RevSlider' ) ) {
		$wbc_sliders_array = array();
		$slider = new RevSlider();
		foreach ($wbc_sliders_array as $s) {
			if(file_exists( homirx_themer_path_demo_content() . 'main/'. $s )){
				$slider->importSliderFromPost(true, true, homirx_themer_path_demo_content().'main/'.$s);
			}
		}
	}

	//Setting Menus
	$wbc_menu_array = array( 'main' );
	if( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
		$top_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
		if ( isset( $top_menu->term_id ) ) {
			set_theme_mod( 'nav_menu_locations', array(
				'primary' => $top_menu->term_id
			));
	 	}
	}

	//Set HomePage
	$wbc_home_pages = array(
		'main' => 'Home 1'
	);
	
	if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
		$page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
		if (isset($page->ID)) {
			update_option( 'page_on_front', $page->ID );
			update_option( 'show_on_front', 'page' );
		}
	}

	// Import Settings of Elementor
	$options_elementor = maybe_unserialize('a:12:{s:13:"system_colors";a:4:{i:0;a:3:{s:3:"_id";s:7:"primary";s:5:"title";s:7:"Primary";s:5:"color";s:7:"#E3572B";}i:1;a:3:{s:3:"_id";s:9:"secondary";s:5:"title";s:9:"Secondary";s:5:"color";s:7:"#16243E";}i:2;a:3:{s:3:"_id";s:4:"text";s:5:"title";s:4:"Text";s:5:"color";s:7:"#6C6E76";}i:3;a:3:{s:3:"_id";s:6:"accent";s:5:"title";s:7:"Heading";s:5:"color";s:7:"#16243D";}}s:13:"custom_colors";a:3:{i:0;a:3:{s:3:"_id";s:7:"68a0019";s:5:"title";s:10:"Gray Color";s:5:"color";s:7:"#FFF8F2";}i:1;a:3:{s:3:"_id";s:7:"fe4fa39";s:5:"title";s:11:"Boder Color";s:5:"color";s:7:"#D7D7D7";}i:2;a:3:{s:3:"_id";s:7:"83e7262";s:5:"title";s:5:"Black";s:5:"color";s:7:"#16243E";}}s:17:"system_typography";a:4:{i:0;a:6:{s:3:"_id";s:7:"primary";s:5:"title";s:7:"Primary";s:21:"typography_typography";s:6:"custom";s:22:"typography_font_family";s:7:"Manrope";s:22:"typography_font_weight";s:3:"700";s:20:"typography_font_size";a:3:{s:4:"unit";s:2:"px";s:4:"size";i:48;s:5:"sizes";a:0:{}}}i:1;a:6:{s:3:"_id";s:9:"secondary";s:5:"title";s:9:"Secondary";s:21:"typography_typography";s:6:"custom";s:22:"typography_font_family";s:7:"Manrope";s:22:"typography_font_weight";s:3:"400";s:20:"typography_font_size";a:3:{s:4:"unit";s:2:"px";s:4:"size";i:16;s:5:"sizes";a:0:{}}}i:2;a:6:{s:3:"_id";s:4:"text";s:5:"title";s:4:"Text";s:21:"typography_typography";s:6:"custom";s:22:"typography_font_family";s:7:"Manrope";s:22:"typography_font_weight";s:3:"400";s:20:"typography_font_size";a:3:{s:4:"unit";s:2:"px";s:4:"size";i:16;s:5:"sizes";a:0:{}}}i:3;a:6:{s:3:"_id";s:6:"accent";s:5:"title";s:6:"Accent";s:21:"typography_typography";s:6:"custom";s:22:"typography_font_family";s:7:"Manrope";s:22:"typography_font_weight";s:3:"400";s:20:"typography_font_size";a:3:{s:4:"unit";s:2:"px";s:4:"size";i:16;s:5:"sizes";a:0:{}}}}s:17:"custom_typography";a:0:{}s:21:"default_generic_fonts";s:10:"Sans-serif";s:9:"site_name";s:36:"HomiRX - Real Estate WordPress Theme";s:19:"page_title_selector";s:14:"h1.entry-title";s:15:"activeItemIndex";i:1;s:11:"viewport_md";i:768;s:11:"viewport_lg";i:1025;s:15:"container_width";a:3:{s:4:"unit";s:2:"px";s:4:"size";i:1290;s:5:"sizes";a:0:{}}s:36:"typography_enable_styleguide_preview";s:3:"yes";}', true);
	$active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
	update_post_meta($active_kit_id, '_elementor_page_settings', $options_elementor);
	update_option('use_extendify_templates', '0');
	update_option( 'elementor_experiment-e_dom_optimization', 'inactive' );
	update_option( 'elementor_experiment-a11y_improvements', 'inactive' );
   update_option( 'elementor_editor_break_lines', '1' );
   update_option( 'elementor_unfiltered_files_upload', '1' );
   update_option( 'elementor_experiment-container', 'active' );
   update_option( 'elementor_experiment-e_element_cache', 'inactive' );
   update_option( 'elementor_experiment-e_optimized_assets_loading', 'inactive' );
   update_option( 'elementor_experiment-additional_custom_breakpoints', 'inactive' );
   update_option( 'elementor_experiment-e_swiper_latest', 'inactive' );
   update_option( 'elementor_experiment-e_optimized_css_loading', 'inactive' );
   update_option( 'elementor_experiment-e_font_icon_svg', 'inactive' );

   // Import Settings of Directorist
   $opts_directorist = get_option('atbdp_option');
   $opts_directorist['enable_multi_directory'] = 1;
   $opts_directorist['enable_monetization'] = 1;
   $opts_directorist['enable_featured_listing'] = 1;
   $opts_directorist['enable_monetization'] = 1;
   // Colors
   $opts_directorist['brand_color'] = '#e3572b';
   $opts_directorist['button_primary_color'] = '#ffffff';
   $opts_directorist['button_primary_bg_color'] = '#e3572b';
   $opts_directorist['button_secondary_color'] = '#000000';
   $opts_directorist['button_secondary_bg_color'] = '#f2f3f5';
   $opts_directorist['primary_color'] = '#ffffff';
   $opts_directorist['primary_hover_color'] = '#ffffff';
   $opts_directorist['back_primary_color'] = '#e3572b';
   $opts_directorist['back_primary_hover_color'] = '#e97653';
   $opts_directorist['border_primary_color'] = '#e3572b';
   $opts_directorist['border_primary_hover_color'] = '#df7653';
  	$opts_directorist['marker_shape_color'] = '#e3572b';
   $opts_directorist['marker_icon_color'] = '#ffffff';
   $opts_directorist['primary_dark_back_color'] = '#e3572b';
   // Image Size
   $opts_directorist['gallery_crop_width'] = 950;
   $opts_directorist['gallery_crop_height'] = 480;
   $opts_directorist['map_zoom_level'] = 16;
   $opts_directorist['map_view_zoom_level'] = 12;
   $opts_directorist['listings_map_height'] = 350;
	// Listings
   $opts_directorist['all_listing_layout'] = 'left_sidebar';
   $opts_directorist['search_result_layout'] = 'left_sidebar';
   $opts_directorist['way_to_show_preview'] = 'full';
   $opts_directorist['crop_width'] = 350;
   $opts_directorist['crop_height'] = 260;
   $opts_directorist['single_slider_image_size'] = 'cover';
   $opts_directorist['paginate_all_listings'] = 1;
   $opts_directorist['all_listing_page_items'] = 3;

   $page_options = array(
   	'search_listing' 			=> 'Search Home',
   	'search_result_page'		=> 'Search Result',
   	'add_listing_page'		=> 'Add Listing',
   	'all_listing_page'		=> 'Properties',
   	'single_category_page'	=> 'Single Category',
   	'single_location_page'	=> 'Single Location',
   	'single_tag_page'			=> 'Single Tag',
   	'author_profile_page'	=> 'Author Profile',
   	'user_dashboard'			=> 'Dashboard',
   	'signin_signup_page'		=> 'Sign In',
   	'all_locations_page'		=> 'All Locations',
   	'all_categories_page'	=> 'All Categories',
   	'checkout_page'			=> 'Property Checkout'
   );

  	foreach ($page_options as $key => $name) {
  		$page_option = false;
  		$page_option = get_page_by_title($name);
  		if ($page_option && isset($page_option->ID)) {
  			$opts_directorist[$key] = $page_option->ID;
  		}
  	}
  
	update_option('atbdp_option', $opts_directorist);

	//$options_directorist_data = maybe_unserialize($options_directorist, true);

	//General Type Update
   $general_type = get_term_by('name', 'General', ATBDP_DIRECTORY_TYPE);
   $general_type_id = isset($general_type->term_id) && $general_type->term_id ? $general_type->term_id : false;
   if($general_type_id){
	   $data_submission_form_fields = maybe_unserialize('a:2:{s:6:"fields";a:25:{s:5:"title";a:8:{s:12:"widget_group";s:6:"preset";s:11:"widget_name";s:5:"title";s:4:"type";s:4:"text";s:9:"field_key";s:13:"listing_title";s:8:"required";s:1:"1";s:5:"label";s:5:"Title";s:11:"placeholder";s:0:"";s:10:"widget_key";s:5:"title";}s:11:"description";a:9:{s:4:"type";s:9:"wp_editor";s:9:"field_key";s:15:"listing_content";s:5:"label";s:11:"Description";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:11:"description";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:11:"description";}s:7:"pricing";a:12:{s:5:"label";s:7:"Pricing";s:12:"pricing_type";s:4:"both";s:17:"price_range_label";s:11:"Price Range";s:23:"price_range_placeholder";s:18:"Select Price Range";s:21:"price_unit_field_type";s:6:"number";s:22:"price_unit_field_label";s:11:"Price [USD]";s:28:"price_unit_field_placeholder";s:30:"Price of this listing. Eg. 100";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:7:"pricing";s:12:"widget_group";s:6:"preset";s:9:"field_key";s:0:"";s:10:"widget_key";s:7:"pricing";}s:8:"location";a:10:{s:9:"field_key";s:32:"tax_input[at_biz_dir-location][]";s:5:"label";s:8:"Location";s:4:"type";s:8:"multiple";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:8:"location";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:8:"location";s:14:"create_new_loc";s:0:"";}s:3:"tag";a:10:{s:9:"field_key";s:28:"tax_input[at_biz_dir-tags][]";s:5:"label";s:3:"Tag";s:11:"placeholder";s:3:"Tag";s:4:"type";s:8:"multiple";s:8:"required";s:0:"";s:9:"allow_new";s:1:"1";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:3:"tag";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:3:"tag";}s:8:"category";a:10:{s:9:"field_key";s:23:"admin_category_select[]";s:5:"label";s:8:"Category";s:4:"type";s:8:"multiple";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:8:"category";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:8:"category";s:14:"create_new_cat";s:0:"";}s:5:"phone";a:10:{s:4:"type";s:3:"tel";s:9:"field_key";s:5:"phone";s:5:"label";s:5:"Phone";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:5:"phone";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:5:"phone";s:8:"whatsapp";s:0:"";}s:5:"email";a:9:{s:4:"type";s:5:"email";s:9:"field_key";s:5:"email";s:5:"label";s:5:"Email";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:5:"email";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:5:"email";}s:7:"website";a:9:{s:4:"type";s:4:"text";s:9:"field_key";s:7:"website";s:5:"label";s:7:"Website";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:7:"website";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:7:"website";}s:11:"social_info";a:8:{s:4:"type";s:7:"add_new";s:9:"field_key";s:6:"social";s:5:"label";s:11:"Social Info";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:11:"social_info";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:11:"social_info";}s:3:"map";a:9:{s:4:"type";s:3:"map";s:9:"field_key";s:3:"map";s:5:"label";s:3:"Map";s:8:"lat_long";s:54:"Or Enter Coordinates (latitude and longitude) Manually";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:3:"map";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:3:"map";}s:18:"hide_contact_owner";a:6:{s:4:"type";s:4:"text";s:9:"field_key";s:18:"hide_contact_owner";s:5:"label";s:47:"Hide contact owner form for single listing page";s:11:"widget_name";s:18:"hide_contact_owner";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:18:"hide_contact_owner";}s:12:"image_upload";a:12:{s:4:"type";s:5:"media";s:9:"field_key";s:11:"listing_img";s:5:"label";s:6:"Images";s:8:"required";s:0:"";s:18:"select_files_label";s:12:"Select Files";s:15:"max_image_limit";s:1:"5";s:19:"max_per_image_limit";s:1:"0";s:21:"max_total_image_limit";s:1:"2";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:12:"image_upload";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:12:"image_upload";}s:5:"video";a:9:{s:4:"type";s:4:"text";s:9:"field_key";s:8:"videourl";s:5:"label";s:5:"Video";s:11:"placeholder";s:30:"Only YouTube &amp; Vimeo URLs.";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:5:"video";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:5:"video";}s:7:"address";a:9:{s:4:"type";s:4:"text";s:9:"field_key";s:7:"address";s:5:"label";s:7:"Address";s:11:"placeholder";s:33:"Listing address eg. New York, USA";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:11:"widget_name";s:7:"address";s:12:"widget_group";s:6:"preset";s:10:"widget_key";s:7:"address";}s:4:"text";a:12:{s:4:"type";s:4:"text";s:9:"field_key";s:11:"custom-text";s:5:"label";s:9:"Number ID";s:11:"description";s:0:"";s:11:"placeholder";s:9:"Number ID";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:9:"assign_to";s:0:"";s:8:"category";s:0:"";s:12:"widget_group";s:6:"custom";s:11:"widget_name";s:4:"text";s:10:"widget_key";s:4:"text";}s:7:"excerpt";a:9:{s:4:"type";s:8:"textarea";s:9:"field_key";s:7:"excerpt";s:5:"label";s:7:"Excerpt";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:12:"widget_group";s:6:"preset";s:11:"widget_name";s:7:"excerpt";s:10:"widget_key";s:7:"excerpt";}s:7:"tagline";a:9:{s:4:"type";s:4:"text";s:9:"field_key";s:7:"tagline";s:5:"label";s:7:"Tagline";s:11:"placeholder";s:0:"";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:12:"widget_group";s:6:"preset";s:11:"widget_name";s:7:"tagline";s:10:"widget_key";s:7:"tagline";}s:6:"number";a:12:{s:4:"type";s:6:"number";s:9:"field_key";s:13:"custom-number";s:5:"label";s:10:"Build Year";s:11:"description";s:0:"";s:11:"placeholder";s:4:"2024";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:9:"assign_to";s:0:"";s:8:"category";s:0:"";s:12:"widget_group";s:6:"custom";s:11:"widget_name";s:6:"number";s:10:"widget_key";s:6:"number";}s:6:"text_2";a:12:{s:4:"type";s:4:"text";s:9:"field_key";s:13:"custom-text-2";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:11:"placeholder";s:7:"ex: Bar";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:9:"assign_to";s:0:"";s:8:"category";s:0:"";s:12:"widget_group";s:6:"custom";s:11:"widget_name";s:4:"text";s:10:"widget_key";s:6:"text_2";}s:6:"text_3";a:12:{s:4:"type";s:4:"text";s:9:"field_key";s:13:"custom-text-3";s:5:"label";s:7:"Parking";s:11:"description";s:0:"";s:11:"placeholder";s:7:"ex: Yes";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:9:"assign_to";s:0:"";s:8:"category";s:0:"";s:12:"widget_group";s:6:"custom";s:11:"widget_name";s:4:"text";s:10:"widget_key";s:6:"text_3";}s:6:"text_5";a:12:{s:4:"type";s:4:"text";s:9:"field_key";s:13:"custom-text-5";s:5:"label";s:16:"Digital Payments";s:11:"description";s:0:"";s:11:"placeholder";s:11:"ex: Bitcoin";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:9:"assign_to";s:0:"";s:8:"category";s:0:"";s:12:"widget_group";s:6:"custom";s:11:"widget_name";s:4:"text";s:10:"widget_key";s:6:"text_5";}s:6:"text_6";a:12:{s:4:"type";s:4:"text";s:9:"field_key";s:13:"custom-text-6";s:5:"label";s:12:"Credit Cards";s:11:"description";s:0:"";s:11:"placeholder";s:7:"ex: Yes";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:9:"assign_to";s:0:"";s:8:"category";s:0:"";s:12:"widget_group";s:6:"custom";s:11:"widget_name";s:4:"text";s:10:"widget_key";s:6:"text_6";}s:13:"terms_privacy";a:7:{s:4:"type";s:4:"text";s:9:"field_key";s:14:"privacy_policy";s:4:"text";s:204:"I agree to the <a href="http://localhost/wp/homirx/privacy-policy-2/" target="_blank">Privacy Policy</a> and <a href="http://localhost/wp/homirx/terms-and-conditions/" target="_blank">Terms of Service</a>";s:8:"required";s:1:"1";s:12:"widget_group";s:6:"preset";s:11:"widget_name";s:13:"terms_privacy";s:10:"widget_key";s:13:"terms_privacy";}s:15:"lt_feature_list";a:11:{s:4:"type";s:8:"textarea";s:9:"field_key";s:15:"lt_feature_list";s:5:"label";s:24:"Features &amp; Amenities";s:11:"description";s:44:"Each new line will be printed with a feature";s:11:"placeholder";s:20:"ex: Air Conditioning";s:4:"rows";s:1:"8";s:8:"required";s:0:"";s:14:"only_for_admin";s:0:"";s:12:"widget_group";s:6:"preset";s:11:"widget_name";s:15:"lt_feature_list";s:10:"widget_key";s:15:"lt_feature_list";}}s:6:"groups";a:5:{i:0;a:5:{s:5:"label";s:15:"General Section";s:4:"lock";s:1:"1";s:6:"fields";a:8:{i:0;s:5:"title";i:1;s:7:"tagline";i:2;s:7:"excerpt";i:3;s:11:"description";i:4;s:8:"location";i:5;s:7:"pricing";i:6;s:8:"category";i:7;s:3:"tag";}s:5:"plans";a:0:{}s:4:"type";s:13:"general_group";}i:1;a:3:{s:5:"label";s:3:"Map";s:6:"fields";a:2:{i:0;s:7:"address";i:1;s:3:"map";}s:4:"type";s:13:"general_group";}i:2;a:3:{s:5:"label";s:18:"Images &amp; Video";s:6:"fields";a:2:{i:0;s:12:"image_upload";i:1;s:5:"video";}s:4:"type";s:13:"general_group";}i:3;a:5:{s:4:"type";s:13:"general_group";s:5:"label";s:11:"Information";s:6:"fields";a:7:{i:0;s:4:"text";i:1;s:6:"text_2";i:2;s:6:"text_3";i:3;s:6:"number";i:4;s:6:"text_5";i:5;s:6:"text_6";i:6;s:15:"lt_feature_list";}s:17:"defaultGroupLabel";s:7:"Section";s:29:"disableTrashIfGroupHasWidgets";a:1:{i:0;a:2:{s:11:"widget_name";s:5:"title";s:12:"widget_group";s:6:"preset";}}}i:4;a:3:{s:5:"label";s:19:"Contact Information";s:6:"fields";a:6:{i:0;s:18:"hide_contact_owner";i:1;s:5:"email";i:2;s:5:"phone";i:3;s:7:"website";i:4;s:11:"social_info";i:5;s:13:"terms_privacy";}s:4:"type";s:13:"general_group";}}}', true);
	   update_term_meta($general_type_id, 'submission_form_fields', $data_submission_form_fields);
	   $data_search_form_fields = maybe_unserialize('a:2:{s:6:"fields";a:7:{s:5:"title";a:7:{s:8:"required";s:0:"";s:5:"label";s:12:"Looking For?";s:11:"placeholder";s:12:"Looking For?";s:11:"widget_name";s:5:"title";s:12:"widget_group";s:17:"available_widgets";s:19:"original_widget_key";s:5:"title";s:10:"widget_key";s:5:"title";}s:8:"category";a:7:{s:8:"required";s:0:"";s:5:"label";s:8:"Category";s:11:"placeholder";s:15:"Select Category";s:11:"widget_name";s:8:"category";s:12:"widget_group";s:17:"available_widgets";s:19:"original_widget_key";s:8:"category";s:10:"widget_key";s:8:"category";}s:8:"location";a:8:{s:8:"required";s:0:"";s:5:"label";s:8:"Location";s:11:"placeholder";s:8:"Location";s:15:"location_source";s:12:"from_map_api";s:11:"widget_name";s:8:"location";s:12:"widget_group";s:17:"available_widgets";s:19:"original_widget_key";s:8:"location";s:10:"widget_key";s:8:"location";}s:7:"pricing";a:7:{s:27:"price_range_min_placeholder";s:3:"Min";s:27:"price_range_max_placeholder";s:3:"Max";s:11:"widget_name";s:7:"pricing";s:12:"widget_group";s:17:"available_widgets";s:19:"original_widget_key";s:7:"pricing";s:10:"widget_key";s:7:"pricing";s:5:"label";s:0:"";}s:6:"review";a:4:{s:5:"label";s:6:"Review";s:11:"widget_name";s:6:"review";s:12:"widget_group";s:13:"other_widgets";s:10:"widget_key";s:6:"review";}s:13:"radius_search";a:7:{s:5:"label";s:13:"Radius Search";s:23:"default_radius_distance";s:1:"0";s:18:"radius_search_unit";s:5:"miles";s:11:"widget_name";s:13:"radius_search";s:12:"widget_group";s:13:"other_widgets";s:10:"widget_key";s:13:"radius_search";s:22:"radius_search_based_on";s:7:"address";}s:3:"tag";a:5:{s:5:"label";s:3:"Tag";s:11:"widget_name";s:3:"tag";s:12:"widget_group";s:17:"available_widgets";s:19:"original_widget_key";s:3:"tag";s:10:"widget_key";s:3:"tag";}}s:6:"groups";a:2:{i:0;a:5:{s:5:"label";s:5:"Basic";s:4:"lock";s:1:"1";s:9:"draggable";s:0:"";s:6:"fields";a:3:{i:0;s:5:"title";i:1;s:8:"category";i:2;s:8:"location";}s:4:"type";s:13:"general_group";}i:1;a:5:{s:5:"label";s:8:"Advanced";s:4:"lock";s:1:"1";s:9:"draggable";s:0:"";s:6:"fields";a:4:{i:0;s:7:"pricing";i:1;s:6:"review";i:2;s:13:"radius_search";i:3;s:3:"tag";}s:4:"type";s:13:"general_group";}}}', true);
	   update_term_meta($general_type_id, 'search_form_fields', $data_search_form_fields);
	   $data_single_listing_header = maybe_unserialize('a:4:{i:0;a:3:{s:4:"type";s:17:"placeholder_group";s:14:"placeholderKey";s:25:"quick-widgets-placeholder";s:12:"placeholders";a:2:{i:0;a:3:{s:4:"type";s:17:"placeholder_group";s:14:"placeholderKey";s:22:"quick-info-placeholder";s:15:"selectedWidgets";a:1:{i:0;a:6:{s:4:"type";s:5:"badge";s:5:"label";s:5:"Title";s:11:"widget_name";s:8:"lt_title";s:10:"widget_key";s:8:"lt_title";s:14:"enable_tagline";s:1:"1";s:14:"enable_address";s:0:"";}}}i:1;a:3:{s:4:"type";s:17:"placeholder_group";s:14:"placeholderKey";s:24:"quick-action-placeholder";s:15:"selectedWidgets";a:3:{i:0;a:4:{s:4:"type";s:6:"button";s:5:"label";s:8:"Bookmark";s:11:"widget_name";s:8:"bookmark";s:10:"widget_key";s:8:"bookmark";}i:1;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:5:"Share";s:11:"widget_name";s:5:"share";s:10:"widget_key";s:5:"share";s:10:"share_icon";s:12:"las la-share";}i:2;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:6:"Report";s:11:"widget_name";s:6:"report";s:10:"widget_key";s:6:"report";s:11:"report_icon";s:11:"las la-flag";}}}}}i:1;a:3:{s:4:"type";s:16:"placeholder_item";s:14:"placeholderKey";s:18:"slider-placeholder";s:15:"selectedWidgets";a:1:{i:0;a:5:{s:4:"type";s:9:"thumbnail";s:5:"label";s:20:"Listing Image/Slider";s:11:"widget_name";s:6:"slider";s:10:"widget_key";s:6:"slider";s:16:"footer_thumbnail";s:1:"1";}}}i:2;a:3:{s:4:"type";s:16:"placeholder_item";s:14:"placeholderKey";s:25:"listing-title-placeholder";s:15:"selectedWidgets";a:0:{}}i:3;a:3:{s:4:"type";s:16:"placeholder_item";s:14:"placeholderKey";s:24:"more-widgets-placeholder";s:15:"selectedWidgets";a:4:{i:0;a:4:{s:4:"type";s:13:"ratings-count";s:5:"label";s:16:"Listings Ratings";s:11:"widget_name";s:13:"ratings_count";s:10:"widget_key";s:13:"ratings_count";}i:1;a:7:{s:4:"type";s:5:"badge";s:5:"label";s:6:"Badges";s:11:"widget_name";s:6:"badges";s:10:"widget_key";s:6:"badges";s:9:"new_badge";s:1:"1";s:13:"popular_badge";s:1:"1";s:14:"featured_badge";s:1:"1";}i:2;a:4:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Category";s:11:"widget_name";s:8:"category";s:10:"widget_key";s:8:"category";}i:3;a:4:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Location";s:11:"widget_name";s:8:"location";s:10:"widget_key";s:8:"location";}}}}', true);
	   update_term_meta($general_type_id, 'single_listing_header', $data_single_listing_header);
	   $data_listings_card_grid_view = maybe_unserialize('a:5:{s:9:"thumbnail";a:5:{s:9:"top_right";a:1:{i:0;a:5:{s:4:"type";s:4:"icon";s:5:"label";s:8:"Favorite";s:4:"hook";s:20:"atbdp_favorite_badge";s:11:"widget_name";s:14:"favorite_badge";s:10:"widget_key";s:14:"favorite_badge";}}s:8:"top_left";a:1:{i:0;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Featured";s:4:"hook";s:20:"atbdp_featured_badge";s:11:"widget_name";s:14:"featured_badge";s:10:"widget_key";s:14:"featured_badge";}}s:12:"bottom_right";a:0:{}s:11:"bottom_left";a:2:{i:0;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:7:"Popular";s:4:"hook";s:19:"atbdp_popular_badge";s:11:"widget_name";s:13:"popular_badge";s:10:"widget_key";s:13:"popular_badge";}i:1;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:3:"New";s:4:"hook";s:15:"atbdp_new_badge";s:11:"widget_name";s:9:"new_badge";s:10:"widget_key";s:9:"new_badge";}}s:6:"avatar";a:1:{i:0;a:7:{s:4:"type";s:6:"avatar";s:5:"label";s:11:"User Avatar";s:4:"hook";s:17:"atbdp_user_avatar";s:8:"can_move";s:0:"";s:11:"widget_name";s:11:"user_avatar";s:10:"widget_key";s:11:"user_avatar";s:5:"align";s:5:"right";}}}s:4:"body";a:3:{s:3:"top";a:3:{i:0;a:6:{s:4:"type";s:5:"title";s:5:"label";s:5:"Title";s:4:"hook";s:19:"atbdp_listing_title";s:11:"widget_name";s:13:"listing_title";s:10:"widget_key";s:13:"listing_title";s:12:"show_tagline";s:0:"";}i:1;a:5:{s:4:"type";s:6:"rating";s:5:"label";s:6:"Rating";s:4:"hook";s:21:"atbdp_listings_rating";s:11:"widget_name";s:6:"rating";s:10:"widget_key";s:6:"rating";}i:2;a:5:{s:4:"type";s:5:"price";s:5:"label";s:7:"Pricing";s:4:"hook";s:27:"atbdp_single_listings_price";s:11:"widget_name";s:7:"pricing";s:10:"widget_key";s:7:"pricing";}}s:6:"bottom";a:3:{i:0;a:6:{s:4:"type";s:9:"list-item";s:5:"label";s:8:"Location";s:4:"hook";s:23:"atbdp_listings_location";s:11:"widget_name";s:17:"listings_location";s:10:"widget_key";s:17:"listings_location";s:4:"icon";s:17:"las la-map-marker";}i:1;a:6:{s:4:"type";s:9:"list-item";s:5:"label";s:5:"Phone";s:4:"hook";s:20:"atbdp_listings_phone";s:11:"widget_name";s:5:"phone";s:10:"widget_key";s:5:"phone";s:4:"icon";s:12:"las la-phone";}i:2;a:7:{s:4:"type";s:9:"list-item";s:5:"label";s:11:"Posted Date";s:4:"hook";s:26:"atbdp_listings_posted_date";s:11:"widget_name";s:11:"posted_date";s:10:"widget_key";s:11:"posted_date";s:4:"icon";s:12:"las la-clock";s:9:"date_type";s:9:"post_date";}}s:7:"excerpt";a:0:{}}s:6:"footer";a:2:{s:5:"right";a:1:{i:0;a:6:{s:4:"type";s:10:"view-count";s:5:"label";s:10:"View Count";s:4:"hook";s:16:"atbdp_view_count";s:11:"widget_name";s:10:"view_count";s:10:"widget_key";s:10:"view_count";s:4:"icon";s:12:"las la-heart";}}s:4:"left";a:1:{i:0;a:6:{s:4:"type";s:8:"category";s:5:"label";s:8:"Category";s:4:"hook";s:14:"atbdp_category";s:11:"widget_name";s:8:"category";s:10:"widget_key";s:8:"category";s:4:"icon";s:13:"las la-folder";}}}s:15:"active_template";s:24:"grid_view_with_thumbnail";s:13:"template_data";a:2:{s:24:"grid_view_with_thumbnail";a:3:{s:9:"thumbnail";a:5:{s:9:"top_right";a:1:{i:0;a:5:{s:4:"type";s:4:"icon";s:5:"label";s:8:"Favorite";s:4:"hook";s:20:"atbdp_favorite_badge";s:11:"widget_name";s:14:"favorite_badge";s:10:"widget_key";s:14:"favorite_badge";}}s:8:"top_left";a:1:{i:0;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:7:"Popular";s:4:"hook";s:19:"atbdp_popular_badge";s:11:"widget_name";s:13:"popular_badge";s:10:"widget_key";s:13:"popular_badge";}}s:12:"bottom_right";a:0:{}s:11:"bottom_left";a:2:{i:0;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Featured";s:4:"hook";s:20:"atbdp_featured_badge";s:11:"widget_name";s:14:"featured_badge";s:10:"widget_key";s:14:"featured_badge";}i:1;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:3:"New";s:4:"hook";s:15:"atbdp_new_badge";s:11:"widget_name";s:9:"new_badge";s:10:"widget_key";s:9:"new_badge";}}s:6:"avatar";a:1:{i:0;a:7:{s:4:"type";s:6:"avatar";s:5:"label";s:11:"User Avatar";s:4:"hook";s:17:"atbdp_user_avatar";s:8:"can_move";s:0:"";s:11:"widget_name";s:11:"user_avatar";s:10:"widget_key";s:11:"user_avatar";s:5:"align";s:5:"right";}}}s:4:"body";a:3:{s:3:"top";a:2:{i:0;a:5:{s:4:"type";s:6:"rating";s:5:"label";s:6:"Rating";s:4:"hook";s:21:"atbdp_listings_rating";s:11:"widget_name";s:6:"rating";s:10:"widget_key";s:6:"rating";}i:1;a:7:{s:4:"type";s:5:"title";s:5:"label";s:5:"Title";s:4:"hook";s:19:"atbdp_listing_title";s:11:"widget_name";s:13:"listing_title";s:10:"widget_key";s:13:"listing_title";s:19:"original_widget_key";s:5:"title";s:12:"show_tagline";s:1:"1";}}s:6:"bottom";a:2:{i:0;a:8:{s:4:"type";s:9:"list-item";s:5:"label";s:7:"Address";s:4:"hook";s:26:"atbdp_listings_map_address";s:11:"widget_name";s:7:"address";s:10:"widget_key";s:7:"address";s:19:"original_widget_key";s:7:"address";s:4:"icon";s:21:"fas fa-map-marker-alt";s:10:"show_label";s:0:"";}i:1;a:8:{s:4:"type";s:9:"list-item";s:5:"label";s:5:"Phone";s:4:"hook";s:20:"atbdp_listings_phone";s:11:"widget_name";s:5:"phone";s:10:"widget_key";s:5:"phone";s:19:"original_widget_key";s:5:"phone";s:4:"icon";s:23:"fas fa-phone-square-alt";s:10:"show_label";s:0:"";}}s:7:"excerpt";a:0:{}}s:6:"footer";a:2:{s:5:"right";a:1:{i:0;a:7:{s:4:"type";s:5:"price";s:11:"widget_name";s:12:"listing_link";s:5:"label";s:12:"Listing Link";s:4:"hook";s:18:"atbdp_listing_link";s:10:"widget_key";s:12:"listing_link";s:10:"label_link";s:7:"Details";s:4:"icon";s:17:"fa-solid fa-house";}}s:4:"left";a:1:{i:0;a:6:{s:4:"type";s:5:"price";s:5:"label";s:7:"Pricing";s:4:"hook";s:27:"atbdp_single_listings_price";s:11:"widget_name";s:7:"pricing";s:10:"widget_key";s:7:"pricing";s:19:"original_widget_key";s:7:"pricing";}}}}s:27:"grid_view_without_thumbnail";a:2:{s:4:"body";a:6:{s:6:"avatar";a:1:{i:0;a:7:{s:4:"type";s:6:"avatar";s:5:"label";s:11:"User Avatar";s:4:"hook";s:17:"atbdp_user_avatar";s:8:"can_move";s:0:"";s:11:"widget_name";s:11:"user_avatar";s:10:"widget_key";s:11:"user_avatar";s:5:"align";s:6:"center";}}s:5:"title";a:1:{i:0;a:6:{s:4:"type";s:5:"title";s:5:"label";s:5:"Title";s:4:"hook";s:19:"atbdp_listing_title";s:11:"widget_name";s:13:"listing_title";s:10:"widget_key";s:13:"listing_title";s:12:"show_tagline";s:0:"";}}s:13:"quick_actions";a:1:{i:0;a:5:{s:4:"type";s:4:"icon";s:5:"label";s:8:"Favorite";s:4:"hook";s:20:"atbdp_favorite_badge";s:11:"widget_name";s:14:"favorite_badge";s:10:"widget_key";s:14:"favorite_badge";}}s:10:"quick_info";a:5:{i:0;a:5:{s:4:"type";s:6:"rating";s:5:"label";s:6:"Rating";s:4:"hook";s:21:"atbdp_listings_rating";s:11:"widget_name";s:6:"rating";s:10:"widget_key";s:6:"rating";}i:1;a:6:{s:4:"type";s:5:"price";s:5:"label";s:7:"Pricing";s:4:"hook";s:27:"atbdp_single_listings_price";s:11:"widget_name";s:7:"pricing";s:10:"widget_key";s:7:"pricing";s:19:"original_widget_key";s:7:"pricing";}i:2;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Featured";s:4:"hook";s:20:"atbdp_featured_badge";s:11:"widget_name";s:14:"featured_badge";s:10:"widget_key";s:14:"featured_badge";}i:3;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:3:"New";s:4:"hook";s:15:"atbdp_new_badge";s:11:"widget_name";s:9:"new_badge";s:10:"widget_key";s:9:"new_badge";}i:4;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:7:"Popular";s:4:"hook";s:19:"atbdp_popular_badge";s:11:"widget_name";s:13:"popular_badge";s:10:"widget_key";s:13:"popular_badge";}}s:6:"bottom";a:3:{i:0;a:6:{s:4:"type";s:9:"list-item";s:5:"label";s:8:"Location";s:4:"hook";s:23:"atbdp_listings_location";s:11:"widget_name";s:17:"listings_location";s:10:"widget_key";s:17:"listings_location";s:4:"icon";s:17:"las la-map-marker";}i:1;a:7:{s:4:"type";s:9:"list-item";s:5:"label";s:5:"Phone";s:4:"hook";s:20:"atbdp_listings_phone";s:11:"widget_name";s:5:"phone";s:10:"widget_key";s:5:"phone";s:4:"icon";s:12:"las la-phone";s:19:"original_widget_key";s:5:"phone";}i:2;a:7:{s:4:"type";s:9:"list-item";s:5:"label";s:5:"Email";s:4:"hook";s:20:"atbdp_listings_email";s:11:"widget_name";s:5:"email";s:10:"widget_key";s:5:"email";s:4:"icon";s:15:"las la-envelope";s:19:"original_widget_key";s:5:"email";}}s:7:"excerpt";a:0:{}}s:6:"footer";a:2:{s:5:"right";a:1:{i:0;a:7:{s:4:"type";s:10:"view-count";s:5:"label";s:10:"View Count";s:4:"hook";s:16:"atbdp_view_count";s:11:"widget_name";s:10:"view_count";s:10:"widget_key";s:10:"view_count";s:4:"icon";s:12:"las la-heart";s:19:"original_widget_key";s:10:"view_count";}}s:4:"left";a:1:{i:0;a:7:{s:4:"type";s:8:"category";s:5:"label";s:8:"Category";s:4:"hook";s:14:"atbdp_category";s:11:"widget_name";s:8:"category";s:10:"widget_key";s:8:"category";s:4:"icon";s:13:"las la-folder";s:19:"original_widget_key";s:8:"category";}}}}}}', true);
	   update_term_meta($general_type_id, 'listings_card_grid_view', $data_listings_card_grid_view);
	   $data_listings_card_list_view = maybe_unserialize('a:5:{s:9:"thumbnail";a:1:{s:9:"top_right";a:2:{i:0;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:7:"Popular";s:4:"hook";s:19:"atbdp_popular_badge";s:11:"widget_name";s:13:"popular_badge";s:10:"widget_key";s:13:"popular_badge";}i:1;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:3:"New";s:4:"hook";s:15:"atbdp_new_badge";s:11:"widget_name";s:9:"new_badge";s:10:"widget_key";s:9:"new_badge";}}}s:4:"body";a:4:{s:3:"top";a:4:{i:0;a:6:{s:4:"type";s:5:"title";s:5:"label";s:5:"Title";s:4:"hook";s:19:"atbdp_listing_title";s:11:"widget_name";s:13:"listing_title";s:10:"widget_key";s:13:"listing_title";s:12:"show_tagline";s:0:"";}i:1;a:5:{s:4:"type";s:6:"rating";s:5:"label";s:6:"Rating";s:4:"hook";s:21:"atbdp_listings_rating";s:11:"widget_name";s:6:"rating";s:10:"widget_key";s:6:"rating";}i:2;a:5:{s:4:"type";s:5:"price";s:5:"label";s:7:"Pricing";s:4:"hook";s:27:"atbdp_single_listings_price";s:11:"widget_name";s:7:"pricing";s:10:"widget_key";s:7:"pricing";}i:3;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Featured";s:4:"hook";s:20:"atbdp_featured_badge";s:11:"widget_name";s:14:"featured_badge";s:10:"widget_key";s:14:"featured_badge";}}s:5:"right";a:1:{i:0;a:5:{s:4:"type";s:4:"icon";s:5:"label";s:8:"Favorite";s:4:"hook";s:20:"atbdp_favorite_badge";s:11:"widget_name";s:14:"favorite_badge";s:10:"widget_key";s:14:"favorite_badge";}}s:6:"bottom";a:3:{i:0;a:6:{s:4:"type";s:9:"list-item";s:5:"label";s:8:"Location";s:4:"hook";s:23:"atbdp_listings_location";s:11:"widget_name";s:17:"listings_location";s:10:"widget_key";s:17:"listings_location";s:4:"icon";s:17:"las la-map-marker";}i:1;a:6:{s:4:"type";s:9:"list-item";s:5:"label";s:5:"Phone";s:4:"hook";s:20:"atbdp_listings_phone";s:11:"widget_name";s:5:"phone";s:10:"widget_key";s:5:"phone";s:4:"icon";s:12:"las la-phone";}i:2;a:7:{s:4:"type";s:9:"list-item";s:5:"label";s:11:"Posted Date";s:4:"hook";s:26:"atbdp_listings_posted_date";s:11:"widget_name";s:11:"posted_date";s:10:"widget_key";s:11:"posted_date";s:4:"icon";s:12:"las la-clock";s:9:"date_type";s:9:"post_date";}}s:7:"excerpt";a:0:{}}s:6:"footer";a:2:{s:5:"right";a:2:{i:0;a:6:{s:4:"type";s:10:"view-count";s:5:"label";s:10:"View Count";s:4:"hook";s:16:"atbdp_view_count";s:11:"widget_name";s:10:"view_count";s:10:"widget_key";s:10:"view_count";s:4:"icon";s:12:"las la-heart";}i:1;a:6:{s:4:"type";s:6:"avatar";s:5:"label";s:11:"User Avatar";s:4:"hook";s:17:"atbdp_user_avatar";s:8:"can_move";s:1:"1";s:11:"widget_name";s:11:"user_avatar";s:10:"widget_key";s:11:"user_avatar";}}s:4:"left";a:1:{i:0;a:6:{s:4:"type";s:8:"category";s:5:"label";s:8:"Category";s:4:"hook";s:14:"atbdp_category";s:11:"widget_name";s:8:"category";s:10:"widget_key";s:8:"category";s:4:"icon";s:13:"las la-folder";}}}s:15:"active_template";s:24:"list_view_with_thumbnail";s:13:"template_data";a:2:{s:24:"list_view_with_thumbnail";a:3:{s:9:"thumbnail";a:1:{s:9:"top_right";a:3:{i:0;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Featured";s:4:"hook";s:20:"atbdp_featured_badge";s:11:"widget_name";s:14:"featured_badge";s:10:"widget_key";s:14:"featured_badge";}i:1;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:7:"Popular";s:4:"hook";s:19:"atbdp_popular_badge";s:11:"widget_name";s:13:"popular_badge";s:10:"widget_key";s:13:"popular_badge";}i:2;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:3:"New";s:4:"hook";s:15:"atbdp_new_badge";s:11:"widget_name";s:9:"new_badge";s:10:"widget_key";s:9:"new_badge";}}}s:4:"body";a:4:{s:3:"top";a:2:{i:0;a:5:{s:4:"type";s:6:"rating";s:5:"label";s:6:"Rating";s:4:"hook";s:21:"atbdp_listings_rating";s:11:"widget_name";s:6:"rating";s:10:"widget_key";s:6:"rating";}i:1;a:6:{s:4:"type";s:5:"title";s:5:"label";s:5:"Title";s:4:"hook";s:19:"atbdp_listing_title";s:11:"widget_name";s:13:"listing_title";s:10:"widget_key";s:13:"listing_title";s:12:"show_tagline";s:1:"1";}}s:5:"right";a:1:{i:0;a:5:{s:4:"type";s:4:"icon";s:5:"label";s:8:"Favorite";s:4:"hook";s:20:"atbdp_favorite_badge";s:11:"widget_name";s:14:"favorite_badge";s:10:"widget_key";s:14:"favorite_badge";}}s:6:"bottom";a:2:{i:0;a:8:{s:4:"type";s:9:"list-item";s:5:"label";s:7:"Address";s:4:"hook";s:26:"atbdp_listings_map_address";s:11:"widget_name";s:7:"address";s:10:"widget_key";s:7:"address";s:19:"original_widget_key";s:7:"address";s:4:"icon";s:21:"fas fa-map-marker-alt";s:10:"show_label";s:0:"";}i:1;a:8:{s:4:"type";s:9:"list-item";s:5:"label";s:5:"Phone";s:4:"hook";s:20:"atbdp_listings_phone";s:11:"widget_name";s:5:"phone";s:10:"widget_key";s:5:"phone";s:19:"original_widget_key";s:5:"phone";s:4:"icon";s:23:"fas fa-phone-square-alt";s:10:"show_label";s:0:"";}}s:7:"excerpt";a:0:{}}s:6:"footer";a:2:{s:5:"right";a:1:{i:0;a:7:{s:4:"type";s:5:"price";s:11:"widget_name";s:12:"listing_link";s:5:"label";s:12:"Listing Link";s:4:"hook";s:18:"atbdp_listing_link";s:10:"widget_key";s:12:"listing_link";s:10:"label_link";s:7:"Details";s:4:"icon";s:17:"fa-solid fa-house";}}s:4:"left";a:1:{i:0;a:6:{s:4:"type";s:5:"price";s:5:"label";s:7:"Pricing";s:4:"hook";s:27:"atbdp_single_listings_price";s:11:"widget_name";s:7:"pricing";s:10:"widget_key";s:7:"pricing";s:19:"original_widget_key";s:7:"pricing";}}}}s:27:"list_view_without_thumbnail";a:2:{s:4:"body";a:4:{s:3:"top";a:5:{i:0;a:6:{s:4:"type";s:5:"title";s:5:"label";s:5:"Title";s:4:"hook";s:19:"atbdp_listing_title";s:11:"widget_name";s:13:"listing_title";s:10:"widget_key";s:13:"listing_title";s:12:"show_tagline";s:0:"";}i:1;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:8:"Featured";s:4:"hook";s:20:"atbdp_featured_badge";s:11:"widget_name";s:14:"featured_badge";s:10:"widget_key";s:14:"featured_badge";}i:2;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:3:"New";s:4:"hook";s:15:"atbdp_new_badge";s:11:"widget_name";s:9:"new_badge";s:10:"widget_key";s:9:"new_badge";}i:3;a:5:{s:4:"type";s:5:"badge";s:5:"label";s:7:"Popular";s:4:"hook";s:19:"atbdp_popular_badge";s:11:"widget_name";s:13:"popular_badge";s:10:"widget_key";s:13:"popular_badge";}i:4;a:6:{s:4:"type";s:5:"price";s:5:"label";s:7:"Pricing";s:4:"hook";s:27:"atbdp_single_listings_price";s:11:"widget_name";s:7:"pricing";s:10:"widget_key";s:7:"pricing";s:19:"original_widget_key";s:7:"pricing";}}s:5:"right";a:1:{i:0;a:5:{s:4:"type";s:4:"icon";s:5:"label";s:8:"Favorite";s:4:"hook";s:20:"atbdp_favorite_badge";s:11:"widget_name";s:14:"favorite_badge";s:10:"widget_key";s:14:"favorite_badge";}}s:6:"bottom";a:2:{i:0;a:8:{s:4:"type";s:9:"list-item";s:5:"label";s:7:"Address";s:4:"hook";s:26:"atbdp_listings_map_address";s:11:"widget_name";s:7:"address";s:10:"widget_key";s:7:"address";s:19:"original_widget_key";s:7:"address";s:4:"icon";s:17:"las la-map-marker";s:10:"show_label";s:0:"";}i:1;a:8:{s:4:"type";s:9:"list-item";s:5:"label";s:5:"Phone";s:4:"hook";s:20:"atbdp_listings_phone";s:11:"widget_name";s:5:"phone";s:10:"widget_key";s:5:"phone";s:19:"original_widget_key";s:5:"phone";s:4:"icon";s:12:"las la-phone";s:10:"show_label";s:0:"";}}s:7:"excerpt";a:0:{}}s:6:"footer";a:2:{s:5:"right";a:1:{i:0;a:6:{s:4:"type";s:6:"avatar";s:5:"label";s:11:"User Avatar";s:4:"hook";s:17:"atbdp_user_avatar";s:8:"can_move";s:1:"1";s:11:"widget_name";s:11:"user_avatar";s:10:"widget_key";s:11:"user_avatar";}}s:4:"left";a:1:{i:0;a:7:{s:4:"type";s:8:"category";s:5:"label";s:8:"Category";s:4:"hook";s:14:"atbdp_category";s:11:"widget_name";s:8:"category";s:10:"widget_key";s:8:"category";s:19:"original_widget_key";s:8:"category";s:4:"icon";s:13:"las la-folder";}}}}}}', true);
	   update_term_meta($general_type_id, 'listings_card_list_view', $data_listings_card_list_view);
		$data_general_config = maybe_unserialize('a:2:{s:4:"icon";s:21:"fas fa-map-marker-alt";s:13:"preview_image";s:0:"";}', true);
	   update_term_meta($general_type_id, 'general_config', $data_general_config);
		$data_single_listings_sidebar = maybe_unserialize('a:2:{s:6:"fields";a:7:{s:5:"phone";a:5:{s:4:"icon";s:12:"las la-phone";s:12:"widget_group";s:14:"preset_widgets";s:11:"widget_name";s:5:"phone";s:19:"original_widget_key";s:5:"phone";s:10:"widget_key";s:5:"phone";}s:3:"fax";a:5:{s:4:"icon";s:10:"las la-fax";s:12:"widget_group";s:14:"preset_widgets";s:11:"widget_name";s:3:"fax";s:19:"original_widget_key";s:3:"fax";s:10:"widget_key";s:3:"fax";}s:5:"email";a:5:{s:4:"icon";s:15:"las la-envelope";s:12:"widget_group";s:14:"preset_widgets";s:11:"widget_name";s:5:"email";s:19:"original_widget_key";s:5:"email";s:10:"widget_key";s:5:"email";}s:7:"website";a:6:{s:4:"icon";s:12:"las la-globe";s:12:"use_nofollow";s:0:"";s:12:"widget_group";s:14:"preset_widgets";s:11:"widget_name";s:7:"website";s:19:"original_widget_key";s:7:"website";s:10:"widget_key";s:7:"website";}s:3:"zip";a:5:{s:4:"icon";s:18:"las la-street-view";s:12:"widget_group";s:14:"preset_widgets";s:11:"widget_name";s:3:"zip";s:19:"original_widget_key";s:3:"zip";s:10:"widget_key";s:3:"zip";}s:11:"social_info";a:5:{s:4:"icon";s:16:"las la-share-alt";s:12:"widget_group";s:14:"preset_widgets";s:11:"widget_name";s:11:"social_info";s:19:"original_widget_key";s:11:"social_info";s:10:"widget_key";s:11:"social_info";}s:7:"address";a:6:{s:4:"icon";s:10:"las la-map";s:21:"address_link_with_map";s:0:"";s:12:"widget_group";s:14:"preset_widgets";s:11:"widget_name";s:7:"address";s:19:"original_widget_key";s:7:"address";s:10:"widget_key";s:7:"address";}}s:6:"groups";a:3:{i:0;a:9:{s:4:"type";s:7:"section";s:5:"label";s:11:"Author Info";s:6:"fields";a:0:{}s:10:"section_id";s:1:"4";s:4:"icon";s:11:"las la-user";s:15:"custom_block_id";s:0:"";s:20:"custom_block_classes";s:0:"";s:12:"widget_group";s:13:"other_widgets";s:11:"widget_name";s:11:"author_info";}i:1;a:5:{s:4:"type";s:13:"general_group";s:5:"label";s:16:"Property Contact";s:6:"fields";a:7:{i:0;s:7:"address";i:1;s:5:"phone";i:2;s:3:"fax";i:3;s:5:"email";i:4;s:7:"website";i:5;s:3:"zip";i:6;s:11:"social_info";}s:10:"section_id";s:1:"3";s:4:"icon";s:15:"las la-list-alt";}i:2;a:9:{s:4:"type";s:7:"section";s:5:"label";s:21:"Contact Listing Owner";s:6:"fields";a:0:{}s:10:"section_id";s:1:"2";s:4:"icon";s:19:"las la-comment-dots";s:15:"custom_block_id";s:0:"";s:20:"custom_block_classes";s:0:"";s:12:"widget_group";s:13:"other_widgets";s:11:"widget_name";s:22:"contact_listings_owner";}}}', true);
	   update_term_meta($general_type_id, 'single_listings_sidebar', $data_single_listings_sidebar);
	}

	// Update Listing content
	$general_id = '';
	$villa_id = '';
	$apartment_id = '';
	$directory_ids = array();
	$directories =  get_terms(array(
		'hide_empty' 	=> false,
		'default_only' => false,
		'taxonomy' 	=> ATBDP_DIRECTORY_TYPE
	));
	if ( is_wp_error( $directories ) || empty( $directories ) ) {
		
	}else{
		foreach ( $directories as $directory ) {
			$directory_ids[] = $directory->term_id;
			if($directory->slug == 'general'){
				$general_id = $directory->term_id;
			}elseif($directory->slug == 'villa'){
				$villa_id = $directory->term_id;
			}elseif($directory->slug == 'apartment'){
				$apartment_id = $directory->term_id;
			}
		}
	}

	// Locations
	$location_ids = array();
	$locations = get_terms(array(
		'hide_empty' 	=> false,
		'default_only' => false,
		'taxonomy' 	=> ATBDP_LOCATION
	));
	if ( is_wp_error( $locations ) || empty( $locations ) ) {

	}else{
		foreach ( $locations as $location ) {
			$location_ids[] = $location->term_id;
			update_term_meta($location->term_id, '_directory_type', $directory_ids);
		}
	}

	//Update Listing General
	global $wpdb;
	$execute = $wpdb->query("UPDATE " . $wpdb->postmeta . " SET meta_value = $general_id WHERE meta_key = '_directory_type' AND meta_value = 28");
	//Update Listing Villa
	$execute = $wpdb->query("UPDATE " . $wpdb->postmeta . " SET meta_value = $villa_id WHERE meta_key = '_directory_type' AND meta_value = 36");
	//Update Listing Apartment
	$execute = $wpdb->query("UPDATE " . $wpdb->postmeta . " SET meta_value = $apartment_id WHERE meta_key = '_directory_type' AND meta_value = 37");
	wp_reset_query();

	// Import Settings of Event
	$options_event = maybe_unserialize('a:16:{s:8:"did_init";b:1;s:19:"tribeEventsTemplate";s:0:"";s:16:"tribeEnableViews";a:3:{i:0;s:4:"list";i:1;s:5:"month";i:2;s:3:"day";}s:10:"viewOption";s:4:"list";s:14:"schema-version";s:7:"6.2.0.1";s:21:"previous_ecp_versions";a:3:{i:0;s:1:"0";i:1;s:5:"6.1.3";i:2;s:5:"6.1.4";}s:18:"latest_ecp_version";s:7:"6.2.0.1";s:18:"dateWithYearFormat";s:6:"F j, Y";s:24:"recurrenceMaxMonthsAfter";i:60;s:22:"google_maps_js_api_key";s:39:"AIzaSyDNsicAsP6-VuGtAb1O9riI3oc_NOb7IOU";s:39:"last-update-message-the-events-calendar";s:5:"6.1.3";s:24:"front_page_event_archive";b:0;s:11:"latest_date";s:19:"2024-08-25 17:00:00";s:13:"earliest_date";s:19:"2024-05-09 08:00:00";s:21:"earliest_date_markers";a:1:{i:0;i:331;}s:19:"latest_date_markers";a:1:{i:0;i:330;}}', true);
	update_option('tribe_events_calendar_options', $options_event);

	if (function_exists('is_plugin_active') && is_plugin_active( 'elementor/elementor.php' )) {
		\Elementor\Plugin::$instance->files_manager->clear_cache();
	}
}

add_action('wbc_importer_after_content_import', 'homirx_themer_import_sample', 10, 2);




//add_action('init', 'update_listing_type');
function update_listing_type(){
	$args = array(
		'term_id'		  => 36,
		//'directory_name' => 'General', // remove when update exsiting listing type
	   'fields_value'   => '{"icon":"las la-home","preview_image":"","import_export":"","default_expiration":"365","new_listing_status":"pending","edit_listing_status":"pending","global_listing_type":"0","submission_form_fields":{"fields":{"title":{"widget_group":"preset","widget_name":"title","type":"text","field_key":"listing_title","required":"1","label":"Title","placeholder":"","widget_key":"title"},"description":{"type":"wp_editor","field_key":"listing_content","label":"Description","placeholder":"","required":"","only_for_admin":"","widget_name":"description","widget_group":"preset","widget_key":"description"},"pricing":{"label":"Pricing","pricing_type":"both","price_range_label":"Price Range","price_range_placeholder":"Select Price Range","price_unit_field_type":"number","price_unit_field_label":"Price [USD]","price_unit_field_placeholder":"Price of this listing. Eg. 100","only_for_admin":"","widget_name":"pricing","widget_group":"preset","field_key":"","widget_key":"pricing"},"location":{"field_key":"tax_input[at_biz_dir-location][]","label":"Location","type":"multiple","placeholder":"","required":"","only_for_admin":"","widget_name":"location","widget_group":"preset","widget_key":"location","create_new_loc":""},"tag":{"field_key":"tax_input[at_biz_dir-tags][]","label":"Tag","placeholder":"Tag","type":"multiple","required":"","allow_new":"1","only_for_admin":"","widget_name":"tag","widget_group":"preset","widget_key":"tag"},"category":{"field_key":"admin_category_select[]","label":"Category","type":"multiple","placeholder":"","required":"","only_for_admin":"","widget_name":"category","widget_group":"preset","widget_key":"category","create_new_cat":""},"zip":{"type":"text","field_key":"zip","label":"Zip/Post Code","placeholder":"","required":"","only_for_admin":"","widget_name":"zip","widget_group":"preset","widget_key":"zip"},"phone":{"type":"tel","field_key":"phone","label":"Phone","placeholder":"","required":"","only_for_admin":"","widget_name":"phone","widget_group":"preset","widget_key":"phone","whatsapp":""},"phone2":{"type":"tel","field_key":"phone2","label":"Phone 2","placeholder":"","required":"","only_for_admin":"","widget_name":"phone2","widget_group":"preset","widget_key":"phone2","whatsapp":""},"fax":{"type":"number","field_key":"fax","label":"Fax","placeholder":"","required":"","only_for_admin":"","widget_name":"fax","widget_group":"preset","widget_key":"fax"},"email":{"type":"email","field_key":"email","label":"Email","placeholder":"","required":"","only_for_admin":"","widget_name":"email","widget_group":"preset","widget_key":"email"},"website":{"type":"text","field_key":"website","label":"Website","placeholder":"","required":"","only_for_admin":"","widget_name":"website","widget_group":"preset","widget_key":"website"},"social_info":{"type":"add_new","field_key":"social","label":"Social Info","required":"","only_for_admin":"","widget_name":"social_info","widget_group":"preset","widget_key":"social_info"},"view_count":{"type":"number","field_key":"atbdp_post_views_count","label":"View Count","placeholder":"","required":"","only_for_admin":"1","widget_name":"view_count","widget_group":"preset","widget_key":"view_count"},"map":{"type":"map","field_key":"map","label":"Map","lat_long":"Or Enter Coordinates (latitude and longitude) Manually","required":"","only_for_admin":"","widget_name":"map","widget_group":"preset","widget_key":"map"},"hide_contact_owner":{"type":"text","field_key":"hide_contact_owner","label":"Hide contact owner form for single listing page","widget_name":"hide_contact_owner","widget_group":"preset","widget_key":"hide_contact_owner"},"image_upload":{"type":"media","field_key":"listing_img","label":"Images","required":"","select_files_label":"Select Files","max_image_limit":"5","max_per_image_limit":"0","max_total_image_limit":"2","only_for_admin":"","widget_name":"image_upload","widget_group":"preset","widget_key":"image_upload"},"video":{"type":"text","field_key":"videourl","label":"Video","placeholder":"Only YouTube & Vimeo URLs.","required":"","only_for_admin":"","widget_name":"video","widget_group":"preset","widget_key":"video"},"tagline":{"type":"text","field_key":"tagline","label":"Tagline","placeholder":"","required":"","only_for_admin":"","widget_name":"tagline","widget_group":"preset","widget_key":"tagline"},"address":{"type":"text","field_key":"address","label":"Address","placeholder":"Listing address eg. New York, USA","required":"","only_for_admin":"","widget_name":"address","widget_group":"preset","widget_key":"address"},"text":{"type":"text","field_key":"custom-text","label":"Number ID","description":"","placeholder":"Number ID","required":"","only_for_admin":"","assign_to":"form","category":"","widget_group":"custom","widget_name":"text","widget_key":"text"},"number":{"type":"number","field_key":"custom-number","label":"Bed","description":"","placeholder":"Number Bedroom","required":"","only_for_admin":"","assign_to":"form","category":"","widget_group":"custom","widget_name":"number","widget_key":"number"},"number_2":{"type":"number","field_key":"custom-number-2","label":"Bath","description":"","placeholder":"Number Bath","required":"","only_for_admin":"","assign_to":"form","category":"","widget_group":"custom","widget_name":"number","widget_key":"number_2"},"text_2":{"type":"text","field_key":"custom-text-2","label":"Size","description":"","placeholder":"","required":"","only_for_admin":"","assign_to":"form","category":"","widget_group":"custom","widget_name":"text","widget_key":"text_2"},"excerpt":{"type":"textarea","field_key":"excerpt","label":"Excerpt","placeholder":"","required":"","only_for_admin":"","widget_group":"preset","widget_name":"excerpt","widget_key":"excerpt"}},"groups":[{"label":"General Section","lock":"1","fields":["title","excerpt","description","tagline","pricing","location","tag","category","view_count"],"plans":[],"type":"general_group"},{"label":"Map","fields":["address","map"],"type":"general_group"},{"type":"general_group","label":"Information","fields":["text","number","number_2","text_2"],"defaultGroupLabel":"Section","disableTrashIfGroupHasWidgets":[{"widget_name":"title","widget_group":"preset"}]},{"label":"Contact Information","fields":["hide_contact_owner","zip","phone","phone2","fax","email","website","social_info"],"type":"general_group"},{"label":"Images & Video","fields":["image_upload","video"],"type":"general_group"}]},"preview_mode":"1","submit_button_label":"Save & Preview","listing_terms_condition":"1","require_terms_conditions":"1","terms_label":"I agree with all %terms & conditions%","listing_privacy":"1","require_privacy":"1","privacy_label":"I agree to the %Privacy & Policy%","single_listings_contents":{"fields":{"tag":{"icon":"las la-tag","widget_name":"tag","widget_group":"preset_widgets","original_widget_key":"tag","widget_key":"tag"},"map":{"icon":"las la-map","widget_name":"map","widget_group":"preset_widgets","original_widget_key":"map","widget_key":"map"},"video":{"icon":"las la-video","widget_name":"video","widget_group":"preset_widgets","original_widget_key":"video","widget_key":"video"},"number":{"icon":"las la-bed","widget_group":"preset_widgets","widget_name":"number","original_widget_key":"number","widget_key":"number"},"text_2":{"icon":"las la-chart-bar","widget_group":"preset_widgets","widget_name":"text","original_widget_key":"text_2","widget_key":"text_2"},"number_2":{"icon":"las la-bath","widget_group":"preset_widgets","widget_name":"number","original_widget_key":"number_2","widget_key":"number_2"},"text":{"icon":"las la-tags","widget_group":"preset_widgets","widget_name":"text","original_widget_key":"text","widget_key":"text"}},"groups":[{"label":"Overview","fields":["text","number","number_2","text_2"],"type":"general_group","icon":"lab la-buromobelexperte","custom_block_id":"","custom_block_classes":"property-overiew","section_id":"1627188303653"},{"label":"Tag","fields":["tag"],"type":"general_group","icon":"las la-tags","custom_block_id":"","custom_block_classes":"","section_id":"1627188303650"},{"label":"Preview Video","fields":["video"],"type":"general_group","icon":"las la-video atbd_area_icon","custom_block_id":"","custom_block_classes":"card-radius","section_id":"1627188303651"},{"label":"Location","fields":["map"],"type":"general_group","icon":"las la-map","custom_block_id":"","custom_block_classes":"card-radius","section_id":"1627188303652"},{"label":"Review","fields":[],"type":"widget_group","widget_group":"other_widgets","widget_name":"review","custom_block_id":"","custom_block_classes":"","section_id":"1627188303656"},{"label":"Related Listings","fields":[],"type":"widget_group","widget_group":"other_widgets","widget_name":"related_listings","custom_block_id":"","custom_block_classes":"","section_id":"1627188303657"}]},"single_listings_sidebar":{"fields":{"phone":{"icon":"las la-phone","widget_group":"preset_widgets","widget_name":"phone","original_widget_key":"phone","widget_key":"phone"},"fax":{"icon":"las la-fax","widget_group":"preset_widgets","widget_name":"fax","original_widget_key":"fax","widget_key":"fax"},"email":{"icon":"las la-envelope","widget_group":"preset_widgets","widget_name":"email","original_widget_key":"email","widget_key":"email"},"website":{"icon":"las la-globe","use_nofollow":"","widget_group":"preset_widgets","widget_name":"website","original_widget_key":"website","widget_key":"website"},"zip":{"icon":"las la-street-view","widget_group":"preset_widgets","widget_name":"zip","original_widget_key":"zip","widget_key":"zip"},"social_info":{"icon":"las la-share-alt","widget_group":"preset_widgets","widget_name":"social_info","original_widget_key":"social_info","widget_key":"social_info"},"address":{"icon":"las la-map","address_link_with_map":"","widget_group":"preset_widgets","widget_name":"address","original_widget_key":"address","widget_key":"address"}},"groups":[{"type":"section","label":"Author Info","fields":[],"section_id":"4","icon":"las la-user","custom_block_id":"","custom_block_classes":"","widget_group":"other_widgets","widget_name":"author_info"},{"type":"general_group","label":"Property Contact Information","fields":["address","phone","fax","email","website","zip","social_info"],"section_id":"3"},{"type":"section","label":"Contact The Listing Owner","fields":[],"section_id":"2","icon":"las la-phone","custom_block_id":"","custom_block_classes":"","widget_group":"other_widgets","widget_name":"contact_listings_owner"}]},"enable_single_listing_page":"0","single_listing_page":"530","single_listings_shortcodes":[null],"similar_listings_logics":"AND","listing_from_same_author":"1","similar_listings_number_of_listings_to_show":"4","similar_listings_number_of_columns":"2","search_form_fields":{"fields":{"title":{"required":"","label":"","placeholder":"What are you looking for?","widget_name":"title","widget_group":"available_widgets","original_widget_key":"title","widget_key":"title"},"category":{"required":"","label":"","placeholder":"Category","widget_name":"category","widget_group":"available_widgets","original_widget_key":"category","widget_key":"category"},"location":{"required":"","label":"","placeholder":"Location","location_source":"from_map_api","widget_name":"location","widget_group":"available_widgets","original_widget_key":"location","widget_key":"location"},"pricing":{"price_range_min_placeholder":"Min","price_range_max_placeholder":"Max","widget_name":"pricing","widget_group":"available_widgets","original_widget_key":"pricing","widget_key":"pricing"},"review":{"label":"Review","widget_name":"review","widget_group":"other_widgets","widget_key":"review"},"radius_search":{"label":"Radius Search","default_radius_distance":"0","radius_search_unit":"miles","widget_name":"radius_search","widget_group":"other_widgets","widget_key":"radius_search","radius_search_based_on":"address"},"tag":{"label":"Tag","widget_name":"tag","widget_group":"available_widgets","original_widget_key":"tag","widget_key":"tag"},"zip":{"label":"Zip/Post Code","placeholder":"Zip","required":"","widget_name":"zip","widget_group":"available_widgets","original_widget_key":"zip","widget_key":"zip"},"phone":{"label":"Phone","placeholder":"Phone","required":"","widget_name":"phone","widget_group":"available_widgets","original_widget_key":"phone","widget_key":"phone"},"phone2":{"label":"Phone 2","placeholder":"Phone 2","required":"","widget_name":"phone2","widget_group":"available_widgets","original_widget_key":"phone2","widget_key":"phone2"},"fax":{"label":"Fax","placeholder":"Fax","required":"","widget_name":"fax","widget_group":"available_widgets","original_widget_key":"fax","widget_key":"fax"},"email":{"label":"Email","placeholder":"Email","required":"","widget_name":"email","widget_group":"available_widgets","original_widget_key":"email","widget_key":"email"},"website":{"label":"Website","placeholder":"Website","required":"","widget_name":"website","widget_group":"available_widgets","original_widget_key":"website","widget_key":"website"}},"groups":[{"label":"Basic","lock":"1","draggable":"","fields":["title","category","location"],"type":"general_group"},{"label":"Advanced","lock":"1","draggable":"","fields":["pricing","review","radius_search","tag","zip","phone","phone2","fax","email","website"],"type":"general_group"}]},"single_listing_header":{"listings_header":{"quick_actions":[{"type":"button","label":"Bookmark","widget_name":"bookmark","widget_key":"bookmark"},{"type":"badge","label":"Share","widget_name":"share","widget_key":"share","icon":"las la-share"},{"type":"badge","label":"Report","widget_name":"report","widget_key":"report","icon":"las la-flag"}],"thumbnail":[{"type":"thumbnail","label":"Listings Slider","can_move":"","widget_name":"listing_slider","widget_key":"listing_slider","footer_thumbail":"1"}],"quick_info":[{"type":"ratings-count","label":"Listings Ratings","widget_name":"ratings_count","widget_key":"ratings_count"},{"type":"reviews","label":"Listings Reviews","widget_name":"reviews","widget_key":"reviews"},{"type":"badge","label":"Badges","widget_name":"badges","widget_key":"badges","new_badge":"1","popular_badge":"1","featured_badge":"1"},{"type":"badge","label":"Category","widget_name":"category","widget_key":"category"},{"type":"badge","label":"Location","widget_name":"location","widget_key":"location"}]},"options":{"general":{"back":{"label":"1"},"section_title":{"use_listing_title":"","label":"Section Title","icon":""}},"content_settings":{"listing_title":{"enable_title":"","enable_tagline":""},"listing_description":{"enable":"1"}}}},"listings_card_grid_view":{"thumbnail":{"top_right":[{"type":"icon","label":"Favorite","hook":"atbdp_favorite_badge","widget_name":"favorite_badge","widget_key":"favorite_badge"}],"top_left":[{"type":"badge","label":"Featured","hook":"atbdp_featured_badge","widget_name":"featured_badge","widget_key":"featured_badge"}],"bottom_right":[],"bottom_left":[{"type":"badge","label":"Popular","hook":"atbdp_popular_badge","widget_name":"popular_badge","widget_key":"popular_badge"},{"type":"badge","label":"New","hook":"atbdp_new_badge","widget_name":"new_badge","widget_key":"new_badge"}],"avatar":[{"type":"avatar","label":"User Avatar","hook":"atbdp_user_avatar","can_move":"","widget_name":"user_avatar","widget_key":"user_avatar","align":"right"}]},"body":{"top":[{"type":"title","label":"Title","hook":"atbdp_listing_title","widget_name":"listing_title","widget_key":"listing_title","show_tagline":""},{"type":"rating","label":"Rating","hook":"atbdp_listings_rating","widget_name":"rating","widget_key":"rating"},{"type":"price","label":"Pricing","hook":"atbdp_single_listings_price","widget_name":"pricing","widget_key":"pricing"}],"bottom":[{"type":"list-item","label":"Location","hook":"atbdp_listings_location","widget_name":"listings_location","widget_key":"listings_location","icon":"las la-map-marker"},{"type":"list-item","label":"Phone","hook":"atbdp_listings_phone","widget_name":"phone","widget_key":"phone","icon":"las la-phone"},{"type":"list-item","label":"Posted Date","hook":"atbdp_listings_posted_date","widget_name":"posted_date","widget_key":"posted_date","icon":"las la-clock","date_type":"post_date"}],"excerpt":[]},"footer":{"right":[{"type":"view-count","label":"View Count","hook":"atbdp_view_count","widget_name":"view_count","widget_key":"view_count","icon":"las la-heart"}],"left":[{"type":"category","label":"Category","hook":"atbdp_category","widget_name":"category","widget_key":"category","icon":"las la-folder"}]},"active_template":"grid_view_with_thumbnail","template_data":{"grid_view_with_thumbnail":{"thumbnail":{"top_right":[{"type":"icon","label":"Favorite","hook":"atbdp_favorite_badge","widget_name":"favorite_badge","widget_key":"favorite_badge"}],"top_left":[{"type":"badge","label":"Popular","hook":"atbdp_popular_badge","widget_name":"popular_badge","widget_key":"popular_badge"}],"bottom_right":[],"bottom_left":[{"type":"badge","label":"Featured","hook":"atbdp_featured_badge","widget_name":"featured_badge","widget_key":"featured_badge"},{"type":"badge","label":"New","hook":"atbdp_new_badge","widget_name":"new_badge","widget_key":"new_badge"}],"avatar":[{"type":"avatar","label":"User Avatar","hook":"atbdp_user_avatar","can_move":"","widget_name":"user_avatar","widget_key":"user_avatar","align":"right"}]},"body":{"top":[{"type":"rating","label":"Rating","hook":"atbdp_listings_rating","widget_name":"rating","widget_key":"rating"},{"type":"title","label":"Title","hook":"atbdp_listing_title","widget_name":"listing_title","widget_key":"listing_title","original_widget_key":"title","show_tagline":""},{"type":"list-item","label":"Address","hook":"atbdp_listings_map_address","widget_name":"address","widget_key":"address","original_widget_key":"address","icon":"las la-map-marker","show_label":""}],"bottom":[{"type":"list-item","label":"Excerpt","hook":"atbdp_listing_excerpt","widget_name":"excerpt","widget_key":"excerpt","original_widget_key":"excerpt","words_limit":"20","show_readmore":"","show_readmore_text":"Read More"}],"excerpt":[{"type":"list-item","label":"Size","hook":"atbdp_custom_text","widget_name":"text","widget_key":"text_2","original_widget_key":"text_2","icon":"fa-solid fa-expand","show_label":""},{"type":"list-item","label":"Bed","hook":"atbdp_custom_number","widget_name":"number","widget_key":"number","original_widget_key":"number","icon":"fa-solid fa-bed","show_label":"1"},{"type":"list-item","label":"Bath","hook":"atbdp_custom_number","widget_name":"number","widget_key":"number_2","original_widget_key":"number_2","icon":"fa-solid fa-bath","show_label":"1"}]},"footer":{"right":[{"type":"price","widget_name":"listing_link","label":"Listing Link","hook":"atbdp_listing_link","widget_key":"listing_link","label_link":"Details","icon":"fa-solid fa-house"}],"left":[{"type":"price","label":"Pricing","hook":"atbdp_single_listings_price","widget_name":"pricing","widget_key":"pricing","original_widget_key":"pricing"}]}},"grid_view_without_thumbnail":{"body":{"avatar":[{"type":"avatar","label":"User Avatar","hook":"atbdp_user_avatar","can_move":"","widget_name":"user_avatar","widget_key":"user_avatar","align":"center"}],"title":[{"type":"title","label":"Title","hook":"atbdp_listing_title","widget_name":"listing_title","widget_key":"listing_title","show_tagline":""}],"quick_actions":[{"type":"icon","label":"Favorite","hook":"atbdp_favorite_badge","widget_name":"favorite_badge","widget_key":"favorite_badge"}],"quick_info":[{"type":"rating","label":"Rating","hook":"atbdp_listings_rating","widget_name":"rating","widget_key":"rating"},{"type":"price","label":"Pricing","hook":"atbdp_single_listings_price","widget_name":"pricing","widget_key":"pricing","original_widget_key":"pricing"},{"type":"badge","label":"Featured","hook":"atbdp_featured_badge","widget_name":"featured_badge","widget_key":"featured_badge"},{"type":"badge","label":"New","hook":"atbdp_new_badge","widget_name":"new_badge","widget_key":"new_badge"},{"type":"badge","label":"Popular","hook":"atbdp_popular_badge","widget_name":"popular_badge","widget_key":"popular_badge"}],"bottom":[{"type":"list-item","label":"Location","hook":"atbdp_listings_location","widget_name":"listings_location","widget_key":"listings_location","icon":"las la-map-marker"},{"type":"list-item","label":"Phone","hook":"atbdp_listings_phone","widget_name":"phone","widget_key":"phone","icon":"las la-phone","original_widget_key":"phone"},{"type":"list-item","label":"Email","hook":"atbdp_listings_email","widget_name":"email","widget_key":"email","icon":"las la-envelope","original_widget_key":"email"}],"excerpt":[]},"footer":{"right":[{"type":"view-count","label":"View Count","hook":"atbdp_view_count","widget_name":"view_count","widget_key":"view_count","icon":"las la-heart","original_widget_key":"view_count"}],"left":[{"type":"category","label":"Category","hook":"atbdp_category","widget_name":"category","widget_key":"category","icon":"las la-folder","original_widget_key":"category"}]}}}},"listings_card_list_view":{"thumbnail":{"top_right":[{"type":"badge","label":"Popular","hook":"atbdp_popular_badge","widget_name":"popular_badge","widget_key":"popular_badge"},{"type":"badge","label":"New","hook":"atbdp_new_badge","widget_name":"new_badge","widget_key":"new_badge"}]},"body":{"top":[{"type":"title","label":"Title","hook":"atbdp_listing_title","widget_name":"listing_title","widget_key":"listing_title","show_tagline":""},{"type":"rating","label":"Rating","hook":"atbdp_listings_rating","widget_name":"rating","widget_key":"rating"},{"type":"price","label":"Pricing","hook":"atbdp_single_listings_price","widget_name":"pricing","widget_key":"pricing"},{"type":"badge","label":"Featured","hook":"atbdp_featured_badge","widget_name":"featured_badge","widget_key":"featured_badge"}],"right":[{"type":"icon","label":"Favorite","hook":"atbdp_favorite_badge","widget_name":"favorite_badge","widget_key":"favorite_badge"}],"bottom":[{"type":"list-item","label":"Location","hook":"atbdp_listings_location","widget_name":"listings_location","widget_key":"listings_location","icon":"las la-map-marker"},{"type":"list-item","label":"Phone","hook":"atbdp_listings_phone","widget_name":"phone","widget_key":"phone","icon":"las la-phone"},{"type":"list-item","label":"Posted Date","hook":"atbdp_listings_posted_date","widget_name":"posted_date","widget_key":"posted_date","icon":"las la-clock","date_type":"post_date"}],"excerpt":[]},"footer":{"right":[{"type":"view-count","label":"View Count","hook":"atbdp_view_count","widget_name":"view_count","widget_key":"view_count","icon":"las la-heart"},{"type":"avatar","label":"User Avatar","hook":"atbdp_user_avatar","can_move":"1","widget_name":"user_avatar","widget_key":"user_avatar"}],"left":[{"type":"category","label":"Category","hook":"atbdp_category","widget_name":"category","widget_key":"category","icon":"las la-folder"}]},"active_template":"list_view_with_thumbnail","template_data":{"list_view_with_thumbnail":{"thumbnail":{"top_right":[{"type":"badge","label":"Featured","hook":"atbdp_featured_badge","widget_name":"featured_badge","widget_key":"featured_badge"},{"type":"badge","label":"Popular","hook":"atbdp_popular_badge","widget_name":"popular_badge","widget_key":"popular_badge"},{"type":"badge","label":"New","hook":"atbdp_new_badge","widget_name":"new_badge","widget_key":"new_badge"}]},"body":{"top":[{"type":"rating","label":"Rating","hook":"atbdp_listings_rating","widget_name":"rating","widget_key":"rating"},{"type":"title","label":"Title","hook":"atbdp_listing_title","widget_name":"listing_title","widget_key":"listing_title","show_tagline":""},{"type":"list-item","label":"Address","hook":"atbdp_listings_map_address","widget_name":"address","widget_key":"address","original_widget_key":"address","icon":"las la-map-marker","show_label":""}],"right":[{"type":"icon","label":"Favorite","hook":"atbdp_favorite_badge","widget_name":"favorite_badge","widget_key":"favorite_badge"}],"bottom":[],"excerpt":[{"type":"list-item","label":"Size","hook":"atbdp_custom_text","widget_name":"text","widget_key":"text_2","original_widget_key":"text_2","icon":"fa-solid fa-expand","show_label":""},{"type":"list-item","label":"Bed","hook":"atbdp_custom_number","widget_name":"number","widget_key":"number","original_widget_key":"number","icon":"fa-solid fa-bath","show_label":"1"},{"type":"list-item","label":"Bath","hook":"atbdp_custom_number","widget_name":"number","widget_key":"number_2","original_widget_key":"number_2","icon":"fa-solid fa-bath","show_label":"1"}]},"footer":{"right":[{"type":"price","widget_name":"listing_link","label":"Listing Link","hook":"atbdp_listing_link","widget_key":"listing_link","label_link":"Details","icon":"fa-solid fa-house"}],"left":[{"type":"price","label":"Pricing","hook":"atbdp_single_listings_price","widget_name":"pricing","widget_key":"pricing","original_widget_key":"pricing"}]}},"list_view_without_thumbnail":{"body":{"top":[{"type":"title","label":"Title","hook":"atbdp_listing_title","widget_name":"listing_title","widget_key":"listing_title","show_tagline":""},{"type":"rating","label":"Rating","hook":"atbdp_listings_rating","widget_name":"rating","widget_key":"rating"},{"type":"price","label":"Pricing","hook":"atbdp_single_listings_price","widget_name":"pricing","widget_key":"pricing","original_widget_key":"pricing"},{"type":"badge","label":"Featured","hook":"atbdp_featured_badge","widget_name":"featured_badge","widget_key":"featured_badge"},{"type":"badge","label":"New","hook":"atbdp_new_badge","widget_name":"new_badge","widget_key":"new_badge"},{"type":"badge","label":"Popular","hook":"atbdp_popular_badge","widget_name":"popular_badge","widget_key":"popular_badge"}],"right":[{"type":"icon","label":"Favorite","hook":"atbdp_favorite_badge","widget_name":"favorite_badge","widget_key":"favorite_badge"}],"bottom":[{"type":"list-item","label":"Location","hook":"atbdp_listings_location","widget_name":"listings_location","widget_key":"listings_location","icon":"las la-map-marker"},{"type":"list-item","label":"Phone","hook":"atbdp_listings_phone","widget_name":"phone","widget_key":"phone","icon":"las la-phone","original_widget_key":"phone"},{"type":"list-item","label":"Email","hook":"atbdp_listings_email","widget_name":"email","widget_key":"email","icon":"las la-envelope","original_widget_key":"email"}],"excerpt":[]},"footer":{"right":[{"type":"view-count","label":"View Count","hook":"atbdp_view_count","widget_name":"view_count","widget_key":"view_count","icon":"las la-heart","original_widget_key":"view_count"},{"type":"avatar","label":"User Avatar","hook":"atbdp_user_avatar","can_move":"","widget_name":"user_avatar","widget_key":"user_avatar","align":"center"}],"left":[{"type":"category","label":"Category","hook":"atbdp_category","widget_name":"category","widget_key":"category","icon":"las la-folder","original_widget_key":"category"}]}}}},"enable_review":"1","enable_owner_review":"1","guest_review":"0","approve_immediately":"1","review_enable_reply":"0","review_num":"5","enable_gdpr_consent":"0","gdpr_consent_label":"I have read and agree to the [privacy_policy]privacy policy[/privacy_policy] & [terms_conditions]terms and conditions[/terms_conditions].","script_debugging":"0","legacy_icon":"0","import_settings":[null],"export_settings":[null],"single_listing_slug_with_directory_type":"1","restore_default_settings":[null],"enable_multi_directory":"0","regenerate_pages":[null],"announcement":"","listing_import_button":[null],"listing_export_button":[null],"email_note":[null],"marker_clustering":"1","country_restriction":"0","use_def_lat_long":"0","restricted_countries":"","submission_confirmation":"1","pending_confirmation_msg":"Thank you for your submission. Your listing is being reviewed and it may take up to 24 hours to complete the review.","publish_confirmation_msg":"Congratulations! Your listing has been approved/published. Now it is publicly available.","lazy_load_taxonomy_fields":"0","review_cookies_consent":"","review_comment_label":"","review_comment_placeholder":"","review_email_label":"","review_email_placeholder":"","review_name_label":"","review_name_placeholder":"","review_show_website_field":"","review_website_label":"","review_website_placeholder":""}',
	   'is_json'        => true
	);
	
	$type = new Directorist\Multi_Directory\Multi_Directory_Manager();
	$type->prepare_settings();
	$type->add_directory($args);
};

