/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){function e(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var r,n={},i={};function s(){if(r)return i;r=1,Object.defineProperty(i,"__esModule",{value:!0}),i.setMatrixArrayType=function(t){i.ARRAY_TYPE=e=t;},i.toRadian=function(t){return t*s},i.equals=function(e,r){return Math.abs(e-r)<=t*Math.max(1,Math.abs(e),Math.abs(r))},i.RANDOM=i.ARRAY_TYPE=i.EPSILON=void 0;var t=1e-6;i.EPSILON=t;var e="undefined"!=typeof Float32Array?Float32Array:Array;i.ARRAY_TYPE=e;var n=Math.random;i.RANDOM=n;var s=Math.PI/180;return Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)}),i}var a,o={};function l(){if(a)return o;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}a=1,Object.defineProperty(o,"__esModule",{value:!0}),o.create=function(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},o.clone=function(t){var r=new e.ARRAY_TYPE(4);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r},o.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},o.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},o.fromValues=function(t,r,n,i){var s=new e.ARRAY_TYPE(4);return s[0]=t,s[1]=r,s[2]=n,s[3]=i,s},o.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},o.transpose=function(t,e){if(t===e){var r=e[1];t[1]=e[2],t[2]=r;}else t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3];return t},o.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*s-i*n;return a?(t[0]=s*(a=1/a),t[1]=-n*a,t[2]=-i*a,t[3]=r*a,t):null},o.adjoint=function(t,e){var r=e[0];return t[0]=e[3],t[1]=-e[1],t[2]=-e[2],t[3]=r,t},o.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},o.multiply=n,o.rotate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+s*o,t[1]=i*l+a*o,t[2]=n*-o+s*l,t[3]=i*-o+a*l,t},o.scale=function(t,e,r){var n=e[1],i=e[2],s=e[3],a=r[0],o=r[1];return t[0]=e[0]*a,t[1]=n*a,t[2]=i*o,t[3]=s*o,t},o.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t},o.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t},o.str=function(t){return "mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},o.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},o.LDU=function(t,e,r,n){return t[2]=n[2]/n[0],r[0]=n[0],r[1]=n[1],r[3]=n[3]-t[2]*r[1],[t,e,r]},o.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},o.subtract=i,o.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},o.equals=function(t,r){var n=t[0],i=t[1],s=t[2],a=t[3],o=r[0],l=r[1],u=r[2],c=r[3];return Math.abs(n-o)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(s-u)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(u))&&Math.abs(a-c)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(c))},o.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},o.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},o.sub=o.mul=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,i&&i.set(e,s),s}(s());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*o+s*l,t[1]=i*o+a*l,t[2]=n*u+s*c,t[3]=i*u+a*c,t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}return o.mul=n,o.sub=i,o}var u,c={};function h(){if(u)return c;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}u=1,Object.defineProperty(c,"__esModule",{value:!0}),c.create=function(){var t=new e.ARRAY_TYPE(6);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0),t[0]=1,t[3]=1,t},c.clone=function(t){var r=new e.ARRAY_TYPE(6);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r},c.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t},c.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},c.fromValues=function(t,r,n,i,s,a){var o=new e.ARRAY_TYPE(6);return o[0]=t,o[1]=r,o[2]=n,o[3]=i,o[4]=s,o[5]=a,o},c.set=function(t,e,r,n,i,s,a){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t},c.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=r*s-n*i;return l?(t[0]=s*(l=1/l),t[1]=-n*l,t[2]=-i*l,t[3]=r*l,t[4]=(i*o-s*a)*l,t[5]=(n*a-r*o)*l,t):null},c.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},c.multiply=n,c.rotate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+s*u,t[1]=i*c+a*u,t[2]=n*-u+s*c,t[3]=i*-u+a*c,t[4]=o,t[5]=l,t},c.scale=function(t,e,r){var n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=r[0],u=r[1];return t[0]=e[0]*l,t[1]=n*l,t[2]=i*u,t[3]=s*u,t[4]=a,t[5]=o,t},c.translate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=r[0],c=r[1];return t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=n*u+s*c+o,t[5]=i*u+a*c+l,t},c.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t[4]=0,t[5]=0,t},c.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t[4]=0,t[5]=0,t},c.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=e[0],t[5]=e[1],t},c.str=function(t){return "mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},c.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},c.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t},c.subtract=i,c.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t},c.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t},c.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]},c.equals=function(t,r){var n=t[0],i=t[1],s=t[2],a=t[3],o=t[4],l=t[5],u=r[0],c=r[1],h=r[2],p=r[3],f=r[4],d=r[5];return Math.abs(n-u)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(u))&&Math.abs(i-c)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(c))&&Math.abs(s-h)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(h))&&Math.abs(a-p)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(p))&&Math.abs(o-f)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(f))&&Math.abs(l-d)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(d))},c.sub=c.mul=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,i&&i.set(e,s),s}(s());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=r[0],c=r[1],h=r[2],p=r[3],f=r[4],d=r[5];return t[0]=n*u+s*c,t[1]=i*u+a*c,t[2]=n*h+s*p,t[3]=i*h+a*p,t[4]=n*f+s*d+o,t[5]=i*f+a*d+l,t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t}return c.mul=n,c.sub=i,c}var p,f={};function d(){if(p)return f;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}p=1,Object.defineProperty(f,"__esModule",{value:!0}),f.create=function(){var t=new e.ARRAY_TYPE(9);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t},f.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},f.clone=function(t){var r=new e.ARRAY_TYPE(9);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r},f.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},f.fromValues=function(t,r,n,i,s,a,o,l,u){var c=new e.ARRAY_TYPE(9);return c[0]=t,c[1]=r,c[2]=n,c[3]=i,c[4]=s,c[5]=a,c[6]=o,c[7]=l,c[8]=u,c},f.set=function(t,e,r,n,i,s,a,o,l,u){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t[6]=o,t[7]=l,t[8]=u,t},f.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},f.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[5];t[1]=e[3],t[2]=e[6],t[3]=r,t[5]=e[7],t[6]=n,t[7]=i;}else t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8];return t},f.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=c*a-o*u,p=-c*s+o*l,f=u*s-a*l,d=r*h+n*p+i*f;return d?(t[0]=h*(d=1/d),t[1]=(-c*n+i*u)*d,t[2]=(o*n-i*a)*d,t[3]=p*d,t[4]=(c*r-i*l)*d,t[5]=(-o*r+i*s)*d,t[6]=f*d,t[7]=(-u*r+n*l)*d,t[8]=(a*r-n*s)*d,t):null},f.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8];return t[0]=a*c-o*u,t[1]=i*u-n*c,t[2]=n*o-i*a,t[3]=o*l-s*c,t[4]=r*c-i*l,t[5]=i*s-r*o,t[6]=s*u-a*l,t[7]=n*l-r*u,t[8]=r*a-n*s,t},f.determinant=function(t){var e=t[3],r=t[4],n=t[5],i=t[6],s=t[7],a=t[8];return t[0]*(a*r-n*s)+t[1]*(-a*e+n*i)+t[2]*(s*e-r*i)},f.multiply=n,f.translate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1];return t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=p*n+f*a+u,t[7]=p*i+f*o+c,t[8]=p*s+f*l+h,t},f.rotate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=Math.sin(r),f=Math.cos(r);return t[0]=f*n+p*a,t[1]=f*i+p*o,t[2]=f*s+p*l,t[3]=f*a-p*n,t[4]=f*o-p*i,t[5]=f*l-p*s,t[6]=u,t[7]=c,t[8]=h,t},f.scale=function(t,e,r){var n=r[0],i=r[1];return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=i*e[3],t[4]=i*e[4],t[5]=i*e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},f.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=e[0],t[7]=e[1],t[8]=1,t},f.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},f.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=e[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},f.fromMat2d=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=0,t[3]=e[2],t[4]=e[3],t[5]=0,t[6]=e[4],t[7]=e[5],t[8]=1,t},f.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,f=i*o,d=i*l,m=s*a,y=s*o,g=s*l;return t[0]=1-h-d,t[3]=c-g,t[6]=p+y,t[1]=c+g,t[4]=1-u-d,t[7]=f-m,t[2]=p-y,t[5]=f+m,t[8]=1-u-h,t},f.normalFromMat4=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,_=n*l-i*o,w=n*u-s*o,M=i*u-s*l,A=c*m-h*d,I=c*y-p*d,S=c*g-f*d,P=h*y-p*m,E=h*g-f*m,z=p*g-f*y,k=x*z-v*E+b*P+_*S-w*I+M*A;return k?(t[0]=(o*z-l*E+u*P)*(k=1/k),t[1]=(l*S-a*z-u*I)*k,t[2]=(a*E-o*S+u*A)*k,t[3]=(i*E-n*z-s*P)*k,t[4]=(r*z-i*S+s*I)*k,t[5]=(n*S-r*E-s*A)*k,t[6]=(m*M-y*w+g*_)*k,t[7]=(y*b-d*M-g*v)*k,t[8]=(d*w-m*b+g*x)*k,t):null},f.projection=function(t,e,r){return t[0]=2/e,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/r,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},f.str=function(t){return "mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},f.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},f.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t},f.subtract=i,f.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t},f.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t},f.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},f.equals=function(t,r){var n=t[0],i=t[1],s=t[2],a=t[3],o=t[4],l=t[5],u=t[6],c=t[7],h=t[8],p=r[0],f=r[1],d=r[2],m=r[3],y=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return Math.abs(n-p)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(p))&&Math.abs(i-f)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(f))&&Math.abs(s-d)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(d))&&Math.abs(a-m)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(m))&&Math.abs(o-y)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(y))&&Math.abs(l-g)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(u-x)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(x))&&Math.abs(c-v)<=e.EPSILON*Math.max(1,Math.abs(c),Math.abs(v))&&Math.abs(h-b)<=e.EPSILON*Math.max(1,Math.abs(h),Math.abs(b))},f.sub=f.mul=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,i&&i.set(e,s),s}(s());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1],d=r[2],m=r[3],y=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return t[0]=p*n+f*a+d*u,t[1]=p*i+f*o+d*c,t[2]=p*s+f*l+d*h,t[3]=m*n+y*a+g*u,t[4]=m*i+y*o+g*c,t[5]=m*s+y*l+g*h,t[6]=x*n+v*a+b*u,t[7]=x*i+v*o+b*c,t[8]=x*s+v*l+b*h,t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t}return f.mul=n,f.sub=i,f}var m,y={};function g(){if(m)return y;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}m=1,Object.defineProperty(y,"__esModule",{value:!0}),y.create=function(){var t=new e.ARRAY_TYPE(16);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},y.clone=function(t){var r=new e.ARRAY_TYPE(16);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r[8]=t[8],r[9]=t[9],r[10]=t[10],r[11]=t[11],r[12]=t[12],r[13]=t[13],r[14]=t[14],r[15]=t[15],r},y.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},y.fromValues=function(t,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y){var g=new e.ARRAY_TYPE(16);return g[0]=t,g[1]=r,g[2]=n,g[3]=i,g[4]=s,g[5]=a,g[6]=o,g[7]=l,g[8]=u,g[9]=c,g[10]=h,g[11]=p,g[12]=f,g[13]=d,g[14]=m,g[15]=y,g},y.set=function(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t[6]=o,t[7]=l,t[8]=u,t[9]=c,t[10]=h,t[11]=p,t[12]=f,t[13]=d,t[14]=m,t[15]=y,t},y.identity=n,y.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[3],s=e[6],a=e[7],o=e[11];t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=s,t[11]=e[14],t[12]=i,t[13]=a,t[14]=o;}else t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15];return t},y.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,_=n*l-i*o,w=n*u-s*o,M=i*u-s*l,A=c*m-h*d,I=c*y-p*d,S=c*g-f*d,P=h*y-p*m,E=h*g-f*m,z=p*g-f*y,k=x*z-v*E+b*P+_*S-w*I+M*A;return k?(t[0]=(o*z-l*E+u*P)*(k=1/k),t[1]=(i*E-n*z-s*P)*k,t[2]=(m*M-y*w+g*_)*k,t[3]=(p*w-h*M-f*_)*k,t[4]=(l*S-a*z-u*I)*k,t[5]=(r*z-i*S+s*I)*k,t[6]=(y*b-d*M-g*v)*k,t[7]=(c*M-p*b+f*v)*k,t[8]=(a*E-o*S+u*A)*k,t[9]=(n*S-r*E-s*A)*k,t[10]=(d*w-m*b+g*x)*k,t[11]=(h*b-c*w-f*x)*k,t[12]=(o*I-a*P-l*A)*k,t[13]=(r*P-n*I+i*A)*k,t[14]=(m*v-d*_-y*x)*k,t[15]=(c*_-h*v+p*x)*k,t):null},y.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15];return t[0]=o*(p*g-f*y)-h*(l*g-u*y)+m*(l*f-u*p),t[1]=-(n*(p*g-f*y)-h*(i*g-s*y)+m*(i*f-s*p)),t[2]=n*(l*g-u*y)-o*(i*g-s*y)+m*(i*u-s*l),t[3]=-(n*(l*f-u*p)-o*(i*f-s*p)+h*(i*u-s*l)),t[4]=-(a*(p*g-f*y)-c*(l*g-u*y)+d*(l*f-u*p)),t[5]=r*(p*g-f*y)-c*(i*g-s*y)+d*(i*f-s*p),t[6]=-(r*(l*g-u*y)-a*(i*g-s*y)+d*(i*u-s*l)),t[7]=r*(l*f-u*p)-a*(i*f-s*p)+c*(i*u-s*l),t[8]=a*(h*g-f*m)-c*(o*g-u*m)+d*(o*f-u*h),t[9]=-(r*(h*g-f*m)-c*(n*g-s*m)+d*(n*f-s*h)),t[10]=r*(o*g-u*m)-a*(n*g-s*m)+d*(n*u-s*o),t[11]=-(r*(o*f-u*h)-a*(n*f-s*h)+c*(n*u-s*o)),t[12]=-(a*(h*y-p*m)-c*(o*y-l*m)+d*(o*p-l*h)),t[13]=r*(h*y-p*m)-c*(n*y-i*m)+d*(n*p-i*h),t[14]=-(r*(o*y-l*m)-a*(n*y-i*m)+d*(n*l-i*o)),t[15]=r*(o*p-l*h)-a*(n*p-i*h)+c*(n*l-i*o),t},y.determinant=function(t){var e=t[0],r=t[1],n=t[2],i=t[3],s=t[4],a=t[5],o=t[6],l=t[7],u=t[8],c=t[9],h=t[10],p=t[11],f=t[12],d=t[13],m=t[14],y=t[15];return (e*a-r*s)*(h*y-p*m)-(e*o-n*s)*(c*y-p*d)+(e*l-i*s)*(c*m-h*d)+(r*o-n*a)*(u*y-p*f)-(r*l-i*a)*(u*m-h*f)+(n*l-i*o)*(u*d-c*f)},y.multiply=i,y.translate=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,m=r[0],y=r[1],g=r[2];return e===t?(t[12]=e[0]*m+e[4]*y+e[8]*g+e[12],t[13]=e[1]*m+e[5]*y+e[9]*g+e[13],t[14]=e[2]*m+e[6]*y+e[10]*g+e[14],t[15]=e[3]*m+e[7]*y+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*m+o*y+h*g+e[12],t[13]=i*m+l*y+p*g+e[13],t[14]=s*m+u*y+f*g+e[14],t[15]=a*m+c*y+d*g+e[15]),t},y.scale=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},y.rotate=function(t,r,n,i){var s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,I,S,P,E,z=i[0],k=i[1],T=i[2],B=Math.hypot(z,k,T);return B<e.EPSILON?null:(z*=B=1/B,k*=B,T*=B,s=Math.sin(n),a=Math.cos(n),u=r[1],c=r[2],h=r[3],f=r[5],d=r[6],m=r[7],g=r[9],x=r[10],v=r[11],b=z*z*(o=1-a)+a,M=z*k*o-T*s,A=k*k*o+a,I=T*k*o+z*s,S=z*T*o+k*s,P=k*T*o-z*s,E=T*T*o+a,t[0]=(l=r[0])*b+(p=r[4])*(_=k*z*o+T*s)+(y=r[8])*(w=T*z*o-k*s),t[1]=u*b+f*_+g*w,t[2]=c*b+d*_+x*w,t[3]=h*b+m*_+v*w,t[4]=l*M+p*A+y*I,t[5]=u*M+f*A+g*I,t[6]=c*M+d*A+x*I,t[7]=h*M+m*A+v*I,t[8]=l*S+p*P+y*E,t[9]=u*S+f*P+g*E,t[10]=c*S+d*P+x*E,t[11]=h*S+m*P+v*E,r!==t&&(t[12]=r[12],t[13]=r[13],t[14]=r[14],t[15]=r[15]),t)},y.rotateX=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},y.rotateY=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},y.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},y.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=e[0],t[13]=e[1],t[14]=e[2],t[15]=1,t},y.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromRotation=function(t,r,n){var i,s,a,o=n[0],l=n[1],u=n[2],c=Math.hypot(o,l,u);return c<e.EPSILON?null:(o*=c=1/c,l*=c,u*=c,i=Math.sin(r),s=Math.cos(r),t[0]=o*o*(a=1-s)+s,t[1]=l*o*a+u*i,t[2]=u*o*a-l*i,t[3]=0,t[4]=o*l*a-u*i,t[5]=l*l*a+s,t[6]=u*l*a+o*i,t[7]=0,t[8]=o*u*a+l*i,t[9]=l*u*a-o*i,t[10]=u*u*a+s,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)},y.fromXRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=n,t[6]=r,t[7]=0,t[8]=0,t[9]=-r,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromYRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=0,t[2]=-r,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=r,t[9]=0,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromZRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=0,t[4]=-r,t[5]=n,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.fromRotationTranslation=a,y.fromQuat2=function(t,r){var n=new e.ARRAY_TYPE(3),i=-r[0],s=-r[1],o=-r[2],l=r[3],u=r[4],c=r[5],h=r[6],p=r[7],f=i*i+s*s+o*o+l*l;return f>0?(n[0]=2*(u*l+p*i+c*o-h*s)/f,n[1]=2*(c*l+p*s+h*i-u*o)/f,n[2]=2*(h*l+p*o+u*s-c*i)/f):(n[0]=2*(u*l+p*i+c*o-h*s),n[1]=2*(c*l+p*s+h*i-u*o),n[2]=2*(h*l+p*o+u*s-c*i)),a(t,r,n),t},y.getTranslation=function(t,e){return t[0]=e[12],t[1]=e[13],t[2]=e[14],t},y.getScaling=o,y.getRotation=function(t,r){var n=new e.ARRAY_TYPE(3);o(n,r);var i=1/n[0],s=1/n[1],a=1/n[2],l=r[0]*i,u=r[1]*s,c=r[2]*a,h=r[4]*i,p=r[5]*s,f=r[6]*a,d=r[8]*i,m=r[9]*s,y=r[10]*a,g=l+p+y,x=0;return g>0?(x=2*Math.sqrt(g+1),t[3]=.25*x,t[0]=(f-m)/x,t[1]=(d-c)/x,t[2]=(u-h)/x):l>p&&l>y?(x=2*Math.sqrt(1+l-p-y),t[3]=(f-m)/x,t[0]=.25*x,t[1]=(u+h)/x,t[2]=(d+c)/x):p>y?(x=2*Math.sqrt(1+p-l-y),t[3]=(d-c)/x,t[0]=(u+h)/x,t[1]=.25*x,t[2]=(f+m)/x):(x=2*Math.sqrt(1+y-l-p),t[3]=(u-h)/x,t[0]=(d+c)/x,t[1]=(f+m)/x,t[2]=.25*x),t},y.fromRotationTranslationScale=function(t,e,r,n){var i=e[0],s=e[1],a=e[2],o=e[3],l=i+i,u=s+s,c=a+a,h=i*l,p=i*u,f=i*c,d=s*u,m=s*c,y=a*c,g=o*l,x=o*u,v=o*c,b=n[0],_=n[1],w=n[2];return t[0]=(1-(d+y))*b,t[1]=(p+v)*b,t[2]=(f-x)*b,t[3]=0,t[4]=(p-v)*_,t[5]=(1-(h+y))*_,t[6]=(m+g)*_,t[7]=0,t[8]=(f+x)*w,t[9]=(m-g)*w,t[10]=(1-(h+d))*w,t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t},y.fromRotationTranslationScaleOrigin=function(t,e,r,n,i){var s=e[0],a=e[1],o=e[2],l=e[3],u=s+s,c=a+a,h=o+o,p=s*u,f=s*c,d=s*h,m=a*c,y=a*h,g=o*h,x=l*u,v=l*c,b=l*h,_=n[0],w=n[1],M=n[2],A=i[0],I=i[1],S=i[2],P=(1-(m+g))*_,E=(f+b)*_,z=(d-v)*_,k=(f-b)*w,T=(1-(p+g))*w,B=(y+x)*w,V=(d+v)*M,C=(y-x)*M,D=(1-(p+m))*M;return t[0]=P,t[1]=E,t[2]=z,t[3]=0,t[4]=k,t[5]=T,t[6]=B,t[7]=0,t[8]=V,t[9]=C,t[10]=D,t[11]=0,t[12]=r[0]+A-(P*A+k*I+V*S),t[13]=r[1]+I-(E*A+T*I+C*S),t[14]=r[2]+S-(z*A+B*I+D*S),t[15]=1,t},y.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,f=i*o,d=i*l,m=s*a,y=s*o,g=s*l;return t[0]=1-h-d,t[1]=c+g,t[2]=p-y,t[3]=0,t[4]=c-g,t[5]=1-u-d,t[6]=f+m,t[7]=0,t[8]=p+y,t[9]=f-m,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},y.frustum=function(t,e,r,n,i,s,a){var o=1/(r-e),l=1/(i-n),u=1/(s-a);return t[0]=2*s*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*s*l,t[6]=0,t[7]=0,t[8]=(r+e)*o,t[9]=(i+n)*l,t[10]=(a+s)*u,t[11]=-1,t[12]=0,t[13]=0,t[14]=a*s*2*u,t[15]=0,t},y.perspectiveNO=l,y.perspectiveZO=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=i*(s=1/(n-i)),t[14]=i*n*s):(t[10]=-1,t[14]=-n),t},y.perspectiveFromFieldOfView=function(t,e,r,n){var i=Math.tan(e.upDegrees*Math.PI/180),s=Math.tan(e.downDegrees*Math.PI/180),a=Math.tan(e.leftDegrees*Math.PI/180),o=Math.tan(e.rightDegrees*Math.PI/180),l=2/(a+o),u=2/(i+s);return t[0]=l,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=-(a-o)*l*.5,t[9]=(i-s)*u*.5,t[10]=n/(r-n),t[11]=-1,t[12]=0,t[13]=0,t[14]=n*r/(r-n),t[15]=0,t},y.orthoNO=u,y.orthoZO=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=s*u,t[15]=1,t},y.lookAt=function(t,r,i,s){var a,o,l,u,c,h,p,f,d,m,y=r[0],g=r[1],x=r[2],v=s[0],b=s[1],_=s[2],w=i[0],M=i[1],A=i[2];return Math.abs(y-w)<e.EPSILON&&Math.abs(g-M)<e.EPSILON&&Math.abs(x-A)<e.EPSILON?n(t):(p=y-w,f=g-M,d=x-A,a=b*(d*=m=1/Math.hypot(p,f,d))-_*(f*=m),o=_*(p*=m)-v*d,l=v*f-b*p,(m=Math.hypot(a,o,l))?(a*=m=1/m,o*=m,l*=m):(a=0,o=0,l=0),u=f*l-d*o,c=d*a-p*l,h=p*o-f*a,(m=Math.hypot(u,c,h))?(u*=m=1/m,c*=m,h*=m):(u=0,c=0,h=0),t[0]=a,t[1]=u,t[2]=p,t[3]=0,t[4]=o,t[5]=c,t[6]=f,t[7]=0,t[8]=l,t[9]=h,t[10]=d,t[11]=0,t[12]=-(a*y+o*g+l*x),t[13]=-(u*y+c*g+h*x),t[14]=-(p*y+f*g+d*x),t[15]=1,t)},y.targetTo=function(t,e,r,n){var i=e[0],s=e[1],a=e[2],o=n[0],l=n[1],u=n[2],c=i-r[0],h=s-r[1],p=a-r[2],f=c*c+h*h+p*p;f>0&&(c*=f=1/Math.sqrt(f),h*=f,p*=f);var d=l*p-u*h,m=u*c-o*p,y=o*h-l*c;return (f=d*d+m*m+y*y)>0&&(d*=f=1/Math.sqrt(f),m*=f,y*=f),t[0]=d,t[1]=m,t[2]=y,t[3]=0,t[4]=h*y-p*m,t[5]=p*d-c*y,t[6]=c*m-h*d,t[7]=0,t[8]=c,t[9]=h,t[10]=p,t[11]=0,t[12]=i,t[13]=s,t[14]=a,t[15]=1,t},y.str=function(t){return "mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},y.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},y.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},y.subtract=c,y.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},y.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t[9]=e[9]+r[9]*n,t[10]=e[10]+r[10]*n,t[11]=e[11]+r[11]*n,t[12]=e[12]+r[12]*n,t[13]=e[13]+r[13]*n,t[14]=e[14]+r[14]*n,t[15]=e[15]+r[15]*n,t},y.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},y.equals=function(t,r){var n=t[0],i=t[1],s=t[2],a=t[3],o=t[4],l=t[5],u=t[6],c=t[7],h=t[8],p=t[9],f=t[10],d=t[11],m=t[12],y=t[13],g=t[14],x=t[15],v=r[0],b=r[1],_=r[2],w=r[3],M=r[4],A=r[5],I=r[6],S=r[7],P=r[8],E=r[9],z=r[10],k=r[11],T=r[12],B=r[13],V=r[14],C=r[15];return Math.abs(n-v)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(v))&&Math.abs(i-b)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(b))&&Math.abs(s-_)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(a-w)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(w))&&Math.abs(o-M)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))&&Math.abs(l-A)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(A))&&Math.abs(u-I)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(I))&&Math.abs(c-S)<=e.EPSILON*Math.max(1,Math.abs(c),Math.abs(S))&&Math.abs(h-P)<=e.EPSILON*Math.max(1,Math.abs(h),Math.abs(P))&&Math.abs(p-E)<=e.EPSILON*Math.max(1,Math.abs(p),Math.abs(E))&&Math.abs(f-z)<=e.EPSILON*Math.max(1,Math.abs(f),Math.abs(z))&&Math.abs(d-k)<=e.EPSILON*Math.max(1,Math.abs(d),Math.abs(k))&&Math.abs(m-T)<=e.EPSILON*Math.max(1,Math.abs(m),Math.abs(T))&&Math.abs(y-B)<=e.EPSILON*Math.max(1,Math.abs(y),Math.abs(B))&&Math.abs(g-V)<=e.EPSILON*Math.max(1,Math.abs(g),Math.abs(V))&&Math.abs(x-C)<=e.EPSILON*Math.max(1,Math.abs(x),Math.abs(C))},y.sub=y.mul=y.ortho=y.perspective=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,i&&i.set(e,s),s}(s());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function i(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],m=e[12],y=e[13],g=e[14],x=e[15],v=r[0],b=r[1],_=r[2],w=r[3];return t[0]=v*n+b*o+_*h+w*m,t[1]=v*i+b*l+_*p+w*y,t[2]=v*s+b*u+_*f+w*g,t[3]=v*a+b*c+_*d+w*x,t[4]=(v=r[4])*n+(b=r[5])*o+(_=r[6])*h+(w=r[7])*m,t[5]=v*i+b*l+_*p+w*y,t[6]=v*s+b*u+_*f+w*g,t[7]=v*a+b*c+_*d+w*x,t[8]=(v=r[8])*n+(b=r[9])*o+(_=r[10])*h+(w=r[11])*m,t[9]=v*i+b*l+_*p+w*y,t[10]=v*s+b*u+_*f+w*g,t[11]=v*a+b*c+_*d+w*x,t[12]=(v=r[12])*n+(b=r[13])*o+(_=r[14])*h+(w=r[15])*m,t[13]=v*i+b*l+_*p+w*y,t[14]=v*s+b*u+_*f+w*g,t[15]=v*a+b*c+_*d+w*x,t}function a(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=n+n,l=i+i,u=s+s,c=n*o,h=n*l,p=n*u,f=i*l,d=i*u,m=s*u,y=a*o,g=a*l,x=a*u;return t[0]=1-(f+m),t[1]=h+x,t[2]=p-g,t[3]=0,t[4]=h-x,t[5]=1-(c+m),t[6]=d+y,t[7]=0,t[8]=p+g,t[9]=d-y,t[10]=1-(c+f),t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t}function o(t,e){var r=e[4],n=e[5],i=e[6],s=e[8],a=e[9],o=e[10];return t[0]=Math.hypot(e[0],e[1],e[2]),t[1]=Math.hypot(r,n,i),t[2]=Math.hypot(s,a,o),t}function l(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t}function u(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t}function c(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t}return y.perspective=l,y.ortho=u,y.mul=i,y.sub=c,y}var x,v={},b={};function _(){if(x)return b;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}x=1,Object.defineProperty(b,"__esModule",{value:!0}),b.create=n,b.clone=function(t){var r=new e.ARRAY_TYPE(3);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r},b.length=i,b.fromValues=function(t,r,n){var i=new e.ARRAY_TYPE(3);return i[0]=t,i[1]=r,i[2]=n,i},b.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t},b.set=function(t,e,r,n){return t[0]=e,t[1]=r,t[2]=n,t},b.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},b.subtract=a,b.multiply=o,b.divide=l,b.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t},b.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t},b.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t},b.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t},b.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t},b.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t},b.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t},b.distance=u,b.squaredDistance=c,b.squaredLength=h,b.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t},b.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t},b.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t},b.dot=p,b.cross=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t},b.lerp=function(t,e,r,n){var i=e[0],s=e[1],a=e[2];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=a+n*(r[2]-a),t},b.hermite=function(t,e,r,n,i,s){var a=s*s,o=a*(2*s-3)+1,l=a*(s-2)+s,u=a*(s-1),c=a*(3-2*s);return t[0]=e[0]*o+r[0]*l+n[0]*u+i[0]*c,t[1]=e[1]*o+r[1]*l+n[1]*u+i[1]*c,t[2]=e[2]*o+r[2]*l+n[2]*u+i[2]*c,t},b.bezier=function(t,e,r,n,i,s){var a=1-s,o=a*a,l=s*s,u=o*a,c=3*s*o,h=3*l*a,p=l*s;return t[0]=e[0]*u+r[0]*c+n[0]*h+i[0]*p,t[1]=e[1]*u+r[1]*c+n[1]*h+i[1]*p,t[2]=e[2]*u+r[2]*c+n[2]*h+i[2]*p,t},b.random=function(t,r){r=r||1;var n=2*e.RANDOM()*Math.PI,i=2*e.RANDOM()-1,s=Math.sqrt(1-i*i)*r;return t[0]=Math.cos(n)*s,t[1]=Math.sin(n)*s,t[2]=i*r,t},b.transformMat4=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t},b.transformMat3=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},b.transformQuat=function(t,e,r){var n=r[0],i=r[1],s=r[2],a=e[0],o=e[1],l=e[2],u=i*l-s*o,c=s*a-n*l,h=n*o-i*a,p=i*h-s*c,f=s*u-n*h,d=n*c-i*u,m=2*r[3];return c*=m,h*=m,f*=2,d*=2,t[0]=a+(u*=m)+(p*=2),t[1]=o+c+f,t[2]=l+h+d,t},b.rotateX=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0],s[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),s[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},b.rotateY=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),s[1]=i[1],s[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},b.rotateZ=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),s[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),s[2]=i[2],t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},b.angle=function(t,e){var r=t[0],n=t[1],i=t[2],s=e[0],a=e[1],o=e[2],l=Math.sqrt(r*r+n*n+i*i)*Math.sqrt(s*s+a*a+o*o),u=l&&p(t,e)/l;return Math.acos(Math.min(Math.max(u,-1),1))},b.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},b.str=function(t){return "vec3("+t[0]+", "+t[1]+", "+t[2]+")"},b.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},b.equals=function(t,r){var n=t[0],i=t[1],s=t[2],a=r[0],o=r[1],l=r[2];return Math.abs(n-a)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(a))&&Math.abs(i-o)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(o))&&Math.abs(s-l)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(l))},b.forEach=b.sqrLen=b.len=b.sqrDist=b.dist=b.div=b.mul=b.sub=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,i&&i.set(e,s),s}(s());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(){var t=new e.ARRAY_TYPE(3);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function i(t){return Math.hypot(t[0],t[1],t[2])}function a(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function o(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function l(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t}function u(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2])}function c(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2];return r*r+n*n+i*i}function h(t){var e=t[0],r=t[1],n=t[2];return e*e+r*r+n*n}function p(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}b.sub=a,b.mul=o,b.div=l,b.dist=u,b.sqrDist=c,b.len=i,b.sqrLen=h;var f,d=(f=n(),function(t,e,r,n,i,s){var a,o;for(e||(e=3),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,a=r;a<o;a+=e)f[0]=t[a],f[1]=t[a+1],f[2]=t[a+2],i(f,f,s),t[a]=f[0],t[a+1]=f[1],t[a+2]=f[2];return t});return b.forEach=d,b}var w,M,A={};function I(){if(w)return A;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}w=1,Object.defineProperty(A,"__esModule",{value:!0}),A.create=n,A.clone=function(t){var r=new e.ARRAY_TYPE(4);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r},A.fromValues=function(t,r,n,i){var s=new e.ARRAY_TYPE(4);return s[0]=t,s[1]=r,s[2]=n,s[3]=i,s},A.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},A.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},A.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},A.subtract=i,A.multiply=a,A.divide=o,A.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t[3]=Math.ceil(e[3]),t},A.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t[3]=Math.floor(e[3]),t},A.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t[3]=Math.min(e[3],r[3]),t},A.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t[3]=Math.max(e[3],r[3]),t},A.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t[3]=Math.round(e[3]),t},A.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},A.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},A.distance=l,A.squaredDistance=u,A.length=c,A.squaredLength=h,A.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},A.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t[3]=1/e[3],t},A.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*r+n*n+i*i+s*s;return a>0&&(a=1/Math.sqrt(a)),t[0]=r*a,t[1]=n*a,t[2]=i*a,t[3]=s*a,t},A.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]},A.cross=function(t,e,r,n){var i=r[0]*n[1]-r[1]*n[0],s=r[0]*n[2]-r[2]*n[0],a=r[0]*n[3]-r[3]*n[0],o=r[1]*n[2]-r[2]*n[1],l=r[1]*n[3]-r[3]*n[1],u=r[2]*n[3]-r[3]*n[2],c=e[0],h=e[1],p=e[2],f=e[3];return t[0]=h*u-p*l+f*o,t[1]=-c*u+p*a-f*s,t[2]=c*l-h*a+f*i,t[3]=-c*o+h*s-p*i,t},A.lerp=function(t,e,r,n){var i=e[0],s=e[1],a=e[2],o=e[3];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=a+n*(r[2]-a),t[3]=o+n*(r[3]-o),t},A.random=function(t,r){var n,i,s,a,o,l;r=r||1;do{o=(n=2*e.RANDOM()-1)*n+(i=2*e.RANDOM()-1)*i;}while(o>=1);do{l=(s=2*e.RANDOM()-1)*s+(a=2*e.RANDOM()-1)*a;}while(l>=1);var u=Math.sqrt((1-o)/l);return t[0]=r*n,t[1]=r*i,t[2]=r*s*u,t[3]=r*a*u,t},A.transformMat4=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t},A.transformQuat=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2],u=r[3],c=u*n+o*s-l*i,h=u*i+l*n-a*s,p=u*s+a*i-o*n,f=-a*n-o*i-l*s;return t[0]=c*u+f*-a+h*-l-p*-o,t[1]=h*u+f*-o+p*-a-c*-l,t[2]=p*u+f*-l+c*-o-h*-a,t[3]=e[3],t},A.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},A.str=function(t){return "vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},A.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},A.equals=function(t,r){var n=t[0],i=t[1],s=t[2],a=t[3],o=r[0],l=r[1],u=r[2],c=r[3];return Math.abs(n-o)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(s-u)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(u))&&Math.abs(a-c)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(c))},A.forEach=A.sqrLen=A.len=A.sqrDist=A.dist=A.div=A.mul=A.sub=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,i&&i.set(e,s),s}(s());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}function a(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}function o(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t[3]=e[3]/r[3],t}function l(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2],e[3]-t[3])}function u(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2],s=e[3]-t[3];return r*r+n*n+i*i+s*s}function c(t){return Math.hypot(t[0],t[1],t[2],t[3])}function h(t){var e=t[0],r=t[1],n=t[2],i=t[3];return e*e+r*r+n*n+i*i}A.sub=i,A.mul=a,A.div=o,A.dist=l,A.sqrDist=u,A.len=c,A.sqrLen=h;var p,f=(p=n(),function(t,e,r,n,i,s){var a,o;for(e||(e=4),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,a=r;a<o;a+=e)p[0]=t[a],p[1]=t[a+1],p[2]=t[a+2],p[3]=t[a+3],i(p,p,s),t[a]=p[0],t[a+1]=p[1],t[a+2]=p[2],t[a+3]=p[3];return t});return A.forEach=f,A}function S(){if(M)return v;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}M=1,Object.defineProperty(v,"__esModule",{value:!0}),v.create=l,v.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},v.setAxisAngle=u,v.getAxisAngle=function(t,r){var n=2*Math.acos(r[3]),i=Math.sin(n/2);return i>e.EPSILON?(t[0]=r[0]/i,t[1]=r[1]/i,t[2]=r[2]/i):(t[0]=1,t[1]=0,t[2]=0),n},v.getAngle=function(t,e){var r=g(t,e);return Math.acos(2*r*r-1)},v.multiply=c,v.rotateX=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+a*o,t[1]=i*l+s*o,t[2]=s*l-i*o,t[3]=a*l-n*o,t},v.rotateY=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l-s*o,t[1]=i*l+a*o,t[2]=s*l+n*o,t[3]=a*l-i*o,t},v.rotateZ=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*o,t[1]=i*l-n*o,t[2]=s*l+a*o,t[3]=a*l-s*o,t},v.calculateW=function(t,e){var r=e[0],n=e[1],i=e[2];return t[0]=r,t[1]=n,t[2]=i,t[3]=Math.sqrt(Math.abs(1-r*r-n*n-i*i)),t},v.exp=h,v.ln=p,v.pow=function(t,e,r){return p(t,e),y(t,t,r),h(t,t),t},v.slerp=f,v.random=function(t){var r=e.RANDOM(),n=e.RANDOM(),i=e.RANDOM(),s=Math.sqrt(1-r),a=Math.sqrt(r);return t[0]=s*Math.sin(2*Math.PI*n),t[1]=s*Math.cos(2*Math.PI*n),t[2]=a*Math.sin(2*Math.PI*i),t[3]=a*Math.cos(2*Math.PI*i),t},v.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*r+n*n+i*i+s*s,o=a?1/a:0;return t[0]=-r*o,t[1]=-n*o,t[2]=-i*o,t[3]=s*o,t},v.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},v.fromMat3=m,v.fromEuler=function(t,e,r,n){var i=.5*Math.PI/180;e*=i,r*=i,n*=i;var s=Math.sin(e),a=Math.cos(e),o=Math.sin(r),l=Math.cos(r),u=Math.sin(n),c=Math.cos(n);return t[0]=s*l*c-a*o*u,t[1]=a*o*c+s*l*u,t[2]=a*l*u-s*o*c,t[3]=a*l*c+s*o*u,t},v.str=function(t){return "quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},v.setAxes=v.sqlerp=v.rotationTo=v.equals=v.exactEquals=v.normalize=v.sqrLen=v.squaredLength=v.len=v.length=v.lerp=v.dot=v.scale=v.mul=v.add=v.set=v.copy=v.fromValues=v.clone=void 0;var e=o(s()),r=o(d()),n=o(_()),i=o(I());function a(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (a=function(t){return t?r:e})(t)}function o(e,r){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var n=a(r);if(n&&n.has(e))return n.get(e);var i={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=s?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(i,o,l):i[o]=e[o];}return i.default=e,n&&n.set(e,i),i}function l(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function u(t,e,r){r*=.5;var n=Math.sin(r);return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=Math.cos(r),t}function c(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+a*o+i*u-s*l,t[1]=i*c+a*l+s*o-n*u,t[2]=s*c+a*u+n*l-i*o,t[3]=a*c-n*o-i*l-s*u,t}function h(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=Math.sqrt(r*r+n*n+i*i),o=Math.exp(s),l=a>0?o*Math.sin(a)/a:0;return t[0]=r*l,t[1]=n*l,t[2]=i*l,t[3]=o*Math.cos(a),t}function p(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=Math.sqrt(r*r+n*n+i*i),o=a>0?Math.atan2(a,s)/a:0;return t[0]=r*o,t[1]=n*o,t[2]=i*o,t[3]=.5*Math.log(r*r+n*n+i*i+s*s),t}function f(t,r,n,i){var s,a,o,l,u,c=r[0],h=r[1],p=r[2],f=r[3],d=n[0],m=n[1],y=n[2],g=n[3];return (a=c*d+h*m+p*y+f*g)<0&&(a=-a,d=-d,m=-m,y=-y,g=-g),1-a>e.EPSILON?(s=Math.acos(a),o=Math.sin(s),l=Math.sin((1-i)*s)/o,u=Math.sin(i*s)/o):(l=1-i,u=i),t[0]=l*c+u*d,t[1]=l*h+u*m,t[2]=l*p+u*y,t[3]=l*f+u*g,t}function m(t,e){var r,n=e[0]+e[4]+e[8];if(n>0)r=Math.sqrt(n+1),t[3]=.5*r,t[0]=(e[5]-e[7])*(r=.5/r),t[1]=(e[6]-e[2])*r,t[2]=(e[1]-e[3])*r;else {var i=0;e[4]>e[0]&&(i=1),e[8]>e[3*i+i]&&(i=2);var s=(i+1)%3,a=(i+2)%3;r=Math.sqrt(e[3*i+i]-e[3*s+s]-e[3*a+a]+1),t[i]=.5*r,t[3]=(e[3*s+a]-e[3*a+s])*(r=.5/r),t[s]=(e[3*s+i]+e[3*i+s])*r,t[a]=(e[3*a+i]+e[3*i+a])*r;}return t}v.clone=i.clone,v.fromValues=i.fromValues,v.copy=i.copy,v.set=i.set,v.add=i.add,v.mul=c;var y=i.scale;v.scale=y;var g=i.dot;v.dot=g,v.lerp=i.lerp;var x=i.length;v.length=x,v.len=x;var b=i.squaredLength;v.squaredLength=b,v.sqrLen=b;var w=i.normalize;v.normalize=w,v.exactEquals=i.exactEquals,v.equals=i.equals;var A,S,P,E=(A=n.create(),S=n.fromValues(1,0,0),P=n.fromValues(0,1,0),function(t,e,r){var i=n.dot(e,r);return i<-.999999?(n.cross(A,S,e),n.len(A)<1e-6&&n.cross(A,P,e),n.normalize(A,A),u(t,A,Math.PI),t):i>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(n.cross(A,e,r),t[0]=A[0],t[1]=A[1],t[2]=A[2],t[3]=1+i,w(t,t))});v.rotationTo=E;var z,k,T=(z=l(),k=l(),function(t,e,r,n,i,s){return f(z,e,i,s),f(k,r,n,s),f(t,z,k,2*s*(1-s)),t});v.sqlerp=T;var B,V=(B=r.create(),function(t,e,r,n){return B[0]=r[0],B[3]=r[1],B[6]=r[2],B[1]=n[0],B[4]=n[1],B[7]=n[2],B[2]=-e[0],B[5]=-e[1],B[8]=-e[2],w(t,m(t,B))});return v.setAxes=V,v}var P,E={};function z(){if(P)return E;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}P=1,Object.defineProperty(E,"__esModule",{value:!0}),E.create=function(){var t=new e.ARRAY_TYPE(8);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0),t[3]=1,t},E.clone=function(t){var r=new e.ARRAY_TYPE(8);return r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=t[3],r[4]=t[4],r[5]=t[5],r[6]=t[6],r[7]=t[7],r},E.fromValues=function(t,r,n,i,s,a,o,l){var u=new e.ARRAY_TYPE(8);return u[0]=t,u[1]=r,u[2]=n,u[3]=i,u[4]=s,u[5]=a,u[6]=o,u[7]=l,u},E.fromRotationTranslationValues=function(t,r,n,i,s,a,o){var l=new e.ARRAY_TYPE(8);l[0]=t,l[1]=r,l[2]=n,l[3]=i;var u=.5*s,c=.5*a,h=.5*o;return l[4]=u*i+c*n-h*r,l[5]=c*i+h*t-u*n,l[6]=h*i+u*r-c*t,l[7]=-u*t-c*r-h*n,l},E.fromRotationTranslation=o,E.fromTranslation=function(t,e){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*e[0],t[5]=.5*e[1],t[6]=.5*e[2],t[7]=0,t},E.fromRotation=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},E.fromMat4=function(t,i){var s=r.create();n.getRotation(s,i);var a=new e.ARRAY_TYPE(3);return n.getTranslation(a,i),o(t,s,a),t},E.copy=l,E.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},E.set=function(t,e,r,n,i,s,a,o,l){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t[6]=o,t[7]=l,t},E.getDual=function(t,e){return t[0]=e[4],t[1]=e[5],t[2]=e[6],t[3]=e[7],t},E.setDual=function(t,e){return t[4]=e[0],t[5]=e[1],t[6]=e[2],t[7]=e[3],t},E.getTranslation=function(t,e){var r=e[4],n=e[5],i=e[6],s=e[7],a=-e[0],o=-e[1],l=-e[2],u=e[3];return t[0]=2*(r*u+s*a+n*l-i*o),t[1]=2*(n*u+s*o+i*a-r*l),t[2]=2*(i*u+s*l+r*o-n*a),t},E.translate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=.5*r[0],l=.5*r[1],u=.5*r[2],c=e[4],h=e[5],p=e[6],f=e[7];return t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=a*o+i*u-s*l+c,t[5]=a*l+s*o-n*u+h,t[6]=a*u+n*l-i*o+p,t[7]=-n*o-i*l-s*u+f,t},E.rotateX=function(t,e,n){var i=-e[0],s=-e[1],a=-e[2],o=e[3],l=e[4],u=e[5],c=e[6],h=e[7],p=l*o+h*i+u*a-c*s,f=u*o+h*s+c*i-l*a,d=c*o+h*a+l*s-u*i,m=h*o-l*i-u*s-c*a;return r.rotateX(t,e,n),t[4]=p*(o=t[3])+m*(i=t[0])+f*(a=t[2])-d*(s=t[1]),t[5]=f*o+m*s+d*i-p*a,t[6]=d*o+m*a+p*s-f*i,t[7]=m*o-p*i-f*s-d*a,t},E.rotateY=function(t,e,n){var i=-e[0],s=-e[1],a=-e[2],o=e[3],l=e[4],u=e[5],c=e[6],h=e[7],p=l*o+h*i+u*a-c*s,f=u*o+h*s+c*i-l*a,d=c*o+h*a+l*s-u*i,m=h*o-l*i-u*s-c*a;return r.rotateY(t,e,n),t[4]=p*(o=t[3])+m*(i=t[0])+f*(a=t[2])-d*(s=t[1]),t[5]=f*o+m*s+d*i-p*a,t[6]=d*o+m*a+p*s-f*i,t[7]=m*o-p*i-f*s-d*a,t},E.rotateZ=function(t,e,n){var i=-e[0],s=-e[1],a=-e[2],o=e[3],l=e[4],u=e[5],c=e[6],h=e[7],p=l*o+h*i+u*a-c*s,f=u*o+h*s+c*i-l*a,d=c*o+h*a+l*s-u*i,m=h*o-l*i-u*s-c*a;return r.rotateZ(t,e,n),t[4]=p*(o=t[3])+m*(i=t[0])+f*(a=t[2])-d*(s=t[1]),t[5]=f*o+m*s+d*i-p*a,t[6]=d*o+m*a+p*s-f*i,t[7]=m*o-p*i-f*s-d*a,t},E.rotateByQuatAppend=function(t,e,r){var n=r[0],i=r[1],s=r[2],a=r[3],o=e[0],l=e[1],u=e[2],c=e[3];return t[0]=o*a+c*n+l*s-u*i,t[1]=l*a+c*i+u*n-o*s,t[2]=u*a+c*s+o*i-l*n,t[3]=c*a-o*n-l*i-u*s,t[4]=(o=e[4])*a+(c=e[7])*n+(l=e[5])*s-(u=e[6])*i,t[5]=l*a+c*i+u*n-o*s,t[6]=u*a+c*s+o*i-l*n,t[7]=c*a-o*n-l*i-u*s,t},E.rotateByQuatPrepend=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+a*o+i*u-s*l,t[1]=i*c+a*l+s*o-n*u,t[2]=s*c+a*u+n*l-i*o,t[3]=a*c-n*o-i*l-s*u,t[4]=n*(c=r[7])+a*(o=r[4])+i*(u=r[6])-s*(l=r[5]),t[5]=i*c+a*l+s*o-n*u,t[6]=s*c+a*u+n*l-i*o,t[7]=a*c-n*o-i*l-s*u,t},E.rotateAroundAxis=function(t,r,n,i){if(Math.abs(i)<e.EPSILON)return l(t,r);var s=Math.hypot(n[0],n[1],n[2]);i*=.5;var a=Math.sin(i),o=a*n[0]/s,u=a*n[1]/s,c=a*n[2]/s,h=Math.cos(i),p=r[0],f=r[1],d=r[2],m=r[3];t[0]=p*h+m*o+f*c-d*u,t[1]=f*h+m*u+d*o-p*c,t[2]=d*h+m*c+p*u-f*o,t[3]=m*h-p*o-f*u-d*c;var y=r[4],g=r[5],x=r[6],v=r[7];return t[4]=y*h+v*o+g*c-x*u,t[5]=g*h+v*u+x*o-y*c,t[6]=x*h+v*c+y*u-g*o,t[7]=v*h-y*o-g*u-x*c,t},E.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t},E.multiply=u,E.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t},E.lerp=function(t,e,r,n){var i=1-n;return c(e,r)<0&&(n=-n),t[0]=e[0]*i+r[0]*n,t[1]=e[1]*i+r[1]*n,t[2]=e[2]*i+r[2]*n,t[3]=e[3]*i+r[3]*n,t[4]=e[4]*i+r[4]*n,t[5]=e[5]*i+r[5]*n,t[6]=e[6]*i+r[6]*n,t[7]=e[7]*i+r[7]*n,t},E.invert=function(t,e){var r=p(e);return t[0]=-e[0]/r,t[1]=-e[1]/r,t[2]=-e[2]/r,t[3]=e[3]/r,t[4]=-e[4]/r,t[5]=-e[5]/r,t[6]=-e[6]/r,t[7]=e[7]/r,t},E.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=e[7],t},E.normalize=function(t,e){var r=p(e);if(r>0){r=Math.sqrt(r);var n=e[0]/r,i=e[1]/r,s=e[2]/r,a=e[3]/r,o=e[4],l=e[5],u=e[6],c=e[7],h=n*o+i*l+s*u+a*c;t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=(o-n*h)/r,t[5]=(l-i*h)/r,t[6]=(u-s*h)/r,t[7]=(c-a*h)/r;}return t},E.str=function(t){return "quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},E.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]},E.equals=function(t,r){var n=t[0],i=t[1],s=t[2],a=t[3],o=t[4],l=t[5],u=t[6],c=t[7],h=r[0],p=r[1],f=r[2],d=r[3],m=r[4],y=r[5],g=r[6],x=r[7];return Math.abs(n-h)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(h))&&Math.abs(i-p)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(p))&&Math.abs(s-f)<=e.EPSILON*Math.max(1,Math.abs(s),Math.abs(f))&&Math.abs(a-d)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(d))&&Math.abs(o-m)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(m))&&Math.abs(l-y)<=e.EPSILON*Math.max(1,Math.abs(l),Math.abs(y))&&Math.abs(u-g)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(g))&&Math.abs(c-x)<=e.EPSILON*Math.max(1,Math.abs(c),Math.abs(x))},E.sqrLen=E.squaredLength=E.len=E.length=E.dot=E.mul=E.setReal=E.getReal=void 0;var e=a(s()),r=a(S()),n=a(g());function i(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (i=function(t){return t?r:e})(t)}function a(e,r){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var n=i(r);if(n&&n.has(e))return n.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,n&&n.set(e,s),s}function o(t,e,r){var n=.5*r[0],i=.5*r[1],s=.5*r[2],a=e[0],o=e[1],l=e[2],u=e[3];return t[0]=a,t[1]=o,t[2]=l,t[3]=u,t[4]=n*u+i*l-s*o,t[5]=i*u+s*a-n*l,t[6]=s*u+n*o-i*a,t[7]=-n*a-i*o-s*l,t}function l(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t}function u(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[4],l=r[5],u=r[6],c=r[7],h=e[4],p=e[5],f=e[6],d=e[7],m=r[0],y=r[1],g=r[2],x=r[3];return t[0]=n*x+a*m+i*g-s*y,t[1]=i*x+a*y+s*m-n*g,t[2]=s*x+a*g+n*y-i*m,t[3]=a*x-n*m-i*y-s*g,t[4]=n*c+a*o+i*u-s*l+h*x+d*m+p*g-f*y,t[5]=i*c+a*l+s*o-n*u+p*x+d*y+f*m-h*g,t[6]=s*c+a*u+n*l-i*o+f*x+d*g+h*y-p*m,t[7]=a*c-n*o-i*l-s*u+d*x-h*m-p*y-f*g,t}E.getReal=r.copy,E.setReal=r.copy,E.mul=u;var c=r.dot;E.dot=c;var h=r.length;E.length=h,E.len=h;var p=r.squaredLength;return E.squaredLength=p,E.sqrLen=p,E}var k,T,B={};function V(){if(k)return B;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}k=1,Object.defineProperty(B,"__esModule",{value:!0}),B.create=n,B.clone=function(t){var r=new e.ARRAY_TYPE(2);return r[0]=t[0],r[1]=t[1],r},B.fromValues=function(t,r){var n=new e.ARRAY_TYPE(2);return n[0]=t,n[1]=r,n},B.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t},B.set=function(t,e,r){return t[0]=e,t[1]=r,t},B.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t},B.subtract=i,B.multiply=a,B.divide=o,B.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t},B.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t},B.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t},B.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t},B.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t},B.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t},B.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t},B.distance=l,B.squaredDistance=u,B.length=c,B.squaredLength=h,B.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t},B.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t},B.normalize=function(t,e){var r=e[0],n=e[1],i=r*r+n*n;return i>0&&(i=1/Math.sqrt(i)),t[0]=e[0]*i,t[1]=e[1]*i,t},B.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]},B.cross=function(t,e,r){var n=e[0]*r[1]-e[1]*r[0];return t[0]=t[1]=0,t[2]=n,t},B.lerp=function(t,e,r,n){var i=e[0],s=e[1];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t},B.random=function(t,r){r=r||1;var n=2*e.RANDOM()*Math.PI;return t[0]=Math.cos(n)*r,t[1]=Math.sin(n)*r,t},B.transformMat2=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i,t[1]=r[1]*n+r[3]*i,t},B.transformMat2d=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i+r[4],t[1]=r[1]*n+r[3]*i+r[5],t},B.transformMat3=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[3]*i+r[6],t[1]=r[1]*n+r[4]*i+r[7],t},B.transformMat4=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t},B.rotate=function(t,e,r,n){var i=e[0]-r[0],s=e[1]-r[1],a=Math.sin(n),o=Math.cos(n);return t[0]=i*o-s*a+r[0],t[1]=i*a+s*o+r[1],t},B.angle=function(t,e){var r=t[0],n=t[1],i=e[0],s=e[1],a=Math.sqrt(r*r+n*n)*Math.sqrt(i*i+s*s);return Math.acos(Math.min(Math.max(a&&(r*i+n*s)/a,-1),1))},B.zero=function(t){return t[0]=0,t[1]=0,t},B.str=function(t){return "vec2("+t[0]+", "+t[1]+")"},B.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]},B.equals=function(t,r){var n=t[0],i=t[1],s=r[0],a=r[1];return Math.abs(n-s)<=e.EPSILON*Math.max(1,Math.abs(n),Math.abs(s))&&Math.abs(i-a)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(a))},B.forEach=B.sqrLen=B.sqrDist=B.dist=B.div=B.mul=B.sub=B.len=void 0;var e=function(e,n){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var i=r(void 0);if(i&&i.has(e))return i.get(e);var s={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var l=a?Object.getOwnPropertyDescriptor(e,o):null;l&&(l.get||l.set)?Object.defineProperty(s,o,l):s[o]=e[o];}return s.default=e,i&&i.set(e,s),s}(s());function r(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return (r=function(t){return t?n:e})(t)}function n(){var t=new e.ARRAY_TYPE(2);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0),t}function i(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t}function a(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t}function o(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t}function l(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1])}function u(t,e){var r=e[0]-t[0],n=e[1]-t[1];return r*r+n*n}function c(t){return Math.hypot(t[0],t[1])}function h(t){var e=t[0],r=t[1];return e*e+r*r}B.len=c,B.sub=i,B.mul=a,B.div=o,B.dist=l,B.sqrDist=u,B.sqrLen=h;var p,f=(p=n(),function(t,e,r,n,i,s){var a,o;for(e||(e=2),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,a=r;a<o;a+=e)p[0]=t[a],p[1]=t[a+1],i(p,p,s),t[a]=p[0],t[a+1]=p[1];return t});return B.forEach=f,B}function C(){if(T)return n;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}T=1,Object.defineProperty(n,"__esModule",{value:!0}),n.vec4=n.vec3=n.vec2=n.quat2=n.quat=n.mat4=n.mat3=n.mat2d=n.mat2=n.glMatrix=void 0;var e=x(s());n.glMatrix=e;var r=x(l());n.mat2=r;var i=x(h());n.mat2d=i;var a=x(d());n.mat3=a;var o=x(g());n.mat4=o;var u=x(S());n.quat=u;var c=x(z());n.quat2=c;var p=x(V());n.vec2=p;var f=x(_());n.vec3=f;var m=x(I());function y(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (y=function(t){return t?r:e})(t)}function x(e,r){if(e&&e.__esModule)return e;if(null===e||"object"!==t(e)&&"function"!=typeof e)return {default:e};var n=y(r);if(n&&n.has(e))return n.get(e);var i={},s=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in e)if("default"!==a&&Object.prototype.hasOwnProperty.call(e,a)){var o=s?Object.getOwnPropertyDescriptor(e,a):null;o&&(o.get||o.set)?Object.defineProperty(i,a,o):i[a]=e[a];}return i.default=e,n&&n.set(e,i),i}return n.vec4=m,n}var D,R,L,F,O=C(),N=function(){if(R)return D;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return R=1,D=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},D}(),U=e(N);function j(){if(F)return L;function t(t,e){this.x=t,this.y=e;}return F=1,L=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},L}var q=e(j());function $(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!$(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!$(t[r],e[r]))return !1;return !0}return t===e}const G=Math.PI/180,Y=180/Math.PI;function H(t){return t*G}function X(t){return t*Y}const Z=[[0,0],[1,0],[1,1],[0,1]];function W(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function K(t,e,r,n){const i=new U(t,e,r,n);return function(t){return i.solve(t)}}const J=K(.25,.1,.25,1);function Q(t,e,r){return Math.min(r,Math.max(e,t))}function tt(t,e,r){return (r=Q((r-t)/(e-t),0,1))*r*(3-2*r)}function et(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function rt(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let s=null;t.forEach(((t,a)=>{e(t,((t,e)=>{t&&(s=t),i[a]=e,0==--n&&r(s,i);}));}));}function nt(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let it=1;function st(){return it++}function at(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function ot(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function lt(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function ut(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function ct(t){return Array.isArray(t)?t.map(ct):"object"==typeof t&&t?lt(t,ct):t}const ht={};function pt(t){ht[t]||("undefined"!=typeof console&&console.warn(t),ht[t]=!0);}function ft(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function dt(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function mt([t,e,r]){const n=H(e+90),i=H(r);return {x:t*Math.cos(n)*Math.sin(i),y:t*Math.sin(n)*Math.sin(i),z:t*Math.cos(i),azimuthal:e,polar:r}}function yt(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function gt(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let xt=null;function vt(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function bt(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<n?e=i+1:r=i;}return e}function _t(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<=n?e=i+1:r=i;}return e}function wt(t){return t>0?1/(1.001-t):1+t}function Mt(t){return t>0?1-1/(1.001-t):-t}const At={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i},get API_TILEJSON_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!At.API_URL)return null;try{const t=new URL(At.API_URL);return "api.mapbox.cn"===t.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===t.hostname?"https://events.mapbox.com/events/v2":null}catch(t){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",RASTERARRAYS_URL_PREFIX:"rasterarrays/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,DEFAULT_STYLE:"mapbox://styles/mapbox/standard",MAX_PARALLEL_IMAGE_REQUESTS:16,DRACO_URL:"https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm",MESHOPT_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_base_v0.20.wasm",MESHOPT_SIMD_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_simd_v0.20.wasm",GLYPHS_URL:"mapbox://fonts/mapbox/{fontstack}/{range}.pbf",TILES3D_URL_PREFIX:"3dtiles/v1"};function It(t){return At.API_URL_REGEX.test(t)}function St(t){return At.API_SPRITE_REGEX.test(t)}let Pt,Et,zt,kt,Tt,Bt;function Vt(){return null==Pt&&(Pt=self.OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof self.createImageBitmap),Pt}const Ct={now:()=>void 0!==kt?kt:performance.now(),setNow(t){kt=t;},restoreNow(){kt=void 0;},frame(t){const e=requestAnimationFrame(t);return {cancel:()=>cancelAnimationFrame(e)}},getImageData(t,e=0){const{width:r,height:n}=t;Tt||(Tt=document.createElement("canvas"));const i=Tt.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return (r>Tt.width||n>Tt.height)&&(Tt.width=r,Tt.height=n),i.clearRect(-e,-e,r+2*e,n+2*e),i.drawImage(t,0,0,r,n),i.getImageData(-e,-e,r+2*e,n+2*e)},resolveURL:t=>(Et||(Et=document.createElement("a")),Et.href=t,Et.href),get devicePixelRatio(){return window.devicePixelRatio},get prefersReducedMotion(){return !!window.matchMedia&&(null==zt&&(zt=window.matchMedia("(prefers-reduced-motion: reduce)")),zt.matches)},hasCanvasFingerprintNoise(){if(void 0!==Bt)return Bt;if(!Vt())return Bt=!1,!1;const t=new OffscreenCanvas(85,1),e=t.getContext("2d",{willReadFrequently:!0});let r=0;for(let n=0;n<t.width;++n)e.fillStyle=`rgba(${r++},${r++},${r++}, 255)`,e.fillRect(n,0,1,1);const n=e.getImageData(0,0,t.width,t.height);r=0;for(let t=0;t<n.data.length;++t)if(t%4!=3&&r++!==n.data[t])return Bt=!0,!0;return Bt=!1,!1}};function Dt(t,e){const r=t.indexOf("?");if(r<0)return `${t}?${new URLSearchParams(e).toString()}`;const n=new URLSearchParams(t.slice(r));for(const t in e)n.set(t,e[t]);return `${t.slice(0,r)}?${n.toString()}`}function Rt(t,e={persistentParams:[]}){const r=t.indexOf("?");if(r<0)return t;const n=new URLSearchParams,i=new URLSearchParams(t.slice(r));for(const t of e.persistentParams){const e=i.get(t);e&&n.set(t,e);}const s=n.toString();return `${t.slice(0,r)}${s.length>0?`?${s}`:""}`}const Lt="mapbox-tiles";let Ft=500,Ot=50;const Nt=["language","worldview","jobid"];let Ut,jt;function qt(){try{return caches}catch(t){}}function $t(){const t=qt();t&&null==Ut&&(Ut=t.open(Lt));}let Gt=1/0;const Yt={supported:!1,testSupport:function(t){!Zt&&Xt&&(Wt?Jt(t):Ht=t);}};let Ht,Xt,Zt=!1,Wt=!1;const Kt="undefined"!=typeof self?self:{};function Jt(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,Xt),t.isContextLost())return;Yt.supported=!0;}catch(t){}t.deleteTexture(e),Zt=!0;}Kt.document&&(Xt=Kt.document.createElement("img"),Xt.onload=function(){Ht&&Jt(Ht),Ht=null,Wt=!0;},Xt.onerror=function(){Zt=!0,Ht=null;},Xt.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const Qt={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Iconset:"Iconset",Image:"Image",Model:"Model"};"function"==typeof Object.freeze&&Object.freeze(Qt);class te extends Error{constructor(t,e,r){401===e&&It(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const ee=yt()?()=>self.worker&&self.worker.referrer:()=>("blob:"===location.protocol?parent:self).location.href;const re=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(ee())&&!/^\w+:/.test(r))){if(self.fetch&&self.Request&&self.AbortController&&Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new AbortController,n=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:ee(),referrerPolicy:t.referrerPolicy,signal:r.signal});let i=!1,s=!1;const a=(o=n.url).indexOf("sku=")>0&&It(o);var o;"json"===t.type&&n.headers.set("Accept","application/json");const l=(r,i,o)=>{if(s)return;if(r&&"SecurityError"!==r.message&&pt(r.toString()),i&&o)return u(i);const l=Date.now();fetch(n).then((r=>{if(r.ok){const t=a?r.clone():null;return u(r,t,l)}return e(new te(r.statusText,r.status,t.url))})).catch((r=>{"AbortError"!==r.name&&e(new Error(`${r.message} ${t.url}`));}));},u=(r,a,o)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{s||(a&&o&&function(t,e,r){if($t(),null==Ut)return;const n=gt(e.headers.get("Cache-Control")||"");if(n["no-store"])return;const i={status:e.status,statusText:e.statusText,headers:new Headers};e.headers.forEach(((t,e)=>i.headers.set(e,t))),n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString());const s=i.headers.get("Expires");if(!s)return;if(new Date(s).getTime()-r<42e4)return;let a=Rt(t.url,{persistentParams:Nt});if(206===e.status){const e=t.headers.get("Range");if(!e)return;i.status=200,a=Dt(a,{range:e});}!function(t,e){if(void 0===jt)try{new Response(new ReadableStream),jt=!0;}catch(t){jt=!1;}jt?e(t.body):t.blob().then(e);}(e,(t=>{const r=new Response(200!==(n=e.status)&&404!==n&&[101,103,204,205,304].includes(n)?null:t,i);var n;$t(),null!=Ut&&Ut.then((t=>t.put(a,r))).catch((t=>pt(t.message)));}));}(n,a,o),i=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{s||e(new Error(t.message));}));};return a?function(t,e){if($t(),null==Ut)return e(null);Ut.then((r=>{let n=Rt(t.url,{persistentParams:Nt});const i=t.headers.get("Range");i&&(n=Dt(n,{range:i})),r.match(n).then((t=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=gt(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(t);r.delete(n),i&&r.put(n,t.clone()),e(null,t,i);})).catch(e);})).catch(e);}(n,l):l(null,null),{cancel:()=>{s=!0,i||r.abort();}}}(t,e);if(yt()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new te(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},ne=function(t,e){return re(nt(t,{type:"arrayBuffer"}),e)};function ie(t){const e=document.createElement("a");return e.href=t,e.protocol===location.protocol&&e.host===location.host}const se="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let ae,oe;ae=[],oe=0;const le=function(t,e){if(Yt.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),oe>=At.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return ae.push(r),r}oe++;let r=!1;const n=()=>{if(!r)for(r=!0,oe--;ae.length&&oe<At.MAX_PARALLEL_IMAGE_REQUESTS;){const t=ae.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=le(e,r).cancel);}},i=ne(t,((t,r,i,s)=>{n(),t?e(t):r&&(self.createImageBitmap?function(t,e){const r=new Blob([new Uint8Array(t)],{type:"image/png"});createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,((t,r)=>e(t,r,i,s))):function(t,e){const r=new Image;r.onload=()=>{e(null,r),URL.revokeObjectURL(r.src),r.onload=null,requestAnimationFrame((()=>{r.src=se;}));},r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):se;}(r,((t,r)=>e(t,r,i,s))));}));return {cancel:()=>{i.cancel(),n();}}};var ue,ce,he,pe={exports:{}},fe={exports:{}},de={exports:{}},me=function(){if(he)return pe.exports;he=1;var t=(ue||(ue=1,fe.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),fe.exports),e=(ce||(ce=1,de.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),de.exports);return pe.exports=t,pe.exports.murmur3=t,pe.exports.murmur2=e,pe.exports}(),ye=e(me);class ge{constructor(t,...e){nt(this,e[0]||{}),this.type=t;}}class xe extends ge{constructor(t,e={}){super("error",nt({error:t},e));}}function ve(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function be(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class _e{on(t,e){return this._listeners=this._listeners||{},ve(t,e,this._listeners),this}off(t,e){return be(t,e,this._listeners),be(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},ve(t,e,this._oneTimeListeners),this):new Promise((e=>{this.once(t,e);}))}fire(t,e){const r="string"==typeof t?new ge(t,e):t,n=r.type;if(this.listens(n)){r.target=this;const t=this._listeners&&this._listeners[n]?this._listeners[n].slice():[];for(const e of t)e.call(this,r);const e=this._oneTimeListeners&&this._oneTimeListeners[n]?this._oneTimeListeners[n].slice():[];for(const t of e)be(n,t,this._oneTimeListeners),t.call(this,r);const i=this._eventedParent;i&&(nt(r,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(r));}else r instanceof xe&&console.error(r.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}class we{constructor(t){"string"==typeof t?this.name=t:(this.name=t.name,this.iconsetId=t.iconsetId);}static from(t){return new we(t)}static toString(t){return t.iconsetId?`${t.name}${t.iconsetId}`:t.name}static parse(t){const[e,r]=t.split("");return new we({name:e,iconsetId:r})}static isEqual(t,e){return t.name===e.name&&t.iconsetId===e.iconsetId}toString(){return we.toString(this)}serialize(){return {name:this.name,iconsetId:this.iconsetId}}}var Me,Ae={},Ie=function(){if(Me)return Ae;Me=1;var t={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function e(t){return (t=Math.round(t))<0?0:t>255?255:t}function r(t){return e("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function n(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function i(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{Ae.parseCSSColor=function(s){var a,o=s.replace(/ /g,"").toLowerCase();if(o in t)return t[o].slice();if("#"===o[0])return 4===o.length?(a=parseInt(o.substr(1),16))>=0&&a<=4095?[(3840&a)>>4|(3840&a)>>8,240&a|(240&a)>>4,15&a|(15&a)<<4,1]:null:7===o.length&&(a=parseInt(o.substr(1),16))>=0&&a<=16777215?[(16711680&a)>>16,(65280&a)>>8,255&a,1]:null;var l=o.indexOf("("),u=o.indexOf(")");if(-1!==l&&u+1===o.length){var c=o.substr(0,l),h=o.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case"rgba":if(4!==h.length)return null;p=n(h.pop());case"rgb":return 3!==h.length?null:[r(h[0]),r(h[1]),r(h[2]),p];case"hsla":if(4!==h.length)return null;p=n(h.pop());case"hsl":if(3!==h.length)return null;var f=(parseFloat(h[0])%360+360)%360/360,d=n(h[1]),m=n(h[2]),y=m<=.5?m*(d+1):m+d-m*d,g=2*m-y;return [e(255*i(g,y,f+1/3)),e(255*i(g,y,f)),e(255*i(g,y,f-1/3)),p];default:return null}}return null};}catch(t){}return Ae}();class Se{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(t){if(!t)return;if(t instanceof Se)return t;if("string"!=typeof t)return;const e=Ie.parseCSSColor(t);return e?new Se(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toStringPremultipliedAlpha(){const[t,e,r,n]=0===this.a?[0,0,0,0]:[255*this.r/this.a,255*this.g/this.a,255*this.b/this.a,this.a];return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toString(){const[t,e,r,n]=[this.r,this.g,this.b,this.a];return `rgba(${Math.round(255*t)},${Math.round(255*e)},${Math.round(255*r)},${n})`}toRenderColor(t){const{r:e,g:r,b:n,a:i}=this;return new Pe(t,e,r,n,i)}clone(){return new Se(this.r,this.g,this.b,this.a)}}class Pe{constructor(t,e,r,n,i){if(t){const s=t.image.height,a=s*s;e=0===i?0:e/i*(s-1),r=0===i?0:r/i*(s-1),n=0===i?0:n/i*(s-1);const o=Math.floor(e),l=Math.floor(r),u=Math.floor(n),c=Math.ceil(e),h=Math.ceil(r),p=Math.ceil(n),f=e-o,d=r-l,m=n-u,y=t.image.data,g=4*(o+l*a+u*s),x=4*(o+l*a+p*s),v=4*(o+h*a+u*s),b=4*(o+h*a+p*s),_=4*(c+l*a+u*s),w=4*(c+l*a+p*s),M=4*(c+h*a+u*s),A=4*(c+h*a+p*s);if(g<0||A>=y.length)throw new Error("out of range");this.r=Ee(Ee(Ee(y[g],y[x],m),Ee(y[v],y[b],m),d),Ee(Ee(y[_],y[w],m),Ee(y[M],y[A],m),d),f)/255*i,this.g=Ee(Ee(Ee(y[g+1],y[x+1],m),Ee(y[v+1],y[b+1],m),d),Ee(Ee(y[_+1],y[w+1],m),Ee(y[M+1],y[A+1],m),d),f)/255*i,this.b=Ee(Ee(Ee(y[g+2],y[x+2],m),Ee(y[v+2],y[b+2],m),d),Ee(Ee(y[_+2],y[w+2],m),Ee(y[M+2],y[A+2],m),d),f)/255*i,this.a=i;}else this.r=e,this.g=r,this.b=n,this.a=i;}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}toHslaArray(){if(0===this.a)return [0,0,0,0];const{r:t,g:e,b:r,a:n}=this,i=Math.min(Math.max(t/n,0),1),s=Math.min(Math.max(e/n,0),1),a=Math.min(Math.max(r/n,0),1),o=Math.min(i,s,a),l=Math.max(i,s,a),u=(o+l)/2;if(o===l)return [0,0,100*u,n];const c=l-o,h=u>.5?c/(2-l-o):c/(l+o);let p=0;return l===i?p=(s-a)/c+(s<a?6:0):l===s?p=(a-i)/c+2:l===a&&(p=(i-s)/c+4),p*=60,[Math.min(Math.max(p,0),360),Math.min(Math.max(100*h,0),100),Math.min(Math.max(100*u,0),100),n]}toArray01(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[t/n,e/n,r/n,n]}toArray01Scaled(t){const{r:e,g:r,b:n,a:i}=this;return 0===i?[0,0,0]:[e/i*t,r/i*t,n/i*t]}toArray01PremultipliedAlpha(){const{r:t,g:e,b:r,a:n}=this;return [t,e,r,n]}toArray01Linear(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[Math.pow(t/n,2.2),Math.pow(e/n,2.2),Math.pow(r/n,2.2),n]}}function Ee(t,e,r){return t*(1-r)+e*r}function ze(t,e,r){return t.map(((t,n)=>Ee(t,e[n],r)))}function ke(t){return t*t*t*t*t}Se.black=new Se(0,0,0,1),Se.white=new Se(1,1,1,1),Se.transparent=new Se(0,0,0,0),Se.red=new Se(1,0,0,1),Se.blue=new Se(0,0,1,1);var Te=Object.freeze({__proto__:null,array:ze,color:function(t,e,r){return new Se(Ee(t.r,e.r,r),Ee(t.g,e.g,r),Ee(t.b,e.b,r),Ee(t.a,e.a,r))},easeIn:ke,number:Ee});function Be(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class Ve extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Ce{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Ce(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const De={kind:"null"},Re={kind:"number"},Le={kind:"string"},Fe={kind:"boolean"},Oe={kind:"color"},Ne={kind:"object"},Ue={kind:"value"},je={kind:"collator"},qe={kind:"formatted"},$e={kind:"resolvedImage"};function Ge(t,e){return {kind:"array",itemType:t,N:e}}function Ye(t){if("array"===t.kind){const e=Ye(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const He=[De,Re,Le,Fe,Oe,qe,Ne,Ge(Ue),$e];function Xe(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Xe(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of He)if(!Xe(t,e))return null}return `Expected ${Ye(t)} but found ${Ye(e)} instead.`}function Ze(t,e){return e.some((e=>e.kind===t.kind))}function We(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}class Ke{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Je{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Qe{constructor(t){this.sections=t;}static fromString(t){return new Qe([new Je(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||!!t.image&&t.image.hasPrimary()))}static factory(t){return t instanceof Qe?t:Qe.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){const r=e.image.getPrimary().id.toString();t.push(["image",r]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toRenderColor(null).toArray())),t.push(r);}return t}}class tr{constructor(t,e={}){if(this.id=we.from(t),this.options=Object.assign({},e),e.transform){const{a:t,b:r,c:n,d:i,e:s,f:a}=e.transform;this.options.transform=new DOMMatrix([t,r,n,i,s,a]);}else this.options.transform=new DOMMatrix([1,0,0,1,0,0]);}toString(){const{a:t,b:e,c:r,d:n,e:i,f:s}=this.options.transform;return JSON.stringify({name:this.id.name,iconsetId:this.id.iconsetId,params:this.options.params,transform:{a:t,b:e,c:r,d:n,e:i,f:s}})}static parse(t){let e,r,n,i;try{({name:e,iconsetId:r,params:n,transform:i}=JSON.parse(t)||{});}catch(t){return null}if(!e)return null;const{a:s,b:a,c:o,d:l,e:u,f:c}=i||{};return new tr({name:e,iconsetId:r},{params:n,transform:new DOMMatrix([s,a,o,l,u,c])})}scaleSelf(t){return this.options.transform.scaleSelf(t),this}}class er{constructor(t,e,r,n,i=!1){this.primaryId=we.from(t),this.primaryOptions=e,r&&(this.secondaryId=we.from(r)),this.secondaryOptions=n,this.available=i;}toString(){return this.primaryId&&this.secondaryId?`[${this.primaryId.name},${this.secondaryId.name}]`:this.primaryId.name}hasPrimary(){return !!this.primaryId}getPrimary(){return new tr(this.primaryId,this.primaryOptions)}hasSecondary(){return !!this.secondaryId}getSecondary(){return this.secondaryId?new tr(this.secondaryId,this.secondaryOptions):null}static from(t){return "string"==typeof t?er.build({name:t}):t}static build(t,e,r,n){return !t||"object"==typeof t&&!("name"in t)?null:new er(t,r,e,n)}}function rr(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function nr(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof Se)return !0;if(t instanceof Ke)return !0;if(t instanceof Qe)return !0;if(t instanceof er)return !0;if(Array.isArray(t)){for(const e of t)if(!nr(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!nr(t[e]))return !1;return !0}return !1}function ir(t){if(null===t)return De;if("string"==typeof t)return Le;if("boolean"==typeof t)return Fe;if("number"==typeof t)return Re;if(t instanceof Se)return Oe;if(t instanceof Ke)return je;if(t instanceof Qe)return qe;if(t instanceof er)return $e;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=ir(e);if(r){if(r===t)continue;r=Ue;break}r=t;}return Ge(r||Ue,e)}return Ne}function sr(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Se?t.toStringPremultipliedAlpha():t instanceof Qe||t instanceof er?t.toString():JSON.stringify(t)}class ar{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!nr(t[1]))return e.error("invalid value");const r=t[1];let n=ir(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new ar(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof Se?["rgba"].concat(this.value.toRenderColor(null).toArray()):this.value instanceof Qe?this.value.serialize():this.value}}class or{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const lr={string:Le,number:Re,boolean:Fe,object:Ne};class ur{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in lr)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=lr[r],n++;}else i=Ue;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Ge(i,s);}else r=lr[i];const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Ue);if(!r)return null;s.push(r);}return new ur(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!Xe(this.type,ir(r)))return r;if(e===this.args.length-1)throw new or(`The expression ${JSON.stringify(this.args[e].serialize())} evaluated to ${Ye(ir(r))} but was expected to be of type ${Ye(this.type)}.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}class cr{constructor(t){this.type=qe,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parseObjectValue(s["font-scale"],r,"font-scale",Re),!t))return null;let a=null;if(s["text-font"]&&(a=e.parseObjectValue(s["text-font"],r,"text-font",Ge(Le)),!a))return null;let o=null;if(s["text-color"]&&(o=e.parseObjectValue(s["text-color"],r,"text-color",Oe),!o))return null;const l=n[n.length-1];l.scale=t,l.font=a,l.textColor=o;}else {const s=e.parse(t[r],r,Ue);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new cr(n)}evaluate(t){return new Qe(this.sections.map((e=>{const r=e.content.evaluate(t);return ir(r)===$e?new Je("",r,null,null,null):new Je(sr(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class hr{constructor(t,e,r,n){this._imageWarnHistory={},this.type=$e,this.namePrimary=t,this.nameSecondary=e,r&&(this.paramsPrimary=r.params,this.iconsetIdPrimary=r.iconset?r.iconset.id:void 0),n&&(this.paramsSecondary=n.params,this.iconsetIdSecondary=n.iconset?n.iconset.id:void 0);}static parse(t,e){if(t.length<2)return e.error("Expected two or more arguments.");let r=1;const n=[];function i(){if(r<t.length){const i=e.parse(t[r],r++,Le);return i?(n.push({image:i,options:{}}),!0):(e.error(n.length?"Secondary image variant is not a string.":"No image name provided."),!1)}return !0}function s(){if(r<t.length){const s=t[r];if(null===(i=s)||"object"!=typeof i||Array.isArray(i))return !0;const a=s.params,o=s.iconset,l=e.concat(r);if(!a&&!o)return r++,!0;if(a){if("object"!=typeof a||a.constructor!==Object)return l.error('Image options "params" should be an object'),!1;const t={},e=l.concat(void 0,"params");for(const r in a){if(!r)return e.error("Image parameter name should be non-empty"),!1;const n=e.concat(void 0,r).parse(a[r],void 0,Oe,void 0,{typeAnnotation:"coerce"});if(!n)return !1;t[r]=n;}n[n.length-1].options.params=t;}if(o){if("object"!=typeof o||o.constructor!==Object)return l.error('Image options "iconset" should be an object'),!1;if(!o.id)return l.error('Image options "iconset" should have an "id" property'),!1;n[n.length-1].options.iconset=o;}return r++,!0}var i;return !0}for(let t=0;t<2;t++)if(!i()||!s())return;return new hr(n[0].image,n[1]?n[1].image:void 0,n[0].options,n[1]?n[1].options:void 0)}evaluateParams(t,e){const r={};if(e){for(const n in e)if(e[n])try{r[n]=e[n].evaluate(t);}catch(t){continue}if(0!==Object.keys(r).length)return {params:r}}}evaluate(t){const e={name:this.namePrimary.evaluate(t),iconsetId:this.iconsetIdPrimary},r=this.nameSecondary?{name:this.nameSecondary.evaluate(t),iconsetId:this.iconsetIdSecondary}:void 0,n=er.build(e,r,this.paramsPrimary?this.evaluateParams(t,this.paramsPrimary):void 0,this.paramsSecondary?this.evaluateParams(t,this.paramsSecondary):void 0);if(n&&t.availableImages){const e=n.getPrimary().id;if(n.available=t.availableImages.some((t=>we.isEqual(t,e))),n.available){const e=n.getSecondary()?n.getSecondary().id:null;e&&(n.available=t.availableImages.some((t=>we.isEqual(t,e))));}}return n}eachChild(t){if(t(this.namePrimary),this.paramsPrimary)for(const e in this.paramsPrimary)this.paramsPrimary[e]&&t(this.paramsPrimary[e]);if(this.nameSecondary&&(t(this.nameSecondary),this.paramsSecondary))for(const e in this.paramsSecondary)this.paramsSecondary[e]&&t(this.paramsSecondary[e]);}outputDefined(){return !1}serializeOptions(t,e){const r={};if(e&&(r.iconset={id:e}),t){r.params={};for(const e in t)t[e]&&(r.params[e]=t[e].serialize());}return Object.keys(r).length>0?r:void 0}serialize(){const t=["image",this.namePrimary.serialize()];if(this.paramsPrimary||this.iconsetIdPrimary){const e=this.serializeOptions(this.paramsPrimary,this.iconsetIdPrimary);e&&t.push(e);}if(this.nameSecondary&&(t.push(this.nameSecondary.serialize()),this.paramsSecondary||this.iconsetIdSecondary)){const e=this.serializeOptions(this.paramsSecondary,this.iconsetIdSecondary);e&&t.push(e);}return t}}function pr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}const fr={"to-boolean":Fe,"to-color":Oe,"to-number":Re,"to-string":Le};class dr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0],n=[];let i=De;if("to-array"===r){if(!Array.isArray(t[1]))return null;const r=t[1].length;if(e.expectedType){if("array"!==e.expectedType.kind)return e.error(`Expected ${e.expectedType.kind} but found array.`);i=Ge(e.expectedType.itemType,r);}else {if(!(r>0&&nr(t[1][0])))return null;i=Ge(ir(t[1][0]),r);}for(let s=0;s<r;s++){const r=t[1][s];let a;if("array"===pr(r))a=e.parse(r,void 0,i.itemType);else {const t=pr(r);if(t!==i.itemType.kind)return e.error(`Expected ${i.itemType.kind} but found ${t}.`);a=e.registry.literal.parse(["literal",void 0===r?null:r],e);}if(!a)return null;n.push(a);}}else {if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");i=fr[r];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,Ue);if(!i)return null;n.push(i);}}return new dr(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Se)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:rr(e[0],e[1],e[2],e[3]),!r))return new Se(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new or(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new or(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?Qe.fromString(sr(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?er.build(sr(this.args[0].evaluate(t))):"array"===this.type.kind?this.args.map((e=>e.evaluate(t))):sr(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new cr([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new hr(this.args[0]).serialize();const t="array"===this.type.kind?[]:[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}const mr=["Unknown","Point","LineString","Polygon"];class yr{constructor(t,e){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null,this.scope=t,this.options=e;}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?mr[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}measureLight(t){return this.globals.brightness||0}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=Se.parse(t)),e}getConfig(t){return this.options?this.options.get(t):null}}class gr{constructor(t,e,r,n,i){this.name=t,this.type=e,this._evaluate=r,this.args=n,this._overloadIndex=i;}evaluate(t){if(!this._evaluate){const t=gr.definitions[this.name];this._evaluate=Array.isArray(t)?t[2]:t.overloads[this._overloadIndex][1];}return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=gr.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=[];let o=null,l=-1;for(const[n,u]of s){if(Array.isArray(n)&&n.length!==t.length-1)continue;a.push(n),l++,o=new Fn(e.registry,e.path,null,e.scope,void 0,e._scope,e.options);const s=[];let c=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,a=o.parse(r,1+s.length,i);if(!a){c=!0;break}s.push(a);}if(!c)if(Array.isArray(n)&&n.length!==s.length)o.error(`Expected ${n.length} arguments, but found ${s.length} instead.`);else {for(let t=0;t<s.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=s[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new gr(r,i,u,s,l)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s.map((([t])=>t))).map(xr).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Ye(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){gr.definitions=e;for(const r in e)t[r]=gr;}}function xr(t){return Array.isArray(t)?`(${t.map(Ye).join(", ")})`:`(${Ye(t.type)}...)`}class vr{constructor(t,e,r){this.type=je,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=void 0===r["case-sensitive"]?e.parse(!1,1,Fe):e.parseObjectValue(r["case-sensitive"],1,"case-sensitive",Fe);if(!n)return null;const i=void 0===r["diacritic-sensitive"]?e.parse(!1,1,Fe):e.parseObjectValue(r["diacritic-sensitive"],1,"diacritic-sensitive",Fe);if(!i)return null;let s=null;return r.locale&&(s=e.parseObjectValue(r.locale,1,"locale",Le),!s)?null:new vr(n,i,s)}evaluate(t){return new Ke(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}function br(t,e,r=0,n=t.length-1,i=wr){for(;n>r;){if(n-r>600){const s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);br(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}const s=t[e];let a=r,o=n;for(_r(t,r,e),i(t[n],s)>0&&_r(t,r,n);a<o;){for(_r(t,a,o),a++,o--;i(t[a],s)<0;)a++;for(;i(t[o],s)>0;)o--;}0===i(t[r],s)?_r(t,r,o):(o++,_r(t,o,n)),o<=e&&(r=o+1),e<=o&&(n=o-1);}}function _r(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function wr(t,e){return t<e?-1:t>e?1:0}function Mr(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function Ar(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Ir(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Sr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function Pr(t,e,r=!1){let n=!1;for(let o=0,l=e.length;o<l;o++){const l=e[o];for(let e=0,o=l.length,u=o-1;e<o;u=e++){const o=l[u],c=l[e];if(Sr(t,o,c))return r;(s=o)[1]>(i=t)[1]!=(a=c)[1]>i[1]&&i[0]<(a[0]-s[0])*(i[1]-s[1])/(a[1]-s[1])+s[0]&&(n=!n);}}var i,s,a;return n}function Er(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function zr(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!Er(t,e,r,n)||!Er(r,n,t,e));var i,s;}const kr=8192;function Tr(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*kr),Math.round(n*i*kr)]}function Br(t,e){for(let r=0;r<e.length;r++)if(Pr(t,e[r]))return !0;return !1}function Vr(t,e,r){for(const n of r)for(let r=0,i=n.length,s=i-1;r<i;s=r++)if(zr(t,e,n[s],n[r]))return !0;return !1}function Cr(t,e){for(let r=0;r<t.length;++r)if(!Pr(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(Vr(t[r],t[r+1],e))return !1;return !0}function Dr(t,e){for(let r=0;r<e.length;r++)if(Cr(t,e[r]))return !0;return !1}function Rr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=Tr(t[i][n],r);Ar(e,a),s.push(a);}n.push(s);}return n}function Lr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=Rr(t[i],e,r);n.push(s);}return n}function Fr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Ar(e,t);}function Or(t,e,r,n){const i=Math.pow(2,n.z)*kr,s=[n.x*kr,n.y*kr],a=[];if(!t)return a;for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Fr(n,e,r,i),a.push(n);}return a}function Nr(t,e,r,n){const i=Math.pow(2,n.z)*kr,s=[n.x*kr,n.y*kr],a=[];if(!t)return a;for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Ar(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Fr(n,e,r,i);}var o;return a}class Ur{constructor(t,e){this.type=Fe,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(nr(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new Ur(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Ur(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Ur(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=Rr(e.coordinates,n,i),a=Or(t.geometry(),r,n,i);if(!Ir(r,n))return !1;for(const t of a)if(!Pr(t,s))return !1}if("MultiPolygon"===e.type){const s=Lr(e.coordinates,n,i),a=Or(t.geometry(),r,n,i);if(!Ir(r,n))return !1;for(const t of a)if(!Br(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=Rr(e.coordinates,n,i),a=Nr(t.geometry(),r,n,i);if(!Ir(r,n))return !1;for(const t of a)if(!Cr(t,s))return !1}if("MultiPolygon"===e.type){const s=Lr(e.coordinates,n,i),a=Nr(t.geometry(),r,n,i);if(!Ir(r,n))return !1;for(const t of a)if(!Dr(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}const jr={kilometers:1,miles:1e3/1609.344,nauticalmiles:1e3/1852,meters:1e3,metres:1e3,yards:1e3/.9144,feet:1e3/.3048,inches:1e3/.0254},qr=1/298.257223563,$r=qr*(2-qr),Gr=Math.PI/180;class Yr{static fromTile(t,e,r){const n=Math.PI*(1-2*(t+.5)/Math.pow(2,e)),i=Math.atan(.5*(Math.exp(n)-Math.exp(-n)))/Gr;return new Yr(i,r)}static get units(){return jr}constructor(t,e){if(void 0===t)throw new Error("No latitude given.");if(e&&!jr[e])throw new Error(`Unknown unit ${e}. Use one of: ${Object.keys(jr).join(", ")}`);const r=6378.137*Gr*(e?jr[e]:1),n=Math.cos(t*Gr),i=1/(1-$r*(1-n*n)),s=Math.sqrt(i);this.kx=r*s*n,this.ky=r*s*i*(1-$r);}distance(t,e){const r=Zr(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}bearing(t,e){const r=Zr(e[0]-t[0])*this.kx;return Math.atan2(r,(e[1]-t[1])*this.ky)/Gr}destination(t,e,r){const n=r*Gr;return this.offset(t,Math.sin(n)*e,Math.cos(n)*e)}offset(t,e,r){return [t[0]+e/this.kx,t[1]+r/this.ky]}lineDistance(t){let e=0;for(let r=0;r<t.length-1;r++)e+=this.distance(t[r],t[r+1]);return e}area(t){let e=0;for(let r=0;r<t.length;r++){const n=t[r];for(let t=0,i=n.length,s=i-1;t<i;s=t++)e+=Zr(n[t][0]-n[s][0])*(n[t][1]+n[s][1])*(r?-1:1);}return Math.abs(e)/2*this.kx*this.ky}along(t,e){let r=0;if(e<=0)return t[0];for(let n=0;n<t.length-1;n++){const i=t[n],s=t[n+1],a=this.distance(i,s);if(r+=a,r>e)return Xr(i,s,(e-(r-a))/a)}return t[t.length-1]}pointToSegmentDistance(t,e,r){let[n,i]=e,s=Zr(r[0]-n)*this.kx,a=(r[1]-i)*this.ky;if(0!==s||0!==a){const e=(Zr(t[0]-n)*this.kx*s+(t[1]-i)*this.ky*a)/(s*s+a*a);e>1?(n=r[0],i=r[1]):e>0&&(n+=s/this.kx*e,i+=a/this.ky*e);}return s=Zr(t[0]-n)*this.kx,a=(t[1]-i)*this.ky,Math.sqrt(s*s+a*a)}pointOnLine(t,e){let r=1/0,n=t[0][0],i=t[0][1],s=0,a=0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=Zr(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(Zr(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=Zr(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<r&&(r=f,n=l,i=u,s=o,a=p);}return {point:[n,i],index:s,t:Math.max(0,Math.min(1,a))}}lineSlice(t,e,r){let n=this.pointOnLine(r,t),i=this.pointOnLine(r,e);if(n.index>i.index||n.index===i.index&&n.t>i.t){const t=n;n=i,i=t;}const s=[n.point],a=n.index+1,o=i.index;!Hr(r[a],s[0])&&a<=o&&s.push(r[a]);for(let t=a+1;t<=o;t++)s.push(r[t]);return Hr(r[o],i.point)||s.push(i.point),s}lineSliceAlong(t,e,r){let n=0;const i=[];for(let s=0;s<r.length-1;s++){const a=r[s],o=r[s+1],l=this.distance(a,o);if(n+=l,n>t&&0===i.length&&i.push(Xr(a,o,(t-(n-l))/l)),n>=e)return i.push(Xr(a,o,(e-(n-l))/l)),i;n>t&&i.push(o);}return i}bufferPoint(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[0]+n,t[1]+r]}bufferBBox(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[2]+n,t[3]+r]}insideBBox(t,e){return Zr(t[0]-e[0])>=0&&Zr(t[0]-e[2])<=0&&t[1]>=e[1]&&t[1]<=e[3]}}function Hr(t,e){return t[0]===e[0]&&t[1]===e[1]}function Xr(t,e,r){const n=Zr(e[0]-t[0]);return [t[0]+n*r,t[1]+(e[1]-t[1])*r]}function Zr(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}class Wr{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}var Kr=8192;function Jr(t,e){return e.dist-t.dist}const Qr=100,tn=50;function en(t){const e=[1/0,1/0,-1/0,-1/0];if(e.length!==t.length)return !1;for(let r=0;r<e.length;r++)if(e[r]!==t[r])return !1;return !0}function rn(t){return t[1]-t[0]+1}function nn(t,e){const r=t[1]>=t[0]&&t[1]<e;return r||console.warn("Distance Expression: Index is out of range"),r}function sn(t,e){if(t[0]>t[1])return [null,null];const r=rn(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}{if(1===r)return [t,null];const e=Math.floor(r/2)-1;return [[t[0],t[0]+e],[t[0]+e+1,t[1]]]}}function an(t,e){const r=[1/0,1/0,-1/0,-1/0];if(!nn(e,t.length))return r;for(let n=e[0];n<=e[1];++n)Ar(r,t[n]);return r}function on(t){const e=[1/0,1/0,-1/0,-1/0];for(let r=0;r<t.length;++r)for(let n=0;n<t[r].length;++n)Ar(e,t[r][n]);return e}function ln(t,e,r){if(en(t)||en(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function un(t){return 360*t-180}function cn(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function hn(t,e){const r=Math.pow(2,e.z),n=(t.y/Kr+e.y)/r;return [un((t.x/Kr+e.x)/r),cn(n)]}function pn(t,e){const r=[];for(let n=0;n<t.length;++n)r.push(hn(t[n],e));return r}function fn(t,e,r){const n=r.pointOnLine(e,t).point;return r.distance(t,n)}function dn(t,e,r,n,i){const s=r.slice(n[0],n[1]+1);let a=1/0;for(let r=e[0];r<=e[1];++r)if(0===(a=Math.min(a,fn(t[r],s,i))))return 0;return a}function mn(t,e,r,n,i){const s=Math.min(i.pointToSegmentDistance(t,r,n),i.pointToSegmentDistance(e,r,n)),a=Math.min(i.pointToSegmentDistance(r,t,e),i.pointToSegmentDistance(n,t,e));return Math.min(s,a)}function yn(t,e,r,n,i){if(!nn(e,t.length)||!nn(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<e[1];++a)for(let e=n[0];e<n[1];++e){if(zr(t[a],t[a+1],r[e],r[e+1]))return 0;s=Math.min(s,mn(t[a],t[a+1],r[e],r[e+1],i));}return s}function gn(t,e,r,n,i){if(!nn(e,t.length)||!nn(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(0===(s=Math.min(s,i.distance(t[a],r[e]))))return s;return s}function xn(t,e,r){if(Pr(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i.length;if(e<2)return console.warn("Distance Expression: Invalid polygon!"),NaN;if(i[0]!==i[e-1]&&0===(n=Math.min(n,r.pointToSegmentDistance(t,i[e-1],i[0]))))return n;if(0===(n=Math.min(n,fn(t,i,r))))return n}return n}function vn(t,e,r,n){if(!nn(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Pr(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s)for(const e of r)for(let r=0,a=e.length,o=a-1;r<a;o=r++){if(zr(t[s],t[s+1],e[o],e[r]))return 0;i=Math.min(i,mn(t[s],t[s+1],e[o],e[r],n));}return i}function bn(t,e){for(const r of t)for(let t=0;t<=r.length-1;++t)if(Pr(r[t],e,!0))return !0;return !1}function _n(t,e,r,n=1/0){const i=on(t),s=on(e);if(n!==1/0&&ln(i,s,r)>=n)return n;if(Ir(i,s)){if(bn(t,e))return 0}else if(bn(e,t))return 0;let a=n;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++)for(const i of e)for(let e=0,o=i.length,l=o-1;e<o;l=e++){if(zr(n[s],n[t],i[l],i[e]))return 0;a=Math.min(a,mn(n[s],n[t],i[l],i[e],r));}return a}function wn(t,e,r,n,i,s,a){if(null===s||null===a)return;const o=ln(an(n,s),an(i,a),r);o<e&&t.push({dist:o,range1:s,range2:a});}function Mn(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const a=new Wr([{dist:0,range1:[0,t.length-1],range2:[0,0]}],Jr),o=e?tn:Qr,l=on(r);for(;a.length;){const i=a.pop();if(i.dist>=s)continue;const u=i.range1;if(rn(u)<=o){if(!nn(u,t.length))return NaN;if(e){const e=vn(t,u,r,n);if(0===(s=Math.min(s,e)))return s}else for(let e=u[0];e<=u[1];++e){const i=xn(t[e],r,n);if(0===(s=Math.min(s,i)))return s}}else {const r=sn(u,e);if(null!==r[0]){const e=ln(an(t,r[0]),l,n);e<s&&a.push({dist:e,range1:r[0],range2:[0,0]});}if(null!==r[1]){const e=ln(an(t,r[1]),l,n);e<s&&a.push({dist:e,range1:r[1],range2:[0,0]});}}}return s}function An(t,e,r,n,i,s=1/0){let a=Math.min(s,i.distance(t[0],r[0]));if(0===a)return a;const o=new Wr([{dist:0,range1:[0,t.length-1],range2:[0,r.length-1]}],Jr),l=e?tn:Qr,u=n?tn:Qr;for(;o.length;){const s=o.pop();if(s.dist>=a)continue;const c=s.range1,h=s.range2;if(rn(c)<=l&&rn(h)<=u){if(!nn(c,t.length)||!nn(h,r.length))return NaN;if(e&&n?a=Math.min(a,yn(t,c,r,h,i)):e||n?e&&!n?a=Math.min(a,dn(r,h,t,c,i)):!e&&n&&(a=Math.min(a,dn(t,c,r,h,i))):a=Math.min(a,gn(t,c,r,h,i)),0===a)return a}else {const s=sn(c,e),l=sn(h,n);wn(o,a,i,t,r,s[0],l[0]),wn(o,a,i,t,r,s[0],l[1]),wn(o,a,i,t,r,s[1],l[0]),wn(o,a,i,t,r,s[1],l[1]);}}return a}function In(t,e,r,n,i=1/0){let s=i;const a=an(t,[0,t.length-1]);for(const i of r)if(!(s!==1/0&&ln(a,an(i,[0,i.length-1]),n)>=s)&&(s=Math.min(s,An(t,e,i,!0,n,s)),0===s))return s;return s}function Sn(t,e,r,n,i=1/0){let s=i;const a=an(t,[0,t.length-1]);for(const i of r){if(s!==1/0&&ln(a,on(i),n)>=s)continue;const r=Mn(t,e,i,n,s);if(isNaN(r))return r;if(0===(s=Math.min(s,r)))return s}return s}function Pn(t){return "Point"===t||"MultiPoint"===t||"LineString"===t||"MultiLineString"===t||"Polygon"===t||"MultiPolygon"===t}class En{constructor(t,e){this.type=Re,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires either one argument, but found ' ${t.length-1} instead.`);if(nr(t[1])){const e=t[1];if("FeatureCollection"===e.type){for(let t=0;t<e.features.length;++t)if(Pn(e.features[t].geometry.type))return new En(e,e.features[t].geometry)}else if("Feature"===e.type){if(Pn(e.geometry.type))return new En(e,e.geometry)}else if(Pn(e.type))return new En(e,e)}return e.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].")}evaluate(t){const e=t.geometry(),r=t.canonicalID();if(null!=e&&null!=r){if("Point"===t.geometryType())return function(t,e,r){const n=[];for(const r of t)for(const t of r)n.push(hn(t,e));const i=new Yr(n[0][1],"meters");return "Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type?An(n,!1,"Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,i):"MultiLineString"===r.type?In(n,!1,r.coordinates,i):"Polygon"===r.type||"MultiPolygon"===r.type?Sn(n,!1,"Polygon"===r.type?[r.coordinates]:r.coordinates,i):null}(e,r,this.geometries);if("LineString"===t.geometryType())return function(t,e,r){const n=[];for(const r of t){const t=[];for(const n of r)t.push(hn(n,e));n.push(t);}const i=new Yr(n[0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return In("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=In(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}if("Polygon"===r.type||"MultiPolygon"===r.type){let t=1/0;for(let e=0;e<n.length;e++){const s=Sn(n[e],!0,"Polygon"===r.type?[r.coordinates]:r.coordinates,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return null}(e,r,this.geometries);if("Polygon"===t.geometryType())return function(t,e,r){const n=[];for(const r of function(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=Mr(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}return i&&n.push(i),n}(t)){const t=[];for(let n=0;n<r.length;++n)t.push(pn(r[n],e));n.push(t);}const i=new Yr(n[0][0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return Sn("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=Sn(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return "Polygon"===r.type||"MultiPolygon"===r.type?function(t,e,r){let n=1/0;for(const i of t)for(const t of e){const e=_n(i,t,r,n);if(isNaN(e))return e;if(0===(n=Math.min(n,e)))return n}return n}("Polygon"===r.type?[r.coordinates]:r.coordinates,n,i):null}(e,r,this.geometries);console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.");}else console.warn("Distance Expression: requirs valid feature and canonical information.");return null}eachChild(){}outputDefined(){return !0}serialize(){return ["distance",this.geojson]}}function zn(t,e){switch(t){case"string":return sr(e);case"number":return +e;case"boolean":return !!e;case"color":return Se.parse(e);case"formatted":return Qe.fromString(sr(e));case"resolvedImage":return er.build(sr(e))}return e}function kn(t,e,r,n){return void 0!==n&&(t=n*Math.round(t/n)),void 0!==e&&t<e&&(t=e),void 0!==r&&t>r&&(t=r),t}class Tn{constructor(t,e,r){this.type=t,this.key=e,this.scope=r;}static parse(t,e){let r=e.expectedType;if(null==r&&(r=Ue),t.length<2||t.length>3)return e.error("Invalid number of arguments for 'config' expression.");const n=e.parse(t[1],1);if(!(n instanceof ar))return e.error("Key name of 'config' expression must be a string literal.");if(t.length>=3){const i=e.parse(t[2],2);return i instanceof ar?new Tn(r,sr(n.value),sr(i.value)):e.error("Scope of 'config' expression must be a string literal.")}return new Tn(r,sr(n.value))}evaluate(t){const e=[this.key,this.scope,t.scope].filter(Boolean).join(""),r=t.getConfig(e);if(!r)return null;const{type:n,value:i,values:s,minValue:a,maxValue:o,stepValue:l}=r,u=r.default.evaluate(t);let c=u;if(i){const e=t.scope;t.scope=(e||"").split("").slice(1).join(""),c=i.evaluate(t),t.scope=e;}return n&&(c=zn(n,c)),void 0===c||void 0===a&&void 0===o&&void 0===l||("number"==typeof c?c=kn(c,a,o,l):Array.isArray(c)&&(c=c.map((t=>"number"==typeof t?kn(t,a,o,l):t)))),void 0!==i&&void 0!==c&&s&&!s.includes(c)&&(c=u,n&&(c=zn(n,c))),(n&&n!==this.type||void 0!==c&&ir(c)!==this.type)&&(c=zn(this.type.kind,c)),c}eachChild(){}outputDefined(){return !1}serialize(){const t=["config",this.key];return this.scope&&t.concat(this.key),t}}function Bn(t){if(t instanceof gr){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Ur)return !1;if(t instanceof En)return !1;let e=!0;return t.eachChild((t=>{e&&!Bn(t)&&(e=!1);})),e}function Vn(t){if(t instanceof gr&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!Vn(t)&&(e=!1);})),e}function Cn(t){if(t instanceof Tn)return new Set([t.key]);let e=new Set;return t.eachChild((t=>{e=new Set([...e,...Cn(t)]);})),e}function Dn(t,e){if(t instanceof gr&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Dn(t,e)&&(r=!1);})),r}class Rn{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Rn(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class Ln{constructor(t,e=[],r,n=new Ce,i=[],s,a){this.registry=t,this.path=e,this.key=e.map((t=>"string"==typeof t?`['${t}']`:`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r,this._scope=s,this.options=a;}parse(t,e,r,n,i={}){return e||r?this.concat(e,null,r,n)._parse(t,i):this._parse(t,i)}parseObjectValue(t,e,r,n,i,s={}){return this.concat(e,r,n,i)._parse(t,s)}_parse(t,e){function r(t,e,r){return "assert"===r?new ur(e,[t]):"coerce"===r?new dr(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n="string"==typeof t[0]?this.registry[t[0]]:void 0;if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof ar)&&"resolvedImage"!==i.type.kind&&On(i)){const t=new yr(this._scope,this.options);try{i=new ar(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return dr.parse(["to-array",t],this)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r,n){let i="number"==typeof t?this.path.concat(t):this.path;i="string"==typeof e?i.concat(e):i;const s=n?this.scope.concat(n):this.scope;return new Ln(this.registry,i,r||null,s,this.errors,this._scope,this.options)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Ve(r,t));}checkSubtype(t,e){const r=Xe(t,e);return r&&this.error(r),r}}var Fn=Ln;function On(t){if(t instanceof Rn)return On(t.boundExpression);if(t instanceof gr&&"error"===t.name)return !1;if(t instanceof vr)return !1;if(t instanceof Ur)return !1;if(t instanceof En)return !1;if(t instanceof Tn)return !1;const e=t instanceof dr||t instanceof ur;let r=!0;return t.eachChild((t=>{r=e?r&&On(t):r&&t instanceof ar;})),!!r&&Bn(t)&&Dn(t,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])}function Nn(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new or("Input is not a number.");a=o-1;}return 0}class Un{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Re);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new Un(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Nn(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}const jn=.95047,qn=1.08883,$n=4/29,Gn=6/29,Yn=3*Gn*Gn,Hn=Gn*Gn*Gn,Xn=Math.PI/180,Zn=180/Math.PI;function Wn(t){return t>Hn?Math.pow(t,1/3):t/Yn+$n}function Kn(t){return t>Gn?t*t*t:Yn*(t-$n)}function Jn(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function Qn(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function ti(t){const e=Qn(t.r),r=Qn(t.g),n=Qn(t.b),i=Wn((.4124564*e+.3575761*r+.1804375*n)/jn),s=Wn((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*s-16,a:500*(i-s),b:200*(s-Wn((.0193339*e+.119192*r+.9503041*n)/qn)),alpha:t.a}}function ei(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Kn(e),r=jn*Kn(r),n=qn*Kn(n),new Se(Jn(3.2404542*r-1.5371385*e-.4985314*n),Jn(-.969266*r+1.8760108*e+.041556*n),Jn(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function ri(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const ni={forward:ti,reverse:ei,interpolate:function(t,e,r){return {l:Ee(t.l,e.l,r),a:Ee(t.a,e.a,r),b:Ee(t.b,e.b,r),alpha:Ee(t.alpha,e.alpha,r)}}},ii={forward:function(t){const{l:e,a:r,b:n}=ti(t),i=Math.atan2(n,r)*Zn;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Xn,r=t.c;return ei({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:ri(t.h,e.h,r),c:Ee(t.c,e.c,r),l:Ee(t.l,e.l,r),alpha:Ee(t.alpha,e.alpha,r)}}};var si=Object.freeze({__proto__:null,hcl:ii,lab:ni});class ai{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=oi(e,t.base,r,n);else if("linear"===t.name)i=oi(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new U(s[0],s[1],s[2],s[3]).solve(oi(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length-1>3&&(t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,Re),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=Oe:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new ai(o,r,n,i,a):e.error(`Type ${Ye(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=Nn(e,n),a=ai.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?Te[this.type.kind.toLowerCase()](o,l,a):"interpolate-hcl"===this.operator?ii.reverse(ii.interpolate(ii.forward(o),ii.forward(l),a)):ni.reverse(ni.interpolate(ni.forward(o),ni.forward(l),a))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier",...this.interpolation.controlPoints];const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function oi(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class li{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const s=n&&i.some((t=>Xe(n,t.type)));return new li(s?Ue:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof er&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class ui{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new ui(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class ci{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Re),n=e.parse(t[2],2,Ge(e.expectedType||Ue));return r&&n?new ci(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new or(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new or(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new or(`Array index must be an integer, but found ${e} instead. Use at-interpolated to retrieve interpolated result with a fractional index.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class hi{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Re),n=e.parse(t[2],2,Ge(e.expectedType||Ue));return r&&n?new hi(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new or(`Array index out of bounds: ${e} < 0.`);if(e>r.length-1)throw new or(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e===Math.floor(e))return r[e];const n=Math.floor(e),i=Math.ceil(e),s=r[n],a=r[i];if("number"!=typeof s||"number"!=typeof a)throw new or(`Cannot interpolate between non-number values at index ${e}.`);const o=e-n;return s*(1-o)+a*o}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at-interpolated",this.index.serialize(),this.input.serialize()]}}class pi{constructor(t,e){this.type=Fe,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ue),n=e.parse(t[2],2,Ue);return r&&n?Ze(r.type,[Fe,Le,Re,De,Ue])?new pi(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ye(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(null==r)return !1;if(!We(e,["boolean","string","number","null"]))throw new or(`Expected first argument to be of type boolean, string, number or null, but found ${Ye(ir(e))} instead.`);if(!We(r,["string","array"]))throw new or(`Expected second argument to be of type array or string, but found ${Ye(ir(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class fi{constructor(t,e,r){this.type=Re,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ue),n=e.parse(t[2],2,Ue);if(!r||!n)return null;if(!Ze(r.type,[Fe,Le,Re,De,Ue]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ye(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Re);return i?new fi(r,n,i):null}return new fi(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!We(e,["boolean","string","number","null"]))throw new or(`Expected first argument to be of type boolean, string, number or null, but found ${Ye(ir(e))} instead.`);if(!We(r,["string","array"]))throw new or(`Expected second argument to be of type array or string, but found ${Ye(ir(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class di{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,ir(t)))return null}else r=ir(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,Ue);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new di(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (ir(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class mi{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,Fe);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new mi(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class yi{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ue),n=e.parse(t[2],2,Re);if(!r||!n)return null;if(!Ze(r.type,[Ge(Ue),Le,Ue]))return e.error(`Expected first argument to be of type array or string, but found ${Ye(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Re);return i?new yi(r.type,r,n,i):null}return new yi(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!We(e,["string","array"]))throw new or(`Expected first argument to be of type array or string, but found ${Ye(ir(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function gi(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function xi(t,e,r,n){return 0===n.compare(e,r)}function vi(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=Fe,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Ue);if(!s)return null;if(!gi(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Ye(s.type)}'.`);let a=e.parse(t[2],2,Ue);if(!a)return null;if(!gi(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Ye(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${Ye(s.type)}' and '${Ye(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new ur(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new ur(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,je),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=ir(s),r=ir(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new or(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=ir(s),r=ir(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const bi=vi("==",(function(t,e,r){return e===r}),xi),_i=vi("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !xi(0,e,r,n)})),wi=vi("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),Mi=vi(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),Ai=vi("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Ii=vi(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class Si{constructor(t,e,r,n,i,s){this.type=Le,this.number=t,this.locale=e,this.currency=r,this.unit=n,this.minFractionDigits=i,this.maxFractionDigits=s;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Re);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parseObjectValue(n.locale,2,"locale",Le),!i))return null;let s=null;if(n.currency&&(s=e.parseObjectValue(n.currency,2,"currency",Le),!s))return null;let a=null;if(n.unit&&(a=e.parseObjectValue(n.unit,2,"unit",Le),!a))return null;let o=null;if(n["min-fraction-digits"]&&(o=e.parseObjectValue(n["min-fraction-digits"],2,"min-fraction-digits",Re),!o))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parseObjectValue(n["max-fraction-digits"],2,"max-fraction-digits",Re),!l)?null:new Si(r,i,s,a,o,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(t):void 0,unit:this.unit?this.unit.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.unit&&t(this.unit),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.unit&&(t.unit=this.unit.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class Pi{constructor(t){this.type=Re,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Ye(r.type)} instead.`):new Pi(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new or(`Expected value to be of type string or array, but found ${Ye(ir(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}function Ei(t){return function(){t=1831565813+(t|=0)|0;let e=Math.imul(t^t>>>15,1|t);return e=e+Math.imul(e^e>>>7,61|e)^e,((e^e>>>14)>>>0)/4294967296}}const zi={"==":bi,"!=":_i,">":Mi,"<":wi,">=":Ii,"<=":Ai,array:ur,at:ci,"at-interpolated":hi,boolean:ur,case:mi,coalesce:li,collator:vr,format:cr,image:hr,in:pi,"index-of":fi,interpolate:ai,"interpolate-hcl":ai,"interpolate-lab":ai,length:Pi,let:ui,literal:ar,match:di,number:ur,"number-format":Si,object:ur,slice:yi,step:Un,string:ur,"to-boolean":dr,"to-color":dr,"to-number":dr,"to-string":dr,var:Rn,within:Ur,distance:En,config:Tn};function ki(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=rr(e,r,n,s);if(a)throw new or(a);return new Se(e/255*s,r/255*s,n/255*s,s)}function Ti(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=function(t,e,r,n){return "number"==typeof t&&t>=0&&t<=360?"number"==typeof e&&e>=0&&e<=100&&"number"==typeof r&&r>=0&&r<=100?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid hsla value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 's', and 'l' must be between 0 and 100.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'h' must be between 0 and 360.`}(e,r,n,s);if(a)throw new or(a);const o=`hsla(${e}, ${r}%, ${n}%, ${s})`,l=Se.parse(o);if(!l)throw new or(`Failed to parse HSLA color: ${o}`);return l}function Bi(t,e){return t in e}function Vi(t,e){const r=e[t];return void 0===r?null:r}function Ci(t){return {type:t}}function Di(t){return {result:"success",value:t}}function Ri(t){return {result:"error",value:t}}function Li(t,e){return !!t&&!!t.parameters&&t.parameters.indexOf(e)>-1}function Fi(t){return "data-driven"===t["property-type"]}function Oi(t){return Li(t.expression,"measure-light")}function Ni(t){return Li(t.expression,"zoom")}function Ui(t){return !!t.expression&&t.expression.interpolated}function ji(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function qi(t){return t}function $i(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(Ui(e)?"exponential":"interval");if(r&&((t=Be({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],Se.parse(t[1])]))),t.default=Se.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!si[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let a,o,l;if("exponential"===s)a=Xi;else if("interval"===s)a=Hi;else if("categorical"===s){a=Yi,o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);a=Zi;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,$i(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:ai.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Xi({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:ai.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>a(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Gi(t.default,e.default):a(t,e,i,o,l)}}}function Gi(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Yi(t,e,r,n,i){return Gi(typeof r===i?n[r]:void 0,t.default,e.default)}function Hi(t,e,r){if("number"!==pr(r))return Gi(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Nn(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Xi(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==pr(r))return Gi(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=Nn(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1];let u=Te[e.type]||qi;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=si[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),a));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,a)}}:u(o,l,a)}function Zi(t,e,r){return "color"===e.type?r=Se.parse(r):"formatted"===e.type?r=Qe.fromString(r.toString()):"resolvedImage"===e.type?r=er.build(r.toString()):pr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),Gi(r,t.default,e.default)}gr.register(zi,{error:[{kind:"error"},[Le],(t,[e])=>{throw new or(e.evaluate(t))}],typeof:[Le,[Ue],(t,[e])=>Ye(ir(e.evaluate(t)))],"to-rgba":[Ge(Re,4),[Oe],(t,[e])=>e.evaluate(t).toRenderColor(null).toArray()],"to-hsla":[Ge(Re,4),[Oe],(t,[e])=>e.evaluate(t).toRenderColor(null).toHslaArray()],rgb:[Oe,[Re,Re,Re],ki],rgba:[Oe,[Re,Re,Re,Re],ki],hsl:[Oe,[Re,Re,Re],Ti],hsla:[Oe,[Re,Re,Re,Re],Ti],has:{type:Fe,overloads:[[[Le],(t,[e])=>Bi(e.evaluate(t),t.properties())],[[Le,Ne],(t,[e,r])=>Bi(e.evaluate(t),r.evaluate(t))]]},get:{type:Ue,overloads:[[[Le],(t,[e])=>Vi(e.evaluate(t),t.properties())],[[Le,Ne],(t,[e,r])=>Vi(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Ue,[Le],(t,[e])=>Vi(e.evaluate(t),t.featureState||{})],properties:[Ne,[],t=>t.properties()],"geometry-type":[Le,[],t=>t.geometryType()],id:[Ue,[],t=>t.id()],zoom:[Re,[],t=>t.globals.zoom],pitch:[Re,[],t=>t.globals.pitch||0],"distance-from-center":[Re,[],t=>t.distanceFromCenter()],"measure-light":[Re,[Le],(t,[e])=>t.measureLight(e.evaluate(t))],"heatmap-density":[Re,[],t=>t.globals.heatmapDensity||0],"line-progress":[Re,[],t=>t.globals.lineProgress||0],"raster-value":[Re,[],t=>t.globals.rasterValue||0],"raster-particle-speed":[Re,[],t=>t.globals.rasterParticleSpeed||0],"sky-radial-progress":[Re,[],t=>t.globals.skyRadialProgress||0],accumulated:[Ue,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Re,Ci(Re),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[Re,Ci(Re),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:Re,overloads:[[[Re,Re],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[Re],(t,[e])=>-e.evaluate(t)]]},"/":[Re,[Re,Re],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[Re,[Re,Re],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[Re,[],()=>Math.LN2],pi:[Re,[],()=>Math.PI],e:[Re,[],()=>Math.E],"^":[Re,[Re,Re],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[Re,[Re],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Re,[Re],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Re,[Re],(t,[e])=>Math.log(e.evaluate(t))],log2:[Re,[Re],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Re,[Re],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Re,[Re],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Re,[Re],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Re,[Re],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Re,[Re],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Re,[Re],(t,[e])=>Math.atan(e.evaluate(t))],min:[Re,Ci(Re),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Re,Ci(Re),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Re,[Re],(t,[e])=>Math.abs(e.evaluate(t))],round:[Re,[Re],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[Re,[Re],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Re,[Re],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Fe,[Le,Ue],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Fe,[Ue],(t,[e])=>t.id()===e.value],"filter-type-==":[Fe,[Le],(t,[e])=>t.geometryType()===e.value],"filter-<":[Fe,[Le,Ue],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[Fe,[Ue],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[Fe,[Le,Ue],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[Fe,[Ue],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[Fe,[Le,Ue],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[Fe,[Ue],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[Fe,[Le,Ue],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[Fe,[Ue],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[Fe,[Ue],(t,[e])=>e.value in t.properties()],"filter-has-id":[Fe,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Fe,[Ge(Le)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Fe,[Ge(Ue)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Fe,[Le,Ge(Ue)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Fe,[Le,Ge(Ue)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Fe,overloads:[[[Fe,Fe],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Ci(Fe),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Fe,overloads:[[[Fe,Fe],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Ci(Fe),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Fe,[Fe],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Fe,[Le],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Le,[Le],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Le,[Le],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Le,Ci(Ue),(t,e)=>e.map((e=>sr(e.evaluate(t)))).join("")],"resolved-locale":[Le,[je],(t,[e])=>e.evaluate(t).resolvedLocale()],random:[Re,[Re,Re,Ue],(t,e)=>{const[r,n,i]=e.map((e=>e.evaluate(t)));if(r>n)return r;if(r===n)return r;let s;if("string"==typeof i)s=function(t){let e=0;if(0===t.length)return e;for(let r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r),e|=0;return e}(i);else {if("number"!=typeof i)throw new or(`Invalid seed input: ${i}`);s=i;}return r+Ei(s)()*(n-r)}]});class Wi{constructor(t,e,r,n){this.expression=t,this._warningHistory={},this._evaluator=new yr(r,n),this._defaultValue=e?function(t){return "color"===t.type&&(ji(t.default)||Array.isArray(t.default))?new Se(0,0,0,0):"color"===t.type?Se.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this.configDependencies=Cn(t);}evaluateWithoutErrorHandling(t,e,r,n,i,s,a,o){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s,a,o){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new or(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(`Failed to evaluate expression "${JSON.stringify(this.expression.serialize())}". ${t.message}`)),this._defaultValue}}}function Ki(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in zi}function Ji(t,e,r,n){const i=new Fn(zi,[],e?function(t){const e={color:Oe,string:Le,number:Re,enum:Le,boolean:Fe,formatted:qe,resolvedImage:$e};return "array"===t.type?Ge(e[t.value]||Ue,t.length):e[t.type]}(e):void 0,void 0,void 0,r,n),s=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return s?Di(new Wi(s,e,r,n)):Ri(i.errors)}class Qi{constructor(t,e,r,n){this.kind=t,this._styleExpression=e,this.isLightConstant=r,this.isLineProgressConstant=n,this.isStateDependent="constant"!==t&&!Vn(e.expression),this.configDependencies=Cn(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class ts{constructor(t,e,r,n,i,s){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Vn(e.expression),this.isLightConstant=i,this.isLineProgressConstant=s,this.configDependencies=Cn(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?ai.interpolationFactor(this.interpolationType,t,e,r):0}}function es(t,e,r,n){if("error"===(t=Ji(t,e,r,n)).result)return t;const i=t.value.expression,s=Bn(i);if(!s&&!Fi(e))return Ri([new Ve("","data expressions not supported")]);const a=Dn(i,["zoom","pitch","distance-from-center"]);if(!a&&!Ni(e))return Ri([new Ve("","zoom expressions not supported")]);const o=Dn(i,["measure-light"]);if(!o&&!Oi(e))return Ri([new Ve("","measure-light expression not supported")]);const l=Dn(i,["line-progress"]);if(!l&&!function(t){return Li(t.expression,"line-progress")}(e))return Ri([new Ve("","line-progress expression not supported")]);const u=e.expression&&e.expression.relaxZoomRestriction,c=ns(i);return c||a||u?c instanceof Ve?Ri([c]):c instanceof ai&&!Ui(e)?Ri([new Ve("",'"interpolate" expressions cannot be used with this property')]):Di(c?new ts(s&&l?"camera":"composite",t.value,c.labels,c instanceof ai?c.interpolation:void 0,o,l):new Qi(s&&l?"constant":"source",t.value,o,l)):Ri([new Ve("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')])}class rs{constructor(t,e){this._parameters=t,this._specification=e,Be(this,$i(this._parameters,this._specification));}static deserialize(t){return new rs(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function ns(t){let e=null;if(t instanceof ui)e=ns(t.result);else if(t instanceof li){for(const r of t.args)if(e=ns(r),e)break}else (t instanceof Un||t instanceof ai)&&t.input instanceof gr&&"zoom"===t.input.name&&(e=t);return e instanceof Ve||t.eachChild((t=>{const r=ns(t);r instanceof Ve?e=r:e&&r&&e!==r&&(e=new Ve("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}var is,ss,as=function(){if(ss)return is;ss=1,is=e;var t=3;function e(e,r,n){var i=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;var s=new Int32Array(this.arrayBuffer);e=s[0],this.d=(r=s[1])+2*(n=s[2]);for(var a=0;a<this.d*this.d;a++){var o=s[t+a],l=s[t+a+1];i.push(o===l?null:s.subarray(o,l));}var u=s[t+i.length+1];this.keys=s.subarray(s[t+i.length],u),this.bboxes=s.subarray(u),this.insert=this._insertReadonly;}else {this.d=r+2*n;for(var c=0;c<this.d*this.d;c++)i.push([]);this.keys=[],this.bboxes=[];}this.n=r,this.extent=e,this.padding=n,this.scale=r/e,this.uid=0;var h=n/r*e;this.min=-h,this.max=e+h;}return e.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},e.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},e.prototype._insertCell=function(t,e,r,n,i,s){this.cells[i].push(s);},e.prototype.query=function(t,e,r,n,i){var s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},i),o},e.prototype._queryCell=function(t,e,r,n,i,s,a,o){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===a[p]){var f=4*p;(o?o(c[f+0],c[f+1],c[f+2],c[f+3]):t<=c[f+2]&&e<=c[f+3]&&r>=c[f+0]&&n>=c[f+1])?(a[p]=!0,s.push(u[p])):a[p]=!1;}}},e.prototype._forEachCell=function(t,e,r,n,i,s,a,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var f=u;f<=h;f++){var d=this.d*f+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(f),this._convertFromCellCoord(p+1),this._convertFromCellCoord(f+1)))&&i.call(this,t,e,r,n,d,s,a,o))return}},e.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},e.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},e.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var e=this.cells,r=t+this.cells.length+1+1,n=0,i=0;i<this.cells.length;i++)n+=this.cells[i].length;var s=new Int32Array(r+n+this.keys.length+this.bboxes.length);s[0]=this.extent,s[1]=this.n,s[2]=this.padding;for(var a=r,o=0;o<e.length;o++){var l=e[o];s[t+o]=a,s.set(l,a),a+=l.length;}return s[t+e.length]=a,s.set(this.keys,a),s[t+e.length+1]=a+=this.keys.length,s.set(this.bboxes,a),a+=this.bboxes.length,s.buffer},is}(),os=e(as);const ls={};function us(t,e,r={}){Object.defineProperty(t,"_classRegistryKey",{value:e,writable:!1}),ls[e]={klass:t,omit:r.omit||[]};}us(Object,"Object"),os.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.add(r),{buffer:r}},os.deserialize=function(t){return new os(t.buffer)},Object.defineProperty(os,"name",{value:"Grid"}),us(os,"Grid"),"undefined"!=typeof DOMMatrix&&us(DOMMatrix,"DOMMatrix"),us(Se,"Color"),us(Error,"Error"),us(Qe,"Formatted"),us(Je,"FormattedSection"),us(te,"AJAXError"),us(er,"ResolvedImage"),us(rs,"StylePropertyFunction"),us(Wi,"StyleExpression",{omit:["_evaluator"]}),us(we,"ImageId"),us(tr,"ImageVariant"),us(ts,"ZoomDependentExpression"),us(Qi,"ZoomConstantExpression"),us(gr,"CompoundExpression",{omit:["_evaluate"]});for(const t in zi)ls[zi[t]._classRegistryKey]||us(zi[t],`Expression${t}`);function cs(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function hs(t){return self.ImageBitmap&&t instanceof ImageBitmap}function ps(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(cs(t)||hs(t))return e&&e.add(t),t;if(ArrayBuffer.isView(t))return e&&e.add(t.buffer),t;if(t instanceof ImageData)return e&&e.add(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(ps(n,e));return r}if(t instanceof Map){const e={$name:"Map",entries:[]};for(const[r,n]of t.entries())e.entries.push(ps(r),ps(n));return e}if(t instanceof Set){const e={$name:"Set"};let r=0;for(const n of t.values())e[++r]=ps(n);return e}if(t instanceof DOMMatrix){const e={$name:"DOMMatrix"},r=["is2D","m11","m12","m13","m14","m21","m22","m23","m24","m31","m32","m33","m34","m41","m42","m43","m44","a","b","c","d","e","f"];for(const n of r)e[n]=t[n];return e}if("bigint"==typeof t)return {$name:"BigInt",value:t.toString()};if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error(`Can't serialize object of unregistered class "${r.name}".`);const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t)t.hasOwnProperty(r)&&(ls[n].omit.indexOf(r)>=0||(i[r]=ps(t[r],e)));t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function fs(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||cs(t)||hs(t)||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(fs);if("object"==typeof t){const e=t.$name||"Object";if("Map"===e){const e=t.entries||[],r=new Map;for(let t=0;t<e.length;t+=2)r.set(fs(e[t]),fs(e[t+1]));return r}if("Set"===e){const e=new Set;for(const r of Object.keys(t))"$name"!==r&&e.add(fs(t[r]));return e}if("DOMMatrix"===e){let e;return e=t.is2D?[t.a,t.b,t.c,t.d,t.e,t.f]:[t.m11,t.m12,t.m13,t.m14,t.m21,t.m22,t.m23,t.m24,t.m31,t.m32,t.m33,t.m34,t.m41,t.m42,t.m43,t.m44],new DOMMatrix(e)}if("BigInt"===e)return BigInt(t.value);const{klass:r}=ls[e];if(!r)throw new Error(`Can't deserialize unregistered class "${e}".`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const e of Object.keys(t))"$name"!==e&&(n[e]=fs(t[e]));return n}throw new Error("can't deserialize object of type "+typeof t)}const ds={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519,Osage:t=>t>=66736&&t<=66815,"CJK Unified Ideographs Extension B":t=>t>=131072&&t<=173791};function ms(t){for(const e of t)if(xs(e.charCodeAt(0)))return !0;return !1}function ys(t){for(const e of t)if(!gs(e.charCodeAt(0)))return !1;return !0}function gs(t){return !(ds.Arabic(t)||ds["Arabic Supplement"](t)||ds["Arabic Extended-A"](t)||ds["Arabic Presentation Forms-A"](t)||ds["Arabic Presentation Forms-B"](t))}function xs(t){return !(746!==t&&747!==t&&(t<4352||!(ds["Bopomofo Extended"](t)||ds.Bopomofo(t)||ds["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||ds["CJK Compatibility Ideographs"](t)||ds["CJK Compatibility"](t)||ds["CJK Radicals Supplement"](t)||ds["CJK Strokes"](t)||!(!ds["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||ds["CJK Unified Ideographs Extension A"](t)||ds["CJK Unified Ideographs"](t)||ds["Enclosed CJK Letters and Months"](t)||ds["Hangul Compatibility Jamo"](t)||ds["Hangul Jamo Extended-A"](t)||ds["Hangul Jamo Extended-B"](t)||ds["Hangul Jamo"](t)||ds["Hangul Syllables"](t)||ds.Hiragana(t)||ds["Ideographic Description Characters"](t)||ds.Kanbun(t)||ds["Kangxi Radicals"](t)||ds["Katakana Phonetic Extensions"](t)||ds.Katakana(t)&&12540!==t||!(!ds["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!ds["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||ds["Unified Canadian Aboriginal Syllabics"](t)||ds["Unified Canadian Aboriginal Syllabics Extended"](t)||ds["Vertical Forms"](t)||ds["Yijing Hexagram Symbols"](t)||ds["Yi Syllables"](t)||ds["Yi Radicals"](t))))}function vs(t){return !(xs(t)||function(t){return !!(ds["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||ds["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||ds["Letterlike Symbols"](t)||ds["Number Forms"](t)||ds["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||ds["Control Pictures"](t)&&9251!==t||ds["Optical Character Recognition"](t)||ds["Enclosed Alphanumerics"](t)||ds["Geometric Shapes"](t)||ds["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||ds["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||ds["CJK Symbols and Punctuation"](t)||ds.Katakana(t)||ds["Private Use Area"](t)||ds["CJK Compatibility Forms"](t)||ds["Small Form Variants"](t)||ds["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function bs(t){return ds.Arabic(t)||ds["Arabic Supplement"](t)||ds["Arabic Extended-A"](t)||ds["Arabic Presentation Forms-A"](t)||ds["Arabic Presentation Forms-B"](t)}function _s(t){return t>=1424&&t<=2303||ds["Arabic Presentation Forms-A"](t)||ds["Arabic Presentation Forms-B"](t)}function ws(t,e){return !(!e&&_s(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||ds.Khmer(t))}function Ms(t){for(const e of t)if(_s(e.charCodeAt(0)))return !0;return !1}const As="deferred",Is="loading",Ss="loaded";let Ps=null,Es="unavailable",zs=null;const ks=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(Es="error"),Ps&&Ps(t);};function Ts(){Bs.fire(new ge("pluginStateChange",{pluginStatus:Es,pluginURL:zs}));}const Bs=new _e,Vs=function(){return Es},Cs=function(){if(Es!==As||!zs)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Es=Is,Ts(),zs&&ne({url:zs},(t=>{t?ks(t):(Es=Ss,Ts());}));},Ds={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>Es===Ss||null!=Ds.applyArabicShaping,isLoading:()=>Es===Is,setState(t){Es=t.pluginStatus,zs=t.pluginURL;},isParsed:()=>null!=Ds.applyArabicShaping&&null!=Ds.processBidirectionalText&&null!=Ds.processStyledBidirectionalText,getPluginURL:()=>zs};class Rs{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.transition=e.transition,this.pitch=e.pitch,this.brightness=e.brightness):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0,this.brightness=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!ws(r.charCodeAt(0),e))return !1;return !0}(t,Ds.isLoaded())}}class Ls{constructor(t,e,r,n){this.property=t,this.value=e,this.expression=function(t,e,r,n){if(ji(t))return new rs(t,e);if(Ki(t)||Array.isArray(t)&&t.length>0){const i=es(t,e,r,n);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=Se.parse(t)),{kind:"constant",configDependencies:new Set,evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r,n);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Fs{constructor(t,e,r){this.property=t,this.value=new Ls(t,void 0,e,r);}transitioned(t,e){return new Ns(this.property,this.value,e,nt({},t.transition,this.transition),t.now)}untransitioned(){return new Ns(this.property,this.value,null,{},0)}}class Os{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._scope=e,this._options=r,this.configDependencies=new Set;}getValue(t){return ct(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Fs(this._values[t].property,this._scope,this._options)),this._values[t].value=new Ls(this._values[t].property,null===e?void 0:ct(e),this._scope,this._options),this._values[t].value.expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].value.expression.configDependencies]));}setTransitionOrValue(t,e){e&&(this._options=e);const r=this._properties.properties;if(t)for(const e in t){const n=t[e];if(e.endsWith("-transition")){const t=e.slice(0,-11);r[t]&&this.setTransition(t,n);}else r.hasOwnProperty(e)&&this.setValue(e,n);}}getTransition(t){return ct(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Fs(this._values[t].property)),this._values[t].transition=ct(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Us(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Us(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Ns{constructor(t,e,r,n,i){const s=n.delay||0,a=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+s,this.end=this.begin+a,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,W(a))}}return i}}class Us{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new $s(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class js{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._scope=e,this._options=r,this.configDependencies=new Set;}getValue(t){return ct(this._values[t].value)}setValue(t,e){this._values[t]=new Ls(this._values[t].property,null===e?void 0:ct(e),this._scope,this._options),this._values[t].expression.configDependencies&&(this.configDependencies=new Set([...this.configDependencies,...this._values[t].expression.configDependencies]));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new $s(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class qs{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class $s{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class Gs{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=Te[this.specification.type];return n?n(t,e,r):t}}class Ys{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new qs(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new qs(this,{kind:"constant",value:void 0},t.parameters);const n=Te[this.specification.type];return n?new qs(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class Hs{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Xs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const e=new Rs(0,{});for(const r in t){const n=t[r];n.specification.overridable&&this.overridableProperties.push(r);const i=this.defaultPropertyValues[r]=new Ls(n,void 0),s=this.defaultTransitionablePropertyValues[r]=new Fs(n);this.defaultTransitioningPropertyValues[r]=s.untransitioned(),this.defaultPossiblyEvaluatedValues[r]=i.possiblyEvaluate(e);}}}us(Ys,"DataDrivenProperty"),us(Gs,"DataConstantProperty"),us(Hs,"ColorRampProperty");var Zs=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"required":false,"type":"array","value":"light-3d"},"terrain":{"type":"terrain","optional":true},"fog":{"type":"fog"},"snow":{"type":"snow","experimental":true},"rain":{"type":"rain","experimental":true},"camera":{"type":"camera"},"color-theme":{"type":"colorTheme"},"indoor":{"type":"indoor","experimental":true},"imports":{"type":"array","value":"import"},"iconsets":{"experimental":true,"type":"iconsets"},"schema":{"type":"schema"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"},"models":{"type":"models"},"featuresets":{"experimental":true,"type":"featuresets"}},"featuresets":{"experimental":true,"*":{"type":"featureset"}},"featureset":{"experimental":true,"metadata":{"experimental":true,"type":"*"},"selectors":{"experimental":true,"type":"array","value":"selector"}},"selector":{"experimental":true,"layer":{"experimental":true,"type":"string","required":true},"properties":{"experimental":true,"type":"selectorProperty","required":false},"featureNamespace":{"experimental":true,"type":"string","required":false},"_uniqueFeatureID":{"experimental":true,"type":"boolean","private":true,"required":false}},"selectorProperty":{"experimental":true,"*":{"experimental":true,"type":"*"}},"model":{"type":"string","required":true},"import":{"id":{"type":"string","required":true},"url":{"type":"string","required":true},"config":{"type":"config"},"data":{"type":"$root"},"color-theme":{"type":"colorTheme","optional":true}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","property-type":"data-constant","expression":{},"required":true},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string","required":true},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false,"property-type":"data-constant"},"shadow-quality":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"parameters":["zoom"]},"experimental":true},"shadow-intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"iconsets":{"*":{"type":"iconset"}},"iconset":["iconset_sprite","iconset_source"],"iconset_sprite":{"type":{"required":true,"type":"enum","values":{"sprite":1}},"url":{"required":true,"type":"string"}},"iconset_source":{"type":{"required":true,"type":"enum","values":{"source":1}},"source":{"required":true,"type":"string"}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_raster_array","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_array":{"experimental":true,"type":{"required":true,"type":"enum","values":{"raster-array":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"rasterLayers":{"type":"*"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"},"dynamic":{"type":"boolean","default":false}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":1}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":1}},"url":{"required":false,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_model":{"type":{"required":true,"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"raster-particle":{"experimental":true},"hillshade":{},"model":{"experimental":true},"background":{},"sky":{},"slot":{},"clip":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_clip","layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_raster-particle","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_clip":{"clip-layer-types":{"type":"array","value":"enum","values":{"model":1,"symbol":1},"default":[],"expression":{},"property-type":"data-constant"},"clip-layer-scope":{"type":"array","value":"string","default":[],"expression":{},"property-type":"data-constant"}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-base":1,"hd-road-markup":1},"default":"none","experimental":true,"private":true,"expression":{},"property-type":"data-constant"},"fill-construct-bridge-guard-rail":{"type":"boolean","default":"true","experimental":true,"private":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"circle-elevation-reference":{"type":"enum","values":{"none":1,"hd-road-markup":1},"default":"none","experimental":true,"expression":{},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","experimental":true,"default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1,"none":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-z-offset":{"type":"number","experimental":true,"default":0,"expression":{"parameters":["zoom","feature","line-progress"]},"property-type":"data-driven"},"line-elevation-reference":{"type":"enum","values":{"none":1,"sea":1,"ground":1,"hd-road-markup":1},"default":"none","experimental":true,"expression":{},"property-type":"data-constant"},"line-cross-slope":{"type":"number","experimental":true,"expression":{},"property-type":"constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"line-width-unit":{"type":"enum","values":{"pixels":1,"meters":1},"default":"pixels","experimental":true,"private":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-elevation-reference":{"type":"enum","values":{"sea":1,"ground":1,"hd-road-markup":1},"default":"ground","experimental":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":0.1,"maximum":10,"experimental":true,"private":true,"expression":{},"property-type":"data-constant"},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size-scale-range":{"type":"array","value":"number","length":2,"default":[0.8,2],"minimum":0.1,"maximum":10,"experimental":true,"private":true,"expression":{},"property-type":"data-constant"},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster-particle":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_hillshade":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_raster-particle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_clip":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_model":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"snow":{"density":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,0.85],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"opacity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,0.3],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","property-type":"data-constant","default":"#ffffff","experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"center-thinning":{"type":"number","property-type":"data-constant","default":0.4,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,50],"minimum":0,"maximum":360,"length":2,"value":"number","property-type":"data-constant","transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"flake-size":{"type":"number","property-type":"data-constant","default":0.71,"minimum":0,"maximum":5,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"rain":{"density":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,0.5],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["measure-light","brightness"],0,"#03113d",0.3,"#a8adbc"],"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"opacity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["measure-light","brightness"],0,0.88,1,0.7],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],11,0,13,1],"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vignette-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["measure-light","brightness"],0,"#001736",0.3,"#464646"],"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"center-thinning":{"type":"number","property-type":"data-constant","default":0.57,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"direction":{"type":"array","default":[0,80],"minimum":0,"maximum":360,"length":2,"value":"number","property-type":"data-constant","transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"droplet-size":{"type":"array","default":[2.6,18.2],"minimum":0,"maximum":50,"length":2,"value":"number","property-type":"data-constant","transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"distortion-strength":{"type":"number","property-type":"data-constant","default":0.7,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective","property-type":"data-constant"}},"colorTheme":{"data":{"type":"string","property-type":"data-constant","expression":{}}},"indoor":{"floorplanFeaturesetId":{"type":"string","experimental":true,"property-type":"data-constant","expression":{}},"buildingFeaturesetId":{"type":"string","experimental":true,"property-type":"data-constant","expression":{}}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_raster-particle","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"fill-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-bridge-guard-rail-color":{"type":"color","default":"rgba(241, 236, 225, 255)","experimental":true,"private":true,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature"]},"property-type":"data-driven"},"fill-tunnel-structure-color":{"type":"color","default":"rgba(241, 236, 225, 255)","transition":true,"experimental":true,"private":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature"]},"property-type":"data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-height-alignment":{"type":"enum","experimental":true,"values":{"terrain":1,"flat":1},"default":"flat","property-type":"data-constant"},"fill-extrusion-base-alignment":{"type":"enum","experimental":true,"values":{"terrain":1,"flat":1},"default":"terrain","property-type":"data-constant"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"property-type":"data-constant","type":"number","experimental":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"property-type":"data-constant","type":"number","experimental":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"property-type":"data-constant","type":"number","experimental":true,"default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"property-type":"data-constant","type":"color","experimental":true,"default":"#ffffff","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"property-type":"data-constant","type":"number","experimental":true,"default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","experimental":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","experimental":true,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"property-type":"data-constant","type":"number","experimental":true,"default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"property-type":"data-constant","type":"number","experimental":true,"default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"property-type":"data-constant","type":"boolean","default":true,"experimental":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"fill-extrusion-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"fill-extrusion-line-width":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-cast-shadows":{"type":"boolean","default":true,"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light","line-progress"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"property-type":"constant"},"line-trim-fade-range":{"type":"array","value":"number","experimental":true,"length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-trim-color":{"type":"color","experimental":true,"default":"transparent","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-border-width":{"type":"number","private":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","private":true,"default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-occlusion-opacity":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true,"property-type":"data-constant"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light","feature-state"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-image-cross-fade":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"transition":true},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-color-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"symbol-z-offset":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-value"]},"property-type":"color-ramp"},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"raster-array-band":{"type":"string","required":false,"experimental":true,"property-type":"data-constant"},"raster-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster-particle":{"raster-particle-array-band":{"type":"string","required":false,"property-type":"data-constant"},"raster-particle-count":{"type":"number","default":512,"minimum":1,"property-type":"data-constant"},"raster-particle-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-particle-speed"]},"property-type":"color-ramp"},"raster-particle-max-speed":{"type":"number","default":1,"minimum":1,"property-type":"data-constant"},"raster-particle-speed-factor":{"type":"number","default":0.2,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-fade-opacity-factor":{"type":"number","default":0.98,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-reset-rate-factor":{"type":"number","default":0.8,"minimum":0,"maximum":1,"property-type":"data-constant"},"raster-particle-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_background":{"background-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":[]},"experimental":true,"property-type":"data-constant"},"background-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"property-type":"data-driven"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d","property-type":"data-constant"},"model-cast-shadows":{"type":"boolean","default":true,"property-type":"data-constant"},"model-receive-shadows":{"type":"boolean","default":true,"property-type":"data-constant"},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant","transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"model-front-cutoff":{"type":"array","private":true,"value":"number","property-type":"data-constant","expression":{"interpolated":true,"parameters":["zoom"]},"length":3,"default":[0,0,1],"minimum":[0,0,0],"maximum":[1,1,1]}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"*"}}}');function Ws(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Ks(t){if(Array.isArray(t))return t.map(Ks);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Ks(t[r]);return e}return Ws(t)}function Js(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!Js(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function Qs(t,e="",r=null,n="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};Js(t)||(t=aa(t));const i=t;let s=!0;try{s=function(t){if(!ra(t))return t;let e=Ks(t);return ea(e),e=ta(e),e}(i);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(i,null,2)}\n        `);}let a=null,o=null;if("background"!==n&&"sky"!==n&&"slot"!==n){o=Zs[`filter_${n}`];const t=Ji(s,o,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));a=(e,r,n)=>t.value.evaluate(e,r,{},n);}let l=null,u=null;if(s!==i){const t=Ji(i,o,e,r);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));l=(e,r,n,i,s)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,s),u=!Bn(t.value.expression);}return {filter:a,dynamicFilter:l||void 0,needGeometry:sa(s),needFeature:!!u}}function ta(t){if(!Array.isArray(t))return t;const e=function(t){if(na.has(t[0]))for(let e=1;e<t.length;e++)if(ra(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>ta(t)))}function ea(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||ra(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||ra(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||ra(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)ea(t[e]);}function ra(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(ra(t[e]))return !0;return !1}const na=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function ia(t,e){return t<e?-1:t>e?1:0}function sa(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(sa(t[e]))return !0;return !1}function aa(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?oa(t[1],t[2],"=="):"!="===e?ca(oa(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?oa(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(aa))):"all"===e?["all"].concat(t.slice(1).map(aa)):"none"===e?["all"].concat(t.slice(1).map(aa).map(ca)):"in"===e?la(t[1],t.slice(2)):"!in"===e?ca(la(t[1],t.slice(2))):"has"===e?ua(t[1]):"!has"!==e||ca(ua(t[1]));var r;}function oa(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function la(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(ia)]]:["filter-in-small",t,["literal",e]]}}function ua(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function ca(t){return ["!",t]}const ha="";function pa(t,e){return e?`${t}${ha}${e}`:t}const fa="-transition",da=new Set(["fill","line","background","hillshade","raster"]);class ma extends _e{constructor(t,e,r,n,i){if(super(),this.id=t.id,this.fqid=pa(this.id,r),this.type=t.type,this.scope=r,this.lut=n,this.options=i,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,this.configDependencies=new Set,"custom"!==t.type){if(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,t.type&&"background"!==t.type&&"sky"!==t.type&&"slot"!==t.type){this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter;const e=Ji(this.filter,Zs[`filter_${t.type}`]);"error"!==e.result&&(this.configDependencies=new Set([...this.configDependencies,...e.value.configDependencies]));}if(t.slot&&(this.slot=t.slot),e.layout&&(this._unevaluatedLayout=new js(e.layout,this.scope,i),this.configDependencies=new Set([...this.configDependencies,...this._unevaluatedLayout.configDependencies])),e.paint){this._transitionablePaint=new Os(e.paint,this.scope,i);for(const e in t.paint)this.setPaintProperty(e,t.paint[e]);for(const e in t.layout)this.setLayoutProperty(e,t.layout[e]);this.configDependencies=new Set([...this.configDependencies,...this._transitionablePaint.configDependencies]),this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new $s(e.paint);}}}onAdd(t){}onRemove(t){}isDraped(t){return !this.is3D(!0)&&da.has(this.type)}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e){if("custom"===this.type&&"visibility"===t)return void(this.visibility=e);const r=this._unevaluatedLayout;r._properties.properties[t]&&(r.setValue(t,e),this.configDependencies=new Set([...this.configDependencies,...r.configDependencies]),"visibility"===t&&this.possiblyEvaluateVisibility());}possiblyEvaluateVisibility(){this._unevaluatedLayout._values.visibility&&(this.visibility=this._unevaluatedLayout._values.visibility.possiblyEvaluate({zoom:0}));}getPaintProperty(t){return t.endsWith(fa)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e){const r=this._transitionablePaint,n=r._properties.properties;if(t.endsWith(fa)){const i=t.slice(0,-11);return n[i]&&r.setTransition(i,e||void 0),!1}if(!n[t])return !1;const i=r._values[t],s=i.value.isDataDriven(),a=i.value;r.setValue(t,e),this.configDependencies=new Set([...this.configDependencies,...r.configDependencies]),this._handleSpecialPaintPropertyUpdate(t);const o=r._values[t].value,l=o.isDataDriven(),u=t.endsWith("pattern")||"line-dasharray"===t;return l||s||u||this._handleOverridablePaintPropertyUpdate(t,a,o)}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getDefaultProgramParams(t,e,r){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){return ut({id:this.id,type:this.type,slot:this.slot,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()},((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}is3D(t){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}hasShadowPass(){return !1}canCastShadows(){return !1}hasLightBeamPass(){return !1}cutoffRange(){return 0}tileCoverLift(){return 0}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof qs&&Fi(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}compileFilter(t){this._filterCompiled||(this._featureFilter=Qs(this.filter,this.scope,t),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}getLayerRenderingStats(){return this._stats}resetLayerRenderingStats(t){this._stats&&("shadow"===t.renderPass?this._stats.numRenderedVerticesInShadowPass=0:this._stats.numRenderedVerticesInTransparentPass=0);}queryRadius(t){}queryIntersectsFeature(t,e,r,n,i,s,a,o,l){}}const ya={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ga{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class xa{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.add(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("StructArray#_refreshViews() must be implemented by each concrete StructArray layout")}emplace(...t){throw new Error("StructArray#emplace() must be implemented by each concrete StructArray layout")}emplaceBack(...t){throw new Error("StructArray#emplaceBack() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null;}}function va(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=ya[t.type].BYTES_PER_ELEMENT,s=r=ba(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:ba(r,Math.max(n,e)),alignment:e}}function ba(t,e){return Math.ceil(t/e)*e}class _a extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}_a.prototype.bytesPerElement=4,us(_a,"StructArrayLayout2i4");class wa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}wa.prototype.bytesPerElement=6,us(wa,"StructArrayLayout3i6");class Ma extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}Ma.prototype.bytesPerElement=8,us(Ma,"StructArrayLayout4i8");class Aa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Aa.prototype.bytesPerElement=4,us(Aa,"StructArrayLayout1f4");class Ia extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t,s=2*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.float32[s+1]=n,t}}Ia.prototype.bytesPerElement=8,us(Ia,"StructArrayLayout2i1f8");class Sa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}Sa.prototype.bytesPerElement=8,us(Sa,"StructArrayLayout3i8");class Pa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=5*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,t}}Pa.prototype.bytesPerElement=10,us(Pa,"StructArrayLayout5i10");class Ea extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=s,this.uint8[u+7]=a,this.float32[c+2]=o,t}}Ea.prototype.bytesPerElement=12,us(Ea,"StructArrayLayout2i4ub1f12");class za extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}za.prototype.bytesPerElement=12,us(za,"StructArrayLayout3f12");class ka extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=6*t,o=3*t;return this.uint16[a+0]=e,this.uint16[a+1]=r,this.uint16[a+2]=n,this.uint16[a+3]=i,this.float32[o+2]=s,t}}ka.prototype.bytesPerElement=12,us(ka,"StructArrayLayout4ui1f12");class Ta extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,this.uint16[s+3]=i,t}}Ta.prototype.bytesPerElement=8,us(Ta,"StructArrayLayout4ui8");class Ba extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}Ba.prototype.bytesPerElement=12,us(Ba,"StructArrayLayout6i12");class Va extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}Va.prototype.bytesPerElement=24,us(Va,"StructArrayLayout4i4ui4i24");class Ca extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=10*t,l=5*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=a,t}}Ca.prototype.bytesPerElement=20,us(Ca,"StructArrayLayout3i3f20");class Da extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Da.prototype.bytesPerElement=16,us(Da,"StructArrayLayout4f16");class Ra extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Ra.prototype.bytesPerElement=4,us(Ra,"StructArrayLayout1ul4");class La extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}La.prototype.bytesPerElement=4,us(La,"StructArrayLayout2ui4");class Fa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=this.length;return this.resize(f+1),this.emplace(f,t,e,r,n,i,s,a,o,l,u,c,h,p)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f){const d=20*t,m=10*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.int16[d+4]=s,this.float32[m+3]=a,this.float32[m+4]=o,this.float32[m+5]=l,this.float32[m+6]=u,this.int16[d+14]=c,this.uint32[m+8]=h,this.uint16[d+18]=p,this.uint16[d+19]=f,t}}Fa.prototype.bytesPerElement=40,us(Fa,"StructArrayLayout5i4f1i1ul2ui40");class Oa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=s,this.int16[l+6]=a,this.int16[l+7]=o,t}}Oa.prototype.bytesPerElement=16,us(Oa,"StructArrayLayout3i2i2i16");class Na extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}Na.prototype.bytesPerElement=16,us(Na,"StructArrayLayout2f1f2i16");class Ua extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=20*t,l=5*t;return this.uint8[o+0]=e,this.uint8[o+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=a,t}}Ua.prototype.bytesPerElement=20,us(Ua,"StructArrayLayout2ub4f20");class ja extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}ja.prototype.bytesPerElement=6,us(ja,"StructArrayLayout3ui6");class qa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b){const _=this.length;return this.resize(_+1),this.emplace(_,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_){const w=30*t,M=15*t,A=60*t;return this.int16[w+0]=e,this.int16[w+1]=r,this.int16[w+2]=n,this.float32[M+2]=i,this.float32[M+3]=s,this.uint16[w+8]=a,this.uint16[w+9]=o,this.uint32[M+5]=l,this.uint32[M+6]=u,this.uint32[M+7]=c,this.uint16[w+16]=h,this.uint16[w+17]=p,this.uint16[w+18]=f,this.float32[M+10]=d,this.float32[M+11]=m,this.uint8[A+48]=y,this.uint8[A+49]=g,this.uint8[A+50]=x,this.uint32[M+13]=v,this.int16[w+28]=b,this.uint8[A+58]=_,t}}qa.prototype.bytesPerElement=60,us(qa,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class $a extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,I,S,P,E,z,k,T,B){const V=this.length;return this.resize(V+1),this.emplace(V,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,I,S,P,E,z,k,T,B)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,I,S,P,E,z,k,T,B,V){const C=20*t,D=40*t,R=80*t;return this.float32[C+0]=e,this.float32[C+1]=r,this.int16[D+4]=n,this.int16[D+5]=i,this.int16[D+6]=s,this.int16[D+7]=a,this.int16[D+8]=o,this.int16[D+9]=l,this.int16[D+10]=u,this.int16[D+11]=c,this.int16[D+12]=h,this.uint16[D+13]=p,this.uint16[D+14]=f,this.uint16[D+15]=d,this.uint16[D+16]=m,this.uint16[D+17]=y,this.uint16[D+18]=g,this.uint16[D+19]=x,this.uint16[D+20]=v,this.uint16[D+21]=b,this.uint16[D+22]=_,this.uint16[D+23]=w,this.uint16[D+24]=M,this.uint16[D+25]=A,this.uint16[D+26]=I,this.uint16[D+27]=S,this.uint32[C+14]=P,this.float32[C+15]=E,this.float32[C+16]=z,this.float32[C+17]=k,this.float32[C+18]=T,this.uint8[R+76]=B,this.uint16[D+39]=V,t}}$a.prototype.bytesPerElement=80,us($a,"StructArrayLayout2f9i15ui1ul4f1ub1ui80");class Ga extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=5*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.float32[a+3]=i,this.float32[a+4]=s,t}}Ga.prototype.bytesPerElement=20,us(Ga,"StructArrayLayout5f20");class Ya extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=7*t;return this.float32[l+0]=e,this.float32[l+1]=r,this.float32[l+2]=n,this.float32[l+3]=i,this.float32[l+4]=s,this.float32[l+5]=a,this.float32[l+6]=o,t}}Ya.prototype.bytesPerElement=28,us(Ya,"StructArrayLayout7f28");class Ha extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,r,n,i,s,a,o,l,u,c)}emplace(t,e,r,n,i,s,a,o,l,u,c,h){const p=11*t;return this.float32[p+0]=e,this.float32[p+1]=r,this.float32[p+2]=n,this.float32[p+3]=i,this.float32[p+4]=s,this.float32[p+5]=a,this.float32[p+6]=o,this.float32[p+7]=l,this.float32[p+8]=u,this.float32[p+9]=c,this.float32[p+10]=h,t}}Ha.prototype.bytesPerElement=44,us(Ha,"StructArrayLayout11f44");class Xa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,a,o,l)}emplace(t,e,r,n,i,s,a,o,l,u){const c=9*t;return this.float32[c+0]=e,this.float32[c+1]=r,this.float32[c+2]=n,this.float32[c+3]=i,this.float32[c+4]=s,this.float32[c+5]=a,this.float32[c+6]=o,this.float32[c+7]=l,this.float32[c+8]=u,t}}Xa.prototype.bytesPerElement=36,us(Xa,"StructArrayLayout9f36");class Za extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}Za.prototype.bytesPerElement=8,us(Za,"StructArrayLayout2f8");class Wa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,this.uint16[s+4]=i,t}}Wa.prototype.bytesPerElement=12,us(Wa,"StructArrayLayout1ul3ui12");class Ka extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Ka.prototype.bytesPerElement=2,us(Ka,"StructArrayLayout1ui2");class Ja extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m){const y=this.length;return this.resize(y+1),this.emplace(y,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y){const g=16*t;return this.float32[g+0]=e,this.float32[g+1]=r,this.float32[g+2]=n,this.float32[g+3]=i,this.float32[g+4]=s,this.float32[g+5]=a,this.float32[g+6]=o,this.float32[g+7]=l,this.float32[g+8]=u,this.float32[g+9]=c,this.float32[g+10]=h,this.float32[g+11]=p,this.float32[g+12]=f,this.float32[g+13]=d,this.float32[g+14]=m,this.float32[g+15]=y,t}}Ja.prototype.bytesPerElement=64,us(Ja,"StructArrayLayout16f64");class Qa extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=10*t,u=5*t;return this.uint16[l+0]=e,this.uint16[l+1]=r,this.uint16[l+2]=n,this.uint16[l+3]=i,this.float32[u+2]=s,this.float32[u+3]=a,this.float32[u+4]=o,t}}Qa.prototype.bytesPerElement=20,us(Qa,"StructArrayLayout4ui3f20");class to extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.int16[1*t+0]=e,t}}to.prototype.bytesPerElement=2,us(to,"StructArrayLayout1i2");class eo extends xa{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint8[1*t+0]=e,t}}eo.prototype.bytesPerElement=1,us(eo,"StructArrayLayout1ub1");class ro extends ga{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}ro.prototype.size=40;class no extends Fa{get(t){return new ro(this,t)}}us(no,"CollisionBoxArray");class io extends ga{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}io.prototype.size=60;class so extends qa{get(t){return new io(this,t)}}us(so,"PlacedSymbolArray");class ao extends ga{get tileAnchorX(){return this._structArray.float32[this._pos4+0]}get tileAnchorY(){return this._structArray.float32[this._pos4+1]}get projectedAnchorX(){return this._structArray.int16[this._pos2+4]}get projectedAnchorY(){return this._structArray.int16[this._pos2+5]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+6]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+7]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+11]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get key(){return this._structArray.uint16[this._pos2+13]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+14]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+15]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+17]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+19]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+21]}get featureIndex(){return this._structArray.uint16[this._pos2+22]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+23]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numIconVertices(){return this._structArray.uint16[this._pos2+25]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+26]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+27]}get crossTileID(){return this._structArray.uint32[this._pos4+14]}set crossTileID(t){this._structArray.uint32[this._pos4+14]=t;}get textOffset0(){return this._structArray.float32[this._pos4+15]}get textOffset1(){return this._structArray.float32[this._pos4+16]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+17]}get zOffset(){return this._structArray.float32[this._pos4+18]}set zOffset(t){this._structArray.float32[this._pos4+18]=t;}get hasIconTextFit(){return this._structArray.uint8[this._pos1+76]}get elevationFeatureIndex(){return this._structArray.uint16[this._pos2+39]}}ao.prototype.size=80;class oo extends $a{get(t){return new ao(this,t)}}us(oo,"SymbolInstanceArray");class lo extends Aa{getoffsetX(t){return this.float32[1*t+0]}}us(lo,"GlyphOffsetArray");class uo extends _a{getx(t){return this.int16[2*t+0]}gety(t){return this.int16[2*t+1]}}us(uo,"SymbolLineVertexArray");class co extends ga{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}co.prototype.size=12;class ho extends Wa{get(t){return new co(this,t)}}us(ho,"FeatureIndexArray");class po extends La{geta_centroid_pos0(t){return this.uint16[2*t+0]}geta_centroid_pos1(t){return this.uint16[2*t+1]}}us(po,"FillExtrusionCentroidArray");class fo extends ga{get a_join_normal_inside0(){return this._structArray.int16[this._pos2+0]}get a_join_normal_inside1(){return this._structArray.int16[this._pos2+1]}get a_join_normal_inside2(){return this._structArray.int16[this._pos2+2]}}fo.prototype.size=6;class mo extends wa{get(t){return new fo(this,t)}}us(mo,"FillExtrusionWallArray");const yo=va([{name:"a_pos",components:2,type:"Int16"}],4),go=va([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class xo{constructor(t=[]){this.segments=t;}_prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>xo.MAX_VERTEX_ARRAY_LENGTH&&pt(`Max vertices per segment is ${xo.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>xo.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e,primitiveOffset:r,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}prepareSegment(t,e,r,n){return this._prepareSegment(t,e.length,r.length,n)}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new xo([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function vo(t,e){return 256*(t=Q(Math.floor(t),0,255))+Q(Math.floor(e),0,255)}xo.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,us(xo,"SegmentVector");const bo=va([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),_o=va([{name:"a_dash",components:4,type:"Uint16"}]);class wo{constructor(){this.ids=[],this.uniqueIds=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(Mo(t)),this.positions.push(e,r,n);}eachPosition(t,e){const r=Mo(t);let n=0,i=this.ids.length-1;for(;n<i;){const t=n+i>>1;this.ids[t]>=r?i=t:n=t+1;}for(;this.ids[n]===r;)e(this.positions[3*n],this.positions[3*n+1],this.positions[3*n+2]),n++;}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return Ao(r,n,0,r.length-1),e&&(e.add(r.buffer),e.add(n.buffer)),{ids:r,positions:n}}static deserialize(t){const e=new wo;let r;e.ids=t.ids,e.positions=t.positions;for(const t of e.ids)t!==r&&e.uniqueIds.push(t),r=t;return e.indexed=!0,e}}function Mo(t){const e=+t;return !isNaN(e)&&Number.MIN_SAFE_INTEGER<=e&&e<=Number.MAX_SAFE_INTEGER?e:ye(String(t))}function Ao(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;Io(t,s,a),Io(e,3*s,3*a),Io(e,3*s+1,3*a+1),Io(e,3*s+2,3*a+2);}a-r<n-a?(Ao(t,e,r,a),r=a+1):(Ao(t,e,a+1,n),n=a);}}function Io(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}us(wo,"FeaturePositionMap");class So{constructor(t){this.gl=t.gl,this.initialized=!1;}fetchUniformLocation(t,e){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(t,e),this.initialized=!0),!!this.location}set(t,e,r){throw new Error("Uniform#set() must be implemented by each concrete Uniform")}}class Po extends So{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1i(this.location,r));}}class Eo extends So{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1f(this.location,r));}}class zo extends So{constructor(t){super(t),this.current=[0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]||(this.current=r,this.gl.uniform2f(this.location,r[0],r[1])));}}class ko extends So{constructor(t){super(t),this.current=[0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]||(this.current=r,this.gl.uniform3f(this.location,r[0],r[1],r[2])));}}class To extends So{constructor(t){super(t),this.current=[0,0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]&&r[3]===this.current[3]||(this.current=r,this.gl.uniform4f(this.location,r[0],r[1],r[2],r[3])));}}class Bo extends So{constructor(t){super(t),this.current=Se.transparent.toRenderColor(null);}set(t,e,r){this.fetchUniformLocation(t,e)&&(r.r===this.current.r&&r.g===this.current.g&&r.b===this.current.b&&r.a===this.current.a||(this.current=r,this.gl.uniform4f(this.location,r.r,r.g,r.b,r.a)));}}const Vo=new Float32Array(16);class Co extends So{constructor(t){super(t),this.current=Vo;}set(t,e,r){if(this.fetchUniformLocation(t,e)){if(r[12]!==this.current[12]||r[0]!==this.current[0])return this.current=r,void this.gl.uniformMatrix4fv(this.location,!1,r);for(let t=1;t<16;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix4fv(this.location,!1,r);break}}}}const Do=new Float32Array(9),Ro=new Float32Array(4);class Lo extends So{constructor(t){super(t),this.current=Ro;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<4;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix2fv(this.location,!1,r);break}}}function Fo(t){return [vo(255*t.r,255*t.g),vo(255*t.b,255*t.a)]}class Oo{constructor(t,e,r,n){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r,this.context=n;}setUniform(t,e,r,n,i){const s=n.constantOr(this.value);e.set(t,i,s instanceof Se?s.toRenderColor(this.lutExpression&&"none"===this.lutExpression.value?null:this.context.lut):s);}getBinding(t,e){return "color"===this.type?new Bo(t):new Eo(t)}}class No{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.pattern=null,this.pixelRatio=1;}setConstantPatternPositions(t){this.pixelRatio=t.pixelRatio||1,this.pattern=t.tl.concat(t.br);}setUniform(t,e,r,n,i){const s="u_pattern"===i||"u_dash"===i?this.pattern:"u_pixel_ratio"===i?this.pixelRatio:null;s&&e.set(t,i,s);}getBinding(t,e){return "u_pattern"===e||"u_dash"===e?new To(t):new Eo(t)}}class Uo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,s,a){const o=this.paintVertexArray.length,l="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate(new Rs(0,{brightness:s}),e,{},i,n,a):"constant"===this.expression.kind&&this.expression.value,u=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new Rs(0,{brightness:s}),e,{},i,n,a):this.lutExpression.value);this.paintVertexArray.resize(t),this._setPaintValue(o,t,l,u?null:this.context.lut);}updatePaintArray(t,e,r,n,i,s,a){const o="composite"===this.expression.kind||"source"===this.expression.kind?this.expression.evaluate({zoom:0,brightness:a},r,n,void 0,i):"constant"===this.expression.kind&&this.expression.value,l=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new Rs(0,{brightness:a}),r,n,void 0,i):this.lutExpression.value);this._setPaintValue(t,e,o,l?null:this.context.lut);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Fo(r.toRenderColor(n));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.lutExpression&&"constant"!==this.lutExpression.kind&&(this.lutExpression.isStateDependent||!this.lutExpression.isLightConstant)||"constant"!==this.expression.kind&&(this.expression.isStateDependent||!this.expression.isLightConstant)));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class jo{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.context=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i,s,a){const o=this.expression.evaluate(new Rs(this.context.zoom,{brightness:s}),e,{},i,n,a),l=this.expression.evaluate(new Rs(this.context.zoom+1,{brightness:s}),e,{},i,n,a),u=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new Rs(0,{brightness:s}),e,{},i,n,a):this.lutExpression.value),c=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(c,t,o,l,u?null:this.context.lut);}updatePaintArray(t,e,r,n,i,s,a){const o=this.expression.evaluate({zoom:this.context.zoom,brightness:a},r,n,void 0,i),l=this.expression.evaluate({zoom:this.context.zoom+1,brightness:a},r,n,void 0,i),u=!!this.lutExpression&&"none"===("composite"===this.lutExpression.kind||"source"===this.lutExpression.kind?this.lutExpression.evaluate(new Rs(0,{brightness:a}),r,n,void 0,i):this.lutExpression.value);this._setPaintValue(t,e,o,l,u?null:this.context.lut);}_setPaintValue(t,e,r,n,i){if("color"===this.type){const n=Fo(r.toRenderColor(i)),s=Fo(r.toRenderColor(i));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e,r,n,i){const s=this.useIntegerZoom?Math.floor(r.zoom):r.zoom,a=Q(this.expression.interpolationFactor(s,this.context.zoom,this.context.zoom+1),0,1);e.set(t,i,a);}getBinding(t,e){return new Eo(t)}}class qo{constructor(t,e,r,n,i){this.expression=t,this.layerId=i,this.paintVertexAttributes=("array"===r?_o:bo).members;for(let t=0;t<e.length;++t);this.paintVertexArray=new n;}populatePaintArray(t,e,r,n){const i=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValues(i,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,s,a){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],s);}_setPaintValues(t,e,r,n){if(!n||!r)return;const i=n[r];if(!i)return;const{tl:s,br:a,pixelRatio:o}=i;for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,s[0],s[1],a[0],a[1],o);}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class $o{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[],this.context=e;const n=[];for(const i in t.paint._values){const s=t.paint.get(i);if(i.endsWith("-use-theme"))continue;if(!r(i))continue;if(!(s instanceof qs&&Fi(s.property.specification)))continue;const a=Ho(i,t.type),o=s.value,l=s.property.specification.type,u=!!s.property.useIntegerZoom,c="line-dasharray"===i||i.endsWith("pattern"),h=t.paint.get(`${i}-use-theme`),p="line-dasharray"===i&&"constant"!==t.layout.get("line-cap").value.kind||h&&"constant"!==h.value.kind;if("constant"!==o.kind||p)if("source"===o.kind||p||c){const e=Wo(i,l,"source");this.binders[i]=c?new qo(o,a,l,e,t.id):new Uo(o,a,l,e),n.push(`/a_${i}`);}else {const t=Wo(i,l,"composite");this.binders[i]=new jo(o,a,l,u,e,t),n.push(`/z_${i}`);}else this.binders[i]=c?new No(o.value,a):new Oo(o.value,a,l,e),n.push(`/u_${i}`);h&&(this.binders[i].lutExpression=h.value);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Uo||e instanceof jo?e.maxValue:0}populatePaintArrays(t,e,r,n,i,s,a){for(const o in this.binders){const l=this.binders[o];l.context=this.context,(l instanceof Uo||l instanceof jo||l instanceof qo)&&l.populatePaintArray(t,e,r,n,i,s,a);}}setConstantPatternPositions(t){for(const e in this.binders){const r=this.binders[e];r instanceof No&&r.setConstantPatternPositions(t);}}updatePaintArrays(t,e,r,n,i,s,a,o,l){let u=!1;const c=Object.keys(t),h=0!==c.length&&!o,p=h?c:e.uniqueIds;this.context.lut=i.lut;for(const o in this.binders){const c=this.binders[o];if(c.context=this.context,(c instanceof Uo||c instanceof jo||c instanceof qo)&&c.expression&&c.expression.kind&&"constant"!==c.expression.kind&&(!0===c.expression.isStateDependent||!1===c.expression.isLightConstant)){const f=i.paint.get(o);c.expression=f.value;for(const r of p){const i=t[r.toString()];e.eachPosition(r,((t,e,r)=>{const o=n.feature(t);c.updatePaintArray(e,r,o,i,s,a,l);}));}if(!h)for(const e of r.uniqueIds){const i=t[e.toString()];r.eachPosition(e,((t,e,r)=>{const o=n.feature(t);c.updatePaintArray(e,r,o,i,s,a,l);}));}u=!0;}}return u}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Oo||r instanceof No)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Uo||r instanceof jo||r instanceof qo)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Oo||r instanceof No||r instanceof jo)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t){const e=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof Oo||n instanceof No||n instanceof jo)for(const i of n.uniformNames)e.push({name:i,property:r,binding:n.getBinding(t,i)});}return e}setUniforms(t,e,r,n,i){for(const{name:e,property:s,binding:a}of r)this.binders[s].setUniform(t,a,i,n.get(s),e);}updatePaintBuffers(){this._buffers=[];for(const t in this.binders){const e=this.binders[t];(e instanceof Uo||e instanceof jo||e instanceof qo)&&e.paintVertexBuffer&&this._buffers.push(e.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Uo||r instanceof jo||r instanceof qo)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Uo||e instanceof jo||e instanceof qo)&&e.destroy();}}}class Go{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new $o(n,e,r);this.needsUpload=!1,this._featureMap=new wo,this._featureMapWithoutIds=new wo,this._bufferOffset=0,this._idlessCounter=0;}populatePaintArrays(t,e,r,n,i,s,a,o){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s,a,o);void 0!==e.id?this._featureMap.add(e.id,r,this._bufferOffset,t):(this._featureMapWithoutIds.add(this._idlessCounter,r,this._bufferOffset,t),this._idlessCounter+=1),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i,s,a){for(const o of r)this.needsUpload=this.programConfigurations[o.id].updatePaintArrays(t,this._featureMap,this._featureMapWithoutIds,e,o,n,i,s,a||0)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const Yo={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-occlusion-opacity":["occlusion_opacity"],"icon-occlusion-opacity":["occlusion_opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-emissive-strength":["emissive_strength"],"icon-emissive-strength":["emissive_strength"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"symbol-z-offset":["z_offset"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio"],"fill-pattern":["pattern","pixel_ratio"],"fill-extrusion-pattern":["pattern","pixel_ratio"],"line-dasharray":["dash"]};function Ho(t,e){return Yo[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const Xo={"line-pattern":{source:ka,composite:ka},"fill-pattern":{source:ka,composite:ka},"fill-extrusion-pattern":{source:ka,composite:ka},"line-dasharray":{source:Ta,composite:Ta}},Zo={color:{source:Za,composite:Da},number:{source:Aa,composite:Za}};function Wo(t,e,r){const n=Xo[t];return n&&n[r]||Zo[e][r]}us(Oo,"ConstantBinder"),us(No,"PatternConstantBinder"),us(Uo,"SourceExpressionBinder"),us(qo,"PatternCompositeBinder"),us(jo,"CompositeExpressionBinder"),us($o,"ProgramConfiguration",{omit:["_buffers"]}),us(Go,"ProgramConfigurationSet");const Ko=Kr/Math.PI/2,Jo=5,Qo=6,tl=16383,el=64,rl=[el,32,16],nl=-Ko,il=Ko;function sl(t,e,r,n=Ko){return r=H(r),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function al(t,e,r){return sl(Math.cos(H(t)),Math.sin(H(t)),e,r)}const ol=6371008.8,ll=2*Math.PI*ol;class ul{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new ul(et(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return ol*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new cl({lng:this.lng-r,lat:this.lat-e},{lng:this.lng+r,lat:this.lat+e})}toEcef(t){return al(this.lat,this.lng,Ko+t*Ko/ol)}static convert(t){if(t instanceof ul)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new ul(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new ul(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class cl{constructor(t,e){if(t)if(e)this.setSouthWest(t).setNorthEast(e);else if(4===t.length){const e=t;this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]);}else {const e=t;this.setSouthWest(e[0]).setNorthEast(e[1]);}}setNorthEast(t){return this._ne=t instanceof ul?new ul(t.lng,t.lat):ul.convert(t),this}setSouthWest(t){return this._sw=t instanceof ul?new ul(t.lng,t.lat):ul.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof ul)n=t,i=t;else {if(!(t instanceof cl))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(cl.convert(t)):this.extend(ul.convert(t)):"object"==typeof t&&null!==t&&t.hasOwnProperty("lat")&&(t.hasOwnProperty("lon")||t.hasOwnProperty("lng"))?this.extend(ul.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new ul(n.lng,n.lat),this._ne=new ul(i.lng,i.lat)),this}getCenter(){return new ul((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new ul(this.getWest(),this.getNorth())}getSouthEast(){return new ul(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=ul.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){if(t)return t instanceof cl?t:new cl(t)}}const hl=0,pl=25.5;function fl(t){return ll*Math.cos(t*Math.PI/180)}function dl(t){return (180+t)/360}function ml(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function yl(t,e){return t/fl(e)}function gl(t){return 360*t-180}function xl(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function vl(t,e){return t*fl(xl(e))}const bl=85.051129;function _l(t){return Math.cos(H(Q(t,-bl,bl)))}function wl(t,e){const r=Q(e,hl,pl),n=Math.pow(2,r);return _l(t)*ll/(512*n)}function Ml(t){return 1/Math.cos(t*Math.PI/180)}function Al(t,e=0){const r=Math.exp(Math.PI*(1-(t.y+e/Kr)/(1<<t.z)*2));return 80150034*r/(r*r+1)/Kr/(1<<t.z)}class Il{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=ul.convert(t);return new Il(dl(r.lng),ml(r.lat),yl(e,r.lat))}toLngLat(){return new ul(gl(this.x),xl(this.y))}toAltitude(){return vl(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/ll*Ml(xl(this.y))}}function Sl(t,e,r,n,i,s,a,o,l){const u=(e+n)/2,c=(r+i)/2,h=new q(u,c);o(h),function(t,e,r,n,i,s){const a=r-i,o=n-s;return Math.abs((n-e)*a-(r-t)*o)/Math.hypot(a,o)}(h.x,h.y,s.x,s.y,a.x,a.y)>=l?(Sl(t,e,r,u,c,s,h,o,l),Sl(t,u,c,n,i,h,a,o,l)):t.push(a);}function Pl(t,e,r){let n=t[0],i=n.x,s=n.y;e(n);const a=[n];for(let o=1;o<t.length;o++){const l=t[o],{x:u,y:c}=l;e(l),Sl(a,i,s,u,c,n,l,e,r),i=u,s=c,n=l;}return a}function El(t,e,r,n){if(n(e,r)){const i=e.add(r)._mult(.5);El(t,e,i,n),El(t,i,r,n);}else t.push(r);}function zl(t,e){let r=t[0];const n=[r];for(let i=1;i<t.length;i++){const s=t[i];El(n,r,s,e),r=s;}return n}const kl=Math.pow(2,14)-1,Tl=-kl-1;function Bl(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=Q(r,Tl,kl),t.y=Q(n,Tl,kl),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&pt("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function Vl(t,e,r){const n=t.loadGeometry(),i=t.extent,s=Kr/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const s=1<<e.z,{scale:a,x:o,y:l,projection:u}=r,c=t=>{const r=gl((e.x+t.x/i)/s),n=xl((e.y+t.y/i)/s),c=u.project(r,n);t.x=(c.x*a-o)*i,t.y=(c.y*a-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=Pl(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)Bl(e,s);return n}function Cl(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Vl(t):[]}}function Dl(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}function Rl(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class Ll{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.projection=t.projection,this.layoutVertexArray=new _a,this.indexArray=new ja,this.segments=new xo,this.programConfigurations=new Go(t.layers,{zoom:t.zoom,lut:t.lut}),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}updateFootprints(t,e){}populate(t,e,r,n){const i=this.layers[0],s=[];let a=null;"circle"===i.type&&(a=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Cl(e,t);if(!this.layers[0]._featureFilter.filter(new Rs(this.zoom),u,r))continue;const c=a?a.evaluate(u,{},r):void 0,h={id:i,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Vl(e,r,n),patterns:{},sortKey:c};s.push(h);}a&&s.sort(((t,e)=>t.sortKey-e.sortKey));let o=null;"globe"===n.projection.name&&(this.globeExtVertexArray=new Ba,o=n.projection);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n,l=t[s].feature;this.addFeature(n,i,s,e.availableImages,r,o,e.brightness),e.featureIndex.insert(l,i,s,a,this.index);}}update(t,e,r,n,i,s,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,a);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,yo.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,go.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy());}addFeature(t,e,r,n,i,s,a){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=Kr||n<0||n>=Kr)continue;if(s){const t=s.projectTilePoint(r,n,i),e=s.upVector(i,r,n),a=this.globeExtVertexArray;Rl(a,t,e),Rl(a,t,e),Rl(a,t,e),Rl(a,t,e);}const a=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),o=a.vertexLength;Dl(this.layoutVertexArray,r,n,-1,-1),Dl(this.layoutVertexArray,r,n,1,-1),Dl(this.layoutVertexArray,r,n,1,1),Dl(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(o,o+1,o+2),this.indexArray.emplaceBack(o,o+2,o+3),a.vertexLength+=4,a.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i,a);}}function Fl(t,e){for(let r=0;r<t.length;r++)if(Hl(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Hl(t,e[r]))return !0;return !!jl(t,e)}function Ol(t,e,r){return !!Hl(t,e)||!!$l(e,t,r)}function Nl(t,e){if(1===t.length)return Yl(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Hl(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(Yl(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(jl(t,e[r]))return !0;return !1}function Ul(t,e,r){if(t.length>1){if(jl(t,e))return !0;for(let n=0;n<e.length;n++)if($l(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if($l(t[n],e,r))return !0;return !1}function jl(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(ql(n,i,e[t],e[t+1]))return !0}return !1}function ql(t,e,r,n){return ft(t,r,n)!==ft(e,r,n)&&ft(t,e,r)!==ft(t,e,n)}function $l(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Gl(t,e[r-1],e[r])<n)return !0;return !1}function Gl(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function Yl(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function Hl(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function Xl(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const s=[new q(e,r),new q(e,i),new q(n,i),new q(n,r)];if(t.length>2)for(const e of s)if(Hl(t,e))return !0;for(let e=0;e<t.length-1;e++)if(Zl(t[e],t[e+1],s))return !0;return !1}function Zl(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=ft(t,e,r[0]);return s!==ft(t,e,r[1])||s!==ft(t,e,r[2])||s!==ft(t,e,r[3])}function Wl(t,e,r,n,i,s){let a=e.y-t.y,o=t.x-e.x;if(s=s||0){const t=a*a+o*o;if(0===t)return !0;const e=Math.sqrt(t);a/=e,o/=e;}return !((r.x-t.x)*a+(r.y-t.y)*o-s<0||(n.x-t.x)*a+(n.y-t.y)*o-s<0||(i.x-t.x)*a+(i.y-t.y)*o-s<0)}function Kl(t,e,r,n,i,s,a){return !(Wl(t,e,n,i,s,a)||Wl(e,r,n,i,s,a)||Wl(r,t,n,i,s,a)||Wl(n,i,t,e,r,a)||Wl(i,s,t,e,r,a)||Wl(s,n,t,e,r,a))}function Jl(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function Ql(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function tu(t,e,r,n,i){if(!e[0]&&!e[1])return t;const s=q.convert(e)._mult(i);"viewport"===r&&s._rotate(-n);const a=[];for(let e=0;e<t.length;e++)a.push(t[e].sub(s));return a}function eu(t,e,r,n){const i=q.convert(t)._mult(n);return "viewport"===e&&i._rotate(-r),i}let ru,nu;us(Ll,"CircleBucket",{omit:["layers"]});var iu,su={exports:{}},au=(iu||(iu=1,function(t,e){!function(t){function e(t,e,n){var i=r(256*t,256*(e=Math.pow(2,n)-e-1),n),s=r(256*(t+1),256*(e+1),n);return i[0]+","+i[1]+","+s[0]+","+s[1]}function r(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}t.getURL=function(t,r,n,i,s,a){return a=a||{},t+"?"+["bbox="+e(n,i,s),"format="+(a.format||"image/png"),"service="+(a.service||"WMS"),"version="+(a.version||"1.1.1"),"request="+(a.request||"GetMap"),"srs="+(a.srs||"EPSG:3857"),"width="+(a.width||256),"height="+(a.height||256),"layers="+r].join("&")},t.getTileBBox=e,t.getMercCoords=r,Object.defineProperty(t,"__esModule",{value:!0});}(e);}(0,su.exports)),su.exports);class ou{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=cu(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=au.getTileBBox(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class lu{constructor(t,e){this.wrap=t,this.canonical=e,this.key=cu(t,e.z,e.z,e.x,e.y);}}class uu{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new ou(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:cu(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new uu(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new uu(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return cu(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return cu(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.z<this.canonical.z&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new uu(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new uu(e,this.wrap,e,r,n),new uu(e,this.wrap,e,r+1,n),new uu(e,this.wrap,e,r,n+1),new uu(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new uu(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new uu(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new lu(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function cu(t,e,r,n,i){const s=1<<Math.min(r,22);let a=s*(i%s)+n%s;return t&&r<22&&(a+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*a+r)+(e-r)}const hu=[t=>{let e=t.canonical.x-1,r=t.wrap;return e<0&&(e=(1<<t.canonical.z)-1,r--),new uu(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>{let e=t.canonical.x+1,r=t.wrap;return e===1<<t.canonical.z&&(e=0,r++),new uu(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>new uu(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new uu(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)];us(ou,"CanonicalTileID"),us(uu,"OverscaledTileID",{omit:["projMatrix","expandedProjMatrix"]});const pu=va([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:fu}=pu,du=va([{name:"a_pos_3",components:3,type:"Int16"}]);var mu=va([{name:"a_pos",type:"Int16",components:2}]);class yu{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=O.vec2.dot(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,!0}}class gu{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=O.vec3.dot(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1]+(t[2]-this.pos[2])*e[2])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,r[2]=this.pos[2]+this.dir[2]*i,!0}closestPointOnSphere(t,e,r){if(O.vec3.equals(this.pos,t)||0===e)return r[0]=r[1]=r[2]=0,!1;const[n,i,s]=this.dir,a=this.pos[0]-t[0],o=this.pos[1]-t[1],l=this.pos[2]-t[2],u=n*n+i*i+s*s,c=2*(a*n+o*i+l*s),h=c*c-4*u*(a*a+o*o+l*l-e*e);if(h<0){const t=Math.max(-c/2,0),u=a+n*t,h=o+i*t,p=l+s*t,f=Math.hypot(u,h,p);return r[0]=u*e/f,r[1]=h*e/f,r[2]=p*e/f,!1}{const t=(-c-Math.sqrt(h))/(2*u);if(t<0){const t=Math.hypot(a,o,l);return r[0]=a*e/t,r[1]=o*e/t,r[2]=l*e/t,!1}return r[0]=a+n*t,r[1]=o+i*t,r[2]=l+s*t,!0}}}class xu{constructor(t,e,r,n,i){this.TL=t,this.TR=e,this.BR=r,this.BL=n,this.horizon=i;}static fromInvProjectionMatrix(t,e,r){const n=[-1,1,1],i=[1,1,1],s=[1,-1,1],a=[-1,-1,1],o=O.vec3.transformMat4(n,n,t),l=O.vec3.transformMat4(i,i,t),u=O.vec3.transformMat4(s,s,t),c=O.vec3.transformMat4(a,a,t);return new xu(o,l,u,c,e/r)}}function vu(t,e,r){let n=1/0,i=-1/0;const s=[];for(const a of t){O.vec3.sub(s,a,e);const t=O.vec3.dot(s,r);n=Math.min(n,t),i=Math.max(i,t);}return [n,i]}function bu(t,e){let r=!0;for(let n=0;n<t.planes.length;n++){const i=t.planes[n];let s=0;for(let t=0;t<e.length;t++)s+=O.vec3.dot(i,e[t])+i[3]>=0;if(0===s)return 0;s!==e.length&&(r=!1);}return r?2:1}function _u(t,e){for(const r of t.projections){const n=vu(e,t.points[0],r.axis);if(r.projection[1]<n[0]||r.projection[0]>n[1])return 0}return 1}function wu(t,e){let r=0;const n=[0,0,0,0];for(let i=0;i<t.length;i++)n[0]=t[i][0],n[1]=t[i][1],n[2]=t[i][2],n[3]=1,O.vec4.dot(n,e)>=0&&r++;return r}class Mu{constructor(t,e){this.points=t||new Array(8).fill([0,0,0]),this.planes=e||new Array(6).fill([0,0,0,0]),this.bounds=Au.fromPoints(this.points),this.projections=[],this.frustumEdges=[O.vec3.sub([],this.points[2],this.points[3]),O.vec3.sub([],this.points[0],this.points[3]),O.vec3.sub([],this.points[4],this.points[0]),O.vec3.sub([],this.points[5],this.points[1]),O.vec3.sub([],this.points[6],this.points[2]),O.vec3.sub([],this.points[7],this.points[3])];for(const t of this.frustumEdges){const e=[0,-t[2],t[1]],r=[t[2],0,-t[0]];this.projections.push({axis:e,projection:vu(this.points,this.points[0],e)}),this.projections.push({axis:r,projection:vu(this.points,this.points[0],r)});}}static fromInvProjectionMatrix(t,e,r,n){const i=Math.pow(2,r),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((r=>{const s=O.vec4.transformMat4([],r,t),a=1/s[3]/e*i;return O.vec4.mul(s,s,[a,a,n?1/s[3]:a,a])})),a=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=O.vec3.sub([],s[t[0]],s[t[1]]),r=O.vec3.sub([],s[t[2]],s[t[1]]),n=O.vec3.normalize([],O.vec3.cross([],e,r)),i=-O.vec3.dot(n,s[t[1]]);return n.concat(i)})),o=[];for(let t=0;t<s.length;t++)o.push([s[t][0],s[t][1],s[t][2]]);return new Mu(o,a)}intersectsPrecise(t,e,r){for(let r=0;r<e.length;r++)if(!wu(t,e[r]))return 0;for(let e=0;e<this.planes.length;e++)if(!wu(t,this.planes[e]))return 0;for(const e of r)for(const r of this.frustumEdges){const n=O.vec3.cross([],e,r),i=O.vec3.length(n);if(0===i)continue;O.vec3.scale(n,n,1/i);const s=vu(this.points,this.points[0],n),a=vu(t,this.points[0],n);if(s[0]>a[1]||a[0]>s[1])return 0}return 1}containsPoint(t){for(const e of this.planes){const r=e[3];if(O.vec3.dot([e[0],e[1],e[2]],t)+r<0)return !1}return !0}}class Au{static fromPoints(t){const e=[1/0,1/0,1/0],r=[-1/0,-1/0,-1/0];for(const n of t)O.vec3.min(e,e,n),O.vec3.max(r,r,n);return new Au(e,r)}static fromTileIdAndHeight(t,e,r){const n=1<<t.canonical.z,i=t.canonical.x,s=t.canonical.y;return new Au([i/n,s/n,e],[(i+1)/n,(s+1)/n,r])}static applyTransform(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)O.vec3.transformMat4(r[t],r[t],e);return Au.fromPoints(r)}static applyTransformFast(t,e){const r=[e[12],e[13],e[14]],n=[...r];for(let i=0;i<3;i++)for(let s=0;s<3;s++){const a=e[4*s+i],o=a*t.min[s],l=a*t.max[s];r[i]+=Math.min(o,l),n[i]+=Math.max(o,l);}return new Au(r,n)}static projectAabbCorners(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)O.vec3.transformMat4(r[t],r[t],e);return r}constructor(t,e){this.min=t,this.max=e,this.center=O.vec3.scale([],O.vec3.add([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=O.vec3.clone(this.min),n=O.vec3.clone(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],n[t]=e[t]?this.center[t]:this.max[t];return n[2]=this.max[2],new Au(r,n)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){return this.intersectsAabb(t.bounds)?bu(t,this.getCorners()):0}intersectsFlat(t){return this.intersectsAabb(t.bounds)?bu(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsPrecise(t,e){return e||this.intersects(t)?_u(t,this.getCorners()):0}intersectsPreciseFlat(t,e){return e||this.intersectsFlat(t)?_u(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsAabb(t){for(let e=0;e<3;++e)if(this.min[e]>t.max[e]||t.min[e]>this.max[e])return !1;return !0}intersectsAabbXY(t){return !(this.min[0]>t.max[0]||t.min[0]>this.max[0]||this.min[1]>t.max[1]||t.min[1]>this.max[1])}encapsulate(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t.min[e]),this.max[e]=Math.max(this.max[e],t.max[e]);}encapsulatePoint(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t[e]),this.max[e]=Math.max(this.max[e],t[e]);}closestPoint(t){return [Math.max(Math.min(this.max[0],t[0]),this.min[0]),Math.max(Math.min(this.max[1],t[1]),this.min[1]),Math.max(Math.min(this.max[2],t[2]),this.min[2])]}}function Iu(t){return t*Ko/ol}us(Au,"Aabb");const Su=[new Au([nl,nl,nl],[il,il,il]),new Au([nl,nl,nl],[0,0,il]),new Au([0,nl,nl],[il,0,il]),new Au([nl,0,nl],[0,il,il]),new Au([0,0,nl],[il,il,il])];function Pu(t,e,r,n=!0){const i=O.vec3.scale([],t._camera.position,t.worldSize),s=[e,r,1,1];O.vec4.transformMat4(s,s,t.pixelMatrixInverse),O.vec4.scale(s,s,1/s[3]);const a=O.vec3.sub([],s,i),o=O.vec3.normalize([],a),l=t.globeMatrix,u=[l[12],l[13],l[14]],c=O.vec3.sub([],u,i),h=O.vec3.length(c),p=O.vec3.normalize([],c),f=t.worldSize/(2*Math.PI),d=O.vec3.dot(p,o),m=Math.asin(f/h);if(m<Math.acos(d)){if(!n)return null;const t=[],e=[];O.vec3.scale(t,o,h/d),O.vec3.normalize(e,O.vec3.sub(e,t,c)),O.vec3.normalize(o,O.vec3.add(o,c,O.vec3.scale(o,e,Math.tan(m)*h)));}const y=[];new gu(i,o).closestPointOnSphere(u,f,y);const g=O.vec3.normalize([],vt(l,0)),x=O.vec3.normalize([],vt(l,1)),v=O.vec3.normalize([],vt(l,2)),b=O.vec3.dot(g,y),_=O.vec3.dot(x,y),w=O.vec3.dot(v,y),M=X(Math.asin(-_/f));let A=X(Math.atan2(b,w));A=t.center.lng+function(t,e){const r=(e-t+180)%360-180;return r<-180?r+360:r}(t.center.lng,A);const I=dl(A),S=Q(ml(M),0,1);return new Il(I,S)}class Eu{constructor(t,e,r){this.a=O.vec3.sub([],t,r),this.b=O.vec3.sub([],e,r),this.center=r;const n=O.vec3.normalize([],this.a),i=O.vec3.normalize([],this.b);this.angle=Math.acos(O.vec3.dot(n,i));}}function zu(t,e){if(0===t.angle)return null;let r;return r=0===t.a[e]?1/t.angle*.5*Math.PI:1/t.angle*Math.atan(t.b[e]/t.a[e]/Math.sin(t.angle)-1/Math.tan(t.angle)),r<0||r>1?null:function(t,e,r,n){const i=Math.sin(r);return t*(Math.sin((1-n)*r)/i)+e*(Math.sin(n*r)/i)}(t.a[e],t.b[e],t.angle,Q(r,0,1))+t.center[e]}function ku(t){if(t.z<=1)return Su[t.z+2*t.y+t.x];const e=Du(Cu(t));return Au.fromPoints(e)}function Tu(t,e,r){return O.vec3.scale(t,t,1-r),O.vec3.scaleAndAdd(t,t,e,r)}function Bu(t,e,r){for(const n of t)O.vec3.transformMat4(n,n,e),O.vec3.scale(n,n,r);}function Vu(t,e,r,n){const i=e/t.worldSize,s=t.globeMatrix;if(r.z<=1){const t=ku(r).getCorners();return Bu(t,s,i),Au.fromPoints(t)}const a=Cu(r,n),o=Du(a,Ko+Iu(t._tileCoverLift));Bu(o,s,i);const l=Number.MAX_VALUE,u=[-l,-l,-l],c=[l,l,l];if(a.contains(t.center)){for(const t of o)O.vec3.min(c,c,t),O.vec3.max(u,u,t);u[2]=0;const e=t.point,r=[e.x*i,e.y*i,0];return O.vec3.min(c,c,r),O.vec3.max(u,u,r),new Au(c,u)}if(t._tileCoverLift>0){for(const t of o)O.vec3.min(c,c,t),O.vec3.max(u,u,t);return new Au(c,u)}const h=[s[12]*i,s[13]*i,s[14]*i],p=a.getCenter(),f=Q(t.center.lat,-bl,bl),d=Q(p.lat,-bl,bl),m=dl(t.center.lng),y=ml(f);let g=m-dl(p.lng);const x=y-ml(d);g>.5?g-=1:g<-.5&&(g+=1);let v=0;if(Math.abs(g)>Math.abs(x))v=g>=0?1:3;else {v=x>=0?0:2;const t=[s[4]*i,s[5]*i,s[6]*i],e=-Math.sin(H(x>=0?a.getSouth():a.getNorth()))*Ko;O.vec3.scaleAndAdd(h,h,t,e);}const b=o[v],_=o[(v+1)%4],w=new Eu(b,_,h),M=[zu(w,0)||b[0],zu(w,1)||b[1],zu(w,2)||b[2]],A=$u(t.zoom);if(A>0){const n=function({x:t,y:e,z:r},n,i,s,a){const o=1/(1<<r);let l=t*o,u=l+o,c=e*o,h=c+o,p=0;const f=(l+u)/2-s;return f>.5?p=-1:f<-.5&&(p=1),l=((l+p)*n-(s*=n))*i+s,u=((u+p)*n-s)*i+s,c=(c*n-(a*=n))*i+a,h=(h*n-a)*i+a,[[l,h,0],[u,h,0],[u,c,0],[l,c,0]]}(r,e,t._pixelsPerMercatorPixel,m,y);for(let t=0;t<o.length;t++)Tu(o[t],n[t],A);const i=O.vec3.add([],n[v],n[(v+1)%4]);O.vec3.scale(i,i,.5),Tu(M,i,A);}for(const t of o)O.vec3.min(c,c,t),O.vec3.max(u,u,t);return c[2]=Math.min(b[2],_[2]),O.vec3.min(c,c,M),O.vec3.max(u,u,M),new Au(c,u)}function Cu({x:t,y:e,z:r},n=!1){const i=1/(1<<r),s=new ul(gl(t*i),e===(1<<r)-1&&n?-90:xl((e+1)*i)),a=new ul(gl((t+1)*i),0===e&&n?90:xl(e*i));return new cl(s,a)}function Du(t,e=Ko){const r=H(t.getNorth()),n=H(t.getSouth()),i=Math.cos(r),s=Math.cos(n),a=Math.sin(r),o=Math.sin(n),l=t.getWest(),u=t.getEast();return [sl(s,o,l,e),sl(s,o,u,e),sl(i,a,u,e),sl(i,a,l,e)]}function Ru(t,e,r,n){const i=1<<r.z,s=(t/Kr+r.x)/i;return al(xl((e/Kr+r.y)/i),gl(s),n)}function Lu({min:t,max:e}){return tl/Math.max(e[0]-t[0],e[1]-t[1],e[2]-t[2])}const Fu=new Float64Array(16);function Ou(t){const e=Lu(t),r=O.mat4.fromScaling(Fu,[e,e,e]);return O.mat4.translate(r,r,O.vec3.negate([],t.min))}function Nu(t){const e=O.mat4.fromTranslation(Fu,t.min),r=1/Lu(t);return O.mat4.scale(e,e,[r,r,r])}function Uu(t){const e=Kr/(2*Math.PI);return t/(2*Math.PI)/e}function ju(t,e){return Kr/(512*Math.pow(2,t))*Lu(ku(e))}function qu(t,e,r,n,i){const s=Uu(r),a=[t,e,-r/(2*Math.PI)],o=O.mat4.identity(new Float64Array(16));return O.mat4.translate(o,o,a),O.mat4.scale(o,o,[s,s,s]),O.mat4.rotateX(o,o,H(-i)),O.mat4.rotateY(o,o,H(-n)),o}function $u(t){return tt(Jo,Qo,t)}function Gu(t,e){const r=al(e.lat,e.lng),n=function(t){const e=al(t._center.lat,t._center.lng),r=O.vec3.fromValues(0,1,0);let n=O.vec3.cross([],r,e);const i=O.mat4.fromRotation([],-t.angle,e);n=O.vec3.transformMat4(n,n,i),O.mat4.fromRotation(i,-t._pitch,n);const s=O.vec3.normalize([],e);return O.vec3.scale(s,s,Iu(t.cameraToCenterDistance/t.pixelsPerMeter)),O.vec3.transformMat4(s,s,i),O.vec3.add([],e,s)}(t),i=O.vec3.subtract([],n,r);return O.vec3.angle(i,r)}function Yu(t,e){return Gu(t,e)>Math.PI/2*1.01}const Hu=H(85),Xu=Math.cos(Hu),Zu=Math.sin(Hu),Wu=O.mat4.create(),Ku=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e};function Ju(t,e,r,n,i,s,a,o,l){if(s&&t.queryGeometry.isAboveHorizon)return !1;s&&(l*=t.pixelToTileUnitsFactor);const u=t.tileID.canonical,c=r.projection.upVectorScale(u,r.center.lat,r.worldSize).metersToTile;for(const h of e)for(const e of h){const h=e.add(o),p=i&&r.elevation?r.elevation.exaggeration()*i.getElevationAt(h.x,h.y,!0):0,f=r.projection.projectTilePoint(h.x,h.y,u);if(p>0){const t=r.projection.upVector(u,h.x,h.y);f.x+=t[0]*c*p,f.y+=t[1]*c*p,f.z+=t[2]*c*p;}const d=s?h:Qu(f.x,f.y,f.z,n),m=s?t.tilespaceRays.map((t=>rc(t,p))):t.queryGeometry.screenGeometry,y=O.vec4.transformMat4([],[f.x,f.y,f.z,1],n);if(!a&&s?l*=y[3]/r.cameraToCenterDistance:a&&!s&&(l*=r.cameraToCenterDistance/y[3]),s){const t=xl((e.y/Kr+u.y)/(1<<u.z));l/=r.projection.pixelsPerMeter(t,1)/yl(1,t);}if(Ol(m,d,l))return !0}return !1}function Qu(t,e,r,n){const i=O.vec4.transformMat4([],[t,e,r,1],n);return new q(i[0]/i[3],i[1]/i[3])}const tc=O.vec3.fromValues(0,0,0),ec=O.vec3.fromValues(0,0,1);function rc(t,e){const r=O.vec3.create();return tc[2]=e,t.intersectsPlane(tc,ec,r),new q(r[0],r[1])}class nc extends Ll{}let ic,sc,ac,oc;function lc(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function uc(t,e,r){const{width:n,height:i}=e;n===t.width&&i===t.height||(cc(t,e,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,n),height:Math.min(t.height,i)},r,null),t.width=n,t.height=i,t.data=e.data);}function cc(t,e,r,n,i,s,a,o){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const l=t.data,u=e.data,c=4===s&&o;for(let o=0;o<i.height;o++){const h=((r.y+o)*t.width+r.x)*s,p=((n.y+o)*e.width+n.x)*s;if(c)for(let t=0;t<i.width;t++){const e=h+t*s+3,r=p+t*s;u[r+0]=255,u[r+1]=255,u[r+2]=255,u[r+3]=l[e];}else if(a)for(let t=0;t<i.width;t++){const e=h+t*s,r=p+t*s,n=l[e+3],i=new Se(l[e+0]/255*n,l[e+1]/255*n,l[e+2]/255*n,n).toRenderColor(a).toArray();u[r+0]=i[0],u[r+1]=i[1],u[r+2]=i[2],u[r+3]=i[3];}else for(let t=0;t<i.width*s;t++)u[p+t]=l[h+t];}return e}us(nc,"HeatmapBucket",{omit:["layers"]});class hc{constructor(t,e){lc(this,t,1,e);}resize(t){uc(this,new hc(t),1);}clone(){return new hc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){cc(t,e,r,n,i,1,null);}}class pc{constructor(t,e){lc(this,t,4,e);}resize(t){uc(this,new pc(t),4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new pc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i,s,a){cc(t,e,r,n,i,4,s,a);}}class fc{constructor(t,e){this.width=t.width,this.height=t.height,this.data=e instanceof Uint8Array?new Float32Array(e.buffer):e;}}function dc(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new pc({width:r,height:n}),s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);a&&(i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a));};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}us(hc,"AlphaImage"),us(pc,"RGBAImage");const mc=va([{name:"a_pos",components:2,type:"Int16"}],4),yc=va([{name:"a_road_z_offset",components:1,type:"Float32"}],4),gc=va([{name:"a_pos",components:2,type:"Int16"},{name:"a_height",components:1,type:"Float32"}],4),xc=va([{name:"a_pos_normal_3",components:3,type:"Int16"}],4);function vc(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=bc(t,0,i,r,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const a=bc(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),i.push(Tc(a));}i.sort(Pc);for(let t=0;t<i.length;t++)r=Ec(i[t],r);return r}(t,e,s,r)),t.length>80*r){o=1/0,l=1/0;let e=-1/0,n=-1/0;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return wc(s,a,r,o,l,u,0),a}function bc(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=Uc(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=Uc(i/n|0,t[i],t[i+1],s);return s&&Dc(s,s.next)&&(jc(s),s=s.next),s}function _c(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Dc(n,n.next)&&0!==Cc(n.prev,n,n.next))n=n.next;else {if(jc(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function wc(t,e,r,n,i,s,a){if(!t)return;!a&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=kc(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let a=i,o=0;for(let t=0;t<r&&(o++,a=a.nextZ,a);t++);let l=r;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||i.z<=a.z)?(n=i,i=i.nextZ,o--):(n=a,a=a.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=a;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?Ac(t,n,i,s):Mc(t))e.push(l.i,t.i,u.i),jc(t),t=u.next,o=u.next;else if((t=u)===o){a?1===a?wc(t=Ic(_c(t),e),e,r,n,i,s,2):2===a&&Sc(t,e,r,n,i,s):wc(_c(t),e,r,n,i,s,1);break}}}function Mc(t){const e=t.prev,r=t,n=t.next;if(Cc(e,r,n)>=0)return !1;const i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=i<s?i<a?i:a:s<a?s:a,h=o<l?o<u?o:u:l<u?l:u,p=i>s?i>a?i:a:s>a?s:a,f=o>l?o>u?o:u:l>u?l:u;let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Bc(i,o,s,l,a,u,d.x,d.y)&&Cc(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function Ac(t,e,r,n){const i=t.prev,s=t,a=t.next;if(Cc(i,s,a)>=0)return !1;const o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,m=o>l?o>u?o:u:l>u?l:u,y=c>h?c>p?c:p:h>p?h:p,g=kc(f,d,e,r,n),x=kc(m,y,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==a&&Bc(o,c,l,h,u,p,v.x,v.y)&&Cc(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==a&&Bc(o,c,l,h,u,p,b.x,b.y)&&Cc(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==a&&Bc(o,c,l,h,u,p,v.x,v.y)&&Cc(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==a&&Bc(o,c,l,h,u,p,b.x,b.y)&&Cc(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Ic(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Dc(n,i)&&Rc(n,r,r.next,i)&&Oc(n,i)&&Oc(i,n)&&(e.push(n.i,r.i,i.i),jc(r),jc(r.next),r=t=i),r=r.next;}while(r!==t);return _c(r)}function Sc(t,e,r,n,i,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&Vc(a,t)){let o=Nc(a,t);return a=_c(a,a.next),o=_c(o,o.next),wc(a,e,r,n,i,s,0),void wc(o,e,r,n,i,s,0)}t=t.next;}a=a.next;}while(a!==t)}function Pc(t,e){return t.x-e.x}function Ec(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,a=-1/0;do{if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const o=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Bc(i<u?n:a,i,l,u,i<u?a:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);Oc(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&zc(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==o);return s}(t,e);if(!r)return e;const n=Nc(r,t);return _c(n,n.next),_c(r,r.next)}function zc(t,e){return Cc(t.prev,t,e.prev)<0&&Cc(e.next,t,t.next)<0}function kc(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Tc(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function Bc(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function Vc(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Rc(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Oc(t,e)&&Oc(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Cc(t.prev,t,e.prev)||Cc(t,e.prev,e))||Dc(t,e)&&Cc(t.prev,t,t.next)>0&&Cc(e.prev,e,e.next)>0)}function Cc(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Dc(t,e){return t.x===e.x&&t.y===e.y}function Rc(t,e,r,n){const i=Fc(Cc(t,e,r)),s=Fc(Cc(t,e,n)),a=Fc(Cc(r,n,t)),o=Fc(Cc(r,n,e));return i!==s&&a!==o||!(0!==i||!Lc(t,r,e))||!(0!==s||!Lc(t,n,e))||!(0!==a||!Lc(r,t,n))||!(0!==o||!Lc(r,e,n))}function Lc(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Fc(t){return t>0?1:t<0?-1:0}function Oc(t,e){return Cc(t.prev,t,t.next)<0?Cc(t,e,t.next)>=0&&Cc(t,t.prev,e)>=0:Cc(t,e,t.prev)<0||Cc(t,t.next,e)<0}function Nc(t,e){const r=qc(t.i,t.x,t.y),n=qc(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function Uc(t,e,r,n){const i=qc(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function jc(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function qc(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function $c(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=dt(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(br(n[t],e,1,n[t].length-1,Gc),n[t]=n[t].slice(0,e));return n}function Gc(t,e){return e.area-t.area}function Yc(t,e,r=1){if(!t)return null;const n="string"==typeof t?er.from(t).getPrimary():t.getPrimary(),i=n.id.toString();return e.has(i)||e.set(i,[]),n.scaleSelf(r),e.get(i).push(n),n.toString()}function Hc(t,e,r,n){const i=n.patternDependencies;let s=!1;for(const n of e){const e=n.paint.get(`${t}-pattern`);e.isConstant()||(s=!0),Yc(e.constantOr(null),i,r)&&(s=!0);}return s}function Xc(t,e,r,n,i,s){const a=s.patternDependencies;for(const o of e){const e=o.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n},r,{},s.availableImages);t=t&&t.name?t.name:t;const l=Yc(t,a,i);l&&(r.patterns[o.id]=l);}}return r}var Zc,Wc,Kc,Jc,Qc,th,eh,rh={};function nh(){if(Wc)return Zc;Wc=1;var t=j();function e(t,e,n,i,s){this.properties={},this.extent=n,this.type=0,this._pbf=t,this._geometry=-1,this._keys=i,this._values=s,t.readFields(r,this,e);}function r(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function n(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}return Zc=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var r,n=e.readVarint()+e.pos,i=1,s=0,a=0,o=0,l=[];e.pos<n;){if(s<=0){var u=e.readVarint();i=7&u,s=u>>3;}if(s--,1===i||2===i)a+=e.readSVarint(),o+=e.readSVarint(),1===i&&(r&&l.push(r),r=[]),r.push(new t(a,o));else {if(7!==i)throw new Error("unknown command "+i);r&&r.push(r[0].clone());}}return r&&l.push(r),l},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},e.prototype.toGeoJSON=function(t,r,i){var s,a,o=this.extent*Math.pow(2,i),l=this.extent*t,u=this.extent*r,c=this.loadGeometry(),h=e.types[this.type];function p(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+l)/o-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+u)/o)*Math.PI/180))-90];}}switch(this.type){case 1:var f=[];for(s=0;s<c.length;s++)f[s]=c[s][0];p(c=f);break;case 2:for(s=0;s<c.length;s++)p(c[s]);break;case 3:for(c=function(t){var e=t.length;if(e<=1)return [t];for(var r,i,s=[],a=0;a<e;a++){var o=n(t[a]);0!==o&&(void 0===i&&(i=o<0),i===o<0?(r&&s.push(r),r=[t[a]]):r.push(t[a]));}return r&&s.push(r),s}(c),s=0;s<c.length;s++)for(a=0;a<c[s].length;a++)p(c[s][a]);}1===c.length?c=c[0]:h="Multi"+h;var d={type:"Feature",geometry:{type:h,coordinates:c},properties:this.properties};return "id"in this&&(d.id=this.id),d},Zc}function ih(){if(Jc)return Kc;Jc=1;var t=nh();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(r,this,e),this.length=this._features.length;}function r(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}return Kc=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var r=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,r,this.extent,this._keys,this._values)},Kc}function sh(){return eh||(eh=1,rh.VectorTile=function(){if(th)return Qc;th=1;var t=ih();function e(e,r,n){if(3===e){var i=new t(n,n.readVarint()+n.pos);i.length&&(r[i.name]=i);}}return Qc=function(t,r){this.layers=t.readFields(e,{},r);},Qc}(),rh.VectorTileFeature=nh(),rh.VectorTileLayer=ih()),rh}var ah=sh();const oh="3d_elevation_id",lh="level";class uh{constructor(){this._valid=!1;}reset(t){return this.feature=t,this._valid=!0,this._geometry=t.loadGeometry(),0!==this._geometry.length&&0!==this._geometry[0].length||(this._valid=!1),this}geometry(t,e){return this._valid&&t(e(this._geometry)),this}require(t,e,r){return this.get(t,!0,e,r)}optional(t,e,r){return this.get(t,!1,e,r)}success(){return this._valid}get(t,e,r,n){const i=this.feature.properties.hasOwnProperty(t)?+this.feature.properties[t]:void 0;return this._valid&&void 0!==i?r(n?n(i):i):e&&(this._valid=!1),this}}class ch{constructor(t,e){this.featureFunc=t,this.vertexFunc=e;}parseFeature(t,e,r){return this.featureFunc(t,e,r)}parseVertex(t,e,r){return this.vertexFunc(t,e,r)}}const hh=new ch(((t,e,r)=>t.reset(e).require(oh,(t=>{r.id=t;})).optional("fixed_height_relative",(t=>{r.constantHeight=t;}),fh.decodeRelativeHeight).geometry((t=>{r.bounds=t;}),fh.computeBounds).success()),((t,e,r)=>t.reset(e).require(oh,(t=>{r.id=t;})).require("elevation_idx",(t=>{r.idx=t;})).require("extent",(t=>{r.extent=t;})).require("height_relative",(t=>{r.height=t;}),fh.decodeRelativeHeight).geometry((t=>{r.position=t;}),fh.getPoint).success())),ph=new ch(((t,e,r)=>t.reset(e).require(oh,(t=>{r.id=t;})).optional("fixed_height",(t=>{r.constantHeight=t;}),fh.decodeMetricHeight).geometry((t=>{r.bounds=t;}),fh.computeBounds).success()),((t,e,r)=>t.reset(e).require(oh,(t=>{r.id=t;})).require("elevation_idx",(t=>{r.idx=t;})).require("extent",(t=>{r.extent=t;})).require("height",(t=>{r.height=t;}),fh.decodeMetricHeight).geometry((t=>{r.position=t;}),fh.getPoint).success()));class fh{static computeBounds(t){const e=new q(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY),r=new q(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY);for(const n of t[0])e.x>n.x&&(e.x=n.x),e.y>n.y&&(e.y=n.y),r.x<n.x&&(r.x=n.x),r.y<n.y&&(r.y=n.y);return {min:e,max:r}}static getPoint(t){return O.vec2.fromValues(t[0][0].x,t[0][0].y)}static decodeRelativeHeight(t){return 1e-4*t*5}static decodeMetricHeight(t){return 1e-4*t}static parse(t){const e=[],r=[],n=t.length,i=new uh;for(let a=0;a<n;a++){const n=t.feature(a),o=n.properties.hasOwnProperty("version")?String(n.properties.version):void 0,l=(s=o)?"1.0.1"===s?ph:void 0:hh;if(void 0===l){pt(`Unknown elevation feature version number ${o||"(unknown)"}`);continue}const u=n.properties.hasOwnProperty("type")?n.properties.type:void 0;if(u)if("Point"===ah.VectorTileFeature.types[n.type]&&"curve_point"===u){const t={};l.parseVertex(i,n,t)&&e.push(t);}else if("Polygon"===ah.VectorTileFeature.types[n.type]&&"curve_meta"===u){const t={};l.parseFeature(i,n,t)&&r.push(t);}}var s;return {vertices:e,features:r}}}class dh{constructor(t,e,r,n,i,s){if(this.vertices=new Array,this.vertexProps=new Array,this.edges=new Array,this.edgeProps=new Array,this.id=t,this.heightRange={min:r,max:r},this.safeArea=e,this.constantHeight=r,null==this.constantHeight&&(null!=this.constantHeight||0!==n.length)){this.vertices=n,this.edges=i,this.edges=this.edges.filter((t=>t.a<this.vertices.length&&t.b<this.vertices.length&&!O.vec2.exactEquals(this.vertices[t.a].position,this.vertices[t.b].position))),this.heightRange={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};for(const t of this.vertices)this.vertexProps.push({dir:O.vec2.fromValues(0,0)}),this.heightRange.min=Math.min(this.heightRange.min,t.height),this.heightRange.max=Math.max(this.heightRange.max,t.height);for(const t of this.edges){const e=this.vertices[t.a].position,r=this.vertices[t.b].position,n=O.vec2.subtract(O.vec2.create(),r,e),i=O.vec2.length(n),s=O.vec2.scale(O.vec2.create(),n,1/i);this.edgeProps.push({vec:n,dir:s,len:i});const a=this.vertexProps[t.a].dir,o=this.vertexProps[t.b].dir;O.vec2.add(a,a,s),O.vec2.add(o,o,s);}for(const t of this.vertexProps)0===t.dir[0]&&0===t.dir[1]||O.vec2.normalize(t.dir,t.dir);this.tessellate(s);}}pointElevation(t){if(null!=this.constantHeight)return this.constantHeight;const e=this.getClosestEdge(t);if(null==e)return 0;const[r,n]=e;return ((t,e,r)=>(1-r)*t+r*e)(this.vertices[this.edges[r].a].height,this.vertices[this.edges[r].b].height,n)}getSafeArea(){return this.safeArea}isTunnel(){return this.heightRange.max<=-5}getClosestEdge(t){if(0===this.edges.length)return;let e=0,r=Number.POSITIVE_INFINITY,n=0;const i=O.vec2.fromValues(t.x,t.y);for(let t=0;t<this.edges.length;t++){const s=this.edges[t],a=this.edgeProps[t].dir,o=new yu(i,this.edgeProps[t].dir),l=this.vertices[s.a].position,u=this.vertices[s.b].position,c=O.vec2.create(),h=O.vec2.create(),p=o.intersectsPlane(l,this.vertexProps[s.a].dir,c),f=o.intersectsPlane(u,this.vertexProps[s.b].dir,h);if(!p||!f)continue;const d=O.vec2.subtract(O.vec2.create(),h,c),m=O.vec2.subtract(O.vec2.create(),i,c),y=O.vec2.dot(d,d),g=y>0?O.vec2.dot(m,d)/y:0,x=Q(g,0,1),v=Math.abs((g-x)*this.edgeProps[t].len),b=O.vec2.subtract(O.vec2.create(),i,l),_=v+Math.abs(O.vec2.dot(b,O.vec2.fromValues(a[1],-a[0])));_<r&&(e=t,r=_,n=x);}return [e,n]}tessellate(t){for(let e=this.edges.length-1;e>=0;--e){const r=this.edges[e].a,n=this.edges[e].b,{position:i,height:s,extent:a}=this.vertices[r],{position:o,height:l,extent:u}=this.vertices[n],c=this.vertexProps[r].dir,h=this.vertexProps[n].dir,p=O.vec3.fromValues(i[0]/t,i[1]/t,s),f=O.vec3.fromValues(o[0]/t,o[1]/t,l),d=O.vec3.fromValues(c[1],-c[0],0);O.vec3.scale(d,d,a);const m=O.vec3.fromValues(h[1],-h[0],0);if(O.vec3.scale(m,m,u),this.distSqLines(O.vec3.fromValues(p[0]+.5*d[0],p[1]+.5*d[1],p[2]+.5*d[2]),O.vec3.fromValues(f[0]-.5*m[0],f[1]-.5*m[1],f[2]-.5*m[2]),O.vec3.fromValues(p[0]-.5*d[0],p[1]-.5*d[1],p[2]-.5*d[2]),O.vec3.fromValues(f[0]+.5*m[0],f[1]+.5*m[1],f[2]+.5*m[2]))<=.05*.05)continue;const y=this.vertices.length,g=O.vec2.add(O.vec2.create(),i,o);this.vertices.push({position:O.vec2.scale(g,g,.5),height:.5*(s+l),extent:.5*(a+u)});const x=O.vec2.add(O.vec2.create(),c,h);this.vertexProps.push({dir:O.vec2.normalize(x,x)}),this.edges.splice(e,1),this.edgeProps.splice(e,1),this.edges.push({a:r,b:y}),this.edges.push({a:y,b:n});const v=O.vec2.subtract(O.vec2.create(),this.vertices[y].position,i),b=O.vec2.length(v),_={vec:v,dir:O.vec2.scale(O.vec2.create(),v,1/b),len:b};this.edgeProps.push(_),this.edgeProps.push(_);}}distSqLines(t,e,r,n){const i=O.vec3.subtract(O.vec3.create(),e,t),s=O.vec3.subtract(O.vec3.create(),n,r),a=O.vec3.subtract(O.vec3.create(),t,r),o=O.vec3.dot(i,i),l=O.vec3.dot(i,s),u=O.vec3.dot(i,a),c=O.vec3.dot(s,s),h=O.vec3.dot(s,a),p=o*c-l*l;if(0===p){const e=O.vec3.dot(a,s)/O.vec3.dot(s,s),i=O.vec3.lerp(O.vec3.create(),r,n,e);return O.vec3.squaredDistance(i,t)}const f=(l*h-u*c)/p,d=(o*h-l*u)/p,m=O.vec3.lerp(O.vec3.create(),t,e,f),y=O.vec3.lerp(O.vec3.create(),r,n,d);return O.vec3.squaredDistance(m,y)}}class mh{constructor(t,e){this.zScale=1,this.xOffset=0,this.yOffset=0,t.equals(e)||(this.zScale=Math.pow(2,e.z-t.z),this.xOffset=(t.x*this.zScale-e.x)*Kr,this.yOffset=(t.y*this.zScale-e.y)*Kr);}constantElevation(t,e){if(null!=t.constantHeight)return this.computeBiasedHeight(t.constantHeight,e)}pointElevation(t,e,r){const n=this.constantElevation(e,r);return null!=n?n:(t.x=t.x*this.zScale+this.xOffset,t.y=t.y*this.zScale+this.yOffset,this.computeBiasedHeight(e.pointElevation(t),r))}computeBiasedHeight(t,e){return e<=0?t:t+e*tt(0,e,t>=0?t:Math.abs(.5*t))}}us(dh,"ElevationFeature");class yh{constructor(){this.polygons=new Map;}add(t,...e){this.polygons.has(t)?this.polygons.get(t).push(...e):this.polygons.set(t,e);}merge(t){for(const[e,r]of t.polygons)this.add(e,...r);}}class gh{constructor(){this.portals=[];}static evaluate(t){if(0===t.length)return new gh;let e=[];for(const r of t)e.push(...r.portals);if(0===e.length)return new gh;const r=(t,e)=>t<=0&&e<=0||t>=Kr&&e>=Kr;for(const t of e){const e=t.va,n=t.vb;(r(e.x,n.x)||r(e.y,n.y))&&(t.type="border");}const n=e.filter((t=>"unevaluated"!==t.type)),i=e.filter((t=>"unevaluated"===t.type));if(0===i.length)return new gh;i.sort(((t,e)=>t.hash===e.hash?t.isTunnel===e.isTunnel?0:t.isTunnel?-1:1:t.hash<e.hash?1:-1)),e=n.concat(i);let s=n.length,a=s,o=s;do{if(a++,a===e.length||e[s].hash!==e[a].hash){if(a-s==2){o<s&&(e[o]=e[s],e[s]=null);const t=e[o],r=e[a-1];t.type=t.isTunnel!==r.isTunnel?"tunnel":"polygon",t.connection={a:t.connection.a,b:r.connection.a},o++;}s=a;}}while(s!==e.length);return e.splice(o),e.sort(((t,e)=>t.hash<e.hash?1:-1)),{portals:e}}}us(gh,"ElevationPortalGraph"),us(yh,"ElevationPolygons");class xh{constructor(t,e,r){this.outPositions=t,this.outNormals=e,this.outIndices=r,this.vertexLookup=new Map,this.buffer=new ArrayBuffer(4),this.view=new DataView(this.buffer);}addVertex(t,e,r){let n=t[2];null!=r&&(n*=r);const i=this.getVec3Bits(t)<<96n|this.getVec3Bits(e),s=this.vertexLookup.get(i);if(null!=s)return s;const a=this.outPositions.length;this.vertexLookup.set(i,a);const o=Math.trunc(16384*e[0]),l=Math.trunc(16384*e[1]),u=Math.trunc(16384*e[2]);return this.outPositions.emplaceBack(t[0],t[1],n),this.outNormals.emplaceBack(o,l,u),a}addVertices(t,e,...r){const n=[];for(const i of r){const r=this.addVertex(i,t,e);n.push(r);}return n}addTriangles(t,e,r){if(e&&r){const n=1===r.length,i=O.vec3.fromValues(0,0,0);for(let s=0;s<t.length;s+=3){const a=e[t[s+0]],o=e[t[s+1]],l=e[t[s+2]],u=n?r[0]:r[t[s+1]],c=n?r[0]:r[t[s+2]],h=this.addVertex(O.vec3.fromValues(a.x,a.y,n?r[0]:r[t[s+0]]),i),p=this.addVertex(O.vec3.fromValues(o.x,o.y,u),i),f=this.addVertex(O.vec3.fromValues(l.x,l.y,c),i);this.outIndices.emplaceBack(h,p,f);}}else for(let e=0;e<t.length;e+=3)this.outIndices.emplaceBack(t[e+0],t[e+1],t[e+2]);}addQuad(t,e){const r=this.addVertices(e,void 0,...t.map((t=>O.vec3.fromValues(t.coord.x,t.coord.y,t.height)))),[n,i,s,a]=r;this.addTriangles([n,i,s,s,a,n]);}getBits(t){return this.view.setFloat32(0,t),BigInt(this.view.getUint32(0))}getVec3Bits(t){return this.getBits(t[0])<<64n|this.getBits(t[1])<<32n|this.getBits(t[2])}}class vh{constructor(t){this.unevaluatedPortals=new gh,this.portalPolygons=new yh,this.vertexHashLookup=new Map,this.unevalVertices=[],this.unevalHeights=[],this.unevalTriangles=[],this.unevalTunnelTriangles=[],this.unevalEdges=[],this.vertexPositions=new Ia,this.vertexNormals=new Sa,this.indexArray=new ja,this.tileToMeters=Al(t);}addVertices(t,e){const r=this.unevalVertices.length;for(let r=0;r<t.length;r++)this.unevalVertices.push(t[r]),this.unevalHeights.push(e[r]);return r}addTriangles(t,e,r){const n=r?this.unevalTunnelTriangles:this.unevalTriangles;for(const r of t)n.push(r+e);}addRenderableRing(t,e,r,n,i){const s=[new q(i.min.x,i.min.y),new q(i.max.x,i.min.y),new q(i.max.x,i.max.y),new q(i.min.x,i.max.y)];for(let a=0;a<r-1;a++){const r=e+a,o=r+1,l=this.unevalVertices[r],u=this.unevalVertices[o];if(!(l.x>=i.min.x&&l.x<=i.max.x&&l.y>=i.min.y&&l.y<=i.max.y||u.x>=i.min.x&&u.x<=i.max.x&&u.y>=i.min.y&&u.y<=i.max.y||Zl(l,u,s)))continue;if(this.isOnBorder(l.x,u.x)||this.isOnBorder(l.y,u.y))continue;const c=vh.computeEdgeHash(this.unevalVertices[r],this.unevalVertices[o]);let h,p=this.vertexHashLookup.get(vh.computePosHash(l));null!=p?h=p.next:(p=this.vertexHashLookup.get(vh.computePosHash(u)),h=null!=p?p.prev:c),this.unevalEdges.push({polygonIdx:t,a:r,b:o,hash:c,portalHash:h,isTunnel:n,type:"unevaluated"});}}addPortalCandidates(t,e,r,n,i){if(0===e.length)return;this.portalPolygons.add(t,{geometry:e,zLevel:i});const s=e[0];this.vertexHashLookup.clear();let a=vh.computeEdgeHash(s[s.length-2],s[s.length-1]);for(let e=0;e<s.length-1;e++){const i=s[e+0],o=s[e+1],l=O.vec2.fromValues(o.x-i.x,o.y-i.y),u=O.vec2.length(l);if(0===u)continue;let c="unevaluated";const h=n.pointElevation(i),p=n.pointElevation(o);Math.abs(h)<.01&&Math.abs(p)<.01?c="entrance":(this.isOnBorder(i.x,o.x)||this.isOnBorder(i.y,o.y))&&(c="border");const f=vh.computeEdgeHash(i,o);this.unevaluatedPortals.portals.push({connection:{a:t,b:void 0},va:i,vb:o,vab:l,length:u,hash:f,isTunnel:r,type:c});const d=vh.computePosHash(i);this.vertexHashLookup.set(d,{prev:a,next:f}),a=f;}}construct(t){if(0===this.unevalVertices.length)return;const e=()=>({vertexOffset:0,primitiveOffset:this.indexArray.length}),r=t=>{t.primitiveLength=this.indexArray.length-t.primitiveOffset;},n=new xh(this.vertexPositions,this.vertexNormals,this.indexArray);this.prepareEdges(t.portals,this.unevalEdges);const i=e(),s=e(),a=e(),o=(t,e)=>{t.sort(((t,r)=>t.type===e&&r.type!==e?-1:t.type!==e&&r.type===e?1:0));const r=t.findIndex((t=>t.type!==e));return r>=0?r:t.length};let l=0;this.unevalEdges.length>0&&(l=o(this.unevalEdges,"none"),this.constructBridgeStructures(n,this.unevalVertices,this.unevalHeights,this.unevalEdges,{min:0,max:l},this.tileToMeters));const u=e();if(this.unevalEdges.length>0){const t=this.unevalEdges.splice(l),e=o(t,"tunnel")+l;this.unevalEdges.push(...t),this.constructTunnelStructures(n,this.unevalVertices,this.unevalHeights,this.unevalEdges,{min:0,max:l},{min:l,max:e});}r(a),n.addTriangles(this.unevalTriangles,this.unevalVertices,this.unevalHeights),r(u),n.addTriangles(this.unevalTunnelTriangles,this.unevalVertices,this.unevalHeights),r(s),n.addTriangles(this.unevalTunnelTriangles,this.unevalVertices,[-.1]),r(i),this.maskSegments=xo.simpleSegment(0,u.primitiveOffset,0,u.primitiveLength),this.depthSegments=xo.simpleSegment(0,s.primitiveOffset,0,s.primitiveLength),this.renderableSegments=xo.simpleSegment(0,a.primitiveOffset,0,a.primitiveLength),this.shadowCasterSegments=xo.simpleSegment(0,i.primitiveOffset,0,i.primitiveLength);}upload(t){this.vertexBuffer||0===this.vertexPositions.length||0===this.vertexNormals.length||0===this.indexArray.length||(this.vertexBuffer=t.createVertexBuffer(this.vertexPositions,gc.members),this.vertexBufferNormal=t.createVertexBuffer(this.vertexNormals,xc.members),this.indexBuffer=t.createIndexBuffer(this.indexArray));}destroy(){this.vertexBuffer&&(this.vertexBuffer.destroy(),this.vertexBufferNormal.destroy(),this.indexBuffer.destroy()),this.maskSegments&&(this.maskSegments.destroy(),this.depthSegments.destroy(),this.renderableSegments.destroy(),this.shadowCasterSegments.destroy());}computeVertexConnections(t,e,r,n){const i=new Map;for(let s=r;s<n;s++){const r=e[s],n=r.a,a=r.b;i.has(n)||i.set(n,{}),i.has(a)||i.set(a,{});const o=i.get(n),l=i.get(a);t[a]>0&&(o.to=a),t[n]>0&&(l.from=n);}return i}constructBridgeStructures(t,e,r,n,i,s){const a=this.computeVertexConnections(r,n,i.min,i.max),o=1/s,l=.5*o,u=t=>O.vec3.fromValues(e[t].x,e[t].y,r[t]*o),c=t=>{const e=a.get(t),r=e.from,n=e.to;if(!r||!n)return;const i=u(r),s=u(t),o=u(n),l=O.vec3.fromValues(0,0,0);if(!O.vec3.exactEquals(i,s)){const t=O.vec3.sub(O.vec3.create(),s,i);O.vec3.add(l,l,O.vec3.normalize(t,t));}if(!O.vec3.exactEquals(o,s)){const t=O.vec3.sub(O.vec3.create(),o,s);O.vec3.add(l,l,O.vec3.normalize(t,t));}const c=O.vec3.len(l);return c>0?O.vec3.scale(l,l,1/c):void 0};for(let a=i.min;a<i.max;a++){const i=n[a],u=this.prepareEdgePoints(e,r,i,((t,e)=>t>=e));if(null==u)continue;const h=u[0],p=u[1],f=O.vec3.fromValues(h.coord.x,h.coord.y,o*h.height),d=O.vec3.fromValues(p.coord.x,p.coord.y,o*p.height);if(O.vec3.exactEquals(f,d))continue;const m=O.vec3.sub(O.vec3.create(),d,f);O.vec3.normalize(m,m);const y=t=>O.vec3.normalize(t,t),g=c(i.a)||m,x=c(i.b)||m,v=y(O.vec3.fromValues(g[1],-g[0],0)),b=y(O.vec3.fromValues(x[1],-x[0],0)),_=y(O.vec3.cross(O.vec3.create(),v,g)),w=y(O.vec3.cross(O.vec3.create(),b,x)),M=O.vec3.create(),A=[O.vec3.add(O.vec3.create(),f,O.vec3.scale(M,O.vec3.sub(M,v,_),l)),O.vec3.add(O.vec3.create(),f,O.vec3.scale(M,O.vec3.add(M,v,_),l)),O.vec3.add(O.vec3.create(),f,O.vec3.scale(M,_,l)),f],I=[O.vec3.add(O.vec3.create(),d,O.vec3.scale(M,O.vec3.sub(M,b,w),l)),O.vec3.add(O.vec3.create(),d,O.vec3.scale(M,O.vec3.add(M,b,w),l)),O.vec3.add(O.vec3.create(),d,O.vec3.scale(M,w,l)),d],[S,P]=t.addVertices(v,s,A[0],A[1]),[E,z]=t.addVertices(b,s,I[0],I[1]);t.addTriangles([S,P,E,P,z,E]);const[k,T]=t.addVertices(_,s,A[1],A[2]),[B,V]=t.addVertices(w,s,I[1],I[2]);t.addTriangles([k,T,B,T,V,B]);const[C,D]=t.addVertices(O.vec3.negate(v,v),s,A[2],A[3]),[R,L]=t.addVertices(O.vec3.negate(b,b),s,I[2],I[3]);t.addTriangles([C,D,R,D,L,R]);}}constructTunnelStructures(t,e,r,n,i,s){const a=t=>O.vec3.normalize(t,t);for(let s=i.min;s<i.max;s++){const i=this.prepareEdgePoints(e,r,n[s],((t,e)=>t<=e));if(null==i)continue;const[o,l]=i,u=a(O.vec3.fromValues(l.coord.y-o.coord.y,-(l.coord.x-o.coord.x),0));t.addQuad([o,l,{coord:l.coord,height:n[s].isTunnel?-.1:0},{coord:o.coord,height:n[s].isTunnel?-.1:0}],u);}for(let i=s.min;i<s.max;i++){const s=n[i],o=e[s.a],l=e[s.b],u=a(O.vec3.fromValues(l.y-o.y,-(l.x-o.x),0));t.addQuad([{coord:l,height:0},{coord:o,height:0},{coord:o,height:r[s.a]+4},{coord:l,height:r[s.b]+4}],u),t.addQuad([{coord:o,height:0},{coord:l,height:0},{coord:l,height:r[s.b]+4},{coord:o,height:r[s.a]+4}],u);}}prepareEdgePoints(t,e,r,n){const i=t[r.a],s=t[r.b];let a=e[r.a],o=e[r.b];if(!(0!==a&&n(a,0)||0!==o&&n(o,0)))return;const l=i.clone(),u=s.clone();if(n(a,0)){if(!n(o,0)){const t=o/(o-a);u.x=Ee(u.x,l.x,t),u.y=Ee(u.y,l.y,t),o=Ee(o,a,t);}}else {const t=a/(a-o);l.x=Ee(l.x,u.x,t),l.y=Ee(l.y,u.y,t),a=Ee(a,o,t);}return [{coord:l,height:a},{coord:u,height:o}]}prepareEdges(t,e){if(0===e.length)return;e.sort(((t,e)=>t.hash===e.hash?e.polygonIdx-t.polygonIdx:e.hash>t.hash?1:-1));let r=0,n=0,i=0,s=e[r].polygonIdx;do{n++,(n===e.length||e[r].hash!==e[n].hash)&&((1==n-r||e[n-1].polygonIdx!==s)&&(i<r&&(e[i]=e[r],e[r]=null),e[i].type="none",i++),r=n,r!==e.length&&(s=e[r].polygonIdx));}while(r!==e.length);if(e.splice(i),0!==e.length&&0!==t.length){e.sort(((t,e)=>t.hash<e.hash?1:-1));let r=0,n=0;for(;r!==e.length&&n!==t.length;){const i=e[r],s=t[n];i.portalHash>s.hash?r++:s.hash>i.portalHash?n++:(i.type=s.type,r++);}}}isOnBorder(t,e){return t<=0&&e<=0||t>=Kr&&e>=Kr}static computeEdgeHash(t,e){return (t.y===e.y&&t.x>e.x||t.y>e.y)&&([t,e]=[e,t]),BigInt(vh.computePosHash(t))<<32n|BigInt(vh.computePosHash(e))}static computePosHash(t){return ((65535&t.x)<<16|65535&t.y)>>>0}}class bh{constructor(t,e){this.layoutVertexArray=new _a,this.indexArray=new ja,this.lineIndexArray=new La,this.triangleSegments=new xo,this.lineSegments=new xo,this.programConfigurations=new Go(t.layers,{zoom:t.zoom,lut:t.lut}),this.uploaded=!1,e&&(this.elevatedLayoutVertexArray=new Aa);}update(t,e,r,n,i,s,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,a);}isEmpty(){return 0===this.layoutVertexArray.length}needsUpload(){return this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,mc.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.lineIndexBuffer=t.createIndexBuffer(this.lineIndexArray),this.elevatedLayoutVertexArray&&this.elevatedLayoutVertexArray.length>0&&(this.elevatedLayoutVertexBuffer=t.createVertexBuffer(this.elevatedLayoutVertexArray,yc.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.elevatedLayoutVertexBuffer&&this.elevatedLayoutVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.lineIndexBuffer.destroy(),this.programConfigurations.destroy(),this.triangleSegments.destroy(),this.lineSegments.destroy());}populatePaintArrays(t,e,r,n,i,s){this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,e,r,n,i,s);}}class _h{constructor(t){this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.bufferData=new bh(t,!1),this.elevationBufferData=new bh(t,!0),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection,this.elevationMode=this.layers[0].layout.get("fill-elevation-reference");}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Hc("fill",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("fill-sort-key"),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Cl(a,t);if(!this.layers[0]._featureFilter.filter(new Rs(this.zoom),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Vl(a,r,n),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=Xc("fill",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.availableImages,e.brightness,e.elevationFeatures);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r,n,i,s,a){this.bufferData.update(t,e,r,n,i,s,a),this.elevationBufferData.update(t,e,r,n,i,s,a);}addFeatures(t,e,r,n,i,s){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,e,r,n,s,t.elevationFeatures);}isEmpty(){return this.bufferData.isEmpty()&&this.elevationBufferData.isEmpty()}uploadPending(){return !this.uploaded||this.bufferData.needsUpload()||this.elevationBufferData.needsUpload()}upload(t){this.bufferData.upload(t),this.elevationBufferData.upload(t),this.elevatedStructures&&this.elevatedStructures.upload(t);}destroy(){this.bufferData.destroy(),this.elevationBufferData.destroy(),this.elevatedStructures&&this.elevatedStructures.destroy();}addFeature(t,e,r,n,i,s=[],a,o){const l=$c(e,500);"none"!==this.elevationMode?this.addElevatedRoadFeature(t,l,n,r,o):this.addGeometry(l,this.bufferData),this.bufferData.populatePaintArrays(t,r,i,s,n,a),this.elevationBufferData.populatePaintArrays(t,r,i,s,n,a);}getUnevaluatedPortalGraph(){return this.elevatedStructures?this.elevatedStructures.unevaluatedPortals:void 0}getElevationPolygons(){return this.elevatedStructures?this.elevatedStructures.portalPolygons:void 0}setEvaluatedPortalGraph(t){this.elevatedStructures&&this.elevatedStructures.construct(t);}addElevatedRoadFeature(t,e,r,n,i){const s=new Array,a=this.getElevationFeature(t,i);if(a){s.push({polygons:e,elevationFeature:a,elevationTileID:r});for(const e of s)if(e.elevationFeature){if("hd-road-base"===this.elevationMode){this.elevatedStructures||(this.elevatedStructures=new vh(e.elevationTileID));const r=e.elevationFeature.isTunnel();let n=0;t.properties.hasOwnProperty(lh)&&(n=+t.properties[lh]);for(const t of e.polygons)this.elevatedStructures.addPortalCandidates(e.elevationFeature.id,t,r,e.elevationFeature,n);}const i=new mh(r,e.elevationTileID);this.addElevatedGeometry(e.polygons,i,e.elevationFeature,"hd-road-base"===this.elevationMode?0:.05,n);}}else this.addGeometry(e,this.bufferData);}addElevatedGeometry(t,e,r,n,i){const s={elevation:r,elevationSampler:e,bias:n,index:i},[a,o]=this.addGeometry(t,this.elevationBufferData,s);null==this.elevationBufferData.heightRange?this.elevationBufferData.heightRange={min:a,max:o}:(this.elevationBufferData.heightRange.min=Math.min(this.elevationBufferData.heightRange.min,a),this.elevationBufferData.heightRange.max=Math.max(this.elevationBufferData.heightRange.max,o));}addGeometry(t,e,r){let n=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY,s=null;r&&(s=r.elevationSampler.constantElevation(r.elevation,r.bias),null!=s&&(n=s,i=s));const a=(t,a,o)=>{if(null!=r)if(a.push(t),null!=s)e.elevatedLayoutVertexArray.emplaceBack(s),o.push(s);else {const s=r.elevationSampler.pointElevation(t,r.elevation,r.bias);e.elevatedLayoutVertexArray.emplaceBack(s),o.push(s),n=Math.min(n,s),i=Math.max(i,s);}};for(const n of t){let t=0;for(const e of n)t+=e.length;const i=e.triangleSegments.prepareSegment(t,e.layoutVertexArray,e.indexArray),s=i.vertexLength,o=[],l=[],u=[],c=[],h=[],p=e.layoutVertexArray.length;for(const t of n){if(0===t.length)continue;t!==n[0]&&l.push(o.length/2);const i=e.lineSegments.prepareSegment(t.length,e.layoutVertexArray,e.lineIndexArray),s=i.vertexLength;r&&h.push(e.layoutVertexArray.length-p),a(t[0],u,c),e.layoutVertexArray.emplaceBack(t[0].x,t[0].y),e.lineIndexArray.emplaceBack(s+t.length-1,s),o.push(t[0].x),o.push(t[0].y);for(let r=1;r<t.length;r++)a(t[r],u,c),e.layoutVertexArray.emplaceBack(t[r].x,t[r].y),e.lineIndexArray.emplaceBack(s+r-1,s+r),o.push(t[r].x),o.push(t[r].y);i.vertexLength+=t.length,i.primitiveLength+=t.length;}const f=vc(o,l);for(let t=0;t<f.length;t+=3)e.indexArray.emplaceBack(s+f[t],s+f[t+1],s+f[t+2]);if(r&&"hd-road-base"===this.elevationMode){const t=r.elevation.isTunnel(),e=r.elevation.safeArea,n=this.elevatedStructures.addVertices(u,c);this.elevatedStructures.addTriangles(f,n,t);const i=h.length;if(i>0){for(let s=0;s<i-1;s++)this.elevatedStructures.addRenderableRing(r.index,h[s]+n,h[s+1]-h[s],t,e);this.elevatedStructures.addRenderableRing(r.index,h[i-1]+n,u.length-h[i-1],t,e);}}i.vertexLength+=t,i.primitiveLength+=f.length/3;}return [n,i]}getElevationFeature(t,e){if(!e)return;const r=+t.properties[oh];return null!=r?e.find((t=>t.id===r)):void 0}}let wh,Mh,Ah,Ih;us(_h,"FillBucket",{omit:["layers","patternFeatures"]}),us(bh,"FillBufferData"),us(vh,"ElevatedStructures");class Sh{constructor(t,e,r,n){if(this.triangleCount=e.length/3,this.min=new q(0,0),this.max=new q(0,0),this.xScale=0,this.yScale=0,this.cellsX=0,this.cellsY=0,this.cells=[],this.payload=[],0===this.triangleCount||0===t.length)return;const[i,s]=[t[0].clone(),t[0].clone()];for(let e=1;e<t.length;++e){const r=t[e];i.x=Math.min(i.x,r.x),i.y=Math.min(i.y,r.y),s.x=Math.max(s.x,r.x),s.y=Math.max(s.y,r.y);}if(n){const t=Math.ceil(Math.max(s.x-i.x,s.y-i.y)/n);r=Math.max(r,t);}if(0===r)return;this.min=i,this.max=s;const a=this.max.sub(this.min);a.x=Math.max(a.x,1),a.y=Math.max(a.y,1);const o=Math.max(a.x,a.y)/r;this.cellsX=Math.max(1,Math.ceil(a.x/o)),this.cellsY=Math.max(1,Math.ceil(a.y/o)),this.xScale=1/o,this.yScale=1/o;const l=[];for(let r=0;r<this.triangleCount;r++){const n=t[e[3*r+0]].sub(this.min),i=t[e[3*r+1]].sub(this.min),s=t[e[3*r+2]].sub(this.min),a=Ph(Math.floor(Math.min(n.x,i.x,s.x)),this.xScale,this.cellsX),u=Ph(Math.floor(Math.max(n.x,i.x,s.x)),this.xScale,this.cellsX),c=Ph(Math.floor(Math.min(n.y,i.y,s.y)),this.yScale,this.cellsY),h=Ph(Math.floor(Math.max(n.y,i.y,s.y)),this.yScale,this.cellsY),p=new q(0,0),f=new q(0,0),d=new q(0,0),m=new q(0,0);for(let t=c;t<=h;++t){p.y=f.y=t*o,d.y=m.y=(t+1)*o;for(let e=a;e<=u;++e)p.x=d.x=e*o,f.x=m.x=(e+1)*o,(Kl(n,i,s,p,f,m)||Kl(n,i,s,p,m,d))&&l.push({cellIdx:t*this.cellsX+e,triIdx:r});}}if(0===l.length)return;l.sort(((t,e)=>t.cellIdx-e.cellIdx||t.triIdx-e.triIdx));let u=0;for(;u<l.length;){const t=l[u].cellIdx,e={start:this.payload.length,len:0};for(;u<l.length&&l[u].cellIdx===t;)++e.len,this.payload.push(l[u++].triIdx);this.cells[t]=e;}}_lazyInitLookup(){this.lookup||(this.lookup=new Uint8Array(Math.ceil(this.triangleCount/8))),this.lookup.fill(0);}queryPoint(t,e){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>t.x||t.y>this.max.y||this.min.y>t.y)return;const r=Ph(t.x-this.min.x,this.xScale,this.cellsX),n=Ph(t.y-this.min.y,this.yScale,this.cellsY),i=this.cells[n*this.cellsX+r];if(i){this._lazyInitLookup();for(let t=0;t<i.len;t++){const r=this.payload[i.start+t],n=Math.floor(r/8),s=1<<r%8;if(!(this.lookup[n]&s)&&(this.lookup[n]|=s,e.push(r),e.length===this.triangleCount))return}}}query(t,e,r){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>e.x)return;if(t.y>this.max.y||this.min.y>e.y)return;this._lazyInitLookup();const n=Ph(t.x-this.min.x,this.xScale,this.cellsX),i=Ph(e.x-this.min.x,this.xScale,this.cellsX),s=Ph(t.y-this.min.y,this.yScale,this.cellsY),a=Ph(e.y-this.min.y,this.yScale,this.cellsY);for(let t=s;t<=a;t++)for(let e=n;e<=i;e++){const n=this.cells[t*this.cellsX+e];if(n)for(let t=0;t<n.len;t++){const e=this.payload[n.start+t],i=Math.floor(e/8),s=1<<e%8;if(!(this.lookup[i]&s)&&(this.lookup[i]|=s,r.push(e),r.length===this.triangleCount))return}}}}function Ph(t,e,r){return Math.max(0,Math.min(r-1,Math.floor(t*e)))}us(Sh,"TriangleGridIndex");class Eh{constructor(t){this.zoom=t.zoom,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.footprints=[];}updateFootprints(t,e){for(const r of this.footprints)e.push({footprint:r,id:t});}populate(t,e,r,n){const i=[];for(const{feature:e,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Cl(e,t);if(!this.layers[0]._featureFilter.filter(new Rs(this.zoom),l,r))continue;const u={id:s,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Vl(e,r,n),patterns:{}};i.push(u);}for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n;this.addFeature(n,i,s,r,{},e.availableImages,e.brightness),e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}isEmpty(){return 0===this.footprints.length}uploadPending(){return !1}upload(t){}update(t,e,r,n,i,s,a){}destroy(){}addFeature(t,e,r,n,i,s=[],a){for(const t of $c(e,2)){const e=[],r=[],n=[],i=new q(1/0,1/0),s=new q(-1/0,-1/0);for(const a of t)if(0!==a.length){a!==t[0]&&n.push(r.length/2);for(let t=0;t<a.length;t++)r.push(a[t].x),r.push(a[t].y),e.push(a[t]),i.x=Math.min(i.x,a[t].x),i.y=Math.min(i.y,a[t].y),s.x=Math.max(s.x,a[t].x),s.y=Math.max(s.y,a[t].y);}const a=vc(r,n),o=new Sh(e,a,8,256);this.footprints.push({vertices:e,indices:a,grid:o,min:i,max:s});}}}us(Eh,"ClipBucket",{omit:["layers"]});const zh=va([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),kh=va([{name:"a_pos_end",components:4,type:"Int16"},{name:"a_angular_offset_factor",components:1,type:"Int16"}]),Th=va([{name:"a_centroid_pos",components:2,type:"Uint16"}]),Bh=va([{name:"a_join_normal_inside",components:3,type:"Int16"}]),Vh=va([{name:"a_hidden_by_landmark",components:1,type:"Uint8"}]),Ch=va([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:Dh}=zh;class Rh extends q{constructor(t,e,r){super(t,e),this.z=r;}}class Lh extends Rh{constructor(t,e,r,n){super(t,e,r),this.w=n;}}function Fh(t,e,r,n){const i=[],s=0===n?(t,e,r,n,i,s)=>{t.push(new q(s,r+(s-e)/(n-e)*(i-r)));}:(t,e,r,n,i,s)=>{t.push(new q(e+(s-r)/(i-r)*(n-e),s));};for(const a of t){const t=[];for(const i of a){if(i.length<=2)continue;const a=[];for(let t=0;t<i.length-1;t++){const o=i[t].x,l=i[t].y,u=i[t+1].x,c=i[t+1].y,h=0===n?o:l,p=0===n?u:c;h<e?p>e&&s(a,o,l,u,c,e):h>r?p<r&&s(a,o,l,u,c,r):a.push(i[t]),p<e&&h>=e&&s(a,o,l,u,c,e),p>r&&h<=r&&s(a,o,l,u,c,r);}let o=i[i.length-1];const l=0===n?o.x:o.y;l>=e&&l<=r&&a.push(o),a.length&&(o=a[a.length-1],a[0].x===o.x&&a[0].y===o.y||a.push(a[0]),t.push(a));}t.length&&i.push(t);}return i}function Oh(t,e,r,n){const i="x"===r?"y":"x",s=(n-t[r])/(e[r]-t[r]);t[i]=t[i]+(e[i]-t[i])*s,t[r]=n,t.hasOwnProperty("z")&&(t.z=Ee(t.z,e.z,s)),t.hasOwnProperty("w")&&(t.w=Ee(t.w,e.w,s));}function Nh(t,e,r,n){const i=r,s=n;for(const r of ["x","y"]){let n=t,a=e;n[r]>=a[r]&&(n=e,a=t),n[r]<i&&a[r]>i&&Oh(n,a,r,i),n[r]<s&&a[r]>s&&Oh(a,n,r,s);}}const Uh=Number.MAX_SAFE_INTEGER;function jh(t,e,r,n){return t.order<e||t.order===Uh||!(t.clipMask&r)||function(t,e){return 0!==e.length&&void 0===e.find((e=>e===t))}(n,t.clipScope)}function qh(t,e){return t.x-e.x||t.y-e.y}function $h(t,e){return 0===qh(t.min,e.min)&&0===qh(t.max,e.max)}function Gh(t,e){return !(t.min.x>e.max.x||t.max.x<e.min.x||t.min.y>e.max.y||t.max.y<e.min.y)}function Yh(t,e){if(t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(t[r].sourceId!==e[r].sourceId||!$h(t[r],e[r])||t[r].order!==e[r].order||t[r].clipMask!==e[r].clipMask||!$(t[r].clipScope,e[r].clipScope))return !1;return !0}function Hh(t,e,r){const n=1/Kr,i=1/(1<<r.canonical.z),s=(e.x*n+r.canonical.x)*i+r.wrap,a=(e.y*n+r.canonical.y)*i;return {min:new q((t.x*n+r.canonical.x)*i+r.wrap,(t.y*n+r.canonical.y)*i),max:new q(s,a)}}function Xh(t,e,r){const n=1<<r.canonical.z,i=((e.x-r.wrap)*n-r.canonical.x)*Kr,s=(e.y*n-r.canonical.y)*Kr;return {min:new q(((t.x-r.wrap)*n-r.canonical.x)*Kr,(t.y*n-r.canonical.y)*Kr),max:new q(i,s)}}function Zh(t,e,r,n,i,s,a){const o=t.indices,l=t.vertices,u=[];for(let c=n;c<n+i;c+=3){const n=e[r[c+0]+s],i=e[r[c+1]+s],h=e[r[c+2]+s],p=Math.min(n.x,i.x,h.x),f=Math.max(n.x,i.x,h.x),d=Math.min(n.y,i.y,h.y),m=Math.max(n.y,i.y,h.y);u.length=0,t.grid.query(new q(p,d),new q(f,m),u);for(let t=0;t<u.length;t++){const e=u[t];if(Kl(l[o[3*e+0]],l[o[3*e+1]],l[o[3*e+2]],n,i,h,a))return !0}}return !1}function Wh(t,e,r,n){if(!t||!r)return !1;let i=t.vertices;if(!e.canonical.equals(n.canonical)||e.wrap!==n.wrap){if(r.vertices.length<t.vertices.length)return Wh(r,n,t,e);const s=e.canonical,a=n.canonical,o=Math.pow(2,a.z-s.z);i=t.vertices.map((t=>new q((t.x+s.x*Kr)*o-a.x*Kr,(t.y+s.y*Kr)*o-a.y*Kr)));}return Zh(r,i,t.indices,0,t.indices.length,0,0)}function Kh(t,e,r,n){const i=Math.pow(2,n.z-r.z);return new q((t+r.x*Kr)*i-n.x*Kr,(e+r.y*Kr)*i-n.y*Kr)}function Jh(t,e){const r=[];e.grid.queryPoint(t,r);const n=e.indices,i=e.vertices;for(let e=0;e<r.length;e++){const s=r[e];if(Hl([i[n[3*s+0]],i[n[3*s+1]],i[n[3*s+2]]],t))return !0}return !1}const Qh=[new q(0,0),new q(Kr,0),new q(Kr,Kr),new q(0,Kr)];function tp(t,e){const r=[];let n=[];if(!e||t.length<2)return [t];if(2===t.length)return Zl(t[0],t[1],Qh)?[t]:[];for(let e=0;e<t.length+2;e++){const i=t[e%t.length],s=t[(e+1)%t.length],a=Zl(0===e?t[t.length-1]:t[(e-1)%t.length],i,Qh),o=Zl(i,s,Qh),l=a||o;l&&n.push(i),l&&o||n.length>0&&(n.length>1&&r.push(n),n=[]);}return n.length>1&&r.push(n),r}const ep=ah.VectorTileFeature.types,rp=["fill-extrusion-base","fill-extrusion-height","fill-extrusion-color","fill-extrusion-pattern","fill-extrusion-flood-light-wall-radius","fill-extrusion-line-width","fill-extrusion-emissive-strength"],np=["fill-extrusion-flood-light-ground-radius"],ip=Math.pow(2,13),sp=Math.pow(2,15)-1,ap=new q(0,1),op=2147483648;function lp(t,e,r,n,i,s,a,o){t.emplaceBack((e<<1)+a,(r<<1)+s,(Math.floor(n*ip)<<1)+i,Math.round(o));}function up(t,e,r){t.emplaceBack(e.x*Kr,e.y*Kr,r?1:0);}function cp(t,e,r,n,i,s){t.emplaceBack(e.x,e.y,(r.x<<1)+n,(r.y<<1)+i,s);}function hp(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class pp{constructor(){this.vertexOffset=0,this.vertexCount=0,this.indexOffset=0,this.indexCount=0;}}class fp{constructor(){this.centroidXY=new q(0,0),this.vertexArrayOffset=0,this.vertexCount=0,this.groundVertexArrayOffset=0,this.groundVertexCount=0,this.flags=0,this.footprintSegIdx=-1,this.footprintSegLen=0,this.polygonSegIdx=-1,this.polygonSegLen=0,this.min=new q(Number.MAX_VALUE,Number.MAX_VALUE),this.max=new q(-Number.MAX_VALUE,-Number.MAX_VALUE),this.height=0;}span(){return new q(this.max.x-this.min.x,this.max.y-this.min.y)}}class dp{constructor(){this.acc=new q(0,0),this.accCount=0,this.centroidDataIndex=0;}startRing(t,e){t.min.x===Number.MAX_VALUE&&(t.min.x=t.max.x=e.x,t.min.y=t.max.y=e.y);}appendEdge(t,e,r){this.accCount++,this.acc._add(e);let n=!!this.borders;e.x<t.min.x?(t.min.x=e.x,n=!0):e.x>t.max.x&&(t.max.x=e.x,n=!0),e.y<t.min.y?(t.min.y=e.y,n=!0):e.y>t.max.y&&(t.max.y=e.y,n=!0),((0===e.x||e.x===Kr)&&e.x===r.x)!=((0===e.y||e.y===Kr)&&e.y===r.y)&&this.processBorderOverlap(e,r),n&&this.checkBorderIntersection(e,r);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,Ee(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>Kr!=t.x>Kr&&this.addBorderIntersection(1,Ee(e.y,t.y,(Kr-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,Ee(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>Kr!=t.y>Kr&&this.addBorderIntersection(3,Ee(e.x,t.x,(Kr-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){return 0===this.accCount?new q(0,0):new q(Math.floor(Math.max(0,this.acc.x)/this.accCount),Math.floor(Math.max(0,this.acc.y)/this.accCount))}intersectsCount(){return this.borders?this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0):0}}function mp(t,e){const r=t.add(e)._unit(),n=Q(t.x*r.x+t.y*r.y,-1,1);var i,s,a;return a=Math.acos(n),Math.min(4,Math.max(-4,Math.tan(a)))/4*sp*((i=t).x*(s=e).y-i.y*s.x<0?-1:1)}const yp=[t=>t.x<0,t=>t.x>Kr,t=>t.y<0,t=>t.y>Kr];function gp(t,e,r,n){const i=[4];if(0===n)return i;r._mult(n);const s=t.sub(r),a=e.sub(r),o=[t,e,s,a];for(let t=0;t<4;t++)for(const e of o)if(yp[t](e)){i.push(t);break}return i}class xp{constructor(t){this.vertexArray=new Pa,this.indexArray=new ja,this.programConfigurations=new Go(t.layers,{zoom:t.zoom,lut:t.lut},(t=>np.includes(t))),this._segments=new xo,this.hiddenByLandmarkVertexArray=new eo,this._segmentToGroundQuads={},this._segmentToGroundQuads[0]=[],this._segmentToRegionTriCounts={},this._segmentToRegionTriCounts[0]=[0,0,0,0,0],this.regionSegments={},this.regionSegments[4]=new xo;}getDefaultSegment(){return this.regionSegments[4]}hasData(){return 0!==this.vertexArray.length}addData(t,e,r,n=!1){const i=t.length;if(i>2){let s=Math.max(0,this._segments.get().length-1);const a=this._segments._prepareSegment(4*i,this.vertexArray.length,2*this._segmentToGroundQuads[s].length);let o;s!==this._segments.get().length-1&&(s++,this._segmentToGroundQuads[s]=[],this._segmentToRegionTriCounts[s]=[0,0,0,0,0]);{const e=t[0],r=t[1];o=mp(e.sub(t[i-1])._perp()._unit(),r.sub(e)._perp()._unit());}for(let l=0;l<i;l++){const u=l===i-1?0:l+1,c=t[l],h=t[u],p=t[u===i-1?0:u+1],f=h.sub(c)._perp()._unit(),d=mp(f,p.sub(h)._perp()._unit()),m=o,y=d;if(Mp(c,h,e)||n&&Ap(c,e)&&Ap(h,e)){o=d;continue}const g=a.vertexLength;cp(this.vertexArray,c,h,1,1,m),cp(this.vertexArray,c,h,1,0,m),cp(this.vertexArray,c,h,0,1,y),cp(this.vertexArray,c,h,0,0,y),a.vertexLength+=4;const x=gp(c,h,f,r);for(const t of x)this._segmentToGroundQuads[s].push({id:g,region:t}),this._segmentToRegionTriCounts[s][t]+=2,a.primitiveLength+=2;o=d;}}}prepareBorderSegments(){if(!this.hasData())return;const t=this._segments.get(),e=t.length;for(let t=0;t<e;t++)this._segmentToGroundQuads[t].sort(((t,e)=>t.region-e.region));for(let r=0;r<e;r++){const e=this._segmentToGroundQuads[r],n=t[r],i=this._segmentToRegionTriCounts[r];i.reduce(((t,e)=>t+e),0);let s=0;for(let t=0;t<=4;t++){const e=i[t];if(0!==e){let r=this.regionSegments[t];r||(r=this.regionSegments[t]=new xo);const i={vertexOffset:n.vertexOffset,primitiveOffset:n.primitiveOffset+s,vertexLength:n.vertexLength,primitiveLength:e};r.get().push(i);}s+=e;}for(let t=0;t<e.length;t++){const r=e[t].id;this.indexArray.emplaceBack(r,r+1,r+3),this.indexArray.emplaceBack(r,r+3,r+2);}}this._segmentToGroundQuads=null,this._segmentToRegionTriCounts=null,this._segments.destroy(),this._segments=null;}addPaintPropertiesData(t,e,r,n,i,s){this.hasData()&&this.programConfigurations.populatePaintArrays(this.vertexArray.length,t,e,r,n,i,s);}upload(t){this.hasData()&&(this.vertexBuffer=t.createVertexBuffer(this.vertexArray,kh.members),this.indexBuffer=t.createIndexBuffer(this.indexArray));}uploadPaintProperties(t){this.hasData()&&this.programConfigurations.upload(t);}update(t,e,r,n,i,s,a){this.hasData()&&this.programConfigurations.updatePaintArrays(t,e,r,n,i,s,a);}updateHiddenByLandmark(t){if(!this.hasData())return;const e=t.groundVertexCount+t.groundVertexArrayOffset;if(0===t.groundVertexCount)return;const r=t.flags&op?1:0;for(let n=t.groundVertexArrayOffset;n<e;++n)this.hiddenByLandmarkVertexArray.emplace(n,r);this._needsHiddenByLandmarkUpdate=!0;}uploadHiddenByLandmark(t){this.hasData()&&this._needsHiddenByLandmarkUpdate&&(!this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexArray.length>0?this.hiddenByLandmarkVertexBuffer=t.createVertexBuffer(this.hiddenByLandmarkVertexArray,Vh.members,!0):this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray),this._needsHiddenByLandmarkUpdate=!1);}destroy(){if(this.vertexBuffer){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.destroy(),this._segments&&this._segments.destroy(),this.programConfigurations.destroy();for(let t=0;t<=4;t++){const e=this.regionSegments[t];e&&e.destroy();}}}}class vp{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaling=t.overscaling,this.layers=t.layers,this.pixelRatio=t.pixelRatio,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=t.projection,this.activeReplacements=[],this.replacementUpdateTime=0,this.centroidData=[],this.footprintIndices=new ja,this.footprintVertices=new _a,this.footprintSegments=[],this.layoutVertexArray=new Ma,this.centroidVertexArray=new po,this.wallVertexArray=new mo,this.indexArray=new ja,this.programConfigurations=new Go(t.layers,{zoom:t.zoom,lut:t.lut},(t=>rp.includes(t))),this.segments=new xo,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.groundEffect=new xp(t),this.maxHeight=0,this.partLookup={},this.triangleSubSegments=[],this.polygonSegments=[];}updateFootprints(t,e){}populate(t,e,r,n){this.features=[],this.hasPattern=Hc("fill-extrusion",this.layers,this.pixelRatio,e),this.featuresOnBorder=[],this.borderFeatureIndices=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.selfDEMTileTimestamp=Number.MAX_VALUE,this.borderDEMTileTimestamp=[Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE],this.tileToMeter=Al(r),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter,this.wallMode=0!==this.layers[0].paint.get("fill-extrusion-line-width").constantOr(1);for(const{feature:i,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Cl(i,t);if(!this.layers[0]._featureFilter.filter(new Rs(this.zoom),l,r))continue;const u={id:s,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Vl(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length,h="Polygon"===ep[u.type];if(this.hasPattern)this.features.push(Xc("fill-extrusion",this.layers,u,this.zoom,this.pixelRatio,e));else if(this.wallMode)for(const t of u.geometry)for(const i of tp(t,h))this.addFeature(u,[i],a,r,{},e.availableImages,n,e.brightness);else this.addFeature(u,u.geometry,a,r,{},e.availableImages,n,e.brightness);e.featureIndex.insert(i,u.geometry,a,o,this.index,c);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles(),this.groundEffect.prepareBorderSegments(),this.polygonSegments.length=0;}addFeatures(t,e,r,n,i,s){for(const t of this.features){const a="Polygon"===ep[t.type],{geometry:o}=t;if(this.wallMode)for(const l of o)for(const o of tp(l,a))this.addFeature(t,[o],t.index,e,r,n,i,s);else this.addFeature(t,o,t.index,e,r,n,i,s);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles();}update(t,e,r,n,i,s,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,a),this.groundEffect.update(t,e,i,r,n,s,a);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Dh),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.wallVertexBuffer=t.createVertexBuffer(this.wallVertexArray,Bh.members),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=t.createVertexBuffer(this.layoutVertexExtArray,Ch.members,!0)),this.groundEffect.upload(t)),this.groundEffect.uploadPaintProperties(t),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){this.groundEffect.uploadHiddenByLandmark(t),this.needsCentroidUpdate&&(!this.centroidVertexBuffer&&this.centroidVertexArray.length>0?this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Th.members,!0):this.centroidVertexBuffer&&this.centroidVertexBuffer.updateData(this.centroidVertexArray),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.groundEffect.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,s,a,o){const l=this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(t,{})/this.tileToMeter,u=[new q(0,0),new q(Kr,Kr)],c=a.projection,h="globe"===c.name,p=this.wallMode||"Polygon"===ep[t.type],f=new dp;f.centroidDataIndex=this.centroidData.length;const d=new fp,m=this.layers[0].paint.get("fill-extrusion-base").evaluate(t,{},n)<=0,y=this.layers[0].paint.get("fill-extrusion-height").evaluate(t,{},n);let g;if(d.height=y,d.vertexArrayOffset=this.layoutVertexArray.length,d.groundVertexArrayOffset=this.groundEffect.vertexArray.length,h&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new Ba),this.wallMode){if(h)return void pt("Non zero fill-extrusion-line-width is not yet supported on globe.");if(1!==e.length)return;g=function(t){const e=t[0].x===t[t.length-1].x&&t[0].y===t[t.length-1].y,r=function(t){let e=0;const r=t.length;for(let n=0;n<r;n++)e+=(t[(n+1)%r].x-t[n].x)*(t[(n+1)%r].y+t[n].y);return e>=0}(t);r||(t=t.reverse());const n={geometry:[],joinNormals:[],indices:[]},i=[],s=[],a=[];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;if(o<(e?3:2))return n;let l,u,c,h,p,f=0;for(;f<o-1&&t[f].equals(t[f+1]);)f++;e&&(l=t[o-2],p=t[f].sub(l)._unit()._perp());for(let r=f;r<o;r++){if(c=r===o-1?e?t[f+1]:void 0:t[r+1],c&&t[r].equals(c))continue;p&&(h=p),l&&(u=l),l=t[r],p=c?c.sub(l)._unit()._perp():h,h=h||p;let n=h.add(p);0===n.x&&0===n.y||n._unit();const d=n.x*p.x+n.y*p.y,m=0!==d?1/d:1/0,y=h.x*p.y-h.y*p.x>0;let g="miter";const x=2;"miter"===g&&m>x&&(g="bevel"),"bevel"===g&&(m>100&&(g="flipbevel"),m<x&&(g="miter"));const v=(t,e,r,n)=>{const o=new q(t.x,t.y),l=new q(t.x,t.y);o.x+=e.x*n,o.y+=e.y*n,l.x-=e.x*Math.max(r,1),l.y-=e.y*Math.max(r,1),a.push(e),i.push(o),s.push(l);};if("miter"===g)n._mult(m),v(l,n,0,0);else if("flipbevel"===g)n=p.mult(-1),v(l,n,0,0),v(l,n.mult(-1),0,0);else {const t=-Math.sqrt(m*m-1),e=y?t:0,r=y?0:t;u&&v(l,h,e,r),c&&v(l,p,e,r);}}n.geometry=[...i,...s.reverse(),i[0]],n.joinNormals=[...a,...a.reverse(),a[a.length-1]];const d=n.geometry.length-1;for(let t=0;t<d/2;t++)if(t+1<d/2){let e=t,r=t+1,i=d-1-t,s=d-2-t;e=0===e?d-1:e-1,r=0===r?d-1:r-1,i=0===i?d-1:i-1,s=0===s?d-1:s-1,n.indices.push(i),n.indices.push(r),n.indices.push(e),n.indices.push(i),n.indices.push(s),n.indices.push(r);}return n}(e[0]),e=[g.geometry];}const x=(t,e)=>t<(e.length-1)/2||t===e.length-1,v=this.wallMode?[e]:$c(e,500);for(let t=v.length-1;t>=0;t--){const e=v[t];(0===e.length||(b=e[0]).every((t=>t.x<=0))||b.every((t=>t.x>=Kr))||b.every((t=>t.y<=0))||b.every((t=>t.y>=Kr)))&&v.splice(t,1);}var b;let _;if(h)_=Ep(v,u,n);else {_=[];for(const t of v)_.push({polygon:t,bounds:u});}const w=p?this.edgeRadius:0,M=w>0&&this.zoom<17,A=(t,e)=>{if(0===t.length)return !1;const r=t[t.length-1];return e.x===r.x&&e.y===r.y};for(const{polygon:t,bounds:e}of _){let r=0,i=0;for(const e of t)p&&!e[0].equals(e[e.length-1])&&e.push(e[0]),i+=p?e.length-1:e.length;const s=this.segments.prepareSegment((p?5:4)*i,this.layoutVertexArray,this.indexArray);d.footprintSegIdx<0&&(d.footprintSegIdx=this.footprintSegments.length),d.polygonSegIdx<0&&(d.polygonSegIdx=this.polygonSegments.length);const a={triangleArrayOffset:this.indexArray.length,triangleCount:0,triangleSegIdx:this.segments.segments.length-1},o=new pp;if(o.vertexOffset=this.footprintVertices.length,o.indexOffset=3*this.footprintIndices.length,o.ringIndices=[],p){const i=[],a=[];r=s.vertexLength;for(let r=0;r<t.length;r++){const u=t[r];u.length&&0!==r&&a.push(i.length/2);const p=[];let f,d;f=u[1].sub(u[0])._perp()._unit(),o.ringIndices.push(u.length-1);for(let t=1;t<u.length;t++){const e=u[t],r=u[t===u.length-1?1:t+1],a=e.clone();if(w){d=r.sub(e)._perp()._unit();const t=f.add(d)._unit(),n=w*Math.min(4,1/(f.x*t.x+f.y*t.y));a.x+=n*t.x,a.y+=n*t.y,a.x=Math.round(a.x),a.y=Math.round(a.y),f=d;}if(!m||0!==w&&!M||A(p,a)||p.push(a),lp(this.layoutVertexArray,a.x,a.y,0,0,1,1,0),this.wallMode){const e=x(t,u);up(this.wallVertexArray,g.joinNormals[t],!e);}s.vertexLength++,this.footprintVertices.emplaceBack(e.x,e.y),i.push(e.x,e.y),h&&hp(this.layoutVertexExtArray,c.projectTilePoint(a.x,a.y,n),c.upVector(n,a.x,a.y));}m&&(0===w||M)&&(0!==p.length&&A(p,p[0])&&p.pop(),this.groundEffect.addData(p,e,l));}const u=this.wallMode?g.indices:vc(i,a);for(let t=0;t<u.length;t+=3)this.footprintIndices.emplaceBack(o.vertexOffset+u[t+0],o.vertexOffset+u[t+1],o.vertexOffset+u[t+2]),this.indexArray.emplaceBack(r+u[t],r+u[t+2],r+u[t+1]),s.primitiveLength++;o.indexCount+=u.length,o.vertexCount+=this.footprintVertices.length-o.vertexOffset;}for(let i=0;i<t.length;i++){const a=t[i];f.startRing(d,a[0]);let o=a.length>4&&Ip(a[a.length-2],a[0],a[1]),u=w?_p(a[a.length-2],a[0],a[1],w):0;const y=[];let v,b,_;b=a[1].sub(a[0])._perp()._unit();let M=!0;for(let t=1,i=0;t<a.length;t++){let l=a[t-1],p=a[t];const I=a[t===a.length-1?1:t+1];if(f.appendEdge(d,p,l),Mp(p,l,e)){w&&(b=I.sub(p)._perp()._unit(),M=!M);continue}const S=p.sub(l)._perp(),P=S.x/(Math.abs(S.x)+Math.abs(S.y)),E=S.y>0?1:0,z=l.dist(p);if(i+z>32768&&(i=0),w){_=I.sub(p)._perp()._unit();let t=wp(l,p,I,bp(b,_),w);isNaN(t)&&(t=0);const e=p.sub(l)._unit();l=l.add(e.mult(u))._round(),p=p.add(e.mult(-t))._round(),u=t,b=_,m&&this.zoom>=17&&(A(y,l)||y.push(l),A(y,p)||y.push(p));}const k=s.vertexLength,T=a.length>4&&Ip(l,p,I);let B=Sp(i,o,M);if(lp(this.layoutVertexArray,l.x,l.y,P,E,0,0,B),lp(this.layoutVertexArray,l.x,l.y,P,E,0,1,B),this.wallMode){const e=x(t-1,a),r=g.joinNormals[t-1];up(this.wallVertexArray,r,e),up(this.wallVertexArray,r,e);}if(i+=z,B=Sp(i,T,!M),o=T,lp(this.layoutVertexArray,p.x,p.y,P,E,0,0,B),lp(this.layoutVertexArray,p.x,p.y,P,E,0,1,B),this.wallMode){const e=x(t,a),r=g.joinNormals[t];up(this.wallVertexArray,r,e),up(this.wallVertexArray,r,e);}if(s.vertexLength+=4,this.indexArray.emplaceBack(k+0,k+1,k+2),this.indexArray.emplaceBack(k+1,k+3,k+2),s.primitiveLength+=2,w){const n=r+(1===t?a.length-2:t-2),i=1===t?r:n+1;if(this.indexArray.emplaceBack(k+1,n,k+3),this.indexArray.emplaceBack(n,i,k+3),s.primitiveLength+=2,void 0===v&&(v=k),!Mp(I,a[t],e)){const e=t===a.length-1?v:s.vertexLength;this.indexArray.emplaceBack(k+2,k+3,e),this.indexArray.emplaceBack(k+3,e+1,e),this.indexArray.emplaceBack(k+3,i,e+1),s.primitiveLength+=3;}M=!M;}if(h){const t=this.layoutVertexExtArray,e=c.projectTilePoint(l.x,l.y,n),r=c.projectTilePoint(p.x,p.y,n),i=c.upVector(n,l.x,l.y),s=c.upVector(n,p.x,p.y);hp(t,e,i),hp(t,e,i),hp(t,r,s),hp(t,r,s);}}p&&(r+=a.length-1),m&&w&&this.zoom>=17&&(0!==y.length&&A(y,y[0])&&y.pop(),this.groundEffect.addData(y,e,l,w>0));}this.footprintSegments.push(o),a.triangleCount=this.indexArray.length-a.triangleArrayOffset,this.polygonSegments.push(a),++d.footprintSegLen,++d.polygonSegLen;}if(d.vertexCount=this.layoutVertexArray.length-d.vertexArrayOffset,d.groundVertexCount=this.groundEffect.vertexArray.length-d.groundVertexArrayOffset,0!==d.vertexCount){if(d.centroidXY=f.borders?ap:this.encodeCentroid(f,d),this.centroidData.push(d),f.borders){this.featuresOnBorder.push(f);const t=this.featuresOnBorder.length-1;for(let e=0;e<f.borders.length;e++)f.borders[e][0]!==Number.MAX_VALUE&&this.borderFeatureIndices[e].push(t);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,o),this.groundEffect.addPaintPropertiesData(t,r,i,s,n,o),this.maxHeight=Math.max(this.maxHeight,y);}}sortBorders(){for(let t=0;t<this.borderFeatureIndices.length;t++)this.borderFeatureIndices[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}splitToSubtiles(){const t=[];for(let e=0;e<this.centroidData.length;e++){const r=this.centroidData[e],n=+(r.min.y+r.max.y>Kr),i=2*n+(+(r.min.x+r.max.x>Kr)^n);for(let n=0;n<r.polygonSegLen;n++){const s=r.polygonSegIdx+n;t.push({centroidIdx:e,subtile:i,polygonSegmentIdx:s,triangleSegmentIdx:this.polygonSegments[s].triangleSegIdx});}}const e=new ja;t.sort(((t,e)=>t.triangleSegmentIdx===e.triangleSegmentIdx?t.subtile-e.subtile:t.triangleSegmentIdx-e.triangleSegmentIdx));let r=0,n=0,i=0;for(const e of t){if(e.triangleSegmentIdx!==r)break;i++;}const s=t.length;for(;n!==t.length;){r=t[n].triangleSegmentIdx;let a=0,o=n,l=n;for(let e=o;e<i&&t[e].subtile===a;e++)l++;for(;o!==i;){const n=t[o];a=n.subtile;const s=this.centroidData[n.centroidIdx].min.clone(),u=this.centroidData[n.centroidIdx].max.clone(),c={vertexOffset:this.segments.segments[r].vertexOffset,primitiveOffset:e.length,vertexLength:this.segments.segments[r].vertexLength,primitiveLength:0,sortKey:void 0,vaos:{}};for(let r=o;r<l;r++){const n=t[r],i=this.polygonSegments[n.polygonSegmentIdx],a=this.centroidData[n.centroidIdx].min,o=this.centroidData[n.centroidIdx].max,l=this.indexArray.uint16;for(let t=i.triangleArrayOffset;t<i.triangleArrayOffset+i.triangleCount;t++)e.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);c.primitiveLength+=i.triangleCount,s.x=Math.min(s.x,a.x),s.y=Math.min(s.y,a.y),u.x=Math.max(u.x,o.x),u.y=Math.max(u.y,o.y);}c.primitiveLength>0&&this.triangleSubSegments.push({segment:c,min:s,max:u}),o=l;for(let e=o;e<i&&t[e].subtile===t[o].subtile;e++)l++;}n=i;for(let e=n;e<s&&t[e].triangleSegmentIdx===t[n].triangleSegmentIdx;e++)i++;}e._trim(),this.indexArray=e;}getVisibleSegments(t,e,r){const n=new xo;if(this.wallMode){for(const t of this.triangleSubSegments)n.segments.push(t.segment);return n}let i=0,s=0;const a=1<<t.canonical.z;if(e){const r=e.getMinMaxForTile(t);r&&(i=r.min,s=r.max);}s+=this.maxHeight;const o=t.toUnwrapped();let l;const u=[o.canonical.x/a+o.wrap,o.canonical.y/a],c=[(o.canonical.x+1)/a+o.wrap,(o.canonical.y+1)/a],h=(t,e,r)=>[t[0]*(1-r[0])+e[0]*r[0],t[1]*(1-r[1])+e[1]*r[1]],p=[],f=[];for(const t of this.triangleSubSegments){p[0]=t.min.x/Kr,p[1]=t.min.y/Kr,f[0]=t.max.x/Kr,f[1]=t.max.y/Kr;const e=h(u,c,p),a=h(u,c,f);if(0===new Au([e[0],e[1],i],[a[0],a[1],s]).intersectsPrecise(r)){l&&(n.segments.push(l),l=void 0);continue}const o=t.segment;l&&l.vertexOffset!==o.vertexOffset&&(n.segments.push(l),l=void 0),l?(l.vertexLength+=o.vertexLength,l.primitiveLength+=o.primitiveLength):l={vertexOffset:o.vertexOffset,primitiveLength:o.primitiveLength,vertexLength:o.vertexLength,primitiveOffset:o.primitiveOffset,sortKey:void 0,vaos:{}};}return l&&n.segments.push(l),n}encodeCentroid(t,e){const r=t.centroid(),n=e.span(),i=Math.min(7,Math.round(n.x*this.tileToMeter/10)),s=Math.min(7,Math.round(n.y*this.tileToMeter/10));return new q(Q(r.x,1,Kr-1)<<3|i,Q(r.y,1,Kr-1)<<3|s)}encodeBorderCentroid(t){if(!t.borders)return new q(0,0);const e=t.borders,r=Number.MAX_VALUE;if(e[0][0]!==r||e[1][0]!==r){const t=e[0][0]!==r?0:1;return new q(6|(e[0][0]!==r?0:65528),(e[t][0]+e[t][1])/2<<3|6)}{const t=e[2][0]!==r?2:3;return new q((e[t][0]+e[t][1])/2<<3|6,6|(e[2][0]!==r?0:65528))}}showCentroid(t){const e=this.centroidData[t.centroidDataIndex];e.flags&=op,e.centroidXY.x=0,e.centroidXY.y=0,this.writeCentroidToBuffer(e);}writeCentroidToBuffer(t){this.groundEffect.updateHiddenByLandmark(t);const e=t.vertexArrayOffset,r=t.vertexCount+t.vertexArrayOffset,n=t.flags&op?ap:t.centroidXY,i=this.centroidVertexArray.geta_centroid_pos0(e);if(this.centroidVertexArray.geta_centroid_pos1(e)!==n.y||i!==n.x){for(let t=e;t<r;++t)this.centroidVertexArray.emplace(t,n.x,n.y);this.needsCentroidUpdate=!0;}}createCentroidsBuffer(){this.centroidVertexArray.resize(this.layoutVertexArray.length),this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const t of this.centroidData)this.writeCentroidToBuffer(t);}updateReplacement(t,e,r){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const n=e.getReplacementRegionsForTile(t.toUnwrapped());if(Yh(this.activeReplacements,n))return;if(this.activeReplacements=n,0===this.centroidVertexArray.length)this.createCentroidsBuffer();else for(const t of this.centroidData)t.flags&=2147483647;const i=[];for(const e of this.activeReplacements){if(e.order<r)continue;const n=Math.max(1,Math.pow(2,e.footprintTileId.canonical.z-t.canonical.z));for(const r of this.centroidData)if(!(r.flags&op||e.min.x>r.max.x||r.min.x>e.max.x||e.min.y>r.max.y||r.min.y>e.max.y))for(let s=0;s<r.footprintSegLen;s++){const a=this.footprintSegments[r.footprintSegIdx+s];if(i.length=0,zp(this.footprintVertices,a.vertexOffset,a.vertexCount,e.footprintTileId.canonical,t.canonical,i),Zh(e.footprint,i,this.footprintIndices.uint16,a.indexOffset,a.indexCount,-a.vertexOffset,-n)){r.flags|=op;break}}}for(const t of this.centroidData)this.writeCentroidToBuffer(t);this.borderDoneWithNeighborZ=[-1,-1,-1,-1];}footprintContainsPoint(t,e,r){let n=!1;for(let i=0;i<r.footprintSegLen;i++){const s=this.footprintSegments[r.footprintSegIdx+i];let a=0;for(const r of s.ringIndices){for(let i=a,o=r+a-1;i<r+a;o=i++){const r=this.footprintVertices.int16[2*(i+s.vertexOffset)+0],a=this.footprintVertices.int16[2*(i+s.vertexOffset)+1],l=this.footprintVertices.int16[2*(o+s.vertexOffset)+1];a>e!=l>e&&t<(this.footprintVertices.int16[2*(o+s.vertexOffset)+0]-r)*(e-a)/(l-a)+r&&(n=!n);}a=r;}}return n}getHeightAtTileCoord(t,e){let r=Number.NEGATIVE_INFINITY,n=!0;const i=4*(t+Kr)*Kr+(e+Kr);if(this.partLookup.hasOwnProperty(i)){const t=this.partLookup[i];return t?{height:t.height,hidden:!!(t.flags&op)}:void 0}for(const s of this.centroidData)t>s.max.x||s.min.x>t||e>s.max.y||s.min.y>e||this.footprintContainsPoint(t,e,s)&&s&&s.height>r&&(r=s.height,this.partLookup[i]=s,n=!!(s.flags&op));if(r!==Number.NEGATIVE_INFINITY)return {height:r,hidden:n};this.partLookup[i]=void 0;}}function bp(t,e){const r=t.add(e)._unit();return t.x*r.x+t.y*r.y}function _p(t,e,r,n){const i=e.sub(t)._perp()._unit(),s=r.sub(e)._perp()._unit();return wp(t,e,r,bp(i,s),n)}function wp(t,e,r,n,i){const s=Math.sqrt(1-n*n);return Math.min(t.dist(e)/3,e.dist(r)/3,i*s/n)}function Mp(t,e,r){return t.x<r[0].x&&e.x<r[0].x||t.x>r[1].x&&e.x>r[1].x||t.y<r[0].y&&e.y<r[0].y||t.y>r[1].y&&e.y>r[1].y}function Ap(t,e){return t.x<e[0].x||t.x>e[1].x||t.y<e[0].y||t.y>e[1].y}function Ip(t,e,r){if(t.x<0||t.x>=Kr||e.x<0||e.x>=Kr||r.x<0||r.x>=Kr)return !1;const n=r.sub(e),i=n.perp(),s=t.sub(e);return (n.x*s.x+n.y*s.y)/Math.sqrt((n.x*n.x+n.y*n.y)*(s.x*s.x+s.y*s.y))>-.866&&i.x*s.x+i.y*s.y<0}function Sp(t,e,r){const n=e?2|t:-3&t;return r?1|n:-2&n}function Pp(){const t=Math.PI/32,e=Math.tan(t),r=ol;return r*Math.sqrt(1+2*e*e)-r}function Ep(t,e,r){const n=1<<r.z,i=gl(r.x/n),s=gl((r.x+1)/n),a=xl(r.y/n),o=xl((r.y+1)/n);return function(t,e,r,n,i=0,s){const a=[];if(!t.length||!r||!n)return a;const o=(t,e)=>{for(const r of t)a.push({polygon:r,bounds:e});},l=Math.ceil(Math.log2(r)),u=Math.ceil(Math.log2(n)),c=l-u,h=[];for(let t=0;t<Math.abs(c);t++)h.push(c>0?0:1);for(let t=0;t<Math.min(l,u);t++)h.push(0),h.push(1);let p=t;if(p=Fh(p,e[0].y-i,e[1].y+i,1),p=Fh(p,e[0].x-i,e[1].x+i,0),!p.length)return a;const f=[];for(h.length?f.push({polygons:p,bounds:e,depth:0}):o(p,e);f.length;){const t=f.pop(),e=t.depth,r=h[e],n=t.bounds[0],a=t.bounds[1],l=0===r?n.x:n.y,u=0===r?a.x:a.y,c=s?s(r,l,u):.5*(l+u),p=Fh(t.polygons,l-i,c+i,r),d=Fh(t.polygons,c-i,u+i,r);if(p.length){const t=[n,new q(0===r?c:a.x,1===r?c:a.y)];h.length>e+1?f.push({polygons:p,bounds:t,depth:e+1}):o(p,t);}if(d.length){const t=[new q(0===r?c:n.x,1===r?c:n.y),a];h.length>e+1?f.push({polygons:d,bounds:t,depth:e+1}):o(d,t);}}return a}(t,e,Math.ceil((s-i)/11.25),Math.ceil((a-o)/11.25),1,((t,e,i)=>{if(0===t)return .5*(e+i);{const t=xl((r.y+e/Kr)/n);return (ml(.5*(xl((r.y+i/Kr)/n)+t))*n-r.y)*Kr}}))}function zp(t,e,r,n,i,s){const a=Math.pow(2,n.z-i.z);for(let o=0;o<r;o++){let r=t.int16[2*(o+e)+0],l=t.int16[2*(o+e)+1];r=(r+i.x*Kr)*a-n.x*Kr,l=(l+i.y*Kr)*a-n.y*Kr,s.push(new q(r,l));}}let kp,Tp;function Bp(t,e){return t.x*e.x+t.y*e.y}function Vp(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=Bp(o,o),h=Bp(o,l),p=Bp(l,l),f=Bp(u,o),d=Bp(u,l),m=c*p-h*h,y=(p*f-h*d)/m,g=(c*d-h*f)/m,x=n.z*(1-y-g)+i.z*y+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Cp(t,e,r,n,i,s,a,o){const l=a*i.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?a*(s[0]/7-450):a*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),s=10*(e[0]-8*n),a=10*(e[1]-8*i),o=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(a*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,f=2*c+1,d=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,f),m=Math.abs(d[0]-d[1]),y=Math.abs(d[2]-d[3]),g=Math.abs(d[0]-d[2])+Math.abs(d[1]-d[3]),x=Math.min(.25,.5*l*(m+y)/p),v=Math.min(.25,.5*l*g/f);return o+Math.max(x*s,v*a)}(i,s,o):l;return {base:l+(0===r?-1:r),top:u?Math.max(c+n,l+r+2):l+n}}us(vp,"FillExtrusionBucket",{omit:["layers","features"]}),us(fp,"PartData"),us(pp,"FootprintSegment"),us(dp,"BorderCentroidData"),us(xp,"GroundEffect");const Dp=va([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),Rp=va([{name:"a_z_offset_width",components:3,type:"Float32"}],4),{members:Lp}=Dp,Fp=va([{name:"a_packed",components:3,type:"Float32"}]),{members:Op}=Fp,Np=va([{name:"a_pattern_data",components:3,type:"Float32"}]),{members:Up}=Np;class jp{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new hc({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=at(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,s=t[0]*r,a=!0;n.push({left:i,right:s,isDash:a,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){a=!a;const l=t[e];i=o*r,o+=l,s=o*r,n.push({left:i,right:s,isDash:a,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let s=0,a=t[s];for(let o=0;o<this.width;o++){o/a.right>1&&(a=t[++s]);const l=Math.abs(o-a.left),u=Math.abs(o-a.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(a.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+o]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let s=0,a=t[s];for(let r=0;r<this.width;r++){r/a.right>1&&(a=t[++s]);const n=Math.abs(r-a.left),o=Math.abs(r-a.right),l=Math.min(n,o);this.image.data[i+r]=Math.max(0,Math.min(255,(a.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,s=2*i+1;if(this.nextRow+s>this.height)return pt("LineAtlas out of space"),null;0===t.length&&t.push(1);let a=0;for(let e=0;e<t.length;e++)t[e]<0&&(pt("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),a+=t[e];if(0!==a){const r=this.width/a,s=this.getDashRanges(t,this.width,r);n?this.addRoundDash(s,r,i):this.addRegularDash(s,"square"===e?.5*r:0);}const o=this.nextRow+i;this.nextRow+=s;const l={tl:[o,i],br:[a,0]};return this.positions[r]=l,l}}us(jp,"LineAtlas");const qp=ah.VectorTileFeature.types,$p=Math.cos(Math.PI/180*37.5),Gp=Math.cos(Math.PI/180*5);class Yp{constructor(t){this.evaluationGlobals={zoom:0,lineProgress:void 0},this.zoom=t.zoom,this.evaluationGlobals.zoom=this.zoom,this.overscaling=t.overscaling,this.pixelRatio=t.pixelRatio,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.projection=t.projection,this.hasPattern=!1,this.hasZOffset=!1,this.hasCrossSlope=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new Ea,this.layoutVertexArray2=new za,this.patternVertexArray=new za,this.indexArray=new ja,this.programConfigurations=new Go(t.layers,{zoom:t.zoom,lut:t.lut}),this.segments=new xo,this.maxLineLength=0,this.zOffsetVertexArray=new za,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.tessellationStep=t.tessellationStep?t.tessellationStep:Kr/64;}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Hc("line",this.layers,this.pixelRatio,e);const i=this.layers[0].layout.get("line-sort-key");this.tileToMeter=Al(r);const s=this.layers[0].layout.get("line-z-offset"),a=s.isConstant()&&!s.constantOr(0),o=this.layers[0].layout.get("line-elevation-reference");this.hasZOffset="sea"===o||"ground"===o||!a&&"none"===o,this.hasZOffset&&"none"===o&&pt(`line-elevation-reference: ground is used for the layer ${this.layerIds[0]} because non-zero line-z-offset value was found.`);const l=this.layers[0].layout.get("line-cross-slope");this.hasCrossSlope=this.hasZOffset&&void 0!==l;const u=[];for(const{feature:e,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Cl(e,t);if(!this.layers[0]._featureFilter.filter(new Rs(this.zoom),l,r))continue;const c=i?i.evaluate(l,{},r):void 0,h={id:s,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Vl(e,r,n),patterns:{},sortKey:c};u.push(h);}i&&u.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:c,featureIndex:h}=e,p=this.addConstantDashes(c);for(const n of u){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(p&&this.addFeatureDashes(n,c),this.hasPattern){const t=Xc("line",this.layers,n,this.zoom,this.pixelRatio,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,c.positions,e.availableImages,e.brightness);h.insert(t[s].feature,i,s,a,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,s=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===s.kind)continue;let a,o;if("constant"===i.kind){if(a=i.value,!a)continue}else a=i.evaluate({zoom:r},t);o="constant"===s.kind?s.value:s.evaluate({zoom:r},t),e.addDash(a,o),t.patterns[n.id]=e.getKey(a,o);}}update(t,e,r,n,i,s,a){this.programConfigurations.updatePaintArrays(t,e,i,r,n,s,a);}addFeatures(t,e,r,n,i,s){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n,s);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Op)),0!==this.patternVertexArray.length&&(this.patternVertexBuffer=t.createVertexBuffer(this.patternVertexArray,Up)),!this.zOffsetVertexBuffer&&this.zOffsetVertexArray.length>0&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,Rp.members,!0)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Lp),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s,a){const o=this.layers[0].layout,l=o.get("line-join").evaluate(t,{}),u=o.get("line-cap").evaluate(t,{}),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t),this.lineFeature=t,this.zOffsetValue=o.get("line-z-offset").value;const p=this.layers[0].paint.get("line-width").value;"constant"!==p.kind&&!1===p.isLineProgressConstant&&(this.variableWidthValue=p);for(const r of e)this.addLine(r,t,n,l,u,c,h);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,a);}addLine(t,e,r,n,i,s,a){this.distance=0,this.prevDistance=0,this.scaledDistance=0,this.totalDistance=0,this.totalFeatureLength=0,this.lineSoFar=0,this.currentVertex=void 0;const o="none"===n;if(this.patternJoinNone=this.hasPattern&&o,this.segmentStart=0,this.segmentStartf32=0,this.segmentPoints=[],this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.totalFeatureLength=this.totalDistance/(this.lineClips.end-this.lineClips.start),this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const l="Polygon"===qp[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===n&&(s=1.05);const h=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let p,f,d,m,y,g;this.e1=this.e2=-1,l&&(p=t[u-2],y=t[c].sub(p)._unit()._perp());for(let e=c;e<u;e++){if(d=e===u-1?l?t[c+1]:void 0:t[e+1],d&&t[e].equals(d))continue;y&&(m=y),p&&(f=p),p=t[e],g=this.evaluateLineProgressFeatures(f?f.dist(p):0),y=d?d.sub(p)._unit()._perp():m,m=m||y;const r=f&&d;let x=r?n:l||o?"butt":i;const v=m.x*y.x+m.y*y.y;if(o){const t=function(t){if(t.patternJoinNone){const e=t.segmentPoints.length/2,r=t.lineSoFar-t.segmentStart;for(let n=0;n<e;++n){const e=t.segmentPoints[2*n+1],i=Math.round(t.segmentPoints[2*n])+.5+.25*e;t.patternVertexArray.emplaceBack(i,r,t.segmentStart),t.patternVertexArray.emplaceBack(i,r,t.segmentStart);}t.segmentPoints.length=0;}t.e1=t.e2=-1;};if(r&&v<Gp){this.updateDistance(f,p),this.addCurrentVertex(p,m,1,1,h,g),t(this),this.addCurrentVertex(p,y,-1,-1,h,g);continue}if(f){if(!d){this.updateDistance(f,p),this.addCurrentVertex(p,m,1,1,h,g),t(this);continue}x="miter";}}let b=m.add(y);0===b.x&&0===b.y||b._unit();const _=b.x*y.x+b.y*y.y,w=0!==_?1/_:1/0,M=2*Math.sqrt(2-2*_),A=_<$p&&f&&d,I=m.x*y.y-m.y*y.x>0,S=this.overscaling<=16?15*Kr/(512*this.overscaling):0;if(r&&"round"===x)if(w<a)x="miter";else if(w<=2){const t=Hp(p,-10,Kr+10);x=this.hasZOffset&&(t||this.hasCrossSlope)?"miter":"fakeround";}if("miter"===x&&w>s&&(x="bevel"),"bevel"===x&&(w>2&&(x="flipbevel"),w<s&&(x="miter")),f&&!("miter"===x&&A)&&this.updateDistance(f,p),"miter"===x)if(A){const t=p.dist(f);if(t>2*S){const e=p.sub(p.sub(f)._mult(S/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,m,0,0,h,g),f=e;}this.updateDistance(f,p),b._mult(w),this.addCurrentVertex(p,b,0,0,h,g);const e=p.dist(d);if(e>2*S){const t=p.add(d.sub(p)._mult(S/e)._round());this.updateDistance(p,t),this.addCurrentVertex(t,y,0,0,h,g),p=t;}}else b._mult(w),this.addCurrentVertex(p,b,0,0,h,g);else if("flipbevel"===x){if(w>100)b=y.mult(-1);else {const t=w*m.add(y).mag()/m.sub(y).mag();b._perp()._mult(t*(I?-1:1));}this.addCurrentVertex(p,b,0,0,h,g),this.addCurrentVertex(p,b.mult(-1),0,0,h,g);}else if("bevel"===x||"fakeround"===x){null!=g&&f&&this.addCurrentVertex(p,m,-1,-1,h,g);const t=p.dist(f)<=2*S&&"bevel"!==x,e=b.mult(I?1:-1);e._mult(w);const r=y.mult(I?-1:1),n=m.mult(I?-1:1),i=this.evaluateLineProgressFeatures(this.distance);if(null==g&&(this.addHalfVertex(p,e.x,e.y,!1,!I,0,h,i),t||this.addHalfVertex(p,e.x+2*n.x,e.y+2*n.y,!1,I,0,h,i)),"fakeround"===x){const t=Math.round(180*M/Math.PI/20);this.addHalfVertex(p,n.x,n.y,!1,I,0,h,i);for(let e=0;e<t;e++){let s=e/t;if(.5!==s){const t=s-.5;s+=s*t*(s-1)*((1.0904+v*(v*(3.55645-1.43519*v)-3.2452))*t*t+(.848013+v*(.215638*v-1.06021)));}const a=r.sub(n)._mult(s)._add(n)._unit();this.addHalfVertex(p,a.x,a.y,!1,I,0,h,i);}this.addHalfVertex(p,r.x,r.y,!1,I,0,h,i);}t||null!=g||this.addHalfVertex(p,e.x+2*r.x,e.y+2*r.y,!1,I,0,h,i),null!=g&&d&&this.addCurrentVertex(p,y,1,1,h,g);}else "butt"===x?this.addCurrentVertex(p,b,0,0,h,g):"square"===x?(f||this.addCurrentVertex(p,b,-1,-1,h,g),this.addCurrentVertex(p,b,0,0,h,g),f&&this.addCurrentVertex(p,b,1,1,h,g)):"round"===x&&(f&&(this.addCurrentVertex(p,m,0,0,h,g),this.addCurrentVertex(p,m,1,1,h,g,!0)),d&&(this.addCurrentVertex(p,y,-1,-1,h,g,!0),this.addCurrentVertex(p,y,0,0,h,g)));}}addVerticesTo(t,e,r,n,i,s,a,o,l,u){const c=(e.w-t.w)/this.tessellationStep|0;let h=0;const p=this.scaledDistance;if(c>1){this.lineSoFar=t.w;const p=(e.x-t.x)/c,f=(e.y-t.y)/c,d=(e.z-t.z)/c,m=(e.w-t.w)/c;for(let e=1;e<c;++e){t.x+=p,t.y+=f,t.z+=d,this.lineSoFar+=m,h+=m;const e=this.evaluateLineProgressFeatures(this.prevDistance+h);this.scaledDistance=(this.prevDistance+h)/this.totalDistance,this.addHalfVertex(t,r,n,u,!1,a,l,e),this.addHalfVertex(t,i,s,u,!0,-o,l,e);}}this.lineSoFar=e.w,this.scaledDistance=p;const f=this.evaluateLineProgressFeatures(this.distance);this.addHalfVertex(e,r,n,u,!1,a,l,f),this.addHalfVertex(e,i,s,u,!0,-o,l,f);}evaluateLineProgressFeatures(t){if(!this.variableWidthValue&&!this.hasZOffset)return null;this.evaluationGlobals.lineProgress=0,this.lineClips?this.evaluationGlobals.lineProgress=Math.min(1,(this.totalFeatureLength*this.lineClips.start+t)/this.totalFeatureLength):pt(`line-progress evaluation for ${this.layerIds[0]} requires enabling 'lineMetrics' for the source.`);let e=0;return this.variableWidthValue&&"constant"!==this.variableWidthValue.kind&&(e=this.variableWidthValue.evaluate(this.evaluationGlobals,this.lineFeature)||0),this.hasZOffset?"constant"===this.zOffsetValue.kind?{zOffset:this.zOffsetValue.value,variableWidth:e}:{zOffset:this.zOffsetValue.evaluate(this.evaluationGlobals,this.lineFeature)||0,variableWidth:e}:{zOffset:0,variableWidth:e}}addCurrentVertex(t,e,r,n,i,s,a=!1){const o=e.x+e.y*r,l=e.y-e.x*r,u=e.y*n-e.x,c=-e.y-e.x*n;if(null!=s){const e=this.hasZOffset,h=-10,p=Kr+10,f=s.zOffset,d=new Lh(t.x,t.y,f,this.lineSoFar),m=!!e&&Hp(t,h,p),y=this.lineSoFar,g=this.distance;if(this.currentVertex)if(m){const e=this.currentVertexIsOutside,s=this.currentVertex,m=new Lh(t.x,t.y,f,this.lineSoFar);if(Nh(s,m,h,p),!Hp(m,h,p)){if(e){this.e1=this.e2=-1,this.distance-=s.dist(d),this.lineSoFar=s.w;const t=this.evaluateLineProgressFeatures(s.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(s,o,l,a,!1,r,i,t),this.addHalfVertex(s,u,c,a,!0,-n,i,t),this.prevDistance=this.distance;}this.distance=this.prevDistance+s.dist(m),this.scaledDistance=this.distance/this.totalDistance,this.addVerticesTo(s,m,o,l,u,c,r,n,i,a),this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}}else {const t=this.currentVertex;if(this.currentVertexIsOutside){Nh(t,d,h,p),this.e1=this.e2=-1,this.distance-=t.dist(d),this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t.w;const e=this.evaluateLineProgressFeatures(t.w-this.totalFeatureLength*(this.lineClips?this.lineClips.start:0));this.addHalfVertex(t,o,l,a,!1,r,i,e),this.addHalfVertex(t,u,c,a,!0,-n,i,e),this.prevDistance=this.distance,this.distance=g,this.scaledDistance=this.distance/this.totalDistance;}this.addVerticesTo(t,d,o,l,u,c,r,n,i,a);}else m||(this.addHalfVertex(t,o,l,a,!1,r,i,s),this.addHalfVertex(t,u,c,a,!0,-n,i,s));this.currentVertex=d,this.currentVertexIsOutside=m,this.lineSoFar=y;}else this.addHalfVertex(t,o,l,a,!1,r,i,s),this.addHalfVertex(t,u,c,a,!0,-n,i,s);}addHalfVertex({x:t,y:e},r,n,i,s,a,o,l){if(this.patternJoinNone&&(0===this.segmentPoints.length&&(this.segmentStart=this.lineSoFar,this.segmentStartf32=Math.fround(this.lineSoFar)),s||this.segmentPoints.push(this.lineSoFar-this.segmentStart,a)),this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar-this.segmentStartf32),this.lineClips){const t=Ee(this.lineClips.start,this.lineClips.end,this.scaledDistance);this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,t);}const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u),o.primitiveLength++),s?this.e2=u:this.e1=u,null!=l&&this.zOffsetVertexArray.emplaceBack(l.zOffset,l.variableWidth,l.variableWidth);}updateScaledDistance(){this.lineClips?(this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=this.totalFeatureLength*this.lineClips.start+this.distance):this.lineSoFar=this.distance;}updateDistance(t,e){this.prevDistance=this.distance,this.distance+=t.dist(e),this.updateScaledDistance();}}function Hp(t,e,r){return t.x<e||t.x>r||t.y<e||t.y>r}let Xp,Zp;function Wp(t,e,r){return e*(Kr/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}us(Yp,"LineBucket",{omit:["layers","patternFeatures","currentVertex","currentVertexIsOutside"]});const Kp=(t,e,r)=>(1-r)*t+r*e;function Jp(t,e){return 1/Wp(t,1,e.tileZoom)}function Qp(t,e,r,n){return t.translatePosMatrix(n||e.tileID.projMatrix,e,r.paint.get("line-translate"),r.paint.get("line-translate-anchor"))}const tf=t=>{const e=[];ef(t)&&e.push("RENDER_LINE_DASH"),t.paint.get("line-gradient")&&e.push("RENDER_LINE_GRADIENT");const r=t.paint.get("line-trim-offset");0===r[0]&&0===r[1]||e.push("RENDER_LINE_TRIM_OFFSET"),0!==t.paint.get("line-border-width").constantOr(1)&&e.push("RENDER_LINE_BORDER");const n="none"===t.layout.get("line-join").constantOr("miter"),i=!!t.paint.get("line-pattern").constantOr(1);return n&&i&&e.push("LINE_JOIN_NONE"),e};function ef(t){const e=t.paint.get("line-dasharray").value;return e.value||"constant"!==e.kind}let rf;const nf=()=>rf||(rf={layout:Xp||(Xp=new Xs({"line-cap":new Ys(Zs.layout_line["line-cap"]),"line-join":new Ys(Zs.layout_line["line-join"]),"line-miter-limit":new Gs(Zs.layout_line["line-miter-limit"]),"line-round-limit":new Gs(Zs.layout_line["line-round-limit"]),"line-sort-key":new Ys(Zs.layout_line["line-sort-key"]),"line-z-offset":new Ys(Zs.layout_line["line-z-offset"]),"line-elevation-reference":new Gs(Zs.layout_line["line-elevation-reference"]),"line-cross-slope":new Gs(Zs.layout_line["line-cross-slope"]),visibility:new Gs(Zs.layout_line.visibility),"line-width-unit":new Gs(Zs.layout_line["line-width-unit"])})),paint:Zp||(Zp=new Xs({"line-opacity":new Ys(Zs.paint_line["line-opacity"]),"line-color":new Ys(Zs.paint_line["line-color"]),"line-translate":new Gs(Zs.paint_line["line-translate"]),"line-translate-anchor":new Gs(Zs.paint_line["line-translate-anchor"]),"line-width":new Ys(Zs.paint_line["line-width"]),"line-gap-width":new Ys(Zs.paint_line["line-gap-width"]),"line-offset":new Ys(Zs.paint_line["line-offset"]),"line-blur":new Ys(Zs.paint_line["line-blur"]),"line-dasharray":new Ys(Zs.paint_line["line-dasharray"]),"line-pattern":new Ys(Zs.paint_line["line-pattern"]),"line-gradient":new Hs(Zs.paint_line["line-gradient"]),"line-trim-offset":new Gs(Zs.paint_line["line-trim-offset"]),"line-trim-fade-range":new Gs(Zs.paint_line["line-trim-fade-range"]),"line-trim-color":new Gs(Zs.paint_line["line-trim-color"]),"line-emissive-strength":new Gs(Zs.paint_line["line-emissive-strength"]),"line-border-width":new Ys(Zs.paint_line["line-border-width"]),"line-border-color":new Ys(Zs.paint_line["line-border-color"]),"line-occlusion-opacity":new Gs(Zs.paint_line["line-occlusion-opacity"]),"line-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"line-gradient-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"line-trim-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"line-border-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},rf);class sf extends Ys{possiblyEvaluate(t,e){return e=new Rs(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=nt({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let af;function of(t,e){return e>0?e+2*t:t}const lf=va([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),uf=va([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),cf=va([{name:"a_projected_pos",components:4,type:"Float32"}],4);va([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const hf=va([{name:"a_auto_z_offset",components:1,type:"Float32"}],4),pf=va([{name:"a_texb",components:2,type:"Uint16"}]),ff=va([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_elevation_from_sea",components:2,type:"Float32"}]),df=va([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"},{name:"a_auto_z_offset",components:1,type:"Float32"}]);va([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const mf=va([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),yf=va([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);va([{name:"triangle",components:3,type:"Uint16"}]),va([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),va([{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Float32",name:"zOffset"},{type:"Uint8",name:"hasIconTextFit"},{type:"Uint16",name:"elevationFeatureIndex"}]),va([{type:"Float32",name:"offsetX"}]),va([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);var gf=24;const xf=128;function vf(t,e,r,n,i){if("camera"===t.kind)return t.maxSize;if("composite"===t.kind){const n=e.possiblyEvaluate(new Rs(t.maxZoom),r).evaluate(i,{},r),s=e.possiblyEvaluate(new Rs(t.minZoom),r).evaluate(i,{},r);return Math.max(n,s)}return e.possiblyEvaluate(new Rs(n)).evaluate(i,{},r)}function bf(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Rs(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new Rs(a)),maxSize:r.evaluate(new Rs(o)),interpolationType:n}}}function _f(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/xf:"composite"===t.kind?Ee(n/xf,i/xf,r):e}function wf(t,e,r=1){let n=0,i=0;if("constant"===t.kind)i=t.layoutSize*r;else if("source"!==t.kind){const{interpolationType:s,minZoom:a,maxZoom:o}=t,l=s?Q(ai.interpolationFactor(s,e,a,o),0,1):0;"camera"===t.kind?i=Ee(t.minSize,t.maxSize,l)*r:n=l*r;}return {uSizeT:n,uSize:i}}var Mf=Object.freeze({__proto__:null,SIZE_PACK_FACTOR:xf,evaluateSizeForFeature:_f,evaluateSizeForZoom:wf,getRasterizedIconSize:vf,getSizeData:bf});function Af(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ds.applyArabicShaping&&(t=Ds.applyArabicShaping(t)),t}(t.text,e,r);})),t}const If={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};function Sf(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function Pf(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}var Ef,zf,kf,Tf={};
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */function Bf(){return Ef||(Ef=1,Tf.read=function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(f?-1:1);a+=Math.pow(2,n),s-=u;}return (f?-1:1)*a*Math.pow(2,s-n)},Tf.write=function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+f]=255&a,f+=d,a/=256,u-=8);t[r+f-d]|=128*m;}),Tf}function Vf(){if(kf)return zf;kf=1,zf=e;var t=Bf();function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var r=4294967296,n=1/r,i="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function s(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function a(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function o(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function l(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function u(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function c(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function h(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function p(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function f(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function d(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function m(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function y(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function g(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function x(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function v(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=g(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=v(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=g(this.buf,this.pos)+g(this.buf,this.pos+4)*r;return this.pos+=8,t},readSFixed64:function(){var t=g(this.buf,this.pos)+v(this.buf,this.pos+4)*r;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return a(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return a(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&i?function(t,e,r){return i.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,r){if(this.type!==e.Bytes)return t.push(this.readVarint(r));var n=s(this);for(t=t||[];this.pos<n;)t.push(this.readVarint(r));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed64());return t},skip:function(t){var r=7&t;if(r===e.Varint)for(;this.buf[this.pos++]>127;);else if(r===e.Bytes)this.pos=this.readVarint()+this.pos;else if(r===e.Fixed32)this.pos+=4;else {if(r!==e.Fixed64)throw new Error("Unimplemented type: "+r);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&o(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&o(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,r,n){this.writeTag(t,e.Bytes),this.writeRawMessage(r,n);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,l,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,u,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,p,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,c,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,h,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,f,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,d,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,m,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,y,e);},writeBytesField:function(t,r){this.writeTag(t,e.Bytes),this.writeBytes(r);},writeFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeFixed32(r);},writeSFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeSFixed32(r);},writeFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeFixed64(r);},writeSFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeSFixed64(r);},writeVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeVarint(r);},writeSVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeSVarint(r);},writeStringField:function(t,r){this.writeTag(t,e.Bytes),this.writeString(r);},writeFloatField:function(t,r){this.writeTag(t,e.Fixed32),this.writeFloat(r);},writeDoubleField:function(t,r){this.writeTag(t,e.Fixed64),this.writeDouble(r);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}},zf}var Cf=e(Vf());const Df=3;function Rf(t,e,r){e.glyphs=[],1===t&&r.readMessage(Lf,e);}function Lf(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Ff,{});e.glyphs.push({id:t,bitmap:new hc({width:i+2*Df,height:s+2*Df},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function Ff(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const Of=Df,Nf={horizontal:1,vertical:2,horizontalOnly:3};class Uf{constructor(){this.scale=1,this.fontStack="",this.image=null;}static forText(t,e){const r=new Uf;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new Uf;return e.image=t,e}}class jf{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e,r){const n=new jf;for(let i=0;i<t.sections.length;i++){const s=t.sections[i];s.image?n.addImageSection(s,r):n.addTextSection(s,e);}return n}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCodePoint(t){return this.text.codePointAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,s=t.charCodeAt(n-1)||null;r+=!e&&(i&&vs(i)&&!If[t[n+1]]||s&&vs(s)&&!If[t[n-1]])||!If[t[n]]?t[n]:If[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&$f[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&$f[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new jf;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(Uf.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t,e){const r=t.image?t.image.getPrimary():null;if(!r)return void pt("Can't add FormattedSection with an empty image.");r.scaleSelf(e);const n=this.getNextImageSectionCharCode();n?(this.text+=String.fromCodePoint(n),this.sections.push(Uf.forImage(r)),this.sectionIndex.push(this.sections.length-1)):pt("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function qf(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m=1){const y=jf.fromFeature(t,i,m);h===Nf.vertical&&y.verticalizePunctuation(p);let g=[];const x=function(t,e,r,n,i,s){if(!t)return [];const a=[],o=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=Yf(t.getCodePoint(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCodePoint(r);if($f[p]||(u+=Yf(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904||!(ds["Bopomofo Extended"](c)||ds.Bopomofo(c)||ds["CJK Compatibility Forms"](c)||ds["CJK Compatibility Ideographs"](c)||ds["CJK Compatibility"](c)||ds["CJK Radicals Supplement"](c)||ds["CJK Strokes"](c)||ds["CJK Symbols and Punctuation"](c)||ds["CJK Unified Ideographs Extension A"](c)||ds["CJK Unified Ideographs"](c)||ds["Enclosed CJK Letters and Months"](c)||ds["Halfwidth and Fullwidth Forms"](c)||ds.Hiragana(c)||ds["Ideographic Description Characters"](c)||ds["Kangxi Radicals"](c)||ds["Katakana Phonetic Extensions"](c)||ds.Katakana(c)||ds["Vertical Forms"](c)||ds["Yi Radicals"](c)||ds["Yi Syllables"](c)));(Gf[p]||e||h.image)&&a.push(Zf(r+1,u,o,a,Xf(p,t.getCodePoint(r+1),e&&l),!1));}}var c;return Wf(Zf(t.length(),u,o,a,0,!0))}(y,u,s,e,n,f),{processBidirectionalText:v,processStyledBidirectionalText:b}=Ds;if(v&&1===y.sections.length){const t=v(y.toString(),x);for(const e of t){const t=new jf;t.text=e,t.sections=y.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(b){const t=b(y.text,y.sectionIndex,x);for(const e of t){const t=new jf;t.text=e[0],t.sectionIndex=e[1],t.sections=y.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(y,x);const _=[],w={positionedLines:_,text:y.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};if(function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,f=0,d=0;const m="right"===o?1:"left"===o?0:.5;let y=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.image)continue;const r=e[t.fontStack];if(r&&(y=void 0!==r.ascender&&void 0!==r.descender,!y))break}if(!y)break}let g=0;for(const a of i){a.trim();const i=a.getMaxScale(),o=(i-1)*gf,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let _=0;if(!a.length()){f+=s,++g;continue}let w=0,M=0;for(let s=0;s<a.length();s++){const o=a.getSection(s),d=a.getSectionIndex(s),m=a.getCodePoint(s);let g=o.scale,v=null,A=null,I=null,S=gf,P=0;l===Nf.vertical&&(12312===(x=m)||12313===x||12316===x||12540===x||12448===x)&&(l=Nf.horizontal);const E=!(l===Nf.horizontal||!c&&!xs(m)||c&&($f[m]||bs(m)));if(o.image){const e=n.get(o.image.toString());if(!e)continue;I=o.image,t.iconsInText=t.iconsInText||!0,A=e.paddedRect;const r=e.displaySize;g=g*gf/h,v={width:r[0],height:r[1],left:0,top:-Of,advance:E?r[1]:r[0],localGlyph:!1},P=y?-v.height*g:i*gf-17-r[1]*g,S=v.advance;const s=(E?r[0]:r[1])*g-gf*i;s>0&&s>_&&(_=s);}else {const t=r[o.fontStack];if(!t)continue;t[m]&&(A=t[m]);const n=e[o.fontStack];if(!n)continue;const s=n.glyphs[m];if(!s)continue;if(v=s.metrics,S=8203!==m?gf:0,y){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;w<r&&(w=r,M=(t-e)/2*g),P=-t*g;}else P=(i-g)*gf-17;}E?(t.verticalizable=!0,b.push({glyph:m,image:I,x:p,y:f+P,vertical:E,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:A}),p+=S*g+u):(b.push({glyph:m,image:I,x:p,y:f+P,vertical:E,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:A}),p+=v.advance*g+u);}0!==b.length&&(d=Math.max(p-u,d),y?Jf(b,m,_,M,s*i/2):Jf(b,m,_,0,s/2)),p=0;const A=s*i+_;v.lineOffset=Math.max(_,o),f+=A,++g;}var x;const v=f,{horizontalAlign:b,verticalAlign:_}=Kf(a);((function(t,e,r,n,i,s){const a=(e-r)*i,o=-s*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=a,t.y+=o;}))(t.positionedLines,m,b,_,d,v),t.top+=-_*v,t.bottom=t.top+v,t.left+=-b*d,t.right=t.left+d,t.hasBaseline=y;}(w,e,r,n,g,a,o,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(_))return w}const $f={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Gf={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Yf(t,e,r,n,i,s){if(e.image){const t=n.get(e.image.toString());return t?t.displaySize[0]*e.scale*gf/s+i:0}{const n=r[e.fontStack],s=n&&n.glyphs[t];return s?s.metrics.advance*e.scale+i:0}}function Hf(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Xf(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Zf(t,e,r,n,i,s){let a=null,o=Hf(e,r,i,s);for(const t of n){const n=Hf(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function Wf(t){return t?Wf(t.priorBreak).concat(t.index):[]}function Kf(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function Jf(t,e,r,n,i){if(!(e||r||n||i))return;const s=t.length-1,a=t[s],o=(a.x+a.metrics.advance*a.scale)*e;for(let e=0;e<=s;e++)t[e].x-=o,t[e].y+=r+n+i;}function Qf(t,e,r,n){const{horizontalAlign:i,verticalAlign:s}=Kf(n),a=r[0]-t.displaySize[0]*i,o=r[1]-t.displaySize[1]*s;return {imagePrimary:t,imageSecondary:e,top:o,bottom:o+t.displaySize[1],left:a,right:a+t.displaySize[0]}}function td(t,e,r,n,i,s){const a=t.imagePrimary;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,m=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+m+n[2]):(c=i[1]+(d+m-a.displaySize[1])/2,p=c+a.displaySize[1]),{imagePrimary:a,imageSecondary:void 0,top:c,right:h,bottom:p,left:f,collisionPadding:o}}class ed extends q{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new ed(this.x,this.y,this.z,this.angle,this.segment)}}function rd(t,e,r,n,i){if(void 0===e.segment)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function nd(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function id(t,e,r){return t?.6*e*r:0}function sd(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function ad(t,e,r,n,i,s){const a=id(r,i,s),o=sd(r,n)*s;let l=0;const u=nd(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=Ee(n.x,i.x,c),p=Ee(n.y,i.y,c),f=new ed(h,p,0,i.angleTo(n),r);return !a||rd(t,f,o,a,e)?f:void 0}l+=s;}}function od(t,e,r,n,i,s,a,o,l){const u=id(n,s,a),c=sd(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),ld(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function ld(t,e,r,n,i,s,a,o,l){const u=s/2,c=nd(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),m=o.angleTo(a);for(;p+r<h+d;){p+=r;const y=(p-h)/d,g=Ee(a.x,o.x,y),x=Ee(a.y,o.y,y);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new ed(g,x,0,m,e);n&&!rd(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=ld(t,h/2,r,n,i,s,a,!0,l)),f}function ud(t,e,r,n,i){const s=[];for(let a=0;a<t.length;a++){const o=t[a];let l;for(let t=0;t<o.length-1;t++){let a=o[t],u=o[t+1];a.x<e&&u.x<e||(a.x<e?a=new q(e,a.y+(e-a.x)/(u.x-a.x)*(u.y-a.y))._round():u.x<e&&(u=new q(e,a.y+(e-a.x)/(u.x-a.x)*(u.y-a.y))._round()),a.y<r&&u.y<r||(a.y<r?a=new q(a.x+(r-a.y)/(u.y-a.y)*(u.x-a.x),r)._round():u.y<r&&(u=new q(a.x+(r-a.y)/(u.y-a.y)*(u.x-a.x),r)._round()),a.x>=n&&u.x>=n||(a.x>=n?a=new q(n,a.y+(n-a.x)/(u.x-a.x)*(u.y-a.y))._round():u.x>=n&&(u=new q(n,a.y+(n-a.x)/(u.x-a.x)*(u.y-a.y))._round()),a.y>=i&&u.y>=i||(a.y>=i?a=new q(a.x+(i-a.y)/(u.y-a.y)*(u.x-a.x),i)._round():u.y>=i&&(u=new q(a.x+(i-a.y)/(u.y-a.y)*(u.x-a.x),i)._round()),l&&a.equals(l[l.length-1])||(l=[a],s.push(l)),l.push(u)))));}}return s}function cd(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}us(ed,"Anchor");const hd=1;class pd{static getImagePositionScale(t,e,r){if(e&&t&&t.options&&t.options.transform){const e=t.options.transform;return {x:e.a,y:e.d}}return {x:r,y:r}}constructor(t,e,r,n){this.paddedRect=t;const{pixelRatio:i,version:s,stretchX:a,stretchY:o,content:l,sdf:u,usvg:c}=e;this.pixelRatio=i,this.stretchX=a,this.stretchY=o,this.content=l,this.version=s,this.padding=r,this.sdf=u,this.scale=pd.getImagePositionScale(n,c,i);}get tl(){return [this.paddedRect.x+this.padding,this.paddedRect.y+this.padding]}get br(){return [this.paddedRect.x+this.paddedRect.w-this.padding,this.paddedRect.y+this.paddedRect.h-this.padding]}get displaySize(){return [(this.paddedRect.w-2*this.padding)/this.scale.x,(this.paddedRect.h-2*this.padding)/this.scale.y]}}function fd(t,e,r){const n=tr.parse(t),i=function(t,e,r=[1,1]){return {x:0,y:0,w:(t.data?t.data.width:t.width*r[0])+2*e,h:(t.data?t.data.height:t.height*r[1])+2*e}}(e,r,[n.options.transform.a,n.options.transform.d]);return {bin:i,imagePosition:new pd(i,e,r,n),imageVariant:n}}class dd{constructor(t,e,r){const n=new Map,i=new Map;this.haveRenderCallbacks=[];const s=[];this.addImages(t,n,hd,s),this.addImages(e,i,2,s);const{w:a,h:o}=cd(s),l=new pc({width:a||1,height:o||1});for(const[e,i]of t.entries()){const t=n.get(e).paddedRect;pc.copy(i.data,l,{x:0,y:0},{x:t.x+hd,y:t.y+hd},i.data,r,i.sdf);}for(const[t,n]of e.entries()){const e=i.get(t),s=e.paddedRect;let a=e.padding;const o=s.x+a,u=s.y+a,c=n.data.width,h=n.data.height;a=a>1?a-1:a,pc.copy(n.data,l,{x:0,y:0},{x:o,y:u},n.data,r),pc.copy(n.data,l,{x:0,y:h-a},{x:o,y:u-a},{width:c,height:a},r),pc.copy(n.data,l,{x:0,y:0},{x:o,y:u+h},{width:c,height:a},r),pc.copy(n.data,l,{x:c-a,y:0},{x:o-a,y:u},{width:a,height:h},r),pc.copy(n.data,l,{x:0,y:0},{x:o+c,y:u},{width:a,height:h},r),pc.copy(n.data,l,{x:c-a,y:h-a},{x:o-a,y:u-a},{width:a,height:a},r),pc.copy(n.data,l,{x:0,y:h-a},{x:o+c,y:u-a},{width:a,height:a},r),pc.copy(n.data,l,{x:0,y:0},{x:o+c,y:u+h},{width:a,height:a},r),pc.copy(n.data,l,{x:c-a,y:0},{x:o-a,y:u+h},{width:a,height:a},r);}this.lut=r,this.image=l,this.iconPositions=n,this.patternPositions=i;}addImages(t,e,r,n){for(const[i,s]of t.entries()){const{bin:t,imagePosition:a,imageVariant:o}=fd(i,s,r);e.set(i,a),n.push(t),s.hasRenderCallback&&this.haveRenderCallbacks.push(o.id);}}patchUpdatedImages(t,e,r){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((e=>t.hasImage(e,r))),t.dispatchRenderCallbacks(this.haveRenderCallbacks,r);for(const n of t.getUpdatedImages(r)){for(const i of this.iconPositions.keys()){const s=tr.parse(i);if(we.isEqual(s.id,n)){const s=t.getImage(n,r);this.patchUpdatedImage(this.iconPositions.get(i),s,e);}}for(const i of this.patternPositions.keys()){const s=tr.parse(i);if(we.isEqual(s.id,n)){const s=t.getImage(n,r);this.patchUpdatedImage(this.patternPositions.get(i),s,e);}}}}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl,s=t.sdf;if(this.lut||s){const t={width:e.data.width,height:e.data.height},a=new pc(t);pc.copy(e.data,a,{x:0,y:0},{x:0,y:0},t,this.lut,s),r.update(a,{position:{x:n,y:i}});}else r.update(e.data,{position:{x:n,y:i}});}}us(pd,"ImagePosition"),us(dd,"ImageAtlas");const md=1e20;function yd(t,e,r,n,i,s,a,o,l){for(let u=e;u<e+n;u++)gd(t,r*s+u,s,i,a,o,l);for(let u=r;u<r+i;u++)gd(t,u*s+e,1,n,a,o,l);}function gd(t,e,r,n,i,s,a){s[0]=0,a[0]=-md,a[1]=md,i[0]=t[e];for(let o=1,l=0,u=0;o<n;o++){i[o]=t[e+o*r];const n=o*o;do{const t=s[l];u=(i[o]-i[t]+n-t*t)/(o-t)/2;}while(u<=a[l]&&--l>-1);l++,s[l]=o,a[l]=u,a[l+1]=md;}for(let o=0,l=0;o<n;o++){for(;a[l+1]<o;)l++;const n=s[l],u=o-n;t[e+o*r]=i[n]+u*u;}}const xd=2,vd={none:0,ideographs:1,all:2};class bd{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.urls={},this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t,e){this.urls[e]=t;}getGlyphs(t,e,r){const n=[],i=this.urls[e]||At.GLYPHS_URL;for(const e in t)for(const r of t[e])n.push({stack:e,id:r});rt(n,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let s=n.glyphs[e];if(void 0!==s)return void r(null,{stack:t,id:e,glyph:s});if(s=this._tinySDF(n,t,e),s)return n.glyphs[e]=s,void r(null,{stack:t,id:e,glyph:s});const a=Math.floor(e/256);if(256*a>65535)return pt("glyphs > 65535 not supported"),void r(null,{stack:t,id:e,glyph:s});if(n.ranges[a])return void r(null,{stack:t,id:e,glyph:s});let o=n.requests[a];o||(o=n.requests[a]=[],bd.loadGlyphRange(t,a,i,this.requestManager,((t,e)=>{if(e){n.ascender=e.ascender,n.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e.glyphs[+t]);n.ranges[a]=!0;}for(const r of o)r(t,e);delete n.requests[a];}))),o.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,e)=>{if(t)r(t);else if(e){const t={};for(const{stack:r,id:n,glyph:i}of e)void 0===t[r]&&(t[r]={}),void 0===t[r].glyphs&&(t[r].glyphs={}),t[r].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[r].ascender=this.entries[r].ascender,t[r].descender=this.entries[r].descender;r(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==vd.none&&(this.localGlyphMode===vd.all?!!this.localFontFamily:!!this.localFontFamily&&(ds["CJK Unified Ideographs"](t)||ds["Hangul Syllables"](t)||ds.Hiragana(t)||ds.Katakana(t)||ds["CJK Symbols and Punctuation"](t)||ds["CJK Unified Ideographs Extension A"](t)||ds["CJK Unified Ideographs Extension B"](t)||ds.Osage(t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new bd.TinySDF({fontFamily:n,fontWeight:r,fontSize:24*xd,buffer:3*xd,radius:8*xd}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const s=String.fromCodePoint(r),{data:a,width:o,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:f}=i.draw(s);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new hc({width:o,height:l},a),metrics:{width:u/xd,height:c/xd,left:h/xd,top:p/xd-27,advance:f/xd,localGlyph:!0}}}}bd.loadGlyphRange=function(t,e,r,n,i){const s=256*e,a=s+255,o=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${a}`),Qt.Glyphs);ne(o,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new Cf(t).readFields(Rf,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},bd.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:s="normal",fontStyle:a="normal"}={}){this.buffer=e,this.cutoff=n,this.radius=r;const o=this.size=t+4*e,l=this._createCanvas(o),u=this.ctx=l.getContext("2d",{willReadFrequently:!0});u.font=`${a} ${s} ${t}px ${i}`,u.textBaseline="alphabetic",u.textAlign="left",u.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:s}=this.ctx.measureText(t),a=Math.ceil(r),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-i))),l=Math.min(this.size-this.buffer,a+Math.ceil(n)),u=o+2*this.buffer,c=l+2*this.buffer,h=Math.max(u*c,0),p=new Uint8ClampedArray(h),f={data:p,width:u,height:c,glyphWidth:o,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return f;const{ctx:d,buffer:m,gridInner:y,gridOuter:g}=this;d.clearRect(m,m,o,l),d.fillText(t,m,m+a);const x=d.getImageData(m,m,o,l);g.fill(md,0,h),y.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const r=x.data[4*(t*o+e)+3]/255;if(0===r)continue;const n=(t+m)*u+e+m;if(1===r)g[n]=0,y[n]=md;else {const t=.5-r;g[n]=t>0?t*t:0,y[n]=t<0?t*t:0;}}yd(g,0,0,u,c,u,this.f,this.v,this.z),yd(y,m,m,o,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(y[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return f}};const _d=hd;function wd(t,e){return t+e[1]-e[0]}function Md(t,e,r,n,i=1){const s=[],a=t.imagePrimary,o=a.pixelRatio,l=a.paddedRect.w-2*_d,u=a.paddedRect.h-2*_d,c=(t.right-t.left)*i,h=(t.bottom-t.top)*i,p=a.stretchX||[[0,l]],f=a.stretchY||[[0,u]],d=p.reduce(wd,0),m=f.reduce(wd,0),y=l-d,g=u-m;let x=0,v=d,b=0,_=m,w=0,M=y,A=0,I=g;if(a.content&&n){const t=a.content;x=Ad(p,0,t[0]),b=Ad(f,0,t[1]),v=Ad(p,t[0],t[2]),_=Ad(f,t[1],t[3]),w=t[0]-x,A=t[1]-b,M=t[2]-t[0]-v,I=t[3]-t[1]-_;}const S=(n,s,l,u)=>{const p=Sd(n.stretch-x,v,c,t.left*i),f=Pd(n.fixed-w,M,n.stretch,d),y=Sd(s.stretch-b,_,h,t.top*i),g=Pd(s.fixed-A,I,s.stretch,m),S=Sd(l.stretch-x,v,c,t.left*i),P=Pd(l.fixed-w,M,l.stretch,d),E=Sd(u.stretch-b,_,h,t.top*i),z=Pd(u.fixed-A,I,u.stretch,m),k=new q(p,y),T=new q(S,y),B=new q(S,E),V=new q(p,E),C=new q(f/o,g/o),D=new q(P/o,z/o),R=e*Math.PI/180;if(R){const t=Math.sin(R),e=Math.cos(R),r=[e,-t,t,e];k._matMult(r),T._matMult(r),V._matMult(r),B._matMult(r);}const L=n.stretch+n.fixed,F=l.stretch+l.fixed,O=s.stretch+s.fixed,N=u.stretch+u.fixed,U=t.imageSecondary;return {tl:k,tr:T,bl:V,br:B,texPrimary:{x:a.paddedRect.x+_d+L,y:a.paddedRect.y+_d+O,w:F-L,h:N-O},texSecondary:U?{x:U.paddedRect.x+_d+L,y:U.paddedRect.y+_d+O,w:F-L,h:N-O}:void 0,writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:C,pixelOffsetBR:D,minFontScaleX:M/o/c,minFontScaleY:I/o/h,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=Id(p,y,d),e=Id(f,g,m);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(S(n,e[t],i,e[t+1]));}}else s.push(S({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Ad(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function Id(t,e,r){const n=[{fixed:-_d,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+_d,stretch:r}),n}function Sd(t,e,r,n){return t/e*r+n}function Pd(t,e,r,n){return t-e*r/n}function Ed(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}function zd(t,e=1,r=!1){let n=1/0,i=1/0,s=-1/0,a=-1/0;const o=t[0];for(let t=0;t<o.length;t++){const e=o[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>s)&&(s=e.x),(!t||e.y>a)&&(a=e.y);}const l=Math.min(s-n,a-i);let u=l/2;const c=new Wr([],kd);if(0===l)return new q(n,i);for(let e=n;e<s;e+=l)for(let r=i;r<a;r+=l)c.push(new Td(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new Td(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)),n.max-h.d<=e||(u=n.h/2,c.push(new Td(n.p.x-u,n.p.y-u,u,t)),c.push(new Td(n.p.x+u,n.p.y-u,u,t)),c.push(new Td(n.p.x-u,n.p.y+u,u,t)),c.push(new Td(n.p.x+u,n.p.y+u,u,t)),p+=4);}return r&&(console.log(`num probes: ${p}`),console.log(`best distance: ${h.d}`)),h.p}function kd(t,e){return e.max-t.max}class Td{constructor(t,e,r,n){this.p=new q(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,Gl(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}}const Bd=Number.POSITIVE_INFINITY,Vd=Math.sqrt(2);function Cd(t,[e,r]){let n=0,i=0;if(r===Bd){e<0&&(e=0);const r=e/Vd;switch(t){case"top-right":case"top-left":i=r-7;break;case"bottom-right":case"bottom-left":i=7-r;break;case"bottom":i=7-e;break;case"top":i=e-7;}switch(t){case"top-right":case"bottom-right":n=-r;break;case"top-left":case"bottom-left":n=r;break;case"left":n=e;break;case"right":n=-e;}}else {switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}}return [n,i]}function Dd(t,e,r,n,i,s,a,o){if(!t)return;const l=vf(e,r,n,i,s);return t.scaleSelf(l*o*a)}function Rd(t,e,r,n,i,s,a,o){return {iconPrimary:Dd(t.getPrimary(),e,r,n,i,s,a,o),iconSecondary:Dd(t.getSecondary(),e,r,n,i,s,a,o)}}function Ld(t,e,r,n){if(!t)return;const i=e.get(r.toString());if(t.imagePrimary=i,n){const r=e.get(n.toString());t.imageSecondary=r;}}function Fd(t,e){for(const r in t.horizontal)Od(t.horizontal[r],e);Od(t.vertical,e);}function Od(t,e){if(t)for(const r of t.positionedLines)for(const t of r.positionedGlyphs)if(null!==t.image){const r=t.image.toString();t.rect=e.get(r).paddedRect;}}function Nd(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Ud(t,e,r,n,i,s,a,o,l){const u=Yd(s.horizontal)||s.vertical,c=r.get("icon-text-fit-padding").evaluate(n,{},i);let h,p=e;return e&&"none"!==l&&(t.allowVerticalPlacement&&s.vertical&&(h=td(e,s.vertical,l,c,o,a)),u&&(p=td(e,u,l,c,o,a))),{defaultShapedIcon:p,verticallyShapedIcon:h}}function jd(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v){let b=a.textMaxSize.evaluate(e,{},p);void 0===b?b=o*a.textScaleFactor:b*=a.textScaleFactor;const _=t.layers[0].layout,w=Yd(r.horizontal)||r.vertical,M="globe"===f.name,A=gf,I=t.tilePixelRatio*b/A,S=(B=t.overscaling,t.zoom>18&&B>2&&(B>>=1),Math.max(Kr/(512*B),1)*_.get("symbol-spacing")),P=_.get("text-padding")*t.tilePixelRatio,E=_.get("icon-padding")*t.tilePixelRatio,z=H(_.get("text-max-angle")),k="map"===_.get("icon-rotation-alignment")&&"point"!==v,T=S/2;var B;!1===t.hasAnyIconTextFit&&"none"!==y&&(t.hasAnyIconTextFit=!0);const V=e.properties?+e.properties[oh]:null,C=V&&t.elevationFeatureIdToIndex?t.elevationFeatureIdToIndex.get(V):65535,D=(o,l,v)=>{if(l.x<0||l.x>=Kr||l.y<0||l.y>=Kr)return;let b=null;if(M){const{x:t,y:e,z:r}=f.projectTilePoint(l.x,l.y,v);b={anchor:new ed(t,e,r,0,void 0),up:f.upVector(v,l.x,l.y)};}!function(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,v,b,_,w,M,A,I,S,P,E){const z=t.addToLineVertexArray(e,n);let k,T,B,V,C,D,R,L=0,F=0,O=0,N=0,U=-1,j=-1;const q={};let $=ye("");const G=r?r.anchor:e,Y="none"!==P;let H=0,X=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")?[H,X]=l.layout.get("text-offset").evaluate(b,{},A).map((t=>t*gf)):(H=l.layout.get("text-radial-offset").evaluate(b,{},A)*gf,X=Bd),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(d)D=Xd(t),o&&(R=Xd(o));else {const r=l.layout.get("text-rotate").evaluate(b,{},A)+90;B=Hd(u,G,e,c,h,p,t,f,r,m),o&&(V=Hd(u,G,e,c,h,p,o,g,r));}}if(s){const n=t.iconSizeData,i=l.layout.get("icon-rotate").evaluate(b,{},A),a=Md(s,i,w,Y,_.iconScaleFactor),f=o?Md(o,i,w,Y,_.iconScaleFactor):void 0;T=Hd(u,G,e,c,h,p,s,g,i,null),L=4*a.length;let d=null;"source"===n.kind?(d=[xf*l.layout.get("icon-size").evaluate(b,{},A)*_.iconScaleFactor],d[0]>$d&&pt(`${t.layerIds[0]}: Value for "icon-size" is >= ${qd}. Reduce your "icon-size".`)):"composite"===n.kind&&(d=[xf*_.compositeIconSizes[0].evaluate(b,{},A)*_.iconScaleFactor,xf*_.compositeIconSizes[1].evaluate(b,{},A)*_.iconScaleFactor],(d[0]>$d||d[1]>$d)&&pt(`${t.layerIds[0]}: Value for "icon-size" is >= ${qd}. Reduce your "icon-size".`)),t.addSymbols(t.icon,a,d,v,x,b,!1,r,e,z.lineStartIndex,z.lineLength,-1,M,A,I,S),U=t.icon.placedSymbolArray.length-1,f&&(F=4*f.length,t.addSymbols(t.icon,f,d,v,x,b,Nf.vertical,r,e,z.lineStartIndex,z.lineLength,-1,M,A,I,S),j=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const s=i.horizontal[n];k||($=ye(s.text),d?C=Xd(s):k=Hd(u,G,e,c,h,p,s,f,l.layout.get("text-rotate").evaluate(b,{},A),m));const o=1===s.positionedLines.length;if(O+=Gd(t,r,e,s,a,l,d,b,m,z,i.vertical?Nf.horizontal:Nf.horizontalOnly,o?Object.keys(i.horizontal):[n],q,U,_,M,A,I),o)break}i.vertical&&(N+=Gd(t,r,e,i.vertical,a,l,d,b,m,z,Nf.vertical,["vertical"],q,j,_,M,A,I));let Z=-1;const W=(t,e)=>t?Math.max(t,e):e;Z=W(C,Z),Z=W(D,Z),Z=W(R,Z);const K=Z>-1?1:0;t.glyphOffsetArray.length>=65535&&pt("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,G.x,G.y,G.z,q.right>=0?q.right:-1,q.center>=0?q.center:-1,q.left>=0?q.left:-1,q.vertical>=0?q.vertical:-1,U,j,$,void 0!==k?k:t.collisionBoxArray.length,void 0!==k?k+1:t.collisionBoxArray.length,void 0!==B?B:t.collisionBoxArray.length,void 0!==B?B+1:t.collisionBoxArray.length,void 0!==T?T:t.collisionBoxArray.length,void 0!==T?T+1:t.collisionBoxArray.length,V||t.collisionBoxArray.length,V?V+1:t.collisionBoxArray.length,c,O,N,L,F,K,0,H,X,Z,0,Y?1:0,E);}(t,l,b,o,r,n,s,i,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,P,x,u,0,E,k,g,e,a,c,h,p,d,m,y,C);};if("line"===v)for(const i of ud(e.geometry,0,0,Kr,Kr)){const e=od(i,S,z,r.vertical||w,n,A,I,t.overscaling,Kr);for(const r of e)w&&Zd(t,w.text,T,r)||D(i,r,p);}else if("line-center"===v){for(const t of e.geometry)if(t.length>1){const e=ad(t,z,r.vertical||w,n,A,I);e&&D(t,e,p);}}else if("Polygon"===e.type)for(const t of $c(e.geometry,0)){const e=zd(t,16);D(t[0],new ed(e.x,e.y,0,0,void 0),p);}else if("LineString"===e.type)for(const t of e.geometry)D(t,new ed(t[0].x,t[0].y,0,0,void 0),p);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)D([e],new ed(e.x,e.y,0,0,void 0),p);}const qd=255,$d=qd*xf;function Gd(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g){const x=function(t,e,r,n,i,s,a,o){const l=[];if(0===e.positionedLines.length)return l;const u=n.layout.get("text-rotate").evaluate(s,{})*Math.PI/180,c=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let h=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)h-=t.lineOffset;const p=e.positionedLines.length,f=h/p;let d=e.top-r[1];for(let t=0;t<p;++t){const n=e.positionedLines[t];d=Ed(e,f,d,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let s=Of+1,h=!0,p=1,f=0;if(t.image){const e=a.get(t.image.toString());if(!e)continue;if(e.sdf){pt("SDF images are not supported in formatted text and will be ignored.");continue}h=!1,p=e.pixelRatio,s=hd/p;}const m=(i||o)&&t.vertical,y=t.metrics.advance*t.scale/2,g=t.metrics,x=t.rect;if(null===x)continue;o&&e.verticalizable&&(f=t.image?y-t.metrics.width*t.scale/2:0);const v=i?[t.x+y,t.y]:[0,0];let b=[0,0],_=[0,0],w=!1;i||(m?(_=[t.x+y+c[0],t.y+c[1]-f],w=!0):b=[t.x+y+r[0],t.y+r[1]-f]);const M=x.w*t.scale/(p*(t.localGlyph?xd:1)),A=x.h*t.scale/(p*(t.localGlyph?xd:1));let I,S,P,E;if(m){const e=t.y-d,r=new q(-y,y-e),n=-Math.PI/2,i=new q(..._);I=new q(-y+b[0],b[1]),I._rotateAround(n,r)._add(i),I.x+=-e+y,I.y-=(g.left-s)*t.scale;const a=t.image?g.advance*t.scale:gf*t.scale,o=String.fromCodePoint(t.glyph);Sf(o)?I.x+=(1-s)*t.scale:Pf(o)?I.x+=a-g.height*t.scale+(-s-1)*t.scale:I.x+=t.image||g.width+2*s===x.w&&g.height+2*s===x.h?(a-A)/2:(a-(g.height+2*s)*t.scale)/2,S=new q(I.x,I.y-M),P=new q(I.x+A,I.y),E=new q(I.x+A,I.y-M);}else {const e=(g.left-s)*t.scale-y+b[0],r=(-g.top-s)*t.scale+b[1],n=e+M,i=r+A;I=new q(e,r),S=new q(n,r),P=new q(e,i),E=new q(n,i);}if(u){let t;t=i?new q(0,0):w?new q(c[0],c[1]):new q(r[0],r[1]),I._rotateAround(u,t),S._rotateAround(u,t),P._rotateAround(u,t),E._rotateAround(u,t);}const z=new q(0,0),k=new q(0,0);l.push({tl:I,tr:S,bl:P,br:E,texPrimary:n,texSecondary:void 0,writingMode:e.writingMode,glyphOffset:v,sectionIndex:t.sectionIndex,isSDF:h,pixelOffsetTL:z,pixelOffsetBR:k,minFontScaleX:0,minFontScaleY:0});}}return l}(0,n,l,s,a,o,i,t.allowVerticalPlacement),v=t.textSizeData;let b=null;"source"===v.kind?(b=[xf*s.layout.get("text-size").evaluate(o,{},y)*d.textScaleFactor],b[0]>$d&&pt(`${t.layerIds[0]}: Value for "text-size" is >= ${qd}. Reduce your "text-size".`)):"composite"===v.kind&&(b=[xf*d.compositeTextSizes[0].evaluate(o,{},y)*d.textScaleFactor,xf*d.compositeTextSizes[1].evaluate(o,{},y)*d.textScaleFactor],(b[0]>$d||b[1]>$d)&&pt(`${t.layerIds[0]}: Value for "text-size" is >= ${qd}. Reduce your "text-size".`)),t.addSymbols(t.text,x,b,l,a,o,c,e,r,u.lineStartIndex,u.lineLength,f,m,y,g,!1);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*x.length}function Yd(t){for(const e in t)return t[e];return null}function Hd(t,e,r,n,i,s,a,o,l,u){let c=a.top,h=a.bottom,p=a.left,f=a.right;const d=a.collisionPadding;if(d&&(p-=d[0],c-=d[1],f+=d[2],h+=d[3]),l){const t=new q(p,c),e=new q(f,c),r=new q(p,h),n=new q(f,h),i=H(l);let s=new q(0,0);u&&(s=new q(u[0],u[1])),t._rotateAround(i,s),e._rotateAround(i,s),r._rotateAround(i,s),n._rotateAround(i,s),p=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),c=Math.min(t.y,e.y,r.y,n.y),h=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,p,c,f,h,o,n,i,s),t.length-1}function Xd(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function Zd(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}function Wd(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),s=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01));let a=Math.sin(t._pitch)*s+i;const o=i*(1/t._horizonShift);if(!t.elevation||0===t.elevation.exaggeration()){let e=Math.max(t.zoom-17,0);t.isOrthographic&&(e/=10),a*=1+e;}return Math.min(1.01*a,o)}function Kd(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,s=t.y*r,a=(t.y+1)*r,o=gl(n),l=gl(i),u=xl(s),c=xl(a),h=e.project(o,u),p=e.project(l,u),f=e.project(l,c),d=e.project(o,c);let m=Math.min(h.x,p.x,f.x,d.x),y=Math.min(h.y,p.y,f.y,d.y),g=Math.max(h.x,p.x,f.x,d.x),x=Math.max(h.y,p.y,f.y,d.y);const v=r/16;function b(t,r,n,i,s,a){const o=(n+s)/2,l=(i+a)/2,u=e.project(gl(o),xl(l)),c=Math.max(0,m-u.x,y-u.y,u.x-g,u.y-x);m=Math.min(m,u.x),g=Math.max(g,u.x),y=Math.min(y,u.y),x=Math.max(x,u.y),c>v&&(b(t,u,n,i,o,l),b(u,r,o,l,s,a));}b(h,p,n,s,i,s),b(p,f,i,s,i,a),b(f,d,i,a,n,a),b(d,h,n,a,n,s),m-=v,y-=v,g+=v,x+=v;const _=1/Math.max(g-m,x-y);return {scale:_,x:m*_,y:y*_,x2:g*_,y2:x*_,projection:e}}function Jd(t,{x:e,y:r},n=0){return new q(((e-n)*t.scale-t.x)*Kr,(r*t.scale-t.y)*Kr)}const Qd=O.mat4.identity(new Float32Array(16));class tm{constructor(t){this.spec=t,this.name=t.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7];}project(t,e){return {x:0,y:0,z:0}}unproject(t,e){return new ul(0,0)}projectTilePoint(t,e,r){return {x:t,y:e,z:0}}locationPoint(t,e,r,n=!0){return t._coordinatePoint(t.locationCoordinate(e,r),n)}pixelsPerMeter(t,e){return yl(1,t)*e}pixelSpaceConversion(t,e,r){return 1}farthestPixelDistance(t){return Wd(t,t.pixelsPerMeter)}pointCoordinate(t,e,r,n){const i=t.horizonLineFromTop(!1),s=new q(e,Math.max(i,r));return t.rayIntersectionCoordinate(t.pointRayIntersection(s,n))}pointCoordinate3D(t,e,r){const n=new q(e,r);if(t.elevation)return t.elevation.pointCoordinate(n);{const e=this.pointCoordinate(t,n.x,n.y,0);return [e.x,e.y,e.z]}}isPointAboveHorizon(t,e){if(t.elevation&&t.elevation.visibleDemTiles.length)return !this.pointCoordinate3D(t,e.x,e.y);const r=t.horizonLineFromTop();return e.y<r}createInversionMatrix(t,e){return Qd}createTileMatrix(t,e,r){let n,i,s;const a=r.canonical,o=O.mat4.identity(new Float64Array(16));if(this.isReprojectedInTileSpace){const l=Kd(a,this);n=1,i=l.x+r.wrap*l.scale,s=l.y,O.mat4.scale(o,o,[n/l.scale,n/l.scale,t.pixelsPerMeter/e]);}else n=e/t.zoomScale(a.z),i=(a.x+Math.pow(2,a.z)*r.wrap)*n,s=a.y*n;return O.mat4.translate(o,o,[i,s,0]),O.mat4.scale(o,o,[n/Kr,n/Kr,1]),o}upVector(t,e,r){return [0,0,1]}upVectorScale(t,e,r){return {metersToTile:1}}}class em extends tm{constructor(t){super(t),this.range=[4,7],this.center=t.center||[-96,37.5];const[e,r]=this.parallels=t.parallels||[29.5,45.5],n=Math.sin(H(e));this.n=(n+Math.sin(H(r)))/2,this.c=1+n*(2*this.n-n),this.r0=Math.sqrt(this.c)/this.n;}project(t,e){const{n:r,c:n,r0:i}=this,s=H(t-this.center[0]),a=H(e),o=Math.sqrt(n-2*r*Math.sin(a))/r;return {x:o*Math.sin(s*r),y:o*Math.cos(s*r)-i,z:0}}unproject(t,e){const{n:r,c:n,r0:i}=this,s=i+e;let a=Math.atan2(t,Math.abs(s))*Math.sign(s);s*r<0&&(a-=Math.PI*Math.sign(t)*Math.sign(s));const o=H(this.center[0])*r;a=et(a,-Math.PI-o,Math.PI-o);const l=Q(X(a/r)+this.center[0],-180,180),u=Math.asin(Q((n-(t*t+s*s)*r*r)/(2*r),-1,1)),c=Q(X(u),-bl,bl);return new ul(l,c)}}const rm=1.340264,nm=-.081106,im=893e-6,sm=.003796,am=Math.sqrt(3)/2;class om extends tm{project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(am*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(am*(rm+3*nm*n+i*(7*im+9*sm*n)))/Math.PI+.5),y:1-.5*(r*(rm+nm*n+i*(im+sm*n))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,s,a,o=0;o<12&&(s=r*(rm+nm*n+i*(im+sm*n))-e,a=rm+3*nm*n+i*(7*im+9*sm*n),t=s/a,r=Q(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++o);const s=am*t*(rm+3*nm*n+i*(7*im+9*sm*n))/Math.cos(r),a=Math.asin(Math.sin(r)/am),o=Q(180*s/Math.PI,-180,180),l=Q(180*a/Math.PI,-bl,bl);return new ul(o,l)}}class lm extends tm{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){return {x:.5+t/360,y:.5-e/360,z:0}}unproject(t,e){const r=360*(t-.5),n=Q(360*(.5-e),-bl,bl);return new ul(r,n)}}const um=Math.PI/2;function cm(t){return Math.tan((um+t)/2)}class hm extends tm{constructor(t){super(t),this.center=t.center||[0,30];const[e,r]=this.parallels=t.parallels||[30,30];let n=H(e),i=H(r);this.southernCenter=n+i<0,this.southernCenter&&(n=-n,i=-i);const s=Math.cos(n),a=cm(n);this.n=n===i?Math.sin(n):Math.log(s/Math.cos(i))/Math.log(cm(i)/a),this.f=s*Math.pow(cm(n),this.n)/this.n;}project(t,e){e=H(e),this.southernCenter&&(e=-e),t=H(t-this.center[0]);const r=1e-6,{n,f:i}=this;i>0?e<-um+r&&(e=-um+r):e>um-r&&(e=um-r);const s=i/Math.pow(cm(e),n);let a=s*Math.sin(n*t),o=i-s*Math.cos(n*t);return a=.5*(a/Math.PI+.5),o=.5*(o/Math.PI+.5),{x:a,y:this.southernCenter?o:1-o,z:0}}unproject(t,e){t=(2*t-.5)*Math.PI,this.southernCenter&&(e=1-e),e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this,i=n-e,s=Math.sign(i),a=Math.sign(r)*Math.sqrt(t*t+i*i);let o=Math.atan2(t,Math.abs(i))*s;i*r<0&&(o-=Math.PI*Math.sign(t)*s);const l=Q(X(o/r)+this.center[0],-180,180),u=Q(X(2*Math.atan(Math.pow(n/a,1/r))-um),-bl,bl);return new ul(l,this.southernCenter?-u:u)}}class pm extends tm{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null;}project(t,e){return {x:dl(t),y:ml(e),z:0}}unproject(t,e){const r=gl(t),n=xl(e);return new ul(r,n)}}const fm=H(bl);class dm extends tm{project(t,e){const r=(e=H(e))*e,n=r*r;return {x:.5*((t=H(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,s=r*r;do{s=r*r;const t=s*s;i=(r*(1.007226+s*(.015085+t*(.028874*s-.044475-.005916*t)))-e)/(1.007226+s*(.045255+t*(.259866*s-.311325-.005916*11*t))),r=Q(r-i,-fm,fm);}while(Math.abs(i)>1e-6&&--n>0);s=r*r;const a=Q(X(t/(.8707+s*(s*(s*s*s*(.003971-.001529*s)-.013791)-.131979))),-180,180),o=X(r);return new ul(a,o)}}const mm=H(bl);class ym extends tm{project(t,e){e=H(e),t=H(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),s=Math.sin(i)/i,a=.5*(t*n+2*r*Math.sin(t/2)/s)||0,o=.5*(e+Math.sin(e)/s)||0;return {x:.5*(a/Math.PI+.5),y:1-.5*(o/Math.PI+1),z:0}}unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const s=1e-6;let a=0,o=0;do{const i=Math.cos(n),s=Math.sin(n),l=2*s*i,u=s*s,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),f=2*h*p,d=p*p,m=1-c*h*h,y=m?1/m:0,g=m?Math.acos(i*h)*Math.sqrt(1/m):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,v=.5*(g*s+n)-e,b=.5*y*(c*d+g*i*h*u)+1/Math.PI,_=y*(f*l/4-g*s*p),w=.125*y*(l*p-g*s*c*f),M=.5*y*(u*h+g*d*i)+.5,A=_*w-M*b;a=(v*_-x*M)/A,o=(x*w-v*b)/A,r=Q(r-a,-Math.PI,Math.PI),n=Q(n-o,-mm,mm);}while((Math.abs(a)>s||Math.abs(o)>s)&&--i>0);return new ul(X(r),X(n))}}class gm extends tm{constructor(t){super(t),this.center=t.center||[0,0],this.parallels=t.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(H(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){const{scale:r,cosPhi:n}=this;return {x:H(t)*n*r+.5,y:-Math.sin(H(e))/n*r+.5,z:0}}unproject(t,e){const{scale:r,cosPhi:n}=this,i=-(e-.5)/r,s=Q(X((t-.5)/r)/n,-180,180),a=Math.asin(Q(i*n,-1,1)),o=Q(X(a),-bl,bl);return new ul(s,o)}}class xm extends pm{constructor(t){super(t),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5];}projectTilePoint(t,e,r){const n=Ru(t,e,r),i=Ou(ku(r));return O.vec3.transformMat4(n,n,i),{x:n[0],y:n[1],z:n[2]}}locationPoint(t,e,r){const n=al(e.lat,e.lng),i=O.vec3.normalize([],n),s=r?t._centerAltitude+r:t.elevation?t.elevation.getAtPointOrZero(t.locationCoordinate(e),t._centerAltitude):t._centerAltitude,a=yl(1,0)*Kr*s;O.vec3.scaleAndAdd(n,n,i,a);const o=O.mat4.identity(new Float64Array(16));return O.mat4.multiply(o,t.pixelMatrix,t.globeMatrix),O.vec3.transformMat4(n,n,o),new q(n[0],n[1])}pixelsPerMeter(t,e){return yl(1,0)*e}pixelSpaceConversion(t,e,r){const n=yl(1,t)*e,i=Ee(yl(1,45)*e,n,r);return this.pixelsPerMeter(t,e)/i}createTileMatrix(t,e,r){const n=Nu(ku(r.canonical));return O.mat4.multiply(new Float64Array(16),t.globeMatrix,n)}createInversionMatrix(t,e){const{center:r}=t,n=Ou(ku(e));return O.mat4.rotateY(n,n,H(r.lng)),O.mat4.rotateX(n,n,H(r.lat)),O.mat4.scale(n,n,[t._pixelsPerMercatorPixel,t._pixelsPerMercatorPixel,1]),Float32Array.from(n)}pointCoordinate(t,e,r,n){return Pu(t,e,r,!0)||new Il(0,0)}pointCoordinate3D(t,e,r){const n=this.pointCoordinate(t,e,r,0);return [n.x,n.y,n.z]}isPointAboveHorizon(t,e){return !Pu(t,e.x,e.y,!1)}farthestPixelDistance(t){const e=function(t,e){const r=t.cameraToCenterDistance,n=t._centerAltitude*e,i=t._camera,s=t._camera.forward(),a=O.vec3.add([],O.vec3.scale([],s,-r),[0,0,n]),o=t.worldSize/(2*Math.PI),l=[0,0,-o],u=t.width/t.height,c=Math.tan(t.fovAboveCenter),h=O.vec3.scale([],i.up(),c),p=O.vec3.scale([],i.right(),c*u),f=O.vec3.normalize([],O.vec3.add([],O.vec3.add([],s,h),p)),d=[];let m;if(new gu(a,f).closestPointOnSphere(l,o,d)){const e=O.vec3.add([],d,l),r=O.vec3.sub([],e,a);m=Math.cos(t.fovAboveCenter)*O.vec3.length(r);}else {const t=O.vec3.sub([],a,l),e=O.vec3.sub([],l,a);O.vec3.normalize(e,e);const r=O.vec3.length(t)-o;m=Math.sqrt(r*(r+2*o));const n=Math.acos(m/(o+r))-Math.acos(O.vec3.dot(s,e));m*=Math.cos(n);}return 1.01*m}(t,this.pixelsPerMeter(t.center.lat,t.worldSize)),r=$u(t.zoom);if(r>0){const n=Wd(t,yl(1,t.center.lat)*t.worldSize),i=t.worldSize/(2*Math.PI),s=Math.max(t.width,t.height)/t.worldSize*Math.PI;return Ee(e,n+i*(1-Math.cos(s)),Math.pow(r,10))}return e}upVector(t,e,r){return Ru(e,r,t,1)}upVectorScale(t){return {metersToTile:Iu(Lu(ku(t)))}}}function vm(t){const e=t.parallels,r=!!e&&Math.abs(e[0]+e[1])<.01;switch(t.name){case"mercator":return new pm(t);case"equirectangular":return new lm(t);case"naturalEarth":return new dm(t);case"equalEarth":return new om(t);case"winkelTripel":return new ym(t);case"albers":return r?new gm(t):new em(t);case"lambertConformalConic":return r?new gm(t):new hm(t);case"globe":return new xm(t)}throw new Error(`Invalid projection name: ${t.name}`)}const bm=ah.VectorTileFeature.types,_m=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function wm(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min($d,Math.round(o[0])):0,d=o?Math.min($d,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function Mm(t,e,r){t.emplaceBack(e,r);}function Am(t,e,r,n,i,s,a){t.emplaceBack(e,r,n,i,s,a);}function Im(t,e,r,n,i){t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i);}function Sm(t){for(const e of t.sections)if(Ms(e.text))return !0;return !1}class Pm{constructor(t){this.layoutVertexArray=new Va,this.indexArray=new ja,this.programConfigurations=t,this.segments=new xo,this.dynamicLayoutVertexArray=new Da,this.opacityVertexArray=new Ra,this.placedSymbolArray=new so,this.iconTransitioningVertexArray=new La,this.globeExtVertexArray=new Ca,this.zOffsetVertexArray=new Aa;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length&&0===this.iconTransitioningVertexArray.length}upload(t,e,r,n,i){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,lf.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,cf.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,_m,!0),this.iconTransitioningVertexArray.length>0&&(this.iconTransitioningVertexBuffer=t.createVertexBuffer(this.iconTransitioningVertexArray,pf.members,!0)),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,uf.members,!0)),!this.zOffsetVertexBuffer&&(this.zOffsetVertexArray.length>0||i)&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,hf.members,!0)),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.iconTransitioningVertexBuffer&&this.iconTransitioningVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy());}}us(Pm,"SymbolBuffers");class Em{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new xo,this.collisionVertexArray=new Ua,this.collisionVertexArrayExt=new Da;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,ff.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,df.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}us(Em,"CollisionBuffers");class zm{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.lut=t.lut,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.hasAnyIconTextFit=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=O.mat4.identity([]),this.placementViewportMatrix=O.mat4.identity([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=bf(this.zoom,e["text-size"]),this.iconSizeData=bf(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&void 0!==n.constantOr(1),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=r.get("text-writing-mode").map((t=>Nf[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID,this.projection=t.projection,this.hasAnyZOffset=!1,this.zOffsetSortDirty=!1,this.zOffsetBuffersNeedUpload=!1,this.elevationType="none",this.elevationStateComplete=!1,this.activeReplacements=[],this.replacementUpdateTime=0;}createArrays(){this.text=new Pm(new Go(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("text")||t.startsWith("symbol")))),this.icon=new Pm(new Go(this.layers,{zoom:this.zoom,lut:this.lut},(t=>t.startsWith("icon")||t.startsWith("symbol")))),this.glyphOffsetArray=new lo,this.lineVertexArray=new uo,this.symbolInstances=new oo;}calculateGlyphDependencies(t,e,r,n,i){for(const r of t){const t=r.codePointAt(0);if(void 0===t)break;if(e[t]=!0,n&&i&&t<=65535){const t=If[r];t&&(e[t.charCodeAt(0)]=!0);}}}updateFootprints(t,e){}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);return !Yh(this.activeReplacements,r)&&(this.activeReplacements=r,!0)}populate(t,e,r,n){const i=this.layers[0],s=i.layout,a="globe"===this.projection.name,o=s.get("text-font"),l=s.get("text-field"),u=s.get("icon-image"),[c,h]=s.get("icon-size-scale-range"),p=Q(e.scaleFactor||1,c,h),f=("constant"!==l.value.kind||l.value.value instanceof Qe&&!l.value.value.isEmpty()||l.value.value.toString().length>0)&&("constant"!==o.value.kind||o.value.value.length>0),d="constant"!==u.value.kind||!!u.value.value||Object.keys(u.parameters).length>0,m=s.get("symbol-sort-key");if(this.features=[],!f&&!d)return;const y=e.iconDependencies,g=e.glyphDependencies,x=e.availableImages,v=new Rs(this.zoom);for(const{feature:e,id:l,index:u,sourceLayerIndex:c}of t){const t=i._featureFilter.needGeometry,h=Cl(e,t);if(!i._featureFilter.filter(v,h,r))continue;if(t||(h.geometry=Vl(e,r,n)),a&&1!==e.type&&r.z<=5){const t=h.geometry,e=.98078528056,n=(t,n)=>{const i=Ru(t.x,t.y,r,1),s=Ru(n.x,n.y,r,1);return O.vec3.dot(i,s)<e};for(let e=0;e<t.length;e++)t[e]=zl(t[e],n);}let b,_;if(f){const t=i.getValueAndResolveTokens("text-field",h,r,x),e=Qe.factory(t);Sm(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===Vs()||this.hasRTLText&&Ds.isParsed())&&(b=Af(e,i,h));}if(d){const t=i.getValueAndResolveTokens("icon-image",h,r,x);_=t instanceof er?t:er.build(t);}if(!b&&!_)continue;const w=this.sortFeaturesByKey?m.evaluate(h,{},r):void 0,M={id:l,text:b,icon:_,index:u,sourceLayerIndex:c,geometry:h.geometry,properties:e.properties,type:bm[e.type],sortKey:w};if(this.features.push(M),_){const t=this.layers[0]._unevaluatedLayout._values,{iconPrimary:e,iconSecondary:n}=Rd(_,this.iconSizeData,t["icon-size"],r,this.zoom,M,this.pixelRatio,p),i=e.id.toString();if(y.has(i)?y.get(i).push(e):y.set(i,[e]),n){const t=n.id.toString();y.has(t)?y.get(t).push(n):y.set(t,[n]);}}if(b){const t=o.evaluate(h,{},r).join(","),e="map"===s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Nf.vertical)>=0;for(const r of b.sections)if(r.image){const t=r.image.getPrimary().scaleSelf(this.pixelRatio),e=t.id.toString(),n=y.get(e)||[];n.push(t),y.set(e,n);}else {const n=ms(b.toString()),i=r.fontStack||t,s=g[i]=g[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n);}}}if("line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),"hd-road-markup"===s.get("symbol-elevation-reference")){if(this.elevationType="road",e.elevationFeatures){!this.elevationFeatures&&e.elevationFeatures.length>0&&(this.elevationFeatures=[],this.elevationFeatureIdToIndex=new Map);for(const t of e.elevationFeatures)this.elevationFeatureIdToIndex.set(t.id,this.elevationFeatures.length),this.elevationFeatures.push(t);}}else s.get("symbol-z-elevate")&&(this.elevationType="offset");"none"!==this.elevationType&&(this.zOffsetBuffersNeedUpload=!0),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r,n,i,s,a){this.text.programConfigurations.updatePaintArrays(t,e,i,r,n,s,a),this.icon.programConfigurations.updatePaintArrays(t,e,i,r,n,s,a);}updateRoadElevation(){if("road"!==this.elevationType||!this.elevationFeatures)return;if(this.elevationStateComplete)return;this.elevationStateComplete=!0,this.hasAnyZOffset=!1;let t=!1;for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);if(65535===r.elevationFeatureIndex)continue;const n=this.elevationFeatures[r.elevationFeatureIndex];if(n){const e=.05+n.pointElevation(new q(r.tileAnchorX,r.tileAnchorY));r.zOffset!==e&&(t=!0,r.zOffset=e);}}t&&(this.zOffsetBuffersNeedUpload=!0,this.zOffsetSortDirty=!0);}updateZOffset(){const t=(t,e,n)=>{r+=e,r>t.length&&t.resize(r);for(let i=-e;i<0;i++)t.emplace(i+r,n);},e=(t,e,r)=>{n+=e,n>t.length&&t.resize(n);for(let i=-e;i<0;i++)t.emplace(i+n,r);};if(!this.zOffsetBuffersNeedUpload)return;this.zOffsetBuffersNeedUpload=!1;let r=0,n=0;for(let r=0;r<this.symbolInstances.length;r++){const n=this.symbolInstances.get(r),{numHorizontalGlyphVertices:i,numVerticalGlyphVertices:s,numIconVertices:a}=n,o=n.zOffset,l=a>0;if((i>0||s>0)&&(t(this.text.zOffsetVertexArray,i,o),t(this.text.zOffsetVertexArray,s,o)),l){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:r}=n;t>=0&&e(this.icon.zOffsetVertexArray,a,o),r>=0&&e(this.icon.zOffsetVertexArray,n.numVerticalIconVertices,o);}}this.text.zOffsetVertexBuffer&&this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray),this.icon.zOffsetVertexBuffer&&this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray);}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}getProjection(){return this.projectionInstance||(this.projectionInstance=vm(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment)for(const{x:t,y:r}of e)this.lineVertexArray.emplaceBack(t,r);return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m){const y=t.indexArray,g=t.layoutVertexArray,x=t.globeExtVertexArray,v=t.segments.prepareSegment(4*e.length,g,y,this.canOverlap?s.sortKey:void 0),b=this.glyphOffsetArray.length,_=v.vertexLength,w=this.allowVerticalPlacement&&a===Nf.vertical?Math.PI/2:0,M=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:a,bl:u,br:c,texPrimary:h,texSecondary:b,pixelOffsetTL:_,pixelOffsetBR:A,minFontScaleX:I,minFontScaleY:S,glyphOffset:P,isSDF:E,sectionIndex:z}=e[n],k=v.vertexLength,T=P[1];if(wm(g,l.x,l.y,i.x,T+i.y,h.x,h.y,r,E,_.x,_.y,I,S),wm(g,l.x,l.y,a.x,T+a.y,h.x+h.w,h.y,r,E,A.x,_.y,I,S),wm(g,l.x,l.y,u.x,T+u.y,h.x,h.y+h.h,r,E,_.x,A.y,I,S),wm(g,l.x,l.y,c.x,T+c.y,h.x+h.w,h.y+h.h,r,E,A.x,A.y,I,S),o){const{x:e,y:r,z:n}=o.anchor,[i,s,a]=o.up;Am(x,e,r,n,i,s,a),Am(x,e,r,n,i,s,a),Am(x,e,r,n,i,s,a),Am(x,e,r,n,i,s,a),Im(t.dynamicLayoutVertexArray,e,r,n,w);}else Im(t.dynamicLayoutVertexArray,l.x,l.y,l.z,w);if(m){const e=b||h;Mm(t.iconTransitioningVertexArray,e.x,e.y),Mm(t.iconTransitioningVertexArray,e.x+e.w,e.y),Mm(t.iconTransitioningVertexArray,e.x,e.y+e.h),Mm(t.iconTransitioningVertexArray,e.x+e.w,e.y+e.h);}y.emplaceBack(k,k+1,k+2),y.emplaceBack(k+1,k+2,k+3),v.vertexLength+=4,v.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(P[0]),n!==e.length-1&&z===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(g.length,s,s.index,{},p,f,d,M&&M[z]);}const A=o?o.anchor:l;t.placedSymbolArray.emplaceBack(A.x,A.y,A.z,l.x,l.y,b,this.glyphOffsetArray.length-b,_,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],a,0,!1,0,h,0);}_commitLayoutVertex(t,e,r,n,i,s,a){t.emplaceBack(e,r,n,i,s,Math.round(a.x),Math.round(a.y));}_addCollisionDebugVertices(t,e,r,n,i,s,a){const o=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),l=o.vertexLength,u=a.tileAnchorX,c=a.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0,0,0);this._commitDebugCollisionVertexUpdate(r.collisionVertexArrayExt,e,t.padding,a.zOffset),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new q(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new q(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new q(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new q(t.x1,t.y2)),o.vertexLength+=4;const h=r.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),o.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}_addIconDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}generateCollisionDebugBuffers(t,e,r){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Em(Oa,mf.members,La),this.iconCollisionBox=new Em(Oa,mf.members,La);const n=wf(this.iconSizeData,t),i=wf(this.textSizeData,t,r);for(let r=0;r<this.symbolInstances.length;r++){const s=this.symbolInstances.get(r);this._addTextDebugCollisionBoxes(i,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(i,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(n,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(n,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),s=_f(this.textSizeData,t,i)/gf;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=_f(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r,n){t.emplaceBack(e,-r,-r,n),t.emplaceBack(e,r,-r,n),t.emplaceBack(e,r,r,n),t.emplaceBack(e,-r,r,n);}_updateTextDebugCollisionBoxes(t,e,r,n,i,s,a){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}_updateIconDebugCollisionBoxes(t,e,r,n,i,s,a){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}updateCollisionDebugBuffers(t,e,r,n){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const i=wf(this.iconSizeData,t,n),s=wf(this.textSizeData,t,r);for(let a=0;a<this.symbolInstances.length;a++){const o=this.symbolInstances.get(a);this._updateTextDebugCollisionBoxes(s,t,e,o.textBoxStartIndex,o.textBoxEndIndex,o,r),this._updateTextDebugCollisionBoxes(s,t,e,o.verticalTextBoxStartIndex,o.verticalTextBoxEndIndex,o,r),this._updateIconDebugCollisionBoxes(i,t,e,o.iconBoxStartIndex,o.iconBoxEndIndex,o,n),this._updateIconDebugCollisionBoxes(i,t,e,o.verticalIconBoxStartIndex,o.verticalIconBoxEndIndex,o,n);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};if(e<r){const{x1:r,y1:n,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(e);u.textBox={x1:r,y1:n,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.textFeatureIndex=f;}if(n<i){const{x1:e,y1:r,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(n);u.verticalTextBox={x1:e,y1:r,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalTextFeatureIndex=f;}if(s<a){const{x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(s);u.iconBox={x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.iconFeatureIndex=f;}if(o<l){const{x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(o);u.verticalIconBox={x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalIconFeatureIndex=f;}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}hasIconTextFit(){return this.hasAnyIconTextFit}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.tileAnchorX+r*a.tileAnchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}getSortedIndexesByZOffset(){if(!this.zOffsetSortDirty)return this.symbolInstanceIndexesSortedZOffset;if(!this.symbolInstanceIndexesSortedZOffset){this.symbolInstanceIndexesSortedZOffset=[];for(let t=0;t<this.symbolInstances.length;++t)this.symbolInstanceIndexesSortedZOffset.push(t);}return this.zOffsetSortDirty=!1,this.symbolInstanceIndexesSortedZOffset.sort(((t,e)=>this.symbolInstances.get(e).zOffset-this.symbolInstances.get(t).zOffset))}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex);const{rightJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,leftJustifiedTextSymbolIndex:i,verticalPlacedTextSymbolIndex:s,placedIconSymbolIndex:a,verticalPlacedIconSymbolIndex:o}=e;r>=0&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&this.addIndicesForPlacedSymbol(this.text,n),i>=0&&i!==n&&i!==r&&this.addIndicesForPlacedSymbol(this.text,i),s>=0&&this.addIndicesForPlacedSymbol(this.text,s),a>=0&&this.addIndicesForPlacedSymbol(this.icon,a),o>=0&&this.addIndicesForPlacedSymbol(this.icon,o);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let km,Tm,Bm;us(zm,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),zm.addDynamicAttributes=Im;class Vm{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:De,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}us(Vm,"FormatSectionOverride",{omit:["defaultValue"]});const Cm=()=>Bm||(Bm={layout:km||(km=new Xs({"symbol-placement":new Gs(Zs.layout_symbol["symbol-placement"]),"symbol-spacing":new Gs(Zs.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Gs(Zs.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Ys(Zs.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Gs(Zs.layout_symbol["symbol-z-order"]),"symbol-z-elevate":new Gs(Zs.layout_symbol["symbol-z-elevate"]),"symbol-elevation-reference":new Gs(Zs.layout_symbol["symbol-elevation-reference"]),"icon-allow-overlap":new Gs(Zs.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new Gs(Zs.layout_symbol["icon-ignore-placement"]),"icon-optional":new Gs(Zs.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Gs(Zs.layout_symbol["icon-rotation-alignment"]),"icon-size":new Ys(Zs.layout_symbol["icon-size"]),"icon-size-scale-range":new Gs(Zs.layout_symbol["icon-size-scale-range"]),"icon-text-fit":new Ys(Zs.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Ys(Zs.layout_symbol["icon-text-fit-padding"]),"icon-image":new Ys(Zs.layout_symbol["icon-image"]),"icon-rotate":new Ys(Zs.layout_symbol["icon-rotate"]),"icon-padding":new Gs(Zs.layout_symbol["icon-padding"]),"icon-keep-upright":new Gs(Zs.layout_symbol["icon-keep-upright"]),"icon-offset":new Ys(Zs.layout_symbol["icon-offset"]),"icon-anchor":new Ys(Zs.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Gs(Zs.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Gs(Zs.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Gs(Zs.layout_symbol["text-rotation-alignment"]),"text-field":new Ys(Zs.layout_symbol["text-field"]),"text-font":new Ys(Zs.layout_symbol["text-font"]),"text-size":new Ys(Zs.layout_symbol["text-size"]),"text-size-scale-range":new Gs(Zs.layout_symbol["text-size-scale-range"]),"text-max-width":new Ys(Zs.layout_symbol["text-max-width"]),"text-line-height":new Ys(Zs.layout_symbol["text-line-height"]),"text-letter-spacing":new Ys(Zs.layout_symbol["text-letter-spacing"]),"text-justify":new Ys(Zs.layout_symbol["text-justify"]),"text-radial-offset":new Ys(Zs.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Gs(Zs.layout_symbol["text-variable-anchor"]),"text-anchor":new Ys(Zs.layout_symbol["text-anchor"]),"text-max-angle":new Gs(Zs.layout_symbol["text-max-angle"]),"text-writing-mode":new Gs(Zs.layout_symbol["text-writing-mode"]),"text-rotate":new Ys(Zs.layout_symbol["text-rotate"]),"text-padding":new Gs(Zs.layout_symbol["text-padding"]),"text-keep-upright":new Gs(Zs.layout_symbol["text-keep-upright"]),"text-transform":new Ys(Zs.layout_symbol["text-transform"]),"text-offset":new Ys(Zs.layout_symbol["text-offset"]),"text-allow-overlap":new Gs(Zs.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new Gs(Zs.layout_symbol["text-ignore-placement"]),"text-optional":new Gs(Zs.layout_symbol["text-optional"]),visibility:new Gs(Zs.layout_symbol.visibility)})),paint:Tm||(Tm=new Xs({"icon-opacity":new Ys(Zs.paint_symbol["icon-opacity"]),"icon-occlusion-opacity":new Ys(Zs.paint_symbol["icon-occlusion-opacity"]),"icon-emissive-strength":new Ys(Zs.paint_symbol["icon-emissive-strength"]),"text-emissive-strength":new Ys(Zs.paint_symbol["text-emissive-strength"]),"icon-color":new Ys(Zs.paint_symbol["icon-color"]),"icon-halo-color":new Ys(Zs.paint_symbol["icon-halo-color"]),"icon-halo-width":new Ys(Zs.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Ys(Zs.paint_symbol["icon-halo-blur"]),"icon-translate":new Gs(Zs.paint_symbol["icon-translate"]),"icon-translate-anchor":new Gs(Zs.paint_symbol["icon-translate-anchor"]),"icon-image-cross-fade":new Ys(Zs.paint_symbol["icon-image-cross-fade"]),"text-opacity":new Ys(Zs.paint_symbol["text-opacity"]),"text-occlusion-opacity":new Ys(Zs.paint_symbol["text-occlusion-opacity"]),"text-color":new Ys(Zs.paint_symbol["text-color"],{runtimeType:Oe,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Ys(Zs.paint_symbol["text-halo-color"]),"text-halo-width":new Ys(Zs.paint_symbol["text-halo-width"]),"text-halo-blur":new Ys(Zs.paint_symbol["text-halo-blur"]),"text-translate":new Gs(Zs.paint_symbol["text-translate"]),"text-translate-anchor":new Gs(Zs.paint_symbol["text-translate-anchor"]),"icon-color-saturation":new Gs(Zs.paint_symbol["icon-color-saturation"]),"icon-color-contrast":new Gs(Zs.paint_symbol["icon-color-contrast"]),"icon-color-brightness-min":new Gs(Zs.paint_symbol["icon-color-brightness-min"]),"icon-color-brightness-max":new Gs(Zs.paint_symbol["icon-color-brightness-max"]),"symbol-z-offset":new Ys(Zs.paint_symbol["symbol-z-offset"]),"icon-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"icon-halo-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"text-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"text-halo-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},Bm);class Dm extends ma{constructor(t,e,r,n){super(t,Cm(),e,r,n),this._colorAdjustmentMatrix=O.mat4.identity([]),this.hasInitialOcclusionOpacityProperties=void 0!==t.paint&&("icon-occlusion-opacity"in t.paint||"text-occlusion-opacity"in t.paint);}recalculate(t,e){super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getColorAdjustmentMatrix(t,e,r,n){return this._saturation===t&&this._contrast===e&&this._brightnessMin===r&&this._brightnessMax===n||(this._colorAdjustmentMatrix=function(t,e,r,n){t=Mt(t),e=wt(e);const i=O.mat4.create(),s=t/3,a=1-2*s,o=[a,s,s,0,s,a,s,0,s,s,a,0,0,0,0,1],l=.5-.5*e,u=n-r;return O.mat4.multiply(i,[u,0,0,0,0,u,0,0,0,0,u,0,r,r,r,1],[e,0,0,0,0,e,0,0,0,0,e,0,l,l,l,1]),O.mat4.multiply(i,i,o),i}(t,e,r,n),this._saturation=t,this._contrast=e,this._brightnessMin=r,this._brightnessMax=n),this._colorAdjustmentMatrix}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Ki(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new zm(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of Cm().paint.overridableProperties){if(!Dm.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Vm(e),n=new Wi(r,e.property.specification,this.scope,this.options);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Qi("source",n):new ts("composite",n,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new qs(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Dm.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=Cm().paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Qe)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof ar&&ir(e.value)===qe?s(e.value.sections):e instanceof cr?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramIds(){return ["symbol"]}getDefaultProgramParams(t,e,r){return {config:new $o(this,{zoom:e,lut:r}),overrideFog:!1}}}let Rm,Lm,Fm,Om;var Nm=va([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);function Um(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.RGBA;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.DEPTH_COMPONENT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.DEPTH_STENCIL;case WebGL2RenderingContext.R8:case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.RED}}function jm(t){switch(t){case WebGL2RenderingContext.RGBA8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.DEPTH_COMPONENT16:return WebGL2RenderingContext.UNSIGNED_SHORT;case WebGL2RenderingContext.DEPTH24_STENCIL8:return WebGL2RenderingContext.UNSIGNED_INT_24_8;case WebGL2RenderingContext.R8:return WebGL2RenderingContext.UNSIGNED_BYTE;case WebGL2RenderingContext.R32F:return WebGL2RenderingContext.FLOAT}}class qm{constructor(t,e,r,n){this.context=t,this.format=r,this.useMipmap=n&&n.useMipmap,this.texture=t.gl.createTexture(),this.update(e,{premultiply:n&&n.premultiply});}update(t,e){const r=t&&t instanceof HTMLVideoElement&&0===t.width?t.videoWidth:t.width,n=t&&t instanceof HTMLVideoElement&&0===t.height?t.videoHeight:t.height,{context:i}=this,{gl:s}=i,{x:a,y:o}=e&&e.position?e.position:{x:0,y:0},l=a+r,u=o+n;!this.size||this.size[0]===l&&this.size[1]===u||(s.bindTexture(s.TEXTURE_2D,null),s.deleteTexture(this.texture),this.texture=s.createTexture(),this.size=null),s.bindTexture(s.TEXTURE_2D,this.texture),i.pixelStoreUnpackFlipY.set(!1),i.pixelStoreUnpack.set(1),i.pixelStoreUnpackPremultiplyAlpha.set(this.format===s.RGBA8&&(!e||!1!==e.premultiply));const c=t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap;if(!this.size&&l>0&&u>0){const t=this.useMipmap?Math.floor(Math.log2(Math.max(l,u)))+1:1;s.texStorage2D(s.TEXTURE_2D,t,this.format,l,u),this.size=[l,u];}if(this.size)if(c)s.texSubImage2D(s.TEXTURE_2D,0,a,o,Um(this.format),jm(this.format),t);else {const e=t.data;e&&s.texSubImage2D(s.TEXTURE_2D,0,a,o,r,n,Um(this.format),jm(this.format),e);}this.useMipmap&&s.generateMipmap(s.TEXTURE_2D);}bind(t,e,r=!1){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),t!==this.minFilter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,this.useMipmap&&!r?t===i.NEAREST?i.NEAREST_MIPMAP_NEAREST:i.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),e!==this.wrapS&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrapS=e);}bindExtraParam(t,e,r,n){const{context:i}=this,{gl:s}=i;s.bindTexture(s.TEXTURE_2D,this.texture),e!==this.magFilter&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,e),this.magFilter=e),t!==this.minFilter&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,this.useMipmap?t===s.NEAREST?s.NEAREST_MIPMAP_NEAREST:s.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),r!==this.wrapS&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,r),this.wrapS=r),n!==this.wrapT&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,n),this.wrapT=n);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class $m{constructor(t,e){this.context=t,this.texture=e;}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}}function Gm(t,e,r,n,i,s,a,o){const l=[t,e,1,r,n,1,i,s,1],u=[a,o,1],c=O.mat3.adjoint([],l),[h,p,f]=O.vec3.transformMat3(u,u,c);return O.mat3.multiply(l,l,[h,0,0,0,p,0,0,0,f])}function Ym(t,e,r,n,i,s,a,o){const l=function(t,e,r,n,i,s,a,o){const l=Gm(0,0,1,0,1,1,0,1),u=Gm(t,e,r,n,i,s,a,o),c=O.mat3.adjoint([],l);return O.mat3.multiply(u,u,c)}(t,e,r,n,i,s,a,o);return [l[2]/l[8]/Kr,l[5]/l[8]/Kr]}function Hm(t){return [t[0],Math.min(Math.max(t[1],-bl),bl)]}class Xm extends _e{constructor(t,e,r,n){super(),this.id=t,this.dispatcher=r,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.onNorthPole=!1,this.onSouthPole=!1,this.setEventedParent(n),this.options=e,this._dirty=!1;}load(t,e){if(this._loaded=e||!1,this.fire(new ge("dataloading",{dataType:"source"})),this.url=this.options.url,!this.url)return t&&(this.coordinates=t),this._loaded=!0,void this._finishLoading();this._imageRequest=le(this.map._requestManager.transformRequest(this.url,Qt.Image),((e,r)=>{this._imageRequest=null,this._loaded=!0,e?this.fire(new xe(e)):r&&(this.image=r instanceof HTMLImageElement?Ct.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading());}));}loaded(){return this._loaded}updateImage(t){return t.url?(this._imageRequest&&t.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=t.url,this.load(t.coordinates,this._loaded),this):this}setTexture(t){if(!(t.handle instanceof WebGLTexture))throw new Error("The provided handle is not a WebGLTexture instance");return this.texture=new $m(this.map.painter.context,t.handle),this.width=t.dimensions[0],this.height=t.dimensions[1],this._dirty=!1,this._loaded=!0,this._finishLoading(),this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new ge("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(t){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),!this.texture||this.texture instanceof $m||this.texture.destroy(),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy());}setCoordinates(t){if(this.coordinates=t,this._boundsArray=void 0,this._unsupportedCoords=!1,!t.length)return this;this.onNorthPole=!1,this.onSouthPole=!1;let e=t[0][1],r=t[0][1];for(const n of t)n[1]>r&&(r=n[1]),n[1]<e&&(e=n[1]);const n=(r+e)/2;if(n>bl?this.onNorthPole=!0:n<-bl&&(this.onSouthPole=!0),!this.onNorthPole&&!this.onSouthPole){const e=t.map(Il.fromLngLat);this.tileID=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);const s=Math.max(n-e,i-r),a=Math.max(0,Math.floor(-Math.log(s)/Math.LN2)),o=Math.pow(2,a);let l=Math.floor((e+n)/2*o);return l>1&&(l-=1),new ou(a,l,Math.floor((r+i)/2*o))}(e),this.minzoom=this.maxzoom=this.tileID.z;}return this.fire(new ge("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0,this._unsupportedCoords=!1;}_prepareData(t){for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}if(this._boundsArray||this.onNorthPole||this.onSouthPole||this._unsupportedCoords)return;const e=Kd(new ou(0,0,0),this.map.transform.projection),r=[e.projection.project(this.coordinates[0][0],this.coordinates[0][1]),e.projection.project(this.coordinates[1][0],this.coordinates[1][1]),e.projection.project(this.coordinates[2][0],this.coordinates[2][1]),e.projection.project(this.coordinates[3][0],this.coordinates[3][1])];if(!function(t){const e=t[1].x-t[0].x,r=t[1].y-t[0].y,n=t[2].x-t[1].x,i=t[2].y-t[1].y,s=t[3].x-t[2].x,a=t[3].y-t[2].y,o=t[0].x-t[3].x,l=t[0].y-t[3].y,u=e*i-n*r,c=n*a-s*i,h=s*l-o*a,p=o*r-e*l;return u>0&&c>0&&h>0&&p>0||u<0&&c<0&&h<0&&p<0}(r))return console.warn("Image source coordinates are defining non-convex area in the Mercator projection"),void(this._unsupportedCoords=!0);const n=Kd(this.tileID,this.map.transform.projection),[i,s,a,o]=this.coordinates.map((t=>{const e=n.projection.project(t[0],t[1]);return Jd(n,e)._round()}));this.perspectiveTransform=Ym(i.x,i.y,s.x,s.y,a.x,a.y,o.x,o.y);const l=this._boundsArray=new Ma;l.emplaceBack(i.x,i.y,0,0),l.emplaceBack(s.x,s.y,Kr,0),l.emplaceBack(o.x,o.y,0,Kr),l.emplaceBack(a.x,a.y,Kr,Kr),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy()),this.boundsBuffer=t.createVertexBuffer(l,Nm.members),this.boundsSegments=xo.simpleSegment(0,0,4,2);const u=[],c=[Hm((h=this.coordinates)[0]),Hm(h[1]),Hm(h[2]),Hm(h[3])];var h;const[p,f,d,m]=function(t){let e=t[0][0],r=e,n=t[0][1],i=n;for(let s=1;s<t.length;s++)t[s][0]<e?e=t[s][0]:t[s][0]>r&&(r=t[s][0]),t[s][1]<n?n=t[s][1]:t[s][1]>i&&(i=t[s][1]);return [e,n,r-e,i-n]}(c);{const n=new Ma,[i,s,a,o]=function(t){let e=t[0].x,r=e,n=t[0].y,i=n;for(let s=1;s<t.length;s++)t[s].x<e?e=t[s].x:t[s].x>r&&(r=t[s].x),t[s].y<n?n=t[s].y:t[s].y>i&&(i=t[s].y);return [e,n,r-e,i-n]}(r),l=t=>[(t.x-i)/a,(t.y-s)/o],[c,h,y,g]=r.map(l),x=function(t,e,r,n,i,s,a,o){const l=Gm(0,0,1,0,1,1,0,1),u=Gm(t,e,r,n,i,s,a,o),c=O.mat3.adjoint([],u);return O.mat3.multiply(l,l,c)}(c[0],c[1],h[0],h[1],y[0],y[1],g[0],g[1]);this.elevatedGlobePerspectiveTransform=Ym(c[0],c[1],h[0],h[1],y[0],y[1],g[0],g[1]);const v=(t,e)=>{u.push(t.lng);const r=Math.round((t.lng-p)/d*Kr),i=Math.round((t.lat-f)/m*Kr),s=l(e),a=O.vec3.transformMat3([],[s[0],s[1],1],x),o=Math.round(a[0]/a[2]*Kr),c=Math.round(a[1]/a[2]*Kr);n.emplaceBack(r,i,o,c);},b=r[3].x-r[0].x,_=r[3].y-r[0].y,w=r[2].x-r[1].x,M=r[2].y-r[1].y;for(let t=0;t<65;t++){const n=t/64,i=[r[0].x+n*b,r[0].y+n*_],s=[r[1].x+n*w,r[1].y+n*M],a=s[0]-i[0],o=s[1]-i[1];for(let t=0;t<65;t++){const r=t/64,n={x:i[0]+a*r,y:i[1]+o*r,z:0};v(e.projection.unproject(n.x,n.y),n);}}this.elevatedGlobeVertexBuffer=t.createVertexBuffer(n,Nm.members);}{this.maxLongitudeTriangleSize=0;let e=[],r=new ja;const n=(t,n,i)=>{r.emplaceBack(t,n,i);const s=u[t],a=u[n],o=u[i],l=Math.min(Math.min(s,a),o),c=Math.max(Math.max(s,a),o)-l;c>this.maxLongitudeTriangleSize&&(this.maxLongitudeTriangleSize=c),e.push(l+c/2);};for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=65*t+e,i=r+1,s=r+65,a=s+1;n(r,s,i),n(i,s,a);}[e,r]=function(t,e){const r=Array.from({length:t.length},((t,e)=>e));r.sort(((e,r)=>t[e]-t[r]));const n=[],i=new ja;for(let s=0;s<r.length;s++){const a=r[s];n.push(t[a]);const o=3*a,l=o+1;i.emplaceBack(e.uint16[o],e.uint16[l],e.uint16[l+1]);}return [n,i]}(e,r),this.elevatedGlobeTrianglesCenterLongitudes=e,this.elevatedGlobeIndexBuffer=t.createIndexBuffer(r);}this.elevatedGlobeSegments=xo.simpleSegment(0,0,4225,8192),this.elevatedGlobeGridMatrix=new Float32Array([0,d/Kr,0,m/Kr,0,0,f,p,0]);}prepare(){const t=0!==Object.keys(this.tiles).length;if(this.tileID&&!t)return;const e=this.map.painter.context,r=e.gl;!this._dirty||this.texture instanceof $m||(this.texture?this.texture.update(this.image):(this.texture=new qm(e,this.image,r.RGBA8),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE)),this._dirty=!1),t&&this._prepareData(e);}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}getSegmentsForLongitude(t){const e=this.elevatedGlobeSegments;if(!this.elevatedGlobeTrianglesCenterLongitudes||!e)return null;const r=this.elevatedGlobeTrianglesCenterLongitudes;let n=(i=t+180)+360*Math.round((r[0]-i)/360);var i;const s=new xo,a=(t,r)=>{s.segments.push({vertexOffset:0,primitiveOffset:t,vertexLength:e.segments[0].vertexLength,primitiveLength:r,sortKey:void 0,vaos:{}});},o=.51*this.maxLongitudeTriangleSize;if(Math.abs(r[0]-n)<=o){const t=_t(r,0,r.length,n+o);return t===r.length||a(t,bt(r,t+1,r.length,n+360-o)-t),s}n<r[0]&&(n+=360);const l=bt(r,0,r.length,n-o);if(l===r.length)return a(0,r.length),s;a(0,l-0);const u=_t(r,l+1,r.length,n+o);return u!==r.length&&a(u,r.length-u),s}}const Zm=(Math.pow(256,2)-1)/16907520;class Wm extends ma{constructor(t,e,r,n){super(t,{layout:Fm||(Fm=new Xs({visibility:new Gs(Zs.layout_raster.visibility)})),paint:Om||(Om=new Xs({"raster-opacity":new Gs(Zs.paint_raster["raster-opacity"]),"raster-color":new Hs(Zs.paint_raster["raster-color"]),"raster-color-mix":new Gs(Zs.paint_raster["raster-color-mix"]),"raster-color-range":new Gs(Zs.paint_raster["raster-color-range"]),"raster-hue-rotate":new Gs(Zs.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Gs(Zs.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Gs(Zs.paint_raster["raster-brightness-max"]),"raster-saturation":new Gs(Zs.paint_raster["raster-saturation"]),"raster-contrast":new Gs(Zs.paint_raster["raster-contrast"]),"raster-resampling":new Gs(Zs.paint_raster["raster-resampling"]),"raster-fade-duration":new Gs(Zs.paint_raster["raster-fade-duration"]),"raster-emissive-strength":new Gs(Zs.paint_raster["raster-emissive-strength"]),"raster-array-band":new Gs(Zs.paint_raster["raster-array-band"]),"raster-elevation":new Gs(Zs.paint_raster["raster-elevation"]),"raster-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this.updateColorRamp(),this._curRampRange=[NaN,NaN];}getProgramIds(){return ["raster"]}hasColorMap(){return !!this._transitionablePaint._values["raster-color"].value.value}tileCoverLift(){return this.paint.get("raster-elevation")}isDraped(t){return !(t&&t._source instanceof Xm&&(t._source.onNorthPole||t._source.onSouthPole))&&0===this.paint.get("raster-elevation")}_handleSpecialPaintPropertyUpdate(t){"raster-color"!==t&&"raster-color-range"!==t||(this._curRampRange=[NaN,NaN],this.updateColorRamp());}updateColorRamp(t){if(!this.hasColorMap())return;if(!this._curRampRange)return;const e=this._transitionablePaint._values["raster-color"].value.expression,[r,n]=t||this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({zoom:0})||[NaN,NaN];isNaN(r)&&isNaN(n)||r===this._curRampRange[0]&&n===this._curRampRange[1]||(this.colorRamp=dc({expression:e,evaluationKey:"rasterValue",image:this.colorRamp,clips:[{start:r,end:n}],resolution:256}),this.colorRampTexture=null,this._curRampRange=[r,n]);}}let Km,Jm,Qm,ty,ey;class ry extends ma{constructor(t,e,r,n){super(t,{layout:Km||(Km=new Xs({visibility:new Gs(Zs["layout_raster-particle"].visibility)})),paint:Jm||(Jm=new Xs({"raster-particle-array-band":new Gs(Zs["paint_raster-particle"]["raster-particle-array-band"]),"raster-particle-count":new Gs(Zs["paint_raster-particle"]["raster-particle-count"]),"raster-particle-color":new Hs(Zs["paint_raster-particle"]["raster-particle-color"]),"raster-particle-max-speed":new Gs(Zs["paint_raster-particle"]["raster-particle-max-speed"]),"raster-particle-speed-factor":new Gs(Zs["paint_raster-particle"]["raster-particle-speed-factor"]),"raster-particle-fade-opacity-factor":new Gs(Zs["paint_raster-particle"]["raster-particle-fade-opacity-factor"]),"raster-particle-reset-rate-factor":new Gs(Zs["paint_raster-particle"]["raster-particle-reset-rate-factor"]),"raster-particle-elevation":new Gs(Zs["paint_raster-particle"]["raster-particle-elevation"]),"raster-particle-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp(),this.lastInvalidatedAt=Ct.now();}onRemove(t){this.colorRampTexture&&this.colorRampTexture.destroy(),this.tileFramebuffer&&this.tileFramebuffer.destroy(),this.particleFramebuffer&&this.particleFramebuffer.destroy();}hasColorMap(){return !!this._transitionablePaint._values["raster-particle-color"].value.value}getProgramIds(){return ["rasterParticle"]}hasOffscreenPass(){return "none"!==this.visibility}isDraped(t){return !1}_handleSpecialPaintPropertyUpdate(t){"raster-particle-color"!==t&&"raster-particle-max-speed"!==t||(this._updateColorRamp(),this._invalidateAnimationState()),"raster-particle-count"===t&&this._invalidateAnimationState();}_updateColorRamp(){if(!this.hasColorMap())return;const t=this._transitionablePaint._values["raster-particle-color"].value.expression,e=this._transitionablePaint._values["raster-particle-max-speed"].value.expression.evaluate({zoom:0});this.colorRamp=dc({expression:t,evaluationKey:"rasterParticleSpeed",image:this.colorRamp,clips:[{start:0,end:e}],resolution:256}),this.colorRampTexture=null;}_invalidateAnimationState(){this.lastInvalidatedAt=Ct.now();}tileCoverLift(){return this.paint.get("raster-particle-elevation")}}class ny extends ma{constructor(t,e){super(t,{},e,null),this.implementation=t,t.slot&&(this.slot=t.slot);}is3D(t){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isDraped(t){return void 0!==this.implementation.renderToTile}shouldRedrape(){return !!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}function iy(t,e,r){const n=[0,0,1],i=O.quat.identity([]);return O.quat.rotateY(i,i,r?-H(t)+Math.PI:H(t)),O.quat.rotateX(i,i,-H(e)),O.vec3.transformQuat(n,n,i),O.vec3.normalize(n,n)}function sy(t,e){const r=oy(t.projection,t.zoom,t.width,t.height),n=function(t,e,r,n,i){const s=new ul(r.lng-180*ly,r.lat),a=new ul(r.lng+180*ly,r.lat),o=t.project(s.lng,s.lat),l=t.project(a.lng,a.lat),u=-Math.atan2(l.y-o.y,l.x-o.x),c=Il.fromLngLat(r);c.y=Q(c.y,-1+ly,1-ly);const h=c.toLngLat(),p=t.project(h.lng,h.lat),f=Il.fromLngLat(h);f.x+=ly;const d=f.toLngLat(),m=t.project(d.lng,d.lat),y=cy(m.x-p.x,m.y-p.y,u),g=Il.fromLngLat(h);g.y+=ly;const x=g.toLngLat(),v=t.project(x.lng,x.lat),b=cy(v.x-p.x,v.y-p.y,u),_=Math.abs(y.x)/Math.abs(b.y),w=O.mat4.identity([]);O.mat4.rotateZ(w,w,-u*(1-(i?0:n)));const M=O.mat4.identity([]);return O.mat4.scale(M,M,[1,1-(1-_)*n,1]),M[4]=-b.x/b.y*n,O.mat4.rotateZ(M,M,u),O.mat4.multiply(M,w,M),M}(t.projection,0,t.center,r,e),i=ay(t);return O.mat4.scale(n,n,[i,i,1]),n}function ay(t){const e=t.projection,r=oy(t.projection,t.zoom,t.width,t.height),n=uy(e,t.center),i=uy(e,ul.convert(e.center));return Math.pow(2,n*r+(1-r)*i)}function oy(t,e,r,n,i=1/0){const s=t.range;if(!s)return 0;const a=Math.min(i,Math.max(r,n)),o=Math.log(a/1024)/Math.LN2;return tt(s[0]+o,s[1]+o,e)}const ly=1/4e4;function uy(t,e){const r=Q(e.lat,-bl,bl),n=new ul(e.lng-180*ly,r),i=new ul(e.lng+180*ly,r),s=t.project(n.lng,r),a=t.project(i.lng,r),o=Il.fromLngLat(n),l=Il.fromLngLat(i),u=a.x-s.x,c=a.y-s.y,h=l.x-o.x,p=l.y-o.y,f=Math.sqrt((h*h+p*p)/(u*u+c*c));return Math.log(f)/Math.LN2}function cy(t,e,r){const n=Math.cos(r),i=Math.sin(r);return {x:t*n-e*i,y:t*i+e*n}}function hy(t,e,r){O.mat4.identity(t),O.mat4.rotateZ(t,t,H(e[2])),O.mat4.rotateX(t,t,H(e[0])),O.mat4.rotateY(t,t,H(e[1])),O.mat4.scale(t,t,r),O.mat4.multiply(t,t,[1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1]);}function py(t,e,r,n,i,s,a,o){const l=[r[0]-e[0],r[1]-e[1],0],u=[n[0]-e[0],n[1]-e[1],0];if(O.vec3.length(l)<1e-12||O.vec3.length(u)<1e-12)return O.quat.identity(t);const c=O.vec3.cross([],l,u);O.vec3.normalize(c,c),O.vec3.subtract(u,n,e),l[2]=(s-i)*o,u[2]=(a-i)*o;const h=l;return O.vec3.cross(h,l,u),O.vec3.normalize(h,h),O.quat.rotationTo(t,c,h)}function fy(t,e,r=!1){const n=$u(e.zoom),i=function(t,e,r){const n=e.worldSize,i=[t[12],t[13],t[14]],s=xl(i[1]/n),a=gl(i[0]/n),o=O.mat4.identity([]),l=yl(1,s)*n,u=yl(1,0)*n*wl(s,e.zoom),c=1/Uu(n);let h=u*c;if(r){const t=oy(e.projection,e.zoom,e.width,e.height,1024);h=c*e.projection.pixelSpaceConversion(e.center.lat,n,t);}const p=al(s,a);O.vec3.add(p,p,O.vec3.scale([],O.vec3.normalize([],p),l*h*i[2]));const f=function(t){const e=[t[0],t[1],t[2]];let r=[0,1,0];const n=O.vec3.cross([],r,e);return O.vec3.cross(r,e,n),0===O.vec3.squaredLength(r)&&(r=[0,1,0],O.vec3.cross(n,e,r)),O.vec3.normalize(n,n),O.vec3.normalize(r,r),O.vec3.normalize(e,e),[n[0],n[1],n[2],0,r[0],r[1],r[2],0,e[0],e[1],e[2],0,t[0],t[1],t[2],1]}(p);O.mat4.scale(o,o,[h,h,h*l]),O.mat4.translate(o,o,[-i[0],-i[1],-i[2]]);const d=O.mat4.multiply([],e.globeMatrix,f);return O.mat4.multiply(d,d,o),O.mat4.multiply(d,d,t),d}(t,e,r);if(n>0){const r=function(t,e){const r=e.worldSize,n=yl(1,0)*r*wl(e.center.lat,e.zoom)/Uu(r),i=yl(1,e.center.lat)*r,s=O.mat4.identity([]);return O.mat4.rotateY(s,s,H(e.center.lng)),O.mat4.rotateX(s,s,H(e.center.lat)),O.mat4.translate(s,s,[0,0,Ko]),O.mat4.scale(s,s,[n,n,n*i]),O.mat4.translate(s,s,[e.point.x-.5*r,e.point.y-.5*r,0]),O.mat4.multiply(s,s,t),O.mat4.multiply(s,e.globeMatrix,s)}(t,e);return function(t,e,r){const n=(t,e,r)=>{const n=O.vec3.length(t),i=O.vec3.length(e),s=Tu(t,e,r);return O.vec3.scale(s,s,1/O.vec3.length(s)*Ee(n,i,r))},i=n([t[0],t[1],t[2]],[e[0],e[1],e[2]],r),s=n([t[4],t[5],t[6]],[e[4],e[5],e[6]],r),a=n([t[8],t[9],t[10]],[e[8],e[9],e[10]],r),o=Tu([t[12],t[13],t[14]],[e[12],e[13],e[14]],r);return [i[0],i[1],i[2],0,s[0],s[1],s[2],0,a[0],a[1],a[2],0,o[0],o[1],o[2],1]}(i,r,n)}return i}function dy(t,e,r,n){const i=Au.projectAabbCorners(n,r);let s=Number.MAX_VALUE,a=-1;for(let t=0;t<i.length;++t){const r=i[t];r[0]=(.5*r[0]+.5)*e.width,r[1]=(.5-.5*r[1])*e.height,r[2]<s&&(a=t,s=r[2]);}const o=t=>new q(i[t][0],i[t][1]);let l;switch(a){case 0:case 6:l=[o(1),o(5),o(4),o(7),o(3),o(2),o(1)];break;case 1:case 7:l=[o(0),o(4),o(5),o(6),o(2),o(3),o(0)];break;case 3:case 5:l=[o(1),o(0),o(4),o(7),o(6),o(2),o(1)];break;default:l=[o(1),o(5),o(6),o(7),o(3),o(0),o(1)];}if(Fl(t,l))return s}const my=va([{name:"a_pos_3f",components:3,type:"Float32"}]),yy=va([{name:"a_color_3f",components:3,type:"Float32"}]),gy=va([{name:"a_color_4f",components:4,type:"Float32"}]),xy=va([{name:"a_uv_2f",components:2,type:"Float32"}]),vy=va([{name:"a_normal_3f",components:3,type:"Float32"}]),by=va([{name:"a_normal_matrix0",components:4,type:"Float32"},{name:"a_normal_matrix1",components:4,type:"Float32"},{name:"a_normal_matrix2",components:4,type:"Float32"},{name:"a_normal_matrix3",components:4,type:"Float32"}]),_y=va([{name:"a_pbr",components:4,type:"Uint16"},{name:"a_heightBasedEmissiveStrength",components:3,type:"Float32"}]),wy={None:0,Model:1,Symbol:2,FillExtrusion:4,All:7};class My{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function Ay(t,e){const r=-1===t.indexOf("://");try{return new URL(t,r&&e?"http://example.com":void 0),!0}catch(t){return !1}}class Iy{constructor(t,e){this.feature=t,this.instancedDataOffset=e,this.instancedDataCount=0,this.rotation=[0,0,0],this.scale=[1,1,1],this.translation=[0,0,0];}}class Sy{constructor(){this.instancedDataArray=new Ja,this.instancesEvaluatedElevation=[],this.features=[],this.idToFeaturesIndex={};}}class Py{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.projection=t.projection,this.index=t.index,this.hasZoomDependentProperties=this.layers[0].isZoomDependent(),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.hasPattern=!1,this.instancesPerModel={},this.validForExaggeration=0,this.maxVerticalOffset=0,this.maxScale=0,this.maxHeight=0,this.lookupDim=this.zoom>this.canonical.z?256:this.zoom>15?75:100,this.instanceCount=0,this.terrainElevationMin=0,this.terrainElevationMax=0,this.validForDEMTile={id:null,timestamp:0},this.modelUris=[],this.modelsRequested=!1,this.activeReplacements=[],this.replacementUpdateTime=0;}updateFootprints(t,e){}populate(t,e,r,n){this.tileToMeter=Al(r);const i=this.layers[0]._featureFilter.needGeometry;this.lookup=new Uint8Array(this.lookupDim*this.lookupDim);for(const{feature:s,id:a,index:o,sourceLayerIndex:l}of t){const t=null!=a?a:s.properties&&s.properties.hasOwnProperty("id")?s.properties.id:void 0,u=Cl(s,i);if(!this.layers[0]._featureFilter.filter(new Rs(this.zoom),u,r))continue;const c={id:t,sourceLayerIndex:l,index:o,geometry:i?u.geometry:Vl(s,r,n),properties:s.properties,type:s.type,patterns:{}},h=this.addFeature(c,c.geometry,u);h&&e.featureIndex.insert(s,c.geometry,o,l,this.index,this.instancesPerModel[h].instancedDataArray.length,Kr/32);}this.lookup=null;}update(t,e,r,n){for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e in t)r.idToFeaturesIndex.hasOwnProperty(e)&&(this.evaluate(r.features[r.idToFeaturesIndex[e]],t[e],r,!0),this.uploaded=!1);}this.maxHeight=0;}updateZoomBasedPaintProperties(){if(!this.hasZoomDependentProperties)return !1;let t=!1;for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e of r.features){const n=this.layers[0],i=e.feature,s=this.canonical,a=n.paint.get("model-rotation").evaluate(i,{},s),o=n.paint.get("model-scale").evaluate(i,{},s),l=n.paint.get("model-translation").evaluate(i,{},s);O.vec3.exactEquals(e.rotation,a)&&O.vec3.exactEquals(e.scale,o)&&O.vec3.exactEquals(e.translation,l)||(this.evaluate(e,e.featureStates,r,!0),t=!0);}}return t}updateReplacement(t,e,r,n){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const i=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);if(Yh(this.activeReplacements,i))return !1;this.activeReplacements=i;let s=!1;for(const e in this.instancesPerModel){const i=this.instancesPerModel[e],a=i.instancedDataArray;for(const e of i.features){const i=e.instancedDataOffset,o=e.instancedDataCount;for(let e=0;e<o;e++){const o=16*(e+i);let l=a.float32[o+0];const u=l>Kr;l=u?l-Kr:l;const c=Math.floor(l),h=a.float32[o+1];let p=!1;for(const e of this.activeReplacements)if(!jh(e,r,wy.Model,n)&&!(e.min.x>c||c>e.max.x||e.min.y>h||h>e.max.y)&&(p=Jh(Kh(c,h,t.canonical,e.footprintTileId.canonical),e.footprint),p))break;a.float32[o]=p?l+Kr:l,s=s||p!==u;}}}return s}isEmpty(){for(const t in this.instancesPerModel)if(0!==this.instancesPerModel[t].instancedDataArray.length)return !1;return !0}uploadPending(){return !this.uploaded}upload(t){if(!this.uploaded)for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];r.instancedDataArray.length<0||0===r.instancedDataArray.length||(r.instancedDataBuffer?r.instancedDataBuffer.updateData(r.instancedDataArray):r.instancedDataBuffer=t.createVertexBuffer(r.instancedDataArray,by.members,!0,void 0,this.instanceCount));}this.uploaded=!0;}destroy(){for(const t in this.instancesPerModel){const e=this.instancesPerModel[t];0!==e.instancedDataArray.length&&e.instancedDataBuffer&&e.instancedDataBuffer.destroy();}const t=this.layers[0].modelManager;if(t&&this.modelUris)for(const e of this.modelUris)t.removeModel(e,"");}addFeature(t,e,r){const n=this.layers[0],i=n.layout.get("model-id").evaluate(r,{},this.canonical);if(!i)return pt(`modelId is not evaluated for layer ${n.id} and it is not going to get rendered.`),i;Ay(i,!1)&&(this.modelUris.includes(i)||this.modelUris.push(i)),this.instancesPerModel[i]||(this.instancesPerModel[i]=new Sy);const s=this.instancesPerModel[i],a=s.instancedDataArray,o=new Iy(r,a.length);for(const t of e)for(const e of t){if(e.x<0||e.x>=Kr||e.y<0||e.y>=Kr)continue;const t=(this.lookupDim-1)/Kr,r=this.lookupDim*(e.y*t|0)+e.x*t|0;if(this.lookup){if(0!==this.lookup[r])continue;this.lookup[r]=1;}this.instanceCount++;const n=a.length;a.resize(n+1),s.instancesEvaluatedElevation.push(0),a.float32[16*n]=e.x,a.float32[16*n+1]=e.y;}return o.instancedDataCount=s.instancedDataArray.length-o.instancedDataOffset,o.instancedDataCount>0&&(t.id&&(s.idToFeaturesIndex[t.id]=s.features.length),s.features.push(o),this.evaluate(o,{},s,!1)),i}getModelUris(){return this.modelUris}evaluate(t,e,r,n){const i=this.layers[0],s=t.feature,a=this.canonical,o=t.rotation=i.paint.get("model-rotation").evaluate(s,e,a),l=t.scale=i.paint.get("model-scale").evaluate(s,e,a),u=t.translation=i.paint.get("model-translation").evaluate(s,e,a),c=i.paint.get("model-color").evaluate(s,e,a);c.a=i.paint.get("model-color-mix-intensity").evaluate(s,e,a);const h=[];this.maxVerticalOffset<u[2]&&(this.maxVerticalOffset=u[2]),this.maxScale=Math.max(Math.max(this.maxScale,l[0]),Math.max(l[1],l[2])),hy(h,o,l);const p=Math.round(100*c.a)+c.b/1.05;for(let e=0;e<t.instancedDataCount;++e){const i=t.instancedDataOffset+e,s=16*i,o=r.instancedDataArray.float32;let l=0;n&&(l=o[s+6]-r.instancesEvaluatedElevation[i]);const f=0|o[s+1];o[s]=(0|o[s])+c.r/1.05,o[s+1]=f+c.g/1.05,o[s+2]=p,o[s+3]=1/(a.z>10?this.tileToMeter:Al(a,f)),o[s+4]=u[0],o[s+5]=u[1],o[s+6]=u[2]+l,o[s+7]=h[0],o[s+8]=h[1],o[s+9]=h[2],o[s+10]=h[4],o[s+11]=h[5],o[s+12]=h[6],o[s+13]=h[8],o[s+14]=h[9],o[s+15]=h[10],r.instancesEvaluatedElevation[i]=u[2];}}}let Ey,zy;us(Py,"ModelBucket",{omit:["layers"]}),us(Sy,"PerModelAttributes"),us(Iy,"ModelFeature");const ky=64,Ty={CoordinateSpaceTile:1,CoordinateSpaceYUp:2,HasMapboxMeshFeatures:4,HasMeshoptCompression:8};function By(t,e,r,n,i,s,a,o,l,u=!1){const c=r.zoom,h=r.project(n),p=wl(n.lat,c),f=1/p;O.mat4.identity(t),O.mat4.translate(t,t,[h.x+a[0]*f,h.y+a[1]*f,a[2]]);let d=1,m=1;const y=r.worldSize;if(u){if("mercator"===r.projection.name){let t=0;r.elevation&&(t=r.elevation.getAtPointOrZero(new Il(h.x/y,h.y/y),0));const e=O.vec4.transformMat4([],[h.x,h.y,t,1],r.projMatrix)[3]/r.cameraToCenterDistance;d=e,m=e*wl(r.center.lat,c);}else if("globe"===r.projection.name){const e=fy(t,r),i=O.mat4.multiply([],r.projMatrix,e),s=[0,0,0,1];O.vec4.transformMat4(s,s,i);const a=s[3]/r.cameraToCenterDistance,o=$u(c),l=r.projection.pixelsPerMeter(n.lat,y)*wl(n.lat,c),u=r.projection.pixelsPerMeter(r.center.lat,y)*wl(r.center.lat,c);d=a/Ee(l,_l(r.center.lat),o),m=a*p/l,d*=u,m*=u;}}else d=f;O.mat4.scale(t,t,[d,d,m]);const g=[...t],x=e.orientation,v=[];if(hy(v,[x[0]+i[0],x[1]+i[1],x[2]+i[2]],s),O.mat4.multiply(t,g,v),o&&r.elevation){let i=0;const s=[];if(l&&r.elevation){i=function(t,e,r,n,i){const s=e.elevation;if(!s)return 0;const a=Au.projectAabbCorners(r,n),o=yl(1,i.lat)*e.worldSize,l=function(t,e){const r=[0,0,1],n=[{corners:[0,1,3,2],dotProductWithUp:0},{corners:[1,5,2,6],dotProductWithUp:0},{corners:[0,4,1,5],dotProductWithUp:0},{corners:[2,6,3,7],dotProductWithUp:0},{corners:[4,7,5,6],dotProductWithUp:0},{corners:[0,3,4,7],dotProductWithUp:0}];for(const i of n){const n=t[i.corners[0]],s=t[i.corners[1]],a=t[i.corners[2]],o=[s[0]-n[0],s[1]-n[1],e*(s[2]-n[2])],l=O.vec3.cross(o,o,[a[0]-n[0],a[1]-n[1],e*(a[2]-n[2])]);O.vec3.normalize(l,l),i.dotProductWithUp=O.vec3.dot(l,r);}return n.sort(((t,e)=>t.dotProductWithUp-e.dotProductWithUp)),n[0].corners}(a,o),u=a[l[0]],c=a[l[1]],h=a[l[2]],p=a[l[3]],f=s.getAtPointOrZero(new Il(u[0]/e.worldSize,u[1]/e.worldSize),0),d=s.getAtPointOrZero(new Il(c[0]/e.worldSize,c[1]/e.worldSize),0),m=s.getAtPointOrZero(new Il(h[0]/e.worldSize,h[1]/e.worldSize),0),y=s.getAtPointOrZero(new Il(p[0]/e.worldSize,p[1]/e.worldSize),0),g=(f+y)/2,x=(d+m)/2;return g>x?d<m?py(t,c,p,u,d,y,f,o):py(t,h,u,p,m,f,y,o):f<y?py(t,u,c,h,f,d,m,o):py(t,p,h,c,y,m,d,o),Math.max(g,x)}(s,r,e.aabb,t,n);const a=O.mat4.fromQuat([],s),o=O.mat4.multiply([],a,v);O.mat4.multiply(t,g,o);}else i=r.elevation.getAtPointOrZero(new Il(h.x/y,h.y/y),0);0!==i&&(t[14]+=i);}}function Vy(t,e,r=!1){t.uploaded||(t.gfxTexture=new qm(e,t.image,r?e.gl.R8:e.gl.RGBA8,{useMipmap:t.sampler.minFilter>=e.gl.NEAREST_MIPMAP_NEAREST}),t.uploaded=!0,t.image=null);}function Cy(t,e,r){t.indexBuffer=e.createIndexBuffer(t.indexArray,!1,!0),t.vertexBuffer=e.createVertexBuffer(t.vertexArray,my.members,!1,!0),t.normalArray&&(t.normalBuffer=e.createVertexBuffer(t.normalArray,vy.members,!1,!0)),t.texcoordArray&&(t.texcoordBuffer=e.createVertexBuffer(t.texcoordArray,xy.members,!1,!0)),t.colorArray&&(t.colorBuffer=e.createVertexBuffer(t.colorArray,(12===t.colorArray.bytesPerElement?yy:gy).members,!1,!0)),t.featureArray&&(t.pbrBuffer=e.createVertexBuffer(t.featureArray,_y.members,!0)),t.segments=xo.simpleSegment(0,0,t.vertexArray.length,t.indexArray.length);const n=t.material;n.pbrMetallicRoughness.baseColorTexture&&Vy(n.pbrMetallicRoughness.baseColorTexture,e),n.pbrMetallicRoughness.metallicRoughnessTexture&&Vy(n.pbrMetallicRoughness.metallicRoughnessTexture,e),n.normalTexture&&Vy(n.normalTexture,e),n.occlusionTexture&&Vy(n.occlusionTexture,e,r),n.emissionTexture&&Vy(n.emissionTexture,e);}function Dy(t,e,r){if(t.meshes)for(const n of t.meshes)Cy(n,e,r);if(t.children)for(const n of t.children)Dy(n,e,r);}function Ry(t){if(t.meshes)for(const e of t.meshes)e.indexArray.destroy(),e.vertexArray.destroy(),e.colorArray&&e.colorArray.destroy(),e.normalArray&&e.normalArray.destroy(),e.texcoordArray&&e.texcoordArray.destroy(),e.featureArray&&e.featureArray.destroy();if(t.children)for(const e of t.children)Ry(e);}function Ly(t){if(t.meshes)for(const r of t.meshes)r.vertexBuffer&&(r.vertexBuffer.destroy(),r.indexBuffer.destroy(),r.normalBuffer&&r.normalBuffer.destroy(),r.texcoordBuffer&&r.texcoordBuffer.destroy(),r.colorBuffer&&r.colorBuffer.destroy(),r.pbrBuffer&&r.pbrBuffer.destroy(),r.segments.destroy(),r.material&&((e=r.material).pbrMetallicRoughness.baseColorTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(),e.pbrMetallicRoughness.metallicRoughnessTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(),e.normalTexture&&e.normalTexture.gfxTexture&&e.normalTexture.gfxTexture.destroy(),e.emissionTexture&&e.emissionTexture.gfxTexture&&e.emissionTexture.gfxTexture.destroy(),e.occlusionTexture&&e.occlusionTexture.gfxTexture&&e.occlusionTexture.gfxTexture.destroy()));var e;if(t.children)for(const e of t.children)Ly(e);}class Fy{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,s=n.tileID,a=1<<e.canonical.z-s.canonical.z;return new Fy(n,i.dim/Kr/a,[(e.canonical.x/a-s.canonical.x)*i.dim,(e.canonical.y/a-s.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),i=Math.floor(r);return new q(n,i)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],a=Math.floor(i),o=Math.floor(s),l=this._dem;return n=!!n,r?Ee(Ee(l.get(a,o,n),l.get(a,o+1,n),s-o),Ee(l.get(a+1,o,n),l.get(a+1,o+1,n),s-o),i-a):l.get(a,o,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*yl(1,t)*this._dem.stride}}const Oy=new Float32Array(262144),Ny=new Uint8Array(262144);function Uy(t){let e=0;if(t.meshes)for(const r of t.meshes)e=Math.max(e,r.aabb.max[2]);if(t.children)for(const r of t.children)e=Math.max(e,Uy(r));return e}function jy(t,e,r){if(t.meshes)for(const n of t.meshes){if(n.aabb.min[0]===1/0)continue;const i=Au.applyTransform(n.aabb,t.matrix);r.insert(e,i.min[0],i.min[1],i.max[0],i.max[1]);}if(t.children)for(const n of t.children)jy(n,e,r);}const qy=["","wall","door","roof","window","lamp","logo"];class $y{constructor(t){this.node=t,this.evaluatedRMEA=[[1,0,0,1],[1,0,0,1],[1,0,0,1],[1,0,0,1],[.4,1,0,1],[1,0,0,1],[1,0,0,1]],this.hiddenByReplacement=!1,this.evaluatedScale=[1,1,1],this.evaluatedColor=[],this.emissionHeightBasedParams=[],this.cameraCollisionOpacity=1,this.feature={type:"Point",id:t.id,geometry:[],properties:{height:Uy(t)}},this.aabb=this._getLocalBounds(),this.state=null;}_getLocalBounds(){if(!this.node.meshes)return new Au([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);if(!this.aabb){let t=0;const e=new Au([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);for(const r of this.node.meshes)this.node.lightMeshIndex!==t&&(r.transformedAabb=Au.applyTransformFast(r.aabb,this.node.matrix),e.encapsulate(r.transformedAabb)),t++;this.aabb=e;}return this.aabb}}class Gy{constructor(t,e,r,n,i,s,a){this.id=r,this.layers=t,this.layerIds=this.layers.map((t=>t.fqid)),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.modelTraits|=Ty.CoordinateSpaceTile,this.uploaded=!1,this.hasPattern=!1,n&&(this.modelTraits|=Ty.HasMapboxMeshFeatures),i&&(this.modelTraits|=Ty.HasMeshoptCompression),this.zoom=-1,this.terrainExaggeration=1,this.projection={name:"mercator"},this.replacementUpdateTime=0,this.elevationReadFromZ=255,this.brightness=s,this.dirty=!0,this.needsUpload=!1,this.filter=null,this.nodesInfo=[];for(const t of e)this.nodesInfo.push(new $y(t)),jy(t,a.featureIndexArray.length,a.grid),a.featureIndexArray.emplaceBack(this.nodesInfo.length-1,0,a.bucketLayerIDs.length-1,0);this.states={};}updateFootprints(t,e){for(const r of this.getNodesInfo()){const n=r.node;n.footprint&&e.push({footprint:n.footprint,id:t});}}update(t){const e=0!==Object.keys(t).length;if(e&&!this.stateDependentLayers.length)return;const r=e?this.stateDependentLayers:this.layers;if(!$(t,this.states))for(const e of r)this.evaluate(e,t);this.states=structuredClone(t);}populate(){console.log("populate 3D model bucket");}uploadPending(){return !this.uploaded||this.needsUpload}upload(t){if(!this.needsUpload)return;const e=this.getNodesInfo();for(const r of e){const e=r.node;this.uploaded?this.updatePbrBuffer(e):Dy(e,t,!0);}for(const t of e)Ry(t.node);this.uploaded=!0,this.needsUpload=!1;}updatePbrBuffer(t){let e=!1;if(!t.meshes)return e;for(const r of t.meshes)r.pbrBuffer&&(r.pbrBuffer.updateData(r.featureArray),e=!0);return e}needsReEvaluation(t,e,r){const n=t.transform.projectionOptions,i=t.style.getBrightness(),s=this.brightness!==i;if(!this.uploaded||this.dirty||n.name!==this.projection.name||Yy(r.paint.get("model-color").value,s)||Yy(r.paint.get("model-color-mix-intensity").value,s)||Yy(r.paint.get("model-roughness").value,s)||Yy(r.paint.get("model-emissive-strength").value,s)||Yy(r.paint.get("model-height-based-emissive-strength-multiplier").value,s)){this.projection=n,this.brightness=i;const t=this.getNodesInfo();for(const e of t)e.state=null;return !0}return !1}evaluateScale(t,e){if(t.transform.zoom===this.zoom)return;this.zoom=t.transform.zoom;const r=this.getNodesInfo(),n=this.id.canonical;for(const t of r){const r=t.feature;t.evaluatedScale=e.paint.get("model-scale").evaluate(r,{},n);}}evaluate(t,e){const r=this.getNodesInfo();for(const n of r){if(!n.node.meshes)continue;const r=n.feature,i=e&&e[r.id];if($(i,n.state))continue;n.state=structuredClone(i);const s=n.node.meshes&&n.node.meshes[0].featureData,a=n.evaluatedColor[2],o=n.evaluatedRMEA[2],l=this.id.canonical;if(n.hasTranslucentParts=!1,s){for(let e=0;e<qy.length;e++){const s=qy[e];s.length&&(r.properties.part=s);const a=t.paint.get("model-color").evaluate(r,i,l).toRenderColor(null),o=t.paint.get("model-color-mix-intensity").evaluate(r,i,l);n.evaluatedColor[e]=[a.r,a.g,a.b,o],n.evaluatedRMEA[e][0]=t.paint.get("model-roughness").evaluate(r,i,l),n.evaluatedRMEA[e][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l),n.evaluatedRMEA[e][3]=a.a,n.emissionHeightBasedParams[e]=t.paint.get("model-height-based-emissive-strength-multiplier").evaluate(r,i,l),!n.hasTranslucentParts&&a.a<1&&(n.hasTranslucentParts=!0);}delete r.properties.part,Xy(n,a!==n.evaluatedColor[2]||o!==n.evaluatedRMEA[2],this.modelTraits);}else n.evaluatedRMEA[0][2]=t.paint.get("model-emissive-strength").evaluate(r,i,l);n.evaluatedScale=t.paint.get("model-scale").evaluate(r,i,l),this.updatePbrBuffer(n.node)||(this.needsUpload=!0);}this.dirty=!1;}elevationUpdate(t,e,r,n){const i=t.findDEMTileFor(r);if(i&&(i.tileID.canonical!==this.terrainTile||e!==this.terrainExaggeration)){if(i.dem&&i.tileID.overscaledZ!==this.elevationReadFromZ){this.elevationReadFromZ=i.tileID.overscaledZ;const e=Fy.create(t,r,i);if(!e)return;this.modelTraits&Ty.HasMapboxMeshFeatures&&this.updateDEM(t,e,r,n);for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.vertices||!r.footprint.vertices.length)continue;const n=r.footprint.vertices;let i=e.getElevationAt(n[0].x,n[0].y,!0,!0);for(let t=1;t<n.length;t++)i=Math.min(i,e.getElevationAt(n[t].x,n[t].y,!0,!0));r.elevation=i;}}this.terrainTile=i.tileID.canonical,this.terrainExaggeration=e;}}updateDEM(t,e,r,n){let i=e._dem._modifiedForSources[n];if(void 0===i&&(e._dem._modifiedForSources[n]=[],i=e._dem._modifiedForSources[n]),i.includes(r.canonical))return;const s=e._dem.dim;i.push(r.canonical);let a=!1;for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.grid)continue;const n=r.footprint.grid,i=e.tileCoordToPixel(n.min.x,n.min.y),o=e.tileCoordToPixel(n.max.x,n.max.y),l=Math.min(Math.min(s-o.y,i.x),Math.min(i.y,s-o.x));if(l<0)continue;const u=Q(l,2,5);let c=Math.max(0,i.x-u),h=Math.max(0,i.y-u),p=Math.min(o.x+u,s-1),f=Math.min(o.y+u,s-1);for(let t=h;t<=f;++t)for(let e=c;e<=p;++e)Ny[t*s+e]=255;let d=0,m=0;for(let t=0;t<n.cellsY;++t)for(let r=0;r<n.cellsX;++r){if(!n.cells[t*n.cellsX+r])continue;const i=e.tileCoordToPixel(n.min.x+r/n.xScale,n.min.y+t/n.yScale),a=e.tileCoordToPixel(n.min.x+(r+1)/n.xScale,n.min.y+(t+1)/n.yScale);for(let t=i.y;t<=Math.min(a.y+1,s-1);++t)for(let r=i.x;r<=Math.min(a.x+1,s-1);++r)255===Ny[t*s+r]&&(Ny[t*s+r]=0,d+=e.getElevationAtPixel(r,t),m++);}const y=d/m;c=Math.max(1,i.x-u),h=Math.max(1,i.y-u),p=Math.min(o.x+u,s-2),f=Math.min(o.y+u,s-2),a=!0;for(let t=h;t<=f;++t)for(let r=c;r<=p;++r)0===Ny[t*s+r]&&(Oy[t*s+r]=e._dem.set(r,t,y));for(let t=1;t<u;++t){c=Math.max(1,i.x-t),h=Math.max(1,i.y-t),p=Math.min(o.x+t,s-2),f=Math.min(o.y+t,s-2);for(let r=h;r<=f;++r)for(let n=c;n<=p;++n){const i=r*s+n;if(255===Ny[i]){let a=0,o=0,l=-1,c=-1;for(let e=-1;e<=1;++e)for(let i=-1;i<=1;++i){const u=(r+e)*s+n+i;if(Ny[u]>=t)continue;const h=Oy[u],p=Math.abs(h);p>o&&(a=h,o=p,l=i,c=e);}if(o>.1){const s=1-(t+.5*Math.abs(l*c))/u;let o=e._dem.get(n,r)+a*s;const h=e._dem.get(n+l,r+c),p=e._dem.get(n-l,r-c,!0);(o-h)*(o-p)>0&&(o=(h+p)/2),Oy[i]=e._dem.set(n,r,o),Ny[i]=t;}}}}}a&&(e._demTile.needsDEMTextureUpload=!0,e._dem._timestamp=Ct.now());}setFilter(t){this.filter=t?Qs(t):null;}getNodesInfo(){return this.filter?this.nodesInfo.filter((t=>this.filter.filter(new Rs(this.id.overscaledZ),t.feature,this.id.canonical))):this.nodesInfo}destroy(){const t=this.getNodesInfo();for(const e of t)Ry(e.node),Ly(e.node);}isEmpty(){return !this.nodesInfo.length}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped()),n=this.getNodesInfo();for(let t=0;t<this.nodesInfo.length;t++){const e=n[t].node;n[t].hiddenByReplacement=!!e.footprint&&!r.find((t=>t.footprint===e.footprint));}}getHeightAtTileCoord(t,e){const r=this.getNodesInfo(),n=[],i=[0,0,0],s=O.mat4.identity([]);for(let a=0;a<this.nodesInfo.length;a++){const o=r[a],l=o.node.meshes[0],u=l.transformedAabb;if(t<u.min[0]||e<u.min[1]||t>u.max[0]||e>u.max[1])continue;if(!0===o.node.hidden)return {height:1/0,maxHeight:o.feature.properties.height,hidden:!1,verticalScale:o.evaluatedScale[2]};O.mat4.invert(s,o.node.matrix),i[0]=t,i[1]=e,O.vec3.transformMat4(i,i,s);const c=(i[0]-l.aabb.min[0])/(l.aabb.max[0]-l.aabb.min[0])*ky|0,h=Math.min(63,(i[1]-l.aabb.min[1])/(l.aabb.max[1]-l.aabb.min[1])*ky|0)*ky+Math.min(63,c),p=l.heightmap[h];if(!(p<0&&o.node.footprint)){if(o.hiddenByReplacement)return;return {height:p,maxHeight:o.feature.properties.height,hidden:!1,verticalScale:o.evaluatedScale[2]}}if(o.node.footprint.grid.query(new q(t,e),new q(t,e),n),n.length>0)return {height:void 0,maxHeight:o.feature.properties.height,hidden:o.hiddenByReplacement,verticalScale:o.evaluatedScale[2]}}}}function Yy(t,e){return !t.isLightConstant&&e}function Hy(t,e,r,n,i,s,a,o){let l=(61440&e|(61440&e)>>4)>>8,u=(3840&e|(3840&e)>>4)>>4,c=240&e|(240&e)>>4;r[3]>0&&(l=Ee(l,255*r[0],r[3]),u=Ee(u,255*r[1],r[3]),c=Ee(c,255*r[2],r[3]));const h=l<<8|u,p=c<<8|Math.floor(255*n[3]),f=function(t){const e=Q(t,0,2);return Math.min(Math.round(.5*e*255),255)}(n[2])<<8|15*n[0]<<4|15*n[1],d=Q(i[0],0,1),m=Q(i[1],0,1),y=Q(i[2],0,1),g=Q(i[3],0,1);let x,v,b,_;if(d!==m&&a!==s&&m!==d){const t=a-s;v=1/(t*(m-d)),b=-(s+t*d)/(t*(m-d));const e=Q(i[4],-1,1);_=Math.pow(10,e),x=255*y<<8|255*g;}else x=65535,v=0,b=1,_=1;if(t.emplaceBack(h,p,f,x,v,b,_),o){const t=o.length;o.clear();for(let e=0;e<t;e++)o.emplaceBack(h,p,f,x,v,b,_);}}function Xy(t,e,r){const n=t.node;let i=0;const s=r&Ty.HasMeshoptCompression;for(const r of n.meshes){if(n.lights&&n.lightMeshIndex===i)continue;if(!r.featureData)continue;r.featureArray=new Qa,r.featureArray.reserve(r.featureData.length);let a=e;for(const e of r.featureData){const i=s?65535&e:e>>16&65535,o=s?e>>16&65535:65535&e,l=(15&o)<8?15&o:0,u=t.evaluatedRMEA[l],c=t.evaluatedColor[l],h=t.emissionHeightBasedParams[l];let p;if(a&&2===l&&n.lights&&(p=new Qa,p.resize(10*n.lights.length)),Hy(r.featureArray,i,c,u,h,r.aabb.min[2],r.aabb.max[2],p),p&&a){a=!1;const t=n.meshes[n.lightMeshIndex];t.featureArray=p,t.featureArray._trim();}}r.featureArray._trim(),i++;}}function Zy(t,e,r,n){const i=1<<t.z;e.lat=xl((n/Kr+t.y)/i),e.lng=gl((r/Kr+t.x)/i);}us(Gy,"Tiled3dModelBucket",{omit:["layers"]}),us($y,"Tiled3dModelFeature");const Wy={circle:class extends ma{constructor(t,e,r,n){super(t,{layout:ru||(ru=new Xs({"circle-sort-key":new Ys(Zs.layout_circle["circle-sort-key"]),"circle-elevation-reference":new Gs(Zs.layout_circle["circle-elevation-reference"]),visibility:new Gs(Zs.layout_circle.visibility)})),paint:nu||(nu=new Xs({"circle-radius":new Ys(Zs.paint_circle["circle-radius"]),"circle-color":new Ys(Zs.paint_circle["circle-color"]),"circle-blur":new Ys(Zs.paint_circle["circle-blur"]),"circle-opacity":new Ys(Zs.paint_circle["circle-opacity"]),"circle-translate":new Gs(Zs.paint_circle["circle-translate"]),"circle-translate-anchor":new Gs(Zs.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Gs(Zs.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Gs(Zs.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Ys(Zs.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Ys(Zs.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Ys(Zs.paint_circle["circle-stroke-opacity"]),"circle-emissive-strength":new Gs(Zs.paint_circle["circle-emissive-strength"]),"circle-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"circle-stroke-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}createBucket(t){return new Ll(t)}queryRadius(t){const e=t;return Jl("circle-radius",this,e)+Jl("circle-stroke-width",this,e)+Ql(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=eu(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return Ju(t,n,s,a,o,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getDefaultProgramParams(t,e,r){const n=Ku(this);return {config:new $o(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}},heatmap:class extends ma{createBucket(t){return new nc(t)}constructor(t,e,r,n){super(t,{layout:ic||(ic=new Xs({visibility:new Gs(Zs.layout_heatmap.visibility)})),paint:sc||(sc=new Xs({"heatmap-radius":new Ys(Zs.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Ys(Zs.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Gs(Zs.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Hs(Zs.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Gs(Zs.paint_heatmap["heatmap-opacity"]),"heatmap-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=dc({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(t){return Jl("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=this.paint.get("heatmap-radius").evaluate(e,r);return Ju(t,n,s,a,o,!0,!0,new q(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getDefaultProgramParams(t,e,r){return "heatmap"===t?{config:new $o(this,{zoom:e,lut:r}),overrideFog:!1}:{}}},hillshade:class extends ma{constructor(t,e,r,n){super(t,{layout:ac||(ac=new Xs({visibility:new Gs(Zs.layout_hillshade.visibility)})),paint:oc||(oc=new Xs({"hillshade-illumination-direction":new Gs(Zs.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new Gs(Zs.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Gs(Zs.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Gs(Zs.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Gs(Zs.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Gs(Zs.paint_hillshade["hillshade-accent-color"]),"hillshade-emissive-strength":new Gs(Zs.paint_hillshade["hillshade-emissive-strength"]),"hillshade-shadow-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"hillshade-highlight-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"hillshade-accent-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}shouldRedrape(){return this.hasOffscreenPass()&&"viewport"===this.paint.get("hillshade-illumination-anchor")}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}},fill:class extends ma{constructor(t,e,r,n){super(t,{layout:wh||(wh=new Xs({"fill-sort-key":new Ys(Zs.layout_fill["fill-sort-key"]),visibility:new Gs(Zs.layout_fill.visibility),"fill-elevation-reference":new Gs(Zs.layout_fill["fill-elevation-reference"]),"fill-construct-bridge-guard-rail":new Ys(Zs.layout_fill["fill-construct-bridge-guard-rail"])})),paint:Mh||(Mh=new Xs({"fill-antialias":new Gs(Zs.paint_fill["fill-antialias"]),"fill-opacity":new Ys(Zs.paint_fill["fill-opacity"]),"fill-color":new Ys(Zs.paint_fill["fill-color"]),"fill-outline-color":new Ys(Zs.paint_fill["fill-outline-color"]),"fill-translate":new Gs(Zs.paint_fill["fill-translate"]),"fill-translate-anchor":new Gs(Zs.paint_fill["fill-translate-anchor"]),"fill-pattern":new Ys(Zs.paint_fill["fill-pattern"]),"fill-emissive-strength":new Gs(Zs.paint_fill["fill-emissive-strength"]),"fill-z-offset":new Ys(Zs.paint_fill["fill-z-offset"]),"fill-bridge-guard-rail-color":new Ys(Zs.paint_fill["fill-bridge-guard-rail-color"]),"fill-tunnel-structure-color":new Ys(Zs.paint_fill["fill-tunnel-structure-color"]),"fill-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"fill-outline-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"fill-bridge-guard-rail-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"fill-tunnel-structure-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getDefaultProgramParams(t,e,r){return {config:new $o(this,{zoom:e,lut:r}),overrideFog:!1}}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new _h(t)}queryRadius(){return Ql(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s){return !t.queryGeometry.isAboveHorizon&&Nl(tu(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return 0===this.paint.get("fill-z-offset").constantOr(1)}is3D(t){if(0!==this.paint.get("fill-z-offset").constantOr(1))return !0;const e=this.layout&&"none"!==this.layout.get("fill-elevation-reference");return null!=t?e&&!t:e}},"fill-extrusion":class extends ma{constructor(t,e,r,n){super(t,{layout:kp||(kp=new Xs({visibility:new Gs(Zs["layout_fill-extrusion"].visibility),"fill-extrusion-edge-radius":new Gs(Zs["layout_fill-extrusion"]["fill-extrusion-edge-radius"])})),paint:Tp||(Tp=new Xs({"fill-extrusion-opacity":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-height-alignment":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-height-alignment"]),"fill-extrusion-base-alignment":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-base-alignment"]),"fill-extrusion-vertical-gradient":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-ambient-occlusion-wall-radius":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]),"fill-extrusion-ambient-occlusion-ground-radius":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]),"fill-extrusion-ambient-occlusion-ground-attenuation":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]),"fill-extrusion-flood-light-color":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]),"fill-extrusion-flood-light-intensity":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]),"fill-extrusion-flood-light-wall-radius":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]),"fill-extrusion-flood-light-ground-radius":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]),"fill-extrusion-flood-light-ground-attenuation":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]),"fill-extrusion-vertical-scale":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]),"fill-extrusion-rounded-roof":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]),"fill-extrusion-cutoff-fade-range":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"]),"fill-extrusion-emissive-strength":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-emissive-strength"]),"fill-extrusion-line-width":new Ys(Zs["paint_fill-extrusion"]["fill-extrusion-line-width"]),"fill-extrusion-cast-shadows":new Gs(Zs["paint_fill-extrusion"]["fill-extrusion-cast-shadows"]),"fill-extrusion-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"fill-extrusion-flood-light-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new vp(t)}queryRadius(){return Ql(this.paint.get("fill-extrusion-translate"))}is3D(t){return !0}hasShadowPass(){return this.paint.get("fill-extrusion-cast-shadows")}cutoffRange(){return this.paint.get("fill-extrusion-cutoff-fade-range")}canCastShadows(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}queryIntersectsFeature(t,e,r,n,i,s,a,o,l){const u=eu(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=[0,0],f=o&&s.elevation,d=s.elevation?s.elevation.exaggeration():1,m=t.tile.getBucket(this);if(f&&m instanceof vp){const t=m.centroidVertexArray,e=l+1;e<t.length&&(p[0]=t.geta_centroid_pos0(e),p[1]=t.geta_centroid_pos1(e));}if(0===p[0]&&1===p[1])return !1;"globe"===s.projection.name&&(n=Ep([n],[new q(0,0),new q(Kr,Kr)],t.tileID.canonical).map((t=>t.polygon)).flat());const y=f?o:null,[g,x]=function(t,e,r,n,i,s,a,o,l,u,c){return "globe"===t.projection.name?function(t,e,r,n,i,s,a,o,l,u,c){const h=[],p=[],f=t.projection.upVectorScale(c,t.center.lat,t.worldSize).metersToTile,d=[0,0,0,1],m=[0,0,0,1],y=(t,e,r,n)=>{t[0]=e,t[1]=r,t[2]=n,t[3]=1;},g=Pp();r>0&&(r+=g),n+=g;for(const g of e){const e=[],x=[];for(const h of g){const p=h.x+i.x,g=h.y+i.y,v=t.projection.projectTilePoint(p,g,c),b=t.projection.upVector(c,h.x,h.y);let _=r,w=n;if(a){const t=Cp(p,g,r,n,a,o,l,u);_+=t.base,w+=t.top;}0!==r?y(d,v.x+b[0]*f*_,v.y+b[1]*f*_,v.z+b[2]*f*_):y(d,v.x,v.y,v.z),y(m,v.x+b[0]*f*w,v.y+b[1]*f*w,v.z+b[2]*f*w),O.vec3.transformMat4(d,d,s),O.vec3.transformMat4(m,m,s),e.push(new Rh(d[0],d[1],d[2])),x.push(new Rh(m[0],m[1],m[2]));}h.push(e),p.push(x);}return [h,p]}(t,e,r,n,i,s,a,o,l,u,c):a?function(t,e,r,n,i,s,a,o,l){const u=[],c=[],h=[0,0,0,1];for(const p of t){const t=[],f=[];for(const u of p){const c=u.x+n.x,p=u.y+n.y,d=Cp(c,p,e,r,s,a,o,l);h[0]=c,h[1]=p,h[2]=d.base,h[3]=1,O.vec4.transformMat4(h,h,i),h[3]=Math.max(h[3],1e-5);const m=new Rh(h[0]/h[3],h[1]/h[3],h[2]/h[3]);h[0]=c,h[1]=p,h[2]=d.top,h[3]=1,O.vec4.transformMat4(h,h,i),h[3]=Math.max(h[3],1e-5);const y=new Rh(h[0]/h[3],h[1]/h[3],h[2]/h[3]);t.push(m),f.push(y);}u.push(t),c.push(f);}return [u,c]}(e,r,n,i,s,a,o,l,u):function(t,e,r,n,i){const s=[],a=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*r,p=i[9]*r,f=i[10]*r,d=i[11]*r;for(const e of t){const t=[],r=[];for(const s of e){const e=s.x+n.x,a=s.y+n.y,m=i[0]*e+i[4]*a+i[12],y=i[1]*e+i[5]*a+i[13],g=i[2]*e+i[6]*a+i[14],x=i[3]*e+i[7]*a+i[15],v=m+o,b=y+l,_=g+u,w=Math.max(x+c,1e-5),M=m+h,A=y+p,I=g+f,S=Math.max(x+d,1e-5);t.push(new Rh(v/w,b/w,_/w)),r.push(new Rh(M/S,A/S,I/S));}s.push(t),a.push(r);}return [s,a]}(e,r,n,i,s)}(s,n,h,c,u,a,y,p,d,s.center.lat,t.tileID.canonical),v=t.queryGeometry;return function(t,e,r){let n=1/0;Nl(r,e)&&(n=Vp(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];Fl(r,i)&&(n=Math.min(n,Vp(r,i)));}}return n!==1/0&&n}(g,x,v.isPointQuery()?v.screenBounds:v.screenGeometry)}},line:class extends ma{constructor(t,e,r,n){const i=nf();super(t,i,e,r,n),i.layout&&(this.layout=new $s(i.layout)),this.gradientVersion=0,this.hasElevatedBuckets=!1,this.hasNonElevatedBuckets=!1;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof Un,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=(()=>{if(af)return af;const t=nf();return af=new sf(t.paint.properties["line-width"].specification),af.useIntegerZoom=!0,af})().possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Yp(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getDefaultProgramParams(t,e,r){const n=tf(this);return {config:new $o(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}queryRadius(t){const e=t,r=of(Jl("line-width",this,e),Jl("line-gap-width",this,e)),n=Jl("line-offset",this,e);return r/2+Math.abs(n)+Ql(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,s){if(t.queryGeometry.isAboveHorizon)return !1;const a=tu(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),o=t.pixelToTileUnitsFactor/2*of(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),l=this.paint.get("line-offset").evaluate(e,r);return l&&(n=function(t,e){const r=[],n=new q(0,0);for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const r=s[t],i=s[t+1],o=0===t?n:r.sub(s[t-1])._unit()._perp(),l=t===s.length-1?n:i.sub(r)._unit()._perp(),u=o._add(l)._unit();u._mult(1/(u.x*l.x+u.y*l.y)),a.push(u._mult(e)._add(r));}r.push(a);}return r}(n,l*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(Hl(t,i[e]))return !0;if(Ul(t,i,r))return !0}return !1}(a,n,o)}isTileClipped(){return this.hasNonElevatedBuckets}isDraped(t){return !this.hasElevatedBuckets}},symbol:Dm,background:class extends ma{constructor(t,e,r,n){super(t,{layout:Rm||(Rm=new Xs({visibility:new Gs(Zs.layout_background.visibility)})),paint:Lm||(Lm=new Xs({"background-pitch-alignment":new Gs(Zs.paint_background["background-pitch-alignment"]),"background-color":new Gs(Zs.paint_background["background-color"]),"background-pattern":new Gs(Zs.paint_background["background-pattern"]),"background-opacity":new Gs(Zs.paint_background["background-opacity"]),"background-emissive-strength":new Gs(Zs.paint_background["background-emissive-strength"]),"background-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}is3D(t){return "viewport"===this.paint.get("background-pitch-alignment")}},raster:Wm,"raster-particle":ry,sky:class extends ma{constructor(t,e,r,n){super(t,{layout:Qm||(Qm=new Xs({visibility:new Gs(Zs.layout_sky.visibility)})),paint:ty||(ty=new Xs({"sky-type":new Gs(Zs.paint_sky["sky-type"]),"sky-atmosphere-sun":new Gs(Zs.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new Gs(Zs.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new Gs(Zs.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new Gs(Zs.paint_sky["sky-gradient-radius"]),"sky-gradient":new Hs(Zs.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new Gs(Zs.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new Gs(Zs.paint_sky["sky-atmosphere-color"]),"sky-opacity":new Gs(Zs.paint_sky["sky-opacity"]),"sky-gradient-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-halo-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"}),"sky-atmosphere-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=dc({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}return !1}getCenter(t,e){if("atmosphere"===this.paint.get("sky-type")){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,s=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&pt("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?iy(s.azimuthal,90-s.polar,e):iy(r[0],90-r[1],e)}const r=this.paint.get("sky-gradient-center");return iy(r[0],90-r[1],e)}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}},slot:class extends ma{constructor(t,e,r,n){super(t,{paint:ey||(ey=new Xs({}))},e,null);}},model:class extends ma{constructor(t,e,r,n){super(t,{layout:Ey||(Ey=new Xs({visibility:new Gs(Zs.layout_model.visibility),"model-id":new Ys(Zs.layout_model["model-id"])})),paint:zy||(zy=new Xs({"model-opacity":new Ys(Zs.paint_model["model-opacity"]),"model-rotation":new Ys(Zs.paint_model["model-rotation"]),"model-scale":new Ys(Zs.paint_model["model-scale"]),"model-translation":new Ys(Zs.paint_model["model-translation"]),"model-color":new Ys(Zs.paint_model["model-color"]),"model-color-mix-intensity":new Ys(Zs.paint_model["model-color-mix-intensity"]),"model-type":new Gs(Zs.paint_model["model-type"]),"model-cast-shadows":new Gs(Zs.paint_model["model-cast-shadows"]),"model-receive-shadows":new Gs(Zs.paint_model["model-receive-shadows"]),"model-ambient-occlusion-intensity":new Gs(Zs.paint_model["model-ambient-occlusion-intensity"]),"model-emissive-strength":new Ys(Zs.paint_model["model-emissive-strength"]),"model-roughness":new Ys(Zs.paint_model["model-roughness"]),"model-height-based-emissive-strength-multiplier":new Ys(Zs.paint_model["model-height-based-emissive-strength-multiplier"]),"model-cutoff-fade-range":new Gs(Zs.paint_model["model-cutoff-fade-range"]),"model-front-cutoff":new Gs(Zs.paint_model["model-front-cutoff"]),"model-color-use-theme":new Ys({type:"string",default:"default","property-type":"data-driven"})}))},e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new Py(t)}getProgramIds(){return ["model"]}is3D(t){return !0}hasShadowPass(){return !0}canCastShadows(){return !0}hasLightBeamPass(){return !0}cutoffRange(){return this.paint.get("model-cutoff-fade-range")}queryRadius(t){return t instanceof Gy?Kr-1:0}queryIntersectsFeature(t,e,r,n,i,s){if(!this.modelManager)return !1;const a=this.modelManager,o=t.tile.getBucket(this);if(!(o&&o instanceof Py))return !1;for(const r in o.instancesPerModel){const n=o.instancesPerModel[r],i=void 0!==e.id?e.id:e.properties&&e.properties.hasOwnProperty("id")?e.properties.id:void 0;if(n.idToFeaturesIndex.hasOwnProperty(i)){const e=n.features[n.idToFeaturesIndex[i]],l=a.getModel(r,this.scope);if(!l)return !1;let u=O.mat4.create();const c=new ul(0,0),h=o.canonical;let p=Number.MAX_VALUE;for(let r=0;r<e.instancedDataCount;++r){const i=16*(e.instancedDataOffset+r),a=n.instancedDataArray.float32,o=[a[i+4],a[i+5],a[i+6]];Zy(h,c,a[i],0|a[i+1]),By(u,l,s,c,e.rotation,e.scale,o,!1,!1,!1),"globe"===s.projection.name&&(u=fy(u,s));const f=O.mat4.multiply([],s.projMatrix,u),d=t.queryGeometry,m=dy(d.isPointQuery()?d.screenBounds:d.screenGeometry,s,f,l.aabb);null!=m&&(p=Math.min(m,p));}return p!==Number.MAX_VALUE&&p}}return !1}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven()||"model-color"!==t&&"model-color-mix-intensity"!==t&&"model-rotation"!==t&&"model-scale"!==t&&"model-translation"!==t&&"model-emissive-strength"!==t)}_isPropertyZoomDependent(t){const e=this._transitionablePaint._values[t];return null!=e&&null!=e.value&&null!=e.value.expression&&e.value.expression instanceof ts}isZoomDependent(){return this._isPropertyZoomDependent("model-scale")||this._isPropertyZoomDependent("model-rotation")||this._isPropertyZoomDependent("model-translation")}},clip:class extends ma{constructor(t,e,r,n){super(t,{layout:Ah||(Ah=new Xs({"clip-layer-types":new Gs(Zs.layout_clip["clip-layer-types"]),"clip-layer-scope":new Gs(Zs.layout_clip["clip-layer-scope"])})),paint:Ih||(Ih=new Xs({}))},e,r,n);}recalculate(t,e){super.recalculate(t,e);}createBucket(t){return new Eh(t)}is3D(t){return !0}}};class Ky{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){this._channel=void 0,this._callback=()=>{};}}class Jy{constructor(){this.tasks={},this.taskQueue=[],ot(["process"],this),this.invoker=new Ky(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){try{t();}finally{}return null}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class Qy{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},ot(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.scheduler=new Jy;}send(t,e,r,n,i=!1,s){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[a]=r);const o=new Set;return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:ps(e,o)},o),{cancel:()=>{r&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data;if(!e)return;const r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||yt()){const t=this.callbacks[r],n=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});n&&(this.cancelCallbacks[r]=n);}else this.processTask(r,e);}processTask(t,e){if(delete this.cancelCallbacks[t],"<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(fs(e.error)):r(null,fs(e.data)));}else {const r=new Set,n=e.hasCallback?(e,n)=>{this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?ps(e):null,data:ps(n,r)},r);}:()=>{},i=fs(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],i.source,i.scope)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}}var tg={workerUrl:"",workerClass:null,workerParams:void 0};const eg="mapboxgl_preloaded_worker_pool";class rg{constructor(){this.active={};}acquire(t,e=rg.workerCount){if(!this.workers)for(this.workers=[];this.workers.length<e;)this.workers.push(null!=tg.workerClass?new tg.workerClass:new self.Worker(tg.workerUrl,tg.workerParams));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],this.workers&&0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[eg]}numActive(){return Object.keys(this.active).length}}rg.workerCount=2;class ng{constructor(t,e,r="Worker",n=rg.workerCount){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=st();const i=this.workerPool.acquire(this.id,n);for(let t=0;t<i.length;t++){const n=new ng.Actor(i[t],e,this.id);n.name=`${r} ${t}`,this.actors.push(n);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,e,r){rt(this.actors,((r,n)=>{r.send(t,e,n);}),r=r||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((t=>{t.remove();})),this.actors=[],this.workerPool.release(this.id);}}let ig,sg;function ag(){return ig||(ig=new rg),ig}ng.Actor=Qy;const og=new Se(0,0,0);var lg=(t=>(t[t.PATH_RULE_UNSPECIFIED=0]="PATH_RULE_UNSPECIFIED",t[t.PATH_RULE_NON_ZERO=1]="PATH_RULE_NON_ZERO",t[t.PATH_RULE_EVEN_ODD=2]="PATH_RULE_EVEN_ODD",t))(lg||{}),ug=(t=>(t[t.LINE_CAP_UNSPECIFIED=0]="LINE_CAP_UNSPECIFIED",t[t.LINE_CAP_BUTT=1]="LINE_CAP_BUTT",t[t.LINE_CAP_ROUND=2]="LINE_CAP_ROUND",t[t.LINE_CAP_SQUARE=3]="LINE_CAP_SQUARE",t))(ug||{}),cg=(t=>(t[t.LINE_JOIN_UNSPECIFIED=0]="LINE_JOIN_UNSPECIFIED",t[t.LINE_JOIN_MITER=1]="LINE_JOIN_MITER",t[t.LINE_JOIN_MITER_CLIP=2]="LINE_JOIN_MITER_CLIP",t[t.LINE_JOIN_ROUND=3]="LINE_JOIN_ROUND",t[t.LINE_JOIN_BEVEL=4]="LINE_JOIN_BEVEL",t))(cg||{}),hg=(t=>(t[t.PAINT_ORDER_UNSPECIFIED=0]="PAINT_ORDER_UNSPECIFIED",t[t.PAINT_ORDER_FILL_AND_STROKE=1]="PAINT_ORDER_FILL_AND_STROKE",t[t.PAINT_ORDER_STROKE_AND_FILL=2]="PAINT_ORDER_STROKE_AND_FILL",t))(hg||{}),pg=(t=>(t[t.PATH_COMMAND_UNSPECIFIED=0]="PATH_COMMAND_UNSPECIFIED",t[t.PATH_COMMAND_MOVE=1]="PATH_COMMAND_MOVE",t[t.PATH_COMMAND_LINE=2]="PATH_COMMAND_LINE",t[t.PATH_COMMAND_QUAD=3]="PATH_COMMAND_QUAD",t[t.PATH_COMMAND_CUBIC=4]="PATH_COMMAND_CUBIC",t[t.PATH_COMMAND_CLOSE=5]="PATH_COMMAND_CLOSE",t))(pg||{}),fg=(t=>(t[t.MASK_TYPE_UNSPECIFIED=0]="MASK_TYPE_UNSPECIFIED",t[t.MASK_TYPE_LUMINANCE=1]="MASK_TYPE_LUMINANCE",t[t.MASK_TYPE_ALPHA=2]="MASK_TYPE_ALPHA",t))(fg||{});function dg(t,e,r){1===t&&e.icons.push(function(t,e){return function(t){if(t.usvg_tree.height||(t.usvg_tree.height=t.usvg_tree.width),!t.metadata)return t;const{metadata:e}=t;if(e.content_area){const{content_area:r}=e;null==r.top&&(r.top=r.left),null==r.width&&(r.width=t.usvg_tree.width),null==r.height&&(r.height=r.width);}return e.stretch_x&&e.stretch_x.length&&mg(e,"x"),e.stretch_y&&e.stretch_y.length&&mg(e,"y"),t}(t.readFields(yg,{name:void 0},e))}(r,r.readVarint()+r.pos));}function mg(t,e){const r=[],n=t[`stretch_${e}`];let i=null;for(let t=0;t<n.length;t++)null===i?i=0===r.length?n[0]:r[r.length-1][1]+n[t]:(r.push([i,i+n[t]]),i=null);t[`stretch_${e}_areas`]=r;}function yg(t,e,r){1===t?e.name=r.readString():2===t?e.metadata=function(t,e){return t.readFields(gg,{stretch_x:null,stretch_y:null,stretch_x_areas:null,stretch_y_areas:null,variables:[]},e)}(r,r.readVarint()+r.pos):3===t&&(e.usvg_tree=function(t,e){return t.readFields(bg,{width:20,children:[],linear_gradients:[],radial_gradients:[],clip_paths:[],masks:[]},e)}(r,r.readVarint()+r.pos),e.data="usvg_tree");}function gg(t,e,r){1===t?e.stretch_x=r.readPackedVarint():2===t?e.stretch_y=r.readPackedVarint():3===t?e.content_area=function(t,e){return t.readFields(xg,{left:0},e)}(r,r.readVarint()+r.pos):4===t&&e.variables.push(function(t,e){return t.readFields(vg,{name:void 0},e)}(r,r.readVarint()+r.pos));}function xg(t,e,r){1===t?e.left=r.readVarint():2===t?e.width=r.readVarint():3===t?e.top=r.readVarint():4===t&&(e.height=r.readVarint());}function vg(t,e,r){1===t?e.name=r.readString():2===t&&(e.rgb_color=Eg(r.readVarint()),e.value="rgb_color");}function bg(t,e,r){1===t?e.width=e.height=r.readVarint():2===t?e.height=r.readVarint():3===t?e.children.push(_g(r,r.readVarint()+r.pos)):4===t?e.linear_gradients.push(function(t,e){return t.readFields(kg,{spread_method:1,stops:[],x1:0,y1:0,x2:1,y2:0},e)}(r,r.readVarint()+r.pos)):5===t?e.radial_gradients.push(function(t,e){return t.readFields(Vg,{spread_method:1,stops:[],cx:.5,cy:.5,r:.5,fx:.5,fy:.5,fr:0},e)}(r,r.readVarint()+r.pos)):7===t?e.clip_paths.push(function(t,e){return t.readFields(Cg,{children:[]},e)}(r,r.readVarint()+r.pos)):8===t&&e.masks.push(function(t,e){const r=t.readFields(Dg,{left:0,width:20,mask_type:1,children:[]},e);return null==r.height&&(r.height=r.width),null==r.top&&(r.top=r.left),r}(r,r.readVarint()+r.pos));}function _g(t,e){return t.readFields(wg,{},e)}function wg(t,e,r){1===t?(e.group=function(t,e){return t.readFields(Mg,{opacity:255,children:[]},e)}(r,r.readVarint()+r.pos),e.node="group"):2===t&&(e.path=function(t,e){return t.readFields(Sg,{paint_order:1,commands:[],step:1,diffs:[],rule:1},e)}(r,r.readVarint()+r.pos),e.node="path");}function Mg(t,e,r){1===t?e.transform=Ag(r,r.readVarint()+r.pos):2===t?e.opacity=r.readVarint():5===t?e.clip_path_idx=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(_g(r,r.readVarint()+r.pos));}function Ag(t,e){return t.readFields(Ig,{sx:1,ky:0,kx:0,sy:1,tx:0,ty:0},e)}function Ig(t,e,r){1===t?e.sx=r.readFloat():2===t?e.ky=r.readFloat():3===t?e.kx=r.readFloat():4===t?e.sy=r.readFloat():5===t?e.tx=r.readFloat():6===t&&(e.ty=r.readFloat());}function Sg(t,e,r){1===t?e.fill=function(t,e){return t.readFields(Pg,{rgb_color:og,paint:"rgb_color",opacity:255},e)}(r,r.readVarint()+r.pos):2===t?e.stroke=function(t,e){return t.readFields(zg,{rgb_color:og,paint:"rgb_color",dasharray:[],dashoffset:0,miterlimit:4,opacity:255,width:1,linecap:1,linejoin:1},e)}(r,r.readVarint()+r.pos):3===t?e.paint_order=r.readVarint():5===t?r.readPackedVarint(e.commands):6===t?e.step=r.readFloat():7===t?r.readPackedSVarint(e.diffs):8===t&&(e.rule=r.readVarint());}function Pg(t,e,r){1===t?(e.rgb_color=Eg(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t&&(e.opacity=r.readVarint());}function Eg(t){return new Se((t>>16&255)/255,(t>>8&255)/255,(255&t)/255,1)}function zg(t,e,r){1===t?(e.rgb_color=Eg(r.readVarint()),e.paint="rgb_color"):2===t?(e.linear_gradient_idx=r.readVarint(),e.paint="linear_gradient_idx"):3===t?(e.radial_gradient_idx=r.readVarint(),e.paint="radial_gradient_idx"):5===t?r.readPackedFloat(e.dasharray):6===t?e.dashoffset=r.readFloat():7===t?e.miterlimit=r.readFloat():8===t?e.opacity=r.readVarint():9===t?e.width=r.readFloat():10===t?e.linecap=r.readVarint():11===t&&(e.linejoin=r.readVarint());}function kg(t,e,r){1===t?e.transform=Ag(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(Tg(r,r.readVarint()+r.pos)):4===t?e.x1=r.readFloat():5===t?e.y1=r.readFloat():6===t?e.x2=r.readFloat():7===t&&(e.y2=r.readFloat());}function Tg(t,e){return t.readFields(Bg,{offset:0,opacity:255,rgb_color:og},e)}function Bg(t,e,r){1===t?e.offset=r.readFloat():2===t?e.opacity=r.readVarint():3===t&&(e.rgb_color=Eg(r.readVarint()));}function Vg(t,e,r){1===t?e.transform=Ag(r,r.readVarint()+r.pos):2===t?e.spread_method=r.readVarint():3===t?e.stops.push(Tg(r,r.readVarint()+r.pos)):4===t?e.cx=r.readFloat():5===t?e.cy=r.readFloat():6===t?e.r=r.readFloat():7===t?e.fx=r.readFloat():8===t?e.fy=r.readFloat():9===t&&(e.fr=r.readFloat());}function Cg(t,e,r){1===t?e.transform=Ag(r,r.readVarint()+r.pos):2===t?e.clip_path_idx=r.readVarint():3===t&&e.children.push(_g(r,r.readVarint()+r.pos));}function Dg(t,e,r){1===t?e.left=e.top=r.readFloat():2===t?e.width=e.height=r.readFloat():3===t?e.top=r.readFloat():4===t?e.height=r.readFloat():5===t?e.mask_type=r.readVarint():6===t?e.mask_idx=r.readVarint():7===t&&e.children.push(_g(r,r.readVarint()+r.pos));}class Rg{static calculate(t={},e=[]){const r=new Map,n=new Map;if(0===Object.keys(t).length)return r;e.forEach((t=>{n.set(t.name,t.rgb_color||new Se(0,0,0));}));for(const[e,i]of Object.entries(t))n.has(e)?r.set(n.get(e).toStringPremultipliedAlpha(),i):console.warn(`Ignoring unknown image variable "${e}"`);return r}}function Lg(t,e=255,r){const n=e/255,i=t.toStringPremultipliedAlpha(),s=r.has(i)?r.get(i).clone():t.clone();return s.a*=n,s.toString()}function Fg(t,e){if(!Vt()){const r=document.createElement("canvas");return r.width=t,r.height=e,r}return new OffscreenCanvas(t,e)}function Og(t,e){const r=Rg.calculate(e.params,t.metadata?t.metadata.variables:[]),n=t.usvg_tree,i=n.width,s=n.height,a=e.transform?e.transform:new DOMMatrix,o=Math.max(1,Math.round(i*a.a)),l=Math.max(1,Math.round(s*a.d)),u=new DOMMatrix([o/i,0,0,l/s,0,0]),c=Fg(o,l).getContext("2d");return Ng(c,u,n,n,r),c.getImageData(0,0,o,l)}function Ng(t,e,r,n,i){for(const s of n.children)Ug(t,e,r,s,i);}function Ug(t,e,r,n,i){n.group?(t.save(),function(t,e,r,n,i){const s=null!=n.mask_idx?r.masks[n.mask_idx]:null,a=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;if(n.transform&&(e=Wg(n.transform).preMultiplySelf(e)),!function(t,e,r){return 255!==t.opacity||e||r}(n,null!=a,null!=s))return void Ng(t,e,r,n,i);const o=Fg(t.canvas.width,t.canvas.height),l=o.getContext("2d");Ng(l,e,r,n,i),a&&Xg(l,e,r,a),s&&Zg(l,e,r,s,i),t.globalAlpha=n.opacity/255,t.drawImage(o,0,0);}(t,e,r,n.group,i),t.restore()):n.path&&(t.save(),function(t,e,r,n,i){const s=Kg(n);t.setTransform(e),n.paint_order===hg.PAINT_ORDER_FILL_AND_STROKE?(jg(t,r,n,s,i),$g(t,r,n,s,i)):($g(t,r,n,s,i),jg(t,r,n,s,i));}(t,e,r,n.path,i),t.restore());}function jg(t,e,r,n,i){const s=r.fill;if(!s)return;const a=s.opacity/255;switch(s.paint){case"rgb_color":t.fillStyle=Lg(s.rgb_color,s.opacity,i);break;case"linear_gradient_idx":t.fillStyle=Gg(t,e.linear_gradients[s.linear_gradient_idx],a,i);break;case"radial_gradient_idx":t.fillStyle=Yg(t,e.radial_gradients[s.radial_gradient_idx],a,i);}t.fill(n,qg(r));}function qg(t){return t.rule===lg.PATH_RULE_NON_ZERO?"nonzero":t.rule===lg.PATH_RULE_EVEN_ODD?"evenodd":void 0}function $g(t,e,r,n,i){const s=r.stroke;if(!s)return;t.lineWidth=s.width,t.miterLimit=s.miterlimit,t.setLineDash(s.dasharray),t.lineDashOffset=s.dashoffset;const a=s.opacity/255;switch(s.paint){case"rgb_color":t.strokeStyle=Lg(s.rgb_color,s.opacity,i);break;case"linear_gradient_idx":t.strokeStyle=Gg(t,e.linear_gradients[s.linear_gradient_idx],a,i);break;case"radial_gradient_idx":t.strokeStyle=Yg(t,e.radial_gradients[s.radial_gradient_idx],a,i);}switch(s.linejoin){case cg.LINE_JOIN_MITER_CLIP:case cg.LINE_JOIN_MITER:t.lineJoin="miter";break;case cg.LINE_JOIN_ROUND:t.lineJoin="round";break;case cg.LINE_JOIN_BEVEL:t.lineJoin="bevel";}switch(s.linecap){case ug.LINE_CAP_BUTT:t.lineCap="butt";break;case ug.LINE_CAP_ROUND:t.lineCap="round";break;case ug.LINE_CAP_SQUARE:t.lineCap="square";}t.stroke(n);}function Gg(t,e,r,n){if(1===e.stops.length){const t=e.stops[0];return Lg(t.rgb_color,t.opacity*r,n)}const i=Wg(e.transform),{x1:s,y1:a,x2:o,y2:l}=e,u=i.transformPoint(new DOMPoint(s,a)),c=i.transformPoint(new DOMPoint(o,l)),h=t.createLinearGradient(u.x,u.y,c.x,c.y);for(const t of e.stops)h.addColorStop(t.offset,Lg(t.rgb_color,t.opacity*r,n));return h}function Yg(t,e,r,n){if(1===e.stops.length){const t=e.stops[0];return Lg(t.rgb_color,t.opacity*r,n)}const i=Wg(e.transform),{fx:s,fy:a,cx:o,cy:l}=e,u=i.transformPoint(new DOMPoint(s,a)),c=i.transformPoint(new DOMPoint(o,l)),h=t.createRadialGradient(u.x,u.y,0,c.x,c.y,e.r*((i.a+i.d)/2));for(const t of e.stops)h.addColorStop(t.offset,Lg(t.rgb_color,t.opacity*r,n));return h}function Hg(t,e,r,n){const i=n.transform?Wg(n.transform).preMultiplySelf(e):e,s=Fg(t.canvas.width,t.canvas.height),a=s.getContext("2d");for(const t of n.children)if(t.group)Hg(a,i,r,t.group);else if(t.path){const e=t.path,r=new Path2D;r.addPath(Kg(e),i),a.fill(r,qg(e));}const o=null!=n.clip_path_idx?r.clip_paths[n.clip_path_idx]:null;o&&Xg(a,i,r,o),t.globalCompositeOperation="source-over",t.drawImage(s,0,0);}function Xg(t,e,r,n){const i=Fg(t.canvas.width,t.canvas.height);Hg(i.getContext("2d"),e,r,n),t.globalCompositeOperation="destination-in",t.drawImage(i,0,0);}function Zg(t,e,r,n,i){if(0===n.children.length)return;const s=null!=n.mask_idx?r.masks[n.mask_idx]:null;s&&Zg(t,e,r,s,i);const a=t.canvas.width,o=t.canvas.height,l=Fg(a,o),u=l.getContext("2d"),c=n.width,h=n.height,p=n.left,f=n.top,d=new Path2D,m=new Path2D;m.rect(p,f,c,h),d.addPath(m,e),u.clip(d);for(const t of n.children)Ug(u,e,r,t,i);const y=u.getImageData(0,0,a,o),g=y.data;if(n.mask_type===fg.MASK_TYPE_LUMINANCE)for(let t=0;t<g.length;t+=4)g[t+3]=g[t+3]/255*(.2126*g[t]+.7152*g[t+1]+.0722*g[t+2]);u.putImageData(y,0,0),t.globalCompositeOperation="destination-in",t.drawImage(l,0,0);}function Wg(t){return t?new DOMMatrix([t.sx,t.ky,t.kx,t.sy,t.tx,t.ty]):new DOMMatrix}function Kg(t){const e=new Path2D,r=t.step;let n=t.diffs[0]*r,i=t.diffs[1]*r;e.moveTo(n,i);for(let s=0,a=2;s<t.commands.length;s++)switch(t.commands[s]){case pg.PATH_COMMAND_MOVE:n+=t.diffs[a++]*r,i+=t.diffs[a++]*r,e.moveTo(n,i);break;case pg.PATH_COMMAND_LINE:n+=t.diffs[a++]*r,i+=t.diffs[a++]*r,e.lineTo(n,i);break;case pg.PATH_COMMAND_QUAD:{const s=n+t.diffs[a++]*r,o=i+t.diffs[a++]*r;n=s+t.diffs[a++]*r,i=o+t.diffs[a++]*r,e.quadraticCurveTo(s,o,n,i);break}case pg.PATH_COMMAND_CUBIC:{const s=n+t.diffs[a++]*r,o=i+t.diffs[a++]*r,l=s+t.diffs[a++]*r,u=o+t.diffs[a++]*r;n=l+t.diffs[a++]*r,i=u+t.diffs[a++]*r,e.bezierCurveTo(s,o,l,u,n,i);break}case pg.PATH_COMMAND_CLOSE:e.closePath();}return e}class Jg{constructor(t){this.capacity=t,this.cache=new Map;}get(t){if(!this.cache.has(t))return;const e=this.cache.get(t);return this.cache.delete(t),this.cache.set(t,e),e}put(t,e){this.cache.has(t)?this.cache.delete(t):this.cache.size===this.capacity&&this.cache.delete(this.cache.keys().next().value),this.cache.set(t,e);}delete(t){this.cache.delete(t);}}us(Jg,"LRUCache");class Qg{constructor(){this.cacheMap=new Map,this.cacheDependenciesMap=new Map;}static _getImage(t){return new pc(t,t.data)}getFromCache(t,e,r){return this.cacheMap.has(r)||this.cacheMap.set(r,new Jg(150)),this.cacheMap.get(r).get(pa(t.toString(),e))}setInCache(t,e,r,n){this.cacheDependenciesMap.has(n)||this.cacheDependenciesMap.set(n,new Map),this.cacheMap.has(n)||this.cacheMap.set(n,new Jg(150));const i=this.cacheDependenciesMap.get(n),s=pa(t.id.toString(),r);i.get(s)||i.set(s,new Set);const a=this.cacheMap.get(n),o=t.toString();i.get(s).add(o),a.put(pa(t.toString(),r),e);}removeImagesFromCacheByIds(t,e,r=0){if(!this.cacheMap.has(r)||!this.cacheDependenciesMap.has(r))return;const n=this.cacheMap.get(r),i=this.cacheDependenciesMap.get(r);for(const r of t){const t=pa(r.toString(),e);if(i.has(t)){for(const e of i.get(t))n.delete(e);i.delete(t);}}}rasterize(t,e,r,n,i=Og){const s=this.getFromCache(t,r,n);if(s)return s.clone();const a=i(e.icon,t.options),o=Qg._getImage(a);return this.setInCache(t,o,r,n),o.clone()}}class tx{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function ex(t,e,r,n){let i=0,s=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(n[a])<1e-15){if(r[a]<t[a]||r[a]>e[a])return null}else {const o=1/n[a];let l=(t[a]-r[a])*o,u=(e[a]-r[a])*o;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<s&&(s=u),i>s)return null}return i}function rx(t,e,r,n,i,s,a,o,l,u,c){const h=n-t,p=i-e,f=s-r,d=a-t,m=o-e,y=l-r,g=c[1]*y-c[2]*m,x=c[2]*d-c[0]*y,v=c[0]*m-c[1]*d,b=h*g+p*x+f*v;if(Math.abs(b)<1e-15)return null;const _=1/b,w=u[0]-t,M=u[1]-e,A=u[2]-r,I=(w*g+M*x+A*v)*_;if(I<0||I>1)return null;const S=M*f-A*p,P=A*h-w*f,E=w*p-M*h,z=(c[0]*S+c[1]*P+c[2]*E)*_;return z<0||I+z>1?null:(d*S+m*P+y*E)*_}function nx(t,e,r){return (t-e)/(r-e)}function ix(t,e,r,n,i,s,a,o,l){const u=1<<r,c=s-n,h=a-i,p=(t+1)/u*c+n,f=(e+0)/u*h+i,d=(e+1)/u*h+i;o[0]=(t+0)/u*c+n,o[1]=f,l[0]=p,l[1]=d;}class sx{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,s=(t,e,r,n,i)=>{const s=n?1:0,a=(t+1)*r-s,o=e*r,l=(e+1)*r-s;i[0]=t*r,i[1]=o,i[2]=a,i[3]=l;};let a=new tx(n);const o=[];for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),i,!1,o);const r=ox(o[0],o[1],t),l=ox(o[2],o[1],t),u=ox(o[2],o[3],t),c=ox(o[0],o[3],t);a.minimums.push(Math.min(r,l,u,c)),a.maximums.push(Math.max(r,l,u,c)),a.leaves.push(1);}for(r.push(a),n/=2;n>=1;n/=2){const t=r[r.length-1];a=new tx(n);for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),2,!0,o);const r=t.getElevation(o[0],o[1]),i=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),f=t.isLeaf(o[0],o[3]),d=Math.min(r.min,i.min,l.min,u.min),m=Math.max(r.max,i.max,l.max,u.max),y=c&&h&&p&&f;a.maximums.push(m),a.minimums.push(d),a.leaves.push(m-d<=5&&y?1:0);}r.push(a);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,s,a=1){return ex([t,e,-100],[r,n,this.maximums[0]*a],i,s)}raycast(t,e,r,n,i,s,a=1){if(!this.nodeCount)return null;const o=this.raycastRoot(t,e,r,n,i,s,a);if(null==o)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:o,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:o,t:f,nodex:d,nodey:m,depth:y}=p.pop();if(this.leaves[o]){ix(d,m,y,t,e,r,n,c,h);const o=1<<y,l=(d+0)/o,u=(d+1)/o,p=(m+0)/o,g=(m+1)/o,x=ox(l,p,this.dem)*a,v=ox(u,p,this.dem)*a,b=ox(u,g,this.dem)*a,_=ox(l,g,this.dem)*a,w=rx(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,i,s),M=rx(h[0],h[1],b,c[0],h[1],_,c[0],c[1],x,i,s),A=Math.min(null!==w?w:Number.MAX_VALUE,null!==M?M:Number.MAX_VALUE);if(A!==Number.MAX_VALUE)return A;{const t=O.vec3.scaleAndAdd([],i,s,f);if(ax(x,v,_,b,nx(t[0],c[0],h[0]),nx(t[1],c[1],h[1]))>=t[2])return f}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){ix((d<<1)+this._siblingOffset[p][0],(m<<1)+this._siblingOffset[p][1],y+1,t,e,r,n,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[o]+p]*a;const f=ex(c,h,i,s);if(null!=f){const t=f;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[o]+e,t:l[e],nodex:(d<<1)+this._siblingOffset[e][0],nodey:(m<<1)+this._siblingOffset[e][1],depth:y+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const s=n-1,a=t[s];let o=0,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],s=a.getElevation(n,i),u=a.isLeaf(n,i),c=this._addNode(s.min,s.max,u);u&&(o|=1<<t),l||(l=c);}for(let n=0;n<this._siblingOffset.length;n++)o&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],s,l+n);}}function ax(t,e,r,n,i,s){return Ee(Ee(t,r,s),Ee(e,n,s),i)}function ox(t,e,r){const n=r.dim,i=Q(t*n-.5,0,n-1),s=Q(e*n-.5,0,n-1),a=Math.floor(i),o=Math.floor(s),l=Math.min(a+1,n-1),u=Math.min(o+1,n-1);return ax(r.get(a,o),r.get(l,o),r.get(a,u),r.get(l,u),i-a,s-o)}const lx={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function ux(t,e,r){return (256*t*256+256*e+r)/10-1e4}function cx(t,e,r){return 256*t+e+r/256-32768}class hx{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return void pt(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const i=this.dim=e.height-2,s=new Uint32Array(e.data.buffer);if(this.pixels=new Uint8Array(e.data.buffer),this.floatView=new Float32Array(e.data.buffer),this.borderReady=n,this._modifiedForSources={},!n){for(let t=0;t<i;t++)s[this._idx(-1,t)]=s[this._idx(0,t)],s[this._idx(i,t)]=s[this._idx(i-1,t)],s[this._idx(t,-1)]=s[this._idx(t,0)],s[this._idx(t,i)]=s[this._idx(t,i-1)];s[this._idx(-1,-1)]=s[this._idx(0,0)],s[this._idx(i,-1)]=s[this._idx(i-1,0)],s[this._idx(-1,i)]=s[this._idx(0,i-1)],s[this._idx(i,i)]=s[this._idx(i-1,i-1)];}const a="terrarium"===r?cx:ux;for(let t=0;t<s.length;++t){const e=4*t;this.floatView[t]=a(this.pixels[e],this.pixels[e+1],this.pixels[e+2]);}this._timestamp=Ct.now();}_buildQuadTree(){this._tree=new sx(this);}get(t,e,r=!1){r&&(t=Q(t,-1,this.dim),e=Q(e,-1,this.dim));const n=this._idx(t,e);return this.floatView[n]}set(t,e,r){const n=this._idx(t,e),i=this.floatView[n];return this.floatView[n]=r,r-i}static getUnpackVector(t){return lx[t]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}static pack(t,e){const r=[0,0,0,0],n=hx.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new fc({width:this.stride,height:this.stride},this.pixels)}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++){const n=4*this._idx(r,e),i=4*this._idx(r+o,e+l);this.pixels[n+0]=t.pixels[i+0],this.pixels[n+1]=t.pixels[i+1],this.pixels[n+2]=t.pixels[i+2],this.pixels[n+3]=t.pixels[i+3];}}onDeserialize(){this._tree&&(this._tree.dem=this);}}function px(t,e,r){1===t?e.headerLength=r.readFixed32():2===t?e.x=r.readVarint():3===t?e.y=r.readVarint():4===t?e.z=r.readVarint():5===t&&e.layers.push(function(t,e){return t.readFields(gx,{version:0,name:"",units:"",tileSize:0,buffer:0,pixelFormat:0,dataIndex:[]},e)}(r,r.readVarint()+r.pos));}function fx(t,e,r){1===t?(e.delta_filter=function(t,e){return t.readFields(dx,{blockSize:0},e)}(r,r.readVarint()+r.pos),e.filter="delta_filter"):2===t?(r.readVarint(),e.filter="zigzag_filter"):3===t?(r.readVarint(),e.filter="bitshuffle_filter"):4===t&&(r.readVarint(),e.filter="byteshuffle_filter");}function dx(t,e,r){1===t&&(e.blockSize=r.readVarint());}function mx(t,e,r){1===t?(r.readVarint(),e.codec="gzip_data"):2===t?(r.readVarint(),e.codec="jpeg_image"):3===t?(r.readVarint(),e.codec="webp_image"):4===t&&(r.readVarint(),e.codec="png_image");}function yx(t,e,r){let n=0,i=0;1===t?e.firstByte=r.readFixed64():2===t?e.lastByte=r.readFixed64():3===t?e.filters.push(function(t,e){return t.readFields(fx,{},e)}(r,r.readVarint()+r.pos)):4===t?e.codec=function(t,e){return t.readFields(mx,{},e)}(r,r.readVarint()+r.pos):5===t?i=r.readFloat():6===t?n=r.readFloat():7===t?e.bands.push(r.readString()):8===t?e.offset=r.readDouble():9===t&&(e.scale=r.readDouble()),0===e.offset&&(e.offset=i),0===e.scale&&(e.scale=n);}function gx(t,e,r){1===t?e.version=r.readVarint():2===t?e.name=r.readString():3===t?e.units=r.readString():4===t?e.tileSize=r.readVarint():5===t?e.buffer=r.readVarint():6===t?e.pixelFormat=r.readVarint():7===t&&e.dataIndex.push(function(t,e){return t.readFields(yx,{firstByte:0,lastByte:0,filters:[],codec:null,offset:0,scale:0,bands:[]},e)}(r,r.readVarint()+r.pos));}function xx(t,e,r){if(2===t)!function(t,e,r){t.readFields(vx,r,e);}(r,r.readVarint()+r.pos,e);else if(3===t)throw new Error("Not implemented")}function vx(t,e,r){if(1===t){let t=0;const n=r.readVarint()+r.pos;for(;r.pos<n;)e[t++]=r.readVarint();}}function bx(t,e){if(4!==e.length)throw new Error(`Expected data of dimension 4 but got ${e.length}.`);let r=e[3];for(let n=2;n>=1;n--){const i=1===n?1:0,s=2===n?1:0;for(let n=0;n<e[0];n++){const a=e[1]*n;for(let n=i;n<e[1];n++){const i=e[2]*(n+a);for(let n=s;n<e[2];n++){const s=e[3]*(n+i);for(let n=0;n<e[3];n++){const e=s+n;t[e]+=t[e-r];}}}}r*=e[n];}return t}function _x(t){for(let e=0,r=t.length;e<r;e++)t[e]=t[e]>>>1^-(1&t[e]);return t}function wx(t,e){switch(e){case"uint32":return t;case"uint16":for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];t[e]=(240&r)>>4|(61440&r)>>8|(240&n)<<4|61440&n,t[e+1]=15&r|(3840&r)>>4|(15&n)<<8|(3840&n)<<4;}return t;case"uint8":for(let e=0;e<t.length;e+=4){const r=t[e],n=t[e+1],i=t[e+2],s=t[e+3];t[e+0]=(192&r)>>6|(192&n)>>4|(192&i)>>2|192&s,t[e+1]=(48&r)>>4|(48&n)>>2|48&i|(48&s)<<2,t[e+2]=(12&r)>>2|12&n|(12&i)<<2|(12&s)<<4,t[e+3]=3&r|(3&n)<<2|(3&i)<<4|(3&s)<<6;}return t;default:throw new Error(`Invalid pixel format, "${e}"`)}}us(hx,"DEMData"),us(sx,"DemMinMaxQuadTree",{omit:["dem"]});var Mx=Uint8Array,Ax=Uint16Array,Ix=Int32Array,Sx=new Mx([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),Px=new Mx([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),Ex=new Mx([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),zx=function(t,e){for(var r=new Ax(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new Ix(r[30]);for(n=1;n<30;++n)for(var s=r[n];s<r[n+1];++s)i[s]=s-r[n]<<5|n;return {b:r,r:i}},kx=zx(Sx,2),Tx=kx.b,Bx=kx.r;Tx[28]=258,Bx[258]=28;for(var Vx=zx(Px,0).b,Cx=new Ax(32768),Dx=0;Dx<32768;++Dx){var Rx=(43690&Dx)>>1|(21845&Dx)<<1;Cx[Dx]=((65280&(Rx=(61680&(Rx=(52428&Rx)>>2|(13107&Rx)<<2))>>4|(3855&Rx)<<4))>>8|(255&Rx)<<8)>>1;}var Lx=function(t,e,r){for(var n=t.length,i=0,s=new Ax(e);i<n;++i)t[i]&&++s[t[i]-1];var a,o=new Ax(e);for(i=1;i<e;++i)o[i]=o[i-1]+s[i-1]<<1;a=new Ax(1<<e);var l=15-e;for(i=0;i<n;++i)if(t[i])for(var u=i<<4|t[i],c=e-t[i],h=o[t[i]-1]++<<c,p=h|(1<<c)-1;h<=p;++h)a[Cx[h]>>l]=u;return a},Fx=new Mx(288);for(Dx=0;Dx<144;++Dx)Fx[Dx]=8;for(Dx=144;Dx<256;++Dx)Fx[Dx]=9;for(Dx=256;Dx<280;++Dx)Fx[Dx]=7;for(Dx=280;Dx<288;++Dx)Fx[Dx]=8;var Ox=new Mx(32);for(Dx=0;Dx<32;++Dx)Ox[Dx]=5;var Nx=Lx(Fx,9),Ux=Lx(Ox,5),jx=function(t){for(var e=t[0],r=1;r<t.length;++r)t[r]>e&&(e=t[r]);return e},qx=function(t,e,r){var n=e/8|0;return (t[n]|t[n+1]<<8)>>(7&e)&r},$x=function(t,e){var r=e/8|0;return (t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&e)},Gx=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],Yx=function(t,e,r){var n=new Error(e||Gx[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,Yx),!r)throw n;return n},Hx=new Mx(0),Xx="undefined"!=typeof TextDecoder&&new TextDecoder;try{Xx.decode(Hx,{stream:!0});}catch(t){}const Zx={gzip_data:"gzip"};class Wx extends Error{constructor(t){super(t),this.name="MRTError";}}const Kx={0:"uint32",1:"uint32",2:"uint16",3:"uint8"},Jx={uint32:1,uint16:2,uint8:4},Qx={uint32:Uint32Array,uint16:Uint16Array,uint8:Uint8Array};let tv;class ev{constructor(t=5){this.x=NaN,this.y=NaN,this.z=NaN,this.layers={},this._cacheSize=t;}getLayer(t){const e=this.layers[t];if(!e)throw new Wx(`Layer '${t}' not found`);return e}getHeaderLength(t){const e=new Uint8Array(t),r=new DataView(t);if(13!==e[0])throw new Wx("File is not a valid MRT.");return r.getUint32(1,!0)}parseHeader(t){const e=new Uint8Array(t),r=this.getHeaderLength(t);if(e.length<r)throw new Wx(`Expected header with length >= ${r} but got buffer of length ${e.length}`);const n=function(t,e){return t.readFields(px,{headerLength:0,x:0,y:0,z:0,layers:[]},void 0)}(new tv(e.subarray(0,r)));if(!isNaN(this.x)&&(this.x!==n.x||this.y!==n.y||this.z!==n.z))throw new Wx(`Invalid attempt to parse header ${n.z}/${n.x}/${n.y} for tile ${this.z}/${this.x}/${this.y}`);this.x=n.x,this.y=n.y,this.z=n.z;for(const t of n.layers)this.layers[t.name]=new rv(t,{cacheSize:this._cacheSize});return this}createDecodingTask(t){const e=[],r=this.getLayer(t.layerName);for(let n of t.blockIndices){const i=r.dataIndex[n],s=i.firstByte-t.firstByte,a=i.lastByte-t.firstByte;if(r._blocksInProgress.has(n))continue;const o={layerName:r.name,firstByte:s,lastByte:a,pixelFormat:r.pixelFormat,blockIndex:n,blockShape:[i.bands.length].concat(r.bandShape),buffer:r.buffer,codec:i.codec.codec,filters:i.filters.map((t=>t.filter))};r._blocksInProgress.add(n),e.push(o);}return new nv(e,(()=>{e.forEach((t=>r._blocksInProgress.delete(t.blockIndex)));}),((t,n)=>{if(e.forEach((t=>r._blocksInProgress.delete(t.blockIndex))),t)throw t;n.forEach((t=>{this.getLayer(t.layerName).processDecodedData(t);}));}))}}class rv{constructor({version:t,name:e,units:r,tileSize:n,pixelFormat:i,buffer:s,dataIndex:a},o){if(this.version=t,1!==this.version)throw new Wx(`Cannot parse raster layer encoded with MRT version ${t}`);this.name=e,this.units=r,this.tileSize=n,this.buffer=s,this.pixelFormat=Kx[i],this.dataIndex=a,this.bandShape=[n+2*s,n+2*s,Jx[this.pixelFormat]],this._decodedBlocks=new Jg(o?o.cacheSize:5),this._blocksInProgress=new Set;}get dimension(){return Jx[this.pixelFormat]}get cacheSize(){return this._decodedBlocks.capacity}getBandList(){return this.dataIndex.map((({bands:t})=>t)).flat()}processDecodedData(t){const e=t.blockIndex.toString();this._decodedBlocks.get(e)||this._decodedBlocks.put(e,t.data);}getBlockForBand(t){let e=0;switch(typeof t){case"string":for(const[r,n]of this.dataIndex.entries()){for(const[i,s]of n.bands.entries())if(s===t)return {bandIndex:e+i,blockIndex:r,blockBandIndex:i};e+=n.bands.length;}break;case"number":for(const[r,n]of this.dataIndex.entries()){if(t>=e&&t<e+n.bands.length)return {bandIndex:t,blockIndex:r,blockBandIndex:t-e};e+=n.bands.length;}break;default:throw new Wx(`Invalid band \`${JSON.stringify(t)}\`. Expected string or integer.`)}return {blockIndex:-1,blockBandIndex:-1}}getDataRange(t){let e=1/0,r=-1/0;const n=[],i=new Set;for(const s of t){const{blockIndex:t}=this.getBlockForBand(s);if(t<0)throw new Wx(`Invalid band: ${JSON.stringify(s)}`);const a=this.dataIndex[t];n.includes(t)||n.push(t),i.add(t),e=Math.min(e,a.firstByte),r=Math.max(r,a.lastByte);}if(i.size>this.cacheSize)throw new Wx(`Number of blocks to decode (${i.size}) exceeds cache size (${this.cacheSize}).`);return {layerName:this.name,firstByte:e,lastByte:r,blockIndices:n}}hasBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0}hasDataForBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0&&!!this._decodedBlocks.get(e.toString())}getBandView(t){const{blockIndex:e,blockBandIndex:r}=this.getBlockForBand(t);if(e<0)throw new Wx(`Band not found: ${JSON.stringify(t)}`);const n=this._decodedBlocks.get(e.toString());if(!n)throw new Wx(`Data for band ${JSON.stringify(t)} of layer "${this.name}" not decoded.`);const i=this.dataIndex[e],s=this.bandShape.reduce(((t,e)=>t*e),1),a=r*s,o=n.subarray(a,a+s);return {data:o,bytes:new Uint8Array(o.buffer).subarray(o.byteOffset,o.byteOffset+o.byteLength),tileSize:this.tileSize,buffer:this.buffer,pixelFormat:this.pixelFormat,dimension:this.dimension,offset:i.offset,scale:i.scale}}}ev.setPbf=function(t){tv=t;};class nv{constructor(t,e,r){this.tasks=t,this._onCancel=e,this._onComplete=r,this._finalized=!1;}cancel(){this._finalized||(this._onCancel(),this._finalized=!0);}complete(t,e){this._finalized||(this._onComplete(t,e),this._finalized=!0);}}ev.performDecoding=function(t,e){const r=new Uint8Array(t);return Promise.all(e.tasks.map((t=>{const{layerName:e,firstByte:n,lastByte:i,pixelFormat:s,blockShape:a,blockIndex:o,filters:l,codec:u}=t,c=r.subarray(n,i+1),h=new Uint32Array(a[0]*a[1]*a[2]);let p;if("gzip_data"!==u)throw new Wx(`Unhandled codec: ${u}`);return p=function(t,e){if(!globalThis.DecompressionStream&&"gzip_data"===e)return Promise.resolve(((s=function(t){31==t[0]&&139==t[1]&&8==t[2]||Yx(6,"invalid gzip data");var e=t[3],r=10;4&e&&(r+=2+(t[10]|t[11]<<8));for(var n=(e>>3&1)+(e>>4&1);n>0;n-=!t[r++]);return r+(2&e)}(i=t))+8>i.length&&Yx(6,"invalid gzip data"),function(t,e,r,n){var i=t.length;if(!i||e.f&&!e.l)return r||new Mx(0);var s=!r,a=s||2!=e.i,o=e.i;s&&(r=new Mx(3*i));var l,u,c=function(t){var e=r.length;if(t>e){var n=new Mx(Math.max(2*e,t));n.set(r),r=n;}},h=e.f||0,p=e.p||0,f=e.b||0,d=e.l,m=e.d,y=e.m,g=e.n,x=8*i;do{if(!d){h=qx(t,p,1);var v=qx(t,p+1,3);if(p+=3,!v){var b=t[(T=4+((p+7)/8|0))-4]|t[T-3]<<8,_=T+b;if(_>i){o&&Yx(0);break}a&&c(f+b),r.set(t.subarray(T,_),f),e.b=f+=b,e.p=p=8*_,e.f=h;continue}if(1==v)d=Nx,m=Ux,y=9,g=5;else if(2==v){var w=qx(t,p,31)+257,M=qx(t,p+10,15)+4,A=w+qx(t,p+5,31)+1;p+=14;for(var I=new Mx(A),S=new Mx(19),P=0;P<M;++P)S[Ex[P]]=qx(t,p+3*P,7);p+=3*M;var E=jx(S),z=(1<<E)-1,k=Lx(S,E);for(P=0;P<A;){var T,B=k[qx(t,p,z)];if(p+=15&B,(T=B>>4)<16)I[P++]=T;else {var V=0,C=0;for(16==T?(C=3+qx(t,p,3),p+=2,V=I[P-1]):17==T?(C=3+qx(t,p,7),p+=3):18==T&&(C=11+qx(t,p,127),p+=7);C--;)I[P++]=V;}}var D=I.subarray(0,w),R=I.subarray(w);y=jx(D),g=jx(R),d=Lx(D,y),m=Lx(R,g);}else Yx(1);if(p>x){o&&Yx(0);break}}a&&c(f+131072);for(var L=(1<<y)-1,F=(1<<g)-1,O=p;;O=p){var N=(V=d[$x(t,p)&L])>>4;if((p+=15&V)>x){o&&Yx(0);break}if(V||Yx(2),N<256)r[f++]=N;else {if(256==N){O=p,d=null;break}var U=N-254;N>264&&(U=qx(t,p,(1<<($=Sx[P=N-257]))-1)+Tx[P],p+=$);var j=m[$x(t,p)&F],q=j>>4;if(j||Yx(3),p+=15&j,R=Vx[q],q>3){var $=Px[q];R+=$x(t,p)&(1<<$)-1,p+=$;}if(p>x){o&&Yx(0);break}a&&c(f+131072);var G=f+U;if(f<R){var Y=0-R,H=Math.min(R,G);for(Y+f<0&&Yx(3);f<H;++f)r[f]=(void 0)[Y+f];}for(;f<G;++f)r[f]=r[f-R];}}e.l=d,e.p=O,e.b=f,e.f=h,d&&(h=1,e.m=y,e.d=m,e.n=g);}while(!h);return f!=r.length&&s?(l=r,(null==(u=f)||u>l.length)&&(u=l.length),new Mx(l.subarray(0,u))):r.subarray(0,f)}(i.subarray(s,-8),{i:2},new Mx(((r=i)[(n=r.length)-4]|r[n-3]<<8|r[n-2]<<16|r[n-1]<<24)>>>0))));var r,n,i,s;const a=Zx[e];if(!a)throw new Error(`Unhandled codec: ${e}`);const o=new globalThis.DecompressionStream(a);return new Response(new Blob([t]).stream().pipeThrough(o)).arrayBuffer().then((t=>new Uint8Array(t)))}(c,u).then((t=>(function(t,e){t.readFields(xx,e);}(new tv(t),h),new(0,Qx[s])(h.buffer)))),p.then((t=>{for(let e=l.length-1;e>=0;e--)switch(l[e]){case"delta_filter":bx(t,a);break;case"zigzag_filter":_x(t);break;case"bitshuffle_filter":wx(t,s);break;default:throw new Wx(`Unhandled filter "${l[e]}"`)}return {layerName:e,blockIndex:o,data:t}})).catch((t=>{throw t}))})))},us(nv,"MRTDecodingBatch",{omit:["_onCancel","_onComplete"]}),us(ev,"MapboxRasterTile"),us(rv,"MapboxRasterLayer",{omit:["_blocksInProgress"]});let iv,sv,av,ov,lv,uv=null;function cv(){return yt()&&self.worker&&self.worker.dracoUrl?self.worker.dracoUrl:sv||At.DRACO_URL}function hv(){if(yt()&&self.worker&&self.worker.meshoptUrl)return self.worker.meshoptUrl;if(ov)return ov;const t=new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,3,2,0,0,5,3,1,0,1,12,1,0,10,22,2,12,0,65,0,65,0,65,0,252,10,0,0,11,7,0,65,0,253,15,26,11]);if("object"!=typeof WebAssembly)throw new Error("WebAssembly not supported, cannot instantiate meshoptimizer");return ov=WebAssembly.validate(t)?At.MESHOPT_SIMD_URL:At.MESHOPT_URL,ov}const pv={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},fv={5120:"DT_INT8",5121:"DT_UINT8",5122:"DT_INT16",5123:"DT_UINT16",5125:"DT_UINT32",5126:"DT_FLOAT32"},dv={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};function mv(t,e,r){const n=r.json.bufferViews.length,i=r.buffers.length;e.bufferView=n,r.json.bufferViews[n]={buffer:i,byteLength:t.byteLength},r.buffers[i]=t;}const yv="KHR_draco_mesh_compression";function gv(t,e){const r=t.extensions&&t.extensions[yv];if(!r)return;const n=new av.Decoder,i=Av(e,r.bufferView),s=new av.Mesh;if(!n.DecodeArrayToMesh(i,i.byteLength,s))throw new Error("Failed to decode Draco mesh");const a=e.json.accessors[t.indices],o=pv[a.componentType],l=a.count*o.BYTES_PER_ELEMENT,u=av._malloc(l);o===Uint16Array?n.GetTrianglesUInt16Array(s,l,u):n.GetTrianglesUInt32Array(s,l,u),mv(av.memory.buffer.slice(u,u+l),a,e),av._free(u);for(const i of Object.keys(r.attributes)){const a=n.GetAttributeByUniqueId(s,r.attributes[i]),o=e.json.accessors[t.attributes[i]],l=fv[o.componentType],u=o.count*dv[o.type]*pv[o.componentType].BYTES_PER_ELEMENT,c=av._malloc(u);n.GetAttributeDataArrayForAllPoints(s,a,av[l],u,c),mv(av.memory.buffer.slice(c,c+u),o,e),av._free(c);}n.destroy(),s.destroy(),delete t.extensions[yv];}const xv="EXT_meshopt_compression";function vv(t,e){if(!t.extensions||!t.extensions[xv])return;const r=t.extensions[xv],n=new Uint8Array(e.buffers[r.buffer],r.byteOffset||0,r.byteLength||0),i=new Uint8Array(r.count*r.byteStride);lv.decodeGltfBuffer(i,r.count,r.byteStride,n,r.mode,r.filter),t.buffer=e.buffers.length,t.byteOffset=0,e.buffers[t.buffer]=i.buffer,delete t.extensions[xv];}const bv=1179937895,_v=new TextDecoder("utf8");function wv(t,e){return new URL(t,e).href}function Mv(t,e,r,n){return fetch(wv(t.uri,n)).then((t=>t.arrayBuffer())).then((t=>{e.buffers[r]=t;}))}function Av(t,e){const r=t.json.bufferViews[e];return new Uint8Array(t.buffers[r.buffer],r.byteOffset||0,r.byteLength)}function Iv(t,e,r,n){if(t.uri){const i=wv(t.uri,n);return fetch(i).then((t=>t.blob())).then((t=>createImageBitmap(t))).then((t=>{e.images[r]=t;}))}if(void 0!==t.bufferView){const n=Av(e,t.bufferView),i=new Blob([n],{type:t.mimeType});return createImageBitmap(i).then((t=>{e.images[r]=t;}))}}function Sv(t,e=0,r){const n={json:null,images:[],buffers:[]};if(new Uint32Array(t,e,1)[0]===bv){const r=new Uint32Array(t,e);let i=2;const s=(r[i++]>>2)-3,a=r[i++]>>2;if(i++,n.json=JSON.parse(_v.decode(r.subarray(i,i+a))),i+=a,i<s){const s=r[i++];i++;const a=e+(i<<2);n.buffers[0]=t.slice(a,a+s);}}else n.json=JSON.parse(_v.decode(new Uint8Array(t,e)));const{buffers:i,images:s,meshes:a,extensionsUsed:o,bufferViews:l}=n.json;let u=Promise.resolve();if(i){const t=[];for(let e=0;e<i.length;e++){const s=i[e];s.uri?t.push(Mv(s,n,e,r)):n.buffers[e]||(n.buffers[e]=null);}u=Promise.all(t);}return u.then((()=>{const t=[],e=o&&o.includes(yv),i=o&&o.includes(xv);if(e&&t.push(function(){if(!av)return null!=iv?iv:(iv=function(t){let e,r=null;function n(){e=new Uint8Array(r.buffer);}function i(){throw new Error("Unexpected Draco error.")}const s={a:{a:i,d:function(t,r,n){return e.copyWithin(t,r,r+n)},c:function(t){const i=e.length,s=Math.max(t>>>0,Math.ceil(1.2*i)),a=Math.ceil((s-i)/65536);try{return r.grow(a),n(),!0}catch(t){return !1}},b:i}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,s):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,s)))).then((t=>{const{Rb:i,Qb:s,P:a,T:o,X:l,Ja:u,La:c,Qa:h,Va:p,Wa:f,eb:d,jb:m,f:y,e:g,yb:x,zb:v,Ab:b,Bb:_,Db:w,Gb:M}=t.instance.exports;r=g;const A=(()=>{let t=0,r=0,n=0,a=0;return o=>{n&&(i(a),i(t),r+=n,n=t=0),t||(r+=128,t=s(r));const l=o.length+7&-8;let u=t;l>=r&&(n=l,u=a=s(l));for(let t=0;t<o.length;t++)e[u+t]=o[t];return u}})();return n(),y(),{memory:g,_free:i,_malloc:s,Mesh:class{constructor(){this.ptr=a();}destroy(){o(this.ptr);}},Decoder:class{constructor(){this.ptr=u();}destroy(){m(this.ptr);}DecodeArrayToMesh(t,e,r){const n=A(t),i=c(this.ptr,n,e,r.ptr);return !!l(i)}GetAttributeByUniqueId(t,e){return {ptr:h(this.ptr,t.ptr,e)}}GetTrianglesUInt16Array(t,e,r){p(this.ptr,t.ptr,e,r);}GetTrianglesUInt32Array(t,e,r){f(this.ptr,t.ptr,e,r);}GetAttributeDataArrayForAllPoints(t,e,r,n,i){d(this.ptr,t.ptr,e.ptr,r,n,i);}},DT_INT8:x(),DT_UINT8:v(),DT_INT16:b(),DT_UINT16:_(),DT_UINT32:w(),DT_FLOAT32:M()}}))}(fetch(cv())),iv.then((t=>{av=t,iv=void 0;})))}()),i&&t.push(function(){if(lv)return;const t=function(t){let e;const r=WebAssembly.instantiateStreaming(t,{}).then((t=>{e=t.instance,e.exports.__wasm_call_ctors();})),n={NONE:"",OCTAHEDRAL:"meshopt_decodeFilterOct",QUATERNION:"meshopt_decodeFilterQuat",EXPONENTIAL:"meshopt_decodeFilterExp"},i={ATTRIBUTES:"meshopt_decodeVertexBuffer",TRIANGLES:"meshopt_decodeIndexBuffer",INDICES:"meshopt_decodeIndexSequence"};return {ready:r,supported:!0,decodeGltfBuffer(t,r,s,a,o,l){!function(t,e,r,n,i,s,a){const o=t.exports.sbrk,l=n+3&-4,u=o(l*i),c=o(s.length),h=new Uint8Array(t.exports.memory.buffer);h.set(s,c);const p=e(u,n,i,c,s.length);if(0===p&&a&&a(u,l,i),r.set(h.subarray(u,u+n*i)),o(u-o(0)),0!==p)throw new Error(`Malformed buffer data: ${p}`)}(e,e.exports[i[o]],t,r,s,a,e.exports[n[l]]);}}}(fetch(hv()));return t.ready.then((()=>{lv=t;}))}()),s)for(let e=0;e<s.length;e++)t.push(Iv(s[e],n,e,r));return (t.length?Promise.all(t):Promise.resolve()).then((()=>{if(e&&a)for(const{primitives:t}of a)for(const e of t)gv(e,n);if(i&&a&&l)for(const t of l)vv(t,n);return n}))}))}function Pv(t,e){const r=t.json.bufferViews[e.bufferView],n=pv[e.componentType];return new n(t.buffers[r.buffer],(e.byteOffset||0)+(r.byteOffset||0),e.count*(r.byteStride&&r.byteStride!==dv[e.type]*n.BYTES_PER_ELEMENT?r.byteStride/n.BYTES_PER_ELEMENT:dv[e.type]))}function Ev(t,e,r,n){const i=pv[e.componentType],s=function(t){switch(t){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:return 1}}(i),a=t.json.bufferViews[e.bufferView],o=a.byteStride?a.byteStride/i.BYTES_PER_ELEMENT:dv[e.type],l=r.float32,u=l.length/r.capacity;for(let t=0,r=0;t<e.count*o;t+=o,r+=u)for(let e=0;e<u;e++)l[r+e]=n[t+e]*s;r._trim();}function zv(t,e,r){const n=t.indices,i=t.attributes,s={};s.indexArray=new ja;const a=e.json.accessors[n],o=a.count/3;s.indexArray.reserve(o);const l=Pv(e,a);for(let t=0;t<o;t++)s.indexArray.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);s.indexArray._trim(),s.vertexArray=new za;const u=e.json.accessors[i.POSITION];s.vertexArray.reserve(u.count);const c=Pv(e,u);for(let t=0;t<u.count;t++)s.vertexArray.emplaceBack(c[3*t],c[3*t+1],c[3*t+2]);if(s.vertexArray._trim(),s.aabb=new Au(u.min,u.max),s.centroid=function(t,e){const r=[0,0,0],n=t.length;if(n>0){for(let i=0;i<n;i++){const n=3*t[i];r[0]+=e[n],r[1]+=e[n+1],r[2]+=e[n+2];}r[0]/=n,r[1]/=n,r[2]/=n;}return r}(l,c),void 0!==i.COLOR_0){const t=e.json.accessors[i.COLOR_0],r=dv[t.type],n=Pv(e,t);s.colorArray=3===r?new za:new Da,s.colorArray.resize(t.count),Ev(e,t,s.colorArray,n);}if(void 0!==i.NORMAL){s.normalArray=new za;const t=e.json.accessors[i.NORMAL];s.normalArray.resize(t.count);const r=Pv(e,t);Ev(e,t,s.normalArray,r);}if(void 0!==i.TEXCOORD_0&&r.length>0){s.texcoordArray=new Za;const t=e.json.accessors[i.TEXCOORD_0];s.texcoordArray.resize(t.count);const r=Pv(e,t);Ev(e,t,s.texcoordArray,r);}if(void 0!==i._FEATURE_ID_RGBA4444){const t=e.json.accessors[i._FEATURE_ID_RGBA4444];e.json.extensionsUsed&&e.json.extensionsUsed.includes("EXT_meshopt_compression")&&(s.featureData=Pv(e,t));}void 0!==i._FEATURE_RGBA4444&&(s.featureData=new Uint32Array(Pv(e,e.json.accessors[i._FEATURE_RGBA4444]).buffer));const h=t.material;return s.material=function(t,e){const{emissiveFactor:r=[0,0,0],alphaMode:n="OPAQUE",alphaCutoff:i=.5,normalTexture:s,occlusionTexture:a,emissiveTexture:o,doubleSided:l}=t,{baseColorFactor:u=[1,1,1,1],metallicFactor:c=1,roughnessFactor:h=1,baseColorTexture:p,metallicRoughnessTexture:f}=t.pbrMetallicRoughness||{},d=a?e[a.index]:void 0;if(a&&a.extensions&&a.extensions.KHR_texture_transform&&d){const t=a.extensions.KHR_texture_transform;d.offsetScale=[t.offset[0],t.offset[1],t.scale[0],t.scale[1]];}return {pbrMetallicRoughness:{baseColorFactor:new Se(...u),metallicFactor:c,roughnessFactor:h,baseColorTexture:p?e[p.index]:void 0,metallicRoughnessTexture:f?e[f.index]:void 0},doubleSided:l,emissiveFactor:r,alphaMode:n,alphaCutoff:i,normalTexture:s?e[s.index]:void 0,occlusionTexture:d,emissionTexture:o?e[o.index]:void 0,defined:void 0===t.defined}}(void 0!==h?e.json.materials[h]:{defined:!1},r),s}function kv(t,e,r){const{matrix:n,rotation:i,translation:s,scale:a,mesh:o,extras:l,children:u}=t,c={};if(c.matrix=n||O.mat4.fromRotationTranslationScale([],i||[0,0,0,1],s||[0,0,0],a||[1,1,1]),void 0!==o){c.meshes=r[o];const t=c.anchor=[0,0];for(const e of c.meshes){const{min:r,max:n}=e.aabb;t[0]+=r[0]+n[0],t[1]+=r[1]+n[1];}t[0]=Math.floor(t[0]/c.meshes.length/2),t[1]=Math.floor(t[1]/c.meshes.length/2);}if(l&&(l.id&&(c.id=l.id),l.lights&&(c.lights=function(t){if(!t.length)return [];const e=function(t){const e=atob(t),r=new Uint8Array(e.length);for(let t=0;t<e.length;t++)r[t]=e.codePointAt(t);return r}(t),r=[],n=e.length/24,i=new Uint16Array(e.buffer),s=new Float32Array(e.buffer);for(let t=0;t<n;t++){const e=i[2*t*6]/30,n=i[2*t*6+1]/30,a=i[2*t*6+10]/100,o=s[6*t+1],l=s[6*t+2],u=s[6*t+3],c=s[6*t+4],h=u-o,p=c-l,f=Math.hypot(h,p);r.push({pos:[o+.5*h,l+.5*p,n],normal:[p/f,-h/f,0],width:f,height:e,depth:a,points:[o,l,u,c]});}return r}(l.lights))),u){const t=[];for(const n of u)t.push(kv(e.json.nodes[n],e,r));c.children=t;}return c}function Tv(t){if(0===t.vertices.length||0===t.indices.length)return null;const e=new Sh(t.vertices,t.indices,8,256),[r,n]=[e.min.clone(),e.max.clone()];return {vertices:t.vertices,indices:t.indices,grid:e,min:r,max:n}}function Bv(t){if(!t.extras||!t.extras.ground)return null;const e=t.extras.ground;if(!e||!Array.isArray(e)||0===e.length)return null;const r=e[0];if(!r||!Array.isArray(r)||0===r.length)return null;const n=[];for(const t of r){if(!Array.isArray(t)||2!==t.length)continue;const e=t[0],r=t[1];"number"==typeof e&&"number"==typeof r&&n.push(new q(e,r));}if(n.length<3)return null;n.length>1&&n[n.length-1].equals(n[0])&&n.pop();let i=0;for(let t=0;t<n.length;t++){const e=n[t],r=n[(t+1)%n.length],s=n[(t+2)%n.length];i+=(e.x-r.x)*(s.y-r.y)-(s.x-r.x)*(e.y-r.y);}i>0&&n.reverse();const s=vc(n.flatMap((t=>[t.x,t.y])),[]);return 0===s.length?null:{vertices:n,indices:s}}function Vv(t,e){const r=[],n=[];let i=0;const s=[];for(const a of t){i=r.length;const t=a.vertexArray.float32,o=a.indexArray.uint16;for(let n=0;n<a.vertexArray.length;n++)s[0]=t[3*n+0],s[1]=t[3*n+1],s[2]=t[3*n+2],O.vec3.transformMat4(s,s,e),r.push(new q(s[0],s[1]));for(let t=0;t<3*a.indexArray.length;t++)n.push(o[t]+i);}if(n.length%3!=0)return null;for(let t=0;t<n.length;t+=3){const e=r[n[t+0]],i=r[n[t+1]],s=r[n[t+2]];(e.x-i.x)*(s.y-i.y)-(s.x-i.x)*(e.y-i.y)>0&&([n[t+1],n[t+2]]=[n[t+2],n[t+1]]);}return {vertices:r,indices:n}}function Cv(t){const e=function(t,e){const r=[],n=WebGL2RenderingContext;if(t.json.textures)for(const i of t.json.textures){const s={magFilter:n.LINEAR,minFilter:n.NEAREST,wrapS:n.REPEAT,wrapT:n.REPEAT};void 0!==i.sampler&&Object.assign(s,t.json.samplers[i.sampler]),r.push({image:e[i.source],sampler:s,uploaded:!1});}return r}(t,t.images),r=function(t,e){const r=[];for(const n of t.json.meshes){const i=[];for(const r of n.primitives)i.push(zv(r,t,e));r.push(i);}return r}(t,e),{scenes:n,scene:i,nodes:s}=t.json,a=n?n[i||0].nodes:s,o=[];for(const e of a)o.push(kv(s[e],t,r));return function(t,e,r){const n={},i=new Set;for(let s=0;s<t.length;s++){const t=r[e[s]];if(!t.extras)continue;const a=t.extras["mapbox:footprint:version"],o=t.extras["mapbox:footprint:id"];(a||o)&&i.add(s),"1.0.0"===a&&o&&(n[o]=s);}for(let s=0;s<t.length;s++){if(i.has(s))continue;const a=t[s],o=r[e[s]];if(!o.extras)continue;let l=null;a.id in n&&(l=Vv(t[n[a.id]].meshes,a.matrix)),l||(l=Bv(o)),l&&(a.footprint=Tv(l));}if(i.size>0){const e=Array.from(i.values()).sort(((t,e)=>t-e));for(let r=e.length-1;r>=0;r--)t.splice(e[r],1);}}(o,a,t.json.nodes),o}function Dv(t){t.heightmap=new Float32Array(4096),t.heightmap.fill(-1);const e=t.vertexArray.float32,r=t.aabb.min[0]-1,n=t.aabb.min[1]-1,i=ky/(t.aabb.max[0]-r+2),s=ky/(t.aabb.max[1]-n+2);for(let a=0;a<e.length;a+=3){const o=e[a+2],l=(e[a+0]-r)*i|0,u=(e[a+1]-n)*s|0;o>t.heightmap[u*ky+l]&&(t.heightmap[u*ky+l]=o);}}function Rv(t,e){const r={};r.indexArray=new ja,r.indexArray.reserve(4*t.length),r.vertexArray=new za,r.vertexArray.reserve(10*t.length),r.colorArray=new Da,r.vertexArray.reserve(10*t.length);let n=0;for(const i of t){const t=Math.min(10,Math.max(4,1.3*i.height))*e,s=[-i.normal[1],i.normal[0],0],a=Math.min(.29,.1*i.width/i.depth),o=i.width-2*i.depth*e*(a+.01),l=O.vec3.scaleAndAdd([],i.pos,s,o/2),u=O.vec3.scaleAndAdd([],i.pos,s,-o/2),c=[l[0],l[1],l[2]+i.height],h=[u[0],u[1],u[2]+i.height],p=O.vec3.scaleAndAdd([],i.normal,s,a);O.vec3.scale(p,p,t);const f=O.vec3.scaleAndAdd([],i.normal,s,-a);O.vec3.scale(f,f,t),O.vec3.add(p,l,p),O.vec3.add(f,u,f),l[2]+=.1,u[2]+=.1,r.vertexArray.emplaceBack(p[0],p[1],p[2]),r.vertexArray.emplaceBack(f[0],f[1],f[2]),r.vertexArray.emplaceBack(l[0],l[1],l[2]),r.vertexArray.emplaceBack(u[0],u[1],u[2]),r.vertexArray.emplaceBack(c[0],c[1],c[2]),r.vertexArray.emplaceBack(h[0],h[1],h[2]),r.vertexArray.emplaceBack(l[0],l[1],l[2]),r.vertexArray.emplaceBack(u[0],u[1],u[2]),r.vertexArray.emplaceBack(p[0],p[1],p[2]),r.vertexArray.emplaceBack(f[0],f[1],f[2]);const d=o/t/2;r.colorArray.emplaceBack(-d-a,-1,d,.8),r.colorArray.emplaceBack(d+a,-1,d,.8),r.colorArray.emplaceBack(-d,0,d,1.3),r.colorArray.emplaceBack(d,0,d,1.3),r.colorArray.emplaceBack(d+a,-.8,d,.7),r.colorArray.emplaceBack(d+a,-.8,d,.7),r.colorArray.emplaceBack(0,0,d,1.3),r.colorArray.emplaceBack(0,0,d,1.3),r.colorArray.emplaceBack(d+a,-1.2,d,.8),r.colorArray.emplaceBack(d+a,-1.2,d,.8),r.indexArray.emplaceBack(6+n,4+n,8+n),r.indexArray.emplaceBack(7+n,9+n,5+n),r.indexArray.emplaceBack(0+n,1+n,2+n),r.indexArray.emplaceBack(1+n,3+n,2+n),n+=10;}const i={defined:!0,emissiveFactor:[0,0,0]},s={};return s.baseColorFactor=Se.white,i.pbrMetallicRoughness=s,r.material=i,r.aabb=new Au([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),r}class Lv{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}const Fv=["id","tile","layer","source","sourceLayer","state"];class Ov{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._z=e,this._x=r,this._y=n,this.properties=t.properties,this.id=i;}clone(){const t=new Ov(this._vectorTileFeature,this._z,this._x,this._y,this.id);return this.state&&(t.state=Object.assign({},this.state)),this.layer&&(t.layer=Object.assign({},this.layer)),this.source&&(t.source=this.source),this.sourceLayer&&(t.sourceLayer=this.sourceLayer),t}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};for(const e of Fv)void 0!==this[e]&&(t[e]=this[e]);return t}}class Nv{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new os(Kr,16,0),this.featureIndexArray=new ho,this.promoteId=e,this.is3DTile=!1,this.serializedLayersCache=new Map;}insert(t,e,r,n,i,s=0,a=0){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,s);const l=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}0!==a&&(n[0]-=a,n[1]-=a,n[2]+=a,n[3]+=a),n[0]<Kr&&n[1]<Kr&&n[2]>=0&&n[3]>=0&&l.insert(o,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new ah.VectorTile(new Cf(this.rawTileData)).layers,this.sourceLayerCoder=new Lv(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e){const{tilespaceGeometry:r,transform:n,tileTransform:i,pixelPosMatrix:s,availableImages:a}=e;this.loadVTLayers(),this.serializedLayersCache.clear();const o=r.bufferedTilespaceBounds,l=this.grid.query(o.min.x,o.min.y,o.max.x,o.max.y,((t,e,n,i)=>Xl(r.bufferedTilespaceGeometry,t,e,n,i)));l.sort(jv);let u=null;n.elevation&&l.length>0&&(u=Fy.create(n.elevation,this.tileID));const c={};let h;for(let e=0;e<l.length;e++){const o=l[e];if(o===h)continue;h=o;const p=this.featureIndexArray.get(o);let f=null;this.is3DTile?this.loadMatchingModelFeature(c,p,t,r,n):this.loadMatchingFeature(c,p,t,a,((t,e,a,o=0)=>(f||(f=Vl(t,this.tileID.canonical,i)),e.queryIntersectsFeature(r,t,a,f,this.z,n,s,u,o))));}return c}loadMatchingFeature(t,e,r,n,i){const{featureIndex:s,bucketIndex:a,sourceLayerIndex:o,layoutVertexArrayOffset:l}=e,u=this.bucketLayerIDs[a],c=r.layers,h=Object.keys(c);if(h.length&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(h,u))return;const p=r.sourceCache,f=this.sourceLayerCoder.decode(o),d=this.vtLayers[f].feature(s),m=this.getId(d,f);for(let e=0;e<u.length;e++){const r=u[e];if(!c[r])continue;const{styleLayer:a,targets:o}=c[r];let h={};void 0!==m&&(h=p.getFeatureState(a.sourceLayer,m));const f=!i||i(d,a,h,l);if(!f)continue;const y=new Ov(d,this.z,this.x,this.y,m);y.tile=this.tileID.canonical,y.state=h;let g=this.serializedLayersCache.get(r);g||(g=a.serialize(),g.id=r,this.serializedLayersCache.set(r,g)),y.source=g.source,y.sourceLayer=g["source-layer"],y.layer=nt({},g),y.layer.paint=Uv(g.paint,a.paint,d,h,n),y.layer.layout=Uv(g.layout,a.layout,d,h,n);let x=!1;for(const t of o){this.updateFeatureProperties(y,t);const{filter:e}=t;if(e)if(d.properties=y.properties,e.needGeometry){const t=Cl(d,!0);if(!e.filter(new Rs(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!e.filter(new Rs(this.tileID.overscaledZ),d))continue;x=!0,t.targetId&&this.addFeatureVariant(y,t);}x&&this.appendToResult(t,r,s,y,f);}}loadMatchingModelFeature(t,e,r,n,i){const s=this.bucketLayerIDs[0][0],a=r.layers;if(!a[s])return;const{styleLayer:o,targets:l}=a[s];if("model"!==o.type)return;const u=n.tile,c=e.featureIndex,h=u.getBucket(o);if(!(h&&h instanceof Gy))return;const p=function(t,e,r,n){const i=t.getNodesInfo()[e];if(i.hiddenByReplacement||!i.node.meshes)return;let s=Number.MAX_VALUE;const a=i.node,o=r.tile,l=n.calculatePosMatrix(o.tileID.toUnwrapped(),n.worldSize),u=i.evaluatedScale;let c=0;n.elevation&&a.elevation&&(c=a.elevation*n.elevation.exaggeration()),O.mat4.translate(l,l,[(a.anchor?a.anchor[0]:0)*(u[0]-1),(a.anchor?a.anchor[1]:0)*(u[1]-1),c]),O.mat4.scale(l,l,u);const h=r.queryGeometry,p=h.isPointQuery()?h.screenBounds:h.screenGeometry,f=function(t){const e=O.mat4.multiply([],l,t.matrix);O.mat4.multiply(e,n.expandedFarZProjMatrix,e);for(let r=0;r<t.meshes.length;++r){const i=t.meshes[r];if(r===t.lightMeshIndex)continue;const a=dy(p,n,e,i.aabb);null!=a&&(s=Math.min(a,s));}if(t.children)for(const e of t.children)f(e);};if(f(a),s===Number.MAX_VALUE)return;const d=new ul(0,0);return Zy(o.tileID.canonical,d,i.node.anchor[0],i.node.anchor[1]),{intersectionZ:s,position:d,feature:i.feature}}(h,c,n,i);if(!p)return;const{z:f,x:d,y:m}=u.tileID.canonical,{feature:y,intersectionZ:g,position:x}=p;let v={};void 0!==y.id&&(v=r.sourceCache.getFeatureState(o.sourceLayer,y.id));const b=new Ov({},f,d,m,y.id);b.tile=this.tileID.canonical,b.state=v,b.properties=y.properties,b.geometry={type:"Point",coordinates:[x.lng,x.lat]};let _=this.serializedLayersCache.get(s);_||(_=o.serialize(),_.id=s,this.serializedLayersCache.set(s,_)),b.source=_.source,b.sourceLayer=_["source-layer"],b.layer=nt({},_);let w=!1;for(const t of l){this.updateFeatureProperties(b,t);const{filter:e}=t;if(e)if(y.properties=b.properties,e.needGeometry){if(!e.filter(new Rs(this.tileID.overscaledZ),y,this.tileID.canonical))continue}else if(!e.filter(new Rs(this.tileID.overscaledZ),y))continue;w=!0,t.targetId&&this.addFeatureVariant(b,t);}w&&this.appendToResult(t,s,c,b,g);}updateFeatureProperties(t,e,r){if(e.properties){const n={};for(const i in e.properties){const s=e.properties[i].evaluate({zoom:this.z},t._vectorTileFeature,t.state,t.tile,r);null!=s&&(n[i]=s);}t.properties=n;}}addFeatureVariant(t,e,r){const n={target:e.target,namespace:e.namespace,uniqueFeatureID:e.uniqueFeatureID};e.properties&&(n.properties=t.properties),t.variants=t.variants||{},t.variants[e.targetId]=t.variants[e.targetId]||[],t.variants[e.targetId].push(n);}appendToResult(t,e,r,n,i){let s=t[e];void 0===s&&(s=t[e]=[]),s.push({featureIndex:r,feature:n,intersectionZ:i});}lookupSymbolFeatures(t,e,r,n,i){const s={};this.loadVTLayers();for(const a of t)this.loadMatchingFeature(s,{bucketIndex:e,sourceLayerIndex:r,featureIndex:a,layoutVertexArrayOffset:0},n,i);return s}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const s=this.vtLayers[n].feature(e);return i[e]=s,s}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;if(this.promoteId){const n=Array.isArray(this.promoteId)||"object"!=typeof this.promoteId?this.promoteId:this.promoteId[e];if(null!=n)if(Array.isArray(n)){if(!this.promoteIdExpression){const t=Ji(n);if("success"!==t.result){const e=t.value.map((t=>`${t.key}: ${t.message}`)).join(", ");return void pt(`Failed to create expression for promoteId: ${e}`)}this.promoteIdExpression=t.value;}this.promoteIdExpression._evaluator||(this.promoteIdExpression._evaluator=new yr),r=this.promoteIdExpression.evaluate({zoom:0},t);}else r=t.properties[n];"boolean"==typeof r&&(r=Number(r));}return r}}function Uv(t,e,r,n,i){return lt(t,((t,s)=>{const a=e instanceof $s?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function jv(t,e){return e-t}us(Nv,"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});const qv=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class $v{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=qv[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new $v(a,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=qv.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Gv(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Zv(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Zv(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o}}function Gv(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;Yv(t,e,a,n,i,s),Gv(t,e,r,n,a-1,1-s),Gv(t,e,r,a+1,i,1-s);}function Yv(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);Yv(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(Hv(t,e,n,r),e[2*i+s]>a&&Hv(t,e,n,i);o<l;){for(Hv(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?Hv(t,e,n,l):(l++,Hv(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function Hv(t,e,r,n){Xv(t,r,n),Xv(e,2*r,2*n),Xv(e,2*r+1,2*n+1);}function Xv(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Zv(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}t.$=gr,t.A=ge,t.B=tr,t.C=pa,t.D=ng,t.E=_e,t.F=2,t.G=pd,t.H=cd,t.I=we,t.J=class extends My{},t.K=pr,t.L=Be,t.M=Ws,t.N=Ui,t.O=Fi,t.P=q,t.Q=Ni,t.R=Qt,t.S=Ki,t.T=qm,t.U=Ks,t.V=My,t.W=es,t.X=Ji,t.Y=Vn,t.Z=Dn,t._=Bn,t.a=function(t){return At.API_CDN_URL_REGEX.test(t)},t.a$=Cl,t.a0=Ie,t.a1=Js,t.a2=ji,t.a3=Oi,t.a4=function(t){const e=t.value;let r=[];if(!e)return r;const n=pr(e);return "string"!==n?(r=r.concat([new My(t.key,e,`string expected, "${n}" found`)]),r):(Ay(e,!0)||(r=r.concat([new My(t.key,e,`invalid url "${e}"`)])),r)},t.a5=Zs,t.a6=Os,t.a7=Xs,t.a8=Gs,t.a9=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return mt(t.expression.evaluate(e))}interpolate(t,e,r){return {x:Ee(t.x,e.x,r),y:Ee(t.y,e.y,r),z:Ee(t.z,e.z,r),azimuthal:Ee(t.azimuthal,e.azimuthal,r),polar:Ee(t.polar,e.polar,r)}}},t.aA=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.aB=cl,t.aC=ml,t.aD=class{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}},t.aE=function(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=ne(t.request,((t,n,i,s)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new ah.VectorTile(new Cf(n)),rawData:n,cacheControl:i,expires:s});}));return ()=>{n.cancel(),e();}}),e)},t.aF=function(t){Gt++,Gt>Ot&&(t.getActor().send("enforceCacheSizeLimit",Ft),Gt=0);},t.aG=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.aH=uu,t.aI=Wm,t.aJ=ry,t.aK=Xm,t.aL=function(t,e){const r=document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=document.createElement("source");ie(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.aM=$m,t.aN=function(t){return fetch(t).then((t=>t.arrayBuffer())).then((e=>Sv(e,0,t)))},t.aO=Cv,t.aP=class{constructor(t,e,r,n){this.id=t,this.position=null!=e?new ul(e[0],e[1]):new ul(0,0),this.orientation=null!=r?r:[0,0,0],this.nodes=n,this.uploaded=!1,this.aabb=new Au([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),this.matrix=[];}_applyTransformations(t,e){if(O.mat4.multiply(t.matrix,e,t.matrix),t.meshes)for(const e of t.meshes){const r=Au.applyTransformFast(e.aabb,t.matrix);this.aabb.encapsulate(r);}if(t.children)for(const e of t.children)this._applyTransformations(e,t.matrix);}computeBoundsAndApplyParent(){const t=O.mat4.identity([]);for(const e of this.nodes)this._applyTransformations(e,t);}computeModelMatrix(t,e,r,n,i,s,a=!1){By(this.matrix,this,t.transform,this.position,e,r,n,i,s,a);}upload(t){if(!this.uploaded){for(const e of this.nodes)Dy(e,t);for(const t of this.nodes)Ry(t);this.uploaded=!0;}}destroy(){for(const t of this.nodes)Ly(t);}},t.aQ=ot,t.aR=Kd,t.aS=gl,t.aT=xl,t.aU=Ma,t.aV=ja,t.aW=st,t.aX=no,t.aY=zm,t.aZ=function(){Ds.isLoading()||Ds.isLoaded()||"deferred"!==Vs()||Cs();},t.a_=Qs,t.aa=Rs,t.ab=ts,t.ac=Il,t.ad=O,t.ae=tt,t.af=$s,t.ag=$u,t.ah=Ee,t.ai=Kr,t.aj=ze,t.ak=H,t.al=Se,t.am=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return function([t,e]){const r=mt([1,t,e]);return {x:r.x,y:r.y,z:r.z}}(t.expression.evaluate(e))}interpolate(t,e,r){return {x:Ee(t.x,e.x,r),y:Ee(t.y,e.y,r),z:Ee(t.z,e.z,r)}}},t.an=function(t,e,r=0,n=!0){const i=new q(r,r),s=t.sub(i),a=e.add(i),o=[s,new q(a.x,s.y),a,new q(s.x,a.y)];return n&&o.push(s.clone()),o},t.ao=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=et(n-1,-1,t.length-1),s=et(n+1,-1,t.length-1),a=t[n],o=t[s],l=t[i].sub(a).unit(),u=o.sub(a).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(a.add(h));}return r},t.ap=Jd,t.aq=Xl,t.ar=function(t,e,r=0){return O.vec3.fromValues(((e.x-r)*t.scale-t.x)*Kr,(e.y*t.scale-t.y)*Kr,vl(e.z,e.y))},t.as=gu,t.at=Wp,t.au=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {min:new q(e,r),max:new q(n,i)}},t.av=dl,t.aw=Hl,t.ax=Pl,t.ay=Q,t.az=Ko,t.b=function(t){return At.API_FONTS_REGEX.test(t)},t.b$=oy,t.b0=Ov,t.b1=gt,t.b2=Yp,t.b3=_h,t.b4=Vl,t.b5=_a,t.b6=Ka,t.b7=mu,t.b8=xo,t.b9=vc,t.bA=Jh,t.bB=Nd,t.bC=Cd,t.bD=Kf,t.bE=$v,t.bF=et,t.bG=vt,t.bH=yl,t.bI=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.bJ=Co,t.bK=zo,t.bL=ko,t.bM=Eo,t.bN=Po,t.bO=ul,t.bP=vm,t.bQ=lu,t.bR=Mu,t.bS=ay,t.bT=ou,t.bU=Vu,t.bV=function(t,e,r,n,i,s,a,o,l){if("globe"===l.name)return Vu(t,e,new ou(r,n,i),!1);const u=Kd({z:r,x:n,y:i},l);return new Au([(s+u.x/u.scale)*e,e*(u.y/u.scale),a],[(s+u.x2/u.scale)*e,e*(u.y2/u.scale),o])},t.bW=function(t,e,r){let n=0;for(let r=0;r<2;++r){const i=0;t[r]>i&&(n+=(t[r]-i)*(t[r]-i)),e[r]<i&&(n+=(i-e[r])*(i-e[r]));}return n},t.bX=bl,t.bY=Qo,t.bZ=function(t){const e=O.mat4.identity(new Float64Array(16));O.mat4.multiply(e,t.pixelMatrix,t.globeMatrix);const r=[0,nl,0],n=[0,il,0];return O.vec3.transformMat4(r,r,e),O.vec3.transformMat4(n,n,e),[r[0]>0&&r[0]<=t.width&&r[1]>0&&r[1]<=t.height&&!Yu(t,new ul(t.center.lat,90)),n[0]>0&&n[0]<=t.width&&n[1]>0&&n[1]<=t.height&&!Yu(t,new ul(t.center.lat,-90))]},t.b_=function(t,e){const{scale:r}=t.tileTransform,n=r*Kr/(t.tileSize*Math.pow(2,e.zoom-t.tileID.overscaledZ+t.tileID.canonical.z));return O.mat2.scale(new Float32Array(4),e.inverseAdjustmentMatrix,[n,n])},t.ba=Nm,t.bb=function(t,e){const r=$u(e.zoom);if(0===r)return ku(t);const n=Cu(t),i=Du(n),s=dl(n.getWest())*e.worldSize,a=dl(n.getEast())*e.worldSize,o=ml(n.getNorth())*e.worldSize,l=ml(n.getSouth())*e.worldSize,u=[s,o,0],c=[a,o,0],h=[s,l,0],p=[a,l,0],f=O.mat4.invert([],e.globeMatrix);return O.vec3.transformMat4(u,u,f),O.vec3.transformMat4(c,c,f),O.vec3.transformMat4(h,h,f),O.vec3.transformMat4(p,p,f),i[0]=Tu(i[0],h,r),i[1]=Tu(i[1],p,r),i[2]=Tu(i[2],c,r),i[3]=Tu(i[3],u,r),Au.fromPoints(i)},t.bc=Ou,t.bd=Ru,t.be=Tu,t.bf=wa,t.bg=du,t.bh=ev,t.bi=Cf,t.bj=ne,t.bk=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.bl=rt,t.bm=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.bn=$,t.bo=function(t,e){const{x:r,y:n}=t.point,i=qu(r,n,t.worldSize/t._pixelsPerMercatorPixel,0,0);return O.mat4.multiply(i,i,Nu(ku(e)))},t.bp=wf,t.bq=Nf,t.br=_f,t.bs=function(t,e,r,n,i){const s=5*e+2;t.float32[s+0]=r,t.float32[s+1]=n,t.float32[s+2]=i;},t.bt=Im,t.bu=ud,t.bv=Fl,t.bw=gf,t.bx=jh,t.by=wy,t.bz=Kh,t.c=St,t.c$=tf,t.c0=sy,t.c1=function(t){const e=sy(t,!0);return O.mat2.invert([],[e[0],e[1],e[4],e[5]])},t.c2=xu,t.c3=function(t){const{x:e,y:r}=t.point,{lng:n,lat:i}=t._center;return qu(e,r,t.worldSize,n,i)},t.c4=X,t.c5=cu,t.c6=Jo,t.c7=function(t){const e=Math.round((t+45+360)%360/90)%4;return Z[e]},t.c8=45,t.c9=ke,t.cA=Bo,t.cB=class extends So{constructor(t){super(t),this.current=Do;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<9;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix3fv(this.location,!1,r);break}}},t.cC=W,t.cD=function(t,e,r){const n=$u(r.zoom),i=t.style.map._antialias,s=t.terrain&&t.terrain.exaggeration()>0;return 0===n&&!i&&!s},t.cE=function(t){const e=t.pixelsPerMeter,r=e/yl(1,t.center.lat),n=O.mat4.identity(new Float64Array(16));return O.mat4.translate(n,n,[t.point.x,t.point.y,0]),O.mat4.scale(n,n,[r,r,e]),Float32Array.from(n)},t.cF=Cu,t.cG=function(t){const e=bl-5;t=Q(t,-e,e)/e*90;const r=Math.pow(Math.abs(Math.sin(H(t))),3);return Math.round(r*(rl.length-1))},t.cH=function(t,e,r,n){const i=e.getNorth(),s=e.getSouth(),a=e.getWest(),o=e.getEast(),l=1<<t.z,u=o-a,c=i-s,h=u/el,p=-c/rl[r],f=[0,h,0,p,0,0,i,a,0];if(t.z>0){const t=180/n;O.mat3.multiply(f,f,[t/u+1,0,0,0,t/c+1,0,-.5*t/h,.5*t/p,1]);}return f[2]=l,f[5]=t.x,f[8]=t.y,f},t.cI=ku,t.cJ=function(t,e,r){const n=O.mat4.identity(new Float64Array(16)),i=(e/(1<<t)-.5)*Math.PI*2;return O.mat4.rotateY(n,r.globeMatrix,i),Float32Array.from(n)},t.cK=class{isDataAvailableAtPoint(t){const e=this._source();if(this.isUsingMockSource()||!e||t.y<0||t.y>1)return !1;const r=e.getSource().maxzoom,n=1<<r,i=Math.floor(t.x),s=Math.floor((t.x-i)*n),a=Math.floor(t.y*n),o=this.findDEMTileFor(new uu(r,i,r,s,a));return !(!o||!o.dem)}getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){if(this.isUsingMockSource())return null;null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,s=1<<i,a=Math.floor(t.x),o=t.x-a,l=new uu(i,a,i,Math.floor(o*s),Math.floor(t.y*s)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(o*h-u.tileID.canonical.x)*c.dim,f=(t.y*h-u.tileID.canonical.y)*c.dim,d=Math.floor(p),m=Math.floor(f);return (r?this.exaggeration():1)*Ee(Ee(c.get(d,m),c.get(d,m+1),f-m),Ee(c.get(d+1,m),c.get(d+1,m+1),f-m),p-d)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPointOrZero(new Il(t.wrap+(t.canonical.x+e/Kr)/n,(t.canonical.y+r/Kr)/n))}getAtTileOffsetFunc(t,e,r,n){return i=>{const s=this.getAtTileOffset(t,i.x,i.y),a=n.upVector(t.canonical,i.x,i.y),o=n.upVectorScale(t.canonical,e,r).metersToTile;return O.vec3.scale(a,a,s*o),a}}getForTilePoints(t,e,r,n){if(this.isUsingMockSource())return !1;const i=Fy.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){if(this.isUsingMockSource())return null;const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let s=t.canonical.x/i-n.canonical.x,a=t.canonical.y/i-n.canonical.y,o=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[o];e++){s*=2,a*=2;const t=2*Math.floor(a)+Math.floor(s);o=r.childOffsets[o]+t,s%=1,a%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}getMinMaxForVisibleTiles(){const t=this.visibleDemTiles;if(0===t.length)return null;let e=!1,r=Number.MAX_VALUE,n=Number.MIN_VALUE;for(const i of t){const t=this.getMinMaxForTile(i.tileID);t&&(r=Math.min(r,t.min),n=Math.max(n,t.max),e=!0);}return e?{min:r,max:n}:null}},t.cL=fc,t.cM=Iu,t.cN=function(t,e){return [Math.pow(t[0],2.2)*e,Math.pow(t[1],2.2)*e,Math.pow(t[2],2.2)*e]},t.cO=ju,t.cP=Mt,t.cQ=wt,t.cR=256,t.cS=function(t,e){const r=[0,0,0],n=Ou(ku(e.canonical));return O.vec3.transformMat4(r,r,n),O.vec3.transformMat4(r,r,t),r},t.cT=t=>({u_camera_to_center_distance:new Eo(t),u_extrude_scale:new Lo(t),u_device_pixel_ratio:new Eo(t),u_matrix:new Co(t),u_inv_rot_matrix:new Co(t),u_merc_center:new zo(t),u_tile_id:new ko(t),u_zoom_transition:new Eo(t),u_up_dir:new ko(t),u_emissive_strength:new Eo(t)}),t.cU=t=>({u_matrix:new Co(t),u_pixels_to_tile_units:new Lo(t),u_device_pixel_ratio:new Eo(t),u_width_scale:new Eo(t),u_floor_width_scale:new Eo(t),u_units_to_pixels:new zo(t),u_dash_image:new Po(t),u_gradient_image:new Po(t),u_image_height:new Eo(t),u_texsize:new zo(t),u_tile_units_to_pixels:new Eo(t),u_alpha_discard_threshold:new Eo(t),u_trim_offset:new zo(t),u_trim_fade_range:new zo(t),u_trim_color:new To(t),u_emissive_strength:new Eo(t),u_zbias_factor:new Eo(t),u_tile_to_meter:new Eo(t)}),t.cV=t=>({u_matrix:new Co(t),u_texsize:new zo(t),u_pixels_to_tile_units:new Lo(t),u_device_pixel_ratio:new Eo(t),u_width_scale:new Eo(t),u_floor_width_scale:new Eo(t),u_image:new Po(t),u_units_to_pixels:new zo(t),u_tile_units_to_pixels:new Eo(t),u_alpha_discard_threshold:new Eo(t),u_trim_offset:new zo(t),u_trim_fade_range:new zo(t),u_trim_color:new To(t),u_emissive_strength:new Eo(t),u_zbias_factor:new Eo(t),u_tile_to_meter:new Eo(t)}),t.cW=Na,t.cX=yf,t.cY=Mf,t.cZ=Ku,t.c_=(t,e,r,n,i,s)=>{const a=t.transform,o="globe"===a.projection.name;let l;if("map"===s.paint.get("circle-pitch-alignment"))if(o){const t=ju(a.zoom,e.canonical)*a._pixelsPerMercatorPixel;l=Float32Array.from([t,0,0,t]);}else l=a.calculatePixelsToTileUnitsMatrix(r);else l=new Float32Array([a.pixelsToGLUnits[0],0,0,a.pixelsToGLUnits[1]]);const u={u_camera_to_center_distance:t.transform.getCameraToCenterDistance(a.projection),u_matrix:t.translatePosMatrix(e.projMatrix,r,s.paint.get("circle-translate"),s.paint.get("circle-translate-anchor")),u_device_pixel_ratio:Ct.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:Wu,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0],u_emissive_strength:s.paint.get("circle-emissive-strength")};if(o){u.u_inv_rot_matrix=n,u.u_merc_center=i,u.u_tile_id=[e.canonical.x,e.canonical.y,1<<e.canonical.z],u.u_zoom_transition=$u(a.zoom);const t=i[0]*Kr,r=i[1]*Kr;u.u_up_dir=a.projection.upVector(new ou(0,0,0),t,r);}return u},t.ca=fl,t.cb=To,t.cc=function(t,e,r){const n=Math.sqrt(t*t+e*e+r*r),i=n>0?Math.acos(r/n)*Y:0;let s=0!==t||0!==e?Math.atan2(-e,-t)*Y+90:0;return s<0&&(s+=360),[n,s,i]},t.cd=Al,t.ce=Au,t.cf=mt,t.cg=function(t){return [Math.pow(t[0],1/2.2),Math.pow(t[1],1/2.2),Math.pow(t[2],1/2.2)]},t.ch=function(t,e){return t.readFields(dg,{icons:[]},e)},t.ci=function(t){return t({pluginStatus:Es,pluginURL:zs}),Bs.on("pluginStateChange",t),t},t.cj=ag,t.ck=bd,t.cl=vd,t.cm=ee,t.cn=ks,t.co=Rt,t.cp=ye,t.cq=ct,t.cr=function(t){const e=t.indexOf(ha);return e>=0?t.slice(0,e):t},t.cs=function(t){return t.indexOf(ha)>=0},t.ct=function(t){const e=t.indexOf(ha);return e>=0?t.slice(e+1):""},t.cu=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.cv=function(t,e,r,n){return "custom"===t.type?new ny(t,e):new Wy[t.type](t,e,r,n)},t.cw=ut,t.cx=class extends Ov{constructor(t,e){super(t._vectorTileFeature,t._z,t._x,t._y,t.id),t.state&&(this.state=Object.assign({},t.state)),this.target=e.target,this.namespace=e.namespace,e.properties&&(this.properties=e.properties),this.target&&("featuresetId"in this.target&&!this.target.importId||"layerId"in this.target)&&(this.source=t.source,this.sourceLayer=t.sourceLayer,this.layer=t.layer);}toJSON(){const t=super.toJSON();return t.target=this.target,t.namespace=this.namespace,t}},t.cy=Bs,t.cz=re,t.d=function(t){return At.API_TILEJSON_REGEX.test(t)},t.d$=Lv,t.d0=er,t.d1=(t,e,r,n,i,s,a,o)=>{const l=t.transform,u=l.pitch<15?Kp(.07,.7,Q((14-l.zoom)/5,0,1)):.07,c="none"===r.paint.get("line-trim-color-use-theme").constantOr("default");return {u_matrix:Qp(t,e,r,n),u_texsize:e.imageAtlasTexture?e.imageAtlasTexture.size:[0,0],u_pixels_to_tile_units:l.calculatePixelsToTileUnitsMatrix(e),u_device_pixel_ratio:i,u_width_scale:s,u_floor_width_scale:a,u_image:0,u_tile_units_to_pixels:Jp(e,l),u_units_to_pixels:[1/l.pixelsToGLUnits[0],1/l.pixelsToGLUnits[1]],u_alpha_discard_threshold:0,u_trim_offset:o,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toRenderColor(c?null:r.lut).toArray01(),u_emissive_strength:r.paint.get("line-emissive-strength"),u_zbias_factor:u,u_tile_to_meter:Al(e.tileID.canonical,0)}},t.d2=(t,e,r,n,i,s,a,o,l)=>{const u=t.transform,c=u.calculatePixelsToTileUnitsMatrix(e),h="none"===r.paint.get("line-trim-color-use-theme").constantOr("default"),p=u.pitch<15?Kp(.07,.7,Q((14-u.zoom)/5,0,1)):.07;return {u_matrix:Qp(t,e,r,n),u_pixels_to_tile_units:c,u_device_pixel_ratio:s,u_width_scale:a,u_floor_width_scale:o,u_units_to_pixels:[1/u.pixelsToGLUnits[0],1/u.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:i,u_texsize:ef(r)&&e.lineAtlasTexture?e.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:Jp(e,t.transform),u_alpha_discard_threshold:0,u_trim_offset:l,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toRenderColor(h?null:r.lut).toArray01(),u_emissive_strength:r.paint.get("line-emissive-strength"),u_zbias_factor:p,u_tile_to_meter:Al(e.tileID.canonical,0)}},t.d3=at,t.d4=dc,t.d5=vl,t.d6=Pp,t.d7=hu,t.d8=vp,t.d9=op,t.dA=Uh,t.dB=K,t.dC=function(){return !!document.fullscreenElement||!!document.webkitFullscreenElement},t.dD=J,t.dE=Ml,t.dF=al,t.dG=function([t,e,r]){const n=Math.hypot(t,e,r),i=Math.atan2(t,r),s=.5*Math.PI-Math.acos(-e/n);return new ul(X(i),X(s))},t.dH=uy,t.dI=function(t){const e=t.navigator?t.navigator.userAgent:null;return !!function(t){if(null==xt){const e=t.navigator?t.navigator.userAgent:null;xt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return xt}(t)&&e&&(e.match("Version/15.4")||e.match("Version/15.5")||e.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/))},t.dJ=function(t,e){Ft=t,Ot=e;},t.dK=Yu,t.dL=Gu,t.dM=function(t){const e=[0,0,0],r=O.mat4.identity(new Float64Array(16));return O.mat4.multiply(r,t.pixelMatrix,t.globeMatrix),O.vec3.transformMat4(e,e,r),new q(e[0],e[1])},t.dN=function(t,e,r=!1){if(Es===As||Es===Is||Es===Ss)throw new Error("setRTLTextPlugin cannot be called multiple times.");zs=Ct.resolveURL(t),Es=As,Ps=e,Ts(),r||Cs();},t.dO=Vs,t.dP=function(){ag().acquire(eg);},t.dQ=function(){const t=ig;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(eg),ig=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.dR=rg,t.dS=function(t){const e=qt();if(!e)return;const r=e.delete(Lt);t&&r.catch(t).then((()=>t()));},t.dT=tg,t.dU=cv,t.dV=function(t){sv=Ct.resolveURL(t),uv||(uv=new ng(ag(),new _e)),uv.broadcast("setDracoUrl",sv);},t.dW=hv,t.dX=function(t){ov=Ct.resolveURL(t),uv||(uv=new ng(ag(),new _e)),uv.broadcast("setMeshoptUrl",ov);},t.dY=us,t.dZ=hc,t.d_=xd,t.da=450,t.db=7,t.dc=Zm,t.dd=va,t.de=to,t.df=256,t.dg=Nu,t.dh=za,t.di=Ga,t.dj=Ya,t.dk=function(t,e,r,n,i){return Q((t-e)/(r-e)*(i-n)+n,n,i)},t.dl=Ei,t.dm=wl,t.dn=class{constructor(t,e,r,n){this.context=t,this.format=n,this.size=r,this.texture=t.gl.createTexture();const[i,s,a]=this.size,{gl:o}=t;o.bindTexture(o.TEXTURE_3D,this.texture),t.pixelStoreUnpackFlipY.set(!1),t.pixelStoreUnpack.set(1),t.pixelStoreUnpackPremultiplyAlpha.set(!1),o.texImage3D(o.TEXTURE_3D,0,this.format,i,s,a,0,Um(this.format),jm(this.format),e.data);}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_3D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}},t.dp=fy,t.dq=[1,1,1],t.dr=Fy,t.ds=Ty,t.dt=La,t.du=Za,t.dv=ol,t.dw=Xa,t.dx=Ha,t.dy=class{constructor(){this._updateTime=0,this._sourceIds=[],this._activeRegions=[],this._prevRegions=[],this._globalClipBounds={min:new q(1/0,1/0),max:new q(-1/0,-1/0)};}clear(){this._activeRegions.length>0&&++this._updateTime,this._activeRegions=[],this._prevRegions=[];}get updateTime(){return this._updateTime}getReplacementRegionsForTile(t,e=!1){const r=Hh(new q(0,0),new q(Kr,Kr),t),n=[];if(e&&!Gh(r,this._globalClipBounds))return n;for(const e of this._activeRegions){if(e.hiddenByOverlap)continue;if(!Gh(r,e))continue;const i=Xh(e.min,e.max,t);n.push({min:i.min,max:i.max,sourceId:this._sourceIds[e.priority],footprint:e.footprint,footprintTileId:e.tileId,order:e.order,clipMask:e.clipMask,clipScope:e.clipScope});}return n}setSources(t){this._setSources(t.map((t=>({getSourceId:()=>t.cache.id,getFootprints:()=>{const e=[];for(const r of t.cache.getVisibleCoordinates()){const n=t.cache.getTile(r).buckets[t.layer];n&&n.updateFootprints(r.toUnwrapped(),e);}return e},getOrder:()=>t.order,getClipMask:()=>t.clipMask,getClipScope:()=>t.clipScope}))));}_addSource(t){const e=t.getFootprints();if(0===e.length)return;const r=t.getOrder(),n=t.getClipMask(),i=t.getClipScope();for(const t of e){if(!t.footprint)continue;const e=Hh(t.footprint.min,t.footprint.max,t.id);this._activeRegions.push({min:e.min,max:e.max,hiddenByOverlap:!1,priority:this._sourceIds.length,tileId:t.id,footprint:t.footprint,order:r,clipMask:n,clipScope:i});}this._sourceIds.push(t.getSourceId());}_computeReplacement(){this._activeRegions.sort(((t,e)=>t.priority-e.priority||qh(t.min,e.min)||qh(t.max,e.max)||t.order-e.order||t.clipMask-e.clipMask||function(t,e){const r=(t,e)=>t+e;return t.length-e.length||t.reduce(r,"").localeCompare(e.reduce(r,""))}(t.clipScope,e.clipScope)));let t=this._activeRegions.length!==this._prevRegions.length;if(!t){let e=0;for(;!t&&e!==this._activeRegions.length;){const r=this._activeRegions[e],n=this._prevRegions[e];t=r.priority!==n.priority||!$h(r,n)||r.order!==n.order||r.clipMask!==n.clipMask||!$(r.clipScope,n.clipScope),++e;}}if(t){++this._updateTime;for(const t of this._activeRegions)t.order!==Uh&&(this._globalClipBounds.min.x=Math.min(this._globalClipBounds.min.x,t.min.x),this._globalClipBounds.min.y=Math.min(this._globalClipBounds.min.y,t.min.y),this._globalClipBounds.max.x=Math.max(this._globalClipBounds.max.x,t.max.x),this._globalClipBounds.max.y=Math.max(this._globalClipBounds.max.y,t.max.y));const t=t=>{const e=this._activeRegions;if(t>=e.length)return t;const r=e[t].priority;for(;t<e.length&&e[t].priority===r;)++t;return t};if(this._sourceIds.length>1){let e=0,r=t(e);for(;e!==r;){let n=e;const i=e;for(;n!==r;){const t=this._activeRegions[n];t.hiddenByOverlap=!1;for(let e=0;e<i;e++){const r=this._activeRegions[e];if(!r.hiddenByOverlap&&t.order===Uh&&Gh(t,r)&&(t.hiddenByOverlap=Wh(t.footprint,t.tileId,r.footprint,r.tileId),t.hiddenByOverlap))break}++n;}e=r,r=t(e);}}}}_setSources(t){[this._prevRegions,this._activeRegions]=[this._activeRegions,[]],this._sourceIds=[];for(let e=t.length-1;e>=0;e--)this._addSource(t[e]);this._computeReplacement();}},t.dz=class{constructor(t){this._createGrid(t),this._createPoles(t);}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const t of this._poleSegments)t.destroy();for(const t of this._gridSegments)t.withSkirts.destroy(),t.withoutSkirts.destroy();}_fillGridMeshWithLods(t,e){const r=new _a,n=new ja,i=[],s=t+1+2,a=e[0]+1,o=e[0]+1+(1+e.length),l=(t,e,r)=>{let n=t===s-1?t-2:0===t?t:t-1;return n+=r?24575:0,[n,e]};for(let t=0;t<s;++t)r.emplaceBack(...l(t,0,!0));for(let t=0;t<a;++t)for(let e=0;e<s;++e)r.emplaceBack(...l(e,t,(0===e||e===s-1)&&!0));for(let t=0;t<e.length;++t){const n=e[t];for(let t=0;t<s;++t)r.emplaceBack(...l(t,n,!0));}for(let t=0;t<e.length;++t){const a=n.length,l=e[t]+1+2,u=new ja;for(let r=0;r<l-1;r++){const i=r===l-2,a=i?s*(o-e.length+t-r):s;for(let t=0;t<s-1;t++){const e=r*s+t;0===r||i||0===t||t===s-2?(u.emplaceBack(e+1,e,e+a),u.emplaceBack(e+a,e+a+1,e+1)):(n.emplaceBack(e+1,e,e+a),n.emplaceBack(e+a,e+a+1,e+1));}}const c=xo.simpleSegment(0,a,r.length,n.length-a);for(let t=0;t<u.uint16.length;t+=3)n.emplaceBack(u.uint16[t],u.uint16[t+1],u.uint16[t+2]);const h=xo.simpleSegment(0,a,r.length,n.length-a);i.push({withoutSkirts:c,withSkirts:h});}return {vertices:r,indices:n,segments:i}}_createGrid(t){const e=this._fillGridMeshWithLods(el,rl);this._gridSegments=e.segments,this._gridBuffer=t.createVertexBuffer(e.vertices,mu.members),this._gridIndexBuffer=t.createIndexBuffer(e.indices,!0);}_createPoles(t){const e=new ja;for(let t=0;t<=el;t++)e.emplaceBack(0,t+1,t+2);this._poleIndexBuffer=t.createIndexBuffer(e,!0);const r=new Ga,n=new Ga,i=new Ga,s=new Ga;this._poleSegments=[];for(let t=0,e=0;t<Jo;t++){const a=360/(1<<t);r.emplaceBack(0,-Ko,0,.5,0),n.emplaceBack(0,-Ko,0,.5,1),i.emplaceBack(0,-Ko,0,.5,.5),s.emplaceBack(0,-Ko,0,.5,.5);for(let t=0;t<=el;t++){let e=t/el,o=0;const l=Ee(0,a,e),[u,c,h]=sl(Xu,Zu,l,Ko);r.emplaceBack(u,c,h,e,o),n.emplaceBack(u,c,h,e,1-o);const p=H(l);e=.5+.5*Math.sin(p),o=.5+.5*Math.cos(p),i.emplaceBack(u,c,h,e,o),s.emplaceBack(u,c,h,e,1-o);}this._poleSegments.push(xo.simpleSegment(e,0,66,64)),e+=66;}this._poleNorthVertexBuffer=t.createVertexBuffer(r,fu,!1),this._poleSouthVertexBuffer=t.createVertexBuffer(n,fu,!1),this._texturedPoleNorthVertexBuffer=t.createVertexBuffer(i,fu,!1),this._texturedPoleSouthVertexBuffer=t.createVertexBuffer(s,fu,!1);}getGridBuffers(t,e){return [this._gridBuffer,this._gridIndexBuffer,e?this._gridSegments[t].withSkirts:this._gridSegments[t].withoutSkirts]}getPoleBuffers(t,e){return [e?this._texturedPoleNorthVertexBuffer:this._poleNorthVertexBuffer,e?this._texturedPoleSouthVertexBuffer:this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[t]]}},t.e=At,t.e0=Nv,t.e1=jp,t.e2=oh,t.e3="hd_road_elevation",t.e4=class{static parseFrom(t,e){const r=fh.parse(t);if(!r)return [];let{vertices:n,features:i}=r;const s=1/Al(e);i.sort(((t,e)=>t.id-e.id)),n.sort(((t,e)=>t.id-e.id||t.idx-e.idx)),n=n.filter(((t,e,r)=>e===r.findIndex((e=>e.id===t.id&&e.idx===t.idx))));const a=new Array;let o=0;const l=n.length;for(const t of i){if(t.constantHeight){a.push(new dh(t.id,t.bounds,t.constantHeight));continue}for(;o!==l&&n[o].id<t.id;)o++;if(o===l||n[o].id!==t.id)continue;const e=new Array,r=new Array,i=o;for(;o!==l&&n[o].id===t.id;){const t=n[o];if(e.push({position:t.position,height:t.height,extent:t.extent}),o!==i&&n[o-1].idx===t.idx-1){const t=o-i;r.push({a:t-1,b:t});}o++;}a.push(new dh(t.id,t.bounds,void 0,e,r,s));}return a}},t.e5=lt,t.e6=gh,t.e7=fd,t.e8=hd,t.e9=function(t,e,r,n,i,s,a,o=1,l){t.createArrays(),t.tilePixelRatio=Kr/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const u=t.layers[0].layout,c=t.layers[0]._unevaluatedLayout._values,h={};h.scaleFactor=o,h.textSizeScaleRange=u.get("text-size-scale-range"),h.iconSizeScaleRange=u.get("icon-size-scale-range");const[p,f]=h.textSizeScaleRange,[d,m]=h.iconSizeScaleRange;h.textScaleFactor=Q(h.scaleFactor,p,f),h.iconScaleFactor=Q(h.scaleFactor,d,m);const y=c["text-size"],g=c["icon-size"];if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;h.compositeTextSizes=[y.possiblyEvaluate(new Rs(e),s),y.possiblyEvaluate(new Rs(r),s)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;h.compositeIconSizes=[g.possiblyEvaluate(new Rs(e),s),g.possiblyEvaluate(new Rs(r),s)];}h.layoutTextSize=y.possiblyEvaluate(new Rs(a+1),s),h.layoutIconSize=g.possiblyEvaluate(new Rs(a+1),s),h.textMaxSize=y.possiblyEvaluate(new Rs(18),s);const x=u.get("symbol-placement"),v="map"===u.get("text-rotation-alignment")&&"point"!==x,b=u.get("text-size");let _=!1;const w=[];for(const a of t.features){const o=u.get("text-font").evaluate(a,{},s).join(","),p=b.evaluate(a,{},s)*h.textScaleFactor,f=h.layoutTextSize.evaluate(a,{},s)*h.textScaleFactor,d=h.layoutIconSize.evaluate(a,{},s)*h.iconScaleFactor,m={horizontal:{},vertical:void 0},y=a.text;let g,M=[0,0];if(y){const n=y.toString(),c=u.get("text-letter-spacing").evaluate(a,{},s)*gf,h=u.get("text-line-height").evaluate(a,{},s)*gf,d=ys(n)?c:0,g=u.get("text-anchor").evaluate(a,{},s),b=u.get("text-variable-anchor");if(!b){const t=u.get("text-radial-offset").evaluate(a,{},s);M=t?Cd(g,[t*gf,Bd]):u.get("text-offset").evaluate(a,{},s).map((t=>t*gf));}let _=v?"center":u.get("text-justify").evaluate(a,{},s);const w="point"===x,A=w?u.get("text-max-width").evaluate(a,{},s)*gf:1/0,I=s=>{t.allowVerticalPlacement&&ms(n)&&(m.vertical=qf(y,e,r,i,o,A,h,g,s,d,M,Nf.vertical,!0,f,p,l));};if(!v&&b){const t="auto"===_?b.map((t=>Nd(t))):[_];let n=!1;for(let s=0;s<t.length;s++){const a=t[s];if(!m.horizontal[a])if(n)m.horizontal[a]=m.horizontal[0];else {const t=qf(y,e,r,i,o,A,h,"center",a,d,M,Nf.horizontal,!1,f,p,l);t&&(m.horizontal[a]=t,n=1===t.positionedLines.length);}}I("left");}else {if("auto"===_&&(_=Nd(g)),w||u.get("text-writing-mode").indexOf("horizontal")>=0||!ms(n)){const t=qf(y,e,r,i,o,A,h,g,_,d,M,Nf.horizontal,!1,f,p,l);t&&(m.horizontal[_]=t);}I(w?"left":_);}}let A,I,S,P,E,z=!1;if(a.icon&&a.icon.hasPrimary()){const e=Rd(a.icon,t.iconSizeData,c["icon-size"],s,t.zoom,a,l,h.iconScaleFactor);A=e.iconPrimary,I=e.iconSecondary;const r=A.toString(),o=n.get(r);o&&(S=u.get("icon-offset").evaluate(a,{},s),P=u.get("icon-anchor").evaluate(a,{},s),E=u.get("icon-text-fit").evaluate(a,{},s),g=Qf(i.get(r),I?i.get(I.toString()):void 0,S,P),z=o.sdf,void 0===t.sdfIcons?t.sdfIcons=o.sdf:t.sdfIcons!==o.sdf&&pt("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(o.pixelRatio!==t.pixelRatio||0!==u.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}_=_||!(!a.icon||!a.icon.hasSecondary());const k=Yd(m.horizontal)||m.vertical;t.iconsInText||(t.iconsInText=!!k&&k.iconsInText);const T=f*h.textScaleFactor/gf,{defaultShapedIcon:B,verticallyShapedIcon:V}=Ud(t,g,u,a,s,m,T,S,E);g=B,w.push({feature:a,shapedTextOrientations:m,shapedText:k,shapedIcon:g,iconPrimary:A,iconSecondary:I,iconOffset:S,iconAnchor:P,verticallyShapedIcon:V,layoutTextSize:f,layoutIconSize:d,textOffset:M,isSDFIcon:z,iconTextFit:E});}return {featureData:w,sizes:h,hasAnySecondaryIcon:_,textAlongLine:v,symbolPlacement:x}},t.ea=dd,t.eb=function(t,e,r,n,i,s,a,o,l,u){const{featureData:c,hasAnySecondaryIcon:h,sizes:p,textAlongLine:f,symbolPlacement:d}=e;for(const e of c){const{shapedIcon:r,verticallyShapedIcon:s,feature:c,shapedTextOrientations:m,shapedText:y,layoutTextSize:g,textOffset:x,isSDFIcon:v,iconPrimary:b,iconSecondary:_,iconTextFit:w,iconOffset:M}=e;Ld(r,u.iconPositions,b,_),Ld(s,u.iconPositions,b,_),Fd(m,u.iconPositions),(y||r)&&jd(t,c,m,r,s,l,p,g,0,x,v,n,i,a,o,h,w,M,f,d);}r&&t.generateCollisionDebugBuffers(s,t.collisionBoxArray,p.textScaleFactor);},t.ec=ah,t.ed=hx,t.ee=j,t.ef=sh,t.eg=Vf,t.eh=e,t.ei=function(t){let e=0;if(new Uint32Array(t,0,1)[0]!==bv){const r=new Uint32Array(t,0,7),[,,n,i,s,a]=r;e=r.byteLength+i+s+a+s,(n!==t.byteLength||e>=t.byteLength)&&pt("Invalid b3dm header information.");}return Sv(t,e)},t.ej=function(t,e){const r=Cv(t);for(const t of r){for(const e of t.meshes)Dv(e);t.lights&&(t.lightMeshIndex=t.meshes.length,t.meshes.push(Rv(t.lights,e)));}return r},t.ek=Gy,t.el=Qy,t.em=Ds,t.en=function(t){$t(),null!=Ut&&Ut.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));},t.f=function(t){return 0===t.indexOf("mapbox:")},t.g=function(t,e){return re(nt(t,{method:"GET"}),e)},t.h=It,t.i=function(t){return At.API_STYLE_REGEX.test(t)&&!St(t)},t.j=function(t){return decodeURIComponent(atob(t).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join(""))},t.k=function(t){return btoa(encodeURIComponent(t).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e)))))},t.l=nt,t.m=Yt,t.n=function(t,e){return re(nt(t,{type:"json"}),e)},t.o=le,t.p=function(t,e){return re(nt(t,{method:"POST"}),e)},t.q=Ct,t.r=pc,t.s=function(t){try{const e=self[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}},t.t=Vt,t.u=function(){return function t(e){return e?(e^Math.random()*(16>>e/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()},t.v=function(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)},t.w=pt,t.x=function(){return sg||(sg=new rg),sg},t.y=Qg,t.z=xe;}));

define(["./shared"],(function(e){function t(e){const t=e?e.url.toString():void 0;return t?performance.getEntriesByName(t):[]}function s(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const i of e)t+=`${s(i)},`;return `${t}]`}let t="{";for(const i of Object.keys(e).sort())t+=`${i}:${s(e[i])},`;return `${t}}`}function i(t){let i="";for(const o of e.bm)("model"!==t.type||"minzoom"!==o&&"maxzoom"!==o)&&(i+=`/${s(t[o])}`);return i}class o{constructor(e){this.keyCache={},this._layers={},this._layerConfigs={},e&&this.replace(e);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,o,n){this._options=n;for(const s of t)this._layerConfigs[s.id]=s,(this._layers[s.id]=e.cv(s,this.scope,null,this._options)).compileFilter(n),this.keyCache[s.id]&&delete this.keyCache[s.id];for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const r=function(e,t){const o={};for(let n=0;n<e.length;n++){const r=e[n];let a=t&&t[r.id];!a&&(a=i(r),"line"===r.type&&r.paint)&&function e(t){return "string"==typeof t&&"line-progress"===t||(Array.isArray(t)?t.some(e):!(!t||"object"!=typeof t)&&Object.values(t).some(e))}(r.paint["line-width"])&&(a+=`/${s(r.paint["line-width"])}`),t&&(t[r.id]=a);let l=o[a];l||(l=o[a]=[]),l.push(r);}const n=[];for(const e in o)n.push(o[e]);return n}(Object.values(this._layerConfigs),this.keyCache);for(const e of r){const t=e.map((e=>this._layers[e.id])),s=t[0];if("none"===s.visibility)continue;const i=s.source||"";let o=this.familiesBySource[i];o||(o=this.familiesBySource[i]={});const n=s.sourceLayer||"_geojsonTileLayer";let r=o[n];r||(r=o[n]=[]),r.push(t);}}}const n=1*e.d_;class r{constructor(t){const s={},i=[];for(const e in t){const o=t[e],r=s[e]={};for(const e in o.glyphs){const t=o.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const s=t.metrics.localGlyph?n:1,a={x:0,y:0,w:t.bitmap.width+2*s,h:t.bitmap.height+2*s};i.push(a),r[e]=a;}}const{w:o,h:r}=e.H(i),a=new e.dZ({width:o||1,height:r||1});for(const i in t){const o=t[i];for(const t in o.glyphs){const r=o.glyphs[+t];if(!r||0===r.bitmap.width||0===r.bitmap.height)continue;const l=s[i][t],c=r.metrics.localGlyph?n:1;e.dZ.copy(r.bitmap,a,{x:0,y:0},{x:l.x+c,y:l.y+c},r.bitmap);}}this.image=a,this.positions=s;}}e.dY(r,"GlyphAtlas");class a{constructor(t){this.tileID=new e.aH(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.lut=t.lut,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.scope=t.scope,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.request&&t.request.collectResourceTiming,this.promoteId=t.promoteId,this.isSymbolTile=t.isSymbolTile,this.tileTransform=e.aR(t.tileID.canonical,t.projection),this.projection=t.projection,this.worldview=t.worldview,this.localizableLayerIds=t.localizableLayerIds,this.brightness=t.brightness,this.extraShadowCaster=!!t.extraShadowCaster,this.tessellationStep=t.tessellationStep,this.scaleFactor=t.scaleFactor;}parse(t,s,i,o,n){this.status="parsing",this.data=t,this.collisionBoxArray=new e.aX;const a=new e.d$(Object.keys(t.layers).sort()),c=new e.e0(this.tileID,this.promoteId);c.bucketLayerIDs=[];const h={},u=new e.e1(256,256),d={featureIndex:c,iconDependencies:new Map,patternDependencies:new Map,glyphDependencies:{},lineAtlas:u,availableImages:i,brightness:this.brightness,scaleFactor:this.scaleFactor,elevationFeatures:void 0},p=s.familiesBySource[this.source];for(const s in p){const o=t.layers[s];if(!o)continue;let n=!1,r=!1,u=!1;for(const e of p[s])"symbol"===e[0].type?n=!0:r=!0,e[0].is3D()&&"model"!==e[0].type&&(u=!0);if(this.extraShadowCaster&&!u)continue;if(!0===this.isSymbolTile&&!n)continue;if(!1===this.isSymbolTile&&!r)continue;1===o.version&&e.w(`Vector tile source "${this.source}" layer "${s}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const f=a.encode(s),g=[];let m=!1;for(let t=0,i=0;t<o.length;t++){const n=o.feature(t),r=c.getId(n,s);if(this.localizableLayerIds&&this.localizableLayerIds.has(s)){const e=n.properties?n.properties.worldview:null;if(this.worldview&&"string"==typeof e)if("all"===e)n.properties.$localized=!0;else {if(!e.split(",").includes(this.worldview))continue;n.properties.$localized=!0,n.properties.worldview=this.worldview;}}!m&&n.properties&&n.properties.hasOwnProperty(e.e2)&&(m=!0),g.push({feature:n,id:r,index:i,sourceLayerIndex:f}),i++;}m&&!d.elevationFeatures&&t.layers.hasOwnProperty(e.e3)&&(d.elevationFeatures=e.e4.parseFrom(t.layers[e.e3],this.canonical));for(const t of p[s]){const s=t[0];(!this.extraShadowCaster||s.is3D()&&"model"!==s.type)&&(void 0!==this.isSymbolTile&&"symbol"===s.type!==this.isSymbolTile||s.minzoom&&this.zoom<Math.floor(s.minzoom)||s.maxzoom&&this.zoom>=s.maxzoom||"none"!==s.visibility&&(l(t,this.zoom,d.brightness,i),(h[s.id]=s.createBucket({index:c.bucketLayerIDs.length,layers:t,zoom:this.zoom,lut:this.lut,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:f,sourceID:this.source,projection:this.projection.spec,tessellationStep:this.tessellationStep})).populate(g,d,this.tileID.canonical,this.tileTransform),c.bucketLayerIDs.push(t.map((t=>e.C(t.id,t.scope))))));}}let f,g,m,y,x,w;u.trim();const b={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},v=()=>{if(f)return this.status="done",n(f);if(this.extraShadowCaster)this.status="done",n(null,{buckets:Object.values(h).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:d.brightness,glyphMap:null,iconMap:null,glyphPositions:null});else if(g&&m&&y){const t=new r(g),s=new Map;for(const[t,i]of m.entries()){const{imagePosition:o}=e.e7(t,i,e.e8);s.set(t,o);}const n={};for(const o in h){const r=h[o];r instanceof e.aY&&(l(r.layers,this.zoom,d.brightness,i),n[o]=e.e9(r,g,t.positions,m,s,this.tileID.canonical,this.tileZoom,this.scaleFactor,this.pixelRatio));}const a={iconsPending:!0,patternsPending:!0};this.rasterizeIfNeeded(o,m,x,(()=>{a.iconsPending=!1,I(n,t,a);})),this.rasterizeIfNeeded(o,y,w,(()=>{a.patternsPending=!1,I(n,t,a);}));}},I=(t,s,o,r)=>{if(o.iconsPending||o.patternsPending)return;const a=new e.ea(m,y,this.lut);for(const s in h){const o=h[s];if(s in t)e.eb(o,t[s],this.showCollisionBoxes,i,this.tileID.canonical,this.tileZoom,this.projection,this.brightness,m,a);else if(o.hasPattern&&(o instanceof e.b2||o instanceof e.b3||o instanceof e.d8)){l(o.layers,this.zoom,d.brightness,i);const e=Object.fromEntries(a.patternPositions);o.addFeatures(d,this.tileID.canonical,e,i,this.tileTransform,this.brightness);}}this.status="done",n(null,{buckets:Object.values(h).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:s.image,lineAtlas:u,imageAtlas:a,brightness:d.brightness});};if(!this.extraShadowCaster){const t=e.e5(d.glyphDependencies,(e=>Object.keys(e).map(Number)));Object.keys(t).length?o.send("getGlyphs",{uid:this.uid,stacks:t,scope:this.scope},((e,t)=>{f||(f=e,g=t,v());}),void 0,!1,b):g={};const s=Array.from(d.iconDependencies.keys()).map((t=>e.I.parse(t)));s.length?o.send("getImages",{images:s,source:this.source,scope:this.scope,tileID:this.tileID,type:"icons"},((e,t)=>{f||(f=e,m=new Map,x=this.updateImageMapAndGetImageTaskQueue(m,t,d.iconDependencies),v());}),void 0,!1,b):(m=new Map,x=new Map);const i=Array.from(d.patternDependencies.keys()).map((t=>e.I.parse(t)));i.length?o.send("getImages",{images:i,source:this.source,scope:this.scope,tileID:this.tileID,type:"patterns"},((e,t)=>{f||(f=e,y=new Map,w=this.updateImageMapAndGetImageTaskQueue(y,t,d.patternDependencies),v());}),void 0,!1,b):(y=new Map,w=new Map);}if(d.elevationFeatures&&d.elevationFeatures.length>0){const t=[];for(const s of Object.values(h))if(s instanceof e.b3){const e=s.getUnevaluatedPortalGraph();e&&t.push(e);}const s=e.e6.evaluate(t);for(const t of Object.values(h))t instanceof e.b3&&t.setEvaluatedPortalGraph(s);}v();}rasterizeIfNeeded(e,t,s,i){Array.from(t.values()).some((e=>e.usvg))?this.rasterize(e,t,s,i):i();}updateImageMapAndGetImageTaskQueue(e,t,s){const i=new Map;for(const o of t.keys()){const n=s.get(o)||[];for(const s of n){const o=s.toString(),n=t.get(s.id.toString());n.usvg?i.has(o)||(i.set(o,s),e.set(o,Object.assign({},n))):e.set(o,n);}}return i}rasterize(e,t,s,i){this.rasterizeTask=e.send("rasterizeImages",{scope:this.scope,tasks:s},((e,s)=>{if(!e)for(const[e,i]of s.entries()){const s=Object.assign(t.get(e),{data:i});t.set(e,s);}i();}));}cancelRasterize(){this.rasterizeTask&&this.rasterizeTask.cancel();}}function l(t,s,i,o){const n=new e.aa(s,{brightness:i});for(const e of t)e.recalculate(n,o);}class c extends e.E{constructor(t,s,i,o,n,r){super(),this.actor=t,this.layerIndex=s,this.availableImages=i,this.loadVectorData=n||e.aE,this.loading={},this.loaded={},this.deduped=new e.aD(t.scheduler),this.isSpriteLoaded=o,this.scheduler=t.scheduler,this.brightness=r;}loadTile(s,i){const o=s.uid,n=s&&s.request,r=n&&n.collectResourceTiming,l=this.loading[o]=new a(s);l.abort=this.loadVectorData(s,((a,c)=>{const h=!this.loading[o];if(delete this.loading[o],l.cancelRasterize(),h||a||!c)return l.status="done",h||(this.loaded[o]=l),i(a);const u=c.rawData,d={};c.expires&&(d.expires=c.expires),c.cacheControl&&(d.cacheControl=c.cacheControl),l.vectorTile=c.vectorTile||new e.ec.VectorTile(new e.bi(u));const p=()=>{l.parse(l.vectorTile,this.layerIndex,this.availableImages,this.actor,((s,o)=>{if(s||!o)return i(s);const a={};if(r){const e=t(n);e.length>0&&(a.resourceTiming=JSON.parse(JSON.stringify(e)));}i(null,e.l({rawTileData:u.slice(0)},o,d,a));}));};this.isSpriteLoaded?p():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(p,{type:"parseTile",isSymbolTile:s.isSymbolTile,zoom:s.tileZoom}):p();})),this.loaded=this.loaded||{},this.loaded[o]=l;}));}reloadTile(t,s){const i=this.loaded,o=t.uid;if(i&&i[o]){const n=i[o];n.scaleFactor=t.scaleFactor,n.showCollisionBoxes=t.showCollisionBoxes,n.projection=t.projection,n.brightness=t.brightness,n.tileTransform=e.aR(t.tileID.canonical,t.projection),n.extraShadowCaster=t.extraShadowCaster,n.lut=t.lut;const r=(e,t)=>{const i=n.reloadCallback;i&&(delete n.reloadCallback,n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,i)),s(e,t);};"parsing"===n.status?n.reloadCallback=r:"done"===n.status&&(n.vectorTile?n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,r):r());}else s(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class h{loadTile(t,s){const{uid:i,encoding:o,rawImageData:n,padding:r}=t,a=ImageBitmap&&n instanceof ImageBitmap?this.getImageData(n,r):n;s(null,new e.ed(i,a,o,r<1));}reloadTile(e,t){t(null,null);}abortTile(e,t){t();}removeTile(e,t){t();}getImageData(e,t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(e.width,e.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d",{willReadFrequently:!0})),this.offscreenCanvas.width=e.width,this.offscreenCanvas.height=e.height,this.offscreenCanvasContext.drawImage(e,0,0,e.width,e.height);const s=this.offscreenCanvasContext.getImageData(-t,-t,e.width+2*t,e.height+2*t);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),s}}e.bh.setPbf(e.bi);class u{constructor(t){this._mrt=new e.bh(t.partial?30:1/0),this._isHeaderLoaded=!1,this.uid=t.uid,this.tileID=t.tileID,this.source=t.source;}parse(t,s){const i=this._mrt;this.status="parsing",this._entireBuffer=t;try{i.parseHeader(t),this._isHeaderLoaded=!0;const o=[];for(const s in i.layers){const n=i.getLayer(s),r=n.getDataRange(n.getBandList()),a=i.createDecodingTask(r),l=t.slice(r.firstByte,r.lastByte+1),c=e.bh.performDecoding(l,a).then((e=>a.complete(null,e))).catch((e=>a.complete(e,null)));o.push(c);}Promise.allSettled(o).then((()=>s(null,i)));}catch(e){s(e);}}}class d{constructor(e){this.actor=e,this.loading={},this.loaded={};}loadTile(t,s){const i=t.uid,o=t.request,n=this.loading[i]=new u(t),{cancel:r}=e.bj(o,((e,t,o,r)=>{const a=!this.loading[i];if(delete this.loading[i],a||e||!t)return n.status="done",a||(this.loaded[i]=n),s(e);n.parse(t,((e,t)=>{if(e||!t)return s(e);s(null,t,o,r);})),this.loaded[i]=n;}));n.abort=r;}reloadTile(e,t){t(null,void 0);}abortTile(e,t){const s=e.uid,i=this.loading[s];i&&(i.abort&&i.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=e.uid;this.loaded[s]&&delete this.loaded[s],t();}decodeRasterArray({task:t,buffer:s},i){e.bh.performDecoding(s,t).then((e=>i(null,e))).catch((e=>i(e)));}}const p=e.ec.VectorTileFeature.prototype.toGeoJSON;class f{constructor(t){this._feature=t,this.extent=e.ai,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const s of this._feature.geometry)t.push([new e.P(s[0],s[1])]);return t}{const t=[];for(const s of this._feature.geometry){const i=[];for(const t of s)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,s){return p.call(this,e,t,s)}}class g{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.ai,this.length=t.length,this._features=t;}feature(e){return new f(this._features[e])}}const m=64/4096,y=128;class x{constructor(){this.features=new Map;}clear(){this.features.clear();}load(e=[],t){for(const s of e){const e=s.id;if(null==e)continue;let i=this.features.get(e);i&&this.updateCache(i,t),s.geometry?(i=b(s),this.updateCache(i,t),this.features.set(e,i)):this.features.delete(e),this.updateCache(i,t);}}updateCache(e,t){for(const{canonical:s,uid:i}of Object.values(t)){const{z:o,x:n,y:r}=s;w(e,Math.pow(2,o),n,r)&&delete t[i];}}getTile(e,t,s){const i=Math.pow(2,e),o=[];for(const e of this.features.values())w(e,i,t,s)&&o.push(M(e,i,t,s));return {features:o}}getFeatures(){return [...this.features.values()]}}function w({minX:e,minY:t,maxX:s,maxY:i},o,n,r){return e<(n+1+m)/o&&t<(r+1+m)/o&&s>(n-m)/o&&i>(r-m)/o}function b(e){const{id:t,geometry:s,properties:i}=e;if(!s)return;if("GeometryCollection"===s.type)throw new Error("GeometryCollection not supported in dynamic mode.");const{type:o,coordinates:n}=s,r={id:t,type:1,geometry:[],tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0},a=r.geometry;if("Point"===o)v(n,a,r);else if("MultiPoint"===o)for(const e of n)v(e,a,r);else if("LineString"===o)r.type=2,I(n,a,r);else if("MultiLineString"===o)r.type=2,S(n,a,r);else if("Polygon"===o)r.type=3,S(n,a,r,!0);else {if("MultiPolygon"!==o)throw new Error("Input data is not a valid GeoJSON object.");r.type=3;for(const e of n)S(e,a,r,!0);}return r}function v([t,s],i,o){const n=e.av(t);let r=e.aC(s);r=r<0?0:r>1?1:r,i.push(n,r),o.minX=Math.min(o.minX,n),o.minY=Math.min(o.minY,r),o.maxX=Math.max(o.maxX,n),o.maxY=Math.max(o.maxY,r);}function I(e,t,s,i=!1,o=!1){const n=[];for(const t of e)v(t,n,s);t.push(n),i&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(n,o);}function S(e,t,s,i=!1){for(let o=0;o<e.length;o++)I(e[o],t,s,i,0===o);}function M(t,s,i,o){const{id:n,type:r,geometry:a,tags:l}=t,c=[];if(1===r)!function(t,s,i,o,n){for(let r=0;r<t.length;r+=2){const a=Math.round(e.ai*(t[r+0]*s-i)),l=Math.round(e.ai*(t[r+1]*s-o));n.push([a,l]);}}(a,s,i,o,c);else for(const e of a)T(e,s,i,o,c);return {id:n,type:r,geometry:c,tags:l}}function T(t,s,i,o,n){const r=-y,a=e.ai+y;let l;for(let c=0;c<t.length-2;c+=2){let h=Math.round(e.ai*(t[c+0]*s-i)),u=Math.round(e.ai*(t[c+1]*s-o)),d=Math.round(e.ai*(t[c+2]*s-i)),p=Math.round(e.ai*(t[c+3]*s-o));const f=d-h,g=p-u;h<r&&d<r||(h<r?(u+=Math.round(g*((r-h)/f)),h=r):d<r&&(p=u+Math.round(g*((r-h)/f)),d=r),u<r&&p<r||(u<r?(h+=Math.round(f*((r-u)/g)),u=r):p<r&&(d=h+Math.round(f*((r-u)/g)),p=r),h>=a&&d>=a||(h>=a?(u+=Math.round(g*((a-h)/f)),h=a):d>=a&&(p=u+Math.round(g*((a-h)/f)),d=a),u>=a&&p>=a||(u>=a?(h+=Math.round(f*((a-u)/g)),u=a):p>=a&&(d=h+Math.round(f*((a-u)/g)),p=a),l&&h===l[l.length-1][0]&&u===l[l.length-1][1]||(l=[[h,u]],n.push(l)),l.push([d,p])))));}}var P,k,C,_={exports:{}},L=function(){if(C)return _.exports;C=1;var t=e.eg(),s=function(){if(k)return P;k=1;var t=e.ee(),s=e.ef().VectorTileFeature;function i(e,t){this.options=t||{},this.features=e,this.length=e.length;}function o(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}return P=i,i.prototype.feature=function(e){return new o(this.features[e],this.options.extent)},o.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var s=0;s<e.length;s++){for(var i=e[s],o=[],n=0;n<i.length;n++)o.push(new t(i[n][0],i[n][1]));this.geometry.push(o);}return this.geometry},o.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,s=-1/0,i=1/0,o=-1/0,n=0;n<e.length;n++)for(var r=e[n],a=0;a<r.length;a++){var l=r[a];t=Math.min(t,l.x),s=Math.max(s,l.x),i=Math.min(i,l.y),o=Math.max(o,l.y);}return [t,i,s,o]},o.prototype.toGeoJSON=s.prototype.toGeoJSON,P}();function i(e){var s=new t;return function(e,t){for(var s in e.layers)t.writeMessage(3,o,e.layers[s]);}(e,s),s.finish()}function o(e,t){var s;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(s=0;s<e.length;s++)i.feature=e.feature(s),t.writeMessage(2,n,i);var o=i.keys;for(s=0;s<o.length;s++)t.writeStringField(3,o[s]);var r=i.values;for(s=0;s<r.length;s++)t.writeMessage(4,h,r[s]);}function n(e,t){var s=e.feature;void 0!==s.id&&t.writeVarintField(1,s.id),t.writeMessage(2,r,e),t.writeVarintField(3,s.type),t.writeMessage(4,c,s);}function r(e,t){var s=e.feature,i=e.keys,o=e.values,n=e.keycache,r=e.valuecache;for(var a in s.properties){var l=s.properties[a],c=n[a];if(null!==l){void 0===c&&(i.push(a),n[a]=c=i.length-1),t.writeVarint(c);var h=typeof l;"string"!==h&&"boolean"!==h&&"number"!==h&&(l=JSON.stringify(l));var u=h+":"+l,d=r[u];void 0===d&&(o.push(l),r[u]=d=o.length-1),t.writeVarint(d);}}}function a(e,t){return (t<<3)+(7&e)}function l(e){return e<<1^e>>31}function c(e,t){for(var s=e.loadGeometry(),i=e.type,o=0,n=0,r=s.length,c=0;c<r;c++){var h=s[c],u=1;1===i&&(u=h.length),t.writeVarint(a(1,u));for(var d=3===i?h.length-1:h.length,p=0;p<d;p++){1===p&&1!==i&&t.writeVarint(a(2,d-1));var f=h[p].x-o,g=h[p].y-n;t.writeVarint(l(f)),t.writeVarint(l(g)),o+=f,n+=g;}3===i&&t.writeVarint(a(7,1));}}function h(e,t){var s=typeof e;"string"===s?t.writeStringField(1,e):"boolean"===s?t.writeBooleanField(7,e):"number"===s&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}return _.exports=i,_.exports.fromVectorTileJs=i,_.exports.fromGeojsonVt=function(e,t){t=t||{};var o={};for(var n in e)o[n]=new s(e[n].features,t),o[n].name=n,o[n].version=t.version,o[n].extent=t.extent;return i({layers:o})},_.exports.GeoJSONWrapper=s,_.exports}(),z=e.eh(L);const D={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},j=Math.fround||(O=new Float32Array(1),e=>(O[0]=+e,O[0]));var O;const F=3,A=5,Z=6;class E{constructor(e){this.options=Object.assign(Object.create(D),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:s,maxZoom:i}=this.options;t&&console.time("total time");const o=`prepare ${e.length} points`;t&&console.time(o),this.points=e;const n=[];for(let t=0;t<e.length;t++){const s=e[t];if(!s.geometry)continue;const[i,o]=s.geometry.coordinates,r=j(B(i)),a=j(G(o));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[i+1]=this._createTree(n);t&&console.timeEnd(o);for(let e=i;e>=s;e--){const s=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-s);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let s=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)s=-180,o=180;else if(s>o){const e=this.getClusters([s,i,180,n],t),r=this.getClusters([-180,i,o,n],t);return e.concat(r)}const r=this.trees[this._limitZoom(t)],a=r.range(B(s),G(n),B(o),G(i)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+A]>1?N(l,t,this.clusterProps):this.points[l[t+F]]);}return c}getChildren(e){const t=this._getOriginId(e),s=this._getOriginZoom(e),i="No cluster with the specified id.",o=this.trees[s];if(!o)throw new Error(i);const n=o.data;if(t*this.stride>=n.length)throw new Error(i);const r=this.options.radius/(this.options.extent*Math.pow(2,s-1)),a=o.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const s=t*this.stride;n[s+4]===e&&l.push(n[s+A]>1?N(n,s,this.clusterProps):this.points[n[s+F]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,s){const i=[];return this._appendLeaves(i,e,t=t||10,s=s||0,0),i}getTile(e,t,s){const i=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(s-a)/o,c=(s+1+a)/o,h={features:[]};return this._addTileFeatures(i.range((t-a)/o,l,(t+1+a)/o,c),i.data,t,s,o,h),0===t&&this._addTileFeatures(i.range(1-a/o,l,1,c),i.data,o,s,o,h),t===o-1&&this._addTileFeatures(i.range(0,l,a/o,c),i.data,-1,s,o,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const s=this.getChildren(e);if(t++,1!==s.length)break;e=s[0].properties.cluster_id;}return t}_appendLeaves(e,t,s,i,o){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?o+n.point_count<=i?o+=n.point_count:o=this._appendLeaves(e,n.cluster_id,s,i,o):o<i?o++:e.push(t),e.length===s)break}return o}_createTree(t){const s=new e.bE(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)s.add(t[e],t[e+1]);return s.finish(),s.data=t,s}_addTileFeatures(e,t,s,i,o,n){for(const r of e){const e=r*this.stride,a=t[e+A]>1;let l,c,h;if(a)l=X(t,e,this.clusterProps),c=t[e],h=t[e+1];else {const s=this.points[t[e+F]];l=s.properties;const[i,o]=s.geometry.coordinates;c=B(i),h=G(o);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*o-s)),Math.round(this.options.extent*(h*o-i))]],tags:l};let d;d=a||this.options.generateId?t[e+F]:this.points[t[e+F]].id,void 0!==d&&(u.id=d),n.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:s,extent:i,reduce:o,minPoints:n}=this.options,r=s/(i*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let s=0;s<a.length;s+=c){if(a[s+2]<=t)continue;a[s+2]=t;const i=a[s],h=a[s+1],u=e.within(a[s],a[s+1],r),d=a[s+A];let p=d;for(const e of u){const s=e*c;a[s+2]>t&&(p+=a[s+A]);}if(p>d&&p>=n){let e,n=i*d,r=h*d,f=-1;const g=(s/c<<5)+(t+1)+this.points.length;for(const i of u){const l=i*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+A];n+=a[l]*h,r+=a[l+1]*h,a[l+4]=g,o&&(e||(e=this._map(a,s,!0),f=this.clusterProps.length,this.clusterProps.push(e)),o(e,this._map(a,l)));}a[s+4]=g,l.push(n/p,r/p,1/0,g,-1,p),o&&l.push(f);}else {for(let e=0;e<c;e++)l.push(a[s+e]);if(p>1)for(const e of u){const s=e*c;if(!(a[s+2]<=t)){a[s+2]=t;for(let e=0;e<c;e++)l.push(a[s+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,s){if(e[t+A]>1){const i=this.clusterProps[e[t+Z]];return s?Object.assign({},i):i}const i=this.points[e[t+F]].properties,o=this.options.map(i);return s&&o===i?Object.assign({},o):o}}function N(e,t,s){return {type:"Feature",id:e[t+F],properties:X(e,t,s),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),Y(e[t+1])]}};var i;}function X(e,t,s){const i=e[t+A],o=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,n=e[t+Z],r=-1===n?{}:Object.assign({},s[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+F],point_count:i,point_count_abbreviated:o})}function B(e){return e/360+.5}function G(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function Y(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function R(e,t,s,i){let o=i;const n=t+(s-t>>1);let r,a=s-t;const l=e[t],c=e[t+1],h=e[s],u=e[s+1];for(let i=t+3;i<s;i+=3){const t=J(e[i],e[i+1],l,c,h,u);if(t>o)r=i,o=t;else if(t===o){const e=Math.abs(i-n);e<a&&(r=i,a=e);}}o>i&&(r-t>3&&R(e,t,r,i),e[r+2]=o,s-r>3&&R(e,r,s,i));}function J(e,t,s,i,o,n){let r=o-s,a=n-i;if(0!==r||0!==a){const l=((e-s)*r+(t-i)*a)/(r*r+a*a);l>1?(s=o,i=n):l>0&&(s+=r*l,i+=a*l);}return r=e-s,a=t-i,r*r+a*a}function V(e,t,s,i){const o={id:e??null,type:t,geometry:s,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)$(o,s);else if("Polygon"===t)$(o,s[0]);else if("MultiLineString"===t)for(const e of s)$(o,e);else if("MultiPolygon"===t)for(const e of s)$(o,e[0]);return o}function $(e,t){for(let s=0;s<t.length;s+=3)e.minX=Math.min(e.minX,t[s]),e.minY=Math.min(e.minY,t[s+1]),e.maxX=Math.max(e.maxX,t[s]),e.maxY=Math.max(e.maxY,t[s+1]);}function W(e,t,s,i){if(!t.geometry)return;const o=t.geometry.coordinates;if(o&&0===o.length)return;const n=t.geometry.type,r=Math.pow(s.tolerance/((1<<s.maxZoom)*s.extent),2);let a=[],l=t.id;if(s.promoteId?l=t.properties[s.promoteId]:s.generateId&&(l=i||0),"Point"===n)q(o,a);else if("MultiPoint"===n)for(const e of o)q(e,a);else if("LineString"===n)U(o,a,r,!1);else if("MultiLineString"===n){if(s.lineMetrics){for(const s of o)a=[],U(s,a,r,!1),e.push(V(l,"LineString",a,t.properties));return}H(o,a,r,!1);}else if("Polygon"===n)H(o,a,r,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const o of t.geometry.geometries)W(e,{id:l,geometry:o,properties:t.properties},s,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of o){const t=[];H(e,t,r,!0),a.push(t);}}e.push(V(l,n,a,t.properties));}function q(e,t){t.push(Q(e[0]),K(e[1]),0);}function U(e,t,s,i){let o,n,r=0;for(let s=0;s<e.length;s++){const a=Q(e[s][0]),l=K(e[s][1]);t.push(a,l,0),s>0&&(r+=i?(o*l-a*n)/2:Math.sqrt(Math.pow(a-o,2)+Math.pow(l-n,2))),o=a,n=l;}const a=t.length-3;t[2]=1,R(t,0,a,s),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function H(e,t,s,i){for(let o=0;o<e.length;o++){const n=[];U(e[o],n,s,i),t.push(n);}}function Q(e){return e/360+.5}function K(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function ee(e,t,s,i,o,n,r,a){if(i/=t,n>=(s/=t)&&r<i)return e;if(r<s||n>=i)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===o?t.minX:t.minY,c=0===o?t.maxX:t.maxY;if(r>=s&&c<i){l.push(t);continue}if(c<s||r>=i)continue;let h=[];if("Point"===n||"MultiPoint"===n)te(e,h,s,i,o);else if("LineString"===n)se(e,h,s,i,o,!1,a.lineMetrics);else if("MultiLineString"===n)oe(e,h,s,i,o,!1);else if("Polygon"===n)oe(e,h,s,i,o,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];oe(t,e,s,i,o,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===n){for(const e of h)l.push(V(t.id,n,e,t.tags));continue}"LineString"!==n&&"MultiLineString"!==n||(1===h.length?(n="LineString",h=h[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===h.length?"Point":"MultiPoint"),l.push(V(t.id,n,h,t.tags));}}return l.length?l:null}function te(e,t,s,i,o){for(let n=0;n<e.length;n+=3){const r=e[n+o];r>=s&&r<=i&&ne(t,e[n],e[n+1],e[n+2]);}}function se(e,t,s,i,o,n,r){let a=ie(e);const l=0===o?re:ae;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const p=e[d],f=e[d+1],g=e[d+2],m=e[d+3],y=e[d+4],x=0===o?p:f,w=0===o?m:y;let b=!1;r&&(c=Math.sqrt(Math.pow(p-m,2)+Math.pow(f-y,2))),x<s?w>s&&(h=l(a,p,f,m,y,s),r&&(a.start=u+c*h)):x>i?w<i&&(h=l(a,p,f,m,y,i),r&&(a.start=u+c*h)):ne(a,p,f,g),w<s&&x>=s&&(h=l(a,p,f,m,y,s),b=!0),w>i&&x<=i&&(h=l(a,p,f,m,y,i),b=!0),!n&&b&&(r&&(a.end=u+c*h),t.push(a),a=ie(e)),r&&(u+=c);}let d=e.length-3;const p=e[d],f=e[d+1],g=0===o?p:f;g>=s&&g<=i&&ne(a,p,f,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&ne(a,a[0],a[1],a[2]),a.length&&t.push(a);}function ie(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function oe(e,t,s,i,o,n){for(const r of e)se(r,t,s,i,o,n,!1);}function ne(e,t,s,i){e.push(t,s,i);}function re(e,t,s,i,o,n){const r=(n-t)/(i-t);return ne(e,n,s+(o-s)*r,1),r}function ae(e,t,s,i,o,n){const r=(n-s)/(o-s);return ne(e,t+(i-t)*r,n,1),r}function le(e,t){const s=[];for(let i=0;i<e.length;i++){const o=e[i],n=o.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=ce(o.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of o.geometry)r.push(ce(e,t));}else if("MultiPolygon"===n){r=[];for(const e of o.geometry){const s=[];for(const i of e)s.push(ce(i,t));r.push(s);}}s.push(V(o.id,n,r,o.tags));}return s}function ce(e,t){const s=[];s.size=e.size,void 0!==e.start&&(s.start=e.start,s.end=e.end);for(let i=0;i<e.length;i+=3)s.push(e[i]+t,e[i+1],e[i+2]);return s}function he(e,t){if(e.transformed)return e;const s=1<<e.z,i=e.x,o=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push(ue(e[r],e[r+1],t,s,i,o));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push(ue(e[r][n],e[r][n+1],t,s,i,o));n.geometry.push(a);}}return e.transformed=!0,e}function ue(e,t,s,i,o,n){return [Math.round(s*(e*i-o)),Math.round(s*(t*i-n))]}function de(e,t,s,i,o){const n=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:s,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)pe(r,t,n,o);return r}function pe(e,t,s,i){const o=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<o.length;t+=3)r.push(o[t],o[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)fe(r,o,e,s,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<o.length;t++)fe(r,o[t],e,s,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<o.length;t++){const i=o[t];for(let t=0;t<i.length;t++)fe(r,i[t],e,s,!0,0===t);}if(r.length){let s=t.tags||null;if("LineString"===n&&i.lineMetrics){s={};for(const e in t.tags)s[e]=t.tags[e];s.mapbox_clip_start=o.start/o.size,s.mapbox_clip_end=o.end/o.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:s};null!==t.id&&(a.id=t.id),e.features.push(a);}}function fe(e,t,s,i,o,n){const r=i*i;if(i>0&&t.size<(o?r:i))return void(s.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===i||t[e+2]>r)&&(s.numSimplified++,a.push(t[e],t[e+1])),s.numPoints++;o&&function(e,t){let s=0;for(let t=0,i=e.length,o=i-2;t<i;o=t,t+=2)s+=(e[t]-e[o])*(e[t+1]+e[o+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const i=e[t],o=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=i,e[s-1-t]=o;}}(a,n),e.push(a);}const ge={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class me{constructor(e,t){const s=(t=this.options=function(e,t){for(const s in t)e[s]=t[s];return e}(Object.create(ge),t)).debug;if(s&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let i=function(e,t){const s=[];if("FeatureCollection"===e.type)for(let i=0;i<e.features.length;i++)W(s,e.features[i],t,i);else W(s,"Feature"===e.type?e:{geometry:e},t);return s}(e,t);this.tiles={},this.tileCoords=[],s&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){const s=t.buffer/t.extent;let i=e;const o=ee(e,1,-1-s,s,0,-1,2,t),n=ee(e,1,1-s,2+s,0,-1,2,t);return (o||n)&&(i=ee(e,1,-s,1+s,0,-1,2,t)||[],o&&(i=le(o,1).concat(i)),n&&(i=i.concat(le(n,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),s&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,s,i,o,n,r){const a=[e,t,s,i],l=this.options,c=l.debug;for(;a.length;){i=a.pop(),s=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=ye(t,s,i);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=de(e,t,s,i,l),this.tileCoords.push({z:t,x:s,y:i}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,s,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==o){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===o)continue;if(null!=o){const e=o-t;if(s!==n>>e||i!==r>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const p=.5*l.buffer/l.extent,f=.5-p,g=.5+p,m=1+p;let y=null,x=null,w=null,b=null,v=ee(e,h,s-p,s+g,0,d.minX,d.maxX,l),I=ee(e,h,s+f,s+m,0,d.minX,d.maxX,l);e=null,v&&(y=ee(v,h,i-p,i+g,1,d.minY,d.maxY,l),x=ee(v,h,i+f,i+m,1,d.minY,d.maxY,l),v=null),I&&(w=ee(I,h,i-p,i+g,1,d.minY,d.maxY,l),b=ee(I,h,i+f,i+m,1,d.minY,d.maxY,l),I=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*s,2*i),a.push(x||[],t+1,2*s,2*i+1),a.push(w||[],t+1,2*s+1,2*i),a.push(b||[],t+1,2*s+1,2*i+1);}}getTile(e,t,s){e=+e,t=+t,s=+s;const i=this.options,{extent:o,debug:n}=i;if(e<0||e>24)return null;const r=1<<e,a=ye(e,t=t+r&r-1,s);if(this.tiles[a])return he(this.tiles[a],o);n>1&&console.log("drilling down to z%d-%d-%d",e,t,s);let l,c=e,h=t,u=s;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[ye(c,h,u)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,s),n>1&&console.timeEnd("drilling down"),this.tiles[a]?he(this.tiles[a],o):null):null}}function ye(e,t,s){return 32*((1<<e)*s+t)+e}function xe(e,t){const s=e.tileID.canonical;if(!this._geoJSONIndex)return void t(null,null);const i=this._geoJSONIndex.getTile(s.z,s.x,s.y);if(!i)return void t(null,null);const o=new g(i.features);let n=z(o);0===n.byteOffset&&n.byteLength===n.buffer.byteLength||(n=new Uint8Array(n)),t(null,{vectorTile:o,rawData:n.buffer});}class we extends c{constructor(e,t,s,i,o,n){super(e,t,s,i,xe,n),o&&(this.loadGeoJSON=o),this._dynamicIndex=new x;}loadData(s,i){const o=s&&s.request,n=o&&o.collectResourceTiming;this.loadGeoJSON(s,((r,a)=>{if(r||!a)return i(r);if("object"!=typeof a)return i(new Error(`Input data given to '${s.source}' is not a valid GeoJSON object.`));{try{if(s.filter){const t=e.X(s.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));a.features=a.features.filter((e=>t.value.evaluate({zoom:0},e)));}s.dynamic?("Feature"===a.type&&(a={type:"FeatureCollection",features:[a]}),s.append||(this._dynamicIndex.clear(),this.loaded={}),this._dynamicIndex.load(a.features,this.loaded),s.cluster&&(a.features=this._dynamicIndex.getFeatures())):this.loaded={},this._geoJSONIndex=s.cluster?new E(function({superclusterOptions:t,clusterProperties:s}){if(!s||!t)return t;const i={},o={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(s);for(const t of a){const[n,r]=s[t],a=e.X(r),l=e.X("string"==typeof n?[n,["accumulated"],["get",t]]:n);i[t]=a.value,o[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(n,r);return t},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=o[t].evaluate(n,r);},t}(s)).load(a.features):s.dynamic?this._dynamicIndex:function(e,t){return new me(e,t)}(a,s.geojsonVtOptions);}catch(e){return i(e)}const r={};if(n){const e=t(o);e&&(r.resourceTiming={},r.resourceTiming[s.source]=JSON.parse(JSON.stringify(e)));}i(null,r);}}));}reloadTile(e,t){const s=this.loaded;return s&&s[e.uid]?e.partial?t(null,void 0):super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,s){if(t.request)e.n(t.request,s);else {if("string"!=typeof t.data)return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return s(null,JSON.parse(t.data))}catch(e){return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class be{constructor(t,s){this.tileID=new e.aH(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.projection=t.projection,this.brightness=s;}parse(t,s,i,o){this.status="parsing";const n=new e.aH(i.tileID.overscaledZ,i.tileID.wrap,i.tileID.canonical.z,i.tileID.canonical.x,i.tileID.canonical.y),r=[],a=s.familiesBySource[i.source],l=new e.e0(n,i.promoteId);return l.bucketLayerIDs=[],l.is3DTile=!0,e.ei(t).then((t=>{if(!t)return o(new Error("Could not parse tile"));const s=e.ej(t,1/e.cd(i.tileID.canonical)),c=t.json.extensionsUsed&&t.json.extensionsUsed.includes("MAPBOX_mesh_features")||t.json.asset.extras&&t.json.asset.extras.MAPBOX_mesh_features,h=t.json.extensionsUsed&&t.json.extensionsUsed.includes("EXT_meshopt_compression"),u=new e.aa(this.zoom,{brightness:this.brightness});for(const t in a)for(const i of a[t]){const t=i[0];l.bucketLayerIDs.push(i.map((t=>e.C(t.id,t.scope)))),t.recalculate(u,[]);const o=new e.ek(i,s,n,c,h,this.brightness,l);c||(o.needsUpload=!0),r.push(o),o.evaluate(t);}this.status="done",o(null,{buckets:r,featureIndex:l,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:null});})).catch((e=>o(new Error(e.message))))}}class ve{constructor(e,t,s,i,o,n){this.actor=e,this.layerIndex=t,this.availableImages=s,this.brightness=n,this.loading={},this.loaded={};}loadTile(t,s){const i=t.uid,o=this.loading[i]=new be(t,this.brightness);e.bj(t.request,((e,n)=>{const r=!this.loading[i];return delete this.loading[i],r||e?(o.status="done",r||(this.loaded[i]=o),s(e)):n&&0!==n.byteLength?void o.parse(n,this.layerIndex,t,((e,t)=>{o.status="done",this.loaded=this.loaded||{},this.loaded[i]=o,e||!t?s(e):s(null,t);})):(o.status="done",this.loaded[i]=o,s())}));}reloadTile(e,t){const s=this.loaded,i=e.uid;if(s&&s[i]){const o=s[i];o.projection=e.projection,o.brightness=e.brightness;const n=(s,i)=>{o.reloadCallback&&(delete o.reloadCallback,this.loadTile(e,t)),t(s,i);};"parsing"===o.status?o.reloadCallback=n:"done"===o.status&&this.loadTile(e,t);}}abortTile(e,t){const s=e.uid;this.loading[s]&&delete this.loading[s],t();}removeTile(e,t){const s=this.loaded,i=e.uid;s&&s[i]&&delete s[i],t();}}class Ie{constructor(t){this.self=t,this.actor=new e.el(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded={},this.imageRasterizer=new e.y,this.projections={},this.defaultProjection=e.bP({name:"mercator"}),this.workerSourceTypes={vector:c,geojson:we,"raster-dem":h,"raster-array":d,"batched-model":ve},this.workerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.em.isParsed())throw new Error("RTL text plugin already registered.");e.em.applyArabicShaping=t.applyArabicShaping,e.em.processBidirectionalText=t.processBidirectionalText,e.em.processStyledBidirectionalText=t.processStyledBidirectionalText;};}clearCaches(e,t,s){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],s();}checkIfReady(e,t,s){s();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,{scope:s,isLoaded:i}){if(this.isSpriteLoaded[t]||(this.isSpriteLoaded[t]={}),this.isSpriteLoaded[t][s]=i,this.workerSources[t]&&this.workerSources[t][s])for(const o in this.workerSources[t][s]){const n=this.workerSources[t][s][o];for(const t in n){const s=n[t];s instanceof c&&(s.isSpriteLoaded=i,s.fire(new e.A("isSpriteLoaded")));}}}setImages(e,{scope:t,images:s},i){if(this.availableImages[e]||(this.availableImages[e]={}),this.availableImages[e][t]=s,this.workerSources[e]&&this.workerSources[e][t]){for(const i in this.workerSources[e][t]){const o=this.workerSources[e][t][i];for(const e in o)o[e].availableImages=s;}i();}else i();}setProjection(t,s){this.projections[t]=e.bP(s);}setBrightness(e,t,s){this.brightness=t,s();}setLayers(e,t,s){this.getLayerIndex(e,t.scope).replace(t.layers,t.options),s();}updateLayers(e,t,s){this.getLayerIndex(e,t.scope).update(t.layers,t.removedIds,t.options),s();}loadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).loadTile(t,s);}decodeRasterArray(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).decodeRasterArray(t,s);}reloadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).reloadTile(t,s);}abortTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).abortTile(t,s);}removeTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).removeTile(t,s);}removeSource(e,t,s){if(!(this.workerSources[e]&&this.workerSources[e][t.scope]&&this.workerSources[e][t.scope][t.type]&&this.workerSources[e][t.scope][t.type][t.source]))return;const i=this.workerSources[e][t.scope][t.type][t.source];delete this.workerSources[e][t.scope][t.type][t.source],void 0!==i.removeSource?i.removeSource(t,s):s();}loadWorkerSource(e,t,s){try{this.self.importScripts(t.url),s();}catch(e){s(e.toString());}}syncRTLPluginState(t,s,i){try{e.em.setState(s);const t=e.em.getPluginURL();if(e.em.isLoaded()&&!e.em.isParsed()&&null!=t){this.self.importScripts(t);const s=e.em.isParsed();i(s?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),s);}}catch(e){i(e.toString());}}setDracoUrl(e,t){this.dracoUrl=t;}getAvailableImages(e,t){this.availableImages[e]||(this.availableImages[e]={});let s=this.availableImages[e][t];return s||(s=[]),s}getLayerIndex(e,t){this.layerIndexes[e]||(this.layerIndexes[e]={});let s=this.layerIndexes[e][t];return s||(s=this.layerIndexes[e][t]=new o,s.scope=t),s}getWorkerSource(e,t,s,i){const o=this.workerSources;return o[e]||(o[e]={}),o[e][i]||(o[e][i]={}),o[e][i][t]||(o[e][i][t]={}),this.isSpriteLoaded[e]||(this.isSpriteLoaded[e]={}),o[e][i][t][s]||(o[e][i][t][s]=new this.workerSourceTypes[t]({send:(t,s,i,o,n,r)=>{this.actor.send(t,s,i,e,n,r);},scheduler:this.actor.scheduler},this.getLayerIndex(e,i),this.getAvailableImages(e,i),this.isSpriteLoaded[e][i],void 0,this.brightness)),o[e][i][t][s]}rasterizeImages(e,t,s){const i=new Map;for(const[s,{image:o,imageVariant:n}]of t.tasks.entries()){const r=this.imageRasterizer.rasterize(n,o,t.scope,e);i.set(s,r);}s(void 0,i);}removeRasterizedImages(e,t,s){this.imageRasterizer.removeImagesFromCacheByIds(t.imageIds,t.scope,e),s();}enforceCacheSizeLimit(t,s){e.en(s);}getWorkerPerformanceMetrics(e,t,s){s(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new Ie(self)),Ie}));

define(["./shared"],(function(e){var t="3.11.1";const i={create:"create",load:"load",fullLoad:"fullLoad"},o={mark(e){performance.mark(e);},measure(e,t,i){performance.measure(e,t,i);}};function s(t){const i=t.name.split("?")[0];return e.a(i)&&i.includes("mapbox-gl.js")?"javascript":e.a(i)&&i.includes("mapbox-gl.css")?"css":e.b(i)?"fontRange":e.c(i)?"sprite":e.i(i)?"style":e.d(i)?"tilejson":"other"}var r,n={},a=function(){if(r)return n;function e(e){return !t(e)}function t(t){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===i[o=t&&t.failIfMajorPerformanceCaveat]&&(i[o]=function(t){var i,o=function(t){var i=document.createElement("canvas"),o=Object.create(e.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=t,i.getContext("webgl2",o)}(t);if(!o)return !1;try{i=o.createShader(o.VERTEX_SHADER);}catch(e){return !1}return !(!i||o.isContextLost())&&(o.shaderSource(i,"void main() {}"),o.compileShader(i),!0===o.getShaderParameter(i,o.COMPILE_STATUS))}(o)),i[o]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL2 support"):"insufficient Canvas/getImageData support":"insufficient worker support";var o;}r=1,n.supported=e,n.notSupportedReason=t;var i={};return e.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0},n}();function l(e,t,i){const o=document.createElement(e);return null!=t&&(o.className=t),i&&i.appendChild(o),o}function c(e,t,i){const o=document.createElementNS("http://www.w3.org/2000/svg",e);for(const e of Object.keys(t))o.setAttributeNS(null,e,String(t[e]));return i&&i.appendChild(o),o}const h="undefined"!=typeof document?document.documentElement&&document.documentElement.style:null,d=h&&void 0!==h.userSelect?"userSelect":"WebkitUserSelect";let u;function _(){h&&d&&(u=h[d],h[d]="none");}function p(){h&&d&&(h[d]=u);}function f(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",f,!0);}function m(){window.addEventListener("click",f,!0),window.setTimeout((()=>{window.removeEventListener("click",f,!0);}),0);}function g(e,t){const i=e.getBoundingClientRect();return x(e,i,t)}function v(e,t){const i=e.getBoundingClientRect(),o=[];for(let s=0;s<t.length;s++)o.push(x(e,i,t[s]));return o}function y(e){return /firefox/i.test(navigator.userAgent)&&/macintosh/i.test(navigator.userAgent)&&2===e.button&&e.ctrlKey?0:e.button}function x(t,i,o){const s=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.P((o.clientX-i.left)*s,(o.clientY-i.top)*s)}const b="01",w="NO_ACCESS_TOKEN";class T{constructor(e,t,i){this._transformRequestFn=e,this._customAccessToken=t,this._silenceAuthErrors=!!i,this._createSkuToken();}_createSkuToken(){const e=function(){let e="";for(let t=0;t<10;t++)e+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",b,e].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=e.token,this._skuTokenExpiresAt=e.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}normalizeStyleURL(i,o){if(!e.f(i))return i;const s=S(i);return s.params.push(`sdk=js-${t}`),s.path=`/styles/v1${s.path}`,this._makeAPIURL(s,this._customAccessToken||o)}normalizeGlyphsURL(t,i){if(!e.f(t))return t;const o=S(t);return o.path=`/fonts/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeModelURL(t,i){if(!e.f(t))return t;const o=S(t);return o.path=`/models/v1${o.path}`,this._makeAPIURL(o,this._customAccessToken||i)}normalizeSourceURL(t,i,o,s){if(!e.f(t))return t;const r=S(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),o&&r.params.push(`language=${o}`),s&&r.params.push(`worldview=${s}`),this._makeAPIURL(r,this._customAccessToken||i)}normalizeIconsetURL(t,i){const o=S(t);return e.f(t)?(o.path=`/styles/v1${o.path}/iconset.pbf`,this._makeAPIURL(o,this._customAccessToken||i)):C(o)}normalizeSpriteURL(t,i,o,s){const r=S(t);return e.f(t)?(r.path=`/styles/v1${r.path}/sprite${i}${o}`,this._makeAPIURL(r,this._customAccessToken||s)):(r.path+=`${i}${o}`,C(r))}normalizeTileURL(t,i,o){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!e.f(t))return t;const s=S(t);s.path=s.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${i||o&&"raster"!==s.authority&&512===o?"@2x":""}${e.m.supported?".webp":"$1"}`),"raster"===s.authority?s.path=`/${e.e.RASTER_URL_PREFIX}${s.path}`:"rasterarrays"===s.authority?s.path=`/${e.e.RASTERARRAYS_URL_PREFIX}${s.path}`:"3dtiles"===s.authority?s.path=`/${e.e.TILES3D_URL_PREFIX}${s.path}`:(s.path=s.path.replace(/^.+\/v4\//,"/"),s.path=`/${e.e.TILE_URL_VERSION}${s.path}`);const r=this._customAccessToken||function(e){for(const t of e){const e=t.match(/^access_token=(.*)$/);if(e)return e[1]}return null}(s.params)||e.e.ACCESS_TOKEN;return e.e.REQUIRE_ACCESS_TOKEN&&r&&this._skuToken&&s.params.push(`sku=${this._skuToken}`),this._makeAPIURL(s,r)}canonicalizeTileURL(t,i){const o=S(t);if(!o.path.match(/^(\/v4\/|\/(raster|rasterarrays)\/v1\/)/)||!o.path.match(/\.[\w]+$/))return t;let s="mapbox://";o.path.match(/^\/raster\/v1\//)?s+=`raster/${o.path.replace(`/${e.e.RASTER_URL_PREFIX}/`,"")}`:o.path.match(/^\/rasterarrays\/v1\//)?s+=`rasterarrays/${o.path.replace(`/${e.e.RASTERARRAYS_URL_PREFIX}/`,"")}`:s+=`tiles/${o.path.replace(`/${e.e.TILE_URL_VERSION}/`,"")}`;let r=o.params;return i&&(r=r.filter((e=>!e.match(/^access_token=/)))),r.length&&(s+=`?${r.join("&")}`),s}canonicalizeTileset(t,i){const o=!!i&&e.f(i),s=[];for(const i of t.tiles||[])e.h(i)?s.push(this.canonicalizeTileURL(i,o)):s.push(i);return s}_makeAPIURL(t,i){const o="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",s=S(e.e.API_URL);if(t.protocol=s.protocol,t.authority=s.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==s.path&&(t.path=`${s.path}${t.path}`),!e.e.REQUIRE_ACCESS_TOKEN)return C(t);if(i=i||e.e.ACCESS_TOKEN,!this._silenceAuthErrors){if(!i)throw new Error(`An API access token is required to use Mapbox GL. ${o}`);if("s"===i[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${o}`)}return t.params=t.params.filter((e=>-1===e.indexOf("access_token"))),t.params.push(`access_token=${i||""}`),C(t)}}const E=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function S(e){const t=e.match(E);if(!t)throw new Error("Unable to parse URL object");return {protocol:t[1],authority:t[2],path:t[3]||"/",params:t[4]?t[4].split("&"):[]}}function C(e){const t=e.params.length?`?${e.params.join("&")}`:"";return `${e.protocol}://${e.authority}${e.path}${t}`}const I="mapbox.eventData";function R(t){if(!t)return null;const i=t.split(".");if(!i||3!==i.length)return null;try{return JSON.parse(e.j(i[1]))}catch(e){return null}}class D{constructor(e){this.type=e,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const i=R(e.e.ACCESS_TOKEN);let o="";return o=i&&i.u?e.k(i.u):e.e.ACCESS_TOKEN||"",t?`${I}.${t}:${o}`:`${I}:${o}`}fetchEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid");if(t)try{const e=localStorage.getItem(i);e&&(this.eventData=JSON.parse(e));const t=localStorage.getItem(o);t&&(this.anonId=t);}catch(t){e.w("Unable to read from LocalStorage");}}saveEventData(){const t=e.s("localStorage"),i=this.getStorageKey(),o=this.getStorageKey("uuid"),s=this.anonId;if(t&&s)try{localStorage.setItem(o,s),Object.keys(this.eventData).length>=1&&localStorage.setItem(i,JSON.stringify(this.eventData));}catch(t){e.w("Unable to write to LocalStorage");}}processRequests(e){}postEvent(t,i,o,s){if(!e.e.EVENTS_URL)return;const r=S(e.e.EVENTS_URL);r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const n={event:this.type,created:new Date(t).toISOString()},a=i?e.l(n,i):n,l={url:C(r),headers:{"Content-Type":"text/plain"},body:JSON.stringify([a])};this.pendingRequest=e.p(l,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}queueRequest(e,t){this.queue.push(e),this.processRequests(t);}}const A=new class extends D{constructor(e){super("appUserTurnstile"),this._customAccessToken=e;}postTurnstileEvent(t,i){e.e.EVENTS_URL&&e.e.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>e.f(t)||e.h(t)))&&this.queueRequest(Date.now(),i);}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const o=R(e.e.ACCESS_TOKEN),s=o?o.u:e.e.ACCESS_TOKEN;let r=s!==this.eventData.tokenU;e.v(this.anonId)||(this.anonId=e.u(),r=!0);const n=this.queue.shift();if(this.eventData.lastSuccess){const e=new Date(this.eventData.lastSuccess),t=new Date(n),i=(n-this.eventData.lastSuccess)/864e5;r=r||i>=1||i<-1||e.getDate()!==t.getDate();}else r=!0;r?this.postEvent(n,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,"enabled.telemetry":!1,userId:this.anonId},(e=>{e||(this.eventData.lastSuccess=n,this.eventData.tokenU=s);}),i):this.processRequests();}},L=A.postTurnstileEvent.bind(A),P=new class extends D{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.EVENTS_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;const{id:o,timestamp:s}=this.queue.shift();o&&this.success[o]||(this.anonId||this.fetchEventData(),e.v(this.anonId)||(this.anonId=e.u()),this.postEvent(s,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:b,skuToken:this.skuToken,userId:this.anonId},(e=>{e?this.errorCb(e):o&&(this.success[o]=!0);}),i));}remove(){this.errorCb=null;}},M=P.postMapLoadEvent.bind(P),z=new class extends D{constructor(){super("style.load"),this.eventIdPerMapInstanceMap=new Map,this.mapInstanceIdMap=new WeakMap;}getMapInstanceId(t){let i=this.mapInstanceIdMap.get(t);return i||(i=e.u(),this.mapInstanceIdMap.set(t,i)),i}getEventId(e){const t=this.eventIdPerMapInstanceMap.get(e)||0;return this.eventIdPerMapInstanceMap.set(e,t+1),t}postStyleLoadEvent(t,i){const{map:o,style:s,importedStyles:r}=i;if(!e.e.EVENTS_URL||!t&&!e.e.ACCESS_TOKEN)return;const n=this.getMapInstanceId(o),a={mapInstanceId:n,eventId:this.getEventId(n),style:s};r.length&&(a.importedStyles=r),this.queueRequest({timestamp:Date.now(),payload:a},t);}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:t,payload:i}=this.queue.shift();this.postEvent(t,i,(()=>{}),e);}},O=z.postStyleLoadEvent.bind(z),F=new class extends D{constructor(){super("gljs.performance");}postPerformanceEvent(t,i){e.e.EVENTS_URL&&(t||e.e.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:i},t);}processRequests(o){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:n}=this.queue.shift(),a=function(o){const r=performance.getEntriesByType("resource"),n=performance.getEntriesByType("mark"),a=function(e){const t={};if(e)for(const i in e)if("other"!==i)for(const o of e[i]){const e=`${i}ResolveRangeMin`,s=`${i}ResolveRangeMax`,r=`${i}RequestCount`,n=`${i}RequestCachedCount`;t[e]=Math.min(t[e]||1/0,o.startTime),t[s]=Math.max(t[s]||-1/0,o.responseEnd);const a=e=>{void 0===t[e]&&(t[e]=0),++t[e];};void 0!==o.transferSize&&0===o.transferSize&&a(n),a(r);}return t}(function(e,t){const i={};if(e)for(const o of e){const e=t(o);void 0===i[e]&&(i[e]=[]),i[e].push(o);}return i}(r,s)),l=window.devicePixelRatio,c=navigator.connection||navigator.mozConnection||navigator.webkitConnection,h=c?c.effectiveType:void 0,d={counters:[],metadata:[],attributes:[]},u=(e,t,i)=>{null!=i&&e.push({name:t,value:i.toString()});};for(const e in a)u(d.counters,e,a[e]);if(o.interactionRange[0]!==1/0&&o.interactionRange[1]!==-1/0&&(u(d.counters,"interactionRangeMin",o.interactionRange[0]),u(d.counters,"interactionRangeMax",o.interactionRange[1])),n)for(const e of Object.keys(i)){const t=i[e],o=n.find((e=>e.name===t));o&&u(d.counters,t,o.startTime);}return u(d.counters,"visibilityHidden",o.visibilityHidden),u(d.attributes,"style",function(t){if(t)for(const i of t){const t=i.name.split("?")[0];if(e.i(t)){const e=t.split("/").slice(-2);if(2===e.length)return `mapbox://styles/${e[0]}/${e[1]}`}}}(r)),u(d.attributes,"terrainEnabled",o.terrainEnabled?"true":"false"),u(d.attributes,"fogEnabled",o.fogEnabled?"true":"false"),u(d.attributes,"projection",o.projection),u(d.attributes,"zoom",o.zoom),u(d.metadata,"devicePixelRatio",l),u(d.metadata,"connectionEffectiveType",h),u(d.metadata,"navigatorUserAgent",navigator.userAgent),u(d.metadata,"screenWidth",window.screen.width),u(d.metadata,"screenHeight",window.screen.height),u(d.metadata,"windowWidth",window.innerWidth),u(d.metadata,"windowHeight",window.innerHeight),u(d.metadata,"mapWidth",o.width/l),u(d.metadata,"mapHeight",o.height/l),u(d.metadata,"webglRenderer",o.renderer),u(d.metadata,"webglVendor",o.vendor),u(d.metadata,"sdkVersion",t),u(d.metadata,"sdkIdentifier","mapbox-gl-js"),d}(n);for(const e of a.metadata);for(const e of a.counters);for(const e of a.attributes);this.postEvent(r,a,(()=>{}),o);}},k=F.postPerformanceEvent.bind(F),B=new class extends D{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,i,o,s){if(!e.e.API_URL||!e.e.SESSION_PATH)return;const r=S(e.e.API_URL+e.e.SESSION_PATH);r.params.push(`sku=${i||""}`),r.params.push(`access_token=${s||e.e.ACCESS_TOKEN||""}`);const n={url:C(r),headers:{"Content-Type":"text/plain"}};this.pendingRequest=e.g(n,(e=>{this.pendingRequest=null,o(e),this.saveEventData(),this.processRequests(s);}));}getSessionAPI(t,i,o,s){this.skuToken=i,this.errorCb=s,e.e.SESSION_PATH&&e.e.API_URL&&(o||e.e.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},o):this.errorCb(new Error(w)));}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:t,timestamp:i}=this.queue.shift();t&&this.success[t]||this.getSession(i,this.skuToken,(e=>{e?this.errorCb(e):t&&(this.success[t]=!0);}),e);}remove(){this.errorCb=null;}},N=B.getSessionAPI.bind(B),U=new Set;function V(e,t){t?U.add(e):U.delete(e);}class G{constructor(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps=new Set,this._updatedImages={};}isDirty(){return this._changed}setDirty(){this._changed=!0;}getUpdatedSourceCaches(){return this._updatedSourceCaches}updateSourceCache(e,t){this._updatedSourceCaches[e]=t,this.setDirty();}discardSourceCacheUpdate(e){delete this._updatedSourceCaches[e];}updateLayer(e){const t=e.scope;this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._updatedLayers[t].add(e.id),this.setDirty();}removeLayer(e){const t=e.scope;this._removedLayers[t]=this._removedLayers[t]||{},this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._removedLayers[t][e.id]=e,this._updatedLayers[t].delete(e.id),this._updatedPaintProps.delete(e.fqid),this.setDirty();}getRemovedLayer(e){return this._removedLayers[e.scope]?this._removedLayers[e.scope][e.id]:null}discardLayerRemoval(e){this._removedLayers[e.scope]&&delete this._removedLayers[e.scope][e.id];}getLayerUpdatesByScope(){const e={};for(const t in this._updatedLayers)e[t]=e[t]||{},e[t].updatedIds=Array.from(this._updatedLayers[t].values());for(const t in this._removedLayers)e[t]=e[t]||{},e[t].removedIds=Object.keys(this._removedLayers[t]);return e}getUpdatedPaintProperties(){return this._updatedPaintProps}updatePaintProperties(e){this._updatedPaintProps.add(e.fqid),this.setDirty();}getUpdatedImages(e){return this._updatedImages[e]?Array.from(this._updatedImages[e].values()):[]}updateImage(t,i){this._updatedImages[i]=this._updatedImages[i]||new Set,this._updatedImages[i].add(e.I.toString(t)),this.setDirty();}resetUpdatedImages(e){this._updatedImages[e]&&this._updatedImages[e].clear();}reset(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps.clear(),this._updatedImages={};}}function j(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class q extends e.E{constructor(t){super(),this.imageProviders=new Map,this.images=new Map,this.updatedImages=new Map,this.callbackDispatchedThisFrame=new Map,this.loaded=new Map,this.requestors=[],this.patterns=new Map,this.patternsInFlight=new Set,this.atlasImage=new Map,this.atlasTexture=new Map,this.dirty=!0,this.spriteFormat=t,"raster"!==t&&e.t()&&(this.imageRasterizerDispatcher=new e.D(e.x(),this,"Image Rasterizer Worker",1));}addScope(t){this.loaded.set(t,!1),this.imageProviders.set(t,new Map),this.images.set(t,new Map),this.updatedImages.set(t,new Set),this.callbackDispatchedThisFrame.set(t,new Set),this.patterns.set(t,new Map),this.atlasImage.set(t,new e.r({width:1,height:1}));}removeScope(e){this.loaded.delete(e),this.imageProviders.delete(e),this.images.delete(e),this.updatedImages.delete(e),this.callbackDispatchedThisFrame.delete(e),this.patterns.delete(e),this.atlasImage.delete(e);const t=this.atlasTexture.get(e);t&&(t.destroy(),this.atlasTexture.delete(e));}addImageProvider(e,t){this.imageProviders.has(t)||this.imageProviders.set(t,new Map),this.imageProviders.get(t).set(e.id,e);}removeImageProvider(e,t){this.imageProviders.has(t)&&this.imageProviders.get(t).delete(e);}getPendingImageProviders(){const e=[];for(const t of this.imageProviders.values())for(const i of t.values())i.hasPendingRequests()&&e.push(i);return e}get imageRasterizer(){return this._imageRasterizer||(this._imageRasterizer=new e.y),this._imageRasterizer}isLoaded(){for(const e of this.loaded.keys())if(!this.loaded.get(e))return !1;return !0}setLoaded(e,t){if(this.loaded.get(t)!==e&&(this.loaded.set(t,e),e)){for(const{ids:e,callback:i}of this.requestors)this._notify(e,t,i);this.requestors=[];}}hasImage(e,t){return !!this.getImage(e,t)}getImage(e,t){return this.images.get(t).get(e.toString())}addImage(e,t,i){this._validate(e,i)&&this.images.get(t).set(e.toString(),i);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.z(new Error(`Image "${t.name}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.z(new Error(`Image "${t.name}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.z(new Error(`Image "${t.name}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;if(!t.usvg){if(e[0]<0||t.data.width<e[0])return !1;if(e[1]<0||t.data.height<e[1])return !1;if(e[2]<0||t.data.width<e[2])return !1;if(e[3]<0||t.data.height<e[3])return !1}return !(e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i){const o=this.images.get(t).get(e.toString());i.version=o.version+1,this.images.get(t).set(e.toString(),i),this.updatedImages.get(t).add(e),this.removeFromImageRasterizerCache(e,t);}clearUpdatedImages(e){this.updatedImages.get(e).clear();}removeFromImageRasterizerCache(t,i){if("raster"!==this.spriteFormat)if(e.t()){const e={imageIds:[t],scope:i};this.imageRasterizerDispatcher.getActor().send("removeRasterizedImages",e);}else this.imageRasterizer.removeImagesFromCacheByIds([t],i);}removeImage(e,t){const i=this.images.get(t),o=i.get(e.toString());i.delete(e.toString()),this.patterns.get(t).delete(e.toString()),this.removeFromImageRasterizerCache(e,t),o.userImage&&o.userImage.onRemove&&o.userImage.onRemove();}listImages(t){return Array.from(this.images.get(t).keys()).map((t=>e.I.from(t)))}getImages(e,t,i){const o=[],s=[],r=this.imageProviders.get(t);for(const i of e){if(!i.iconsetId){o.push(i);continue}const e=r.get(i.iconsetId);e&&(this.getImage(i,t)?s.push(i):e.addPendingRequest(i));}if(0===o.length)return void this._notify(s,t,i);let n=!0;const a=!!this.loaded.get(t),l=this.images.get(t);if(!a)for(const e of o)l.has(e.toString())||(n=!1);a||n?this._notify(o,t,i):this.requestors.push({ids:o,scope:t,callback:i});}rasterizeImages({scope:e,tasks:t},i){const o=new Map;for(const[i,s]of t.entries()){const t=this.getImage(s.id,e);t&&o.set(i,{image:t,imageVariant:s});}this._rasterizeImages(e,o,i);}_rasterizeImages(t,i,o){if(e.t())this.imageRasterizerDispatcher.getActor().send("rasterizeImages",{tasks:i,scope:t},o);else {const e=new Map;for(const[o,{image:s,imageVariant:r}]of i.entries())e.set(o,this.imageRasterizer.rasterize(r,s,t,0));o(void 0,e);}}getUpdatedImages(e){return this.updatedImages.get(e)||new Set}_notify(t,i,o){const s=this.images.get(i),r=new Map;for(const i of t){const t=s.get(i.toString());if(!t){if(i.iconsetId)continue;e.w(`Image "${i.name}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`),this.fire(new e.A("styleimagemissing",{id:i.name}));continue}const o={data:t.usvg?null:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,usvg:t.usvg,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)};t.usvg&&Object.assign(o,{width:t.icon.usvg_tree.width,height:t.icon.usvg_tree.height}),r.set(e.I.toString(i),o);}o(null,r);}getPixelSize(e){const{width:t,height:i}=this.atlasImage.get(e);return {width:t,height:i}}getPattern(t,i,o){const s=t.toString(),r=this.patterns.get(i),n=r.get(s),a=this.getImage(t,i);if(!a)return null;if(n){if(n.position.version===a.version)return n.position;n.position.version=a.version;}else {if(a.usvg&&!a.data){const r=this.getPatternInFlightId(s,i);if(this.patternsInFlight.has(r))return null;this.patternsInFlight.add(r);const n=new e.B(t).scaleSelf(e.q.devicePixelRatio),l=new Map([[n.toString(),{image:a,imageVariant:n}]]);return this._rasterizeImages(i,l,((e,t)=>this.storePatternImage(n,i,a,o,t))),null}this.storePattern(t,i,a);}return this._updatePatternAtlas(i,o),r.get(s).position}getPatternInFlightId(t,i){return e.C(t,i)}hasPatternsInFlight(){return 0!==this.patternsInFlight.size}storePatternImage(e,t,i,o,s){const r=e.toString(),n=s?s.get(r):void 0;n&&(i.data=n,this.storePattern(e.id,t,i),this._updatePatternAtlas(t,o),this.patternsInFlight.delete(this.getPatternInFlightId(e.id.toString(),t)));}storePattern(t,i,o){const s={w:o.data.width+2*e.F,h:o.data.height+2*e.F,x:0,y:0},r=new e.G(s,o,e.F);this.patterns.get(i).set(t.toString(),{bin:s,position:r});}bind(t,i){const o=t.gl;let s=this.atlasTexture.get(i);s?this.dirty&&(s.update(this.atlasImage.get(i)),this.dirty=!1):(s=new e.T(t,this.atlasImage.get(i),o.RGBA8),this.atlasTexture.set(i,s)),s.bind(o.LINEAR,o.CLAMP_TO_EDGE);}_updatePatternAtlas(t,i){const o=this.patterns.get(t),s=Array.from(o.values()).map((({bin:e})=>e)),{w:r,h:n}=e.H(s),a=this.atlasImage.get(t);a.resize({width:r||1,height:n||1});const l=this.images.get(t);for(const[t,{bin:s,position:r}]of o.entries()){let o=r.padding;const n=s.x+o,c=s.y+o,h=l.get(t).data,d=h.width,u=h.height;o=o>1?o-1:o,e.r.copy(h,a,{x:0,y:0},{x:n,y:c},{width:d,height:u},i),e.r.copy(h,a,{x:0,y:u-o},{x:n,y:c-o},{width:d,height:o},i),e.r.copy(h,a,{x:0,y:0},{x:n,y:c+u},{width:d,height:o},i),e.r.copy(h,a,{x:d-o,y:0},{x:n-o,y:c},{width:o,height:u},i),e.r.copy(h,a,{x:0,y:0},{x:n+d,y:c},{width:o,height:u},i),e.r.copy(h,a,{x:d-o,y:u-o},{x:n-o,y:c-o},{width:o,height:o},i),e.r.copy(h,a,{x:0,y:u-o},{x:n+d,y:c-o},{width:o,height:o},i),e.r.copy(h,a,{x:0,y:0},{x:n+d,y:c+u},{width:o,height:o},i),e.r.copy(h,a,{x:d-o,y:0},{x:n-o,y:c+u},{width:o,height:o},i);}this.dirty=!0;}beginFrame(){for(const e of this.images.keys())this.callbackDispatchedThisFrame.set(e,new Set);}dispatchRenderCallbacks(e,t){const i=this.images.get(t);for(const o of e){if(this.callbackDispatchedThisFrame.get(t).has(o.toString()))continue;this.callbackDispatchedThisFrame.get(t).add(o.toString());const e=i.get(o.toString());j(e)&&this.updateImage(o,t,e);}}}function H(t){const i=t.key,o=t.value,s=t.valueSpec||{},r=t.objectElementValidators||{},n=t.style,a=t.styleSpec;let l=[];const c=e.K(o);if("object"!==c)return [new e.V(i,o,`object expected, ${c} found`)];for(const t in o){const c=t.split(".")[0];let h;r[c]?h=r[c]:s[c]?h=_e:r["*"]?h=r["*"]:s["*"]&&(h=_e),h?l=l.concat(h({key:(i?`${i}.`:i)+t,value:o[t],valueSpec:s[c]||s["*"],style:n,styleSpec:a,object:o,objectKey:t},o)):l.push(new e.J(i,o[t],`unknown property "${t}"`));}for(const t in s)r[t]||s[t].required&&void 0===s[t].default&&void 0===o[t]&&l.push(new e.V(i,o,`missing required property "${t}"`));return l}function Z(t){const i=t.value,o=t.valueSpec,s=t.style,r=t.styleSpec,n=t.key,a=t.arrayElementValidator||_e;if("array"!==e.K(i))return [new e.V(n,i,`array expected, ${e.K(i)} found`)];if(o.length&&i.length!==o.length)return [new e.V(n,i,`array length ${o.length} expected, length ${i.length} found`)];if(o["min-length"]&&i.length<o["min-length"])return [new e.V(n,i,`array length at least ${o["min-length"]} expected, length ${i.length} found`)];let l={type:o.value,values:o.values,minimum:o.minimum,maximum:o.maximum,function:void 0};r.$version<7&&(l.function=o.function),"object"===e.K(o.value)&&(l=o.value);let c=[];for(let e=0;e<i.length;e++)c=c.concat(a({array:i,arrayIndex:e,value:i[e],valueSpec:l,style:s,styleSpec:r,key:`${n}[${e}]`},!0));return c}function W(t){const i=t.key,o=t.value,s=t.valueSpec;let r=e.K(o);if("number"===r&&o!=o&&(r="NaN"),"number"!==r)return [new e.V(i,o,`number expected, ${r} found`)];if("minimum"in s){let r=s.minimum;if("array"===e.K(s.minimum)&&(r=s.minimum[t.arrayIndex]),o<r)return [new e.V(i,o,`${o} is less than the minimum value ${r}`)]}if("maximum"in s){let r=s.maximum;if("array"===e.K(s.maximum)&&(r=s.maximum[t.arrayIndex]),o>r)return [new e.V(i,o,`${o} is greater than the maximum value ${r}`)]}return []}function $(t){const i=t.valueSpec,o=e.M(t.value.type);let s,r,n,a={};const l="categorical"!==o&&void 0===t.value.property,c=!l,h="array"===e.K(t.value.stops)&&"array"===e.K(t.value.stops[0])&&"object"===e.K(t.value.stops[0][0]),d=H({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===o)return [new e.V(t.key,t.value,'identity function may not have a "stops" property')];let i=[];const s=t.value;return i=i.concat(Z({key:t.key,value:s,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===e.K(s)&&0===s.length&&i.push(new e.V(t.key,s,"array must have at least one stop")),i},default:function(e){return _e({key:e.key,value:e.value,valueSpec:i,style:e.style,styleSpec:e.styleSpec})}}});return "identity"===o&&l&&d.push(new e.V(t.key,t.value,'missing required property "property"')),"identity"===o||t.value.stops||d.push(new e.V(t.key,t.value,'missing required property "stops"')),"exponential"===o&&t.valueSpec.expression&&!e.N(t.valueSpec)&&d.push(new e.V(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(c&&!e.O(t.valueSpec)?d.push(new e.V(t.key,t.value,"property functions not supported")):l&&!e.Q(t.valueSpec)&&d.push(new e.V(t.key,t.value,"zoom functions not supported"))),"categorical"!==o&&!h||void 0!==t.value.property||d.push(new e.V(t.key,t.value,'"property" property is required')),d;function u(t){let o=[];const s=t.value,l=t.key;if("array"!==e.K(s))return [new e.V(l,s,`array expected, ${e.K(s)} found`)];if(2!==s.length)return [new e.V(l,s,`array length 2 expected, length ${s.length} found`)];if(h){if("object"!==e.K(s[0]))return [new e.V(l,s,`object expected, ${e.K(s[0])} found`)];if(void 0===s[0].zoom)return [new e.V(l,s,"object stop key must have zoom")];if(void 0===s[0].value)return [new e.V(l,s,"object stop key must have value")];const i=e.M(s[0].zoom);if("number"!=typeof i)return [new e.V(l,s[0].zoom,"stop zoom values must be numbers")];if(n&&n>i)return [new e.V(l,s[0].zoom,"stop zoom values must appear in ascending order")];i!==n&&(n=i,r=void 0,a={}),o=o.concat(H({key:`${l}[0]`,value:s[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:W,value:_}}));}else o=o.concat(_({key:`${l}[0]`,value:s[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},s));return e.S(e.U(s[1]))?o.concat([new e.V(`${l}[1]`,s[1],"expressions are not allowed in function stops.")]):o.concat(_e({key:`${l}[1]`,value:s[1],valueSpec:i,style:t.style,styleSpec:t.styleSpec}))}function _(t,n){const l=e.K(t.value),c=e.M(t.value),h=null!==t.value?t.value:n;if(s){if(l!==s)return [new e.V(t.key,h,`${l} stop domain type must match previous stop domain type ${s}`)]}else s=l;if("number"!==l&&"string"!==l&&"boolean"!==l&&"number"!=typeof c&&"string"!=typeof c&&"boolean"!=typeof c)return [new e.V(t.key,h,"stop domain value must be a number, string, or boolean")];if("number"!==l&&"categorical"!==o){let s=`number expected, ${l} found`;return e.O(i)&&void 0===o&&(s+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new e.V(t.key,h,s)]}return "categorical"!==o||"number"!==l||"number"==typeof c&&isFinite(c)&&Math.floor(c)===c?"categorical"!==o&&"number"===l&&"number"==typeof c&&"number"==typeof r&&void 0!==r&&c<r?[new e.V(t.key,h,"stop domain values must appear in ascending order")]:(r=c,"categorical"===o&&c in a?[new e.V(t.key,h,"stop domain values must be unique")]:(a[c]=!0,[])):[new e.V(t.key,h,`integer expected, found ${String(c)}`)]}}function X(t){const i=("property"===t.expressionContext?e.W:e.X)(e.U(t.value),t.valueSpec);if("error"===i.result)return i.value.map((i=>new e.V(`${t.key}${i.key}`,t.value,i.message)));const o=i.value.expression||i.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!o.outputDefined())return [new e.V(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!e.Y(o))return [new e.V(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return K(o,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!e.Z(o,["zoom","feature-state"]))return [new e.V(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!e._(o))return [new e.V(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function K(t,i){const o=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(i.valueSpec&&i.valueSpec.expression)for(const e of i.valueSpec.expression.parameters)o.delete(e);if(0===o.size)return [];const s=[];return t instanceof e.$&&o.has(t.name)?[new e.V(i.key,i.value,`["${t.name}"] expression is not supported in a filter for a ${i.object.type} layer with id: ${i.object.id}`)]:(t.eachChild((e=>{s.push(...K(e,i));})),s)}function Y(t){const i=t.key,o=t.value,s=t.valueSpec,r=[];return Array.isArray(s.values)?-1===s.values.indexOf(e.M(o))&&r.push(new e.V(i,o,`expected one of [${s.values.join(", ")}], ${JSON.stringify(o)} found`)):-1===Object.keys(s.values).indexOf(e.M(o))&&r.push(new e.V(i,o,`expected one of [${Object.keys(s.values).join(", ")}], ${JSON.stringify(o)} found`)),r}function J(t){return e.a1(e.U(t.value))?X(e.L({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${t.layerType||"fill"}`]})):Q(t)}function Q(t){const i=t.value,o=t.key;if("array"!==e.K(i))return [new e.V(o,i,`array expected, ${e.K(i)} found`)];const s=t.styleSpec;let r,n=[];if(i.length<1)return [new e.V(o,i,"filter array must have at least 1 element")];switch(n=n.concat(Y({key:`${o}[0]`,value:i[0],valueSpec:s.filter_operator,style:t.style,styleSpec:t.styleSpec})),e.M(i[0])){case"<":case"<=":case">":case">=":i.length>=2&&"$type"===e.M(i[1])&&n.push(new e.V(o,i,`"$type" cannot be use with operator "${i[0]}"`));case"==":case"!=":3!==i.length&&n.push(new e.V(o,i,`filter array for operator "${i[0]}" must have 3 elements`));case"in":case"!in":i.length>=2&&(r=e.K(i[1]),"string"!==r&&n.push(new e.V(`${o}[1]`,i[1],`string expected, ${r} found`)));for(let a=2;a<i.length;a++)r=e.K(i[a]),"$type"===e.M(i[1])?n=n.concat(Y({key:`${o}[${a}]`,value:i[a],valueSpec:s.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==r&&"number"!==r&&"boolean"!==r&&n.push(new e.V(`${o}[${a}]`,i[a],`string, number, or boolean expected, ${r} found`));break;case"any":case"all":case"none":for(let e=1;e<i.length;e++)n=n.concat(Q({key:`${o}[${e}]`,value:i[e],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":r=e.K(i[1]),2!==i.length?n.push(new e.V(o,i,`filter array for "${i[0]}" operator must have 2 elements`)):"string"!==r&&n.push(new e.V(`${o}[1]`,i[1],`string expected, ${r} found`));}return n}function ee(t,i){const o=t.key,s=t.style,r=t.layer,n=t.styleSpec,a=t.value,l=t.objectKey,c=n[`${i}_${t.layerType}`];if(!c)return [];const h=l.match(/^(.*)-use-theme$/);if("paint"===i&&h&&c[h[1]])return e.S(a)?[].concat(_e({key:t.key,value:a,valueSpec:{type:"string",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},style:s,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l})):_e({key:o,value:a,valueSpec:{type:"string"},style:s,styleSpec:n});const d=l.match(/^(.*)-transition$/);if("paint"===i&&d&&c[d[1]]&&c[d[1]].transition)return _e({key:o,value:a,valueSpec:n.transition,style:s,styleSpec:n});const u=t.valueSpec||c[l];if(!u)return [new e.J(o,a,`unknown property "${l}"`)];let _;if("string"===e.K(a)&&e.O(u)&&!u.tokens&&(_=/^{([^}]+)}$/.exec(a))){const t=`\`{ "type": "identity", "property": ${_?JSON.stringify(_[1]):'"_"'} }\``;return [new e.V(o,a,`"${l}" does not support interpolation syntax\nUse an identity property function instead: ${t}.`)]}const p=[];if("symbol"===t.layerType)"text-field"!==l||!s||s.glyphs||s.imports||p.push(new e.V(o,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===l&&e.a2(e.U(a))&&"identity"===e.M(a.type)&&p.push(new e.V(o,a,'"text-font" does not support identity functions'));else if("model"===t.layerType&&"paint"===i&&r&&r.layout&&r.layout.hasOwnProperty("model-id")&&e.O(u)&&(e.a3(u)||e.Q(u))){const t=e.W(e.U(a),u),i=t.value.expression||t.value._styleExpression.expression;i&&!e.Z(i,["measure-light"])&&("model-emissive-strength"===l&&e._(i)&&e.Y(i)||p.push(new e.V(o,a,`${l} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`)));}return p.concat(_e({key:t.key,value:a,valueSpec:u,style:s,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l}))}function te(e){return ee(e,"paint")}function ie(e){return ee(e,"layout")}function oe(t){let i=[];const o=t.value,s=t.key,r=t.style,n=t.styleSpec;o.type||o.ref||i.push(new e.V(s,o,'either "type" or "ref" is required'));let a=e.M(o.type);const l=e.M(o.ref);if(o.id){const n=e.M(o.id);for(let a=0;a<t.arrayIndex;a++){const t=r.layers[a];e.M(t.id)===n&&i.push(new e.V(s,o.id,`duplicate layer id "${o.id}", previously used at line ${t.id.__line__}`));}}if("ref"in o){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in o&&i.push(new e.V(s,o[t],`"${t}" is prohibited for ref layers`));})),r.layers.forEach((i=>{e.M(i.id)===l&&(t=i);})),t?t.ref?i.push(new e.V(s,o.ref,"ref cannot reference another ref layer")):a=e.M(t.type):"string"==typeof l&&i.push(new e.V(s,o.ref,`ref layer "${l}" not found`));}else if("background"!==a&&"sky"!==a&&"slot"!==a)if(o.source){const t=r.sources&&r.sources[o.source],n=t&&e.M(t.type);t?"vector"===n&&"raster"===a?i.push(new e.V(s,o.source,`layer "${o.id}" requires a raster source`)):"raster"===n&&"raster"!==a?i.push(new e.V(s,o.source,`layer "${o.id}" requires a vector source`)):"vector"!==n||o["source-layer"]?"raster-dem"===n&&"hillshade"!==a?i.push(new e.V(s,o.source,"raster-dem source can only be used with layer type 'hillshade'.")):"raster-array"!==n||["raster","raster-particle"].includes(a)?"line"!==a||!o.paint||!o.paint["line-gradient"]&&!o.paint["line-trim-offset"]||"geojson"===n&&t.lineMetrics?"raster-particle"===a&&"raster-array"!==n&&i.push(new e.V(s,o.source,`layer "${o.id}" requires a 'raster-array' source.`)):i.push(new e.V(s,o,`layer "${o.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):i.push(new e.V(s,o.source,"raster-array source can only be used with layer type 'raster'.")):i.push(new e.V(s,o,`layer "${o.id}" must specify a "source-layer"`)):i.push(new e.V(s,o.source,`source "${o.source}" not found`));}else i.push(new e.V(s,o,'missing required property "source"'));return i=i.concat(H({key:s,value:o,valueSpec:n.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>_e({key:`${s}.type`,value:o.type,valueSpec:n.layer.type,style:t.style,styleSpec:t.styleSpec,object:o,objectKey:"type"}),filter:t=>J(e.L({layerType:a},t)),layout:t=>H({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>ie(e.L({layerType:a},t))}}),paint:t=>H({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>te(e.L({layerType:a,layer:o},t))}})}})),i}function se(t){const i=t.value,o=t.key,s=e.K(i);return "string"!==s?[new e.V(o,i,`string expected, ${s} found`)]:[]}const re={promoteId:function t({key:i,value:o}){if("string"===e.K(o))return se({key:i,value:o});if(Array.isArray(o)){const t=[],s=e.U(o),r=e.X(s);return "error"===r.result&&r.value.forEach((o=>{t.push(new e.V(`${i}${o.key}`,null,`${o.message}`));})),e.Z(r.value.expression,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])||t.push(new e.V(`${i}`,null,"promoteId expression should be only feature dependent")),t}{const e=[];for(const s in o)e.push(...t({key:`${i}.${s}`,value:o[s]}));return e}}};function ne(t){const i=t.value,o=t.key,s=t.styleSpec,r=t.style;if(!i.type)return [new e.V(o,i,'"type" is required')];const n=e.M(i.type);let a=[];switch(["vector","raster","raster-dem","raster-array"].includes(n)&&(i.url||i.tiles||a.push(new e.J(o,i,'Either "url" or "tiles" is required.'))),n){case"vector":case"raster":case"raster-dem":case"raster-array":return a=a.concat(H({key:o,value:i,valueSpec:s[`source_${n.replace("-","_")}`],style:t.style,styleSpec:s,objectElementValidators:re})),a;case"geojson":if(a=H({key:o,value:i,valueSpec:s.source_geojson,style:r,styleSpec:s,objectElementValidators:re}),i.cluster)for(const e in i.clusterProperties){const[t,s]=i.clusterProperties[e],r="string"==typeof t?[t,["accumulated"],["get",e]]:t;a.push(...X({key:`${o}.${e}.map`,value:s,expressionContext:"cluster-map"})),a.push(...X({key:`${o}.${e}.reduce`,value:r,expressionContext:"cluster-reduce"}));}return a;case"video":return H({key:o,value:i,valueSpec:s.source_video,style:r,styleSpec:s});case"image":return H({key:o,value:i,valueSpec:s.source_image,style:r,styleSpec:s});case"canvas":return [new e.V(o,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Y({key:`${o}.type`,value:i.type,valueSpec:{values:ae(s)},style:r,styleSpec:s})}}function ae(e){return e.source.reduce(((t,i)=>{const o=e[i];return "enum"===o.type.type&&(t=t.concat(Object.keys(o.type.values))),t}),[])}function le(t){const i=t.value,o=t.styleSpec,s=o.light,r=t.style;let n=[];const a=e.K(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("light",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);n=n.concat(l&&s[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:r,styleSpec:o}):a&&s[a[1]]&&s[a[1]].transition?_e({key:t,value:i[t],valueSpec:o.transition,style:r,styleSpec:o}):s[t]?_e({key:t,value:i[t],valueSpec:s[t],style:r,styleSpec:o}):[new e.V(t,i[t],`unknown property "${t}"`)]);}return n}function ce(t){const i=t.value;let o=[];if(!i)return o;const s=e.K(i);if("object"!==s)return o=o.concat([new e.V("light-3d",i,`object expected, ${s} found`)]),o;const r=t.styleSpec,n=r["light-3d"],a=t.key,l=t.style,c=t.style.lights;for(const t of ["type","id"])if(!(t in i))return o=o.concat([new e.V("light-3d",i,`missing property ${t} on light`)]),o;if(i.type&&c)for(let s=0;s<t.arrayIndex;s++){const t=e.M(i.type),r=c[s];e.M(r.type)===t&&o.push(new e.V(a,i.id,`duplicate light type "${i.type}", previously defined at line ${r.id.__line__}`));}const h=`properties_light_${i.type}`;if(!(h in r))return o=o.concat([new e.V("light-3d",i,`Invalid light type ${i.type}`)]),o;const d=r[h];for(const s in i)if("properties"===s){const n=i[s],a=e.K(n);if("object"!==a)return o=o.concat([new e.V("properties",n,`object expected, ${a} found`)]),o;for(const i in n)o=o.concat(d[i]?_e({key:i,value:n[i],valueSpec:d[i],style:l,styleSpec:r}):[new e.J(t.key,n[i],`unknown property "${i}"`)]);}else {const t=s.match(/^(.*)-transition$/),a=s.match(/^(.*)-use-theme$/);o=o.concat(a&&n[a[1]]?_e({key:s,value:i[s],valueSpec:{type:"string"},style:l,styleSpec:r}):t&&n[t[1]]&&n[t[1]].transition?_e({key:s,value:i[s],valueSpec:r.transition,style:l,styleSpec:r}):n[s]?_e({key:s,value:i[s],valueSpec:n[s],style:l,styleSpec:r}):[new e.J(s,i[s],`unknown property "${s}"`)]);}return o}function he(t){const i=t.value,o=t.key,s=t.style,r=t.styleSpec,n=r.terrain;let a=[];const l=e.K(i);if(void 0===i)return a;if("null"===l)return a;if("object"!==l)return a=a.concat([new e.V("terrain",i,`object expected, ${l} found`)]),a;for(const t in i){const o=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);a=a.concat(l&&n[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:s,styleSpec:r}):o&&n[o[1]]&&n[o[1]].transition?_e({key:t,value:i[t],valueSpec:r.transition,style:s,styleSpec:r}):n[t]?_e({key:t,value:i[t],valueSpec:n[t],style:s,styleSpec:r}):[new e.J(t,i[t],`unknown property "${t}"`)]);}if(i.source){const t=s.sources&&s.sources[i.source],r=t&&e.M(t.type);t?"raster-dem"!==r&&a.push(new e.V(o,i.source,`terrain cannot be used with a source of type ${String(r)}, it only be used with a "raster-dem" source type`)):a.push(new e.V(o,i.source,`source "${i.source}" not found`));}else a.push(new e.V(o,i,'terrain is missing required property "source"'));return a}function de(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.fog;let n=[];const a=e.K(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("fog",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/),l=t.match(/^(.*)-use-theme$/);n=n.concat(l&&r[l[1]]?_e({key:t,value:i[t],valueSpec:{type:"string"},style:o,styleSpec:s}):a&&r[a[1]]&&r[a[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.J(t,i[t],`unknown property "${t}"`)]);}return n}const ue={"*":()=>[],array:Z,boolean:function(t){const i=t.value,o=t.key,s=e.K(i);return "boolean"!==s?[new e.V(o,i,`boolean expected, ${s} found`)]:[]},number:W,color:function(t){const i=t.key,o=t.value,s=e.K(o);return "string"!==s?[new e.V(i,o,`color expected, ${s} found`)]:null===e.a0.parseCSSColor(o)?[new e.V(i,o,`color expected, "${o}" found`)]:[]},enum:Y,filter:J,function:$,layer:oe,object:H,source:ne,model:e.a4,light:le,"light-3d":ce,terrain:he,fog:de,string:se,formatted:function(e){return 0===se(e).length?[]:X(e)},resolvedImage:function(e){return 0===se(e).length?[]:X(e)},projection:function(t){const i=t.value,o=t.styleSpec,s=o.projection,r=t.style;let n=[];const a=e.K(i);if("object"===a)for(const e in i)n=n.concat(_e({key:e,value:i[e],valueSpec:s[e],style:r,styleSpec:o}));else "string"!==a&&(n=n.concat([new e.V("projection",i,`object or string expected, ${a} found`)]));return n},import:function(t){const{value:i,styleSpec:o}=t,{data:s,...r}=i;Object.defineProperty(r,"__line__",{value:i.__line__,enumerable:!1});let n=H(e.L({},t,{value:r,valueSpec:o.import}));return ""===e.M(r.id)&&n.push(new e.V(`${t.key}.id`,r,"import id can't be an empty string")),s&&(n=n.concat(fe(s,o,{key:`${t.key}.data`}))),n},iconset:function(t){const i=t.value,o=t.key,s=t.styleSpec,r=t.style;if(!i.type)return [new e.V(o,i,'"type" is required')];const n=e.M(i.type);let a=[];if(a=a.concat(H({key:o,value:i,valueSpec:s[`iconset_${n}`],style:r,styleSpec:s})),"source"===n&&i.source){const t=r.sources&&r.sources[i.source],s=t&&e.M(t.type);t?"raster-array"!==s&&a.push(new e.V(o,i.source,`iconset cannot be used with a source of type ${String(s)}, it only be used with a "raster-array" source type`)):a.push(new e.V(o,i.source,`source "${i.source}" not found`));}return a}};function _e(t,i=!1){const o=t.value,s=t.valueSpec,r=t.styleSpec;if(s.expression&&e.a2(e.M(o)))return $(t);if(s.expression&&e.S(e.U(o)))return X(t);if(s.type&&ue[s.type]){const o=ue[s.type](t);return !0===i&&o.length>0&&"array"===e.K(t.value)?X(t):o}return H(e.L({},t,{valueSpec:s.type?r[s.type]:s}))}function pe(t){const i=t.value,o=t.key,s=se(t);return s.length||(-1===i.indexOf("{fontstack}")&&s.push(new e.V(o,i,'"glyphs" url must include a "{fontstack}" token')),-1===i.indexOf("{range}")&&s.push(new e.V(o,i,'"glyphs" url must include a "{range}" token'))),s}function fe(t,i=e.a5,o={}){return _e({key:o.key||"",value:t,valueSpec:i.$root,styleSpec:i,style:t,objectElementValidators:{glyphs:pe,"*":()=>[]}})}function me(t,i=e.a5){return De(fe(t,i))}const ge=e=>De(ne(e)),ve=e=>De(le(e)),ye=e=>De(ce(e)),xe=e=>De(he(e)),be=e=>De(de(e)),we=t=>De(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.snow;let n=[];const a=e.K(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("snow",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/);n=n.concat(a&&r[a[1]]&&r[a[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.J(t,i[t],`unknown property "${t}"`)]);}return n}(t)),Te=t=>De(function(t){const i=t.value,o=t.style,s=t.styleSpec,r=s.rain;let n=[];const a=e.K(i);if(void 0===i)return n;if("object"!==a)return n=n.concat([new e.V("rain",i,`object expected, ${a} found`)]),n;for(const t in i){const a=t.match(/^(.*)-transition$/);n=n.concat(a&&r[a[1]]&&r[a[1]].transition?_e({key:t,value:i[t],valueSpec:s.transition,style:o,styleSpec:s}):r[t]?_e({key:t,value:i[t],valueSpec:r[t],style:o,styleSpec:s}):[new e.J(t,i[t],`unknown property "${t}"`)]);}return n}(t)),Ee=e=>De(oe(e)),Se=e=>De(J(e)),Ce=e=>De(te(e)),Ie=e=>De(ie(e)),Re=t=>De(e.a4(t));function De(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function Ae(t,i){let o=!1;if(i&&i.length)for(const s of i)s instanceof e.J?e.w(s.message):(t.fire(new e.z(new Error(s.message))),o=!0);return o}let Le;class Pe extends e.E{constructor(t,i="flat"){super(),this._transitionable=new e.a6(Le||(Le=new e.a7({anchor:new e.a8(e.a5.light.anchor),position:new e.a9(e.a5.light.position),color:new e.a8(e.a5.light.color),intensity:new e.a8(e.a5.light.intensity)}))),this.setLight(t,i),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,t,i={}){this._validate(ve,e,i)||(this._transitionable.setTransitionOrValue(e),this.id=t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}}let Me=class extends e.E{constructor(t,i,o,s){super(),this.scope=o,this._transitionable=new e.a6(new e.a7({source:new e.a8(e.a5.terrain.source),exaggeration:new e.a8(e.a5.terrain.exaggeration)}),o,s),this._transitionable.setTransitionOrValue(t,s),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i;}get(){return this._transitionable.serialize()}set(e,t){this._transitionable.setTransitionOrValue(e,t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}getExaggeration(t){return this._transitioning.possiblyEvaluate(new e.aa(t)).get("exaggeration")}getAttenuationRange(){if(!this.isZoomDependent())return null;const t=this._transitionable._values.exaggeration;if(!t)return null;const i=t.value.expression;if(!i)return null;let o=-1,s=-1,r=1;for(const t of i.zoomStops)r=i.evaluate(new e.aa(t)),r>.01?(o=t,s=-1):s=t;return r<.01&&o>0&&s>o?[o,s]:null}isZoomDependent(){const t=this._transitionable._values.exaggeration;return null!=t&&null!=t.value&&null!=t.value.expression&&t.value.expression instanceof e.ab}};const ze=45,Oe=65,Fe=.05;function ke(t,i,o,s){const r=e.ae(ze,Oe,o),[n,a]=Be(t,s);let l=1-Math.min(1,Math.exp((i-n)/(a-n)*-6));return l*=l*l,l=Math.min(1,1.00747*l),l*r*t.alpha}function Be(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}function Ne(t,i,o,s,r){const n=e.ad.vec3.transformMat4([],[i,o,s],r.mercatorFogMatrix);return ke(t,e.ad.vec3.length(n),r.pitch,r._fov)}function Ue(t,i,o,s,r,n,a){const l=[[o,s,0],[r,s,0],[r,n,0],[o,n,0]];let c=Number.MAX_VALUE,h=-Number.MAX_VALUE;for(const t of l){const o=e.ad.vec3.transformMat4([],t,i),s=e.ad.vec3.length(o);c=Math.min(c,s),h=Math.max(h,s);}return [ke(t,c,a.pitch,a._fov),ke(t,h,a.pitch,a._fov)]}class Ve extends e.E{constructor(t,i,o,s){super();const r=new e.a7({range:new e.a8(e.a5.fog.range),color:new e.a8(e.a5.fog.color),"color-use-theme":new e.a8({type:"string","property-type":"data-constant",default:"default"}),"high-color":new e.a8(e.a5.fog["high-color"]),"high-color-use-theme":new e.a8({type:"string","property-type":"data-constant",default:"default"}),"space-color":new e.a8(e.a5.fog["space-color"]),"space-color-use-theme":new e.a8({type:"string","property-type":"data-constant",default:"default"}),"horizon-blend":new e.a8(e.a5.fog["horizon-blend"]),"star-intensity":new e.a8(e.a5.fog["star-intensity"]),"vertical-range":new e.a8(e.a5.fog["vertical-range"])});this._transitionable=new e.a6(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this._transform=i,this.properties=new e.af(r),this.scope=o;}get state(){const t=this._transform,i="globe"===t.projection.name,o=e.ag(t.zoom),s=this.properties.get("range"),r=[.5,3];return {range:i?[e.ah(r[0],s[0],o),e.ah(r[1],s[1],o)]:s,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(be,t,o))return;const s=e.l({},t);for(const t of Object.keys(e.a5.fog))void 0===s[t]&&(s[t]=e.a5.fog[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return ("globe"===this._transform.projection.name?1:e.ae(ze,Oe,t))*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const s=e.ac.fromLngLat(i),r=o.elevation?o.elevation.getAtPointOrZero(s):0;return Ne(t,s.x,s.y,r,o)}(this.state,t,i):0}getOpacityForTile(t){if(!this._transform.projection.supportsFog)return [1,1];const i=this._transform.calculateFogTileMatrix(t.toUnwrapped());return Ue(this.state,i,0,0,e.ai,e.ai,this._transform)}getOpacityForBounds(e,t,i,o,s){return this._transform.projection.supportsFog?Ue(this.state,e,t,i,o,s,this._transform):[1,1]}getFovAdjustedRange(e){return this._transform.projection.supportsFog?Be(this.state,e):[0,1]}isVisibleOnFrustum(t){if(!this._transform.projection.supportsFog)return !1;const i=[4,5,6,7];for(const o of i){const i=t.points[o];let s;if(i[2]>=0)s=i;else {const r=t.points[o-4];s=e.aj(r,i,r[2]/(r[2]-i[2]));}if(Ne(this.state,s[0],s[1],0,this._transform)>=Fe)return !0}return !1}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}}let Ge,je,qe,He,Ze=class extends e.E{constructor(t,i,o,s){super();const r=Ge||(Ge=new e.a7({density:new e.a8(e.a5.snow.density),intensity:new e.a8(e.a5.snow.intensity),color:new e.a8(e.a5.snow.color),opacity:new e.a8(e.a5.snow.opacity),vignette:new e.a8(e.a5.snow.vignette),"vignette-color":new e.a8(e.a5.snow["vignette-color"]),"center-thinning":new e.a8(e.a5.snow["center-thinning"]),direction:new e.a8(e.a5.snow.direction),"flake-size":new e.a8(e.a5.snow["flake-size"])}));this._transitionable=new e.a6(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.af(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.ak(o[0]),r=-Math.max(e.ak(o[1]),.01),n=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],a=this.properties.get("vignette"),l=this.properties.get("vignette-color");return l.a=a,{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.al(i.r,i.g,i.b,i.a*t),direction:n,centerThinning:this.properties.get("center-thinning"),flakeSize:this.properties.get("flake-size"),vignetteColor:l}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(we,t,o))return;const s=e.l({},t);for(const t of Object.keys(e.a5.snow))void 0===s[t]&&(s[t]=e.a5.snow[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}},We=class extends e.E{constructor(t,i,o,s){super();const r=je||(je=new e.a7({density:new e.a8(e.a5.rain.density),intensity:new e.a8(e.a5.rain.intensity),color:new e.a8(e.a5.rain.color),opacity:new e.a8(e.a5.rain.opacity),vignette:new e.a8(e.a5.rain.vignette),"vignette-color":new e.a8(e.a5.rain["vignette-color"]),"center-thinning":new e.a8(e.a5.rain["center-thinning"]),direction:new e.a8(e.a5.rain.direction),"droplet-size":new e.a8(e.a5.rain["droplet-size"]),"distortion-strength":new e.a8(e.a5.rain["distortion-strength"])}));this._transitionable=new e.a6(r,o,new Map(s)),this.set(t,s),this._transitioning=this._transitionable.untransitioned(),this.properties=new e.af(r),this.scope=o;}get state(){const t=this.properties.get("opacity"),i=this.properties.get("color"),o=this.properties.get("direction"),s=e.ak(o[0]),r=-Math.max(e.ak(o[1]),.01),n=[Math.cos(s)*Math.cos(r),Math.sin(s)*Math.cos(r),Math.sin(r)],a=this.properties.get("vignette-color");return a.a=this.properties.get("vignette"),{density:this.properties.get("density"),intensity:this.properties.get("intensity"),color:new e.al(i.r,i.g,i.b,i.a*t),direction:n,centerThinning:this.properties.get("center-thinning"),dropletSize:this.properties.get("droplet-size"),distortionStrength:this.properties.get("distortion-strength"),vignetteColor:a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(Te,t,o))return;const s=e.l({},t);for(const t of Object.keys(e.a5.rain))void 0===s[t]&&(s[t]=e.a5.rain[t].default);this._options=s,this._transitionable.setTransitionOrValue(this._options,i);}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Ae(this,t.call(me,e.l({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.a5})))}};class $e extends e.E{constructor(t,i,o,s){super(),this.scope=o,this._options=t,this.properties=new e.af(i),this._transitionable=new e.a6(i,o,new Map(s)),this._transitionable.setTransitionOrValue(t.properties),this._transitioning=this._transitionable.untransitioned();}updateConfig(e){this._transitionable.setTransitionOrValue(this._options.properties,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}get(){return this._options.properties=this._transitionable.serialize(),this._options}set(e,t){this._options=e,this._transitionable.setTransitionOrValue(e.properties,t);}shadowsEnabled(){return !!this.properties&&!0===this.properties.get("cast-shadows")}}class Xe{constructor(e,t,i,o){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,o);}static createFromScreenPoints(t,i){let o,s;if(t instanceof e.P||"number"==typeof t[0]){const r=e.P.convert(t);o=[r],s=i.isPointAboveHorizon(r);}else {const r=e.P.convert(t[0]),n=e.P.convert(t[1]);o=[r,n],s=e.an(r,n).every((e=>i.isPointAboveHorizon(e)));}return new Xe(o,i.getCameraPoint(),s,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.an(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.an(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?s.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?s[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(s[3]=this.cameraPoint)),e.ao(s,t)}bufferedCameraGeometryGlobe(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.P(1,1)):this.screenBounds[1],s=e.an(i,o,t),r=this.cameraPoint.clone();switch(3*((r.y>i.y)+(r.y>o.y))+((r.x>i.x)+(r.x>o.x))){case 0:s[0]=r,s[4]=r.clone();break;case 1:s.splice(1,0,r);break;case 2:s[1]=r;break;case 3:s.splice(4,0,r);break;case 5:s.splice(2,0,r);break;case 6:s[3]=r;break;case 7:s.splice(3,0,r);break;case 8:s[2]=r;}return s}containsTile(t,i,o,s=0){const r=t.queryPadding/i._pixelsPerMercatorPixel+1,n=o?this._bufferedCameraMercator(r,i):this._bufferedScreenMercator(r,i);let a=t.tileID.wrap+(n.unwrapped?s:0);const l=n.polygon.map((i=>e.ap(t.tileTransform,i,a)));if(!e.aq(l,0,0,e.ai,e.ai))return;a=t.tileID.wrap+(this.screenGeometryMercator.unwrapped?s:0);const c=this.screenGeometryMercator.polygon.map((i=>e.ar(t.tileTransform,i,a))),h=c.map((t=>new e.P(t[0],t[1]))),d=i.getFreeCameraOptions().position||new e.ac(0,0,0),u=e.ar(t.tileTransform,d,a),_=c.map((t=>{const i=e.ad.vec3.sub(t,t,u);return e.ad.vec3.normalize(i,i),new e.as(u,i)})),p=e.at(t,1,i.zoom)*i._pixelsPerMercatorPixel;return {queryGeometry:this,tilespaceGeometry:h,tilespaceRays:_,bufferedTilespaceGeometry:l,bufferedTilespaceBounds:(f=e.au(l),f.min.x=e.ay(f.min.x,0,e.ai),f.min.y=e.ay(f.min.y,0,e.ai),f.max.x=e.ay(f.max.x,0,e.ai),f.max.y=e.ay(f.max.y,0,e.ai),f),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:p};var f;}_bufferedScreenMercator(e,t){const i=Je(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=Je(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=o,o}}_projectAndResample(t,i){const o=function(t,i){const o=e.ad.mat4.multiply([],i.pixelMatrix,i.globeMatrix),s=[0,-e.az,0,1],r=[0,e.az,0,1],n=[0,0,0,1];e.ad.vec4.transformMat4(s,s,o),e.ad.vec4.transformMat4(r,r,o),e.ad.vec4.transformMat4(n,n,o);const a=new e.P(s[0]/s[3],s[1]/s[3]),l=new e.P(r[0]/r[3],r[1]/r[3]),c=e.aw(t,a)&&s[3]<n[3],h=e.aw(t,l)&&r[3]<n[3];if(!c&&!h)return null;const d=function(e,t,i){for(let o=1;o<e.length;o++){const s=Ye(t.pointCoordinate3D(e[o-1]).x),r=Ye(t.pointCoordinate3D(e[o]).x);if(i<0){if(s<r)return {idx:o,t:-s/(r-1-s)}}else if(r<s)return {idx:o,t:(1-s)/(r+1-s)}}return null}(t,i,c?-1:1);if(!d)return null;const{idx:u,t:_}=d;let p=u>1?Ke(t.slice(0,u),i):[],f=u<t.length?Ke(t.slice(u),i):[];p=p.map((t=>new e.P(Ye(t.x),t.y))),f=f.map((t=>new e.P(Ye(t.x),t.y)));const m=[...p];0===m.length&&m.push(f[f.length-1]);const g=e.ah(m[m.length-1].y,(0===f.length?p[0]:f[0]).y,_);let v;return v=c?[new e.P(0,g),new e.P(0,0),new e.P(1,0),new e.P(1,g)]:[new e.P(1,g),new e.P(1,1),new e.P(0,1),new e.P(0,g)],m.push(...v),0===f.length?m.push(p[0]):m.push(...f),{polygon:m.map((t=>new e.ac(t.x,t.y))),unwrapped:!1}}(t,i);if(o)return o;const s=function(t,i){let o=!1,s=-1/0,r=0;for(let e=0;e<t.length-1;e++)t[e].x>s&&(s=t[e].x,r=e);for(let e=0;e<t.length-1;e++){const i=(r+e)%(t.length-1),s=t[i],n=t[i+1];Math.abs(s.x-n.x)>.5&&(s.x<n.x?(s.x+=1,0===i&&(t[t.length-1].x+=1)):(n.x+=1,i+1===t.length-1&&(t[0].x+=1)),o=!0);}const n=e.av(i.center.lng);return o&&n<Math.abs(n-1)&&t.forEach((e=>{e.x-=1;})),{polygon:t,unwrapped:o}}(Ke(t,i).map((t=>new e.P(Ye(t.x),t.y))),i);return {polygon:s.polygon.map((t=>new e.ac(t.x,t.y))),unwrapped:s.unwrapped}}}function Ke(t,i){return e.ax(t,(e=>{const t=i.pointCoordinate3D(e);e.x=t.x,e.y=t.y;}),1/256)}function Ye(e){return e<0?1+e%1:e%1}function Je(e){return 100*e|0}function Qe(t,i,o,s,r){const n=function(o,s){if(o)return r(o);if(s){if(t.url&&s.tiles&&t.tiles&&delete t.tiles,s.variants){if(!Array.isArray(s.variants))return r(new Error("variants must be an array"));for(const t of s.variants){if(null==t||"object"!=typeof t||t.constructor!==Object)return r(new Error("variant must be an object"));if(!Array.isArray(t.capabilities))return r(new Error("capabilities must be an array"));if(1===t.capabilities.length&&"meshopt"===t.capabilities[0]){s=e.l(s,t);break}}}const o=e.aA(e.l({},s,t),["tilejson","tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding","vector_layers","raster_layers","worldview_options","worldview_default","worldview"]);o.tiles=i.canonicalizeTileset(o,t.url),r(null,o);}},a=function(e,t,i){if(!e)return null;if(!t&&!i)return e;i=i||e.worldview_default;const o=Object.values(e.language||{});if(0===o.length)return null;const s=Object.values(e.worldview||{});if(0===s.length)return null;const r=o.every((e=>e===t)),n=s.every((e=>e===i));return r&&n?e:t in(e.language_options||{})||i in(e.worldview_options||{})?null:e.language_options&&e.worldview_options?e:null}(t.data,o,s);return a?e.q.frame((()=>n(null,a))):t.url?e.n(i.transformRequest(i.normalizeSourceURL(t.url,null,o,s),e.R.Source),n):e.q.frame((()=>{const{data:e,...i}=t;n(null,i);}))}class et{constructor(t,i,o){this.bounds=e.aB.convert(this.validateBounds(t)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),o=Math.floor(e.av(this.bounds.getWest())*i),s=Math.floor(e.aC(this.bounds.getNorth())*i),r=Math.ceil(e.av(this.bounds.getEast())*i),n=Math.ceil(e.aC(this.bounds.getSouth())*i);return t.x>=o&&t.x<r&&t.y>=s&&t.y<n}}class tt extends e.E{constructor(t,i,o,s){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.l(this,e.aA(i,["url","scheme","tileSize","promoteId"])),this._options=e.l({type:"vector"},i),this._collectResourceTiming=!!i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(s),this._tileWorkers={},this._deduped=new e.aD;}load(t){this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=Qe(this._options,this.map._requestManager,i,o,((s,r)=>{if(this._tileJSONRequest=null,this._loaded=!0,s)i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.z(s));else if(r){if(e.l(this,r),this.hasWorldviews=!!r.worldview_options,r.worldview_default&&(this.worldviewDefault=r.worldview_default),r.vector_layers){this.vectorLayers=r.vector_layers,this.vectorLayerIds=[],this.localizableLayerIds=new Set;for(const e of r.vector_layers)this.vectorLayerIds.push(e.id),r.worldview&&r.worldview[e.source]&&this.localizableLayerIds.add(e.id);}r.bounds&&(this.tileBounds=new et(r.bounds,this.minzoom,this.maxzoom)),L(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}));}t&&t(s);}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.C(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.l({},this._options)}loadTile(t,i){const o=t.tileID.canonical.url(this.tiles,this.scheme),s=this.map._requestManager.normalizeTileURL(o),r=this.map._requestManager.transformRequest(s,e.R.Tile),n=this.map.style?this.map.style.getLut(this.scope):null,a=n?{image:n.image.clone()}:null,l={request:r,data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,lut:a,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,pixelRatio:e.q.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster,tessellationStep:this.map._tessellationStep,scaleFactor:this.map.getScaleFactor()};if(this.hasWorldviews&&e.f(o)&&(l.worldview=this.map.getWorldview()||this.worldviewDefault,l.localizableLayerIds=this.localizableLayerIds),l.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",l,c.bind(this));else if(t.actor=this._tileWorkers[s]=this._tileWorkers[s]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",l,c.bind(this),void 0,!0);else {const i=e.aE.call({deduped:this._deduped},l,((e,i)=>{e||!i?c.call(this,e):(l.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",l,c.bind(this),void 0,!0));}),!0);t.request={cancel:i};}function c(o,s){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(s&&s.resourceTiming&&(t.resourceTiming=s.resourceTiming),this.map._refreshExpiredTiles&&s&&t.setExpiryData(s),t.loadVectorData(s,this.map.painter),e.aF(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(e,t){e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class it extends e.E{constructor(t,i,o,s){super(),this.id=t,this.dispatcher=o,this.setEventedParent(s),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.l({type:"raster"},i),e.l(this,e.aA(i,["url","scheme","tileSize"]));}load(t){this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"})),this._tileJSONRequest=Qe(this._options,this.map._requestManager,null,null,((i,o)=>{this._tileJSONRequest=null,this._loaded=!0,i?this.fire(new e.z(i)):o&&(e.l(this,o),o.raster_layers&&(this.rasterLayers=o.raster_layers,this.rasterLayerIds=this.rasterLayers.map((e=>e.id))),o.bounds&&(this.tileBounds=new et(o.bounds,this.minzoom,this.maxzoom)),L(o.tiles),this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}))),t&&t(i);}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.C(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.l({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.q.devicePixelRatio>=2,s=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.o(this.map._requestManager.transformRequest(s,e.R.Tile),((o,s,r,n)=>(delete t.request,t.aborted?(t.state="unloaded",i(null)):o?(t.state="errored",i(o)):s?(this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:r,expires:n}),t.setTexture(s,this.map.painter),t.state="loaded",e.aF(this.dispatcher),void i(null)):i(null))));}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t&&t();}unloadTile(t,i){t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),i&&i();}hasTransition(){return !1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class ot extends it{constructor(t,i,o,s){super(t,i,o,s),this.type="raster-array",this.maxzoom=22,this.partial=!0,this._options=e.l({type:"raster-array"},i);}triggerRepaint(e){const t=this.map.painter._terrain,i=this.map.style.getSourceCache(this.id);t&&t.enabled&&i&&t._clearRenderCacheForTile(i.id,e.tileID),this.map.triggerRepaint();}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize),s=this.map._requestManager.transformRequest(o,e.R.Tile),r={request:s,uid:t.uid,tileID:t.tileID,type:this.type,source:this.id,scope:this.scope,partial:this.partial};t.source=this.id,t.scope=this.scope,t.requestParams=s,t.actor||(t.actor=this.dispatcher.getActor());const n=(e,o,s,r)=>{if(delete t.request,t.aborted)return t.state="unloaded",i(null);if(e){if("AbortError"===e.name)return;return t.state="errored",i(e)}if(this.map._refreshExpiredTiles&&o&&t.setExpiryData({cacheControl:s,expires:r}),this.partial)t.state="empty";else {if(!o)return i(null);t.state="loaded",t._isHeaderLoaded=!0,t._mrt=o;}i(null);};t.request=this.partial?t.fetchHeader(void 0,n.bind(this)):t.actor.send("loadTile",r,n.bind(this),void 0,!0);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(t,i){const o=t.texture;o&&o instanceof e.T?(t.destroy(!0),this.map.painter.saveTileTexture(o)):(t.destroy(),t.flushQueues(),t._isHeaderLoaded=!1,delete t._mrt,delete t.textureDescriptor),t.fbo&&(t.fbo.destroy(),delete t.fbo),delete t.request,delete t.requestParams,delete t.neighboringTiles,t.state="unloaded";}prepareTile(t,i,o){t._isHeaderLoaded&&("empty"!==t.state&&(t.state="reloading"),t.fetchBand(i,o,((i,o)=>{if(i)return t.state="errored",this.fire(new e.z(i)),void this.triggerRepaint(t);o&&(t._isHeaderLoaded=!0,t.setTexture(o,this.map.painter),t.state="loaded",this.triggerRepaint(t));})));}getInitialBand(e){if(!this.rasterLayers)return 0;const t=this.rasterLayers.find((({id:t})=>t===e)),i=t&&t.fields,o=i&&i.bands&&i.bands;return o?o[0]:0}getTextureDescriptor(t,i,o){if(!t)return;const s=i.sourceLayer||this.rasterLayerIds&&this.rasterLayerIds[0];if(!s)return;let r=null;i instanceof e.aI?r=i.paint.get("raster-array-band"):i instanceof e.aJ&&(r=i.paint.get("raster-particle-array-band"));const n=r||this.getInitialBand(s);if(null!=n)if(t.textureDescriptor){if(!t.updateNeeded(s,n)||o)return Object.assign({},t.textureDescriptor,{texture:t.texture})}else this.prepareTile(t,s,n);}getImages(t,i){const o=new Map;for(const s of t)for(const t of i){const[i,r]=t.split("/"),n=s.getLayer(i);if(!n)continue;if(!n.hasBand(r)||!n.hasDataForBand(r))continue;const{bytes:a,tileSize:l,buffer:c}=n.getBandView(r),h=l+2*c,d={data:new e.r({width:h,height:h},a),pixelRatio:2,sdf:!1,usvg:!1,version:0};o.set(t,d);}return o}}const st={vector:tt,raster:it,"raster-dem":class extends it{constructor(t,i,o,s){super(t,i,o,s),this.type="raster-dem",this.maxzoom=22,this._options=e.l({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function s(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.o(this.map._requestManager.transformRequest(o,e.R.Tile),function(o,r,n,a){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(r){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:n,expires:a});const i=ImageBitmap&&r instanceof ImageBitmap&&e.t(),o=1-(r.width-e.aG(r.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=i?r:e.q.getImageData(r,o),c={uid:t.uid,tileID:t.tileID,source:this.id,type:this.type,scope:this.scope,rawImageData:l,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadTile",c,s.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),s=(i.x-1+o)%o,r=0===i.x?t.wrap-1:t.wrap,n=(i.x+1+o)%o,a=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.aH(t.overscaledZ,r,i.z,s,i.y).key]={backfilled:!1},l[new e.aH(t.overscaledZ,a,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new e.aH(t.overscaledZ,r,i.z,s,i.y-1).key]={backfilled:!1},l[new e.aH(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.aH(t.overscaledZ,a,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.aH(t.overscaledZ,r,i.z,s,i.y+1).key]={backfilled:!1},l[new e.aH(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.aH(t.overscaledZ,a,i.z,n,i.y+1).key]={backfilled:!1}),l}},"raster-array":ot,geojson:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(s),this._data=i.data,this._options=e.l({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),void 0!==i.minzoom&&(this.minzoom=i.minzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const r=e.ai/this.tileSize;this.workerOptions=e.l({source:this.id,scope:this.scope,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*r,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*r,extent:e.ai,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.ai,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*r,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter,dynamic:i.dynamic},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}updateData(t){if(!this._options.dynamic)return this.fire(new e.z(new Error("Can't call updateData on a GeoJSON source with dynamic set to false.")));if("string"!=typeof t&&("Feature"===t.type&&(t={type:"FeatureCollection",features:[t]}),"FeatureCollection"!==t.type))return this.fire(new e.z(new Error("Data to update should be a feature or a feature collection.")));if(this._coalesce&&"string"!=typeof t&&"string"!=typeof this._data&&"FeatureCollection"===this._data.type){const e=new Map;for(const t of this._data.features)e.set(t.id,t);for(const i of t.features)e.set(i.id,i);this._data.features=[...e.values()];}else this._data=t;return this._updateWorkerData(!0),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,scope:this.scope,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(t=!1){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.A("dataloading",{dataType:"source"})),this._loaded=!1;const i=e.l({append:t},this.workerOptions);i.scope=this.scope;const o=this._data;"string"==typeof o?(i.request=this.map._requestManager.transformRequest(e.q.resolveURL(o),e.R.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(o),this._pendingLoad=this.actor.send(`${this.type}.loadData`,i,((i,o)=>{if(this._loaded=!0,this._pendingLoad=null,i)this.fire(new e.z(i));else {const i={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&o&&o.resourceTiming&&o.resourceTiming[this.id]&&(i.resourceTiming=o.resourceTiming[this.id]),t&&(this._partialReload=!0),this.fire(new e.A("data",i)),this._partialReload=!1,this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(t),this._coalesce=!1);}));}loaded(){return this._loaded}reload(){const t=e.C(this.id,this.scope);this.map.style.clearSource(t),this._updateWorkerData();}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor;const s=this.map.style?this.map.style.getLut(this.scope):null,r=s?{image:s.image.clone()}:null,n=this._partialReload,a={type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,lut:r,scope:this.scope,pixelRatio:e.q.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,brightness:this.map.style&&this.map.style.getBrightness()||0,scaleFactor:this.map.getScaleFactor(),partial:n};t.request=this.actor.send(o,a,((e,s)=>n&&!s?(t.state="loaded",i(null)):(delete t.request,t.destroy(),t.aborted?i(null):e?i(e):(t.loadVectorData(s,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e,t){this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}onRemove(e){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return e.l({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends e.aK{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.R.Source).url);e.aL(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.z(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.z(new e.V(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.T(t,this.video,i.RGBA8),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(t);}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:e.aK,model:class extends e.E{constructor(e,t,i,o){super(),this.id=e,this.type="model",this.models=[],this._loaded=!1,this._options=t;}load(){const t=[];for(const i in this._options.models){const o=this._options.models[i],s=e.aN(this.map._requestManager.transformRequest(o.uri,e.R.Model).url).then((t=>{if(!t)return;const s=e.aO(t),r=new e.aP(i,o.position,o.orientation,s);r.computeBoundsAndApplyParent(),this.models.push(r);})).catch((t=>{this.fire(new e.z(new Error(`Could not load model ${i} from ${o.uri}: ${t.message}`)));}));t.push(s);}return Promise.allSettled(t).then((()=>{this._loaded=!0,this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"}));})).catch((t=>{this.fire(new e.z(new Error(`Could not load models: ${t.message}`)));}))}onAdd(e){this.map=e,this.load();}hasTransition(){return !1}loaded(){return this._loaded}getModels(){return this.models}loadTile(e,t){}serialize(){return {type:"model"}}},"batched-model":class extends e.E{constructor(e,t,i,o){super(),this.type="batched-model",this.id=e,this.tileSize=512,this._options=t,this.tiles=this._options.tiles,this.maxzoom=t.maxzoom||19,this.minzoom=t.minzoom||0,this.roundZoom=!0,this.usedInConflation=!0,this.dispatcher=i,this.reparseOverscaled=!1,this.scheme="xyz",this._loaded=!1,this.setEventedParent(o);}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.C(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}load(t){this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map.getWorldview();this._tileJSONRequest=Qe(this._options,this.map._requestManager,i,o,((s,r)=>{this._tileJSONRequest=null,this._loaded=!0,s?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.z(s))):r&&(e.l(this,r),r.bounds&&(this.tileBounds=new et(r.bounds,this.minzoom,this.maxzoom)),L(r.tiles,this.map._requestManager._customAccessToken),this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}))),t&&t(s);}));}hasTransition(){return !1}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loaded(){return this._loaded}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),s={request:this.map._requestManager.transformRequest(o,e.R.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,showCollisionBoxes:this.map.showCollisionBoxes,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,pixelRatio:e.q.devicePixelRatio,promoteId:this.promoteId};if(t.actor&&"expired"!==t.state)if("loading"===t.state)t.reloadCallback=i;else {if(t.buckets){const e=Object.values(t.buckets);for(const t of e)t.dirty=!0;return void(t.state="loaded")}t.request=t.actor.send("reloadTile",s,r.bind(this));}else t.actor=this.dispatcher.getActor(),t.request=t.actor.send("loadTile",s,r.bind(this),void 0,!0);function r(e,o){return t.aborted?i(null):e&&404!==e.status?i(e):(this.map._refreshExpiredTiles&&o&&t.setExpiryData(o),t.loadModelData(o,this.map.painter),t.state="loaded",void i(null))}}serialize(){return e.l({},this._options)}},canvas:class extends e.aK{constructor(t,i,o,s){super(t,i,o,s),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.z(new e.V(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.z(new e.V(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.z(new e.V(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.z(new e.V(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.z(new e.V(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.z(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(e){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context;this.texture?!t&&!this._playing||this.texture instanceof e.aM||this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.T(i,this.canvas,i.gl.RGBA8,{premultiply:!0}),this._prepareData(i);}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}},custom:class extends e.E{constructor(t,i,o,s){super(),this.id=t,this.type="custom",this._dataType="raster",this._dispatcher=o,this._implementation=i,this.setEventedParent(s),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new e.z(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new e.z(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new et(this._implementation.bounds,this.minzoom,this.maxzoom)),i.update=this._update.bind(this),i.clearTiles=this._clearTiles.bind(this),i.coveringTiles=this._coveringTiles.bind(this),e.l(this,e.aA(i,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]));}serialize(){return e.aA(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new e.A("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}));}loaded(){return this._loaded}onAdd(t){this.map=t,this._loaded=!1,this.fire(new e.A("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(t),this.load();}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e);}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:o}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:o})}return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const{x:i,y:o,z:s}=e.tileID.canonical,r=new AbortController;e.request=Promise.resolve(this._implementation.loadTile({x:i,y:o,z:s},{signal:r.signal})).then(function(i){return delete e.request,e.aborted?(e.state="unloaded",t(null)):void 0===i?(e.state="errored",t(null)):null===i?(this.loadTileData(e,{width:this.tileSize,height:this.tileSize,data:null}),e.state="loaded",t(null)):function(e){return e instanceof ImageData||e instanceof HTMLCanvasElement||e instanceof ImageBitmap||e instanceof HTMLImageElement}(i)?(this.loadTileData(e,i),e.state="loaded",void t(null)):(e.state="errored",t(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((i=>{"AbortError"!==i.name&&(e.state="errored",t(i));})),e.request.cancel=()=>r.abort();}loadTileData(e,t){e.setTexture(t,this.map.painter);}unloadTile(t,i){if(t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),this._implementation.unloadTile){const{x:e,y:i,z:o}=t.tileID.canonical;this._implementation.unloadTile({x:e,y:i,z:o});}i&&i();}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t&&t();}hasTransition(){return !1}_coveringTiles(){return this.map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){const t=e.C(this.id,this.scope);this.map.style.clearSource(t);}_update(){this.fire(new e.A("data",{dataType:"source",sourceDataType:"content"}));}}},rt=function(t,i,o,s){const r=new st[i.type](t,i,o,s);if(r.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${r.id}`);return e.aQ(["load","abort","unload","serialize","prepare"],r),r};function nt(e,t,i=""){return `${i}:${t.id||""}:${t.layer.id}:${function(e){if("layerId"in e)return `layer:${e.layerId}`;{const{featuresetId:t,importId:i}=e;return `featureset:${t}${i?`:import:${i}`:""}`}}(e.target)}`}function at(e,t,i,o=""){if(e.uniqueFeatureID){const s=nt(e,t,o);if(i.has(s))return !0;i.add(s);}return !1}function lt(e,t,i,o,s=!1){const r=t.sourceCache.transform,n=t.sourceCache.tilesIn(e,t.has3DLayers,s);n.sort(dt);const a=[];for(const e of n){const n=e.tile.queryRenderedFeatures(t,e,i,o,r,s);Object.keys(n).length&&a.push({wrappedTileID:e.tile.tileID.wrapped().key,queryResults:n});}return 0===a.length?{}:function(e){const t={},i={};for(const o of e){const e=o.queryResults,s=o.wrappedTileID,r=i[s]=i[s]||{};for(const i in e){const o=e[i],s=r[i]=r[i]||{},n=t[i]=t[i]||[];for(const e of o)s[e.featureIndex]||(s[e.featureIndex]=!0,n.push(e));}}return t}(a)}function ct(e,t,i,o,s){const r={},n=o.queryRenderedSymbols(e),a=[];for(const e of Object.keys(n).map(Number))a.push(s[e]);a.sort(dt);for(const e of a){const o=e.featureIndex.lookupSymbolFeatures(n[e.bucketInstanceId],e.bucketIndex,e.sourceLayerIndex,t,i);for(const t in o){const i=r[t]=r[t]||[],s=o[t];s.sort(((t,i)=>{const o=e.featureSortOrder;if(o){const e=o.indexOf(t.featureIndex);return o.indexOf(i.featureIndex)-e}return i.featureIndex-t.featureIndex}));for(const e of s)i.push(e);}}return r}function ht(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],s={};for(let e=0;e<i.length;e++){const r=i[e],n=r.tileID.canonical.key;s[n]||(s[n]=!0,r.querySourceFeatures(o,t));}return o}function dt(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function ut(e,t){const i={};if(!t)return i;for(const o of e){const e=o.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){o.layers=e,o.stateDependentLayerIds&&(o.stateDependentLayers=o.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.fqid]=o;}}return i}const _t=32,pt=33,ft=new Uint16Array(8184);for(let e=0;e<2046;e++){let t=e+2,i=0,o=0,s=0,r=0,n=0,a=0;for(1&t?s=r=n=_t:i=o=a=_t;(t>>=1)>1;){const e=i+s>>1,l=o+r>>1;1&t?(s=i,r=o,i=n,o=a):(i=s,o=r,s=n,r=a),n=e,a=l;}const l=4*e;ft[l+0]=i,ft[l+1]=o,ft[l+2]=s,ft[l+3]=r;}const mt=new Uint16Array(2178),gt=new Uint8Array(1089),vt=new Uint16Array(1089);function yt(e){return 0===e?-.03125:32===e?.03125:0}const xt=(()=>({type:2,extent:e.ai,loadGeometry:()=>[[new e.P(0,0),new e.P(e.ai+1,0),new e.P(e.ai+1,e.ai+1),new e.P(0,e.ai+1),new e.P(0,0)]]}))();class bt{constructor(t,i,o,s,r){this.tileID=t,this.uid=e.aW(),this.uses=0,this.tileSize=i,this.tileZoom=o,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=r,s&&s.style&&(this._lastUpdatedBrightness=s.style.getBrightness()),this.expiredRequestCount=0,this.state="loading",s&&s.transform&&(this.projection=s.transform.projection);}registerFadeDuration(t){const i=t+this.timeAdded;i<e.q.now()||this.fadeEndTime&&i<this.fadeEndTime||(this.fadeEndTime=i);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=e.aR(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,i,o){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=ut(t.buckets,i.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.aY){if(this.hasSymbolBuckets=!0,!o)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.aY&&i.hasRTLText){this.hasRTLText=!0,e.aZ();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e],o=i.style.getOwnLayer(e);if(!o)continue;const s=o.queryRadius(t);this.queryPadding=Math.max(this.queryPadding,s);}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas),this._lastUpdatedBrightness=t.brightness;}else this.collisionBoxArray=new e.aX;}unloadVectorData(){if(this.hasData()){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}loadModelData(e,t,i){e&&(e.resourceTiming&&(this.resourceTiming=e.resourceTiming),this.buckets=Object.assign({},this.buckets,ut(e.buckets,t.style)),e.featureIndex&&(this.latestFeatureIndex=e.featureIndex));}getBucket(e){return this.buckets[e.fqid]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t);}const i=t.gl,o=this.imageAtlas;o&&!o.uploaded&&(this.imageAtlasTexture=new e.T(t,o.image,i.RGBA8,{useMipmap:!!o.patternPositions.size}),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new e.T(t,this.glyphAtlasImage,i.R8),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new e.T(t,this.lineAtlas.image,i.R8),this.lineAtlas.uploaded=!0);}prepare(e,t,i){if(this.imageAtlas&&this.imageAtlasTexture&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture,i),!t||!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData)return;const o=t.style.getBrightness();(this._lastUpdatedBrightness||o)&&(this._lastUpdatedBrightness&&o&&Math.abs(this._lastUpdatedBrightness-o)<.001||(this.updateBuckets(t,this._lastUpdatedBrightness!==o),this._lastUpdatedBrightness=o));}queryRenderedFeatures(t,i,o,s,r,n){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData&&!this.latestFeatureIndex.is3DTile)return {};const a=function(t,i){const o=e.ad.mat4.fromScaling([],[.5*t.width,.5*-t.height,1]);return e.ad.mat4.translate(o,o,[1,-1,0]),e.ad.mat4.multiply(o,o,t.calculateProjMatrix(i.toUnwrapped())),Float32Array.from(o)}(r,this.tileID);return this.latestFeatureIndex.query(t,{tilespaceGeometry:i,pixelPosMatrix:a,transform:s,availableImages:o,tileTransform:this.tileTransform})}querySourceFeatures(t,i){const o=this.latestFeatureIndex;if(!o||!o.rawTileData)return;const s=o.loadVTLayers(),r=i?i.sourceLayer:"",n=s._geojsonTileLayer||s[r];if(!n)return;const a=e.a_(i&&i.filter),{z:l,x:c,y:h}=this.tileID.canonical,d={z:l,x:c,y:h};for(let i=0;i<n.length;i++){const s=n.feature(i);if(a.needGeometry){const t=e.a$(s,!0);if(!a.filter(new e.aa(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new e.aa(this.tileID.overscaledZ),s))continue;const u=o.getId(s,r),_=new e.b0(s,l,c,h,u);_.tile=d,t.push(_);}}loaded(){return "loaded"===this.state||"errored"===this.state}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return !!this.imageAtlas&&!!this.imageAtlas.patternPositions.size}setExpiryData(t){const i=this.expirationTime;if(t.cacheControl){const i=e.b1(t.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const o=this.expirationTime-i;o?this.expirationTime=e+Math.max(o,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}refreshFeatureState(e){this.latestFeatureIndex&&(this.latestFeatureIndex.rawTileData||this.latestFeatureIndex.is3DTile)&&e&&this.updateBuckets(e);}updateBuckets(t,i){if(!this.latestFeatureIndex)return;if(!t.style)return;const o=this.latestFeatureIndex.loadVTLayers(),s=t.style.listImages(),r=t.style.getBrightness();for(const n in this.buckets){if(!t.style.hasLayer(n))continue;const a=this.buckets[n],l=a.layers[0],c=l.sourceLayer||"_geojsonTileLayer",h=o[c],d=t.style.getLayerSourceCache(l);let u={};d&&(u=d._state.getState(c,void 0));const _=this.imageAtlas?Object.fromEntries(this.imageAtlas.patternPositions):{},p=Object.keys(u).length>0&&!i;p&&!a.stateDependentLayers.length&&!i||a.update(u,h,s,_,p?a.stateDependentLayers:a.layers,i,r),(a instanceof e.b2||a instanceof e.b3)&&t._terrain&&t._terrain.enabled&&d&&a.uploadPending()&&t._terrain._clearRenderCacheForTile(d.id,this.tileID);const f=t&&t.style&&t.style.getOwnLayer(n);f&&(this.queryPadding=Math.max(this.queryPadding,f.queryRadius(a)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<e.q.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=e.q.now()+t;}setTexture(t,i){const o=i.context,s=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t):(this.texture=new e.T(o,t,s.RGBA8,{useMipmap:!0}),this.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE));}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,i){if(!i||"mercator"===i.name||this._tileDebugBuffer)return;const o=e.b4(xt,this.tileID.canonical,this.tileTransform)[0],s=new e.b5,r=new e.b6;for(let e=0;e<o.length;e++){const{x:t,y:i}=o[e];s.emplaceBack(t,i),r.emplaceBack(e);}r.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(r),this._tileDebugBuffer=t.createVertexBuffer(s,e.b7.members),this._tileDebugSegments=e.b8.simpleSegment(0,0,s.length,r.length);}_makeTileBoundsBuffers(t,i){if(this._tileBoundsBuffer||!i||"mercator"===i.name)return;const o=e.b4(xt,this.tileID.canonical,this.tileTransform)[0];let s,r;if(this.isRaster){const t=function(t,i){const o=e.aR(t,i),s=Math.pow(2,t.z);for(let r=0;r<pt;r++)for(let n=0;n<pt;n++){const a=e.aS((t.x+(n+yt(n))/_t)/s),l=e.aT((t.y+(r+yt(r))/_t)/s),c=i.project(a,l),h=r*pt+n;mt[2*h+0]=Math.round((c.x*o.scale-o.x)*e.ai),mt[2*h+1]=Math.round((c.y*o.scale-o.y)*e.ai);}gt.fill(0),vt.fill(0);for(let e=2045;e>=0;e--){const t=4*e,i=ft[t+0],o=ft[t+1],s=ft[t+2],r=ft[t+3],n=i+s>>1,a=o+r>>1,l=n+a-o,c=a+i-n,h=o*pt+i,d=r*pt+s,u=a*pt+n,_=Math.hypot((mt[2*h+0]+mt[2*d+0])/2-mt[2*u+0],(mt[2*h+1]+mt[2*d+1])/2-mt[2*u+1])>=16;gt[u]=gt[u]||(_?1:0),e<1022&&(gt[u]=gt[u]||gt[(o+c>>1)*pt+(i+l>>1)]||gt[(r+c>>1)*pt+(s+l>>1)]);}const r=new e.aU,n=new e.aV;let a=0;function l(t,i){const o=i*pt+t;return 0===vt[o]&&(r.emplaceBack(mt[2*o+0],mt[2*o+1],t*e.ai/_t,i*e.ai/_t),vt[o]=++a),vt[o]-1}function c(e,t,i,o,s,r){const a=e+i>>1,h=t+o>>1;if(Math.abs(e-s)+Math.abs(t-r)>1&&gt[h*pt+a])c(s,r,e,t,a,h),c(i,o,s,r,a,h);else {const a=l(e,t),c=l(i,o),h=l(s,r);n.emplaceBack(a,c,h);}}return c(0,0,_t,_t,_t,0),c(_t,_t,0,0,0,_t),{vertices:r,indices:n}}(this.tileID.canonical,i);s=t.vertices,r=t.indices;}else {s=new e.aU,r=new e.aV;for(const{x:e,y:t}of o)s.emplaceBack(e,t,0,0);const t=e.b9(s.int16,void 0,4);for(let e=0;e<t.length;e+=3)r.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(s,e.ba.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(r),this._tileBoundsSegments=e.b8.simpleSegment(0,0,s.length,r.length);}_makeGlobeTileDebugBuffers(t,i){const o=i.projection;if(!o||"globe"!==o.name||i.freezeTileCoverage)return;const s=this.tileID.canonical,r=e.bb(s,i),n=e.bc(r),a=e.ag(i.zoom);let l;a>0&&(l=e.ad.mat4.invert(new Float64Array(16),i.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(t,s,i,n,l,a),this._makeGlobeTileDebugTextBuffer(t,s,i,n,l,a);}_globePoint(t,i,o,s,r,n,a){let l=e.bd(t,i,o);if(n){const r=1<<o.z,c=e.av(s.center.lng),h=e.aC(s.center.lat),d=(o.x+.5)/r-c;let u=0;d>.5?u=-1:d<-.5&&(u=1);let _=(t/e.ai+o.x)/r+u,p=(i/e.ai+o.y)/r;_=(_-c)*s._pixelsPerMercatorPixel+c,p=(p-h)*s._pixelsPerMercatorPixel+h;const f=[_*s.worldSize,p*s.worldSize,0];e.ad.vec3.transformMat4(f,f,n),l=e.be(l,f,a);}return e.ad.vec3.transformMat4(l,l,r)}_makeGlobeTileDebugBorderBuffer(t,i,o,s,r,n){const a=new e.b5,l=new e.b6,c=new e.bf,h=(e,t,h,d,u)=>{const _=(h-e)/(u-1),p=(d-t)/(u-1),f=a.length;for(let h=0;h<u;h++){const d=e+h*_,u=t+h*p;a.emplaceBack(d,u);const m=this._globePoint(d,u,i,o,s,r,n);c.emplaceBack(m[0],m[1],m[2]),l.emplaceBack(f+h);}},d=e.ai;h(0,0,d,0,16),h(d,0,d,d,16),h(d,d,0,d,16),h(0,d,0,0,16),this._tileDebugIndexBuffer=t.createIndexBuffer(l),this._tileDebugBuffer=t.createVertexBuffer(a,e.b7.members),this._globeTileDebugBorderBuffer=t.createVertexBuffer(c,e.bg.members),this._tileDebugSegments=e.b8.simpleSegment(0,0,a.length,l.length);}_makeGlobeTileDebugTextBuffer(t,i,o,s,r,n){const a=e.ai/4,l=new e.b5,c=new e.aV,h=new e.bf,d=25;c.reserve(32),l.reserve(d),h.reserve(d);const u=(e,t)=>d*e+t;for(let e=0;e<d;e++){const t=e*a;for(let e=0;e<d;e++){const c=e*a;l.emplaceBack(c,t);const d=this._globePoint(c,t,i,o,s,r,n);h.emplaceBack(d[0],d[1],d[2]);}}for(let e=0;e<4;e++)for(let t=0;t<4;t++){const i=u(e,t),o=u(e,t+1),s=u(e+1,t),r=u(e+1,t+1);c.emplaceBack(i,o,s),c.emplaceBack(s,o,r);}this._tileDebugTextIndexBuffer=t.createIndexBuffer(c),this._tileDebugTextBuffer=t.createVertexBuffer(l,e.b7.members),this._globeTileDebugTextBuffer=t.createVertexBuffer(h,e.bg.members),this._tileDebugTextSegments=e.b8.simpleSegment(0,0,d,32);}destroy(t=!1){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&(this.imageAtlasTexture.destroy(),delete this.imageAtlasTexture),this.glyphAtlasTexture&&(this.glyphAtlasTexture.destroy(),delete this.glyphAtlasTexture),this.lineAtlasTexture&&(this.lineAtlasTexture.destroy(),delete this.lineAtlasTexture),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),!t&&this.texture&&this.texture instanceof e.T&&(this.texture.destroy(),delete this.texture),this.hillshadeFBO&&(this.hillshadeFBO.destroy(),delete this.hillshadeFBO),this.dem&&delete this.dem,this.neighboringTiles&&delete this.neighboringTiles,this.demTexture&&(this.demTexture.destroy(),delete this.demTexture),this.rasterParticleState&&(this.rasterParticleState.destroy(),delete this.rasterParticleState),this.latestFeatureIndex=null,this.state="unloaded";}}e.bh.setPbf(e.bi);class wt extends bt{constructor(e,t,i,o,s){super(e,t,i,o,s),this._workQueue=[],this._fetchQueue=[],this._isHeaderLoaded=!1;}getLayers(){return this._mrt?Object.values(this._mrt.layers):[]}getLayer(e){return this._mrt&&this._mrt.getLayer(e)}setTexture(t,i){const o=i.context,s=o.gl;this.texture=this.texture||i.getTileTexture(t.width),this.texture&&this.texture instanceof e.T?this.texture.update(t,{premultiply:!1}):this.texture=new e.T(o,t,s.RGBA8,{premultiply:!1});}flushQueues(){for(;this._workQueue.length;)this._workQueue.pop()();for(;this._fetchQueue.length;)this._fetchQueue.pop()();}fetchHeader(t=16384,i){const o=this._mrt=new e.bh(30),s=Object.assign({},this.requestParams,{headers:{Range:"bytes=0-"+(t-1)}});return this.entireBuffer=null,this.request=e.bj(s,((e,s,r,n)=>{if(e)i(e);else try{const e=o.getHeaderLength(s);if(e>t)return void(this.request=this.fetchHeader(e,i));o.parseHeader(s),this._isHeaderLoaded=!0;let a=0;for(const e of Object.values(o.layers))a=Math.max(a,e.dataIndex[e.dataIndex.length-1].lastByte);s.byteLength>=a&&(this.entireBuffer=s),i(null,this.entireBuffer||s,r,n);}catch(e){i(e);}})),this.request}fetchBand(t,i,o){const s=this._mrt;if(!this._isHeaderLoaded||!s)return void o(new Error("Tile header is not ready"));const r=this.actor;if(!r)return void o(new Error("Can't fetch tile band without an actor"));let n;const a=(e,s)=>{n.complete(e,s),e?o(e):(this.updateTextureDescriptor(t,i),o(null,this.textureDescriptor&&this.textureDescriptor.img));},l=(e,t)=>{if(e)return o(e);const i=r.send("decodeRasterArray",{type:"raster-array",source:this.source,scope:this.scope,tileID:this.tileID,uid:this.uid,buffer:t,task:n},a,void 0,!0);this._workQueue.push((()=>{i&&i.cancel(),n.cancel();}));},c=s.getLayer(t);if(!c)return void o(new Error(`Unknown sourceLayer "${t}"`));if(c.hasDataForBand(i))return this.updateTextureDescriptor(t,i),void o(null,this.textureDescriptor?this.textureDescriptor.img:null);const h=c.getDataRange([i]);if(n=s.createDecodingTask(h),!n||n.tasks.length)if(this.flushQueues(),this.entireBuffer)l(null,this.entireBuffer.slice(h.firstByte,h.lastByte+1));else {const t=Object.assign({},this.requestParams,{headers:{Range:`bytes=${h.firstByte}-${h.lastByte}`}}),i=e.bj(t,l);this._fetchQueue.push((()=>{i.cancel(),n.cancel();}));}else o(null);}updateNeeded(e,t){return (!this.textureDescriptor||this.textureDescriptor.band!==t||this.textureDescriptor.layer!==e)&&"errored"!==this.state}updateTextureDescriptor(t,i){if(!this._mrt)return;const o=this._mrt.getLayer(t);if(!o||!o.hasBand(i)||!o.hasDataForBand(i))return;const{bytes:s,tileSize:r,buffer:n,offset:a,scale:l}=o.getBandView(i),c=r+2*n,h=new e.r({width:c,height:c},s),d=this.texture;d&&d instanceof e.T&&d.update(h,{premultiply:!1}),this.textureDescriptor={layer:t,band:i,img:h,buffer:n,offset:a,tileSize:r,format:o.pixelFormat,mix:[l,256*l,65536*l,16777216*l]};}}class Tt{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const o=e.wrapped().key;void 0===this.data[o]&&(this.data[o]=[]);const s={value:t,timeout:void 0};if(void 0!==i&&(s.timeout=setTimeout((()=>{this.remove(e,s);}),i)),this.data[o].push(s),this.order.push(o),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,o=void 0===t?0:this.data[i].indexOf(t),s=this.data[i][o];return this.data[i].splice(o,1),s.timeout&&clearTimeout(s.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(s.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const i in this.data)for(const o of this.data[i])e(o.value)||t.push(o);for(const e of t)this.remove(e.value.tileID,e);}}class Et{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,i,o){const s=String(i);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][s]=this.stateChanges[t][s]||{},e.l(this.stateChanges[t][s],o),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==s&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][s]){this.deletedStates[t][s]={};for(const e in this.state[t][s])o[e]||(this.deletedStates[t][s][e]=null);}else for(const e in o)this.deletedStates[t]&&this.deletedStates[t][s]&&null===this.deletedStates[t][s][e]&&delete this.deletedStates[t][s][e];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const o=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][o]&&(this.deletedStates[e][o]=this.deletedStates[e][o]||{},this.deletedStates[e][o][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][o])for(i in this.deletedStates[e][o]={},this.stateChanges[e][o])this.deletedStates[e][o][i]=null;else this.deletedStates[e][o]=null;else this.deletedStates[e]=null;}getState(t,i){const o=this.state[t]||{},s=this.stateChanges[t]||{},r=this.deletedStates[t];if(null===r)return {};if(void 0!==i){const t=String(i),n=e.l({},o[t],s[t]);if(r){const e=r[i];if(null===e)return {};for(const t in e)delete n[t];}return n}const n=e.l({},o,s);if(r)for(const e in r)delete n[e];return n}initializeTileState(e,t){e.refreshFeatureState(t);}coalesceChanges(t,i){const o={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const i={};for(const o in this.stateChanges[t])this.state[t][o]||(this.state[t][o]={}),e.l(this.state[t][o],this.stateChanges[t][o]),i[o]=this.state[t][o];o[t]=i;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const i={};if(null===this.deletedStates[t])for(const e in this.state[t])i[e]={},this.state[t][e]={};else for(const e in this.deletedStates[t]){if(null===this.deletedStates[t][e])this.state[t][e]={};else if(this.state[t][e])for(const i of Object.keys(this.deletedStates[t][e]))delete this.state[t][e][i];i[e]=this.state[t][e];}o[t]=o[t]||{},e.l(o[t],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(o).length)for(const e in t)t[e].refreshFeatureState(i);}}class St extends e.E{constructor(e,t,i){super(),this.id=e,this._onlySymbols=i,t.on("data",(e=>{"source"===e.dataType&&"metadata"===e.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===e.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),t.on("error",(()=>{this._sourceErrored=!0;})),this._source=t,this._tiles={},this._cache=new Tt(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._loadedParentTiles={},this.castsShadows=!1,this.tileCoverLift=0,this._coveredTiles={},this._shadowCasterTiles={},this._state=new Et,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"raster-array"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType;}onAdd(e){this.map=e,this._minTileCacheSize=void 0===this._minTileCacheSize&&e?e._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&e?e._maxTileCacheSize:this._maxTileCacheSize;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const e in this._tiles)if(!this._tiles[e].loaded())return !1;return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(e,t){return e.isSymbolTile=this._onlySymbols,e.isExtraShadowCaster=this._shadowCasterTiles[e.tileID.key],this._source.loadTile(e,t)}_unloadTile(e){if(this._source.unloadTile)return this._source.unloadTile(e)}_abortTile(e){if(this._source.abortTile)return this._source.abortTile(e)}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager,this.map?this.map.painter:null,this._source.scope);}}getIds(){return Object.values(this._tiles).map((e=>e.tileID)).sort(Ct).map((e=>e.key))}getRenderableIds(t,i){const o=[];for(const e in this._tiles)this._isIdRenderable(+e,t,i)&&o.push(this._tiles[e]);return t?o.sort(((t,i)=>{const o=t.tileID,s=i.tileID,r=new e.P(o.canonical.x,o.canonical.y)._rotate(this.transform.angle),n=new e.P(s.canonical.x,s.canonical.y)._rotate(this.transform.angle);return o.overscaledZ-s.overscaledZ||n.y-r.y||n.x-r.x})).map((e=>e.tileID.key)):o.map((e=>e.tileID)).sort(Ct).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return !!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t,i){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())&&(i||!this._shadowCasterTiles[e])}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const e in this._tiles)"errored"!==this._tiles[e].state&&this._reloadTile(+e,"reloading");}}_reloadTile(e,t){const i=this._tiles[e];i&&("loading"!==i.state&&(i.state=t),this._loadTile(i,this._tileLoaded.bind(this,i,e,t)));}_tileLoaded(t,i,o,s){if(s)if(t.state="errored",404!==s.status)this._source.fire(new e.z(s,{tile:t}));else {if(this._source.fire(new e.A("data",{dataType:"source",sourceDataType:"error",sourceId:this._source.id,tile:t})),!(t.tileID.key in this._loadedParentTiles))return;if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const e=this.map.painter.terrain;this.update(this.transform,e.getScaledDemTileSize(),!0),e.resetTileLookupCache(this.id);}else this.update(this.transform);}else t.timeAdded=e.q.now(),"expired"===o&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(i,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new e.A("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(e){const t=this.getRenderableIds();for(let o=0;o<t.length;o++){const s=t[o];if(e.neighboringTiles&&e.neighboringTiles[s]){const t=this.getTileByID(s);i(e,t),i(t,e);}}function i(e,t){if(!e.dem||e.dem.borderReady)return;e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const o=t.tileID.canonical.y-e.tileID.canonical.y,s=Math.pow(2,e.tileID.canonical.z),r=t.tileID.key;0===i&&0===o||Math.abs(o)>1||(Math.abs(i)>1&&(1===Math.abs(i+s)?i+=s:1===Math.abs(i-s)&&(i-=s)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,o),e.neighboringTiles&&e.neighboringTiles[r]&&(e.neighboringTiles[r].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,o){for(const s in this._tiles){let r=this._tiles[s];if(o[s]||!r.hasData()||r.tileID.overscaledZ<=t||r.tileID.overscaledZ>i)continue;let n=r.tileID;for(;r&&r.tileID.overscaledZ>t+1;){const e=r.tileID.scaledTo(r.tileID.overscaledZ-1);r=this._tiles[e.key],r&&r.hasData()&&(n=e);}let a=n;for(;a.overscaledZ>t;)if(a=a.scaledTo(a.overscaledZ-1),e[a.key]){o[n.key]=n;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),o=this._getLoadedTile(t);if(o)return o}}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(this._source.reparseOverscaled?e.wrapped().key:e.canonical.key)}updateCacheSize(e,t){t=t||this._source.tileSize;const i=Math.ceil(e.width/t)+1,o=Math.ceil(e.height/t)+1,s=Math.floor(i*o*5),r="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,s):s,n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(n);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const o=this._tiles[i];o.tileID=o.tileID.unwrapTo(o.tileID.wrap+t),e[o.tileID.key]=o;}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(+e,this._tiles[e]);}}update(t,i,o,s){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!o)return;this.updateCacheSize(t,i),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._shadowCasterTiles={},this._coveredTiles={};const r="batched-model"===this._source.type;let n,a=this._source.maxzoom;const l=this.map&&this.map.painter?this.map.painter._terrain:null;if(l&&l.sourceCache===this&&l.attenuationRange()){const e=l.attenuationRange()[0],t=Math.floor(e)-Math.log2(l.getDemUpscale());a>t&&(a=t);}if(this.used||this.usedForTerrain){if(this._source.tileID)n=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new e.aH(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)));else if(0!==this.tileCoverLift){const s=t.clone();s.tileCoverLift=this.tileCoverLift,n=s.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:a,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:r}),this._source.minzoom<=1&&"globe"===t.projection.name&&(n.push(new e.aH(1,0,1,0,0)),n.push(new e.aH(1,0,1,1,0)),n.push(new e.aH(1,0,1,0,1)),n.push(new e.aH(1,0,1,1,1)));}else if(n=t.coveringTiles({tileSize:i||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:a,roundZoom:this._source.roundZoom&&!o,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain,calculateQuadrantVisibility:r}),this._source.hasTile){const e=this._source.hasTile.bind(this._source);n=n.filter((t=>e(t)));}}else n=[];if(n.length>0&&this.castsShadows&&s&&"globe"!==this.transform.projection.name&&!this.usedForTerrain&&!It(this._source.type)){const e=t.coveringZoomLevel({tileSize:i||this._source.tileSize,roundZoom:this._source.roundZoom&&!o}),a=Math.min(e,this._source.maxzoom);if(r){const e=t.extendTileCover(n,a);for(const t of e)n.push(t);}else {const e=t.extendTileCover(n,a,s);for(const t of e)this._shadowCasterTiles[t.key]=!0,n.push(t);}}const c=this._updateRetainedTiles(n);if(It(this._source.type)&&0!==n.length){const t={},i={},o=Object.keys(c);for(const s of o){const o=c[s],r=this._tiles[s];if(!r||r.fadeEndTime&&r.fadeEndTime<=e.q.now())continue;const n=this.findLoadedParent(o,Math.max(o.overscaledZ-St.maxOverzooming,this._source.minzoom));n&&(this._addTile(n.tileID),t[n.tileID.key]=n.tileID),i[s]=o;}const s=n[n.length-1].overscaledZ;for(const e in this._tiles){const t=this._tiles[e];if(c[e]||!t.hasData())continue;let o=t.tileID;for(;o.overscaledZ>s;){o=o.scaledTo(o.overscaledZ-1);const s=this._tiles[o.key];if(s&&s.hasData()&&i[o.key]){c[e]=t.tileID;break}}}for(const e in t)c[e]||(this._coveredTiles[e]=!0,c[e]=t[e]);}for(const e in c)this._tiles[e].clearFadeHold();const h=e.bk(this._tiles,c);for(const e of h){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(+e);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(+e);}_updateRetainedTiles(e){const t={};if(0===e.length)return t;const i={},o=e.reduce(((e,t)=>Math.min(e,t.overscaledZ)),1/0),s=e[0].overscaledZ,r=Math.max(s-St.maxOverzooming,this._source.minzoom),n=Math.max(s+St.maxUnderzooming,this._source.minzoom),a={};for(const i of e){const e=this._addTile(i);t[i.key]=i,e.hasData()||o<this._source.maxzoom&&(a[i.key]=i);}this._retainLoadedChildren(a,o,n,t);for(const o of e){let e=this._tiles[o.key];if(e.hasData())continue;if(o.canonical.z>=this._source.maxzoom){const e=o.children(this._source.maxzoom)[0],i=this.getTile(e);if(i&&i.hasData()){t[e.key]=e;continue}}else {const e=o.children(this._source.maxzoom);if(t[e[0].key]&&t[e[1].key]&&t[e[2].key]&&t[e[3].key])continue}let s=e.wasRequested();for(let n=o.overscaledZ-1;n>=r;--n){const r=o.scaledTo(n);if(i[r.key])break;if(i[r.key]=!0,e=this.getTile(r),!e&&s&&(e=this._addTile(r)),e&&(t[r.key]=r,s=e.wasRequested(),e.hasData()))break}}return t}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,o=this._tiles[e].tileID;for(;o.overscaledZ>0;){if(o.key in this._loadedParentTiles){i=this._loadedParentTiles[o.key];break}t.push(o.key);const e=o.scaledTo(o.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;o=e;}for(const e of t)this._loadedParentTiles[e]=i;}}_addTile(t){let i=this._tiles[t.key];if(i)return !0!==i.isExtraShadowCaster||!!this._shadowCasterTiles[t.key]||this._reloadTile(t.key,"reloading"),i;i=this._cache.getAndRemove(t),i&&(this._setTileReloadTimer(t.key,i),i.tileID=t,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,i)));const o=Boolean(i);if(!o){const e=this.map?this.map.painter:null,o=this._source.tileSize*t.overscaleFactor();i="raster-array"===this._source.type?new wt(t,o,this.transform.tileZoom,e,this._isRaster):new bt(t,o,this.transform.tileZoom,e,this._isRaster),this._loadTile(i,this._tileLoaded.bind(this,i,t.key,i.state));}return i?(i.uses++,this._tiles[t.key]=i,o||this._source.fire(new e.A("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i):null}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state||"empty"===t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(+e);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id);}tilesIn(t,i,o){const s=[],r=this.transform;if(!r)return s;const n="globe"===r.projection.name,a=e.av(r.center.lng);for(const l in this._tiles){const c=this._tiles[l];if(o&&c.clearQueryDebugViz(),c.holdingForFade())continue;let h;if(n){const t=c.tileID.canonical;if(0===t.z){const i=[Math.abs(e.ay(a,...Rt(t,-1))-a),Math.abs(e.ay(a,...Rt(t,1))-a)];h=[0,2*i.indexOf(Math.min(...i))-1];}else {const i=[Math.abs(e.ay(a,...Rt(t,-1))-a),Math.abs(e.ay(a,...Rt(t,0))-a),Math.abs(e.ay(a,...Rt(t,1))-a)];h=[i.indexOf(Math.min(...i))-1];}}else h=[0];for(const e of h){const o=t.containsTile(c,r,i,e);o&&s.push(o);}}return s}getShadowCasterCoordinates(){return this._getRenderableCoordinates(!1,!0)}getVisibleCoordinates(e){return this._getRenderableCoordinates(e)}_getRenderableCoordinates(e,t){const i=this.getRenderableIds(e,t).map((e=>this._tiles[e].tileID)),o="globe"===this.transform.projection.name;for(const e of i)e.projMatrix=this.transform.calculateProjMatrix(e.toUnwrapped()),e.expandedProjMatrix=o?this.transform.calculateProjMatrix(e.toUnwrapped(),!1,!0):e.projMatrix;return i}sortCoordinatesByDistance(e){const t=e.slice(),i=this.transform._camera.position,o=this.transform._camera.forward(),s={};for(const e of t){const t=1/(1<<e.canonical.z);s[e.key]=((e.canonical.x+.5)*t+e.wrap-i[0])*o[0]+((e.canonical.y+.5)*t-i[1])*o[1]-i[2]*o[2];}return t.sort(((e,t)=>s[e.key]-s[t.key])),t}hasTransition(){if(this._source.hasTransition())return !0;if(It(this._source.type))for(const t in this._tiles){const i=this._tiles[t];if(void 0!==i.fadeEndTime&&i.fadeEndTime>=e.q.now())return !0}return !1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i);}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i);}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const o=this._tiles[e];o&&o.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(+i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}_preloadTiles(t,i){if(!this._sourceLoaded){const e=()=>{this._sourceLoaded&&(this._source.off("data",e),this._preloadTiles(t,i));};return void this._source.on("data",e)}const o=new Map,s=Array.isArray(t)?t:[t],r=this.map.painter.terrain,n=this.usedForTerrain&&r?r.getScaledDemTileSize():this._source.tileSize;for(const e of s){const t=e.coveringTiles({tileSize:n,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const e of t)o.set(e.key,e);this.usedForTerrain&&e.updateElevation(!1);}const a=Array.from(o.values());e.bl(a,((e,t)=>{const i=new bt(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster);this._loadTile(i,(e=>{"raster-dem"===this._source.type&&i.dem&&this._backfillDEM(i),t(e,i);}));}),i);}}function Ct(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),o=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||o-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function It(e){return "raster"===e||"image"===e||"video"===e||"custom"===e}function Rt(e,t){const i=1<<e.z;return [e.x/i+t,(e.x+1)/i+t]}St.maxOverzooming=10,St.maxUnderzooming=3;class Dt{constructor(e){this.style=e,this.layersGotHidden=!1,this.layers=[];}processLayersChanged(){this.layers=[];const e=!1,t=!1;for(const i in this.style._mergedLayers){const o=this.style._mergedLayers[i];if("fill-extrusion"===o.type)this.layers.push({layer:o,visible:e,visibilityChanged:t});else if("model"===o.type){const i=this.style.getLayerSource(o);i&&"batched-model"===i.type&&this.layers.push({layer:o,visible:e,visibilityChanged:t});}}}onNewFrame(e){this.layersGotHidden=!1;for(const t of this.layers){const i=t.layer;let o=!1;"fill-extrusion"===i.type?o=!i.isHidden(e)&&i.paint.get("fill-extrusion-opacity")>0:"model"===i.type&&(o=!i.isHidden(e)&&i.paint.get("model-opacity").constantOr(1)>0),this.layersGotHidden=this.layersGotHidden||!o&&t.visible,t.visible=o;}}updateZOffset(e,t){this.currentBuildingBuckets=[];for(const e of this.layers){const i=e.layer,o=this.style.getLayerSourceCache(i);let s=1;"fill-extrusion"===i.type&&(s=e.visible?i.paint.get("fill-extrusion-vertical-scale"):0);let r=o?o.getTile(t):null;if(!r&&o&&t.canonical.z>o.getSource().minzoom){let e=t.scaledTo(Math.min(o.getSource().maxzoom,t.overscaledZ-1));for(;e.overscaledZ>=o.getSource().minzoom&&(r=o.getTile(e),!r&&0!==e.overscaledZ);)e=e.scaledTo(e.overscaledZ-1);}this.currentBuildingBuckets.push({bucket:r?r.getBucket(i):null,tileID:r?r.tileID:t,verticalScale:s});}e.hasAnyZOffset=!1;let i=!1;for(let o=0;o<e.symbolInstances.length;o++){const s=e.symbolInstances.get(o),r=s.zOffset,n=this._getHeightAtTileOffset(t,s.tileAnchorX,s.tileAnchorY);s.zOffset=n!==Number.NEGATIVE_INFINITY?n:r,i||r===s.zOffset||(i=!0),e.hasAnyZOffset||0===s.zOffset||(e.hasAnyZOffset=!0);}i&&(e.zOffsetBuffersNeedUpload=!0,e.zOffsetSortDirty=!0);}_mapCoordToOverlappingTile(t,i,o,s){let r=i,n=o;if(t.canonical.z!==s.canonical.z){const a=s.canonical,l=1/(1<<t.canonical.z-a.z);r=(i+t.canonical.x*e.ai)*l-a.x*e.ai|0,n=(o+t.canonical.y*e.ai)*l-a.y*e.ai|0;}return {tileX:r,tileY:n}}_getHeightAtTileOffset(e,t,i){let o,s;for(let r=0;r<this.layers.length;++r){if("fill-extrusion"!==this.layers[r].layer.type)continue;const{bucket:n,tileID:a,verticalScale:l}=this.currentBuildingBuckets[r];if(!n)continue;const{tileX:c,tileY:h}=this._mapCoordToOverlappingTile(e,t,i,a),d=n.getHeightAtTileCoord(c,h);d&&void 0!==d.height&&(d.hidden?o=d.height:s=Math.max(d.height*l,s||0));}if(void 0!==s)return s;for(let s=0;s<this.layers.length;++s){const r=this.layers[s];if("model"!==r.layer.type||!r.visible)continue;const{bucket:n,tileID:a}=this.currentBuildingBuckets[s];if(!n)continue;const{tileX:l,tileY:c}=this._mapCoordToOverlappingTile(e,t,i,a),h=n.getHeightAtTileCoord(l,c);if(h&&!h.hidden)return void 0===h.height&&void 0!==o?Math.min(h.maxHeight,o)*h.verticalScale:h.height?h.height*h.verticalScale:Number.NEGATIVE_INFINITY}return this.layersGotHidden?0:Number.NEGATIVE_INFINITY}}function At(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.bm.forEach((e=>{e in i&&(o[e]=i[e]);})),o}function Lt(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=At(e[i],t[e[i].ref]));return e}const Pt={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setSlot:"setSlot",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setSnow:"setSnow",setRain:"setRain",setCamera:"setCamera",setLights:"setLights",setProjection:"setProjection",addImport:"addImport",removeImport:"removeImport",updateImport:"updateImport",addIconset:"addIconset",removeIconset:"removeIconset"};function Mt(e,t,i){i.push({command:Pt.addSource,args:[e,t[e]]});}function zt(e,t,i){t.push({command:Pt.removeSource,args:[e]}),i[e]=!0;}function Ot(e,t,i,o){zt(e,i,o),Mt(e,t,i);}function Ft(t,i,o){let s;for(s in t[o])if(t[o].hasOwnProperty(s)&&"data"!==s&&!e.bn(t[o][s],i[o][s]))return !1;for(s in i[o])if(i[o].hasOwnProperty(s)&&"data"!==s&&!e.bn(t[o][s],i[o][s]))return !1;return !0}function kt(t,i,o,s,r,n){let a;for(a in i=i||{},t=t||{})t.hasOwnProperty(a)&&(e.bn(t[a],i[a])||o.push({command:n,args:[s,a,i[a],r]}));for(a in i)i.hasOwnProperty(a)&&!t.hasOwnProperty(a)&&(e.bn(t[a],i[a])||o.push({command:n,args:[s,a,i[a],r]}));}function Bt(e){return e.id}function Nt(e,t){return e[t.id]=t,e}class Ut{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.ay(t,0,1);let i=1,o=this._distances[i];const s=t*this.paddedLength+this.padding;for(;o<s&&i<this._distances.length;)o=this._distances[++i];const r=i-1,n=this._distances[r],a=o-n,l=a>0?(s-n)/a:0;return this.points[r].mult(1-l).add(this.points[i].mult(l))}}class Vt{constructor(e,t,i){const o=this.boxCells=[],s=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),s.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,s){this._forEachCell(t,i,o,s,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(s);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,s,r){this.boxCells[s].push(r);}_insertCircleCell(e,t,i,o,s,r){this.circleCells[s].push(r);}_query(e,t,i,o,s,r){if(i<0||e>this.width||o<0||t>this.height)return !s&&[];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(s)return !0;for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return r?n.filter(r):n}return this._forEachCell(e,t,i,o,this._queryCell,n,{hitTest:s,seenUids:{box:{},circle:{}}},r),s?n.length>0:n}_queryCircle(e,t,i,o,s){const r=e-i,n=e+i,a=t-i,l=t+i;if(n<0||r>this.width||l<0||a>this.height)return !o&&[];const c=[];return this._forEachCell(r,a,n,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},s),o?c.length>0:c}query(e,t,i,o,s){return this._query(e,t,i,o,!1,s)}hitTest(e,t,i,o,s){return this._query(e,t,i,o,!0,s)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,s,r,n,a){const l=n.seenUids,c=this.boxCells[s];if(null!==c){const s=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=s[c+2]&&t<=s[c+3]&&i>=s[c+0]&&o>=s[c+1]&&(!a||a(this.boxKeys[h]))){if(n.hitTest)return r.push(!0),!0;r.push({key:this.boxKeys[h],x1:s[c],y1:s[c+1],x2:s[c+2],y2:s[c+3]});}}}const h=this.circleCells[s];if(null!==h){const s=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(s[h],s[h+1],s[h+2],e,t,i,o)&&(!a||a(this.circleKeys[c]))){if(n.hitTest)return r.push(!0),!0;{const e=s[h],t=s[h+1],i=s[h+2];r.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,s,r,n,a){const l=n.circle,c=n.seenUids,h=this.boxCells[s];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!a||a(this.boxKeys[t])))return r.push(!0),!0}}const d=this.circleCells[s];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!a||a(this.circleKeys[t])))return r.push(!0),!0}}}_forEachCell(e,t,i,o,s,r,n,a){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),d=this._convertToYCellCoord(o);for(let u=l;u<=h;u++)for(let l=c;l<=d;l++)if(s.call(this,e,t,i,o,this.xCellCount*l+u,r,n,a))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,s,r){const n=o-e,a=s-t,l=i+r;return l*l>n*n+a*a}_circleAndRectCollide(e,t,i,o,s,r,n){const a=(r-o)/2,l=Math.abs(e-(o+a));if(l>a+i)return !1;const c=(n-s)/2,h=Math.abs(t-(s+c));if(h>c+i)return !1;if(l<=a||h<=c)return !0;const d=l-a,u=h-c;return d*d+u*u<=i*i}}const Gt={unknown:0,flipRequired:1,flipNotRequired:2},jt=Math.tan(85*Math.PI/180);function qt(t,i,o,s,r,n,a){const l=e.ad.mat4.create();if(o)if("globe"===n.name){const t=e.bo(r,i);e.ad.mat4.multiply(l,l,t);}else {const t=e.ad.mat2.invert([],a);l[0]=t[0],l[1]=t[1],l[4]=t[2],l[5]=t[3],s||e.ad.mat4.rotateZ(l,l,r.angle);}else e.ad.mat4.multiply(l,r.labelPlaneMatrix,t);return l}function Ht(e,t,i,o,s,r,n){const a=qt(e,t,i,o,s,r,n);return "globe"===r.name&&i||(a[2]=a[6]=a[10]=a[14]=0),a}function Zt(t,i,o,s,r,n,a){if(o){if("globe"===n.name){const l=qt(t,i,o,s,r,n,a);return e.ad.mat4.invert(l,l),e.ad.mat4.multiply(l,t,l),l}{const i=e.ad.mat4.clone(t),o=e.ad.mat4.identity([]);return o[0]=a[0],o[1]=a[1],o[4]=a[2],o[5]=a[3],e.ad.mat4.multiply(i,i,o),s||e.ad.mat4.rotateZ(i,i,-r.angle),i}}return r.glCoordMatrix}function Wt(t,i,o,s){const r=[t,i,o,1];o?e.ad.vec4.transformMat4(r,r,s):si(r,r,s);const n=r[3];return r[0]/=n,r[1]/=n,r[2]/=n,r}function $t(e,t){return Math.min(.5+e/t*.5,1.5)}function Xt(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function Kt(t,i,o,s,r,n,a,l,c,h){const d=o.transform,u=s?t.textSizeData:t.iconSizeData,_=e.bp(u,o.transform.zoom),p="globe"===d.projection.name,f=[256/o.width*2+1,256/o.height*2+1],m=s?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;m.clear();let g=null;p&&(g=s?t.text.globeExtVertexArray:t.icon.globeExtVertexArray);const v=t.lineVertexArray,y=s?t.text.placedSymbolArray:t.icon.placedSymbolArray,x=o.transform.width/o.transform.height;let b,w=!1;for(let s=0;s<y.length;s++){const p=y.get(s),{numGlyphs:T,writingMode:E}=p;if(E!==e.bq.vertical||w||b===e.bq.horizontal||(w=!0),b=E,(p.hidden||E===e.bq.vertical)&&!w){oi(T,m);continue}w=!1;const S=new e.P(p.tileAnchorX,p.tileAnchorY);let{x:C,y:I,z:R}=d.projection.projectTilePoint(S.x,S.y,h.canonical);if(c){const[e,t,i]=c(S);C+=e,I+=t,R+=i;}const D=[C,I,R,1];if(e.ad.vec4.transformMat4(D,D,i),!Xt(D,f)){oi(T,m);continue}const A=D[3],L=$t(o.transform.getCameraToCenterDistance(d.projection),A),P=e.br(u,_,p),M=a?P/L:P*L,z=Wt(C,I,R,r);if(z[3]<=0){oi(T,m);continue}let O={};const F=e.ak(t.layers[0].layout.get("text-max-angle")),k=Math.cos(F),B=a?null:c,N=Qt(p,M,!1,l,i,r,n,t.glyphOffsetArray,v,m,g,z,S,O,x,B,d.projection,h,a,k);w=N.useVertical,B&&N.needsFlipping&&(O={}),(N.notEnoughRoom||w||N.needsFlipping&&Qt(p,M,!0,l,i,r,n,t.glyphOffsetArray,v,m,g,z,S,O,x,B,d.projection,h,a,k).notEnoughRoom)&&oi(T,m);}s?(t.text.dynamicLayoutVertexBuffer.updateData(m),g&&t.text.globeExtVertexBuffer&&t.text.globeExtVertexBuffer.updateData(g)):(t.icon.dynamicLayoutVertexBuffer.updateData(m),g&&t.icon.globeExtVertexBuffer&&t.icon.globeExtVertexBuffer.updateData(g));}function Yt(e,t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m){const{lineStartIndex:g,glyphStartIndex:v,segment:y}=a,x=v+a.numGlyphs,b=g+a.lineLength,w=t.getoffsetX(v),T=t.getoffsetX(x-1),E=ii(e*w,i,o,s,r,n,y,g,b,l,c,h,d,u,!0,_,p,f,m);if(!E)return null;const S=ii(e*T,i,o,s,r,n,y,g,b,l,c,h,d,u,!0,_,p,f,m);return S?{first:E,last:S}:null}function Jt(t,i,o,s){return t===e.bq.horizontal&&Math.abs(s)>Math.abs(o)?{useVertical:!0}:t===e.bq.vertical?s>0?{needsFlipping:!0}:null:i!==Gt.unknown&&function(e,t){return 0===e||Math.abs(t/e)>jt}(o,s)?i===Gt.flipRequired?{needsFlipping:!0}:null:o<0?{needsFlipping:!0}:null}function Qt(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g,v,y,x){const b=i/24,w=t.lineOffsetX*b,T=t.lineOffsetY*b,{lineStartIndex:E,glyphStartIndex:S,numGlyphs:C,segment:I,writingMode:R,flipState:D}=t,A=E+t.lineLength,L=t=>{if(d){const[i,o,s]=t.up,r=h.length;e.bs(d,r+0,i,o,s),e.bs(d,r+1,i,o,s),e.bs(d,r+2,i,o,s),e.bs(d,r+3,i,o,s);}const[i,o,s]=t.point;e.bt(h,i,o,s,t.angle);};if(C>1){const e=Yt(b,l,w,T,o,u,_,t,c,n,p,m,!1,g,v,y,x);if(!e)return {notEnoughRoom:!0};if(s&&!o){let[i,o,s]=e.first.point,[r,n,l]=e.last.point;[i,o]=Wt(i,o,s,a),[r,n]=Wt(r,n,l,a);const c=Jt(R,D,(r-i)*f,n-o);if(t.flipState=c&&c.needsFlipping?Gt.flipRequired:Gt.flipNotRequired,c)return c}L(e.first);for(let e=S+1;e<S+C-1;e++){const t=ii(b*l.getoffsetX(e),w,T,o,u,_,I,E,A,c,n,p,m,!1,!1,g,v,y,x);if(!t)return h.length-=4*(e-S),{notEnoughRoom:!0};L(t);}L(e.last);}else {if(s&&!o){const i=Wt(_.x,_.y,0,r),o=E+I+1,s=new e.P(c.getx(o),c.gety(o)),n=Wt(s.x,s.y,0,r),a=n[3]>0?n:ti(_,s,i,1,r,void 0,g,v.canonical),l=Jt(R,D,(a[0]-i[0])*f,a[1]-i[1]);if(t.flipState=l&&l.needsFlipping?Gt.flipRequired:Gt.flipNotRequired,l)return l}const i=ii(b*l.getoffsetX(S),w,T,o,u,_,I,E,A,c,n,p,m,!1,!1,g,v,y,x);if(!i)return {notEnoughRoom:!0};L(i);}return {}}function ei(e,t,i,o,s){const{x:r,y:n,z:a}=o.projectTilePoint(e.x,e.y,t);if(!s)return Wt(r,n,a,i);const[l,c,h]=s(e);return Wt(r+l,n+c,a+h,i)}function ti(t,i,o,s,r,n,a,l){const c=ei(t.sub(i)._unit()._add(t),l,r,a,n);return e.ad.vec3.sub(c,o,c),e.ad.vec3.normalize(c,c),e.ad.vec3.scaleAndAdd(c,o,c,s)}function ii(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g,v,y){const x=s?t-i:t+i;let b=x>0?1:-1,w=0;s&&(b*=-1,w=Math.PI),b<0&&(w+=Math.PI);let T=l+a+(b>0?0:1)|0,E=r,S=r,C=0,I=0;const R=Math.abs(x),D=[],A=[];let L=n,P=L,M=e.ad.vec3.zero([]);const z=()=>ti(P,L,S,R-C+1,d,_,m,g.canonical);for(;C+I<=R;){if(T+=b,T<l||T>=c)return null;if(S=E,P=L,D.push(S),p&&A.push(P),L=new e.P(h.getx(T),h.gety(T)),E=u[T],!E){const e=ei(L,g.canonical,d,m,_);E=e[3]>0?u[T]=e:z();}C+=I;const t=e.ad.vec3.sub([],E,S),i=e.ad.vec3.distance(S,E);if(o&&i>0&&I>0&&e.ad.vec3.dot(M,t)/(I*i)<y)return null;I=i,M=t;}f&&_&&(u[T]&&(E=z(),I=e.ad.vec3.distance(S,E),M=e.ad.vec3.sub([],E,S)),u[T]=E);const O=(R-C)/I,F=L.sub(P)._mult(O)._add(P),k=e.ad.vec3.scaleAndAdd([],S,M,O);let B=[0,0,1],N=M[0],U=M[1];if(v&&(B=m.upVector(g.canonical,F.x,F.y),0!==B[0]||0!==B[1]||1!==B[2])){const t=[B[2],0,-B[0]],i=e.ad.vec3.cross([],B,t);e.ad.vec3.normalize(t,t),e.ad.vec3.normalize(i,i),N=e.ad.vec3.dot(M,t),U=e.ad.vec3.dot(M,i);}if(o){const t=e.ad.vec3.cross([],B,M);e.ad.vec3.normalize(t,t),e.ad.vec3.scaleAndAdd(k,k,t,o*b);}const V=w+Math.atan2(U,N);return D.push(k),p&&A.push(F),{point:k,angle:V,path:D,tilePath:A,up:B}}function oi(e,t){const i=t.length,o=i+4*e;t.resize(o),t.float32.fill(-1/0,4*i,4*o);}function si(e,t,i){const o=t[0],s=t[1];return e[0]=i[0]*o+i[4]*s+i[12],e[1]=i[1]*o+i[5]*s+i[13],e[3]=i[3]*o+i[7]*s+i[15],e}const ri=100;class ni{constructor(e,t,i=new Vt(e.width+200,e.height+200,25),o=new Vt(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=o,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+ri,this.screenBottomBoundary=e.height+ri,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t;}placeCollisionBox(e,t,i,o,s,r,n,a){let l=i.projectedAnchorX,c=i.projectedAnchorY,h=i.projectedAnchorZ;const d=i.elevation,u=i.tileID,_=e.getProjection();if(d&&u){const[e,t,o]=_.upVector(u.canonical,i.tileAnchorX,i.tileAnchorY),s=_.upVectorScale(u.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;l+=e*d*s,c+=t*d*s,h+=o*d*s;}const p=this.projectAndGetPerspectiveRatio(n,l,c,h,i.tileID,"globe"===_.name||!!d||this.transform.pitch>0,_),f=r*p.perspectiveRatio,m=(i.x1*t+o.x-i.padding)*f+p.point.x,g=(i.y1*t+o.y-i.padding)*f+p.point.y,v=(i.x2*t+o.x+i.padding)*f+p.point.x,y=(i.y2*t+o.y+i.padding)*f+p.point.y,x=p.perspectiveRatio<=.55||p.occluded;return !this.isInsideGrid(m,g,v,y)||!s&&this.grid.hitTest(m,g,v,y,a)||x?{box:[],offscreen:!1,occluded:p.occluded}:{box:[m,g,v,y],offscreen:this.isOffscreen(m,g,v,y),occluded:!1}}placeCollisionCircles(t,i,o,s,r,n,a,l,c,h,d,u,_,p,f){const m=[],g=this.transform.elevation,v=t.getProjection(),y=g?g.getAtTileOffsetFunc(f,this.transform.center.lat,this.transform.worldSize,v):null,x=new e.P(o.tileAnchorX,o.tileAnchorY);let{x:b,y:w,z:T}=v.projectTilePoint(x.x,x.y,f.canonical);if(y){const[e,t,i]=y(x);b+=e,w+=t,T+=i;}const E="globe"===v.name,S=this.projectAndGetPerspectiveRatio(a,b,w,T,f,E||!!g||this.transform.pitch>0,v),{perspectiveRatio:C}=S,I=(d?n/C:n*C)/e.bw,R=Wt(b,w,T,l),D=o.lineOffsetX*I,A=o.lineOffsetY*I,L=e.ak(t.layers[0].layout.get("text-max-angle")),P=Math.cos(L),M=S.signedDistanceFromCamera>0?Yt(I,r,D,A,!1,R,x,o,s,l,{},g&&!d?y:null,d&&!!g,v,f,d,P):null;let z=!1,O=!1,F=!0;if(M&&!S.occluded){const t=.5*_*C+p,o=new e.P(-100,-100),s=new e.P(this.screenRightBoundary,this.screenBottomBoundary),r=new Ut,{first:n,last:a}=M,l=n.path.length;let d=[];for(let e=l-1;e>=1;e--)d.push(n.path[e]);for(let e=1;e<a.path.length;e++)d.push(a.path[e]);const f=2.5*t;c&&(d=d.map((([e,t,i],o)=>(y&&!E&&(i=y(o<l-1?n.tilePath[l-1-o]:a.tilePath[o-l+2])[2]),Wt(e,t,i,c)))),d.some((e=>e[3]<=0))&&(d=[]));let g=[];if(d.length>0){let t=1/0,i=-1/0,r=1/0,n=-1/0;for(const e of d)t=Math.min(t,e[0]),r=Math.min(r,e[1]),i=Math.max(i,e[0]),n=Math.max(n,e[1]);i>=o.x&&t<=s.x&&n>=o.y&&r<=s.y&&(g=[d.map((t=>new e.P(t[0],t[1])))],(t<o.x||i>s.x||r<o.y||n>s.y)&&(g=e.bu(g,o.x,o.y,s.x,s.y)));}for(const e of g){r.reset(e,.25*t);let o=0;o=r.length<=.5*t?1:Math.ceil(r.paddedLength/f)+1;for(let e=0;e<o;e++){const s=e/Math.max(o-1,1),n=r.lerp(s),a=n.x+ri,l=n.y+ri;m.push(a,l,t,0);const c=a-t,d=l-t,_=a+t,p=l+t;if(F=F&&this.isOffscreen(c,d,_,p),O=O||this.isInsideGrid(c,d,_,p),!i&&this.grid.hitTestCircle(a,l,t,u)&&(z=!0,!h))return {circles:[],offscreen:!1,collisionDetected:z,occluded:!1}}}}return {circles:!h&&z||!O?[]:m,offscreen:F,collisionDetected:z,occluded:S.occluded}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,s=1/0,r=-1/0,n=-1/0;for(const a of t){const t=new e.P(a.x+ri,a.y+ri);o=Math.min(o,t.x),s=Math.min(s,t.y),r=Math.max(r,t.x),n=Math.max(n,t.y),i.push(t);}const a=this.grid.query(o,s,r,n).concat(this.ignoredGrid.query(o,s,r,n)),l={},c={};for(const t of a){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const s=[new e.P(t.x1,t.y1),new e.P(t.x2,t.y1),new e.P(t.x2,t.y2),new e.P(t.x1,t.y2)];e.bv(i,s)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,s){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:s},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,s){const r=t?this.ignoredGrid:this.grid,n={bucketInstanceId:i,featureIndex:o,collisionGroupID:s};for(let t=0;t<e.length;t+=4)r.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,s,r,n,a){const l=[i,o,s,1];let c=!1;if(s||this.transform.pitch>0){if(e.ad.vec4.transformMat4(l,l,t),this.fogState&&r&&"globe"!==a.name){const t=function(t,i,o,s,r,n){const a=n.calculateFogTileMatrix(r),l=[i,o,s];return e.ad.vec3.transformMat4(l,l,a),ke(t,e.ad.vec3.length(l),n.pitch,n._fov)}(this.fogState,i,o,s,r.toUnwrapped(),this.transform);c=t>.9;}}else si(l,l,t);const h=l[3];return {point:new e.P((l[0]/h+1)/2*this.transform.width+ri,(-l[1]/h+1)/2*this.transform.height+ri),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(a)/h*.5,1.5),signedDistanceFromCamera:h,occluded:n&&l[2]>h||c}}isOffscreen(e,t,i,o){return i<ri||e>=this.screenRightBoundary||o<ri||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.ad.mat4.identity([]);return e.ad.mat4.translate(t,t,[-100,-100,0]),t}}function ai(t,i,o){const s=i.createTileMatrix(t,t.worldSize,o.toUnwrapped());return e.ad.mat4.multiply(new Float32Array(16),t.projMatrix,s)}function li(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const o=i.clone();return o.setProjection(t.projection),ai(o,t.getProjection(),e)}function ci(e,t,i){return t.name===i.projection.name?e.projMatrix:ai(i,t,e)}class hi{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class di{constructor(e,t,i,o,s,r=!1){this.text=new hi(e?e.text:null,t,i,s),this.icon=new hi(e?e.icon:null,t,o,s),this.clipped=r;}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class ui{constructor(e,t,i,o=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=o;}}class _i{constructor(){this.invProjMatrix=e.ad.mat4.create(),this.viewportMatrix=e.ad.mat4.create(),this.circles=[];}}class pi{constructor(e,t,i,o,s){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=s;}}class fi{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function mi(t,i,o,s,r){const{horizontalAlign:n,verticalAlign:a}=e.bD(t),l=-(n-.5)*i,c=-(a-.5)*o,h=e.bC(t,s);return new e.P(l+h[0]*r,c+h[1]*r)}function gi(t,i,o,s,r){const n=new e.P(t,i);return o&&n._rotate(s?r:-r),n}class vi{constructor(e,t,i,o,s,r){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new ni(this.transform,s),this.buildingIndex=r,this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new fi(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,o,s,r=1){const n=o.getBucket(i),a=o.latestFeatureIndex;if(!n||!a||i.fqid!==n.layerIds[0])return;const l=n.layers[0].layout,c=n.layers[0].paint,h=o.collisionBoxArray,d=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),u=o.tileSize/e.ai,_=o.tileID.toUnwrapped();this.transform.setProjection(n.projection);const p=(f=o.tileID,m=n.getProjection(),g=this.transform,m.name===this.projection?g.calculateProjMatrix(f.toUnwrapped()):ai(g,m,f));var f,m,g;const v="map"===l.get("text-pitch-alignment"),y="map"===l.get("text-rotation-alignment");i.compileFilter(i.options);const x=i.dynamicFilter(),b=i.dynamicFilterNeedsFeature(),w=this.transform.calculatePixelsToTileUnitsMatrix(o),T=Ht(p,o.tileID.canonical,v,y,this.transform,n.getProjection(),w);let E=null;if(v){const t=Zt(p,o.tileID.canonical,v,y,this.transform,n.getProjection(),w);E=e.ad.mat4.multiply([],this.transform.labelPlaneMatrix,t);}let S=null;x&&o.latestFeatureIndex&&(S={unwrappedTileID:_,dynamicFilter:x,dynamicFilterNeedsFeature:b}),this.retainedQueryData[n.bucketInstanceId]=new pi(n.bucketInstanceId,a,n.sourceLayerIndex,n.index,o.tileID);const[C,I]=n.layers[0].layout.get("text-size-scale-range"),R=e.ay(r,C,I),[D,A]=l.get("icon-size-scale-range"),L=e.ay(r,D,A),P={bucket:n,layout:l,paint:c,posMatrix:p,textLabelPlaneMatrix:T,labelToScreenMatrix:E,clippingData:S,scale:d,textPixelRatio:u,holdingForFade:o.holdingForFade(),collisionBoxArray:h,partiallyEvaluatedTextSize:e.bp(n.textSizeData,this.transform.zoom,R),partiallyEvaluatedIconSize:e.bp(n.iconSizeData,this.transform.zoom,L),collisionGroup:this.collisionGroups.get(n.sourceID),latestFeatureIndex:o.latestFeatureIndex};if(s)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:s,parameters:P});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:P});}attemptAnchorPlacement(e,t,i,o,s,r,n,a,l,c,h,d,u,_,p,f,m,g){const{textOffset0:v,textOffset1:y,crossTileID:x}=d,b=[v,y],w=mi(e,i,o,b,s),T=this.collisionIndex.placeCollisionBox(_,s,t,gi(w.x,w.y,r,n,this.transform.angle),h,a,l,c.predicate);if(f){const e=_.getSymbolInstanceIconSize(g,this.transform.zoom,d.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(_,e,f,gi(w.x,w.y,r,n,this.transform.angle),h,a,l,c.predicate).box.length)return}if(T.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[x]&&this.prevPlacement.placements[x]&&this.prevPlacement.placements[x].text&&(t=this.prevPlacement.variableOffsets[x].anchor),this.variableOffsets[x]={textOffset:b,width:i,height:o,anchor:e,textScale:s,prevAnchor:t},this.markUsedJustification(_,e,d,p),_.allowVerticalPlacement&&(this.markUsedOrientation(_,p,d),this.placedOrientations[x]=p),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,i,o,s,r=1){const{bucket:n,layout:a,paint:l,posMatrix:c,textLabelPlaneMatrix:h,labelToScreenMatrix:d,clippingData:u,textPixelRatio:_,holdingForFade:p,collisionBoxArray:f,partiallyEvaluatedTextSize:m,partiallyEvaluatedIconSize:g,collisionGroup:v,latestFeatureIndex:y}=t.parameters,x=a.get("text-optional"),b=a.get("icon-optional"),w=a.get("text-allow-overlap"),T=a.get("icon-allow-overlap"),E="map"===a.get("text-rotation-alignment"),S="map"===a.get("text-pitch-alignment"),C=l.get("symbol-z-offset"),I="sea"===a.get("symbol-elevation-reference"),[R,D]=a.get("text-size-scale-range"),[A,L]=a.get("icon-size-scale-range"),P=e.ay(r,R,D),M=e.ay(r,A,L);this.transform.setProjection(n.projection);let z=w&&(T||!n.hasIconData()||b),O=T&&(w||!n.hasTextData()||x);const F=!C.isConstant();!n.collisionArrays&&f&&n.deserializeCollisionBoxes(f),o&&s&&n.updateCollisionDebugBuffers(this.transform.zoom,f,P,M);const k=(t,s,l)=>{const{crossTileID:f,numVerticalGlyphVertices:R}=t;let D=null;if(u&&u.dynamicFilterNeedsFeature||F){const e=this.retainedQueryData[n.bucketInstanceId];D=y.loadFeature({featureIndex:t.featureIndex,bucketIndex:e.bucketIndex,sourceLayerIndex:e.sourceLayerIndex,layoutVertexArrayOffset:0});}if(u&&!(0,u.dynamicFilter)({zoom:this.transform.zoom,pitch:this.transform.pitch},D,this.retainedQueryData[n.bucketInstanceId].tileID.canonical,new e.P(t.tileAnchorX,t.tileAnchorY),this.transform.calculateDistanceTileData(u.unwrappedTileID)))return this.placements[f]=new ui(!1,!1,!1,!0),void i.add(f);const A=C.evaluate(D,{});if(i.has(f))return;if(p)return void(this.placements[f]=new ui(!1,!1,!1));let L=!1,P=!1,M=!0,k=!1,B=!1,N=null,U={box:null,offscreen:null,occluded:null},V={box:null,offscreen:null,occluded:null},G=null,j=null,q=null,H=0,Z=0,W=0;l.textFeatureIndex?H=l.textFeatureIndex:t.useRuntimeCollisionCircles&&(H=t.featureIndex),l.verticalTextFeatureIndex&&(Z=l.verticalTextFeatureIndex);const $=e=>{e.tileID=this.retainedQueryData[n.bucketInstanceId].tileID;const i=this.transform.elevation;e.elevation=I?A:A+(i?i.getAtTileOffset(e.tileID,e.tileAnchorX,e.tileAnchorY):0),e.elevation+=t.zOffset;},X=l.textBox;if(X){$(X);const i=i=>{let o=e.bq.horizontal;if(n.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[f];e&&(this.placedOrientations[f]=e,o=e,this.markUsedOrientation(n,o,t));}return o},o=(t,i)=>{if(n.allowVerticalPlacement&&R>0&&l.verticalTextBox){for(const o of n.writingModes)if(o===e.bq.vertical?(U=i(),V=U):U=t(),U&&U.box&&U.box.length)break}else U=t();};if(a.get("text-variable-anchor")){let r=a.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[f]){const e=this.prevPlacement.variableOffsets[f];r.indexOf(e.anchor)>0&&(r=r.filter((t=>t!==e.anchor)),r.unshift(e.anchor));}const h=(e,i,o)=>{const a=n.getSymbolInstanceTextSize(m,t,this.transform.zoom,s),l=(e.x2-e.x1)*a+2*e.padding,h=(e.y2-e.y1)*a+2*e.padding,d=t.hasIconTextFit&&!T?i:null;d&&$(d);let u={box:[],offscreen:!1,occluded:!1};const p=w?2*r.length:r.length;for(let i=0;i<p;++i){const p=this.attemptAnchorPlacement(r[i%r.length],e,l,h,a,E,S,_,c,v,i>=r.length,t,s,n,o,d,m,g);if(p&&(u=p.placedGlyphBoxes,u&&u.box&&u.box.length)){L=!0,N=p.shift;break}}return u};o((()=>h(X,l.iconBox,e.bq.horizontal)),(()=>{const t=l.verticalTextBox;return t&&$(t),n.allowVerticalPlacement&&!(U&&U.box&&U.box.length)&&R>0&&t?h(t,l.verticalIconBox,e.bq.vertical):{box:null,offscreen:null,occluded:null}})),U&&(L=U.box,M=U.offscreen,k=U.occluded);const d=i(!(!U||!U.box));if(!L&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[f];e&&(this.variableOffsets[f]=e,this.markUsedJustification(n,e.anchor,t,d));}}else {const a=(i,o)=>{const a=n.getSymbolInstanceTextSize(m,t,this.transform.zoom,s,r),l=this.collisionIndex.placeCollisionBox(n,a,i,new e.P(0,0),w,_,c,v.predicate);return l&&l.box&&l.box.length&&(this.markUsedOrientation(n,o,t),this.placedOrientations[f]=o),l};o((()=>a(X,e.bq.horizontal)),(()=>{const t=l.verticalTextBox;return n.allowVerticalPlacement&&R>0&&t?($(t),a(t,e.bq.vertical)):{box:null,offscreen:null,occluded:null}})),i(!!(U&&U.box&&U.box.length));}}if(G=U,L=G&&G.box&&G.box.length>0,M=G&&G.offscreen,k=G&&G.occluded,t.useRuntimeCollisionCircles){const i=n.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex),s=e.br(n.textSizeData,m,i),r=a.get("text-padding");j=this.collisionIndex.placeCollisionCircles(n,w,i,n.lineVertexArray,n.glyphOffsetArray,s,c,h,d,o,S,v.predicate,t.collisionCircleDiameter*s/e.bw,r,this.retainedQueryData[n.bucketInstanceId].tileID),L=w||j.circles.length>0&&!j.collisionDetected,M=M&&j.offscreen,k=j.occluded;}if(l.iconFeatureIndex&&(W=l.iconFeatureIndex),l.iconBox){const i=i=>{$(i);const o=t.hasIconTextFit&&N?gi(N.x,N.y,E,S,this.transform.angle):new e.P(0,0),s=n.getSymbolInstanceIconSize(g,this.transform.zoom,t.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(n,s,i,o,T,_,c,v.predicate)};V&&V.box&&V.box.length&&l.verticalIconBox?(q=i(l.verticalIconBox),P=q.box.length>0):(q=i(l.iconBox),P=q.box.length>0),M=M&&q.offscreen,B=q.occluded;}const K=x||0===t.numHorizontalGlyphVertices&&0===R,Y=b||0===t.numIconVertices;if(K||Y?Y?K||(P=P&&L):L=P&&L:P=L=P&&L,L&&G&&G.box&&this.collisionIndex.insertCollisionBox(G.box,a.get("text-ignore-placement"),n.bucketInstanceId,V&&V.box&&Z?Z:H,v.ID),P&&q&&this.collisionIndex.insertCollisionBox(q.box,a.get("icon-ignore-placement"),n.bucketInstanceId,W,v.ID),j&&(L&&this.collisionIndex.insertCollisionCircles(j.circles,a.get("text-ignore-placement"),n.bucketInstanceId,H,v.ID),o)){const e=n.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new _i);for(let e=0;e<j.circles.length;e+=4)t.circles.push(j.circles[e+0]),t.circles.push(j.circles[e+1]),t.circles.push(j.circles[e+2]),t.circles.push(j.collisionDetected?1:0);}const J="globe"!==n.projection.name;z=z&&(J||!k),O=O&&(J||!B),this.placements[f]=new ui(L||z,P||O,M||n.justReloaded),i.add(f);};if("offset"===n.elevationType&&this.buildingIndex&&this.buildingIndex.updateZOffset(n,this.retainedQueryData[n.bucketInstanceId].tileID),"road"===n.elevationType&&n.updateRoadElevation(),n.updateZOffset(),n.sortFeaturesByY){const t=n.getSortedSymbolIndexes(this.transform.angle);for(let e=t.length-1;e>=0;--e){const i=t[e];k(n.symbolInstances.get(i),i,n.collisionArrays[i]);}n.hasAnyZOffset&&e.w(`${n.layerIds[0]} layer symbol-z-elevate: symbols are not sorted by elevation if symbol-z-order is evaluated to viewport-y`);}else if(n.hasAnyZOffset){const e=n.getSortedIndexesByZOffset();for(let t=0;t<e.length;++t){const i=e[t];k(n.symbolInstances.get(i),i,n.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)k(n.symbolInstances.get(e),e,n.collisionArrays[e]);if(o&&n.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[n.bucketInstanceId];e.ad.mat4.invert(t.invProjMatrix,c),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}n.justReloaded=!1;}markUsedJustification(t,i,o,s){const{leftJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,rightJustifiedTextSymbolIndex:a,verticalPlacedTextSymbolIndex:l,crossTileID:c}=o,h=e.bB(i),d=s===e.bq.vertical?l:"left"===h?r:"center"===h?n:"right"===h?a:-1;r>=0&&(t.text.placedSymbolArray.get(r).crossTileID=d>=0&&r!==d?0:c),n>=0&&(t.text.placedSymbolArray.get(n).crossTileID=d>=0&&n!==d?0:c),a>=0&&(t.text.placedSymbolArray.get(a).crossTileID=d>=0&&a!==d?0:c),l>=0&&(t.text.placedSymbolArray.get(l).crossTileID=d>=0&&l!==d?0:c);}markUsedOrientation(t,i,o){const s=i===e.bq.horizontal||i===e.bq.horizontalOnly?i:0,r=i===e.bq.vertical?i:0,{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:a,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=o,h=t.text.placedSymbolArray;n>=0&&(h.get(n).placedOrientation=s),a>=0&&(h.get(a).placedOrientation=s),l>=0&&(h.get(l).placedOrientation=s),c>=0&&(h.get(c).placedOrientation=r);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,s=t?t.opacities:{},r=t?t.variableOffsets:{},n=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],r=s[e];r?(this.opacities[e]=new di(r,o,t.text,t.icon,null,t.clipped),i=i||t.text!==r.text.placed||t.icon!==r.icon.placed):(this.opacities[e]=new di(null,o,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon);}for(const e in s){const t=s[e];if(!this.opacities[e]){const s=new di(t,o,!1,!1);s.isHidden()||(this.opacities[e]=s,i=i||t.text.placed||t.icon.placed);}}for(const e in r)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=r[e]);for(const e in n)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=n[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t,i,o){const s=new Set;for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.fqid===t.layerIds[0]&&(this.updateBucketOpacities(t,s,r,r.collisionBoxArray,i,o,r.tileID,e.scope),"offset"===t.elevationType&&this.buildingIndex&&this.buildingIndex.updateZOffset(t,r.tileID),"road"===t.elevationType&&t.updateRoadElevation(),t.updateZOffset());}}updateBucketOpacities(t,i,o,s,r,n,a,l){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const c=t.layers[0].layout,h=t.layers[0].paint,d=!!t.layers[0].dynamicFilter(),u=new di(null,0,!1,!1,!0),_=c.get("text-allow-overlap"),p=c.get("icon-allow-overlap"),f=c.get("text-variable-anchor"),m="map"===c.get("text-rotation-alignment"),g="map"===c.get("text-pitch-alignment"),v=h.get("symbol-z-offset"),y="sea"===c.get("symbol-elevation-reference"),x=!v.isConstant(),b=new di(null,0,_&&(p||!t.hasIconData()||c.get("icon-optional")),p&&(_||!t.hasTextData()||c.get("text-optional")),!0);!t.collisionArrays&&s&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(s);const w=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};let T=0;n&&t.updateReplacement(a,n);for(let s=0;s<t.symbolInstances.length;s++){const c=t.symbolInstances.get(s),{numHorizontalGlyphVertices:h,numVerticalGlyphVertices:_,crossTileID:p,numIconVertices:E,tileAnchorX:S,tileAnchorY:C}=c;let I=null;const R=this.retainedQueryData[t.bucketInstanceId];x&&c&&R&&(I=o.latestFeatureIndex.loadFeature({featureIndex:c.featureIndex,bucketIndex:R.bucketIndex,sourceLayerIndex:R.sourceLayerIndex,layoutVertexArrayOffset:0}));const D=v.evaluate(I,{}),A=i.has(p);let L=this.opacities[p];A?L=u:L||(L=b,this.opacities[p]=L),i.add(p);const P=h>0||_>0,M=E>0,z=this.placedOrientations[p],O=z===e.bq.vertical,F=z===e.bq.horizontal||z===e.bq.horizontalOnly;!P&&!M||L.isHidden()||T++;let k=!1;if((P||M)&&n)for(const i of t.activeReplacements){if(e.bx(i,r,e.by.Symbol,l))continue;if(i.min.x>S||S>i.max.x||i.min.y>C||C>i.max.y)continue;const t=e.bz(S,C,a.canonical,i.footprintTileId.canonical);if(k=e.bA(t,i.footprint),k)break}if(P){const e=k?Ri:Ii(L.text);w(t.text,h,O?Ri:e),w(t.text,_,F?Ri:e);const i=L.text.isHidden(),{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:s,rightJustifiedTextSymbolIndex:r,verticalPlacedTextSymbolIndex:n}=c,a=t.text.placedSymbolArray,l=i||O?1:0;o>=0&&(a.get(o).hidden=l),s>=0&&(a.get(s).hidden=l),r>=0&&(a.get(r).hidden=l),n>=0&&(a.get(n).hidden=i||F?1:0);const d=this.variableOffsets[p];d&&this.markUsedJustification(t,d.anchor,c,z);const u=this.placedOrientations[p];u&&(this.markUsedJustification(t,"left",c,u),this.markUsedOrientation(t,u,c));}if(M){const e=k?Ri:Ii(L.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:o}=c,s=t.icon.placedSymbolArray,r=L.icon.isHidden()?1:0;i>=0&&(w(t.icon,E,O?Ri:e),s.get(i).hidden=r),o>=0&&(w(t.icon,c.numVerticalIconVertices,F?Ri:e),s.get(o).hidden=r);}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[s];if(i){let o=new e.P(0,0),s=!0;if(i.textBox||i.verticalTextBox){if(f){const e=this.variableOffsets[p];e?(o=mi(e.anchor,e.width,e.height,e.textOffset,e.textScale),m&&o._rotate(g?this.transform.angle:-this.transform.angle)):s=!1;}d&&(s=!L.clipped),i.textBox&&yi(t.textCollisionBox.collisionVertexArray,L.text.placed,!s||O,D,y,o.x,o.y),i.verticalTextBox&&yi(t.textCollisionBox.collisionVertexArray,L.text.placed,!s||F,D,y,o.x,o.y);}const r=s&&Boolean(!F&&i.verticalIconBox);i.iconBox&&yi(t.iconCollisionBox.collisionVertexArray,L.icon.placed,r,D,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0),i.verticalIconBox&&yi(t.iconCollisionBox.collisionVertexArray,L.icon.placed,!r,D,y,c.hasIconTextFit?o.x:0,c.hasIconTextFit?o.y:0);}}}if(t.fullyClipped=0===T,t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function yi(e,t,i,o,s,r,n){e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0,o,s?1:0);}const xi=Math.pow(2,25),bi=Math.pow(2,24),wi=Math.pow(2,17),Ti=Math.pow(2,16),Ei=Math.pow(2,9),Si=Math.pow(2,8),Ci=Math.pow(2,1);function Ii(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*xi+t*bi+i*wi+t*Ti+i*Ei+t*Si+i*Ci+t}const Ri=0;class Di{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs=new Set,this._bucketParts=[];}continuePlacement(e,t,i,o,s,r){const n=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(n,o,e[this._currentTileIndex],this._sortAcrossTiles,r),this._currentTileIndex++,s())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,n.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<n.length;){const e=n[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart,r),this._currentPartIndex++,s())return !0}return !1}}class Ai{constructor(e,t,i,o,s,r,n,a,l){this.placement=new vi(e,s,r,n,a,l),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o,s,r){const n=e.q.now(),a=()=>{const t=e.q.now()-n;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const n=i[t[this._currentPlacementIndex]],l=this.placement.collisionIndex.transform.zoom;if("symbol"===n.type&&(!n.minzoom||n.minzoom<=l)&&(!n.maxzoom||n.maxzoom>l)){const t=n,i=t.layout.get("symbol-z-elevate"),l=void 0!==t.layout.get("symbol-sort-key").constantOr(1),c=t.layout.get("symbol-z-order"),h="viewport-y"===c||"auto"===c&&!("viewport-y"!==c&&l),d=t.layout.get("text-allow-overlap")||t.layout.get("icon-allow-overlap")||t.layout.get("text-ignore-placement")||t.layout.get("icon-ignore-placement"),u=h&&d,_=this._inProgressLayer=this._inProgressLayer||new Di(t),p=e.C(n.source,n.scope);if(_.continuePlacement(i||u?s[p]:o[p],this.placement,this._showCollisionBoxes,n,a,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Li=512/e.ai/2;class Pi{constructor(t,i,o){this.tileID=t,this.bucketInstanceId=o,this.index=new e.bE(i.length,16,Int32Array),this.keys=[],this.crossTileIDs=[];const s=t.canonical.x*e.ai,r=t.canonical.y*e.ai;for(let e=0;e<i.length;e++){const{key:t,crossTileID:o,tileAnchorX:n,tileAnchorY:a}=i.get(e),l=Math.floor((s+n)*Li),c=Math.floor((r+a)*Li);this.index.add(l,c),this.keys.push(t),this.crossTileIDs.push(o);}this.index.finish();}findMatches(t,i,o){const s=this.tileID.canonical.z<i.canonical.z?1:Math.pow(2,this.tileID.canonical.z-i.canonical.z),r=Li/Math.pow(2,i.canonical.z-this.tileID.canonical.z),n=i.canonical.x*e.ai,a=i.canonical.y*e.ai;for(let e=0;e<t.length;e++){const i=t.get(e);if(i.crossTileID)continue;const{key:l,tileAnchorX:c,tileAnchorY:h}=i,d=Math.floor((n+c)*r),u=Math.floor((a+h)*r),_=this.index.range(d-s,u-s,d+s,u+s);for(const e of _){const t=this.crossTileIDs[e];if(this.keys[e]===l&&!o.has(t)){o.add(t),i.crossTileID=t;break}}}}}class Mi{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class zi{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const s=i[e];s.tileID=s.tileID.unwrapTo(s.tileID.wrap+t),o[s.tileID.key]=s;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]=new Set);const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const s=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in s){const r=s[i];r.tileID.isChildOf(e)&&r.findMatches(t.symbolInstances,e,o);}else {const r=s[e.scaledTo(Number(i)).key];r&&r.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const s=t.symbolInstances.get(e);s.crossTileID||(s.crossTileID=i.generate(),o.add(s.crossTileID));}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new Pi(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.crossTileIDs)this.usedCrossTileIDs[e].delete(i);}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const s in o)e[o[s].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[s]),delete o[s],t=!0);}return t}}class Oi{constructor(){this.layerIndexes={},this.crossTileIDs=new Mi,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i,o){let s=this.layerIndexes[e.fqid];void 0===s&&(s=this.layerIndexes[e.fqid]=new zi);let r=!1;const n={};"globe"!==o.name&&s.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.fqid===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),s.addBucket(i.tileID,t,this.crossTileIDs)&&(r=!0),n[t.bucketInstanceId]=!0);}return s.removeStaleBuckets(n)&&(r=!0),r}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}const Fi=771;class ki{constructor(e,t,i,o){this.blendFunction=e,this.blendColor=t,this.mask=i,this.blendEquation=o;}}ki.Replace=[1,0,1,0],ki.disabled=new ki(ki.Replace,e.al.transparent,[!1,!1,!1,!1]),ki.unblended=new ki(ki.Replace,e.al.transparent,[!0,!0,!0,!0]),ki.alphaBlended=new ki([1,Fi,1,Fi],e.al.transparent,[!0,!0,!0,!0]),ki.alphaBlendedNonPremultiplied=new ki([770,Fi,770,Fi],e.al.transparent,[!0,!0,!0,!0]),ki.multiply=new ki([774,0,774,0],e.al.transparent,[!0,!0,!0,!0]);class Bi{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Bi.ReadOnly=!1,Bi.ReadWrite=!0,Bi.disabled=new Bi(519,Bi.ReadOnly,[0,1]);const Ni=7680;class Ui{constructor(e,t,i,o,s,r){this.test=e,this.ref=t,this.mask=i,this.fail=o,this.depthFail=s,this.pass=r;}}Ui.disabled=new Ui({func:519,mask:0},0,0,Ni,Ni,Ni);const Vi=1029,Gi=2305;class ji{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}function qi(t,i){const o=e.bG(t,3);e.ad.mat4.fromQuat(t,i),e.bI(t,3,o);}function Hi(t,i){const o=e.ad.quat.identity([]);return e.ad.quat.rotateZ(o,o,-i),e.ad.quat.rotateX(o,o,-t),o}function Zi(t,i){const o=[t[0],t[1],0],s=[i[0],i[1],0];if(e.ad.vec3.length(o)>=1e-15){const t=e.ad.vec3.normalize([],o);e.ad.vec3.scale(s,t,e.ad.vec3.dot(s,t)),i[0]=s[0],i[1]=s[1];}const r=e.ad.vec3.cross([],i,t);if(e.ad.vec3.len(r)<1e-15)return null;const n=Math.atan2(-r[1],r[0]);return Hi(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),n)}ji.disabled=new ji(!1,Vi,Gi),ji.backCCW=new ji(!0,Vi,Gi),ji.backCW=new ji(!0,Vi,2304),ji.frontCW=new ji(!0,1028,2304),ji.frontCCW=new ji(!0,1028,Gi);class Wi{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){if(t){const i=t instanceof e.ac?t:new e.ac(t[0],t[1],t[2]);this._renderWorldCopies&&(i.x=e.bF(i.x,0,1)),this._position=i;}else this._position=null;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this.position,s=this._elevation?this._elevation.getAtPointOrZero(e.ac.fromLngLat(t)):0,r=e.ac.fromLngLat(t,s),n=[r.x-o.x,r.y-o.y,r.z-o.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=Zi(n,i);}setPitchBearing(t,i){this.orientation=Hi(e.ak(t),e.ak(-i));}}class $i{constructor(t,i){this._transform=e.ad.mat4.identity([]),this.orientation=i,this.position=t;}get mercatorPosition(){const t=this.position;return new e.ac(t[0],t[1],t[2])}get position(){const t=e.bG(this._transform,3);return [t[0],t[1],t[2]]}set position(t){var i;t&&e.bI(this._transform,3,[(i=t)[0],i[1],i[2],1]);}get orientation(){return this._orientation}set orientation(t){this._orientation=t||e.ad.quat.identity([]),t&&qi(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=Hi(e,t),qi(this._transform,this._orientation);}forward(){const t=e.bG(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.bG(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.bG(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.ad.mat4.invert(o,this.getWorldToCamera(t,i)),o}getCameraToWorldMercator(){return this._transform}getWorldToCameraPosition(t,i,o){const s=this.position;e.ad.vec3.scale(s,s,-t);const r=new Float64Array(16);return e.ad.mat4.fromScaling(r,[o,o,o]),e.ad.mat4.translate(r,r,s),r[10]*=i,r}getWorldToCamera(t,i){const o=new Float64Array(16),s=new Float64Array(4),r=this.position;return e.ad.quat.conjugate(s,this._orientation),e.ad.vec3.scale(r,r,-t),e.ad.mat4.fromQuat(o,s),e.ad.mat4.translate(o,o,r),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,s){const r=new Float64Array(16);return e.ad.mat4.perspective(r,t,i,o,s),r}getCameraToClipOrthographic(t,i,o,s,r,n){const a=new Float64Array(16);return e.ad.mat4.ortho(a,t,i,o,s,r,n),a}getDistanceToElevation(t,i=!1){const o=0===t?0:e.bH(t,i?e.aT(this.position[1]):this.position[1]),s=this.forward();return (o-this.position[2])/s[2]}clone(){return new $i([...this.position],[...this.orientation])}}const Xi={BaseColor:5,MetallicRoughness:6,Normal:7,Occlusion:8,Emission:9,LUT:10,ShadowMap0:11};class Ki{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.ah(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.ah(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.ah(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.ah(t.right,i.right,o)),this}getCenter(t,i){const o=e.ay((this.left+t-this.right)/2,0,t),s=e.ay((this.top+i-this.bottom)/2,0,i);return new e.P(o,s)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Ki(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}const Yi=15;class Ji{constructor(t,i,o,s,r,n,a){this.tileSize=512,this._renderWorldCopies=void 0===r||r,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=o??0,this._maxPitch=s??60,this.setProjection(n),this.setMaxBounds(a),this.width=0,this.height=0,this._center=new e.bO(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new Ki,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._expandedProjMatrixCache={},this._distanceTileDataCache={},this._camera=new $i,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._tileCoverLift=0,this.freezeTileCoverage=!1,this._horizonShift=.1,this._orthographicProjectionAtLowPitch=!1,this._allowWorldUnderZoom=!1;}clone(){const e=new Ji(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection(),this.maxBounds);return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._orthographicProjectionAtLowPitch=this._orthographicProjectionAtLowPitch,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e._allowWorldUnderZoom=this._allowWorldUnderZoom,e}get isOrthographic(){return "globe"!==this.projection.name&&this._orthographicProjectionAtLowPitch&&this.pitch<Yi}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices());}get depthOcclusionForSymbolsAndCircles(){return "globe"!==this.projection.name&&!this.isOrthographic}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices();}getProjection(){return e.aA(this.projection,["name","center","parallels"])}setProjection(t){this.projectionOptions=t||{name:"mercator"};const i=this.projection?this.getProjection():void 0;this.projection=e.bP(this.projectionOptions);const o=this.getProjection(),s=!e.bn(i,o);return s&&this._calcMatrices(),this.mercatorFromTransition=!1,s}setOrthographicProjectionAtLowPitch(e){return this._orthographicProjectionAtLowPitch!==e&&(this._orthographicProjectionAtLowPitch=e,this._calcMatrices(),!0)}setMercatorFromTransition(){const t=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=e.bP({name:"mercator"});const i=t!==this.projection.name;return i&&this._calcMatrices(),i}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return e.bH(1,this.center.lat)*this.cameraWorldSizeForFog}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return e.bF(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=e.ad.mat2.create(),e.ad.mat2.rotate(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.ay(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=e.ak(t),this._calcMatrices());}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={};}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}get tileCoverLift(){return this._tileCoverLift}set tileCoverLift(e){this._tileCoverLift!==e&&(this._tileCoverLift=e);}_updateCameraOnTerrain(){const e=this.elevation?this.elevation.getAtPoint(this.locationCoordinate(this.center),Number.NEGATIVE_INFINITY):Number.NEGATIVE_INFINITY,t=this.elevation&&e===Number.NEGATIVE_INFINITY&&this.elevation.visibleDemTiles.length>0&&this.elevation.exaggeration()>0&&this._centerAltitudeValidForExaggeration;if(!this._elevation||e===Number.NEGATIVE_INFINITY&&(!t||!this._centerAltitude))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const i=this._elevation;t||this._centerAltitude&&this._centerAltitudeValidForExaggeration&&i.exaggeration()&&this._centerAltitudeValidForExaggeration!==i.exaggeration()?(this._centerAltitude=this._centerAltitude/this._centerAltitudeValidForExaggeration*i.exaggeration(),this._centerAltitudeValidForExaggeration=i.exaggeration()):(this._centerAltitude=e||0,this._centerAltitudeValidForExaggeration=i.exaggeration()),this._updateSeaLevelZoom();}_updateSeaLevelZoom(){void 0!==this._centerAltitudeValidForExaggeration&&(this._seaLevelZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize));}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let s=0,r=0;for(let n=0;n<i.length;n++){const a=new e.P(i[n][0]*this.width,o+i[n][1]*(this.height-o)),l=t.pointCoordinate(a);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);s+=l[3]*c,r+=c;}return 0===r?NaN:s/r}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),s=this._mercatorZfromZoom(this._maxZoom),r=Math.max(o-i,s);this._setZoom(this._zoomFromMercatorZ(r));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const s=e.ad.vec3.length(e.ad.vec3.sub([],this._camera.position,o));return e.ay(this._zoomFromMercatorZ(s),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.ad.quat.exactEquals(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.ad.vec3.exactEquals(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new Wi;return i.position=new e.ac(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.ad.quat.length(t))return !1;e.ad.quat.normalize(t,t);const i=e.ad.vec3.transformQuat([],[0,0,-1],t),o=e.ad.vec3.transformQuat([],[0,-1,0],t);if(o[2]<0)return !1;const s=Zi(i,o);return !!s&&(this._camera.orientation=s,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,s=this.cameraToCenterDistance;t[2]=e.ay(t[2],s/o,s/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.bQ(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.P(0,0)),s=this.pointCoordinate(new e.P(this.width,0)),r=this.pointCoordinate(new e.P(this.width,this.height)),n=this.pointCoordinate(new e.P(0,this.height)),a=Math.floor(Math.min(o.x,s.x,r.x,n.x)),l=Math.floor(Math.max(o.x,s.x,r.x,n.x)),c=1;for(let o=a-c;o<=l+c;o++)0!==o&&i.push(new e.bQ(o,t));}return i}isLODDisabled(e){return (!e||this.pitch<=60)&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace}extendTileCover(t,i,o){let s=[];const r=void 0!==o,n=!r;if(n&&this.zoom<i)return s;if(r&&0===o[0]&&0===o[1])return s;const a=new Set,l=(t,i,o,r,n)=>{const l=e.c5(i,t,o,r,n);a.has(l)||(s.push(new e.aH(t,i,o,r,n)),a.add(l));};for(let e=0;e<t.length;e++){const s=t[e];if(n&&s.canonical.z!==i)continue;const a=s.canonical,c=s.overscaledZ,h=s.wrap,d=1<<a.z,u=a.x+1<d,_=a.x>0,p=a.y+1<d,f=a.y>0,m=s.wrap-(_?0:1),g=s.wrap+(u?0:1),v=_?a.x-1:d-1,y=u?a.x+1:0;if(r)o[0]<0?(l(c,g,a.z,y,a.y),o[1]<0&&p&&(l(c,h,a.z,a.x,a.y+1),l(c,g,a.z,y,a.y+1)),o[1]>0&&f&&(l(c,h,a.z,a.x,a.y-1),l(c,g,a.z,y,a.y-1))):o[0]>0?(l(c,m,a.z,v,a.y),o[1]<0&&p&&(l(c,h,a.z,a.x,a.y+1),l(c,m,a.z,v,a.y+1)),o[1]>0&&f&&(l(c,h,a.z,a.x,a.y-1),l(c,m,a.z,v,a.y-1))):o[1]<0&&p?l(c,h,a.z,a.x,a.y+1):f&&l(c,h,a.z,a.x,a.y-1);else {const e=s.visibleQuadrants;1&e&&(l(c,m,a.z,v,a.y),f&&(l(c,h,a.z,a.x,a.y-1),l(c,m,a.z,v,a.y-1))),2&e&&(l(c,g,a.z,y,a.y),f&&(l(c,h,a.z,a.x,a.y-1),l(c,g,a.z,y,a.y-1))),4&e&&(l(c,m,a.z,v,a.y),p&&(l(c,h,a.z,a.x,a.y+1),l(c,m,a.z,v,a.y+1))),8&e&&(l(c,g,a.z,y,a.y),p&&(l(c,h,a.z,a.x,a.y+1),l(c,g,a.z,y,a.y+1)));}}const c=[];for(const e of s)s.some((t=>e.isChildOf(t)))||c.push(e);if(s=c.filter((e=>!t.some((t=>!!(e.overscaledZ<i&&t.isChildOf(e))||e.equals(t)||e.isChildOf(t))))),n){const e=1<<i,t="globe"===this.projection.name?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),o=[e*t.x,e*t.y],r=4,n=r*r;s=s.filter((e=>{const t=e.canonical.x+.5-o[0],i=e.canonical.y+.5-o[1];return t*t+i*i<n}));}return s}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,s=this.elevation&&this.elevation.exaggeration(),r=s&&!t.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const a=this.locationCoordinate(this.center),l=this.center.lat,c=1<<i,h=[c*a.x,c*a.y,0],d="globe"===this.projection.name,u=!d,_=e.bR.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,u),p=d?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),f=c*e.bH(1,this.center.lat),m=this._camera.position[2]/e.bH(1,this.center.lat),g=[c*p.x,c*p.y,m*(u?1:f)],v=d||s,y=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),x=this.isLODDisabled(!0)?i:0;let b;if(this._elevation&&t.isTerrainDEM)b=1e4*this._elevation.exaggeration();else if(this._elevation){const e=this._elevation.getMinMaxForVisibleTiles();b=e?e.max:this._centerAltitude;}else b=this._centerAltitude;const w=t.isTerrainDEM?-b:this._elevation?this._elevation.getMinElevationBelowMSL():0,T=this.projection.isReprojectedInTileSpace?e.bS(this):1,E=t=>{const i=1/4e4,o=new e.ac(t.x+i,t.y,t.z),s=new e.ac(t.x,t.y+i,t.z),r=t.toLngLat(),n=o.toLngLat(),a=s.toLngLat(),l=this.locationCoordinate(r),c=this.locationCoordinate(n),h=this.locationCoordinate(a),d=Math.hypot(c.x-l.x,c.y-l.y),u=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(d*u)*T/i},S=t=>{const i=b,o=w;return {aabb:e.bV(this,c,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},C=[];let I=[];const R=i,D=t.reparseOverscaled?o:i,A=(m-this._centerAltitude)*f,L=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=M(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},P=(e,t)=>{if(.707*t<e)return 1;const i=t/e;return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)},M=t=>{if(t.zoom<x)return !0;if(t.zoom===R)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(g),s=t.aabb.distanceY(g);let a=A,c=1;if(d){a=t.aabb.distanceZ(g);const i=Math.pow(2,t.zoom),o=e.aT((t.y+1)/i),s=e.aT(t.y/i),r=Math.min(Math.max(l,o),s),n=e.ca(r)/e.ca(l);if(c=r===l?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,n/this._mercatorScaleRatio),this.zoom<=e.c6&&t.zoom===R-1&&n>=.9)return !0}else if(r&&(a=t.aabb.distanceZ(g)*f),this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=E(new e.ac((t.x+.5)/i,(t.y+.5)/i));c=o>.85?1:o;}if(!n){const e=Math.sqrt(i*i+s*s+a*a);let o=(1<<R-t.zoom)*y*c;return o*=P(Math.max(a,A),e),e<o}let u=Number.MAX_VALUE,_=0;const p=t.aabb.getCorners(),m=[];for(const t of p){e.ad.vec3.sub(m,t,g),d||(r?m[2]*=f:m[2]=A);const i=e.ad.vec3.dot(m,this._camera.forward());i<u&&(u=i,_=Math.abs(m[2]));}let v=(1<<R-t.zoom)*y*c;if(v*=P(Math.max(_,A),u),u<v)return !0;const b=t.aabb.closestPoint(h);return b[0]===h[0]&&b[1]===h[1]};if(this.renderWorldCopies)for(let e=1;e<=3;e++)C.push(S(-e)),C.push(S(e));for(C.push(S(0));C.length>0;){const o=C.pop(),s=o.x,a=o.y;let l=o.fullyVisible;const u=()=>"globe"===this.projection.name&&(0===o.y||o.y===(1<<o.zoom)-1);if(!l){let t=v?o.aabb.intersects(_):o.aabb.intersectsFlat(_);if(0===t&&u()){const i=new e.bT(o.zoom,s,a);t=e.bU(this,c,i,!0).intersects(_);}if(0===t)continue;l=2===t;}if(o.zoom!==R&&M(o))for(let t=0;t<4;t++){const i=(s<<1)+t%2,h=(a<<1)+(t>>1),u={aabb:n?o.aabb.quadrant(t):e.bV(this,c,o.zoom+1,i,h,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:h,wrap:o.wrap,fullyVisible:l,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};r&&!d&&(u.tileID=new e.aH(o.zoom+1===R?D:o.zoom+1,o.wrap,o.zoom+1,i,h),L(u)),C.push(u);}else {const r=o.zoom===R?D:o.zoom;if(t.minzoom&&t.minzoom>r)continue;let n=0;if(!l){let i=v?o.aabb.intersectsPrecise(_):o.aabb.intersectsPreciseFlat(_);if(0===i&&u()){const t=new e.bT(o.zoom,s,a);i=e.bU(this,c,t,!0).intersectsPrecise(_);}if(0===i)continue;if(t.calculateQuadrantVisibility)if(_.containsPoint(o.aabb.center))n=15;else for(let e=0;e<4;e++)0!==o.aabb.quadrant(e).intersects(_)&&(n|=1<<e);}const d=h[0]-(.5+s+(o.wrap<<o.zoom))*(1<<i-o.zoom),p=h[1]-.5-a,f=o.tileID?o.tileID:new e.aH(r,o.wrap,o.zoom,s,a);t.calculateQuadrantVisibility&&(f.visibleQuadrants=n),I.push({tileID:f,distanceSq:d*d+p*p});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();I=I.filter((s=>{const r=[0,0,0,1],n=[e.ai,e.ai,0,1],a=this.calculateFogTileMatrix(s.tileID.toUnwrapped());e.ad.vec4.transformMat4(r,r,a),e.ad.vec4.transformMat4(n,n,a);const l=e.ad.vec4.min([],r,n),c=e.ad.vec4.max([],r,n),h=e.bW(l,c);if(0===h)return !0;let d=!1;const u=this._elevation;if(u&&h>i&&0!==o){const i=this.calculateProjMatrix(s.tileID.toUnwrapped());let r;t.isTerrainDEM||(r=u.getMinMaxForTile(s.tileID)),r||(r={min:w,max:b});const n=e.c7(this.rotation),a=[n[0]*e.ai,n[1]*e.ai,r.max];e.ad.vec3.transformMat4(a,a,i),d=(1-a[1])*this.height*.5<o;}return h<i||d}));}return I.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.ay(t.lat,-e.bX,e.bX),o=this.projection.project(t.lng,i);return new e.P(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/e.bH(1,this.center.lat)/this.worldSize}setLocationAtPoint(t,i){let o,s;const r=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;o=(i.x-r.x)/e,s=(i.y-r.y)/e;}else {const e=this.pointCoordinate(i),t=this.pointCoordinate(r);o=e.x-t.x,s=e.y-t.y;}const n=this.locationCoordinate(t);this.setLocation(new e.ac(n.x-o,n.y-s));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e,t){return this.projection.locationPoint(this,e,t)}locationPoint3D(e,t){return this.projection.locationPoint(this,e,t,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e,t){return this.coordinateLocation(this.pointCoordinate3D(e,t))}locationCoordinate(t,i){const o=i?e.bH(i,t.lat):void 0,s=this.projection.project(t.lng,t.lat);return new e.ac(s.x,s.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,s=[t.x,t.y,0,1],r=[t.x,t.y,1,1];e.ad.vec4.transformMat4(s,s,this.pixelMatrixInverse),e.ad.vec4.transformMat4(r,r,this.pixelMatrixInverse);const n=r[3];e.ad.vec4.scale(s,s,1/s[3]),e.ad.vec4.scale(r,r,1/n);const a=s[2],l=r[2];return {p0:s,p1:r,t:a===l?0:(o-a)/(l-a)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.ad.vec4.transformMat4(i,i,this.pixelMatrixInverse),e.ad.vec4.transformMat4(o,o,this.pixelMatrixInverse),e.ad.vec4.scale(i,i,1/i[3]),e.ad.vec4.scale(o,o,1/o[3]),i[2]=e.bH(i[2],this._center.lat)*this.worldSize,o[2]=e.bH(o[2],this._center.lat)*this.worldSize,e.ad.vec4.scale(i,i,1/this.worldSize),e.ad.vec4.scale(o,o,1/this.worldSize),new e.as([i[0],i[1],i[2]],e.ad.vec3.normalize([],e.ad.vec3.sub([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:s}=t,r=e.bH(i[2],this._center.lat),n=e.bH(o[2],this._center.lat);return new e.ac(e.ah(i[0],o[0],s)/this.worldSize,e.ah(i[1],o[1],s)/this.worldSize,e.ah(r,n,s))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(t,i){if(!this.elevation)return this.pointCoordinate(t,i);let o=this.projection.pointCoordinate3D(this,t.x,t.y);if(o)return new e.ac(o[0],o[1],o[2]);let s=0,r=this.horizonLineFromTop();if(t.y>r)return this.pointCoordinate(t,i);const n=.02*r,a=t.clone();for(let t=0;t<10&&r-s>n;t++){a.y=e.ah(s,r,.66);const t=this.projection.pointCoordinate3D(this,a.x,a.y);t?(r=a.y,o=t):s=a.y;}return o?new e.ac(o[0],o[1],o[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(t){if(t.y<0||t.y>this.height||t.x<0||t.x>this.width)return !1;if(this.elevation||this.zoom>=e.bY)return !this.isPointAboveHorizon(t);const i=this.pointCoordinate(t);return i.y>=0&&i.y<=1}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,s=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.ad.vec4.transformMat4(s,s,this.pixelMatrix),s[3]>0?new e.P(s[0]/s[3],s[1]/s[3]):new e.P(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:t,left:i}=this._edgeInsets,o=this.height-this._edgeInsets.bottom,s=this.width-this._edgeInsets.right,r=this.pointLocation3D(new e.P(i,t)),n=this.pointLocation3D(new e.P(s,t)),a=this.pointLocation3D(new e.P(s,o)),l=this.pointLocation3D(new e.P(i,o));let c=Math.min(r.lng,n.lng,a.lng,l.lng),h=Math.max(r.lng,n.lng,a.lng,l.lng),d=Math.min(r.lat,n.lat,a.lat,l.lat),u=Math.max(r.lat,n.lat,a.lat,l.lat);const _=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(t,i,o,s,r)=>{const n=(t+o)/2,a=(i+s)/2,l=new e.P(n,a),{lng:m,lat:g}=this.pointLocation3D(l),v=Math.max(0,c-m,d-g,m-h,g-u);c=Math.min(c,m),h=Math.max(h,m),d=Math.min(d,g),u=Math.max(u,g),(r<p||v>_)&&(f(t,i,n,a,r+1),f(n,a,o,s,r+1));};if(f(i,t,s,t,1),f(s,t,s,o,1),f(s,o,i,o,1),f(i,o,i,t,1),"globe"===this.projection.name){const[t,i]=e.bZ(this);t?(u=90,h=180,c=-180):i&&(d=-90,h=180,c=-180);}return new e.aB(new e.bO(c,d),new e.bO(h,u))}_getBoundsRectangular(t,i){const{top:o,left:s}=this._edgeInsets,r=this.height-this._edgeInsets.bottom,n=this.width-this._edgeInsets.right,a=new e.P(s,o),l=new e.P(n,o),c=new e.P(n,r),h=new e.P(s,r);let d=this.pointCoordinate(a,t),u=this.pointCoordinate(l,t);const _=this.pointCoordinate(c,i),p=this.pointCoordinate(h,i),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return d.y>1&&u.y>=0?d=new e.ac((1-p.y)/f(p,d)+p.x,1):d.y<0&&u.y<=1&&(d=new e.ac(-p.y/f(p,d)+p.x,0)),u.y>1&&d.y>=0?u=new e.ac((1-_.y)/f(_,u)+_.x,1):u.y<0&&d.y<=1&&(u=new e.ac(-_.y/f(_,u)+_.x,0)),(new e.aB).extend(this.coordinateLocation(d)).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(_))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return "mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))-this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-e.bX,this.maxLat=e.bX,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.av(this.minLng)*this.tileSize,this.worldMaxX=e.av(this.maxLng)*this.tileSize,this.worldMinY=e.aC(this.maxLat)*this.tileSize,this.worldMaxY=e.aC(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const s=t.canonical,r=1/this.height,n=this.cameraWorldSize,a=n/this.zoomScale(s.z),l=(s.x+Math.pow(2,s.z)*t.wrap)*a,c=s.y*a,h=this.point;h.x*=n/this.worldSize,h.y*=n/this.worldSize;const d=this.angle,u=Math.sin(-d),_=-Math.cos(-d);return o[i]={bearing:[u,_],center:[(h.x-l)*r,(h.y-c)*r],scale:a/e.ai*r},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const s=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,t);return e.ad.mat4.multiply(s,this.worldToFogMatrix,s),o[i]=new Float32Array(s),o[i]}calculateProjMatrix(t,i=!1,o=!1){const s=t.key;let r;if(r=o?this._expandedProjMatrixCache:i?this._alignedProjMatrixCache:this._projMatrixCache,r[s])return r[s];const n=this.calculatePosMatrix(t,this.worldSize);let a;return a=this.projection.isReprojectedInTileSpace?this.mercatorMatrix:o?this.expandedFarZProjMatrix:i?this.alignedProjMatrix:this.projMatrix,e.ad.mat4.multiply(n,a,n),r[s]=new Float32Array(n),r[s]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const s=e.b_(t,this);return o[i]=s,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const t=1/this.worldSize,i=e.ad.mat4.fromScaling([],[t,t,t]);return e.ad.mat4.multiply(i,i,this.globeMatrix),i}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const t=this._elevation;this._updateCameraState();const i=e.bH(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),s=this._camera.forward(),r=e.bH(1,this._center.lat);o[2]/=r,s[2]/=r,e.ad.vec3.normalize(s,s);const n=t.raycast(o,s,t.exaggeration());if(n){const t=e.ad.vec3.scaleAndAdd([],o,s,n),i=new e.ac(t[0],t[1],e.bH(t[2],e.aT(t[1]))),a=(i.z+e.ad.vec3.length([i.x-o[0],i.y-o[1],i.z-o[2]*r]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(a),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCamera(t=!1){if(!this._elevation)return;const i=this._elevation,o=e.bH(1,this._center.lat)*this.worldSize,s=this._computeCameraPosition(o),r=i.getAtPointOrZero(new e.ac(...s)),n=this.pixelsPerMeter/this.worldSize*r,a=this._minimumHeightOverTerrain(),l=s[2]-n;if(l<=a)if(l<0||t){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[s[0],s[1],t.z-s[2]],o=e.ad.vec3.length(i);i[2]-=(a-l)/this._pixelsPerMercatorPixel;const r=e.ad.vec3.length(i);if(0===r)return;e.ad.vec3.scale(i,i,o/r*this._pixelsPerMercatorPixel),this._camera.position=[s[0],s[1],t.z*this._pixelsPerMercatorPixel-i[2]],this._updateStateFromCamera();}else this._isCameraConstrained=!0;}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||t){const i=this.center;return i.lat=e.ay(i.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!t)&&(i.lng=e.ay(i.lng,this.minLng,this.maxLng)),this.center=i,void(this._constraining=!1)}const i=this._unmodified,{x:o,y:s}=this.point;let r=0,n=o,a=s;const l=this.width/2,c=this.height/2,h=this.worldMinY*this.scale,d=this.worldMaxY*this.scale;if(s-c<h&&(a=h+c),s+c>d&&(a=d-c),d-h<this.height&&(r=Math.max(r,this.height/(d-h)),a=(d+h)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,i=this.worldSize/2-(e+t)/2;n=(o+i+this.worldSize)%this.worldSize-i,n-l<e&&(n=e+l),n+l>t&&(n=t-l),t-e<this.width&&(r=Math.max(r,this.width/(t-e)),n=(t+e)/2);}n===o&&a===s||this._allowWorldUnderZoom||(this.center=this.unproject(new e.P(n,a))),r&&!this._allowWorldUnderZoom&&(this.zoom+=this.scaleZoom(r)),this._constrainCamera(),this._unmodified=i,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i="globe"===this.projection.name,o=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=e.bH(1,this.center.lat)/e.bH(1,e.c8));const s=e.b$(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,s),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const r="meters"===this.projection.zAxisUnit?o:1,n=this._camera.getWorldToCamera(this.worldSize,r);let a;const l=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);if(l[8]=2*-t.x/this.width,l[9]=2*t.y/this.height,this.isOrthographic){let i=.5*this.height/Math.tan(this._fov/2)*1*Math.tan(.5*this._fov),o=i*this.aspect,s=-o,r=-i;o-=t.x,s-=t.x,i+=t.y,r+=t.y,a=this._camera.getCameraToClipOrthographic(s,o,r,i,this._nearZ,this._farZ),((t,i,o,s)=>{for(let r=0;r<16;r++)t[r]=e.ah(i[r],o[r],s);})(a,a,l,e.c9(this.pitch>=Yi?1:this.pitch/Yi));}else a=l;const c=e.ad.mat4.mul([],l,n);let h=e.ad.mat4.mul([],a,n);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.ad.mat4.identity([]);e.ad.mat4.translate(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.ad.mat4.multiply(i,i,e.c0(this)),e.ad.mat4.translate(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.ad.mat4.multiply(h,h,i),e.ad.mat4.multiply(c,c,i),this.inverseAdjustmentMatrix=e.c1(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];if(this.mercatorMatrix=e.ad.mat4.scale([],h,[this.worldSize,this.worldSize,this.worldSize/r,1]),this.projMatrix=h,this.invProjMatrix=e.ad.mat4.invert(new Float64Array(16),this.projMatrix),i){const i=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,1/0);i[8]=2*-t.x/this.width,i[9]=2*t.y/this.height,this.expandedFarZProjMatrix=e.ad.mat4.mul([],i,n);}else this.expandedFarZProjMatrix=this.projMatrix;const d=e.ad.mat4.invert([],a);this.frustumCorners=e.c2.fromInvProjectionMatrix(d,this.horizonLineFromTop(),this.height),this.cameraFrustum=e.bR.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,0,!i);const u=new Float32Array(16);e.ad.mat4.identity(u),e.ad.mat4.scale(u,u,[1,-1,1]),e.ad.mat4.rotateX(u,u,this._pitch),e.ad.mat4.rotateZ(u,u,this.angle);const _=e.ad.mat4.perspective(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ);this.starsProjMatrix=e.ad.mat4.clone(_);const p=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;_[8]=2*-t.x/this.width,_[9]=2*(t.y+p)/this.height,this.skyboxMatrix=e.ad.mat4.multiply(u,_,u);const f=this.point,m=f.x,g=f.y,v=this.width%2/2,y=this.height%2/2,x=Math.cos(this.angle),b=Math.sin(this.angle),w=m-Math.round(m)+x*v+b*y,T=g-Math.round(g)+x*y+b*v,E=new Float64Array(h);if(e.ad.mat4.translate(E,E,[w>.5?w-1:w,T>.5?T-1:T,0]),this.alignedProjMatrix=E,h=e.ad.mat4.create(),e.ad.mat4.scale(h,h,[this.width/2,-this.height/2,1]),e.ad.mat4.translate(h,h,[1,-1,0]),this.labelPlaneMatrix=h,h=e.ad.mat4.create(),e.ad.mat4.scale(h,h,[1,-1,1]),e.ad.mat4.translate(h,h,[-1,-1,0]),e.ad.mat4.scale(h,h,[2/this.width,2/this.height,1]),this.glCoordMatrix=h,this.pixelMatrix=e.ad.mat4.multiply(new Float64Array(16),this.labelPlaneMatrix,c),this._calcFogMatrices(),this._distanceTileDataCache={},h=e.ad.mat4.invert(new Float64Array(16),this.pixelMatrix),!h)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=h,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=e.c3(this);const t=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=e.ad.vec3.transformMat4(t,t,n),this.globeRadius=this.worldSize/2/Math.PI-1;}else this.globeMatrix=h;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={},this._expandedProjMatrixCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSizeForFog,i=this.cameraPixelsPerMeter,o=this._camera.position,s=1/this.height/this._pixelsPerMercatorPixel,r=[t,t,i];e.ad.vec3.scale(r,r,s),e.ad.vec3.scale(o,o,-1),e.ad.vec3.multiply(o,o,r);const n=e.ad.mat4.create();e.ad.mat4.translate(n,n,o),e.ad.mat4.scale(n,n,r),this.mercatorFogMatrix=n,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,s);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,s=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*s,o.y/this.worldSize-i[1]*s,e/this.worldSize*this._centerAltitude-i[2]*s]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=this._camera.position[2],s=t[2];let r=1;this.projection.wrap&&(this.center=this.center.wrap()),s>0&&(r=Math.min((i-o)/s,1)),this._camera.position=e.ad.vec3.scaleAndAdd([],this._camera.position,t,r),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:s}=this._camera.getPitchBearing(),r=e.bH(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.ak(this._maxPitch)),a=Math.max((t[2]-r)/Math.cos(o),n),l=this._zoomFromMercatorZ(a);e.ad.vec3.scaleAndAdd(t,t,i,a),this._pitch=e.ay(o,e.ak(this.minPitch),e.ak(this.maxPitch)),this.angle=e.bF(s,-Math.PI,Math.PI),this._setZoom(e.ay(l,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new e.ac(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min(null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom,this._maxZoom)+4;return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}zoomFromMercatorZAdjusted(t){let i=0,o=e.bY,s=0,r=1/0;for(;o-i>1e-6&&o>i;){const e=i+.5*(o-i),n=this.tileSize*Math.pow(2,e),a=this.getCameraToCenterDistance(this.projection,e,n),l=this.scaleZoom(a/(t*this.tileSize)),c=Math.abs(e-l);c<r&&(r=c,s=e),e<l?i=e:o=e;}return s}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.w("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),s=Math.max(t.x,i.x),r=Math.min(t.y,i.y),n=Math.max(t.y,i.y);if(r<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const a=[new e.P(o,r),new e.P(s,n),new e.P(o,n),new e.P(s,r)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of a){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.c4(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.P(0,0),new e.P(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.ad.vec3.length(e.ad.vec3.sub([],this._camera.position,t)),s=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(s)}getCameraPoint(){if("globe"===this.projection.name){const t=function([t,i,o],s){const r=[t,i,o,1];e.ad.vec4.transformMat4(r,r,s);const n=r[3]=Math.max(r[3],1e-6);return r[0]/=n,r[1]/=n,r[2]/=n,r}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new e.P(t[0],t[1])}{const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}}getCameraToCenterDistance(t,i=this.zoom,o=this.worldSize){const s=e.b$(t,i,this.width,this.height,1024),r=t.pixelSpaceConversion(this.center.lat,o,s);let n=.5/Math.tan(.5*this._fov)*this.height*r;return this.isOrthographic&&(n=e.ah(1,n,e.c9(this.pitch>=Yi?1:this.pitch/Yi))),n}getWorldToCameraMatrix(){const t=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return "globe"===this.projection.name&&e.ad.mat4.multiply(t,t,this.globeMatrix),t}getFrustum(t){return e.bR.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,"meters"===this.projection.zAxisUnit)}}const Qi=(t,i)=>{if(i>0&&t.terrain&&e.w("Cutoff is currently disabled on terrain"),i<=0||t.terrain)return {shouldRenderCutoff:!1,uniformValues:{u_cutoff_params:[0,0,0,1]}};const o=t.transform,s=Math.max(Math.abs(o._zoom-(t.minCutoffZoom-1)),1),r=o.isLODDisabled(!1)?e.ae(60,45,o.pitch):e.ae(30,15,o.pitch),n=o._farZ-o._nearZ,a=i*o.height,l=((1-(c=r))*o.cameraToCenterDistance+c*(o._farZ+a))*s;var c;return {shouldRenderCutoff:r<1,uniformValues:{u_cutoff_params:[o._nearZ,o._farZ,(l-o._nearZ)/n,(l-a-o._nearZ)/n]}}},eo={cascadeCount:2,normalOffset:3,shadowMapResolution:2048};class to{constructor(e,t){this.aabb=e,this.lastCascade=t;}}class io{add(e,t){const i=this.receivers[e.key];void 0!==i?(i.aabb.min[0]=Math.min(i.aabb.min[0],t.min[0]),i.aabb.min[1]=Math.min(i.aabb.min[1],t.min[1]),i.aabb.min[2]=Math.min(i.aabb.min[2],t.min[2]),i.aabb.max[0]=Math.max(i.aabb.max[0],t.max[0]),i.aabb.max[1]=Math.max(i.aabb.max[1],t.max[1]),i.aabb.max[2]=Math.max(i.aabb.max[2],t.max[2])):this.receivers[e.key]=new to(t,null);}clear(){this.receivers={};}get(e){return this.receivers[e.key]}computeRequiredCascades(t,i,o){const s=e.ce.fromPoints(t.points);let r=0;for(const t in this.receivers){const n=this.receivers[t];if(!n)continue;if(!s.intersectsAabb(n.aabb))continue;n.aabb.min=s.closestPoint(n.aabb.min),n.aabb.max=s.closestPoint(n.aabb.max);const a=n.aabb.getCorners();for(let t=0;t<o.length;t++){let s=!0;for(const r of a){const n=[r[0]*i,r[1]*i,r[2]];if(e.ad.vec3.transformMat4(n,n,o[t].matrix),n[0]<-1||n[0]>1||n[1]<-1||n[1]>1){s=!1;break}}if(n.lastCascade=t,r=Math.max(r,t),s)break}}return r+1}}class oo{constructor(e){this.painter=e,this._enabled=!1,this._shadowLayerCount=0,this._numCascadesToRender=0,this._cascades=[],this._groundShadowTiles=[],this._receivers=new io,this._depthMode=new Bi(e.context.gl.LEQUAL,Bi.ReadWrite,[0,1]),this._uniformValues={u_light_matrix_0:new Float32Array(16),u_light_matrix_1:new Float32Array(16),u_shadow_intensity:0,u_fade_range:[0,0],u_shadow_normal_offset:[1,1,1],u_shadow_texel_size:1,u_shadow_map_resolution:1,u_shadow_direction:[0,0,1],u_shadow_bias:[36e-5,.0012,.012],u_shadowmap_0:0,u_shadowmap_1:0},this._forceDisable=!1,this.useNormalOffset=!1,e.tp.registerParameter(this,["Shadows"],"_forceDisable",{label:"forceDisable"},(()=>{this.painter.style.map.triggerRepaint();})),e.tp.registerParameter(eo,["Shadows"],"cascadeCount",{min:1,max:2,step:1}),e.tp.registerParameter(eo,["Shadows"],"normalOffset",{min:0,max:10,step:.05}),e.tp.registerParameter(eo,["Shadows"],"shadowMapResolution",{min:32,max:2048,step:32}),e.tp.registerBinding(this,["Shadows"],"_numCascadesToRender",{readonly:!0,label:"numCascadesToRender"});}destroy(){for(const e of this._cascades)e.texture.destroy(),e.framebuffer.destroy();this._cascades=[];}updateShadowParameters(t,i){const o=this.painter;if(this._enabled=!1,this._shadowLayerCount=0,this._receivers.clear(),!i||!i.properties)return;const s=i.properties.get("shadow-intensity");if(!i.shadowsEnabled()||s<=0)return;if(this._shadowLayerCount=o.style.order.reduce(((e,i)=>{const s=o.style._mergedLayers[i];return e+(s.hasShadowPass()&&!s.isHidden(t.zoom)?1:0)}),0),this._enabled=this._shadowLayerCount>0,!this.enabled)return;const r=o.context,n=eo.shadowMapResolution,a=eo.shadowMapResolution;if(0===this._cascades.length||eo.shadowMapResolution!==this._cascades[0].texture.size[0]){this._cascades=[];for(let t=0;t<eo.cascadeCount;++t){const t=o._shadowMapDebug,i=r.gl,s=r.createFramebuffer(n,a,t,"texture"),l=new e.T(r,{width:n,height:a,data:null},i.DEPTH_COMPONENT16);if(s.depthAttachment.set(l.texture),t){const t=new e.T(r,{width:n,height:a,data:null},i.RGBA8);s.colorAttachment.set(t.texture);}this._cascades.push({framebuffer:s,texture:l,matrix:[],far:0,boundingSphereRadius:0,frustum:new e.bR,scale:0});}}this.shadowDirection=ro(i);let l=0;if(t.elevation){const e=t.elevation,i=[1e4,-1e4];e.visibleDemTiles.filter((e=>e.dem)).forEach((e=>{const t=e.dem.tree;i[0]=Math.min(i[0],t.minimums[0]),i[1]=Math.max(i[1],t.maximums[0]);})),1e4!==i[0]&&(l=(i[1]-i[0])*e.exaggeration());}const c=1.5*t.cameraToCenterDistance,h=3*c,d=new Float64Array(16);for(let i=0;i<this._cascades.length;++i){const o=this._cascades[i];let s=t.height/50,r=1;1===eo.cascadeCount?r=h:0===i?r=c:(s=c,r=h);const[n,a]=ao(t,this.shadowDirection,s,r,eo.shadowMapResolution,l);o.scale=t.scale,o.matrix=n,o.boundingSphereRadius=a,e.ad.mat4.invert(d,o.matrix),o.frustum=e.bR.fromInvProjectionMatrix(d,1,0,!0),o.far=r;}const u=this._cascades.length-1;this._uniformValues.u_fade_range=[.75*this._cascades[u].far,this._cascades[u].far],this._uniformValues.u_shadow_intensity=s,this._uniformValues.u_shadow_direction=[this.shadowDirection[0],this.shadowDirection[1],this.shadowDirection[2]],this._uniformValues.u_shadow_texel_size=1/eo.shadowMapResolution,this._uniformValues.u_shadow_map_resolution=eo.shadowMapResolution,this._uniformValues.u_shadowmap_0=Xi.ShadowMap0,this._uniformValues.u_shadowmap_1=Xi.ShadowMap0+1,this._groundShadowTiles=o.transform.coveringTiles({tileSize:512,renderWorldCopies:!0});const _=o.transform.elevation;for(const e of this._groundShadowTiles){let t={min:0,max:0};if(_){const i=_.getMinMaxForTile(e);i&&(t=i);}this.addShadowReceiver(e.toUnwrapped(),t.min,t.max);}}get enabled(){return this._enabled&&!this._forceDisable}set enabled(e){this._enabled=e;}drawShadowPass(t,i){if(!this.enabled)return;const o=this.painter,s=o.context;this._numCascadesToRender=this._receivers.computeRequiredCascades(o.transform.getFrustum(0),o.transform.worldSize,this._cascades),s.viewport.set([0,0,eo.shadowMapResolution,eo.shadowMapResolution]);for(let r=0;r<this._numCascadesToRender;++r){o.currentShadowCascade=r,s.bindFramebuffer.set(this._cascades[r].framebuffer.framebuffer),s.clear({color:e.al.white,depth:1});for(const e of t.order){const s=t._mergedLayers[e];if(!s.hasShadowPass()||s.isHidden(o.transform.zoom))continue;const r=t.getLayerSourceCache(s),n=r?i[r.id]:void 0;("model"===s.type||n&&n.length)&&o.renderLayer(o,r,s,n);}}o.currentShadowCascade=0;}drawGroundShadows(){if(!this.enabled)return;const e=this.painter,t=e.style,i=e.context,o=t.directionalLight,s=t.ambientLight;if(!o||!s)return;const r=[],n=Qi(e,e.longestCutoffRange);n.shouldRenderCutoff&&r.push("RENDER_CUTOFF"),r.push("RENDER_SHADOWS","DEPTH_TEXTURE"),this.useNormalOffset&&r.push("NORMAL_OFFSET");const a=no(t,o,s),l=new Bi(i.gl.LEQUAL,Bi.ReadOnly,e.depthRangeFor3D);for(const t of this._groundShadowTiles){const o=t.toUnwrapped(),s=e.isTileAffectedByFog(t),c=e.getOrCreateProgram("groundShadow",{defines:r,overrideFog:s});this.setupShadows(o,c),e.uploadCommonUniforms(i,c,o,null,n);const h={u_matrix:e.transform.calculateProjMatrix(o),u_ground_shadow_factor:a};c.draw(e,i.gl.TRIANGLES,l,Ui.disabled,ki.multiply,ji.disabled,h,"ground_shadow",e.tileExtentBuffer,e.quadTriangleIndexBuffer,e.tileExtentSegments,null,e.transform.zoom,null,null);}}getShadowPassColorMode(){return this.painter._shadowMapDebug?ki.unblended:ki.disabled}getShadowPassDepthMode(){return this._depthMode}getShadowCastingLayerCount(){return this._shadowLayerCount}calculateShadowPassMatrixFromTile(t){const i=this.painter.transform,o=i.calculatePosMatrix(t,i.worldSize);return e.ad.mat4.multiply(o,this._cascades[this.painter.currentShadowCascade].matrix,o),Float32Array.from(o)}calculateShadowPassMatrixFromMatrix(t){return e.ad.mat4.multiply(t,this._cascades[this.painter.currentShadowCascade].matrix,t),Float32Array.from(t)}setupShadows(t,i,o,s=0){if(!this.enabled)return;const r=this.painter.transform,n=this.painter.context,a=n.gl,l=this._uniformValues,c=new Float64Array(16),h=r.calculatePosMatrix(t,r.worldSize);for(let t=0;t<this._cascades.length;t++)e.ad.mat4.multiply(c,this._cascades[t].matrix,h),l[0===t?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(c),n.activeTexture.set(a.TEXTURE0+Xi.ShadowMap0+t),this._cascades[t].texture.bind(a.NEAREST,a.CLAMP_TO_EDGE);if(this.useNormalOffset=!!o,this.useNormalOffset){const i=e.cd(t.canonical),n=2/r.tileSize*e.ai/eo.shadowMapResolution,a=n*this._cascades[0].boundingSphereRadius,c=n*this._cascades[this._cascades.length-1].boundingSphereRadius,h=("vector-tile"===o?1:3)/Math.pow(2,s-t.canonical.z-(1-r.zoom+Math.floor(r.zoom)));l.u_shadow_normal_offset=[i,a*h,c*h],l.u_shadow_bias=[6e-5,.0012,.012];}else l.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(n,l);}setupShadowsFromMatrix(t,i,o=!1){if(!this.enabled)return;const s=this.painter.context,r=s.gl,n=this._uniformValues,a=new Float64Array(16);for(let i=0;i<eo.cascadeCount;i++)e.ad.mat4.multiply(a,this._cascades[i].matrix,t),n[0===i?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(a),s.activeTexture.set(r.TEXTURE0+Xi.ShadowMap0+i),this._cascades[i].texture.bind(r.NEAREST,r.CLAMP_TO_EDGE);if(this.useNormalOffset=o,o){const e=eo.normalOffset;n.u_shadow_normal_offset=[1,e,e],n.u_shadow_bias=[6e-5,.0012,.012];}else n.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(s,n);}getShadowUniformValues(){return this._uniformValues}getCurrentCascadeFrustum(){return this._cascades[this.painter.currentShadowCascade].frustum}computeSimplifiedTileShadowVolume(t,i,o,s){if(s[2]>=0)return {};const r=function(t,i,o){const s=o/(1<<t.canonical.z);return new e.ce([t.canonical.x*s+t.wrap*o,t.canonical.y*s+t.wrap*o,0],[(t.canonical.x+1)*s+t.wrap*o,(t.canonical.y+1)*s+t.wrap*o,i])}(t,i,o).getCorners(),n=i/-s[2];s[0]<0?(e.ad.vec3.add(r[0],r[0],[s[0]*n,0,0]),e.ad.vec3.add(r[3],r[3],[s[0]*n,0,0])):s[0]>0&&(e.ad.vec3.add(r[1],r[1],[s[0]*n,0,0]),e.ad.vec3.add(r[2],r[2],[s[0]*n,0,0])),s[1]<0?(e.ad.vec3.add(r[0],r[0],[0,s[1]*n,0]),e.ad.vec3.add(r[1],r[1],[0,s[1]*n,0])):s[1]>0&&(e.ad.vec3.add(r[2],r[2],[0,s[1]*n,0]),e.ad.vec3.add(r[3],r[3],[0,s[1]*n,0]));const a={};return a.vertices=r,a.planes=[so(r[1],r[0],r[4]),so(r[2],r[1],r[5]),so(r[3],r[2],r[6]),so(r[0],r[3],r[7])],a}addShadowReceiver(t,i,o){this._receivers.add(t,e.ce.fromTileIdAndHeight(t,i,o));}getMaxCascadeForTile(e){const t=this._receivers.get(e);return t&&t.lastCascade?t.lastCascade:0}}function so(t,i,o){const s=e.ad.vec3.sub([],o,i),r=e.ad.vec3.sub([],t,i),n=e.ad.vec3.cross([],s,r),a=e.ad.vec3.length(n);return 0===a?[0,0,1,0]:(e.ad.vec3.scale(n,n,1/a),[n[0],n[1],n[2],-e.ad.vec3.dot(n,i)])}function ro(t){const i=t.properties.get("direction"),o=e.cc(i.x,i.y,i.z);o[2]=e.ay(o[2],0,75);const s=e.cf([o[0],o[1],o[2]]);return e.ad.vec3.fromValues(s.x,s.y,s.z)}function no(t,i,o){const s="none"===i.properties.get("color-use-theme"),r=i.properties.get("color"),n=i.properties.get("intensity"),a=i.properties.get("direction"),l=[a.x,a.y,a.z],c="none"===o.properties.get("color-use-theme"),h=o.properties.get("color"),d=o.properties.get("intensity"),u=Math.max(e.ad.vec3.dot([0,0,1],l),0),_=[0,0,0];e.ad.vec3.scale(_,h.toRenderColor(c?null:t.getLut(i.scope)).toArray01Linear().slice(0,3),d);const p=[0,0,0];return e.ad.vec3.scale(p,r.toRenderColor(s?null:t.getLut(o.scope)).toArray01Linear().slice(0,3),u*n),e.cg([_[0]>0?_[0]/(_[0]+p[0]):0,_[1]>0?_[1]/(_[1]+p[1]):0,_[2]>0?_[2]/(_[2]+p[2]):0])}function ao(t,i,o,s,r,n){const a=t.zoom,l=t.scale,c=t.worldSize,h=1/c,d=t.aspect,u=Math.sqrt(1+d*d)*Math.tan(.5*t.fovX),_=u*u,p=s-o,f=s+o;let m,g;_>p/f?(m=s,g=s*u):(m=.5*f*(1+_),g=.5*Math.sqrt(p*p+2*(s*s+o*o)*_+f*f*_*_));const v=t.projection.pixelsPerMeter(t.center.lat,c),y=t._camera.getCameraToWorldMercator(),x=[0,0,-m*h];e.ad.vec3.transformMat4(x,x,y);let b=g*h;const w=t._edgeInsets;if(!(0===w.left&&0===w.top&&0===w.right&&0===w.bottom||w.left===w.right&&w.top===w.bottom)){const i=t._camera.getWorldToCamera(t.worldSize,"meters"===t.projection.zAxisUnit?v:1),r=t._camera.getCameraToClipPerspective(t._fov,t.width/t.height,o,s);r[8]=2*-t.centerOffset.x/t.width,r[9]=2*t.centerOffset.y/t.height;const n=new Float64Array(16);e.ad.mat4.mul(n,r,i);const h=new Float64Array(16);e.ad.mat4.invert(h,n);const d=e.bR.fromInvProjectionMatrix(h,c,a,!0);for(const i of d.points){const o=((T=i)[0]/=l,T[1]/=l,T[2]=e.bH(T[2],t._center.lat),T);b=Math.max(b,e.ad.vec3.len(e.ad.vec3.subtract([],x,o)));}}var T;b*=r/(r-1);const E=Math.acos(i[2]),S=Math.atan2(-i[0],-i[1]),C=new $i;C.position=x,C.setPitchBearing(E,S);const I=C.getWorldToCamera(c,v),R=b*c,D=Math.min(t._mercatorZfromZoom(17)*c*-2,-2*R),A=C.getCameraToClipOrthographic(-R,R,-R,R,D,(R+n*v)/i[2]),L=new Float64Array(16);e.ad.mat4.multiply(L,A,I);const P=e.ad.vec3.fromValues(Math.floor(1e6*x[0])/1e6*c,Math.floor(1e6*x[1])/1e6*c,0),M=.5*r,z=[0,0,0];e.ad.vec3.transformMat4(z,P,L),e.ad.vec3.scale(z,z,M);const O=[Math.floor(z[0]),Math.floor(z[1]),Math.floor(z[2])],F=[0,0,0];e.ad.vec3.sub(F,z,O),e.ad.vec3.scale(F,F,-1/M);const k=new Float64Array(16);return e.ad.mat4.identity(k),e.ad.mat4.translate(k,k,F),e.ad.mat4.multiply(L,k,L),[L,R]}class lo extends e.E{constructor(e){super(),this.requestManager=e,this.models={"":{}},this.modelUris={"":{}},this.numModelsLoading={};}loadModel(t,i){return e.aN(this.requestManager.transformRequest(i,e.R.Model).url).then((i=>{if(!i)return;const o=e.aO(i),s=new e.aP(t,void 0,void 0,o);return s.computeBoundsAndApplyParent(),s})).catch((o=>{if(o&&404===o.status)return null;this.fire(new e.z(new Error(`Could not load model ${t} from ${i}: ${o.message}`)));}))}load(t,i,o={keepNumReferences:!1}){this.models[i]||(this.models[i]={});const s=Object.keys(t);this.numModelsLoading[i]=(this.numModelsLoading[i]||0)+s.length;const r=[];for(const e of s)r.push(this.loadModel(e,t[e]));Promise.allSettled(r).then((t=>{for(let e=0;e<t.length;e++){const{status:r,value:n}=t[e];if("fulfilled"===r&&n){const t=this.models[i][s[e]];this.models[i][s[e]]={model:n,numReferences:o.keepNumReferences&&t?t.numReferences:1};}}this.numModelsLoading[i]-=s.length,this.fire(new e.A("data",{dataType:"style"}));})).catch((t=>{this.fire(new e.z(new Error(`Could not load models: ${t.message}`)));}));}isLoaded(){for(const e in this.numModelsLoading)if(this.numModelsLoading[e]>0)return !1;return !0}hasModel(e,t){return !!this.getModel(e,t)}getModel(e,t){return this.models[t]||(this.models[t]={}),this.models[t][e]?this.models[t][e].model:void 0}addModel(e,t,i){this.models[i]||(this.models[i]={}),this.modelUris[i]||(this.modelUris[i]={}),this.hasModel(e,i)&&this.models[i][e].numReferences++,this.modelUris[i][e]=this.requestManager.normalizeModelURL(t),this.load({[e]:this.modelUris[i][e]},i);}addModels(e,t){this.models[t]||(this.models[t]={}),this.modelUris[t]||(this.modelUris[t]={});const i=this.modelUris[t];for(const o in e)this.models[t][o]={},i[o]=this.requestManager.normalizeModelURL(e[o]);this.load(i,t,{keepNumReferences:!0});}reloadModels(e){this.load(this.modelUris[e],e);}addModelsFromBucket(e,t){this.models[t]||(this.models[t]={}),this.modelUris[t]||(this.modelUris[t]={});const i={};for(const o of e)this.hasModel(o,t)?this.models[t][o].numReferences++:(this.modelUris[t][o]=this.requestManager.normalizeModelURL(o),i[o]=this.modelUris[t][o]);this.load(i,t);}removeModel(e,t){if(this.models[t]&&this.models[t][e]&&(this.models[t][e].numReferences--,0===this.models[t][e].numReferences)){const i=this.models[t][e].model;delete this.models[t][e],delete this.modelUris[t][e],i.destroy();}}listModels(e){return this.models[e]||(this.models[e]={}),Object.keys(this.models[e])}upload(e,t){this.models[t]||(this.models[t]={});for(const i in this.models[t])this.models[t][i].model&&this.models[t][i].model.upload(e.context);}}const co=new e.a7({data:new e.a8(e.a5.colorTheme.data)}),ho={"mbx-indoor-active-floorplans":{default:["literal",[]]},"mbx-indoor-underground":{default:["literal",!1]},"mbx-indoor-loaded-levels":{default:["literal",[]]},"mbx-indoor-level-height":{default:["literal",{}]},"mbx-indoor-level-base":{default:["literal",{}]},"mbx-indoor-level-selected":{default:["literal",{}]},"mbx-indoor-level-overlapped":{default:["literal",{}]}};function uo(e){return e=e||{},Object.assign(e,ho)}class _o extends e.E{constructor(t){super(),this.mergeFloors=!0,this._scope=void 0,this._queryFeatureSetId=void 0,this._buildingEntryFeatureSetId=void 0,this._selectedFloorplan=void 0,this._indoorData=void 0,this._selectedLevel=void 0,this._floorplanStates={},e.aQ(["_onLoad","_onMove","_checkFloorplanVisible"],this),this._map=t,this._checkFloorplanVisible(!0),this._map.on("load",this._onLoad),this._map.on("move",this._onMove);}destroy(){this._map.indoor.off("load",this._onLoad),this._map.indoor.off("move",this._onMove),this._map=void 0;}_onLoad(){this._map.style.forEachFragmentStyle((t=>{t.stylesheet.indoor&&(this._queryFeatureSetId?this.fire(new e.z(new Error("Multiple indoor map styles detected, simultaneous usage is not allowed currently."))):(this._queryFeatureSetId=t.stylesheet.indoor.floorplanFeaturesetId,this._buildingEntryFeatureSetId=t.stylesheet.indoor.buildingFeaturesetId,this._scope=t.scope));})),this._queryFeatureSetId&&this._buildingEntryFeatureSetId&&this._map.addInteraction("mbx-indoor-buildingclick",{type:"click",target:{featuresetId:this._buildingEntryFeatureSetId,importId:this._scope},handler:e=>(e.feature&&e.feature.properties.floorplan&&this.selectFloorplan(e.feature.properties.floorplan),!0)}),this._checkFloorplanVisible(!0);}_onMove(){this._checkFloorplanVisible(!1);}_checkFloorplanVisible(t){if(!this._queryFeatureSetId)return;if(!this._map.isStyleLoaded())return;if(this._map.transform.zoom<13)return;this._indoorData&&!function(e,t){const[i,o]=e,{center:s,radius:r}=t,[n,a]=s,l=Math.abs(i-n);return Math.sqrt((l>180?360-l:l)**2+(o-a)**2)<=r}([this._map.getCenter().lng,this._map.getCenter().lat],this._indoorData.circumCircle)&&(this._indoorData=void 0,this._selectedFloorplan=void 0,this._map.setConfigProperty(this._scope,"mbx-indoor-underground",!1),this._map.setConfigProperty(this._scope,"mbx-indoor-active-floorplans",["literal",[]]),this.fire(new e.A("floorplangone")));const i={target:{featuresetId:this._queryFeatureSetId,importId:this._scope}},o=new e.P(this._map.transform.width/2,this._map.transform.height/2),s=[new e.P(0,0),new e.P(this._map.transform.width,this._map.transform.height)],r=this._map.queryRenderedFeatures(t?s:o,i);r.length>0&&(this._selectedFloorplan&&r[0].properties.id===this._selectedFloorplan.properties.id||(this._selectedFloorplan=r[0],this._floorplanSelected(!1)));}_floorplanSelected(t){this._indoorData=JSON.parse(this._selectedFloorplan.properties["indoor-data"]),this._indoorData.id=this._selectedFloorplan.properties.id,this._indoorData.circumCircle=function(e){const[[t,i],[o,s]]=e,r=(o-t+360)%360,n=r>180?360-r:r;return {center:[(t+n/2+360)%360,(i+s)/2],radius:Math.sqrt(n**2+(s-i)**2)/2}}(this._indoorData.extent),this._floorplanStates[this._indoorData.id]||(this._floorplanStates[this._indoorData.id]={});const i=this._floorplanStates[this._indoorData.id].selectedBuilding,o=this._floorplanStates[this._indoorData.id].selectedLevel;let s;if(this._map.setConfigProperty(this._scope,"mbx-indoor-active-floorplans",this._indoorData.floorplanIDs),this._selectedLevel)for(const e of this._indoorData.levels)e.id===this._selectedLevel.id&&(s=e.id);if(this.fire(new e.A("floorplanselected",{buildings:this._indoorData.buildings,levels:this._indoorData.levels,selectedLevelId:s})),i){const e=this._indoorData.buildings.find((e=>e.id===i));this._buildingSelected(e,!1);}else this._indoorData.buildings.length>0&&this._buildingSelected(this._indoorData.buildings[0],!1);if(o){const e=this._indoorData.levels.find((e=>e.id===o));this._updateLevels(e,t);}else t&&this._indoorData["default-levels"].length>0&&this.selectLevel(this._indoorData["default-levels"][0]);}_buildingSelected(t,i){i&&t&&t.extent&&this._map.fitBounds(t.extent,{pitch:this._map.getPitch(),bearing:this._map.getBearing()}),this._floorplanStates[this._indoorData.id].selectedBuilding=t?t.id:void 0;const o=this._indoorData.levels.filter((e=>t.levels.includes(e.id)));this.fire(new e.A("buildingselected",{buildingId:t.id,levels:o}));}_levelSelected(t){if("overview"===t)this._updateLevels(void 0,!0);else {const e=this._indoorData.levels.find((e=>e.id===t));this._updateLevels(e,!0);}this.fire(new e.A("levelselected",{levelId:"overview"===t?void 0:t}));}_updateLevels(e,t){if(!e)return this._map.setConfigProperty(this._scope,"mbx-indoor-loaded-levels",["literal",[]]),this._map.setConfigProperty(this._scope,"mbx-indoor-underground",!1),this._floorplanStates[this._indoorData.id].selectedLevel=void 0,void(t&&this._indoorData.extent&&this._map.fitBounds(this._indoorData.extent,{pitch:this._map.getPitch(),bearing:this._map.getBearing()}));function i(e){const t=e.indexOf("/floor/");if(-1===t)return e;const i=t+7,o=e.indexOf("/",i);return -1===o?e.slice(i):e.slice(i,o)}this._selectedLevel=e,this._floorplanStates[this._indoorData.id].selectedLevel=e?e.id:void 0;const o=[],s={},r={},n={},a={};for(const t of this._indoorData.levels)if(o.push(t.id),s[t.id]=t.height,r[t.id]=t.base,e){if(this.mergeFloors){const o=i(e.id),s=i(t.id);n[t.id]=s===o?"true":"false";}else n[t.id]=t.id===e.id?"true":"false";a[t.id]=t.base<e.base?"true":"false";}else a[t.id]=!0;if(this._map.setConfigProperty(this._scope,"mbx-indoor-loaded-levels",["literal",o]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-height",["literal",s]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-base",["literal",r]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-selected",["literal",n]),this._map.setConfigProperty(this._scope,"mbx-indoor-level-overlapped",["literal",a]),e&&(this._map.setConfigProperty(this._scope,"mbx-indoor-underground",!!e.isUnderground),t&&e.extent)){const t=this._map.cameraForBounds(e.extent,{pitch:this._map.getPitch(),bearing:this._map.getBearing()}),i=this._map.getZoom(),o=t.zoom?Math.abs(i-t.zoom):0;this._map.fitBounds(e.extent,o>=1?{pitch:this._map.getPitch(),bearing:this._map.getBearing()}:{pitch:this._map.getPitch(),bearing:this._map.getBearing(),zoom:i});}}selectFloorplan(t){const i={target:{featuresetId:this._queryFeatureSetId,importId:this._scope}},o=[new e.P(0,0),new e.P(this._map.transform.width,this._map.transform.height)],s=this._map.queryRenderedFeatures(o,i);if(s.length>0)for(const e of s)if(JSON.parse(e.properties["indoor-data"]).floorplanIDs.includes(t)){this._selectedFloorplan=e,this._floorplanSelected(!0);break}}selectBuilding(e){const t=this._indoorData.buildings.find((t=>t.id===e));this._buildingSelected(t,!0);}selectLevel(e){this._levelSelected(e);}}function po(t){if(!t.metadata||!t.metadata.content_area)return;const i=e.q.devicePixelRatio,{left:o,top:s,width:r,height:n}=t.metadata.content_area,a=o*i,l=s*i;return [a,l,a+r*i,l+n*i]}function fo(t){if(t)return t.map((([t,i])=>[t*e.q.devicePixelRatio,i*e.q.devicePixelRatio]))}class mo{constructor(e,t,i){this.id=e,this.scope=t,this.sourceCache=i,this.pendingRequests=new Set,this.missingRequests=new Set;}addPendingRequest(e){this.missingRequests.has(e.name)||this.pendingRequests.has(e.name)||this.pendingRequests.add(e.name);}hasPendingRequests(){return this.pendingRequests.size>0}resolvePendingRequests(){const t=new Map;if(!this.sourceCache.loaded())return t;const i=this.sourceCache.getVisibleCoordinates();if(0===i.length)return t;const o=this.sourceCache.getSource();if(!(o instanceof ot))return t;const s=i.map((e=>this.sourceCache.getTile(e))),r=o.getImages(s,Array.from(this.pendingRequests));for(const[i,o]of r)t.set(e.I.from({name:i,iconsetId:this.id}),o),this.pendingRequests.delete(i);for(const e of this.pendingRequests)this.missingRequests.add(e);return this.pendingRequests.clear(),t}}const go=(e,t)=>Ae(e,t&&t.filter((e=>"source.canvas"!==e.identifier))),vo=e.aA(Pt,["addLayer","removeLayer","setLights","setPaintProperty","setLayoutProperty","setSlot","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain","setFog","setSnow","setRain","setProjection","setCamera","addImport","removeImport","updateImport","addIconset","removeIconset"]),yo=e.aA(Pt,["setCenter","setZoom","setBearing","setPitch"]),xo=new Set(["background","sky","slot","custom"]),bo={version:8,layers:[],sources:{}},wo={duration:300,delay:0};class To extends e.E{constructor(t,i={}){super(),this.map=t,this.scope=i.scope||"",this.globalId=null,this.fragments=[],this.importDepth=i.importDepth||0,this.importsCache=i.importsCache||new Map,this.resolvedImports=i.resolvedImports||new Set,this.transition=e.l({},wo),this._buildingIndex=new Dt(this),this.crossTileSymbolIndex=new Oi,this._mergedOrder=[],this._drapedFirstOrder=[],this._mergedLayers={},this._mergedSourceCaches={},this._mergedOtherSourceCaches={},this._mergedSymbolSourceCaches={},this._clipLayerPresent=!1,this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this._changes=i.styleChanges||new G,this.dispatcher=i.dispatcher?i.dispatcher:new e.D(e.cj(),this),i.imageManager?this.imageManager=i.imageManager:(this.imageManager=new q(this.map._spriteFormat),this.imageManager.setEventedParent(this)),this.imageManager.addScope(this.scope),this.glyphManager=i.glyphManager?i.glyphManager:new e.ck(t._requestManager,i.localFontFamily?e.cl.all:i.localIdeographFontFamily?e.cl.ideographs:e.cl.none,i.localFontFamily||i.localIdeographFontFamily),i.modelManager?this.modelManager=i.modelManager:(this.modelManager=new lo(t._requestManager),this.modelManager.setEventedParent(this)),this._layers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this._loaded=!1,this._precompileDone=!1,this._shouldPrecompile=!1,this._availableImages=[],this._order=[],this._markersNeedUpdate=!1,this.options=i.configOptions?i.configOptions:new Map,this._configDependentLayers=i.configDependentLayers?i.configDependentLayers:new Set,this._config=i.config,this._styleColorTheme={lut:null,lutLoading:!1,lutLoadingCorrelationID:0,colorTheme:null,colorThemeOverride:i.colorThemeOverride},this._styleColorThemeForScope={},this._initialConfig=i.initialConfig,this.dispatcher.broadcast("setReferrer",e.cm());const o=this;this._rtlTextPluginCallback=To.registerForPluginStateChange((t=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:t.pluginStatus,pluginURL:t.pluginURL},((t,i)=>{if(e.cn(t),i&&i.every((e=>e)))for(const e in o._sourceCaches){const t=o._sourceCaches[e],i=t.getSource().type;"vector"!==i&&"geojson"!==i||t.reload();}}));})),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getOwnSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i);}}));}load(e){return e?("string"==typeof e?this.loadURL(e):this.loadJSON(e),this):this}_getGlobalId(t){if(!t)return null;if("string"==typeof t){if(e.f(t))return t;const i=e.co(t);if(!i.startsWith("http"))try{return new URL(i,location.href).toString()}catch(e){return i}return i}return `json://${e.cp(JSON.stringify(t))}`}_diffStyle(t,i,o){this.globalId=this._getGlobalId(t);const s=(e,t)=>{try{t(null,this.setState(e,o));}catch(e){t(e,!1);}};if("string"==typeof t){const o=this.map._requestManager.normalizeStyleURL(t),r=this.map._requestManager.transformRequest(o,e.R.Style);e.n(r,((t,o)=>{t?this.fire(new e.z(t)):o&&s(o,i);}));}else "object"==typeof t&&s(t,i);}loadURL(t,i={}){this.fire(new e.A("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!e.f(t);this.globalId=this._getGlobalId(t),t=this.map._requestManager.normalizeStyleURL(t,i.accessToken),this.resolvedImports.add(t);const s=this.importsCache.get(t);if(s)return this._load(s,o);const r=this.map._requestManager.transformRequest(t,e.R.Style);this._request=e.n(r,((i,s)=>{if(this._request=null,i)this.fire(new e.z(i));else if(s)return this.importsCache.set(t,s),this._load(s,o)}));}loadJSON(t,i={}){this.fire(new e.A("dataloading",{dataType:"style"})),this.globalId=this._getGlobalId(t),this._request=e.q.frame((()=>{this._request=null,this._load(t,!1!==i.validate);}));}loadEmpty(){this.fire(new e.A("dataloading",{dataType:"style"})),this._load(bo,!1);}_loadImports(t,i,o){if(this.importDepth>=4)return e.w("Style doesn't support nesting deeper than 5"),Promise.resolve();const s=[];for(const e of t){const t=this._createFragmentStyle(e),r=new Promise((e=>{t.once("style.import.load",e),t.once("error",e);})).then((()=>this.mergeAll()));if(s.push(r),this.resolvedImports.has(e.url)){t.loadEmpty();continue}const n=e.data||this.importsCache.get(e.url);n?(t.loadJSON(n,{validate:i}),this._isInternalStyle(n)&&(t.globalId=null)):e.url?t.loadURL(e.url,{validate:i}):t.loadEmpty();const a={style:t,id:e.id,config:e.config};if(o){const e=this.fragments.findIndex((({id:e})=>e===o));this.fragments=this.fragments.slice(0,e).concat(a).concat(this.fragments.slice(e));}else this.fragments.push(a);}return Promise.allSettled(s)}getImportGlobalIds(e=this,t=new Set){for(const i of e.fragments)i.style.globalId&&t.add(i.style.globalId),this.getImportGlobalIds(i.style,t);return [...t.values()]}_createFragmentStyle(t){const i=this.scope?e.C(t.id,this.scope):t.id;let o;const s=this._initialConfig&&this._initialConfig[i];(t.config||s)&&(o=e.l({},t.config,s));const r=new To(this.map,{scope:i,styleChanges:this._changes,importDepth:this.importDepth+1,importsCache:this.importsCache,resolvedImports:new Set(this.resolvedImports),dispatcher:this.dispatcher,imageManager:this.imageManager,glyphManager:this.glyphManager,modelManager:this.modelManager,config:o,configOptions:this.options,colorThemeOverride:t["color-theme"],configDependentLayers:this._configDependentLayers});return r.setEventedParent(this.map,{style:r}),r}_reloadImports(){this.mergeAll(),this._updateMapProjection(),this.updateConfigDependencies(),this.map._triggerCameraUpdate(this.camera),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options}),this._shouldPrecompile=this.map._precompilePrograms&&this.isRootStyle();}_isInternalStyle(e){return this.isRootStyle()&&(e.fragment||!!e.schema&&!1!==e.fragment)}_load(t,i){const o=t.indoor?uo(t.schema):t.schema;if(this._isInternalStyle(t)){const o=e.l({},bo,{imports:[{id:"basemap",data:t,url:""}]});return void this._load(o,i)}if(this.updateConfig(this._config,o),i&&go(this,me(t)))return;this._loaded=!0,this.stylesheet=e.cq(t);const s=()=>{for(const e in t.sources)this.addSource(e,t.sources[e],{validate:!1,isInitialLoad:!0});if(t.iconsets)for(const e in t.iconsets)this.addIconset(e,t.iconsets[e]);t.sprite?this._loadIconset(t.sprite):(this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0})),this.setGlyphsUrl(t.glyphs);const o=Lt(this.stylesheet.layers);if(this._order=o.map((e=>e.id)),this.stylesheet.light&&e.w("The `light` root property is deprecated, prefer using `lights` with `flat` light type instead."),this.stylesheet.lights)if(1===this.stylesheet.lights.length&&"flat"===this.stylesheet.lights[0].type){const e=this.stylesheet.lights[0];this.light=new Pe(e.properties,e.id);}else this.setLights(this.stylesheet.lights);this.light||(this.light=new Pe(this.stylesheet.light)),this._layers={};for(const t of o){const i=e.cv(t,this.scope,this._styleColorTheme.lut,this.options);0!==i.configDependencies.size&&this._configDependentLayers.add(i.fqid),i.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=i;const o=this.getOwnLayerSourceCache(i),s=!!this.directionalLight&&this.directionalLight.shadowsEnabled();o&&i.canCastShadows()&&s&&(o.castsShadows=!0);}this.stylesheet.featuresets&&this.setFeaturesetSelectors(this.stylesheet.featuresets),this.stylesheet.models&&this.modelManager.addModels(this.stylesheet.models,this.scope);const s=this.stylesheet.terrain;s&&(this.checkCanvasFingerprintNoise(),this.disableElevatedTerrain||this.terrainSetForDrapingOnly()||this._createTerrain(s,1)),this.stylesheet.fog&&this._createFog(this.stylesheet.fog),this.stylesheet.snow&&this._createSnow(this.stylesheet.snow),this.stylesheet.rain&&this._createRain(this.stylesheet.rain),this.stylesheet.transition&&this.setTransition(this.stylesheet.transition),this.fire(new e.A("data",{dataType:"style"}));const r=this.isRootStyle();t.imports?this._loadImports(t.imports,i).then((()=>{this._reloadImports(),this.fire(new e.A(r?"style.load":"style.import.load"));})):(this._reloadImports(),this.fire(new e.A(r?"style.load":"style.import.load")));};this._styleColorTheme.colorTheme=this.stylesheet["color-theme"];const r=this._styleColorTheme.colorThemeOverride?this._styleColorTheme.colorThemeOverride:this._styleColorTheme.colorTheme;if(r){const t=this._evaluateColorThemeData(r);this._loadColorTheme(t).then((()=>{s();})).catch((t=>{e.w(`Couldn't load color theme from the stylesheet: ${t}`),s();}));}else this._styleColorTheme.lut=null,s();}isRootStyle(){return 0===this.importDepth}mergeAll(){let t,i,o,s,r,n,a,l,c,h;const d={};this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((e=>{if(e.stylesheet){if(null!=e.light&&(t=e.light),e.stylesheet.lights)for(const t of e.stylesheet.lights)"ambient"===t.type&&null!=e.ambientLight&&(i=e.ambientLight),"directional"===t.type&&null!=e.directionalLight&&(o=e.directionalLight);s=this._prioritizeTerrain(s,e.terrain,e.stylesheet.terrain),e.stylesheet.fog&&null!=e.fog&&(r=e.fog),e.stylesheet.snow&&null!=e.snow&&(n=e.snow),e.stylesheet.rain&&null!=e.rain&&(a=e.rain),null!=e.stylesheet.camera&&(h=e.stylesheet.camera),null!=e.stylesheet.projection&&(l=e.stylesheet.projection),null!=e.stylesheet.transition&&(c=e.stylesheet.transition),d[e.scope]=e._styleColorTheme;}})),this.light=t,this.ambientLight=i,this.directionalLight=o,this.fog=r,this.snow=n,this.rain=a,this._styleColorThemeForScope=d,null===s?delete this.terrain:this.terrain=s,this.camera=h||{"camera-projection":"perspective"},this.projection=l||{name:"mercator"},this.transition=e.l({},wo,c),this.mergeSources(),this.mergeLayers();}forEachFragmentStyle(e){const t=i=>{for(const e of i.fragments)t(e.style);e(i);};t(this);}_prioritizeTerrain(e,t,i){const o=e&&0===e.drapeRenderMode;return null===i?t&&0===t.drapeRenderMode?t:o?e:null:null!=t&&(!e||o||t&&1===t.drapeRenderMode)?t:e}mergeTerrain(){let e;this.terrain&&this.terrain.scope!==this.scope&&delete this.terrain,this.forEachFragmentStyle((t=>{e=this._prioritizeTerrain(e,t.terrain,t.stylesheet.terrain);})),null===e?delete this.terrain:this.terrain=e;}mergeProjection(){let e;this.forEachFragmentStyle((t=>{null!=t.stylesheet.projection&&(e=t.stylesheet.projection);})),this.projection=e||{name:"mercator"};}mergeSources(){const t={},i={},o={};this.forEachFragmentStyle((s=>{for(const i in s._sourceCaches){const o=e.C(i,s.scope);t[o]=s._sourceCaches[i];}for(const t in s._otherSourceCaches){const o=e.C(t,s.scope);i[o]=s._otherSourceCaches[t];}for(const t in s._symbolSourceCaches){const i=e.C(t,s.scope);o[i]=s._symbolSourceCaches[t];}})),this._mergedSourceCaches=t,this._mergedOtherSourceCaches=i,this._mergedSymbolSourceCaches=o;}mergeLayers(){const t={},i=[],o={};this._mergedSlots=[],this._has3DLayers=!1,this._hasCircleLayers=!1,this._hasSymbolLayers=!1,this.forEachFragmentStyle((o=>{for(const s of o._order){const r=o._layers[s];if("slot"===r.type){const i=e.cr(s);if(t[i])continue;t[i]=[];}r.slot&&t[r.slot]?t[r.slot].push(r):i.push(r);}})),this._mergedOrder=[];const s=(i=[])=>{for(const r of i)if("slot"===r.type){const i=e.cr(r.id);t[i]&&s(t[i]),this._mergedSlots.push(i);}else {const t=e.C(r.id,r.scope);this._mergedOrder.push(t),o[t]=r,r.is3D(!!this.terrain)&&(this._has3DLayers=!0),"circle"===r.type&&(this._hasCircleLayers=!0),"symbol"===r.type&&(this._hasSymbolLayers=!0),"clip"===r.type&&(this._clipLayerPresent=!0);}};s(i),this._mergedOrder.sort(((e,t)=>{const i=o[e],s=o[t];return i.hasInitialOcclusionOpacityProperties?s.is3D(!!this.terrain)?1:0:i.is3D(!!this.terrain)&&s.hasInitialOcclusionOpacityProperties?-1:0})),this._mergedLayers=o,this.updateDrapeFirstLayers(),this._buildingIndex.processLayersChanged();}terrainSetForDrapingOnly(){return !!this.terrain&&0===this.terrain.drapeRenderMode}getCamera(){return this.stylesheet.camera}setCamera(t){return this.stylesheet.camera=e.l({},this.stylesheet.camera,t),this.camera=this.stylesheet.camera,this}_evaluateColorThemeData(t){return t.data?function(t,i,o){const s=e.l({},i);for(const t of Object.keys(e.a5.colorTheme))void 0===s[t]&&(s[t]=e.a5.colorTheme[t].default);const r=new e.a6(co,t,new Map(o));return r.setTransitionOrValue(s,o),r.untransitioned().possiblyEvaluate(new e.aa(0))}(this.scope,t,this.options).get("data"):null}_loadColorTheme(t){this._styleColorTheme.lutLoading=!0,this._styleColorTheme.lutLoadingCorrelationID+=1;const i=this._styleColorTheme.lutLoadingCorrelationID;return new Promise(((o,s)=>{const r="data:image/png;base64,";if(!t||0===t.length)return this._styleColorTheme.lut=null,this._styleColorTheme.lutLoading=!1,void o();let n=t;n.startsWith(r)||(n=r+n);const a=e.I.from("mapbox-reserved-lut"),l=new Image;l.src=n,l.onerror=()=>{this._styleColorTheme.lutLoading=!1,s(new Error("Failed to load image data"));},l.onload=()=>{if(this._styleColorTheme.lutLoadingCorrelationID!==i)return void o();this._styleColorTheme.lutLoading=!1;const{width:r,height:n,data:c}=e.q.getImageData(l);if(n>32)return void s(new Error("The height of the image must be less than or equal to 32 pixels."));if(r!==n*n)return void s(new Error("The width of the image must be equal to the height squared."));this.getImage(a,this.scope)&&this.removeImage(a,this.scope),this.addImage(a,this.scope,{data:new e.r({width:r,height:n},c),pixelRatio:1,sdf:!1,usvg:!1,version:0});const h=this.imageManager.getImage(a,this.scope);h?(this._styleColorTheme.lut={image:h.data,data:t},o()):s(new Error("Missing LUT image."));};}))}getLut(e){const t=this._styleColorThemeForScope[e];return t?t.lut:null}setProjection(e){e?this.stylesheet.projection=e:delete this.stylesheet.projection,this.mergeProjection(),this._updateMapProjection();}applyProjectionUpdate(){this._loaded&&(this.dispatcher.broadcast("setProjection",this.map.transform.projectionOptions),this.map.transform.projection.requiresDraping?(this.getTerrain()||this.stylesheet.terrain)&&!this.disableElevatedTerrain||this.setTerrainForDraping():this.terrainSetForDrapingOnly()&&this.setTerrain(null,0));}_updateMapProjection(){this.isRootStyle()&&(this.map._useExplicitProjection?this.applyProjectionUpdate():this.map._prioritizeAndUpdateProjection(null,this.projection));}_loadSprite(t){this._spriteRequest=function(t,i,o){let s,r,n;const a=e.q.devicePixelRatio>1?"@2x":"";let l=e.n(i.transformRequest(i.normalizeSpriteURL(t,a,".json"),e.R.SpriteJSON),((e,t)=>{l=null,n||(n=e,s=t,h());})),c=e.o(i.transformRequest(i.normalizeSpriteURL(t,a,".png"),e.R.SpriteImage),((e,t)=>{c=null,n||(n=e,r=t,h());}));function h(){if(n)o(n);else if(s&&r){const t=e.q.getImageData(r),i={};for(const o in s){const{width:r,height:n,x:a,y:l,sdf:c,pixelRatio:h,stretchX:d,stretchY:u,content:_}=s[o],p=new e.r({width:r,height:n});e.r.copy(t,p,{x:a,y:l},{x:0,y:0},{width:r,height:n},null),i[o]={data:p,pixelRatio:h,sdf:c,stretchX:d,stretchY:u,content:_,usvg:!1};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(t,this.map._requestManager,((t,i)=>{if(this._spriteRequest=null,t)this.fire(new e.z(t));else if(i){const t=new Map;for(const o in i)t.set(e.I.from(o),i[o]);this.addImages(t,this.scope);}this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0}),this.fire(new e.A("data",{dataType:"style"}));}));}addIconset(t,i){if("sprite"===i.type)return void this._loadSprite(i.url);const o=this.getOwnSourceCache(i.source);if(!o)return void this.fire(new e.z(new Error(`Source "${i.source}" as specified by iconset "${t}" does not exist and cannot be used as an iconset source`)));const s=o.getSource();if("raster-array"!==s.type)return void this.fire(new e.z(new Error(`Source "${i.source}" as specified by iconset "${t}" is not a "raster-array" source and cannot be used as an iconset source`)));s.partial=!1;const r=new mo(t,this.scope,o);this.imageManager.addImageProvider(r,this.scope);}removeIconset(e){this.imageManager.removeImageProvider(e,this.scope);}_loadIconset(t){if(!e.f(t)&&"icon_set"!==this.map._spriteFormat||"raster"===this.map._spriteFormat)return void this._loadSprite(t);const i="auto"===this.map._spriteFormat;var o,s;this._spriteRequest=(s=(o,s)=>{if(this._spriteRequest=null,o)i?this._loadSprite(t):this.fire(new e.z(o));else if(s){const t=new Map;for(const i in s)t.set(e.I.from(i),s[i]);this.addImages(t,this.scope);}this.imageManager.setLoaded(!0,this.scope),this.dispatcher.broadcast("spriteLoaded",{scope:this.scope,isLoaded:!0}),this.fire(new e.A("data",{dataType:"style"}));},e.bj((o=this.map._requestManager).transformRequest(o.normalizeIconsetURL(t),e.R.Iconset),((t,i)=>{if(t)return void s(t);const o={},r=e.ch(new e.bi(i));for(const t of r.icons){const i={version:1,pixelRatio:e.q.devicePixelRatio,content:po(t),stretchX:t.metadata?fo(t.metadata.stretch_x_areas):void 0,stretchY:t.metadata?fo(t.metadata.stretch_y_areas):void 0,sdf:!1,usvg:!0,icon:t};o[t.name]=i;}s(null,o);})));}_validateLayer(t){const i=this.getOwnSource(t.source);if(!i)return;const o=t.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new e.z(new Error(`Source layer "${o}" does not exist on source "${i.id}" as specified by style layer "${t.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._changes.getUpdatedSourceCaches()).length)return !1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return !1;if(!this.imageManager.isLoaded())return !1;if(this.imageManager.hasPatternsInFlight())return !1;if(!this.modelManager.isLoaded())return !1;if(this._styleColorTheme.lutLoading)return !1;for(const{style:e}of this.fragments)if(!e.loaded())return !1;return !0}_serializeImports(){if(this.stylesheet.imports)return this.stylesheet.imports.map(((e,t)=>{const i=this.fragments[t];return i&&i.style&&(e.data=i.style.serialize()),e}))}_serializeSources(){const e={};for(const t in this._sourceCaches){const i=this._sourceCaches[t].getSource();e[i.id]||(e[i.id]=i.serialize());}return e}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];e&&"custom"!==e.type&&t.push(e.serialize());}return t}hasLightTransitions(){return !(!this.light||!this.light.hasTransition())||!(!this.ambientLight||!this.ambientLight.hasTransition())||!(!this.directionalLight||!this.directionalLight.hasTransition())}hasFogTransition(){return !!this.fog&&this.fog.hasTransition()}hasSnowTransition(){return !!this.snow&&this.snow.hasTransition()}hasRainTransition(){return !!this.rain&&this.rain.hasTransition()}hasTransitions(){if(this.hasLightTransitions())return !0;if(this.hasFogTransition())return !0;if(this.hasSnowTransition())return !0;if(this.hasRainTransition())return !0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}get order(){return this.terrain?this._drapedFirstOrder:this._mergedOrder}_getOrder(e){return e?this.order:this._mergedOrder}isLayerDraped(e){return !!this.terrain&&e.isDraped(this.getLayerSourceCache(e))}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}_checkLayer(t){const i=this.getOwnLayer(t);if(i)return i;this.fire(new e.z(new Error(`The layer '${t}' does not exist in the map's style.`)));}_checkSource(t){const i=this.getOwnSource(t);if(i)return i;this.fire(new e.z(new Error(`The source '${t}' does not exist in the map's style.`)));}precompilePrograms(e,t){const i=this.map.painter;if(i)for(let o=e.minzoom||0;o<(e.maxzoom||25.5);o++){const o=e.getProgramIds();if(o)for(const s of o){const o=e.getDefaultProgramParams(s,t.zoom,this._styleColorTheme.lut);o&&(i.style=this,this.fog&&(i._fogVisible=!0,o.overrideFog=!0,i.getOrCreateProgram(s,o)),i._fogVisible=!1,o.overrideFog=!1,i.getOrCreateProgram(s,o),(this.stylesheet.terrain||this.stylesheet.projection&&"globe"===this.stylesheet.projection.name)&&(o.overrideRtt=!0,i.getOrCreateProgram(s,o)));}}}update(t){if(!this._loaded)return;this.ambientLight&&this.ambientLight.recalculate(t),this.directionalLight&&this.directionalLight.recalculate(t);const i=this.calculateLightsBrightness();t.brightness=i||0,i!==this._brightness&&(this._brightness=i,this.dispatcher.broadcast("setBrightness",i));const o=this._changes.isDirty();let s=!1;if(this._changes.isDirty()){const e=this._changes.getLayerUpdatesByScope();for(const t in e){const{updatedIds:i,removedIds:o}=e[t];(i||o)&&(this._updateWorkerLayers(t,i,o),s=!0);}this.updateSourceCaches(),this._updateTilesForChangedImages(),this.updateLayers(t),this.light&&this.light.updateTransitions(t),this.ambientLight&&this.ambientLight.updateTransitions(t),this.directionalLight&&this.directionalLight.updateTransitions(t),this.fog&&this.fog.updateTransitions(t),this.snow&&this.snow.updateTransitions(t),this.rain&&this.rain.updateTransitions(t),this._changes.reset();}const r={};for(const e in this._mergedSourceCaches){const t=this._mergedSourceCaches[e];r[e]=t.used,t.used=!1,t.tileCoverLift=0;}for(const e of this._mergedOrder){const i=this._mergedLayers[e];if(i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)){const e=this.getLayerSourceCache(i);e&&(e.used=!0,e.tileCoverLift=Math.max(e.tileCoverLift,i.tileCoverLift()));}!this._precompileDone&&this._shouldPrecompile&&("requestIdleCallback"in window?requestIdleCallback((()=>{this.precompilePrograms(i,t);})):this.precompilePrograms(i,t));}this._shouldPrecompile&&(this._precompileDone=!0),this.terrain&&s&&this.mergeLayers();const n=this.imageManager.getPendingImageProviders();for(const e of n)e.sourceCache.used=!0;for(const t in r){const i=this._mergedSourceCaches[t];r[t]!==i.used&&i.getSource().fire(new e.A("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light&&this.light.recalculate(t),this.terrain&&this.terrain.recalculate(t),this.fog&&this.fog.recalculate(t),this.snow&&this.snow.recalculate(t),this.rain&&this.rain.recalculate(t),this.z=t.zoom,this._markersNeedUpdate&&(this._updateMarkersOpacity(),this._markersNeedUpdate=!1),this.imageManager.clearUpdatedImages(this.scope),o&&this.fire(new e.A("data",{dataType:"style"}));}updateImageProviders(){const e=this.imageManager.getPendingImageProviders();for(const t of e){const e=t.resolvePendingRequests();this.addImages(e,t.scope);}}_updateTilesForChangedImages(){const e={};for(const t in this._mergedSourceCaches){const i=this._mergedSourceCaches[t].getSource().scope;e[i]=e[i]||this._changes.getUpdatedImages(i),0!==e[i].length&&this._mergedSourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e[i]);}for(const t in e)this._changes.resetUpdatedImages(t);}_updateWorkerLayers(e,t,i){const o=this.getFragmentStyle(e);o&&this.dispatcher.broadcast("updateLayers",{layers:t?o._serializeLayers(t):[],scope:e,removedIds:i||[],options:o.options});}setState(t,i){if(this._checkLoaded(),go(this,me(t)))return !1;(t=e.cq(t)).layers=Lt(t.layers);const o=function(t,i){if(!t)return [{command:Pt.setStyle,args:[i]}];let o=[];try{if(!e.bn(t.version,i.version))return [{command:Pt.setStyle,args:[i]}];if(e.bn(t.center,i.center)||o.push({command:Pt.setCenter,args:[i.center]}),e.bn(t.zoom,i.zoom)||o.push({command:Pt.setZoom,args:[i.zoom]}),e.bn(t.bearing,i.bearing)||o.push({command:Pt.setBearing,args:[i.bearing]}),e.bn(t.pitch,i.pitch)||o.push({command:Pt.setPitch,args:[i.pitch]}),e.bn(t.sprite,i.sprite)||o.push({command:Pt.setSprite,args:[i.sprite]}),e.bn(t.glyphs,i.glyphs)||o.push({command:Pt.setGlyphs,args:[i.glyphs]}),e.bn(t.imports,i.imports)||function(t=[],i=[],o){i=i||[];const s=(t=t||[]).map(Bt),r=i.map(Bt),n=t.reduce(Nt,{}),a=i.reduce(Nt,{}),l=s.slice();let c,h,d,u;for(c=0,h=0;c<s.length;c++)d=s[c],a.hasOwnProperty(d)?h++:(o.push({command:Pt.removeImport,args:[d]}),l.splice(l.indexOf(d,h),1));for(c=0,h=0;c<r.length;c++)d=r[r.length-1-c],l[l.length-1-c]!==d&&(n.hasOwnProperty(d)?(o.push({command:Pt.removeImport,args:[d]}),l.splice(l.lastIndexOf(d,l.length-h),1)):h++,u=l[l.length-c],o.push({command:Pt.addImport,args:[a[d],u]}),l.splice(l.length-c,0,d));for(const t of i){const i=n[t.id];i&&!e.bn(i,t)&&o.push({command:Pt.updateImport,args:[t.id,t]});}}(t.imports,i.imports,o),e.bn(t.transition,i.transition)||o.push({command:Pt.setTransition,args:[i.transition]}),e.bn(t.light,i.light)||o.push({command:Pt.setLight,args:[i.light]}),e.bn(t.fog,i.fog)||o.push({command:Pt.setFog,args:[i.fog]}),e.bn(t.snow,i.snow)||o.push({command:Pt.setSnow,args:[i.snow]}),e.bn(t.rain,i.rain)||o.push({command:Pt.setRain,args:[i.rain]}),e.bn(t.projection,i.projection)||o.push({command:Pt.setProjection,args:[i.projection]}),e.bn(t.lights,i.lights)||o.push({command:Pt.setLights,args:[i.lights]}),e.bn(t.camera,i.camera)||o.push({command:Pt.setCamera,args:[i.camera]}),e.bn(t.iconsets,i.iconsets)||function(t,i,o){let s;for(s in i=i||{},t=t||{})t.hasOwnProperty(s)&&(i.hasOwnProperty(s)||o.push({command:Pt.removeIconset,args:[s]}));for(s in i){if(!i.hasOwnProperty(s))continue;const r=i[s];t.hasOwnProperty(s)?e.bn(t[s],r)||(o.push({command:Pt.removeIconset,args:[s]}),o.push({command:Pt.addIconset,args:[s,r]})):o.push({command:Pt.addIconset,args:[s,r]});}}(t.iconsets,i.iconsets,o),!e.bn(t["color-theme"],i["color-theme"]))return [{command:Pt.setStyle,args:[i]}];const s={},r=[];!function(t,i,o,s){let r;for(r in i=i||{},t=t||{})t.hasOwnProperty(r)&&(i.hasOwnProperty(r)||zt(r,o,s));for(r in i){if(!i.hasOwnProperty(r))continue;const n=i[r];t.hasOwnProperty(r)?e.bn(t[r],n)||("geojson"===t[r].type&&"geojson"===n.type&&Ft(t,i,r)?o.push({command:Pt.setGeoJSONSourceData,args:[r,n.data]}):Ot(r,i,o,s)):Mt(r,i,o);}}(t.sources,i.sources,r,s);const n=[];t.layers&&t.layers.forEach((e=>{e.source&&s[e.source]?o.push({command:Pt.removeLayer,args:[e.id]}):n.push(e);}));let a=t.terrain;a&&s[a.source]&&(o.push({command:Pt.setTerrain,args:[void 0]}),a=void 0),o=o.concat(r),e.bn(a,i.terrain)||o.push({command:Pt.setTerrain,args:[i.terrain]}),function(t,i,o){i=i||[];const s=(t=t||[]).map(Bt),r=i.map(Bt),n=t.reduce(Nt,{}),a=i.reduce(Nt,{}),l=s.slice(),c=Object.create(null);let h,d,u,_,p,f,m;for(h=0,d=0;h<s.length;h++)u=s[h],a.hasOwnProperty(u)?d++:(o.push({command:Pt.removeLayer,args:[u]}),l.splice(l.indexOf(u,d),1));for(h=0,d=0;h<r.length;h++)u=r[r.length-1-h],l[l.length-1-h]!==u&&(n.hasOwnProperty(u)?(o.push({command:Pt.removeLayer,args:[u]}),l.splice(l.lastIndexOf(u,l.length-d),1)):d++,f=l[l.length-h],o.push({command:Pt.addLayer,args:[a[u],f]}),l.splice(l.length-h,0,u),c[u]=!0);for(h=0;h<r.length;h++)if(u=r[h],_=n[u],p=a[u],!c[u]&&!e.bn(_,p))if(e.bn(_.source,p.source)&&e.bn(_["source-layer"],p["source-layer"])&&e.bn(_.type,p.type)){for(m in kt(_.layout,p.layout,o,u,null,Pt.setLayoutProperty),kt(_.paint,p.paint,o,u,null,Pt.setPaintProperty),e.bn(_.slot,p.slot)||o.push({command:Pt.setSlot,args:[u,p.slot]}),e.bn(_.filter,p.filter)||o.push({command:Pt.setFilter,args:[u,p.filter]}),e.bn(_.minzoom,p.minzoom)&&e.bn(_.maxzoom,p.maxzoom)||o.push({command:Pt.setLayerZoomRange,args:[u,p.minzoom,p.maxzoom]}),_)_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?kt(_[m],p[m],o,u,m.slice(6),Pt.setPaintProperty):e.bn(_[m],p[m])||o.push({command:Pt.setLayerProperty,args:[u,m,p[m]]}));for(m in p)p.hasOwnProperty(m)&&!_.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&"slot"!==m&&(0===m.indexOf("paint.")?kt(_[m],p[m],o,u,m.slice(6),Pt.setPaintProperty):e.bn(_[m],p[m])||o.push({command:Pt.setLayerProperty,args:[u,m,p[m]]}));}else o.push({command:Pt.removeLayer,args:[u]}),f=l[l.lastIndexOf(u)+1],o.push({command:Pt.addLayer,args:[p,f]});}(n,i.layers,o);}catch(e){console.warn("Unable to compute style diff:",e),o=[{command:Pt.setStyle,args:[i]}];}return o}(this.serialize(),t).filter((e=>!(e.command in yo)));if(0===o.length)return !1;const s=o.filter((e=>!(e.command in vo)));if(s.length>0)throw new Error(`Unimplemented: ${s.map((e=>e.command)).join(", ")}.`);const r=[];return o.forEach((e=>{r.push(this[e.command].apply(this,e.args));})),i&&Promise.all(r).then(i),this.stylesheet=t,this.mergeAll(),this.dispatcher.broadcast("setLayers",{layers:this._serializeLayers(this._order),scope:this.scope,options:this.options}),!0}_updateWorkerImages(e){const t=this.getFragmentStyle(e);t&&(t._availableImages=t.imageManager.listImages(e),t.dispatcher.broadcast("setImages",{scope:e,images:t._availableImages}));}addImages(t,i){for(const[o,s]of t.entries()){if(this.getImage(o,i))return this.fire(new e.z(new Error(`An image with the name "${o.name}" already exists.`)));this.imageManager.addImage(o,i,s),this._changes.updateImage(o,i);}return this._updateWorkerImages(i),this.fire(new e.A("data",{dataType:"style"})),this}addImage(t,i,o){return this.getImage(t,i)?this.fire(new e.z(new Error(`An image with the name "${t.name}" already exists.`))):(this.imageManager.addImage(t,i,o),this._changes.updateImage(t,i),this._updateWorkerImages(i),this.fire(new e.A("data",{dataType:"style"})),this)}updateImage(t,i,o,s=!1){this.imageManager.updateImage(t,i,o),s&&(this._changes.updateImage(t,i),this._updateWorkerImages(i),this.fire(new e.A("data",{dataType:"style"})));}getImage(e,t){return this.imageManager.getImage(e,t)}removeImage(t,i){return this.getImage(t,i)?(this.imageManager.removeImage(t,i),this._changes.updateImage(t,i),this._updateWorkerImages(i),this.fire(new e.A("data",{dataType:"style"})),this):this.fire(new e.z(new Error("No image with this name exists.")))}listImages(){return this._checkLoaded(),this._availableImages.slice()}addModel(e,t,i={}){return this._checkLoaded(),this._validate(Re,`models.${e}`,t,null,i)||(this.modelManager.addModel(e,t,this.scope),this._changes.setDirty()),this}hasModel(e){return this.modelManager.hasModel(e,this.scope)}removeModel(t){return this.hasModel(t)?(this.modelManager.removeModel(t,this.scope),this):this.fire(new e.z(new Error("No model with this ID exists.")))}listModels(){return this._checkLoaded(),this.modelManager.listModels(this.scope)}addSource(t,i,o={}){if(this._checkLoaded(),void 0!==this.getOwnSource(t))throw new Error(`There is already a source with ID "${t}".`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(ge,`sources.${t}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const s=rt(t,i,this.dispatcher,this);s.scope=this.scope,s.setEventedParent(this,(()=>({isSourceLoaded:this._isSourceCacheLoaded(s.id),source:s.serialize(),sourceId:s.id})));const r=t=>{const i=(t?"symbol:":"other:")+s.id,o=e.C(i,this.scope),r=this._sourceCaches[i]=new St(o,s,t);(t?this._symbolSourceCaches:this._otherSourceCaches)[s.id]=r,r.onAdd(this.map);};r(!1),"vector"!==i.type&&"geojson"!==i.type||r(!0),s.onAdd&&s.onAdd(this.map),o.isInitialLoad||(this.mergeSources(),this._changes.setDirty());}removeSource(t){this._checkLoaded();const i=this.getOwnSource(t);if(!i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.z(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.scope===this.scope&&this.terrain.get().source===t)return this.fire(new e.z(new Error(`Source "${t}" cannot be removed while terrain is using it.`)));if(this.stylesheet.iconsets){const i=Object.entries(this.stylesheet.iconsets).find((([e,i])=>"source"===i.type&&i.source===t));if(i)return this.fire(new e.z(new Error(`Source "${t}" cannot be removed while iconset "${i[0]}" is using it.`)))}const o=this.getOwnSourceCaches(t);for(const t of o){const i=e.cr(t.id);delete this._sourceCaches[i],this._changes.discardSourceCacheUpdate(t.id),t.fire(new e.A("data",{sourceDataType:"metadata",dataType:"source",sourceId:t.getSource().id})),t.setEventedParent(null),t.clearTiles();}return delete this._otherSourceCaches[t],delete this._symbolSourceCaches[t],this.mergeSources(),i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changes.setDirty(),this}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getOwnSource(e).setData(t),this._changes.setDirty();}getOwnSource(e){const t=this.getOwnSourceCache(e);return t&&t.getSource()}getOwnSources(){const e=[];for(const t in this._otherSourceCaches){const i=this.getOwnSourceCache(t);i&&e.push(i.getSource());}return e}areTilesLoaded(){const e=this._mergedSourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}setLights(t){if(this._checkLoaded(),!t)return delete this.ambientLight,void delete this.directionalLight;const i=this._getTransitionParameters();for(const o of t){if(this._validate(ye,"lights",o))return;switch(o.type){case"ambient":if(this.ambientLight){const e=this.ambientLight;e.set(o),e.updateTransitions(i);}else this.ambientLight=new $e(o,qe||(qe=new e.a7({color:new e.a8(e.a5.properties_light_ambient.color),"color-use-theme":new e.a8({type:"string",default:"default","property-type":"data-constant"}),intensity:new e.a8(e.a5.properties_light_ambient.intensity)})),this.scope,this.options);break;case"directional":if(this.directionalLight){const e=this.directionalLight;e.set(o),e.updateTransitions(i);}else this.directionalLight=new $e(o,He||(He=new e.a7({direction:new e.am(e.a5.properties_light_directional.direction),color:new e.a8(e.a5.properties_light_directional.color),"color-use-theme":new e.a8({type:"string",default:"default","property-type":"data-constant"}),intensity:new e.a8(e.a5.properties_light_directional.intensity),"cast-shadows":new e.a8(e.a5.properties_light_directional["cast-shadows"]),"shadow-quality":new e.a8(e.a5.properties_light_directional["shadow-quality"]),"shadow-intensity":new e.a8(e.a5.properties_light_directional["shadow-intensity"])})),this.scope,this.options);}}const o=new e.aa(this.z||0,i);this.ambientLight&&this.ambientLight.recalculate(o),this.directionalLight&&this.directionalLight.recalculate(o),this._brightness=this.calculateLightsBrightness(),this.dispatcher.broadcast("setBrightness",t