<?php
/**
 * Prohibit direct script loading.
 *
 * @package Convert_Plus.
 */

// Add new input type "datetimepicker".
if ( function_exists( 'smile_add_input_type' ) ) {
	smile_add_input_type( 'datetimepicker', 'datetime_picker_settings_field' );
}

/**
 * Function Name:datetime_picker_settings_field Function to handle new input type "datetimepicker".
 *
 * @param  string $name     settings provided when using the input type "datetimepicker".
 * @param  string $settings holds the default / updated value.
 * @param  string $value    html output generated by the function.
 * @return string           html output generated by the function.
 */
function datetime_picker_settings_field( $name, $settings, $value ) {
	$input_name        = $name;
	$type              = isset( $settings['type'] ) ? $settings['type'] : '';
	$class             = isset( $settings['class'] ) ? $settings['class'] : '';
	$timezone_settings = get_option( 'convert_plug_settings' );
	$timezone_name     = $timezone_settings['cp-timezone'];
	$date              = current_time( 'm/d/Y h:i A' );
	if ( 'WordPress' === $timezone_name ) {
		$timezone = 'WordPress';
	} elseif ( 'system' === $timezone_name ) {
		$timezone = 'system';
	} else {
		$timezone = 'WordPress';
	}
	echo ' <input type="hidden" id="cp_currenttime" class="form-control cp_currenttime" value="' . esc_attr( $date ) . '" />';
	echo ' <input type="hidden" id="cp_timezone_name" class="form-control cp_timezone" value="' . esc_attr( $timezone ) . '" />';

	$output = '<div class="form-group cp-datetime-picker">
	<div class="input-group date" id="datetimepicker1">
	<input type="text" id="smile_' . $input_name . '" data-default-date="' . $value . '"  name="' . $input_name . '"  class="form-control smile-input smile-' . $type . ' ' . $input_name . ' ' . $type . ' ' . $class . '"  value="' . $value . '" />
	<span class="input-group-addon"><span class="connects-icon-clock"></span></span> </div>
	</div>';

	$output .= cpget_date( $input_name );

	return $output;
}

if ( ! function_exists( 'cpget_date' ) ) {
	/**
	 * Function Name: cpget_date.
	 *
	 * @param  string $input_name string parameter.
	 * @return mixed            mixed content.
	 */
	function cpget_date( $input_name ) {
		ob_start();
		?>
		<script type="text/javascript">
			jQuery(document).ready(function(){

				var checkbox = jQuery(".smile_<?php echo esc_attr( $input_name ); ?>");
				var input = jQuery("#smile_<?php echo esc_attr( $input_name ); ?>");
				var val = '';		
				var timestring = '';
				timestring = jQuery(".cp_timezone").val();

				var currenttime = '';
				if( timestring == 'system' ){      
					currenttime = new Date();
				}else {        
					currenttime = jQuery(".cp_currenttime").val();
				}

				jQuery('#datetimepicker1').datetimepicker({                  
					minDate: currenttime,
					icons: {
						time: 'connects-icon-clock',
						date: 'dashicons dashicons-calendar-alt',
						up: 'dashicons dashicons-arrow-up-alt2',
						down: 'dashicons dashicons-arrow-down-alt2',
						previous: 'dashicons dashicons-arrow-left-alt2',
						next: 'dashicons dashicons-arrow-right-alt2',
						today: 'dashicons dashicons-screenoptions',
						clear: 'dashicons dashicons-trash',
					}
					//viewDate:true
					});
				jQuery("#datetimepicker1").on("dp.change", function (e) {   

					var date = e.date;
					var date_Obj  = new Date(date);

			//get date.
			var newDate = (date_Obj.getMonth()+1)  + "/" + date_Obj.getDate()  + "/" + date_Obj .getFullYear() + " " ;  
			//get time.
			var hours = date_Obj.getHours();
			var minutes = date_Obj.getMinutes();
			var ampm = hours >= 12 ? 'PM' : 'AM';
			hours = hours % 12;
			hours = hours ? hours : 12; // the hour '0' should be '12'.
			minutes = minutes < 10 ? '0'+minutes : minutes;
			var strTime = newDate + hours + ':' + minutes + ' ' + ampm;           
			input.attr("value",strTime);
			input.attr('data-default-date',strTime);
			input.trigger('change');
			input.trigger('keyup');
			jQuery(document).trigger('smile-datepicker-change',[input , strTime] );

		});

				val = input.data('default-date');           
				if(val.length == 0 ){
					val = currenttime;
				}
				input.attr("value",val);

			});
		</script>

		<?php
		return ob_get_clean();
	}
}
