<?php
/*
Plugin Name: Liquid Events
Plugin URI: http://ave.liquid-themes.com/
Description: Liquid Events - Schedule Table
Version: 1.0.1
Author: LiquidThemes
Author URI: https://themeforest.net/user/liquidthemes
Text Domain: liquid-events
*/

if( !defined( 'ABSPATH' ) ) 
	exit; // Exit if accessed directly

class Liquid_Events {

	/**
	 * Hold an instance of Liquid_Events class.
	 * @var Liquid_Events
	 */
	protected static $instance = null;
	
	/**
	 * [$params description]
	 * @var array
	 */
	public $params = array();
	
	/**
	 * Main Liquid_Events instance.
	 *
	 * @return Liquid_Events - Main instance.
	 */
	public static function instance() {

		if(null == self::$instance) {
			self::$instance = new Liquid_Events();
		}

		return self::$instance;
	}

	/**
	 * [__construct description]
	 * @method __construct
	 */
	public function __construct() {

		add_action( 'init', array( $this, 'init_hooks' ) );
		add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );
		add_action( 'admin_notices', array( $this, 'activate_addons_notice' ) );
		
		add_action( 'admin_print_scripts-post.php', array( $this, 'enqueue' ), 99 );
		add_action( 'admin_print_scripts-post-new.php', array( $this, 'enqueue' ), 99 );
		
		add_action( 'wp_enqueue_scripts', array( $this, 'frontend_enqueue_css_js' ), 99 );

	}

	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain( 'liquid-events', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	/**
	 * [init_hooks description]
	 * @method init_hooks
	 * @return [type]     [description]
	 */
	/**
	 * [init_hooks description]
	 * @method init_hooks
	 *
	 * @return [type]     [description]
	 */
	public function init_hooks() {

		$this->assets_css = plugins_url( '/assets/css', __FILE__ );
		$this->assets_js  = plugins_url( '/assets/js', __FILE__ );

		if( class_exists( 'WPBakeryShortCode' ) ) {
			include_once $this->plugin_dir() . 'includes/shortcode.class.php';

			$this->load_shortcodes();
			
			global $vc_manager;
			$vc_manager->setIsAsTheme();
			$vc_manager->disableUpdater();
	
			$list = array( 'page', 'post', 'product' );
			$vc_manager->setEditorDefaultPostTypes( $list );
	
			//disable VC update notifications
			if( is_admin() ) {
	
				if ( ! isset( $_COOKIE['vchideactivationmsg'] ) ) {
					setcookie( 'vchideactivationmsg', '1', strtotime( '+3 years' ), '/' );
				}
	
				if ( ! isset( $_COOKIE[ 'vchideactivationmsg_vc11' ] ) ) {
					setcookie( 'vchideactivationmsg_vc11', ( defined( 'WPB_VC_VERSION' ) ? WPB_VC_VERSION : '1' ), strtotime( '+3 years' ), '/' );
				}
			}
			
		}	

	}
	
	/**
	 * Load vc scripts
	 */
	public function enqueue() {
		
		wp_enqueue_style( 'le-vc-style', $this->assets_css. '/vc-style.css' );
	}
	
	/**
	 * Load vc scripts
	 */
	public function frontend_enqueue_css_js() {
		
		wp_enqueue_style( 'le-schedule-table', $this->assets_css. '/liquid-events-table.min.css' );
		
		if(!wp_script_is( 'liquid-theme-vendors' ) ) {
			wp_enqueue_script( 'le-table-vendors-js',   $this->assets_js . '/liquidEventsTable-vendors.min.js' ,  array('jquery'), '1.0.0', true );	
		}
		wp_enqueue_script( 'le-table-js',   $this->assets_js . '/liquidEventsTable.min.js' ,  array( 'jquery' ), '1.0.0', true );
	}

	public function activate_addons_notice() {

		if( class_exists( 'WPBakeryShortCode' ) ) {
			return;
		}
	?>
		<div class="updated not-h2">
			<p><strong><?php esc_html_e( 'Please activate the WPBakery Page Builder to use the Liquid Events plugin.', 'liquid-events' ); ?></strong></p>
			<?php
				$screen = get_current_screen();
				if ( $screen->base != 'plugins' ):
			?>
				<p><a href="<?php echo esc_url( admin_url( 'plugins.php' ) ); ?>"><?php esc_html_e( 'Activate WPBakery Page Builder', 'liquid-events' ); ?></a></p>
			<?php endif; ?>
		</div>
	<?php
	}
	
	/**
	 * [load_shortcodes description]
	 * @method load_shortcodes
	 *
	 * @return [type]          [description]
	 */
	public function load_shortcodes() {

		//List of shortcodes in APLHABETICAL ORDER!!!!
		$shortcodes = array(
			'schedule-table',
			'schedule-table-cell'
		);

		// Order Shortcodes
		sort( $shortcodes );

		foreach( $shortcodes as $shortcode ) {

			$file = $this->plugin_dir(). "shortcodes/{$shortcode}/liquid-{$shortcode}.php";

			if ( file_exists( $file ) ) {
				require_once $file;
			}
		}
	}
	
	public function get_param( $id, $old ) {

		$id = sanitize_key( $id );

		if( ! isset( $this->params[$id] ) ) {
			_doing_it_wrong( 'get_param', wp_kses( sprintf( __( 'ID: <strong>%s</strong>, didn\'t exists in the system', 'liquid-events' ), $id ), array( 'strong' => array() ) ), null );
		}

		$new = array_merge( $this->params[$id], $old );
		unset( $new['id'] );

		return $new;
	}

	/**
	 * Plugin activation
	 */
	public static function activate() {
		flush_rewrite_rules();
	}

	/**
	 * Plugin deactivation
	 */
	public static function deactivate() {
		flush_rewrite_rules();
	}

	public function plugin_uri() {
		return plugin_dir_url( __FILE__ );
	}

	public function plugin_dir() {
		return plugin_dir_path( __FILE__ );
	}
	
}

/**
 * Main instance of Liquid_Events.
 *
 * Returns the main instance of Liquid_Events to prevent the need to use globals.
 *
 * @return Liquid_Events
 */
function liquid_events() {
	return Liquid_Events::instance();
}
liquid_events(); // init i

register_activation_hook( __FILE__, array( 'Liquid_Events', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'Liquid_Events', 'deactivate' ) );