<?php
/**
* Shortcode Schedule Table
*/

if( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly
	
/**
* LE_Shortcode
*/
class LE_Schedule_Table extends Liquid_Events_Shortcode {

	/**
	 * Construct
	 * @method __construct
	 */
	public function __construct() {

		// Properties
		$this->slug            = 'le_schedule_table';
		$this->title           = esc_html__( 'Schedule Table', 'liquid-events' );
		$this->description     = esc_html__( 'Add schedule table container', 'liquid-events' );
		$this->icon            = 'fa fa-calendar-plus-o';
		$this->content_element = true;
		$this->is_container    = true;
		$this->as_parent       = array( 'only' => 'le_schedule_table_cell' );

		parent::__construct();
	}

	public function get_params() {
		
		$this->params = array(
			
			array(
				'type'          => 'textfield',
				'param_name'	=> 'title',
				'heading'		=> esc_html__( 'Title', 'liquid-events' ),
				'admin_label'	=> true
			),
			array(
				'type'       => 'textarea',
				'param_name' => 'description',
				'heading'    => esc_html__( 'Description', 'liquid-events' ),
				'holder'     => 'div'
			),
			
			array(
				'type'             => 'colorpicker',
				'param_name'       => 'color',
				'heading'          => esc_html__( 'Title Color', 'one-core' ),
				'group'            => esc_html__( 'Design Options', 'one-core' ),
				'std'              => '#3ed2a7',
			),
			array(
				'type'             => 'colorpicker',
				'param_name'       => 'gr_color',
				'heading'          => esc_html__( 'Gradient Color', 'one-core' ),
				'description'      => esc_html__( 'Background gradient color, will create gradient effect', 'one-core' ),
				'group'            => esc_html__( 'Design Options', 'one-core' ),
				'std'              => '#4fda91',
				'edit_field_class' => 'vc_column-with-padding  vc_col-sm-6',
			),
			array(
				'type'        => 'colorpicker',
				'param_name'  => 'gr_color2',
				'heading'     => esc_html__( 'Gradient Color', 'one-core' ),
				'description' => esc_html__( 'Background gradient color, will create gradient effect', 'one-core' ),
				'group'       => esc_html__( 'Design Options', 'one-core' ),
				'std'              => '#34dbc5',
				'edit_field_class' => 'vc_col-sm-6',
			),

		);

		$this->add_extras();
	}
	
	public function before_output( $atts, &$content ) {

		global $le_cells;

		$le_cells = array();

		//parse ra_tab_section shortcode
		do_shortcode( $content );

		$atts['items'] =  $le_cells;

		return $atts;
	}
	
	protected function get_filter_cats( $id ) {
		
		$cells = array();
		foreach( $this->atts['items'] as $i => $cell ) {
			$cells[] = $cell['_category'];
		}
		$cells = array_unique( $cells );
		echo '<select class="liquid-schedule-filter" name="' . $id . '" id="' . $id . '">';
			echo '<option value="*">'. esc_html__( 'All Classes', 'liquid-events' ) . '</option>';
			foreach( $cells as $i => $cell ) {
				echo '<option value="' . esc_attr( sanitize_title( $cell ) ) . '">' . esc_html( $cell ) . '</option>';
			}
		echo '</select>';
		
	}

	protected function get_title() {

		// check
		if( empty( $this->atts['title'] ) ) {
			return '';
		}

		$title = sprintf( '<h2 class="font-weight-bold">%s</h2>', $this->atts['title'] );

		echo $title;
	}
	
	protected function get_description() {

		// check
		if( empty( $this->atts['description'] ) ) {
			return '';
		}

		$description = $this->atts['description'];

		printf( '<p>%s</p>', wp_kses_post( $description ) );
	}

	protected function generate_css() {

		$elements = array();
		extract( $this->atts );
		$id = '.' .$this->get_id();
		
		if( !empty( $color ) ) {
			$elements[ $this->liquid_implode( array( '%1$s .liquid-st-cell strong,%1$s .liquid-st-cell-details .btn' ) ) ]['color'] = $color;
		}
		
		if( !empty( $gr_color ) && !empty( $gr_color2 ) ) {
			$elements[ $this->liquid_implode( array( '%1$s .liquid-st-cell:before' ) ) ]['background'] = 'linear-gradient(to right, ' . $gr_color . ' 0%, ' . $gr_color2 . ' 100%)';
		}

		$this->dynamic_css_parser( $id, $elements );
	}

}
new LE_Schedule_Table;
class WPBakeryShortCode_LE_Schedule_Table extends WPBakeryShortCodesContainer {}