<?php 
/**
 * Facebook
 *
 * with help of the API this class delivers album images from Facebook
 *
 * @package    socialstreams
 * @subpackage socialstreams/facebook
 * @author     ThemePunch <info@themepunch.com>
 */
class TP_facebook {
	/**
	 * Get User ID from its URL
	 *
	 * @since    1.0.0
	 * @param    string    $user_url URL of the Page
	 */
	public function get_user_from_url($user_url){
		$theid = str_replace("https", "", $user_url);
		$theid = str_replace("http", "", $theid);
		$theid = str_replace("://", "", $theid);
		$theid = str_replace("www.", "", $theid);
		$theid = str_replace("facebook", "", $theid);
		$theid = str_replace(".com", "", $theid);
		$theid = str_replace("/", "", $theid);
		$theid = explode("?", $theid);
		return $theid[0];
	}
	/**
	 * Get Photosets List from User
	 *
	 * @since    1.0.0
	 * @param    string    $user_id 	Facebook User id (not name)
	 * @param    int       $item_count 	number of photos to pull
	 */
	public function get_photo_sets($user_id, $item_count = 10) {
	// build API URL
		$url = "https://graph.facebook.com/" . urlencode($user_id) . "/albums";
		$response = wp_remote_get( $url, array( 'timeout' => 15 ) );
		if ( is_wp_error( $response ) ) {
			return array();
		}
		$body = wp_remote_retrieve_body( $response );
		$photo_sets_list = json_decode( $body );
		return isset( $photo_sets_list->data ) ? $photo_sets_list->data : array();
	}
	/**
	 * Get Photoset Photos
	 *
	 * @since    1.0.0
	 * @param    string    $photo_set_id 	Photoset ID
	 * @param    int       $item_count 	number of photos to pull
	 */
	public function get_photo_set_photos($photo_set_id, $item_count = 10) {
	// Build API URL
		$url = "https://graph.facebook.com/v2.0/" . urlencode($photo_set_id) . "?fields=photos.limit(" . intval($item_count) . ")";
		$response = wp_remote_get( $url, array( 'timeout' => 15 ) );
		if ( is_wp_error( $response ) ) {
			return array();
		}
		$body = wp_remote_retrieve_body( $response );
		$photo_set_photos = json_decode( $body );
		return isset( $photo_set_photos->photos->data ) ? $photo_set_photos->photos->data : array();
	}
	/**
	 * Get Feed
	 *
	 * @since    1.0.0
	 * @param    string    $user 	User ID
	 * @param    int       $item_count 	number of itmes to pull
	 */
	public function get_post_feed($user, $app_id, $app_secret, $item_count = 10) {
	// Step 1: Get OAuth Access Token
		$oauth_url = add_query_arg(
			array(
				'type'          => 'client_cred',
				'client_id'     => $app_id,
				'client_secret' => $app_secret,
			),
			'https://graph.facebook.com/oauth/access_token'
		);
		$oauth_response = wp_remote_get( $oauth_url, array( 'timeout' => 15 ) );
		if ( is_wp_error( $oauth_response ) ) {
			return array();
		}
		$oauth_body = wp_remote_retrieve_body( $oauth_response );
		parse_str( $oauth_body, $oauth_data );
		if ( empty( $oauth_data['access_token'] ) ) {
			return array();
		}
	// Step 2: Build feed URL with access token
		$feed_url = add_query_arg(
			array(
				'access_token' => $oauth_data['access_token'],
				'fields'       => 'id,from,message,picture,link,name,icon,privacy,type,status_type,object_id,application,created_time,updated_time,is_hidden,is_expired,likes,comments',
				'limit'        => intval( $item_count ),
			),
			'https://graph.facebook.com/' . urlencode( $user ) . '/feed'
		);
		$feed_response = wp_remote_get( $feed_url, array( 'timeout' => 15 ) );
		if ( is_wp_error( $feed_response ) ) {
			return array();
		}
		$feed_body = wp_remote_retrieve_body( $feed_response );
		$feed      = json_decode( $feed_body );
		return isset( $feed->data ) ? $feed->data : array();
	}
	/**
	 * Decode URL from feed
	 *
	 * @since    1.0.0
	 * @param    string    $url 	facebook Output Data
	 */
	public static function decode_facebook_url($url) {
		$url = str_replace('u00253A',':',$url);
		$url = str_replace('\u00255C\u00252F','/',$url);
		$url = str_replace('u00252F','/',$url);
		$url = str_replace('u00253F','?',$url);
		$url = str_replace('u00253D','=',$url);
		$url = str_replace('u002526','&',$url);
		return $url;
	}
}
?>