<?php
$indusza_redux_demo = get_option('redux_demo');

//Custom fields:
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/framework/class-ocdi-importer.php';
//Theme Set up:
function indusza_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
    add_theme_support( 'custom-header' ); 
    add_theme_support( 'custom-background' );
    $lang = get_template_directory_uri() . '/languages';
    load_theme_textdomain('indusza', $lang);

    add_theme_support( 'post-thumbnails' );
  // Adds RSS feed links to <head> for posts and comments.
    add_theme_support( 'automatic-feed-links' );
  // Switches default core markup for search form, comment form, and comments
  // to output valid HTML5.
    add_theme_support( 'title-tag' );
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    // This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary' =>  esc_html__( 'Primary Menu: Chosen menu in all pages, blogs', 'indusza' ),
    ) );
    // This theme uses its own gallery styles.
}
add_action( 'after_setup_theme', 'indusza_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;

function indusza_fonts_url() {
    $font_url = '';

    if ( 'off' !== _x( 'on', 'Google font: on or off', 'indusza' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Teko:wght@300;400;500;600;700&display=swap|&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

function indusza_theme_scripts_styles() {
	$indusza_redux_demo = get_option('redux_demo');
	$protocol = is_ssl() ? 'https' : 'http';
    wp_enqueue_style('indusza-fonts', indusza_fonts_url(), array(), '1.0.0' );
    wp_enqueue_style('bootstrap1', get_template_directory_uri().'/assets/css/bootstrap.min.css');
    wp_enqueue_style('font-awesome', get_template_directory_uri().'/assets/css/font-awesome.min.css');
    wp_enqueue_style('owl-carousel', get_template_directory_uri().'/assets/css/owl.carousel.min.css');
    wp_enqueue_style('bootstrap-select', get_template_directory_uri().'/assets/css/bootstrap-select.min.css');
    wp_enqueue_style('magnific-popup', get_template_directory_uri().'/assets/css/magnific-popup.min.css');
    wp_enqueue_style('indusza-style', get_template_directory_uri().'/assets/css/style.css');
    wp_enqueue_style('flaticon', get_template_directory_uri().'/assets/css/flaticon.min.css');
    wp_enqueue_style('swiper-bundle', get_template_directory_uri().'/assets/css/swiper-bundle.min.css');
    wp_enqueue_style('themify-icons', get_template_directory_uri().'/assets/css/themify-icons.css');
    wp_enqueue_style('lc-lightbox', get_template_directory_uri().'/assets/css/lc_lightbox.css');
    wp_enqueue_style('indusza-settings', get_template_directory_uri().'/assets/plugins/revolution/revolution/css/settings.css');
    wp_enqueue_style('navigation', get_template_directory_uri().'/assets/plugins/revolution/revolution/css/navigation.css');
    wp_enqueue_style('indusza-css', get_stylesheet_uri(), array(), '2025-07-25' );
    if(isset($indusza_redux_demo['chosen-color']) && $indusza_redux_demo['chosen-color'] == 1){
        wp_enqueue_style( 'color', get_template_directory_uri().'/framework/color.php');
    }
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
    wp_enqueue_script( 'comment-reply' );
    wp_enqueue_script('jquery1', get_template_directory_uri().'/assets/js/jquery-3.5.1.min.js',array(),false,true);
    wp_enqueue_script('popper', get_template_directory_uri().'/assets/js/popper.min.js',array(),false,true);
    wp_enqueue_script('bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js',array(),false,true);
    wp_enqueue_script('bootstrap-select', get_template_directory_uri().'/assets/js/bootstrap-select.min.js',array(),false,true);
    wp_enqueue_script('magnific-popup', get_template_directory_uri().'/assets/js/magnific-popup.min.js',array(),false,true);
    wp_enqueue_script('waypoints', get_template_directory_uri().'/assets/js/waypoints.min.js',array(),false,true);
    wp_enqueue_script('counterup', get_template_directory_uri().'/assets/js/counterup.min.js',array(),false,true);
    wp_enqueue_script('swiper-bundle', get_template_directory_uri().'/assets/js/swiper-bundle.min.js',array(),false,true);
    wp_enqueue_script('waypoints-sticky', get_template_directory_uri().'/assets/js/waypoints-sticky.min.js',array(),false,true);
    wp_enqueue_script('isotope-pkgd', get_template_directory_uri().'/assets/js/isotope.pkgd.min.js',array(),false,true);
    wp_enqueue_script('owl-carousel', get_template_directory_uri().'/assets/js/owl.carousel.min.js',array(),false,true);
    wp_enqueue_script('theia-sticky-sidebar', get_template_directory_uri().'/assets/js/theia-sticky-sidebar.js',array(),false,true);
    wp_enqueue_script('jquery-bootstrap-touchspin', get_template_directory_uri().'/assets/js/jquery.bootstrap-touchspin.js',array(),false,true);
    wp_enqueue_script('map-script', get_template_directory_uri().'/assets/js/map.script.js',array(),false,true);
    wp_enqueue_script('indusza-custom', get_template_directory_uri().'/assets/js/custom.js',array(),false,true);
    wp_enqueue_script('lc-lightbox', get_template_directory_uri().'/assets/js/lc_lightbox.lite.js',array(),false,true);
    wp_enqueue_script('jquery-themepunch-tools', get_template_directory_uri().'/assets/plugins/revolution/revolution/js/jquery.themepunch.tools.min.js',array(),false,true);
    wp_enqueue_script('jquery-themepunch-revolution', get_template_directory_uri().'/assets/plugins/revolution/revolution/js/jquery.themepunch.revolution.min.js',array(),false,true);
    wp_enqueue_script('revolution-plugin', get_template_directory_uri().'/assets/plugins/revolution/revolution/js/extensions/revolution-plugin.js',array(),false,true);
    wp_enqueue_script('rev-script', get_template_directory_uri().'/assets/js/rev-script-1.js',array(),false,true);
    wp_enqueue_script('rev-script-2', get_template_directory_uri().'/assets/js/rev-script-2.js',array(),false,true);
}

add_action( 'wp_enqueue_scripts', 'indusza_theme_scripts_styles' );

function indusza_my_custom_wc_theme_support() {
  add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'indusza_my_custom_wc_theme_support' );

add_filter( 'loop_shop_columns', function() {
    return 2;
}, 20);

function indusza_custom_wc_ajax_refresh_cart_fragment( $fragments ) {
    ob_start();
    ?>
    <div class="menu-item mini-cart">
        <a href="<?php echo wc_get_cart_url(); ?>" class="cart-contents">
          <span class="cart-icon"></span>
      </a>
      <div class="mini-cart-dropdown">
        <?php woocommerce_mini_cart(); ?>
    </div>
</div>
<?php
$mini_cart = ob_get_clean();
$fragments['div.menu-item.mini-cart'] = $mini_cart;

unset( $fragments['a.cart-contents'] );

return $fragments;
}
add_filter( 'woocommerce_add_to_cart_fragments', 'indusza_custom_wc_ajax_refresh_cart_fragment', 30 );

function indusza_enqueue_wc_cart_fragments_script() {
    if ( function_exists( 'is_woocommerce' ) ) {
        wp_enqueue_script( 'wc-cart-fragments' );
    }
}
add_action( 'wp_enqueue_scripts', 'indusza_enqueue_wc_cart_fragments_script' );


add_filter( 'yith_wcwl_locate_template', 'indusza_custom_yith_wcwl_template_path', 10, 2 );

function indusza_custom_yith_wcwl_template_path( $located, $template_name ) {

    $custom_template = get_stylesheet_directory() . '/yith-woocommerce-wishlist/' . $template_name;

    if ( file_exists( $custom_template ) ) {
        return $custom_template;
    }

    return $located;
}

add_filter('woocommerce_add_to_cart_redirect', 'indusza_redirect_to_product_page_after_add_to_cart', 10, 1);

function indusza_redirect_to_product_page_after_add_to_cart($url) {
    if (
        isset($_POST['redirect_to_product']) 
        && $_POST['redirect_to_product'] === '1'
        && isset($_POST['add-to-cart'])
    ) {
        $product_id = absint($_POST['add-to-cart']);
        $product_url = get_permalink($product_id);
        return $product_url;
    }
    return $url;
}

function indusza_set_custom_woocommerce_pages() {
    if ( class_exists( 'WooCommerce' ) ) {

        $shop_page = get_posts( array(
            'post_type'   => 'page',
            'title'       => 'Shop Sidebar',
            'posts_per_page' => 1
        ) );
        if ( $shop_page ) {
            update_option( 'woocommerce_shop_page_id', $shop_page[0]->ID );
        }

        $cart_page = get_posts( array(
            'post_type'   => 'page',
            'title'       => 'Cart Page',
            'posts_per_page' => 1
        ) );
        if ( $cart_page ) {
            update_option( 'woocommerce_cart_page_id', $cart_page[0]->ID );
        }

        $checkout_page = get_posts( array(
            'post_type'   => 'page',
            'title'       => 'Checkout Page',
            'posts_per_page' => 1
        ) );
        if ( $checkout_page ) {
            update_option( 'woocommerce_checkout_page_id', $checkout_page[0]->ID );
        }

        $myaccount_page = get_posts( array(
            'post_type'   => 'page',
            'title'       => 'My Account Page',
            'posts_per_page' => 1
        ) );
        if ( $myaccount_page ) {
            update_option( 'woocommerce_myaccount_page_id', $myaccount_page[0]->ID );
        }
    }
}
add_action( 'after_setup_theme', 'indusza_set_custom_woocommerce_pages' );

add_action( 'ocdi/after_import', 'my_ocdi_after_import_elementor', 20 );
function my_ocdi_after_import_elementor( $selected_import = null ) {
    if ( ! did_action( 'elementor/loaded' ) ) {
        return;
    }

    if ( method_exists( '\Elementor\Plugin', 'instance' ) && isset( \Elementor\Plugin::instance()->files_manager ) ) {
        try {
            \Elementor\Plugin::instance()->files_manager->clear_cache();
        } catch ( \Exception $e ) {

        }
    }

    $args = [
        'post_type'      => [ 'page', 'post' ],
        'posts_per_page' => -1,
        'meta_query'     => [
            [
                'key'     => '_elementor_data',
                'compare' => 'EXISTS',
            ],
        ],
        'fields' => 'ids',
    ];
    $posts = get_posts( $args );

    if ( ! empty( $posts ) && method_exists( '\Elementor\Plugin', 'instance' ) && isset( \Elementor\Plugin::instance()->documents ) ) {
        foreach ( $posts as $post_id ) {
            try {
                $doc = \Elementor\Plugin::instance()->documents->get( $post_id );
                if ( $doc && method_exists( $doc, 'save' ) ) {
                    $doc->save( [] );
                }
            } catch ( \Exception $e ) {
            }
        }
    }
}

function indusza_do_shortcode($content) {
    global $shortcode_tags;
    if (empty($shortcode_tags) || !is_array($shortcode_tags))
        return $content;
    $pattern = get_shortcode_regex();
    return preg_replace_callback( "/$pattern/s", 'do_shortcode_tag', $content );
}

function indusza_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}
add_filter( 'comment_form_fields', 'indusza_move_comment_field_to_bottom');

// Widget Sidebar
function indusza_widgets_init() {
	register_sidebar( array(
        'name'          => esc_html__( 'Primary Sidebar', 'indusza' ),
        'id'            => 'sidebar-1',        
        'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'indusza' ),        
        'before_widget' => '<div id="%1$s" class="single-widget mb-30 %2$s">',        
        'after_widget'  => '</div>',        
        'before_title'  => '<h3 class="widget-title">',        
        'after_title'   => '</h3>'
    ) );
	register_sidebar( array(
      'name'          => esc_html__( 'Shop Sidebar', 'indusza' ),
      'id'            => 'sidebar-shop',
      'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'indusza' ),
      'before_widget' => '<div id="%1$s" class="shop-widget widget  %2$s">',
      'after_widget'  => '</div>',
      'before_title'  => '<div class="widget_products"><h3 class="widget-title">',
      'after_title'   => '</h3></div>',
  ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Project Sidebar', 'indusza' ),
    'id'            => 'sidebar-2',        
    'description'   => esc_html__( 'Appears in the sidebar section of the project.', 'indusza' ),        
    'before_widget' => '<div id="%1$s" class="single-widget mb-30 %2$s">',        
    'after_widget'  => '</div>',        
    'before_title'  => '<h3 class="widget-title">',        
    'after_title'   => '</h3>'
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Services Sidebar', 'indusza' ),
    'id'            => 'sidebar-3',        
    'description'   => esc_html__( 'Appears in the sidebar section of the services.', 'indusza' ),        
    'before_widget' => '<div id="%1$s" class="single-widget mb-30 %2$s">',        
    'after_widget'  => '</div>',        
    'before_title'  => '<h3 class="widget-title">',        
    'after_title'   => '</h3>'
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget One', 'indusza' ),
    'id'            => 'footer-area-1',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'indusza' ),
    'before_widget' => '<div >',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>',
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget Two', 'indusza' ),
    'id'            => 'footer-area-2',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'indusza' ),
    'before_widget' => '<div >',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>',
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget Three', 'indusza' ),
    'id'            => 'footer-area-3',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'indusza' ),
    'before_widget' => '<div >',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>',
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget Four', 'indusza' ),
    'id'            => 'footer-area-4',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'indusza' ),
    'before_widget' => '<div >',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>',
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget Five', 'indusza' ),
    'id'            => 'footer-area-5',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'indusza' ),
    'before_widget' => '<div >',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>',
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget Six', 'indusza' ),
    'id'            => 'footer-area-6',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'indusza' ),
    'before_widget' => '<div >',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>',
) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget Seven', 'indusza' ),
    'id'            => 'footer-area-7',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'indusza' ),
    'before_widget' => '<div >',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>',
) );
}
add_action( 'widgets_init', 'indusza_widgets_init' );

//function tag widgets
function indusza_tag_cloud_widget($args) {
	$args['number'] = 0; //adding a 0 will display all tags
	$args['largest'] = 18; //largest tag
	$args['smallest'] = 11; //smallest tag
	$args['unit'] = 'px'; //tag font unit
	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
	$args['exclude'] = array(20, 80, 92); //exclude tags by ID
	return $args;
}
add_filter( 'widget_tag_cloud_args', 'indusza_tag_cloud_widget' );


function indusza_excerpt() {
  $indusza_redux_demo = get_option('redux_demo');
  if(isset($indusza_redux_demo['blog_excerpt'])){
    $limit = $indusza_redux_demo['blog_excerpt'];
}else{
    $limit = 80;
}
$excerpt = explode(' ', get_the_excerpt(), $limit);
if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
} else {
    $excerpt = implode(" ",$excerpt);
}
$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
return $excerpt;
}

function indusza_excerpt_2() {
  $indusza_redux_demo = get_option('redux_demo');
  if(isset($indusza_redux_demo['blog_excerpt_2'])){
    $limit = $indusza_redux_demo['blog_excerpt_2'];
}else{
    $limit = 30;
}
$excerpt = explode(' ', get_the_excerpt(), $limit);
if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
} else {
    $excerpt = implode(" ",$excerpt);
}
$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
return $excerpt;
}

//pagination
function indusza_pagination($pages='') {
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
        $pages = $wp_query->max_num_pages;
        if(!$pages)
        {
           $pages = 1;
       }
   }
   $pagination = array(
    'base'      => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
    'format'    => '',
    'current'     => max( 1, get_query_var('paged') ),
    'total'     => $pages,
    'prev_text' => wp_specialchars_decode('<i class="fa fa-angle-double-left"></i>'),
    'next_text' => wp_specialchars_decode('<i class="fa fa-angle-double-right"></i>'),   
    'type'      => 'list',
    'end_size'    => 3,
    'mid_size'    => 3
);
   $return =  paginate_links( $pagination );
   echo str_replace( "<ul class='page-numbers'>", '<ul class="clearfix">', $return );
}

function indusza_search_form( $form ) {
    $form = '
    <form action="' . esc_url(home_url('/')) . '" id="searchform-all" method="get">
    <div class="input-group">
    <input type="search" class="form-control" placeholder="'.esc_attr__('Search...', 'indusza').'" name="s">
    <span class="input-group-btn">
    <button type="submit" class="btn"><i class="fa fa-search"></i></button>
    </span>
    </div>
    </form>
    ';
    return $form;
}
add_filter( 'get_search_form', 'indusza_search_form' );
//Custom comment List:

// Comment Form
function indusza_theme_comment($comment, $args, $depth) {
    //echo 's';
 $GLOBALS['comment'] = $comment; ?>

 <li class="comment">
  <!-- COMMENT BLOCK -->
  <div class="comment-body">
    <div class="comment-author">
      <?php echo get_avatar($comment,$size='100' ); ?>
      <cite class="fn"><?php printf( get_comment_author_link()) ?></cite>
      <div class="reply">
        <?php comment_reply_link(array_merge( $args, array('reply_text' => __('Reply', 'indusza'),'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
    </div>
</div>                                                
<div class="comment-meta">
  <a href="javascript:void(0);"><?php comment_time('F j, Y'); ?></a>
</div>
<?php comment_text() ?>
</div>
</li>  
<?php
}

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'indusza_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */


function indusza_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
      array(
        'name'      => esc_html__( 'One Click Demo Import', 'indusza' ),
        'slug'      => 'one-click-demo-import',
        'required'  => true,
      ), 
      array(
        'name'      => esc_html__( 'Classic Editor', 'indusza' ),
        'slug'      => 'classic-editor',
        'required'  => true,
      ), 
      array(
        'name'      => esc_html__( 'Classic Widgets', 'indusza' ),
        'slug'      => 'classic-widgets',
        'required'  => true,
      ),
      array(
        'name'      => esc_html__( 'Widget Importer & Exporter', 'indusza' ),
        'slug'      => 'widget-importer-&-exporter',
        'required'  => true,
      ), 
      array(
        'name'      => esc_html__( 'Contact Form 7', 'indusza' ),
        'slug'      => 'contact-form-7',
        'required'  => true,
      ), 
      array(
        'name'      => esc_html__( 'WP Maximum Execution Time Exceeded', 'indusza' ),
        'slug'      => 'wp-maximum-execution-time-exceeded',
        'required'  => true,
      ), 
      array(
        'name'      => esc_html__( 'Elementor', 'indusza' ),
        'slug'      => 'elementor',
        'required'  => true,
      ),
      array(
        'name'      => esc_html__( 'WooCommerce', 'indusza' ),
        'slug'      => 'woocommerce',
        'required'  => true,
      ),
      array(
        'name'      => esc_html__( 'YITH WooCommerce Wishlist', 'indusza' ),
        'slug'      => 'yith-woocommerce-wishlist',
        'required'  => true,
      ),
      array(
        'name'      => esc_html__( 'Custom Product Tabs for WooCommerce', 'indusza' ),
        'slug'      => 'yikes-inc-easy-custom-woocommerce-product-tabs',
        'required'  => true,
      ),
      array(
        'name'      => esc_html__( 'Indusza Common', 'indusza' ),
        'slug'      => 'indusza-common',
        'required'  => true,
        'source'    => get_template_directory() . '/framework/plugins/indusza-common.zip',
      ),
      array(
        'name'      => esc_html__( 'Indusza Elementor', 'indusza' ),
        'slug'      => 'indusza-elementor',
        'required'  => true,
        'source'    => get_template_directory() . '/framework/plugins/indusza-elementor.zip',
      ),
  );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'indusza' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'indusza' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'indusza' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'indusza' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'indusza' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'indusza' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'indusza' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'indusza' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'indusza' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'indusza' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'indusza' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'indusza' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'indusza' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'indusza' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'indusza' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'indusza' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'indusza' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
tgmpa( $plugins, $config );
}

?>