<?php
/**
 * The Template for displaying all single posts
 */
$indusza_redux_demo = get_option('redux_demo');
get_header(); ?>
<?php 
while (have_posts()): the_post();
    $team_position = get_post_meta(get_the_ID(),'_cmb_team_position', true);
    ?>
    <?php if(isset($indusza_redux_demo['blog_image']['url']) && $indusza_redux_demo['blog_image']['url'] != ''){?>
        <div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo esc_url($indusza_redux_demo['blog_image']['url']);?>);">
        <?php }else{?> 
            <div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/banner/1.jpg);">
            <?php } ?>
            <div class="overlay-main site-bg-black opacity-06"></div>
            <div class="container">
                <div class="wt-bnr-inr-entry">
                    <div class="banner-title-outer">
                        <div class="banner-title-name">
                            <h2 class="wt-title"><?php if(isset($indusza_redux_demo['team_details_title']) && $indusza_redux_demo['team_details_title'] != ''){?>
                                <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['team_details_title']));?>
                            <?php }else{?>
                                <?php echo esc_html__( 'Team Detail', 'indusza' );
                            }
                        ?></h2>
                    </div>
                </div>
                <!-- BREADCRUMB ROW -->                            
                <div>
                    <ul class="wt-breadcrumb breadcrumb-style-2">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'indusza' )?></a></li>
                        <li><?php if(isset($indusza_redux_demo['team_details_title']) && $indusza_redux_demo['team_details_title'] != ''){?>
                            <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['team_details_title']));?>
                        <?php }else{?>
                            <?php echo esc_html__( 'Team Detail', 'indusza' );
                        }
                    ?></li>
                </ul>
            </div>
            <!-- BREADCRUMB ROW END -->                        
        </div>
    </div>
</div>
<!-- INNER PAGE BANNER END -->
<!-- OUR TEAM START -->
<div class="section-full p-t120 p-b90  site-bg-white">
    <div class="container">
        <div class="section-content team_details_area">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-6 m-b30">
                    <?php if (has_post_thumbnail()) { ?> 
                        <div class="wt-team-1">
                            <div class="wt-media">
                                <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="<?php the_title_attribute(); ?>">
                            </div> 
                        </div>
                    <?php } ?>
                </div>
                <div class="col-lg-6 offset-lg-1 col-md-6 m-b30 team-box-single site-bg-gray-light">
                    <div class="team-detail">
                        <span class="team-position"><?php echo esc_html($team_position); ?></span>                                        
                        <h4 class="m-t0 team-name"><a href="javascript:;"><?php the_title();?></a></h4>
                        <?php the_content(); ?>
                        <?php wp_link_pages( array(
                            'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'indusza' ),
                            'after'       => '</div>',
                            'link_before' => '<p class="page-number">',
                            'link_after'  => '</p>',
                        ) ); ?>                                          
                    </div>
                </div>
            </div>
        </div>      
    </div>
</div>   
<!-- OUR TEAM SECTION END -->
<!-- BUILD FUTURE END -->         
<?php endwhile; ?>
<?php
get_footer();
?>