<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit; ?>

<?php $indusza_redux_demo = get_option('redux_demo'); ?>

<?php if(isset($indusza_redux_demo['shop_banner']['url']) && $indusza_redux_demo['shop_banner']['url'] != ''){?>
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo esc_url($indusza_redux_demo['shop_banner']['url']);?>);">
<?php }else{?> 
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo (get_template_directory_uri().'/assets/images/banner/1.jpg');?>);">
<?php } ?>
    <div class="overlay-main site-bg-black opacity-06"></div>
    <div class="container">
        <div class="wt-bnr-inr-entry">
            <div class="banner-title-outer">
                <div class="banner-title-name">
                    <h2 class="wt-title"><?php if(isset($indusza_redux_demo['cart_title']) && $indusza_redux_demo['cart_title'] != ''){?>
                        <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['cart_title']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'Shop Cart', 'indusza' );
                    }
                ?></h2>
                </div>
            </div>
            <!-- BREADCRUMB ROW -->  
            <div>
                <ul class="wt-breadcrumb breadcrumb-style-2">
                    <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($indusza_redux_demo['home'])){?>
                        <?php echo esc_attr($indusza_redux_demo['home']);?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Home', 'indusza' );}?></a></li>
                    <li><?php if(isset($indusza_redux_demo['cart_title']) && $indusza_redux_demo['cart_title'] != ''){?>
                        <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['cart_title']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'Shop Cart', 'indusza' );
                    }
                ?></li>
                </ul>
            </div>
            <!-- BREADCRUMB ROW END -->                        
        </div>
    </div>
</div>

<section class="cart section-padding">
    <div class="container">
        <?php

/*
 * @hooked wc_empty_cart_message - 10
 */
do_action( 'woocommerce_cart_is_empty' ); ?>

<?php if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
	<p class="return-to-shop">
		<a class="button wc-backward<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php
				/**
				 * Filter "Return To Shop" text.
				 *
				 * @since 4.6.0
				 * @param string $default_text Default text.
				 */
				echo esc_html( apply_filters( 'woocommerce_return_to_shop_text', __( 'Return to shop', 'indusza' ) ) );
             ?>
         </a>
     </p>
     <?php endif; ?>
    </div>
</section>