<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined( 'ABSPATH' ) || exit;
?>
<?php $indusza_redux_demo = get_option('redux_demo'); ?>

<?php if(isset($indusza_redux_demo['shop_banner']['url']) && $indusza_redux_demo['shop_banner']['url'] != ''){?>
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo esc_url($indusza_redux_demo['shop_banner']['url']);?>);">
<?php }else{?> 
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo (get_template_directory_uri().'/assets/images/banner/1.jpg');?>);">
<?php } ?>
    <div class="overlay-main site-bg-black opacity-06"></div>
    <div class="container">
        <div class="wt-bnr-inr-entry">
            <div class="banner-title-outer">
                <div class="banner-title-name">
                    <h2 class="wt-title"><?php echo esc_html__( 'Lost Your Password', 'indusza' );?></h2>
                </div>
            </div>
            <!-- BREADCRUMB ROW -->  
            <div>
                <ul class="wt-breadcrumb breadcrumb-style-2">
                    <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($indusza_redux_demo['home'])){?>
                        <?php echo esc_attr($indusza_redux_demo['home']);?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Home', 'indusza' );}?></a></li>
                    <li><?php echo esc_html__( 'Lost Your Password', 'indusza' );?></li>
                </ul>
            </div>
            <!-- BREADCRUMB ROW END -->                        
        </div>
    </div>
</div>

<div class="password-area pt-100 pb-100">
  <!-- Product -->
  <div class="container">
     <div class="row">
        <?php do_action( 'woocommerce_before_lost_password_form' );
        ?>

        <form method="post" class="woocommerce-ResetPassword lost_reset_password">

           <p><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'indusza' ) ); ?></p><?php // @codingStandardsIgnoreLine ?>

           <p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
              <label for="user_login"><?php esc_html_e( 'Username or email', 'indusza' ); ?>&nbsp;<span class="required" aria-hidden="true">*</span><span class="screen-reader-text"><?php esc_html_e( 'Required', 'indusza' ); ?></span></label>
              <input class="woocommerce-Input woocommerce-Input--text input-text" type="text" name="user_login" id="user_login" autocomplete="username" required aria-required="true" />
          </p>

          <div class="clear"></div>

          <?php do_action( 'woocommerce_lostpassword_form' ); ?>

          <p class="woocommerce-form-row form-row">
              <input type="hidden" name="wc_reset_password" value="true" />
              <button type="submit" class="woocommerce-Button button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" value="<?php esc_attr_e( 'Reset password', 'indusza' ); ?>"><?php esc_html_e( 'Reset password', 'indusza' ); ?></button>
          </p>

          <?php wp_nonce_field( 'lost_password', 'woocommerce-lost-password-nonce' ); ?>

      </form>
      <?php
      do_action( 'woocommerce_after_lost_password_form' );?>
  </div>
</div>
</div>