<?php
/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;
$indusza_redux_demo = get_option('redux_demo');
?>

<?php if(isset($indusza_redux_demo['shop_banner']['url']) && $indusza_redux_demo['shop_banner']['url'] != ''){?>
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo esc_url($indusza_redux_demo['shop_banner']['url']);?>);">
<?php }else{?> 
<div class="wt-bnr-inr overlay-wraper bg-center" style="background-image:url(<?php echo (get_template_directory_uri().'/assets/images/banner/1.jpg');?>);">
<?php } ?>
    <div class="overlay-main site-bg-black opacity-06"></div>
    <div class="container">
        <div class="wt-bnr-inr-entry">
            <div class="banner-title-outer">
                <div class="banner-title-name">
                    <h2 class="wt-title"><?php if(isset($indusza_redux_demo['account_title']) && $indusza_redux_demo['account_title'] != ''){?>
                        <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['account_title']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'My Account', 'indusza' );
                    }
                ?></h2>
                </div>
            </div>
            <!-- BREADCRUMB ROW -->  
            <div>
                <ul class="wt-breadcrumb breadcrumb-style-2">
                    <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($indusza_redux_demo['home'])){?>
                        <?php echo esc_attr($indusza_redux_demo['home']);?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Home', 'indusza' );}?></a></li>
                    <li><?php if(isset($indusza_redux_demo['account_title']) && $indusza_redux_demo['account_title'] != ''){?>
                        <?php echo wp_specialchars_decode(esc_attr($indusza_redux_demo['account_title']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'My Account', 'indusza' );
                    }
                ?></li>
                </ul>
            </div>
            <!-- BREADCRUMB ROW END -->                        
        </div>
    </div>
</div>

<div class="account-area">
	<div class="container">
		<div class="row">
			<?php
			/**
			 * My Account navigation.
			 *
			 * @since 2.6.0
			 */
			do_action( 'woocommerce_account_navigation' ); ?>

			<div class="woocommerce-MyAccount-content">
				<?php
				/**
				 * My Account content.
				 *
				 * @since 2.6.0
				 */
				do_action( 'woocommerce_account_content' );
				?>
			</div>
		</div>
	</div>
</div>